import os, unittest, linda, tempfile, shutil
from linda import clparser
from linda.funcs import run_external_cmd
from linda.parser.clparser import CLParser
from linda.parser.config import ConfigFileParser, ConfigFileParserException

class ConfigFileParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_config.tar.gz' % \
            self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_fine(self):
        "Check a correct config file"
        clparser['config'] = os.path.join(self.dir, 'correct')
        ConfigFileParser()
        self.assertEqual(clparser['debug'], 3)
        clparser['debug'] = 0
        self.assertEqual(clparser['more-overrides'], \
            '/var/lib/dpkg/info/libc6.postinst')

    def test_empty(self):
        "Check that an empty arg raises an ConfigFileParserException"
        clparser['config'] = os.path.join(self.dir, 'empty')
        try:
            ConfigFileParser()
        except ConfigFileParserException:
            pass
        else:
            self.fail()

    def test_req_arg(self):
        "Check that a missing req arg raises an ConfigFileParserException"
        clparser['config'] = os.path.join(self.dir, 'reqarg')
        try:
            ConfigFileParser()
        except ConfigFileParserException:
            pass
        else:
            self.fail()

    def test_unknown(self):
        "Check an unknown line raises an ConfigFileParserException"
        clparser['config'] = os.path.join(self.dir, 'unknown')
        try:
            ConfigFileParser()
        except ConfigFileParserException:
            pass
        else:
            self.fail()

