import os, linda, gettext
from linda import clparser
from linda.debug import dprint, vprint
from linda.err_print import PrintErrors, ErrorPrintingException
from linda.libchecks import CheckRunningException
from linda.overrides import Overrides
from linda.unpack import Unpacker, UnpackException
from linda.parser.data import DataFileParser
_ = gettext.gettext

class Checker:
    def __init__(self):
        self.mapping = {'deb': 'binary', 'dsc': 'source', 'changes': 'changes'}
        self.data_files = {}
        
    def check(self, file):
        self.file = file
        self.processing_print()
        self.err_printer = PrintErrors(file)
        if os.path.splitext(self.file)[1] == '.changes':
            self.unpacker = ChangesUnpacker()
            self.overrides = ChangesOverrides()
            self.run_checks(1)
        else:
            self.unpacker = Unpacker()
            self.overrides = Overrides(file, self.unpacker.lab)
            self.go()
        
    def go(self):
        self.unpack(1)
        self.overrides.parse()
        self.run_checks(1)
        if linda.checks.registry[self.mapping[self.file[-3:]]][2]:
            if not clparser['unpack'] or clparser['unpack'] == 2:
                self.unpack(2)
            self.run_checks(2)
        self.cull_lab()

    def unpack(self, level):
        try:
            self.unpacker.unpack(self.file, level)
        except UnpackException, e:
            raise CheckerException('Level %d unpacking failed: %s' % \
                (level, e))

    def cull_lab(self):
        self.unpacker.cull_lab()

    def run_checks(self, level):
        if not clparser['unpack']:
            try:
                errs = linda.checks.apply(self.unpacker.lab, self.file, \
                    self.unpacker.information, level)
            except CheckRunningException, e:
                raise CheckerException(e)
            for err in errs.keys():
                if not self.data_files.has_key(err):
                    self.data_files[err] = DataFileParser(err)
            if not clparser['show-overridden']:
                errs, data_files = self.overrides.check(errs, self.data_files)
            try:
                self.err_printer.print_error(errs, self.data_files)
            except ErrorPrintingException, e:
                raise CheckerException(e)
                
    def processing_print(self):
        vprint(_("Processing file: %s") % os.path.split(self.file)[1], 1)
        dprint(_("Processing file: %s") % os.path.split(self.file)[1])

class CheckerException(Exception):
    pass

class ChangesUnpacker:
    def __init__(self):
        self.lab = ''
        self.information = ''

class ChangesOverrides:
    def check(self, errs, data_files):
        return [{}, {}]

