from linda import libchecks, checks
from linda.funcs import iterate_dir

class ConfigFileCheck(libchecks.LindaChecker):
    'Checks relating to the conffiles file.'
    def init(self):
        self.conf_files = {}
    
    def check_binary_2(self):
        self.conffiles()

    def conffiles(self):
        try:
            f = open(os.path.join(self.information['dir'], 'control', \
                'conffiles'))
        except IOError:
            f = 0
        if f:
            for file in f:
                self.conf_files[file[:-1]] = os.path.split(file[:-1])
        for file in self.conf_files.keys():
            if file.find('/etc') == -1:
                self.signal_error('non-etc-conffile', [self.conf_files[file]])
            if not file.startswith('/'):
                self.signal_error('relative-conffile', [self.conf_files[file]])
        pkg_conf_files = map(lambda x: x[len('%s/unpacked' % \
            self.information['dir']):], \
            iterate_dir(os.path.join(self.information['dir'], 'unpacked', \
            'etc')))
        for file in pkg_conf_files:
            if file not in self.conf_files.keys() and not \
                os.path.islink(os.path.join(self.information['dir'], \
                'unpacked', file[1:])):
                (path, name) = os.path.split(file)
                self.signal_error('etc-conffile', [name, path])

checks.register(ConfigFileCheck)

