import unittest, gettext, os, linda, shutil, tempfile
from po_count import POFileParser
from linda.debug import dprint
from linda.collector import Collector
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class PerlCheckBinaryTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/perl.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['binary'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.po_keys = POFileParser('po/en.po')
        
    def test_parse_package(self):
        "Check parse_package() method of PerlCheck"
        method = getattr(self.instance, 'parse_package')
        self.instance.information['control'] = {'self': [{}]}
        method()
        self.assertEqual(self.instance.info['arch'], 'none')
        self.assertEqual(self.instance.info['src-pkg'], 'test')
        self.assertEqual(self.instance.info['module-pkg'], 0)
        self.instance.information['control'] = {'self': [{'architecture': \
            'hppa', 'source': 'libpoe-perl'}]}
        method()
        self.assertEqual(self.instance.info['arch'], 'hppa')
        self.assertEqual(self.instance.info['src-pkg'], 'libpoe-perl')
        self.assertEqual(self.instance.info['module-pkg'], 1)
        
    def test_parse_files(self):
        "Check parse_files() method of PerlCheck"
        method = getattr(self.instance, 'parse_files')
        self.instance.information['collector'] = Collector('bin', '/tmp', '')
        self.instance.information['collector'].set('files', 'files', \
            {'/usr/share/perl5/lala': ''})
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.information['collector'].set('files', 'files', \
            {'/usr/share/perl/lala': ''})
        method()
        self.assert_('pkg-installs-into-perl-dir' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'pkg-installs-into-perl-dir'), True)
        self.instance.information['collector'].set('files', 'files', \
            {'/usr/lib/perl5/foobar': ''})
        self.instance.info['arch'] = 'all'
        method()
        self.assert_('arch-indep-should-be-u-s-p' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'arch-indep-should-be-u-s-p'), True)
        self.instance.information['collector'].set('files', 'files', \
            {'/usr/share/perl5/foobar': ''})
        self.instance.info['arch'] = 'all'
        method()
        self.assertEqual(self.instance.info['right']['arch-indep'], 1)
        self.instance.information['collector'].set('files', 'files', \
            {'/usr/lib/perl5/foobar': ''})
        self.instance.info['arch'] = 'ppc'
        method()
        self.assertEqual(self.instance.info['right']['arch-dep'], 1)

    def test_control_checks(self):
        "Check control_checks() method of PerlCheck"
        method = getattr(self.instance, 'control_checks')
        self.instance.info['module-pkg'] = 1
        self.instance.info['right']['arch-indep'] = 0
        self.instance.information['control'] = {'self': [{}]}
        method()
        self.assert_('module-pkg-no-perl-dep' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'module-pkg-no-perl-dep'), True)
        self.instance.err_dict.clear()
        self.instance.info['right']['arch-indep'] = 1
        self.instance.information['control'] = {'self': [{'depends': \
            {'perl': {'relation': [['>=', '5.6.0-16']], 'arch': []}}}]}
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.information['control'] = {'self': [{'depends': \
            {'perl': {'relation': [[None, None]], 'arch': [None]}}}]}
        method()
        self.assert_('unversioned-dep-on-perl' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'unversioned-dep-on-perl'), True)
        self.instance.information['control'] = {'self': [{'depends': \
            {'perl': {'relation': [['>=', '5.6.0-1']], 'arch': []}}}]}
        method()
        self.assert_('perl-dep-not-great-enough' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'perl-dep-not-great-enough'), True)
        
