import unittest, gettext, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class DebhelperCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/debhelper.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        os.mkdir('%s/debian' % self.instance.information['dir'])
        run_external_cmd('tar zxCf %s tests/source_debhelper.tar.gz' % \
            self.instance.information['dir'])
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])
        
    def test_depends(self):
        "Check dh_commands() method of DebhelperCheck"
        method = getattr(self.instance, 'dh_commands')
        shutil.copy('%s/rules.nonbinary' % self.instance.information['dir'], \
            '%s/debian/rules' % self.instance.information['dir'])
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        shutil.copy('%s/rules.compat2' % self.instance.information['dir'], \
            '%s/debian/rules' % self.instance.information['dir']) 
        method()
        self.assert_('uses-dh-testversion' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'uses-dh-testversion'), True)
        method = getattr(self.instance, 'build_deps_and_deps')
        self.instance.information['control'] = {'self': [{}]}
        method()
        self.assert_('missing-build-dep-on-dh' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'missing-build-dep-on-dh'), True)
        self.instance.information['control']['self'][0]['build-depends'] = \
            {'debhelper': {'arch': None, 'relation': [[None, None]]}}
        method()
        self.assert_('dh-compat-greater-than-depends' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'dh-compat-greater-than-depends'), True)
        self.instance.err_dict.clear()
        self.instance.information['control']['self'][0]['build-depends'] = \
            {'debhelper': {'arch': None, 'relation': [['>>', '1.0.0']]}}
        method()
        self.assert_('dh-compat-greater-than-depends' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'dh-compat-greater-than-depends'), True)
        self.instance.err_dict.clear()
        self.instance.information['control']['self'][0] = \
            {'build-depends-indep': {'python-dev': {'arch': None, 'relation': \
            [[None, None]]}, 'debhelper': {'arch': None, 'relation': \
            [['>>', '4']]}}}
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        del self.instance.information['control']['self'][0]['build-depends-indep']['python-dev']
        method()
        self.assert_('no-build-dep-python-dev' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-build-dep-python-dev'), True)
        
    def test_maint_checks(self):
        "Check check_maint_scripts() method of DebhelperCheck"
        shutil.copy('%s/rules.compat2' % self.instance.information['dir'], \
            '%s/debian/rules' % self.instance.information['dir']) 
        shutil.move('%s/postinst.compat2' % self.instance.information['dir'], \
            '%s/debian/postinst' % self.instance.information['dir'])
        method = getattr(self.instance, 'check_maint_scripts')
        method()
        self.assert_('maint-uses-dh-no-tag' not in \
            self.instance.err_dict.keys())
        shutil.move('%s/prerm.compat2' % self.instance.information['dir'], \
            '%s/debian/prerm' % self.instance.information['dir'])
        getattr(self.instance, 'init')()
        getattr(self.instance, 'dh_commands')()
        method()
        self.assert_('maint-uses-dh-no-tag' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'maint-uses-dh-no-tag'), True)
        for file in ('debian/postinst', 'debian/prerm'):
            os.remove('%s/%s' % (self.instance.information['dir'], file))

    def test_build_deps(self):
        "Check build_deps_and_deps() method of DebhelperCheck"
        shutil.copy('%s/rules.cdbs' % self.instance.information['dir'], \
            '%s/debian/rules' % self.instance.information['dir'])
        getattr(self.instance, 'init')()
        getattr(self.instance, 'dh_commands')()
        self.instance.information['control'] = {'self': [{'build-depends': \
            {'cdbs': {'arch': None, 'relation': [None, None]}, 'debhelper': \
            {'arch': None, 'relation': [['>=', '2.0']]}}}]}
        method = getattr(self.instance, 'build_deps_and_deps')
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.information['control'] = {'self': [{'build-depends': \
            {'debhelper': {'arch': '', 'relation': [['>>', '1.0.0']]}}}]}
        method = getattr(self.instance, 'build_deps_and_deps')
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        shutil.copy('%s/rules.nondh' % self.instance.information['dir'], \
            '%s/debian/rules' % self.instance.information['dir'])
        getattr(self.instance, 'init')()
        getattr(self.instance, 'dh_commands')()
        self.instance.information['control'] = {'self': [{'build-depends': \
            {'debhelper': {'arch': '', 'relation': [['>>', '1.0.0']]}}}]}
        method = getattr(self.instance, 'build_deps_and_deps')
        method()
        self.assert_('no-debhelper-but-build-dep' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-debhelper-but-build-dep'), True)

