BEGIN;

CREATE TYPE t_code AS ENUM (
       'O', 'X', 'I', 'W', 'E'
);
CREATE TYPE t_type AS ENUM (
       'binary', 'source', 'udeb'
);

CREATE TABLE tag_list (
       id    serial PRIMARY KEY,
       name  text NOT NULL UNIQUE,
       desc  text
);
CREATE INDEX tag_list_name_idx ON tag_list (name);
CREATE INDEX tag_list_name_pattern_idx
       ON tag_list (name text_pattern_ops);

CREATE TABLE src_pkg_list (
       id    	      serial PRIMARY KEY,
       name	      text NOT NULL,
       maint	      text NOT NULL,
       version	      text NOT NULL,

       UNIQUE (name, version)
);
CREATE INDEX src_pkg_list_name_idx ON src_pkg_list (name);
CREATE INDEX src_pkg_list_name_pattern_idx
       ON src_pkg_list (name text_pattern_ops);
CREATE INDEX src_pkg_list_maint_idx ON src_pkg_list (maint);
CREATE INDEX src_pkg_list_maint_pattern_idx
       ON src_pkg_list (maint text_pattern_ops);

CREATE TABLE tags (
       code  	  t_code NOT NULL,
       src_pkg	  int NOT NULL REFERENCES src_pkg_list(id),
       pkg	  text NOT NULL,
       type	  t_type NOT NULL DEFAULT 'binary',
       tag	  int NOT NULL REFERENCES tag_list(id),
       extra	  text
);
CREATE INDEX tags_pkg_idx ON tags (pkg);
CREATE INDEX tags_pkg_pattern_idx ON tags (pkg text_pattern_ops);

COMMIT;