 
/****************************************************************************
#	 	Agilent HDCS2020 library                                    #
# 		Copyright (C) 2004 Michel Xhaard   mxhaard@magic.fr         #
#                                                                           #
# This program is free software; you can redistribute it and/or modify      #
# it under the terms of the GNU General Public License as published by      #
# the Free Software Foundation; either version 2 of the License, or         #
# (at your option) any later version.                                       #
#                                                                           #
# This program is distributed in the hope that it will be useful,           #
# but WITHOUT ANY WARRANTY; without even the implied warranty of            #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
# GNU General Public License for more details.                              #
#                                                                           #
# You should have received a copy of the GNU General Public License         #
# along with this program; if not, write to the Free Software               #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA #
#                                                                           #
****************************************************************************/

/* play poker with registers at your own risk !! */
static __u16 hdcs2020xx_start_data[][3]=
{
 { 0xA0, 0x01, 0x0000},
 { 0xA0, 0x03, 0x0008},
 { 0xA0, 0x0E, 0x0010},
 { 0xA0, 0x10, 0x0002},
 { 0xA0, 0x02, 0x0003},
 { 0xA0, 0x80, 0x0004},
 { 0xA0, 0x01, 0x0005},
 { 0xA0, 0xD0, 0x0006}, //D0 ?? E0 did not start
 { 0xA0, 0x01, 0x0001},
 { 0xA0, 0x03, 0x0012},
 { 0xA0, 0x01, 0x0012},
 { 0xA0, 0x08, 0x008D},
 { 0xA0, 0x08, 0x0098},
 { 0xA0, 0x02, 0x009A},
 { 0xA0, 0x08, 0x011A},
 { 0xA0, 0x02, 0x011C},
 { 0xA0, 0x01, 0x009B},
 { 0xA0, 0xD8, 0x009C},
 { 0xA0, 0x02, 0x009D},
 { 0xA0, 0x88, 0x009E},
 { 0xA0, 0x02, 0x0092},
 { 0xA0, 0x02, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x07, 0x0092},
 { 0xA0, 0x06, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x08, 0x0092},
 { 0xA0, 0x02, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x09, 0x0092},
 { 0xA0, 0x06, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0A, 0x0092},
 { 0xA0, 0x01, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0B, 0x0092},
 { 0xA0, 0x01, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0C, 0x0092},
 { 0xA0, 0x08, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0D, 0x0092},
 { 0xA0, 0x00, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x10, 0x0092},
 { 0xA0, 0x00, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x12, 0x0092},
 { 0xA0, 0x05, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x13, 0x0092},
 { 0xA0, 0x63, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x15, 0x0092},
 { 0xA0, 0x70, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x37, 0x0101},
 { 0xA0, 0x0D, 0x0100},
 { 0xA0, 0x06, 0x0189},
 { 0xA0, 0x00, 0x01AD},
 { 0xA0, 0x03, 0x01C5},
 { 0xA0, 0x13, 0x01CB},
 { 0xA0, 0x08, 0x0250},
 { 0xA0, 0x08, 0x0301},
 { 0xA0, 0x70, 0x018D},
 { 0xA1, 0x01, 0x0002},
 { 0xA1, 0x01, 0x0008},
 { 0xA0, 0x03, 0x0008},
 { 0xA0, 0x04, 0x01C6},
 { 0xA1, 0x01, 0x01C8},
 { 0xA1, 0x01, 0x01C9},
 { 0xA1, 0x01, 0x01CA},
 { 0xA0, 0x07, 0x01CB},
 { 0xA0, 0x11, 0x0120},
 { 0xA0, 0x37, 0x0121},
 { 0xA0, 0x58, 0x0122},
 { 0xA0, 0x79, 0x0123},
 { 0xA0, 0x91, 0x0124},
 { 0xA0, 0xA6, 0x0125},
 { 0xA0, 0xB8, 0x0126},
 { 0xA0, 0xC7, 0x0127},
 { 0xA0, 0xD3, 0x0128},
 { 0xA0, 0xDE, 0x0129},
 { 0xA0, 0xE6, 0x012A},
 { 0xA0, 0xED, 0x012B},
 { 0xA0, 0xF3, 0x012C},
 { 0xA0, 0xF8, 0x012D},
 { 0xA0, 0xFB, 0x012E},
 { 0xA0, 0xFF, 0x012F},
 { 0xA0, 0x26, 0x0130},
 { 0xA0, 0x23, 0x0131},
 { 0xA0, 0x20, 0x0132},
 { 0xA0, 0x1C, 0x0133},
 { 0xA0, 0x16, 0x0134},
 { 0xA0, 0x13, 0x0135},
 { 0xA0, 0x10, 0x0136},
 { 0xA0, 0x0D, 0x0137},
 { 0xA0, 0x0B, 0x0138},
 { 0xA0, 0x09, 0x0139},
 { 0xA0, 0x07, 0x013A},
 { 0xA0, 0x06, 0x013B},
 { 0xA0, 0x05, 0x013C},
 { 0xA0, 0x04, 0x013D},
 { 0xA0, 0x03, 0x013E},
 { 0xA0, 0x02, 0x013F},
 { 0xA0, 0x4C, 0x010A},
 { 0xA0, 0xF5, 0x010B},
 { 0xA0, 0xFF, 0x010C},
 { 0xA0, 0xF9, 0x010D},
 { 0xA0, 0x51, 0x010E},
 { 0xA0, 0xF5, 0x010F},
 { 0xA0, 0xFB, 0x0110},
 { 0xA0, 0xED, 0x0111},
 { 0xA0, 0x5F, 0x0112},
 { 0xA1, 0x01, 0x0180},
 { 0xA0, 0x00, 0x0180},
 { 0xA0, 0x00, 0x0019},
 { 0xA0, 0x20, 0x0087},
 { 0xA0, 0x21, 0x0088},
 { 0xA0, 0x20, 0x0092},
 { 0xA0, 0x04, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x21, 0x0092},
 { 0xA0, 0x3D, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x03, 0x0092},
 { 0xA0, 0x41, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x04, 0x0092},
 { 0xA0, 0x10, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x05, 0x0092},
 { 0xA0, 0x3D, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0E, 0x0092},
 { 0xA0, 0x01, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0F, 0x0092},
 { 0xA0, 0x00, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x14, 0x01A9},
 { 0xA0, 0x24, 0x01AA},
 { 0xA0, 0x00, 0x0190},
 { 0xA0, 0x04, 0x0191},
 { 0xA0, 0x3D, 0x0192},
 { 0xA0, 0x00, 0x0195},
 { 0xA0, 0x00, 0x0196},
 { 0xA0, 0x9B, 0x0197},
 { 0xA0, 0x10, 0x018C},
 { 0xA0, 0x20, 0x018F},
 { 0xA0, 0x41, 0x001D},
 { 0xA0, 0x6F, 0x001E},
 { 0xA0, 0xAD, 0x001F},
 { 0xA0, 0xFF, 0x0020},
 { 0xA0, 0x0F, 0x0087},
 { 0xA0, 0x0E, 0x0088},
 { 0xA0, 0x40, 0x0180},
 { 0xA1, 0x01, 0x0195},
 { 0xA1, 0x01, 0x0196},
 { 0xA1, 0x01, 0x0197},
 { 0xA0, 0x3D, 0x0192},
 { 0xA0, 0x04, 0x0191},
 { 0xA0, 0x00, 0x0190},
 { 0xA0, 0x1D, 0x0116},
 { 0xA0, 0x40, 0x0117},
 { 0xA0, 0x85, 0x0118},
 { 0xA1, 0x01, 0x0116},
 { 0xA1, 0x01, 0x0118},
 { 0xA1, 0x01, 0x0180},
 { 0xA0, 0x42, 0x0180},
 { 0xA0, 0x1D, 0x0116},
 { 0xA0, 0x40, 0x0117},
 { 0xA0, 0x85, 0x0118},
 { 0xA1, 0x01, 0x0116},
 { 0xA1, 0x01, 0x0118},
 //{ 0xA0, 0x02, 0x0008},
 { 0xA0, 0x00, 0x0007},
 {0,0,0}
 };

static __u16 hdcs2020xx_scale_data[][3]=
{
 { 0xA0, 0x01, 0x0000},
 { 0xA0, 0x03, 0x0008},
 { 0xA0, 0x0E, 0x0010},
 { 0xA0, 0x00, 0x0002},
 { 0xA0, 0x02, 0x0003},
 { 0xA0, 0x80, 0x0004},
 { 0xA0, 0x01, 0x0005},
 { 0xA0, 0xE0, 0x0006},
 { 0xA0, 0x01, 0x0001},
 { 0xA0, 0x03, 0x0012},
 { 0xA0, 0x01, 0x0012},
 { 0xA0, 0x08, 0x008D},
 { 0xA0, 0x00, 0x0098},
 { 0xA0, 0x03, 0x009A},
 { 0xA0, 0x00, 0x011A},
 { 0xA0, 0x03, 0x011C},
 { 0xA0, 0x01, 0x009B},
 { 0xA0, 0xE6, 0x009C},
 { 0xA0, 0x02, 0x009D},
 { 0xA0, 0x86, 0x009E},
 { 0xA0, 0x02, 0x0092},
 { 0xA0, 0x02, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x07, 0x0092},
 { 0xA0, 0x06, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x08, 0x0092},
 { 0xA0, 0x02, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x09, 0x0092},
 { 0xA0, 0x06, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0A, 0x0092},
 { 0xA0, 0x01, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0B, 0x0092},
 { 0xA0, 0x01, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0C, 0x0092},
 { 0xA0, 0x08, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0D, 0x0092},
 { 0xA0, 0x00, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x10, 0x0092},
 { 0xA0, 0x00, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x12, 0x0092},
 { 0xA0, 0x05, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x13, 0x0092},
 { 0xA0, 0x63, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x15, 0x0092},
 { 0xA0, 0x70, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0xB7, 0x0101},
 { 0xA0, 0x0D, 0x0100},
 { 0xA0, 0x06, 0x0189},
 { 0xA0, 0x00, 0x01AD},
 { 0xA0, 0x03, 0x01C5},
 { 0xA0, 0x13, 0x01CB},
 { 0xA0, 0x08, 0x0250},
 { 0xA0, 0x08, 0x0301},
 { 0xA0, 0x70, 0x018D},
 { 0xA1, 0x01, 0x0002},
 { 0xA1, 0x01, 0x0008},
 { 0xA0, 0x03, 0x0008},
 { 0xA0, 0x04, 0x01C6},
 { 0xA1, 0x01, 0x01C8},
 { 0xA1, 0x01, 0x01C9},
 { 0xA1, 0x01, 0x01CA},
 { 0xA0, 0x07, 0x01CB},
 { 0xA0, 0x11, 0x0120},
 { 0xA0, 0x37, 0x0121},
 { 0xA0, 0x58, 0x0122},
 { 0xA0, 0x79, 0x0123},
 { 0xA0, 0x91, 0x0124},
 { 0xA0, 0xA6, 0x0125},
 { 0xA0, 0xB8, 0x0126},
 { 0xA0, 0xC7, 0x0127},
 { 0xA0, 0xD3, 0x0128},
 { 0xA0, 0xDE, 0x0129},
 { 0xA0, 0xE6, 0x012A},
 { 0xA0, 0xED, 0x012B},
 { 0xA0, 0xF3, 0x012C},
 { 0xA0, 0xF8, 0x012D},
 { 0xA0, 0xFB, 0x012E},
 { 0xA0, 0xFF, 0x012F},
 { 0xA0, 0x26, 0x0130},
 { 0xA0, 0x23, 0x0131},
 { 0xA0, 0x20, 0x0132},
 { 0xA0, 0x1C, 0x0133},
 { 0xA0, 0x16, 0x0134},
 { 0xA0, 0x13, 0x0135},
 { 0xA0, 0x10, 0x0136},
 { 0xA0, 0x0D, 0x0137},
 { 0xA0, 0x0B, 0x0138},
 { 0xA0, 0x09, 0x0139},
 { 0xA0, 0x07, 0x013A},
 { 0xA0, 0x06, 0x013B},
 { 0xA0, 0x05, 0x013C},
 { 0xA0, 0x04, 0x013D},
 { 0xA0, 0x03, 0x013E},
 { 0xA0, 0x02, 0x013F},
 { 0xA0, 0x4C, 0x010A},
 { 0xA0, 0xF5, 0x010B},
 { 0xA0, 0xFF, 0x010C},
 { 0xA0, 0xF9, 0x010D},
 { 0xA0, 0x51, 0x010E},
 { 0xA0, 0xF5, 0x010F},
 { 0xA0, 0xFB, 0x0110},
 { 0xA0, 0xED, 0x0111},
 { 0xA0, 0x5F, 0x0112},
 { 0xA1, 0x01, 0x0180},
 { 0xA0, 0x00, 0x0180},
 { 0xA0, 0x00, 0x0019},
 { 0xA0, 0x20, 0x0087},
 { 0xA0, 0x21, 0x0088},
 { 0xA0, 0x20, 0x0092},
 { 0xA0, 0x02, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x21, 0x0092},
 { 0xA0, 0x1B, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x03, 0x0092},
 { 0xA0, 0x44, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x04, 0x0092},
 { 0xA0, 0x08, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x05, 0x0092},
 { 0xA0, 0x1B, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0E, 0x0092},
 { 0xA0, 0x01, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x0F, 0x0092},
 { 0xA0, 0x00, 0x0093},
 { 0xA0, 0x00, 0x0094},
 { 0xA0, 0x01, 0x0090},
 { 0xA1, 0x01, 0x0091},
 { 0xA0, 0x14, 0x01A9},
 { 0xA0, 0x24, 0x01AA},
 { 0xA0, 0x00, 0x0190},
 { 0xA0, 0x02, 0x0191},
 { 0xA0, 0x1B, 0x0192},
 { 0xA0, 0x00, 0x0195},
 { 0xA0, 0x00, 0x0196},
 { 0xA0, 0x4D, 0x0197},
 { 0xA0, 0x10, 0x018C},
 { 0xA0, 0x20, 0x018F},
 { 0xA0, 0x44, 0x001D},
 { 0xA0, 0x6F, 0x001E},
 { 0xA0, 0xAD, 0x001F},
 { 0xA0, 0xEB, 0x0020},
 { 0xA0, 0x0F, 0x0087},
 { 0xA0, 0x0E, 0x0088},
 { 0xA0, 0x40, 0x0180},
 { 0xA1, 0x01, 0x0195},
 { 0xA1, 0x01, 0x0196},
 { 0xA1, 0x01, 0x0197},
 { 0xA0, 0x1B, 0x0192},
 { 0xA0, 0x02, 0x0191},
 { 0xA0, 0x00, 0x0190},
 { 0xA0, 0x1D, 0x0116},
 { 0xA0, 0x40, 0x0117},
 { 0xA0, 0x99, 0x0118},
 { 0xA1, 0x01, 0x0116},
 { 0xA1, 0x01, 0x0118},
 { 0xA1, 0x01, 0x0180},
 { 0xA0, 0x42, 0x0180},
 { 0xA0, 0x1D, 0x0116},
 { 0xA0, 0x40, 0x0117},
 { 0xA0, 0x99, 0x0118}, 
// { 0xA0, 0x02, 0x0008},
 { 0xA0, 0x00, 0x0007},
 //{ 0xA0, 0x18, 0x00FE},
 {0,0,0}
 };
static __u16 hdcs2020xb_start_data[][3]=
{
 { 0xa0, 0x01, 0x0000},
 { 0xa0, 0x11, 0x0002},
 { 0xa0, 0x03, 0x0008}, // qtable 0x05
 { 0xa0, 0x08, 0x0010},
 { 0xa0, 0x02, 0x0003},
 { 0xa0, 0x80, 0x0004},
 { 0xa0, 0x01, 0x0005},
 { 0xa0, 0xe0, 0x0006},
 { 0xa0, 0x01, 0x0001},
 { 0xa0, 0x03, 0x0012},
 { 0xa0, 0x01, 0x0012},
 { 0xa0, 0x00, 0x0098},
 { 0xa0, 0x00, 0x009a},
 { 0xa0, 0x00, 0x011a},
 { 0xa0, 0x00, 0x011c},
 { 0xa0, 0xe8, 0x009c},
 { 0xa0, 0x88, 0x009e},
 { 0xa0, 0x1c, 0x0092},
 { 0xa0, 0x00, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0a, 0x0092},
 { 0xa0, 0x01, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0b, 0x0092},
 { 0xa0, 0x06, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0c, 0x0092},
 { 0xa0, 0x7b, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0d, 0x0092},
 { 0xa0, 0xa7, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x03, 0x0092},
 { 0xa0, 0xfb, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x05, 0x0092},
 { 0xa0, 0x00, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x06, 0x0092},
 { 0xa0, 0x03, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x09, 0x0092},
 { 0xa0, 0x08, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},

 { 0xa0, 0x0f, 0x0092}, // set sensor gain
 { 0xa0, 0x18, 0x0093}, //0x18
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x10, 0x0092},
 { 0xa0, 0x18, 0x0093}, //0x18
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x11, 0x0092},
 { 0xa0, 0x18, 0x0093}, //0x18
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x12, 0x0092},
 { 0xa0, 0x18, 0x0093}, //0x18
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},

 { 0xa0, 0x15, 0x0092},
 { 0xa0, 0x4e, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x1c, 0x0092},
 { 0xa0, 0x04, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0xb7, 0x0101},
 { 0xa0, 0x05, 0x0012},
 { 0xa0, 0x70, 0x018d},
 { 0xa0, 0x0d, 0x0100},
 { 0xa0, 0x06, 0x0189},
 { 0xa0, 0x03, 0x01c5},
 { 0xa0, 0x13, 0x01cb},
 { 0xa0, 0x08, 0x0250},
 { 0xa0, 0x08, 0x0301},
 { 0xa1, 0x01, 0x0002},
 { 0xa1, 0x01, 0x0008},
 { 0xa1, 0x01, 0x0180},
 { 0xa0, 0x02, 0x0180},
 { 0xa0, 0x40, 0x0116},
 { 0xa0, 0x40, 0x0117},
 { 0xa0, 0x40, 0x0118},
 { 0xa1, 0x01, 0x0008},
 { 0xa0, 0x03, 0x0008},//
 { 0xa0, 0x08, 0x01c6},
 { 0xa1, 0x01, 0x01c8},
 { 0xa1, 0x01, 0x01c9},
 { 0xa1, 0x01, 0x01ca},
 { 0xa0, 0x0f, 0x01cb},
 { 0xa0, 0x13, 0x0120},
 { 0xa0, 0x38, 0x0121},
 { 0xa0, 0x59, 0x0122},
 { 0xa0, 0x79, 0x0123},
 { 0xa0, 0x92, 0x0124},
 { 0xa0, 0xa7, 0x0125},
 { 0xa0, 0xb9, 0x0126},
 { 0xa0, 0xc8, 0x0127},
 { 0xa0, 0xd4, 0x0128},
 { 0xa0, 0xdf, 0x0129},
 { 0xa0, 0xe7, 0x012a},
 { 0xa0, 0xee, 0x012b},
 { 0xa0, 0xf4, 0x012c},
 { 0xa0, 0xf9, 0x012d},
 { 0xa0, 0xfc, 0x012e},
 { 0xa0, 0xff, 0x012f},
 { 0xa0, 0x26, 0x0130},
 { 0xa0, 0x22, 0x0131},
 { 0xa0, 0x20, 0x0132},
 { 0xa0, 0x1c, 0x0133},
 { 0xa0, 0x16, 0x0134},
 { 0xa0, 0x13, 0x0135},
 { 0xa0, 0x10, 0x0136},
 { 0xa0, 0x0d, 0x0137},
 { 0xa0, 0x0b, 0x0138},
 { 0xa0, 0x09, 0x0139},
 { 0xa0, 0x07, 0x013a},
 { 0xa0, 0x06, 0x013b},
 { 0xa0, 0x05, 0x013c},
 { 0xa0, 0x04, 0x013d},
 { 0xa0, 0x03, 0x013e},
 { 0xa0, 0x02, 0x013f},
 /********************/
 { 0xa0, 0x66, 0x010a},//66
 { 0xa0, 0xed, 0x010b},//ed
 { 0xa0, 0xed, 0x010c},//ed
 { 0xa0, 0xed, 0x010d},//ed
 { 0xa0, 0x66, 0x010e},//66
 { 0xa0, 0xed, 0x010f},//ed
 { 0xa0, 0xed, 0x0110},//ed
 { 0xa0, 0xed, 0x0111},//ed
 { 0xa0, 0x66, 0x0112},//66
 
 { 0xa1, 0x01, 0x0180},
 { 0xa0, 0x00, 0x0180},
 { 0xa0, 0x00, 0x0019},
 { 0xa0, 0x13, 0x0092},
 { 0xa0, 0x31, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x14, 0x0092},
 { 0xa0, 0x01, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0e, 0x0092},
 { 0xa0, 0x04, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x19, 0x0092},
 { 0xa0, 0xcd, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x00, 0x0190},
 { 0xa0, 0x02, 0x0191},
 { 0xa0, 0x62, 0x0192},
 { 0xa0, 0x00, 0x0195},
 { 0xa0, 0x00, 0x0196},
 { 0xa0, 0x3d, 0x0197},
 { 0xa0, 0x10, 0x018c},
 { 0xa0, 0x20, 0x018f},
 /********************/
 { 0xa0, 0x0c, 0x01a9},//0x14
 { 0xa0, 0x28, 0x01aa},
 /********************/
 { 0xa0, 0x04, 0x001d},
 { 0xa0, 0x18, 0x001e},
 { 0xa0, 0x2c, 0x001f},
 { 0xa0, 0x41, 0x0020},
 { 0xa0, 0x60, 0x011d},
 { 0xa0, 0x42, 0x0180},
 { 0xa1, 0x01, 0x0180},
 { 0xa0, 0x42, 0x0180},
 { 0xa0, 0x40, 0x0116},
 { 0xa0, 0x40, 0x0117},
 { 0xa0, 0x40, 0x0118},
 {0,0,0}
 };
static __u16 hdcs2020xb_scale_data[][3]={
{ 0xa0, 0x01, 0x0000},
 { 0xa0, 0x00, 0x0002},
 { 0xa0, 0x03, 0x0008},
 { 0xa0, 0x08, 0x0010},
 { 0xa0, 0x02, 0x0003},
 { 0xa0, 0x80, 0x0004},
 { 0xa0, 0x01, 0x0005},
 { 0xa0, 0xe0, 0x0006},
 { 0xa0, 0x01, 0x0001},
 { 0xa0, 0x03, 0x0012},
 { 0xa0, 0x01, 0x0012},
 { 0xa0, 0x00, 0x0098},
 { 0xa0, 0x00, 0x009a},
 { 0xa0, 0x00, 0x011a},
 { 0xa0, 0x00, 0x011c},
 { 0xa0, 0xe8, 0x009c},
 { 0xa0, 0x88, 0x009e},
 { 0xa0, 0x1c, 0x0092},
 { 0xa0, 0x00, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0a, 0x0092},
 { 0xa0, 0x01, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0b, 0x0092},
 { 0xa0, 0x06, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0c, 0x0092},
 { 0xa0, 0x7a, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0d, 0x0092},
 { 0xa0, 0xa7, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x03, 0x0092},
 { 0xa0, 0xfb, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x05, 0x0092},
 { 0xa0, 0x00, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x06, 0x0092},
 { 0xa0, 0x03, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x09, 0x0092},
 { 0xa0, 0x08, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 #if 0
 { 0xa0, 0x0f, 0x0092}, // set sensor gain
 { 0xa0, 0x4f, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x10, 0x0092},
 { 0xa0, 0x4f, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x11, 0x0092},
 { 0xa0, 0x4f, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x12, 0x0092},
 { 0xa0, 0x4f, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 #endif
 { 0xa0, 0x0f, 0x0092}, // original setting
 { 0xa0, 0x18, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x10, 0x0092},
 { 0xa0, 0x18, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x11, 0x0092},
 { 0xa0, 0x18, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x12, 0x0092},
 { 0xa0, 0x18, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
/**********************/
 { 0xa0, 0x15, 0x0092},
 { 0xa0, 0x4e, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x1c, 0x0092},
 { 0xa0, 0x04, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0xf7, 0x0101},
 { 0xa0, 0x05, 0x0012},
 { 0xa0, 0x70, 0x018d},
 { 0xa0, 0x0d, 0x0100},
 { 0xa0, 0x06, 0x0189},
 { 0xa0, 0x03, 0x01c5},
 { 0xa0, 0x13, 0x01cb},
 { 0xa0, 0x08, 0x0250},
 { 0xa0, 0x08, 0x0301},
 { 0xa1, 0x01, 0x0002},
 { 0xa1, 0x01, 0x0008},
 { 0xa1, 0x01, 0x0180},
 { 0xa0, 0x02, 0x0180},
 { 0xa0, 0x40, 0x0116},
 { 0xa0, 0x40, 0x0117},
 { 0xa0, 0x40, 0x0118},
 { 0xa1, 0x01, 0x0008},
 { 0xa0, 0x03, 0x0008},
 { 0xa0, 0x08, 0x01c6},
 { 0xa1, 0x01, 0x01c8},
 { 0xa1, 0x01, 0x01c9},
 { 0xa1, 0x01, 0x01ca},
 { 0xa0, 0x0f, 0x01cb},
 { 0xa0, 0x13, 0x0120},
 { 0xa0, 0x38, 0x0121},
 { 0xa0, 0x59, 0x0122},
 { 0xa0, 0x79, 0x0123},
 { 0xa0, 0x92, 0x0124},
 { 0xa0, 0xa7, 0x0125},
 { 0xa0, 0xb9, 0x0126},
 { 0xa0, 0xc8, 0x0127},
 { 0xa0, 0xd4, 0x0128},
 { 0xa0, 0xdf, 0x0129},
 { 0xa0, 0xe7, 0x012a},
 { 0xa0, 0xee, 0x012b},
 { 0xa0, 0xf4, 0x012c},
 { 0xa0, 0xf9, 0x012d},
 { 0xa0, 0xfc, 0x012e},
 { 0xa0, 0xff, 0x012f},
 { 0xa0, 0x26, 0x0130},
 { 0xa0, 0x22, 0x0131},
 { 0xa0, 0x20, 0x0132},
 { 0xa0, 0x1c, 0x0133},
 { 0xa0, 0x16, 0x0134},
 { 0xa0, 0x13, 0x0135},
 { 0xa0, 0x10, 0x0136},
 { 0xa0, 0x0d, 0x0137},
 { 0xa0, 0x0b, 0x0138},
 { 0xa0, 0x09, 0x0139},
 { 0xa0, 0x07, 0x013a},
 { 0xa0, 0x06, 0x013b},
 { 0xa0, 0x05, 0x013c},
 { 0xa0, 0x04, 0x013d},
 { 0xa0, 0x03, 0x013e},
 { 0xa0, 0x02, 0x013f},
 { 0xa0, 0x66, 0x010a},
 { 0xa0, 0xed, 0x010b},
 { 0xa0, 0xed, 0x010c},
 { 0xa0, 0xed, 0x010d},
 { 0xa0, 0x66, 0x010e},
 { 0xa0, 0xed, 0x010f},
 { 0xa0, 0xed, 0x0110},
 { 0xa0, 0xed, 0x0111},
 { 0xa0, 0x66, 0x0112},
 { 0xa1, 0x01, 0x0180},
 { 0xa0, 0x00, 0x0180},
 { 0xa0, 0x00, 0x0019},
 /**** set exposure ***/
 { 0xa0, 0x13, 0x0092},
 { 0xa0, 0x31, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x14, 0x0092},
 { 0xa0, 0x01, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x0e, 0x0092},
 { 0xa0, 0x04, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x19, 0x0092},
 { 0xa0, 0xcd, 0x0093},
 { 0xa0, 0x00, 0x0094},
 { 0xa0, 0x01, 0x0090},
 { 0xa1, 0x01, 0x0091},
 { 0xa0, 0x00, 0x0190},
 { 0xa0, 0x02, 0x0191},
 { 0xa0, 0x62, 0x0192},
 { 0xa0, 0x00, 0x0195},
 { 0xa0, 0x00, 0x0196},
 { 0xa0, 0x3d, 0x0197},
 { 0xa0, 0x10, 0x018c},
 { 0xa0, 0x20, 0x018f},
 { 0xa0, 0x0c, 0x01a9},
 { 0xa0, 0x28, 0x01aa},
 { 0xa0, 0x04, 0x001d},
 { 0xa0, 0x18, 0x001e},
 { 0xa0, 0x2c, 0x001f},
 { 0xa0, 0x41, 0x0020},
 { 0xa0, 0x60, 0x011d},
 { 0xa0, 0x42, 0x0180},
 { 0xa1, 0x01, 0x0180},
 { 0xa0, 0x42, 0x0180},
 { 0xa0, 0x40, 0x0116},
 { 0xa0, 0x40, 0x0117},
 { 0xa0, 0x40, 0x0118},
 {0,0,0}
 };
