/*
 * OMAP4 Power domains framework
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Abhijit Pagare (abhijitpagare@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 * Paul Walmsley (paul@pwsan.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_POWERDOMAINS54XX_H
#define __ARCH_ARM_MACH_OMAP2_POWERDOMAINS54XX_H

#include <plat/powerdomain.h>

#include "prcm-common.h"
#include "cm.h"
#include "cm-regbits-44xx.h"
#include "prm.h"
#include "prm-regbits-44xx.h"

#if defined(CONFIG_ARCH_OMAP4)

/* core_44xx_pwrdm: CORE power domain */
static struct powerdomain core_44xx_pwrdm = {
	.name		  = "core_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_CORE_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 5,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* core_nret_bank */
		[1] = PWRSTS_OFF_RET,	/* core_ocmram */
		[2] = PWRSTS_OFF_RET,	/* core_other_bank */
		[3] = PWRSTS_OFF_RET,	/* ipu_l2ram */
		[4] = PWRSTS_OFF_RET,	/* ipu_unicache */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* core_nret_bank */
		[1] = PWRSTS_OFF_RET,	/* core_ocmram */
		[2] = PWRSTS_OFF_RET,	/* core_other_bank */
		[3] = PWRSTS_OFF_RET,	/* ipu_l2ram */
		[4] = PWRSTS_OFF_RET,	/* ipu_unicache */
	},
};

/* abe_44xx_pwrdm: Audio back end power domain */
static struct powerdomain abe_44xx_pwrdm = {
	.name		  = "abe_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_ABE_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRDM_POWER_OFF,
	.banks		  = 2,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* aessmem */
		[1] = PWRSTS_OFF_RET,	/* periphmem */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* aessmem */
		[1] = PWRSTS_OFF_RET,	/* periphmem */
	},
};

/* coreaon_44xx_pwrdm: Always ON logic that sits in VDD_CORE voltage domain */
static struct powerdomain coreaon_44xx_pwrdm = {
	.name		  = "coreaon_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_COREAON_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRDM_POWER_ON,
};

/* dss_44xx_pwrdm: Display subsystem power domain */
static struct powerdomain dss_44xx_pwrdm = {
	.name		  = "dss_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_DSS_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRDM_POWER_OFF,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* dss_mem */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* dss_mem */
	},
};

/* cpu0_44xx_pwrdm: MPU0 processor and Neon coprocessor power domain */
static struct powerdomain cpu0_44xx_pwrdm = {
	.name		  = "cpu0_pwrdm",
	.prcm_offs	  = OMAP4430_PRCM_MPU_CPU0_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* cpu0_l1 */
	},
	.pwrsts_mem_on	= {
		[0] = PWRDM_POWER_ON,	/* cpu0_l1 */
	},
};

/* cpu1_44xx_pwrdm: MPU1 processor and Neon coprocessor power domain */
static struct powerdomain cpu1_44xx_pwrdm = {
	.name		  = "cpu1_pwrdm",
	.prcm_offs	  = OMAP4430_PRCM_MPU_CPU1_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* cpu1_l1 */
	},
	.pwrsts_mem_on	= {
		[0] = PWRDM_POWER_ON,	/* cpu1_l1 */
	},
};

/* emu_44xx_pwrdm: Emulation power domain */
static struct powerdomain emu_44xx_pwrdm = {
	.name		  = "emu_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_EMU_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_ON,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* emu_bank */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* emu_bank */
	},
};

/* mpu_44xx_pwrdm: Modena processor and the Neon coprocessor power domain */
static struct powerdomain mpu_44xx_pwrdm = {
	.name		  = "mpu_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_MPU_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 2,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* mpu_l2 */
		[1] = PWRDM_POWER_RET,	/* mpu_ram */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* mpu_l2 */
		[1] = PWRSTS_OFF_RET,	/* mpu_ram */
	},
};

/* custefuse_44xx_pwrdm: Customer efuse controller power domain */
static struct powerdomain custefuse_44xx_pwrdm = {
	.name		  = "custefuse_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_CUSTEFUSE_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_ON,
};

/* dsp_44xx_pwrdm: Tesla processor power domain */
static struct powerdomain dsp_44xx_pwrdm = {
	.name		  = "dsp_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_DSP_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 3,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* dsp_edma */
		[1] = PWRSTS_OFF_RET,	/* dsp_l1 */
		[2] = PWRSTS_OFF_RET,	/* dsp_l2 */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* dsp_edma */
		[1] = PWRSTS_OFF_RET,	/* dsp_l1 */
		[2] = PWRSTS_OFF_RET,	/* dsp_l2 */
	},
};

/* cam_44xx_pwrdm: Camera subsystem power domain */
static struct powerdomain cam_44xx_pwrdm = {
	.name		  = "cam_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_CAM_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_ON,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* cam_mem */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* cam_mem */
	},
};

/* l3init_44xx_pwrdm: L3 initators pheripherals power domain  */
static struct powerdomain l3init_44xx_pwrdm = {
	.name		  = "l3init_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_L3INIT_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 2,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* l3init_bank1 */
		[1] = PWRSTS_OFF_RET,	/* l3init_bank2 */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* l3init_bank1 */
		[1] = PWRSTS_OFF_RET,	/* l3init_bank2 */
	},
};

/* l4per_44xx_pwrdm: Target peripherals power domain */
static struct powerdomain l4per_44xx_pwrdm = {
	.name		  = "l4per_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_L4PER_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_RET_ON,
	.pwrsts_logic_ret = PWRSTS_OFF_RET,
	.banks		  = 2,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* nonretained_bank */
		[1] = PWRSTS_OFF_RET,	/* retained_bank */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* nonretained_bank */
		[1] = PWRSTS_OFF_RET,	/* retained_bank */
	},
};

/* gpu_44xx_pwrdm: 3D accelerator power domain */
static struct powerdomain gpu_44xx_pwrdm = {
	.name		  = "gpu_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_GPU_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_ON,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* gpu_mem */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* gpu_mem */
	},
};

/* mpuaon_44xx_pwrdm: Always ON logic that sits in VDD_MPU voltage domain */
static struct powerdomain mpuaon_44xx_pwrdm = {
	.name		  = "mpuaon_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_MPUAON_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRDM_POWER_ON,
};

/* mmaon_44xx_pwrdm: Always-on logic that sits in VDD_IVA voltage domain */
static struct powerdomain mmaon_44xx_pwrdm = {
	.name		  = "mmaon_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_MMAON_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRDM_POWER_ON,
};

/* wkupaon_44xx_pwrdm: Wake-up power domain */
static struct powerdomain wkupaon_44xx_pwrdm = {
	.name		  = "wkupaon_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_WKUPAON_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRDM_POWER_ON,
	.banks		  = 1,
	.pwrsts_mem_ret	= {
	},
	.pwrsts_mem_on	= {
		[0] = PWRDM_POWER_ON,	/* wkup_bank */
	},
};

/* iva_44xx_pwrdm: IVA-HD power domain */
static struct powerdomain iva_44xx_pwrdm = {
	.name		  = "iva_pwrdm",
	.prcm_offs	  = OMAP4430_PRM_IVA_MOD,
	.omap_chip	  = OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
	.pwrsts		  = PWRSTS_OFF_RET_ON,
	.pwrsts_logic_ret = PWRDM_POWER_OFF,
	.banks		  = 4,
	.pwrsts_mem_ret	= {
		[0] = PWRSTS_OFF_RET,	/* hwa_mem */
		[1] = PWRSTS_OFF_RET,	/* sl2_mem */
		[2] = PWRSTS_OFF_RET,	/* tcm1_mem */
		[3] = PWRSTS_OFF_RET,	/* tcm2_mem */
	},
	.pwrsts_mem_on	= {
		[0] = PWRSTS_OFF_RET,	/* hwa_mem */
		[1] = PWRSTS_OFF_RET,	/* sl2_mem */
		[2] = PWRSTS_OFF_RET,	/* tcm1_mem */
		[3] = PWRSTS_OFF_RET,	/* tcm2_mem */
	},
};

/*
 * The following power domains are not under SW control
 *
 */

#endif

#endif
