/*
 * OMAP54xx Clock Management register bits
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_CM_REGBITS_54XX_H
#define __ARCH_ARM_MACH_OMAP2_CM_REGBITS_54XX_H

/* Used by CM_DSP_DYNAMICDEP, CM_L3MAIN1_DYNAMICDEP, CM_MPU_DYNAMICDEP */
#define OMAP54XX_ABE_DYNDEP_SHIFT					3
#define OMAP54XX_ABE_DYNDEP_MASK					(1 << 3)

/*
 * Used by CM_C2C_STATICDEP, CM_DMA_STATICDEP, CM_DSP_STATICDEP,
 * CM_IPU_STATICDEP, CM_L3INIT_STATICDEP, CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_ABE_STATDEP_SHIFT					3
#define OMAP54XX_ABE_STATDEP_MASK					(1 << 3)

/*
 * Used by CM_AUTOIDLE_DPLL_ABE, CM_AUTOIDLE_DPLL_CORE, CM_AUTOIDLE_DPLL_IVA,
 * CM_AUTOIDLE_DPLL_MPU, CM_AUTOIDLE_DPLL_PER, CM_AUTOIDLE_DPLL_UNIPRO1,
 * CM_AUTOIDLE_DPLL_UNIPRO2, CM_AUTOIDLE_DPLL_USB
 */
#define OMAP54XX_AUTO_DPLL_MODE_SHIFT					0
#define OMAP54XX_AUTO_DPLL_MODE_MASK					(0x7 << 0)

/* Used by CM_L3MAIN2_DYNAMICDEP, CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_C2C_DYNDEP_SHIFT					18
#define OMAP54XX_C2C_DYNDEP_MASK					(1 << 18)

/* Used by CM_MPU_STATICDEP */
#define OMAP54XX_C2C_STATDEP_SHIFT					18
#define OMAP54XX_C2C_STATDEP_MASK					(1 << 18)

/* Used by CM_IPU_DYNAMICDEP, CM_L3MAIN2_DYNAMICDEP, CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_CAM_DYNDEP_SHIFT					9
#define OMAP54XX_CAM_DYNDEP_MASK					(1 << 9)

/*
 * Used by CM_DMA_STATICDEP, CM_DSP_STATICDEP, CM_IPU_STATICDEP,
 * CM_MPU_STATICDEP
 */
#define OMAP54XX_CAM_STATDEP_SHIFT					9
#define OMAP54XX_CAM_STATDEP_MASK					(1 << 9)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_ABE_24M_GFCLK_SHIFT			13
#define OMAP54XX_CLKACTIVITY_ABE_24M_GFCLK_MASK				(1 << 13)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_ABE_32K_CLK_SHIFT				12
#define OMAP54XX_CLKACTIVITY_ABE_32K_CLK_MASK				(1 << 12)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_ABE_GICLK_SHIFT				9
#define OMAP54XX_CLKACTIVITY_ABE_GICLK_MASK				(1 << 9)

/* Used by CM_WKUPAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_ABE_LP_CLK_SHIFT				9
#define OMAP54XX_CLKACTIVITY_ABE_LP_CLK_MASK				(1 << 9)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_ABE_SYS_CLK_SHIFT				11
#define OMAP54XX_CLKACTIVITY_ABE_SYS_CLK_MASK				(1 << 11)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_ABE_X2_CLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_ABE_X2_CLK_MASK				(1 << 8)

/* Used by CM_C2C_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_C2C_L3_GICLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_C2C_L3_GICLK_MASK				(1 << 8)

/* Used by CM_C2C_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_C2C_L4_GICLK_SHIFT				9
#define OMAP54XX_CLKACTIVITY_C2C_L4_GICLK_MASK				(1 << 9)

/* Used by CM_CAM_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CAM_BOOST_GCLK_SHIFT			11
#define OMAP54XX_CLKACTIVITY_CAM_BOOST_GCLK_MASK			(1 << 11)

/* Used by CM_CAM_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CAM_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_CAM_GCLK_MASK				(1 << 8)

/* Used by CM_CAM_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CAM_L3_GICLK_SHIFT				12
#define OMAP54XX_CLKACTIVITY_CAM_L3_GICLK_MASK				(1 << 12)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_COREAON_32K_GFCLK_SHIFT			12
#define OMAP54XX_CLKACTIVITY_COREAON_32K_GFCLK_MASK			(1 << 12)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_COREAON_IO_SRCOMP_GFCLK_SHIFT		14
#define OMAP54XX_CLKACTIVITY_COREAON_IO_SRCOMP_GFCLK_MASK		(1 << 14)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_COREAON_L4_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_COREAON_L4_GICLK_MASK			(1 << 8)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_COREAON_TS_GFCLK_SHIFT			13
#define OMAP54XX_CLKACTIVITY_COREAON_TS_GFCLK_MASK			(1 << 13)

/* Used by CM_L4CFG_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CORE_TS_GFCLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_CORE_TS_GFCLK_MASK				(1 << 9)

/* Used by CM_CAM_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CSI_PHY_GFCLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_CSI_PHY_GFCLK_MASK				(1 << 9)

/* Used by CM_CUSTEFUSE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CUSTEFUSE_L4_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_CUSTEFUSE_L4_GICLK_MASK			(1 << 8)

/* Used by CM_CUSTEFUSE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_CUSTEFUSE_SYS_GFCLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_CUSTEFUSE_SYS_GFCLK_MASK			(1 << 9)

/* Used by CM_EMIF_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_DLL_GCLK_SHIFT				9
#define OMAP54XX_CLKACTIVITY_DLL_GCLK_MASK				(1 << 9)

/* Used by CM_DMA_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_DMA_L3_GICLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_DMA_L3_GICLK_MASK				(1 << 8)

/* Used by CM_DSP_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_DSP_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_DSP_GCLK_MASK				(1 << 8)

/* Used by CM_DSS_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_DSS_GFCLK_SHIFT				9
#define OMAP54XX_CLKACTIVITY_DSS_GFCLK_MASK				(1 << 9)

/* Used by CM_DSS_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_DSS_L3_GICLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_DSS_L3_GICLK_MASK				(1 << 8)

/* Used by CM_DSS_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_DSS_SYS_GFCLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_DSS_SYS_GFCLK_MASK				(1 << 10)

/* Used by CM_EMIF_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_EMIF_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_EMIF_L3_GICLK_MASK				(1 << 8)

/* Used by CM_EMIF_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_EMIF_PHY_GCLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_EMIF_PHY_GCLK_MASK				(1 << 10)

/* Used by CM_EMU_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_EMU_SYS_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_EMU_SYS_GCLK_MASK				(1 << 8)

/* Used by CM_CAM_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_FDIF_GCLK_SHIFT				10
#define OMAP54XX_CLKACTIVITY_FDIF_GCLK_MASK				(1 << 10)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_FUNC_24M_GFCLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_FUNC_24M_GFCLK_MASK			(1 << 10)

/* Used by CM_GPU_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_GPU_CORE_GCLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_GPU_CORE_GCLK_MASK				(1 << 9)

/* Used by CM_GPU_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_GPU_HYD_GCLK_SHIFT				10
#define OMAP54XX_CLKACTIVITY_GPU_HYD_GCLK_MASK				(1 << 10)

/* Used by CM_GPU_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_GPU_SYS_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_GPU_SYS_GCLK_MASK				(1 << 8)

/* Used by CM_DSS_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HDMI_CEC_GFCLK_SHIFT			12
#define OMAP54XX_CLKACTIVITY_HDMI_CEC_GFCLK_MASK			(1 << 12)

/* Used by CM_DSS_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HDMI_PHY_GFCLK_SHIFT			11
#define OMAP54XX_CLKACTIVITY_HDMI_PHY_GFCLK_MASK			(1 << 11)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSIC_P1_480M_GFCLK_SHIFT			20
#define OMAP54XX_CLKACTIVITY_HSIC_P1_480M_GFCLK_MASK			(1 << 20)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSIC_P1_GFCLK_SHIFT			26
#define OMAP54XX_CLKACTIVITY_HSIC_P1_GFCLK_MASK				(1 << 26)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSIC_P2_480M_GFCLK_SHIFT			21
#define OMAP54XX_CLKACTIVITY_HSIC_P2_480M_GFCLK_MASK			(1 << 21)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSIC_P2_GFCLK_SHIFT			27
#define OMAP54XX_CLKACTIVITY_HSIC_P2_GFCLK_MASK				(1 << 27)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSIC_P3_480M_GFCLK_SHIFT			6
#define OMAP54XX_CLKACTIVITY_HSIC_P3_480M_GFCLK_MASK			(1 << 6)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSIC_P3_GFCLK_SHIFT			7
#define OMAP54XX_CLKACTIVITY_HSIC_P3_GFCLK_MASK				(1 << 7)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_HSI_GFCLK_SHIFT				16
#define OMAP54XX_CLKACTIVITY_HSI_GFCLK_MASK				(1 << 16)

/* Used by CM_IPU_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_IPU_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_IPU_GCLK_MASK				(1 << 8)

/* Used by CM_IVA_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_IVA_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_IVA_GCLK_MASK				(1 << 8)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INIT_48M_GFCLK_SHIFT			12
#define OMAP54XX_CLKACTIVITY_L3INIT_48M_GFCLK_MASK			(1 << 12)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INIT_60M_P1_GFCLK_SHIFT			28
#define OMAP54XX_CLKACTIVITY_L3INIT_60M_P1_GFCLK_MASK			(1 << 28)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INIT_60M_P2_GFCLK_SHIFT			29
#define OMAP54XX_CLKACTIVITY_L3INIT_60M_P2_GFCLK_MASK			(1 << 29)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INIT_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L3INIT_L3_GICLK_MASK			(1 << 8)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INIT_L4_GICLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_L3INIT_L4_GICLK_MASK			(1 << 9)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INIT_USB_OTG_SS_LFPS_TX_GFCLK_SHIFT	11
#define OMAP54XX_CLKACTIVITY_L3INIT_USB_OTG_SS_LFPS_TX_GFCLK_MASK	(1 << 11)

/* Used by CM_L3INSTR_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INSTR_DLL_AGING_GCLK_SHIFT		9
#define OMAP54XX_CLKACTIVITY_L3INSTR_DLL_AGING_GCLK_MASK		(1 << 9)

/* Used by CM_L3INSTR_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3INSTR_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L3INSTR_L3_GICLK_MASK			(1 << 8)

/* Used by CM_L3MAIN1_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3MAIN1_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L3MAIN1_L3_GICLK_MASK			(1 << 8)

/* Used by CM_L3MAIN2_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L3MAIN2_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L3MAIN2_L3_GICLK_MASK			(1 << 8)

/* Used by CM_L4CFG_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L4CFG_L4_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L4CFG_L4_GICLK_MASK			(1 << 8)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L4PER_L4_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L4PER_L4_GICLK_MASK			(1 << 8)

/* Used by CM_L4SEC_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L4SEC_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_L4SEC_L3_GICLK_MASK			(1 << 8)

/* Used by CM_L4SEC_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_L4SEC_L4_GICLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_L4SEC_L4_GICLK_MASK			(1 << 9)

/* Used by CM_MIPIEXT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_MIPIEXT_L3_GICLK_SHIFT			8
#define OMAP54XX_CLKACTIVITY_MIPIEXT_L3_GICLK_MASK			(1 << 8)

/* Used by CM_MIPIEXT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_MIPIEXT_PHY_REF_GFCLK_SHIFT		11
#define OMAP54XX_CLKACTIVITY_MIPIEXT_PHY_REF_GFCLK_MASK			(1 << 11)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_MMC1_GFCLK_SHIFT				17
#define OMAP54XX_CLKACTIVITY_MMC1_GFCLK_MASK				(1 << 17)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_MMC2_GFCLK_SHIFT				18
#define OMAP54XX_CLKACTIVITY_MMC2_GFCLK_MASK				(1 << 18)

/* Used by CM_MPU_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_MPU_GCLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_MPU_GCLK_MASK				(1 << 8)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PAD_CLKS_SHIFT				14
#define OMAP54XX_CLKACTIVITY_PAD_CLKS_MASK				(1 << 14)

/* Used by CM_ABE_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PAD_SLIMBUS1_CLK_SHIFT			15
#define OMAP54XX_CLKACTIVITY_PAD_SLIMBUS1_CLK_MASK			(1 << 15)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PAD_SLIMBUS2_CLK_SHIFT			26
#define OMAP54XX_CLKACTIVITY_PAD_SLIMBUS2_CLK_MASK			(1 << 26)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PAD_XCLK60MHSP1_SHIFT			3
#define OMAP54XX_CLKACTIVITY_PAD_XCLK60MHSP1_MASK			(1 << 3)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PAD_XCLK60MHSP2_SHIFT			4
#define OMAP54XX_CLKACTIVITY_PAD_XCLK60MHSP2_MASK			(1 << 4)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PER_12M_GFCLK_SHIFT			15
#define OMAP54XX_CLKACTIVITY_PER_12M_GFCLK_MASK				(1 << 15)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PER_24M_GFCLK_SHIFT			16
#define OMAP54XX_CLKACTIVITY_PER_24M_GFCLK_MASK				(1 << 16)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PER_32K_GFCLK_SHIFT			17
#define OMAP54XX_CLKACTIVITY_PER_32K_GFCLK_MASK				(1 << 17)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PER_48M_GFCLK_SHIFT			18
#define OMAP54XX_CLKACTIVITY_PER_48M_GFCLK_MASK				(1 << 18)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PER_96M_GFCLK_SHIFT			19
#define OMAP54XX_CLKACTIVITY_PER_96M_GFCLK_MASK				(1 << 19)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_PER_ABE_24M_GFCLK_SHIFT			25
#define OMAP54XX_CLKACTIVITY_PER_ABE_24M_GFCLK_MASK			(1 << 25)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_SATA_REF_GFCLK_SHIFT			19
#define OMAP54XX_CLKACTIVITY_SATA_REF_GFCLK_MASK			(1 << 19)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_SR_CORE_SYS_GFCLK_SHIFT			11
#define OMAP54XX_CLKACTIVITY_SR_CORE_SYS_GFCLK_MASK			(1 << 11)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_SR_MM_SYS_GFCLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_SR_MM_SYS_GFCLK_MASK			(1 << 10)

/* Used by CM_COREAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_SR_MPU_SYS_GFCLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_SR_MPU_SYS_GFCLK_MASK			(1 << 9)

/* Used by CM_WKUPAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_SYS_CLK_SHIFT				8
#define OMAP54XX_CLKACTIVITY_SYS_CLK_MASK				(1 << 8)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TIMER10_GFCLK_SHIFT			9
#define OMAP54XX_CLKACTIVITY_TIMER10_GFCLK_MASK				(1 << 9)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TIMER11_GFCLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_TIMER11_GFCLK_MASK				(1 << 10)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TIMER2_GFCLK_SHIFT				11
#define OMAP54XX_CLKACTIVITY_TIMER2_GFCLK_MASK				(1 << 11)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TIMER3_GFCLK_SHIFT				12
#define OMAP54XX_CLKACTIVITY_TIMER3_GFCLK_MASK				(1 << 12)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TIMER4_GFCLK_SHIFT				13
#define OMAP54XX_CLKACTIVITY_TIMER4_GFCLK_MASK				(1 << 13)

/* Used by CM_L4PER_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TIMER9_GFCLK_SHIFT				14
#define OMAP54XX_CLKACTIVITY_TIMER9_GFCLK_MASK				(1 << 14)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TLL_CH0_GFCLK_SHIFT			22
#define OMAP54XX_CLKACTIVITY_TLL_CH0_GFCLK_MASK				(1 << 22)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TLL_CH1_GFCLK_SHIFT			23
#define OMAP54XX_CLKACTIVITY_TLL_CH1_GFCLK_MASK				(1 << 23)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_TLL_CH2_GFCLK_SHIFT			24
#define OMAP54XX_CLKACTIVITY_TLL_CH2_GFCLK_MASK				(1 << 24)

/* Used by CM_MIPIEXT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UNIPRO1_DPLL_CLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_UNIPRO1_DPLL_CLK_MASK			(1 << 10)

/* Used by CM_MIPIEXT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UNIPRO1_PHY_GFCLK_SHIFT			13
#define OMAP54XX_CLKACTIVITY_UNIPRO1_PHY_GFCLK_MASK			(1 << 13)

/* Used by CM_MIPIEXT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UNIPRO1_TXPHY_LS_GFCLK_SHIFT		12
#define OMAP54XX_CLKACTIVITY_UNIPRO1_TXPHY_LS_GFCLK_MASK		(1 << 12)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UNIPRO2_DPLL_CLK_SHIFT			10
#define OMAP54XX_CLKACTIVITY_UNIPRO2_DPLL_CLK_MASK			(1 << 10)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UNIPRO2_PHY_GFCLK_SHIFT			13
#define OMAP54XX_CLKACTIVITY_UNIPRO2_PHY_GFCLK_MASK			(1 << 13)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UNIPRO2_PHY_REF_GFCLK_SHIFT		5
#define OMAP54XX_CLKACTIVITY_UNIPRO2_PHY_REF_GFCLK_MASK			(1 << 5)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_USB_DPLL_CLK_SHIFT				14
#define OMAP54XX_CLKACTIVITY_USB_DPLL_CLK_MASK				(1 << 14)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_USB_DPLL_HS_CLK_SHIFT			15
#define OMAP54XX_CLKACTIVITY_USB_DPLL_HS_CLK_MASK			(1 << 15)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_USB_OTG_SS_REF_CLK_SHIFT			31
#define OMAP54XX_CLKACTIVITY_USB_OTG_SS_REF_CLK_MASK			(1 << 31)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UTMI_P3_GFCLK_SHIFT			30
#define OMAP54XX_CLKACTIVITY_UTMI_P3_GFCLK_MASK				(1 << 30)

/* Used by CM_L3INIT_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_UTMI_ROOT_GFCLK_SHIFT			25
#define OMAP54XX_CLKACTIVITY_UTMI_ROOT_GFCLK_MASK			(1 << 25)

/* Used by CM_WKUPAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_WKUPAON_32K_GFCLK_SHIFT			11
#define OMAP54XX_CLKACTIVITY_WKUPAON_32K_GFCLK_MASK			(1 << 11)

/* Used by CM_WKUPAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_WKUPAON_GICLK_SHIFT			12
#define OMAP54XX_CLKACTIVITY_WKUPAON_GICLK_MASK				(1 << 12)

/* Used by CM_WKUPAON_CLKSTCTRL */
#define OMAP54XX_CLKACTIVITY_WKUPAON_IO_SRCOMP_GFCLK_SHIFT		13
#define OMAP54XX_CLKACTIVITY_WKUPAON_IO_SRCOMP_GFCLK_MASK		(1 << 13)

/*
 * Used by CM_ABE_TIMER5_CLKCTRL, CM_ABE_TIMER6_CLKCTRL, CM_ABE_TIMER7_CLKCTRL,
 * CM_ABE_TIMER8_CLKCTRL, CM_L3INIT_HSI_CLKCTRL, CM_L4PER_TIMER10_CLKCTRL,
 * CM_L4PER_TIMER11_CLKCTRL, CM_L4PER_TIMER2_CLKCTRL, CM_L4PER_TIMER3_CLKCTRL,
 * CM_L4PER_TIMER4_CLKCTRL, CM_L4PER_TIMER9_CLKCTRL, CM_WKUPAON_TIMER1_CLKCTRL
 */
#define OMAP54XX_CLKSEL_SHIFT						24
#define OMAP54XX_CLKSEL_MASK						(1 << 24)

/*
 * Renamed from CLKSEL Used by CM_CLKSEL_ABE_DSS_SYS, CM_CLKSEL_ABE_PLL_REF,
 * CM_CLKSEL_USB_60MHZ, CM_CLKSEL_WKUPAON
 */
#define OMAP54XX_CLKSEL_0_0_SHIFT					0
#define OMAP54XX_CLKSEL_0_0_MASK					(1 << 0)

/* Renamed from CLKSEL Used by CM_BYPCLK_DPLL_IVA, CM_BYPCLK_DPLL_MPU */
#define OMAP54XX_CLKSEL_0_1_SHIFT					0
#define OMAP54XX_CLKSEL_0_1_MASK					(0x3 << 0)

/* Renamed from CLKSEL Used by CM_COREAON_BANDGAP_CLKCTRL */
#define OMAP54XX_CLKSEL_24_25_SHIFT					24
#define OMAP54XX_CLKSEL_24_25_MASK					(0x3 << 24)

/* Used by CM_MPU_MPU_CLKCTRL */
#define OMAP54XX_CLKSEL_ABE_DIV_MODE_SHIFT				26
#define OMAP54XX_CLKSEL_ABE_DIV_MODE_MASK				(1 << 26)

/* Used by CM_ABE_AESS_CLKCTRL */
#define OMAP54XX_CLKSEL_AESS_FCLK_SHIFT					24
#define OMAP54XX_CLKSEL_AESS_FCLK_MASK					(1 << 24)

/* Used by CM_L3INIT_MMC1_CLKCTRL, CM_L3INIT_MMC2_CLKCTRL */
#define OMAP54XX_CLKSEL_DIV_SHIFT					25
#define OMAP54XX_CLKSEL_DIV_MASK					(1 << 25)

/* Used by CM_MPU_MPU_CLKCTRL */
#define OMAP54XX_CLKSEL_EMIF_DIV_MODE_SHIFT				24
#define OMAP54XX_CLKSEL_EMIF_DIV_MODE_MASK				(0x3 << 24)

/* Used by CM_CAM_FDIF_CLKCTRL */
#define OMAP54XX_CLKSEL_FCLK_SHIFT					24
#define OMAP54XX_CLKSEL_FCLK_MASK					(1 << 24)

/* Used by CM_GPU_GPU_CLKCTRL */
#define OMAP54XX_CLKSEL_GPU_CORE_GCLK_SHIFT				24
#define OMAP54XX_CLKSEL_GPU_CORE_GCLK_MASK				(1 << 24)

/* Used by CM_GPU_GPU_CLKCTRL */
#define OMAP54XX_CLKSEL_GPU_HYD_GCLK_SHIFT				25
#define OMAP54XX_CLKSEL_GPU_HYD_GCLK_MASK				(1 << 25)

/*
 * Used by CM_ABE_DMIC_CLKCTRL, CM_ABE_MCASP_CLKCTRL, CM_ABE_MCBSP1_CLKCTRL,
 * CM_ABE_MCBSP2_CLKCTRL, CM_ABE_MCBSP3_CLKCTRL
 */
#define OMAP54XX_CLKSEL_INTERNAL_SOURCE_SHIFT				26
#define OMAP54XX_CLKSEL_INTERNAL_SOURCE_MASK				(0x3 << 26)

/* Used by CM_CLKSEL_CORE */
#define OMAP54XX_CLKSEL_L3_SHIFT					4
#define OMAP54XX_CLKSEL_L3_MASK						(1 << 4)

/* Renamed from CLKSEL_L3 Used by CM_SHADOW_FREQ_CONFIG2 */
#define OMAP54XX_CLKSEL_L3_1_1_SHIFT					1
#define OMAP54XX_CLKSEL_L3_1_1_MASK					(1 << 1)

/* Used by CM_CLKSEL_CORE */
#define OMAP54XX_CLKSEL_L4_SHIFT					8
#define OMAP54XX_CLKSEL_L4_MASK						(1 << 8)

/* Used by CM_L3INIT_UNIPRO2_CLKCTRL, CM_MIPIEXT_UNIPRO1_CLKCTRL */
#define OMAP54XX_CLKSEL_OPP_SHIFT					24
#define OMAP54XX_CLKSEL_OPP_MASK					(1 << 24)

/* Renamed from CLKSEL_OPP Used by CM_CLKSEL_ABE */
#define OMAP54XX_CLKSEL_OPP_0_1_SHIFT					0
#define OMAP54XX_CLKSEL_OPP_0_1_MASK					(0x3 << 0)

/*
 * Used by CM_ABE_DMIC_CLKCTRL, CM_ABE_MCASP_CLKCTRL, CM_ABE_MCBSP1_CLKCTRL,
 * CM_ABE_MCBSP2_CLKCTRL, CM_ABE_MCBSP3_CLKCTRL
 */
#define OMAP54XX_CLKSEL_SOURCE_SHIFT					24
#define OMAP54XX_CLKSEL_SOURCE_MASK					(0x3 << 24)

/*
 * Renamed from CLKSEL_SOURCE Used by CM_L3INIT_MMC1_CLKCTRL,
 * CM_L3INIT_MMC2_CLKCTRL
 */
#define OMAP54XX_CLKSEL_SOURCE_24_24_SHIFT				24
#define OMAP54XX_CLKSEL_SOURCE_24_24_MASK				(1 << 24)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_CLKSEL_UTMI_P1_SHIFT					24
#define OMAP54XX_CLKSEL_UTMI_P1_MASK					(1 << 24)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_CLKSEL_UTMI_P2_SHIFT					25
#define OMAP54XX_CLKSEL_UTMI_P2_MASK					(1 << 25)

/*
 * Used by CM_DIV_H11_DPLL_CORE, CM_DIV_H11_DPLL_IVA, CM_DIV_H11_DPLL_PER,
 * CM_DIV_H12_DPLL_CORE, CM_DIV_H12_DPLL_IVA, CM_DIV_H12_DPLL_PER,
 * CM_DIV_H13_DPLL_CORE, CM_DIV_H14_DPLL_CORE, CM_DIV_H14_DPLL_PER,
 * CM_DIV_H22_DPLL_CORE, CM_DIV_H23_DPLL_CORE, CM_DIV_M2_DPLL_ABE,
 * CM_DIV_M2_DPLL_CORE, CM_DIV_M2_DPLL_MPU, CM_DIV_M2_DPLL_PER,
 * CM_DIV_M2_DPLL_UNIPRO1, CM_DIV_M2_DPLL_UNIPRO2, CM_DIV_M2_DPLL_USB,
 * CM_DIV_M3_DPLL_ABE, CM_DIV_M3_DPLL_CORE, CM_DIV_M3_DPLL_PER
 */
#define OMAP54XX_CLKST_SHIFT						9
#define OMAP54XX_CLKST_MASK						(1 << 9)

/*
 * Used by CM_ABE_CLKSTCTRL, CM_C2C_CLKSTCTRL, CM_CAM_CLKSTCTRL,
 * CM_COREAON_CLKSTCTRL, CM_CUSTEFUSE_CLKSTCTRL, CM_DMA_CLKSTCTRL,
 * CM_DSP_CLKSTCTRL, CM_DSS_CLKSTCTRL, CM_EMIF_CLKSTCTRL, CM_EMU_CLKSTCTRL,
 * CM_GPU_CLKSTCTRL, CM_IPU_CLKSTCTRL, CM_IVA_CLKSTCTRL, CM_L3INIT_CLKSTCTRL,
 * CM_L3INSTR_CLKSTCTRL, CM_L3MAIN1_CLKSTCTRL, CM_L3MAIN2_CLKSTCTRL,
 * CM_L4CFG_CLKSTCTRL, CM_L4PER_CLKSTCTRL, CM_L4SEC_CLKSTCTRL,
 * CM_MIPIEXT_CLKSTCTRL, CM_MPU_CLKSTCTRL, CM_WKUPAON_CLKSTCTRL
 */
#define OMAP54XX_CLKTRCTRL_SHIFT					0
#define OMAP54XX_CLKTRCTRL_MASK						(0x3 << 0)

/* Used by CM_DIV_M2_DPLL_ABE, CM_DIV_M2_DPLL_PER */
#define OMAP54XX_CLKX2ST_SHIFT						11
#define OMAP54XX_CLKX2ST_MASK						(1 << 11)

/* Used by CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_COREAON_DYNDEP_SHIFT					16
#define OMAP54XX_COREAON_DYNDEP_MASK					(1 << 16)

/* Used by CM_DSP_STATICDEP, CM_IPU_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_COREAON_STATDEP_SHIFT					16
#define OMAP54XX_COREAON_STATDEP_MASK					(1 << 16)

/* Used by CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_CUSTEFUSE_DYNDEP_SHIFT					17
#define OMAP54XX_CUSTEFUSE_DYNDEP_MASK					(1 << 17)

/* Used by CM_DSP_STATICDEP, CM_IPU_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_CUSTEFUSE_STATDEP_SHIFT				17
#define OMAP54XX_CUSTEFUSE_STATDEP_MASK					(1 << 17)

/* Used by REVISION_CM_CORE, REVISION_CM_CORE_AON */
#define OMAP54XX_CUSTOM_SHIFT						6
#define OMAP54XX_CUSTOM_MASK						(0x3 << 6)

/*
 * Used by CM_CLKSEL_DPLL_ABE, CM_CLKSEL_DPLL_CORE, CM_CLKSEL_DPLL_IVA,
 * CM_CLKSEL_DPLL_MPU, CM_CLKSEL_DPLL_PER, CM_CLKSEL_DPLL_UNIPRO1,
 * CM_CLKSEL_DPLL_UNIPRO2, CM_CLKSEL_DPLL_USB
 */
#define OMAP54XX_DCC_EN_SHIFT						22
#define OMAP54XX_DCC_EN_MASK						(1 << 22)

/*
 * Used by CM_SSC_DELTAMSTEP_DPLL_ABE, CM_SSC_DELTAMSTEP_DPLL_CORE,
 * CM_SSC_DELTAMSTEP_DPLL_IVA, CM_SSC_DELTAMSTEP_DPLL_MPU,
 * CM_SSC_DELTAMSTEP_DPLL_PER
 */
#define OMAP54XX_DELTAMSTEP_SHIFT					0
#define OMAP54XX_DELTAMSTEP_MASK					(0xfffff << 0)

/*
 * Renamed from DELTAMSTEP Used by CM_SSC_DELTAMSTEP_DPLL_UNIPRO1,
 * CM_SSC_DELTAMSTEP_DPLL_UNIPRO2, CM_SSC_DELTAMSTEP_DPLL_USB
 */
#define OMAP54XX_DELTAMSTEP_0_20_SHIFT					0
#define OMAP54XX_DELTAMSTEP_0_20_MASK					(0x1fffff << 0)

/*
 * Used by CM_DIV_H11_DPLL_CORE, CM_DIV_H11_DPLL_IVA, CM_DIV_H11_DPLL_PER,
 * CM_DIV_H12_DPLL_CORE, CM_DIV_H12_DPLL_IVA, CM_DIV_H12_DPLL_PER,
 * CM_DIV_H13_DPLL_CORE, CM_DIV_H14_DPLL_CORE, CM_DIV_H14_DPLL_PER,
 * CM_DIV_H22_DPLL_CORE, CM_DIV_H23_DPLL_CORE
 */
#define OMAP54XX_DIVHS_SHIFT						0
#define OMAP54XX_DIVHS_MASK						(0x3f << 0)

/*
 * Renamed from DIVHS Used by CM_DIV_M2_DPLL_ABE, CM_DIV_M2_DPLL_CORE,
 * CM_DIV_M2_DPLL_MPU, CM_DIV_M2_DPLL_PER, CM_DIV_M3_DPLL_ABE,
 * CM_DIV_M3_DPLL_CORE, CM_DIV_M3_DPLL_PER
 */
#define OMAP54XX_DIVHS_0_4_SHIFT					0
#define OMAP54XX_DIVHS_0_4_MASK						(0x1f << 0)

/*
 * Renamed from DIVHS Used by CM_DIV_M2_DPLL_UNIPRO1, CM_DIV_M2_DPLL_UNIPRO2,
 * CM_DIV_M2_DPLL_USB
 */
#define OMAP54XX_DIVHS_0_6_SHIFT					0
#define OMAP54XX_DIVHS_0_6_MASK						(0x7f << 0)

/* Used by CM_DLL_CTRL */
#define OMAP54XX_DLL_OVERRIDE_SHIFT					0
#define OMAP54XX_DLL_OVERRIDE_MASK					(1 << 0)

/* Renamed from DLL_OVERRIDE Used by CM_SHADOW_FREQ_CONFIG1 */
#define OMAP54XX_DLL_OVERRIDE_2_2_SHIFT					2
#define OMAP54XX_DLL_OVERRIDE_2_2_MASK					(1 << 2)

/* Used by CM_SHADOW_FREQ_CONFIG1 */
#define OMAP54XX_DLL_RESET_SHIFT					3
#define OMAP54XX_DLL_RESET_MASK						(1 << 3)

/*
 * Used by CM_CLKSEL_DPLL_ABE, CM_CLKSEL_DPLL_CORE, CM_CLKSEL_DPLL_IVA,
 * CM_CLKSEL_DPLL_MPU, CM_CLKSEL_DPLL_PER, CM_CLKSEL_DPLL_UNIPRO1,
 * CM_CLKSEL_DPLL_UNIPRO2, CM_CLKSEL_DPLL_USB
 */
#define OMAP54XX_DPLL_BYP_CLKSEL_SHIFT					23
#define OMAP54XX_DPLL_BYP_CLKSEL_MASK					(1 << 23)

/* Used by CM_CLKSEL_DPLL_CORE */
#define OMAP54XX_DPLL_CLKOUTHIF_CLKSEL_SHIFT				20
#define OMAP54XX_DPLL_CLKOUTHIF_CLKSEL_MASK				(1 << 20)

/* Used by CM_SHADOW_FREQ_CONFIG1 */
#define OMAP54XX_DPLL_CORE_DPLL_EN_SHIFT				8
#define OMAP54XX_DPLL_CORE_DPLL_EN_MASK					(0x7 << 8)

/* Used by CM_SHADOW_FREQ_CONFIG2 */
#define OMAP54XX_DPLL_CORE_H12_DIV_SHIFT				2
#define OMAP54XX_DPLL_CORE_H12_DIV_MASK					(0x3f << 2)

/* Used by CM_SHADOW_FREQ_CONFIG1 */
#define OMAP54XX_DPLL_CORE_M2_DIV_SHIFT					11
#define OMAP54XX_DPLL_CORE_M2_DIV_MASK					(0x1f << 11)

/*
 * Used by CM_CLKSEL_DPLL_ABE, CM_CLKSEL_DPLL_CORE, CM_CLKSEL_DPLL_IVA,
 * CM_CLKSEL_DPLL_MPU, CM_CLKSEL_DPLL_PER
 */
#define OMAP54XX_DPLL_DIV_SHIFT						0
#define OMAP54XX_DPLL_DIV_MASK						(0x7f << 0)

/*
 * Renamed from DPLL_DIV Used by CM_CLKSEL_DPLL_UNIPRO1,
 * CM_CLKSEL_DPLL_UNIPRO2, CM_CLKSEL_DPLL_USB
 */
#define OMAP54XX_DPLL_DIV_0_7_SHIFT					0
#define OMAP54XX_DPLL_DIV_0_7_MASK					(0xff << 0)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER
 */
#define OMAP54XX_DPLL_DRIFTGUARD_EN_SHIFT				8
#define OMAP54XX_DPLL_DRIFTGUARD_EN_MASK				(1 << 8)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER, CM_CLKMODE_DPLL_UNIPRO1,
 * CM_CLKMODE_DPLL_UNIPRO2, CM_CLKMODE_DPLL_USB
 */
#define OMAP54XX_DPLL_EN_SHIFT						0
#define OMAP54XX_DPLL_EN_MASK						(0x7 << 0)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER
 */
#define OMAP54XX_DPLL_LPMODE_EN_SHIFT					10
#define OMAP54XX_DPLL_LPMODE_EN_MASK					(1 << 10)

/*
 * Used by CM_CLKSEL_DPLL_ABE, CM_CLKSEL_DPLL_CORE, CM_CLKSEL_DPLL_IVA,
 * CM_CLKSEL_DPLL_MPU, CM_CLKSEL_DPLL_PER
 */
#define OMAP54XX_DPLL_MULT_SHIFT					8
#define OMAP54XX_DPLL_MULT_MASK						(0x7ff << 8)

/*
 * Renamed from DPLL_MULT Used by CM_CLKSEL_DPLL_UNIPRO1,
 * CM_CLKSEL_DPLL_UNIPRO2, CM_CLKSEL_DPLL_USB
 */
#define OMAP54XX_DPLL_MULT_UNIPRO1_SHIFT				8
#define OMAP54XX_DPLL_MULT_UNIPRO1_MASK					(0xfff << 8)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER
 */
#define OMAP54XX_DPLL_REGM4XEN_SHIFT					11
#define OMAP54XX_DPLL_REGM4XEN_MASK					(1 << 11)

/* Used by CM_CLKSEL_DPLL_UNIPRO1, CM_CLKSEL_DPLL_UNIPRO2, CM_CLKSEL_DPLL_USB */
#define OMAP54XX_DPLL_SD_DIV_SHIFT					24
#define OMAP54XX_DPLL_SD_DIV_MASK					(0xff << 24)

/* Used by CM_CLKSEL_DPLL_UNIPRO1, CM_CLKSEL_DPLL_UNIPRO2, CM_CLKSEL_DPLL_USB */
#define OMAP54XX_DPLL_SELFREQDCO_SHIFT					21
#define OMAP54XX_DPLL_SELFREQDCO_MASK					(1 << 21)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER, CM_CLKMODE_DPLL_UNIPRO1,
 * CM_CLKMODE_DPLL_UNIPRO2, CM_CLKMODE_DPLL_USB
 */
#define OMAP54XX_DPLL_SSC_ACK_SHIFT					13
#define OMAP54XX_DPLL_SSC_ACK_MASK					(1 << 13)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER, CM_CLKMODE_DPLL_UNIPRO1,
 * CM_CLKMODE_DPLL_UNIPRO2, CM_CLKMODE_DPLL_USB
 */
#define OMAP54XX_DPLL_SSC_DOWNSPREAD_SHIFT				14
#define OMAP54XX_DPLL_SSC_DOWNSPREAD_MASK				(1 << 14)

/*
 * Used by CM_CLKMODE_DPLL_ABE, CM_CLKMODE_DPLL_CORE, CM_CLKMODE_DPLL_IVA,
 * CM_CLKMODE_DPLL_MPU, CM_CLKMODE_DPLL_PER, CM_CLKMODE_DPLL_UNIPRO1,
 * CM_CLKMODE_DPLL_UNIPRO2, CM_CLKMODE_DPLL_USB
 */
#define OMAP54XX_DPLL_SSC_EN_SHIFT					12
#define OMAP54XX_DPLL_SSC_EN_MASK					(1 << 12)

/* Used by CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_DSP_DYNDEP_SHIFT					1
#define OMAP54XX_DSP_DYNDEP_MASK					(1 << 1)

/* Used by CM_IPU_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_DSP_STATDEP_SHIFT					1
#define OMAP54XX_DSP_STATDEP_MASK					(1 << 1)

/* Used by CM_L3MAIN2_DYNAMICDEP, CM_L4CFG_DYNAMICDEP, CM_L4PER_DYNAMICDEP */
#define OMAP54XX_DSS_DYNDEP_SHIFT					8
#define OMAP54XX_DSS_DYNDEP_MASK					(1 << 8)

/* Used by CM_DMA_STATICDEP, CM_IPU_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_DSS_STATDEP_SHIFT					8
#define OMAP54XX_DSS_STATDEP_MASK					(1 << 8)

/*
 * Used by CM_C2C_DYNAMICDEP, CM_L3MAIN1_DYNAMICDEP, CM_L4CFG_DYNAMICDEP,
 * CM_MIPIEXT_DYNAMICDEP, CM_MPU_DYNAMICDEP
 */
#define OMAP54XX_EMIF_DYNDEP_SHIFT					4
#define OMAP54XX_EMIF_DYNDEP_MASK					(1 << 4)

/*
 * Used by CM_C2C_STATICDEP, CM_CAM_STATICDEP, CM_DMA_STATICDEP,
 * CM_DSP_STATICDEP, CM_DSS_STATICDEP, CM_GPU_STATICDEP, CM_IPU_STATICDEP,
 * CM_IVA_STATICDEP, CM_L3INIT_STATICDEP, CM_L4SEC_STATICDEP,
 * CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_EMIF_STATDEP_SHIFT					4
#define OMAP54XX_EMIF_STATDEP_MASK					(1 << 4)

/* Used by CM_SHADOW_FREQ_CONFIG1 */
#define OMAP54XX_FREQ_UPDATE_SHIFT					0
#define OMAP54XX_FREQ_UPDATE_MASK					(1 << 0)

/* Used by REVISION_CM_CORE, REVISION_CM_CORE_AON */
#define OMAP54XX_FUNC_SHIFT						16
#define OMAP54XX_FUNC_MASK						(0xfff << 16)

/* Used by CM_SHADOW_FREQ_CONFIG2 */
#define OMAP54XX_GPMC_FREQ_UPDATE_SHIFT					0
#define OMAP54XX_GPMC_FREQ_UPDATE_MASK					(1 << 0)

/* Used by CM_L3MAIN2_DYNAMICDEP */
#define OMAP54XX_GPU_DYNDEP_SHIFT					10
#define OMAP54XX_GPU_DYNDEP_MASK					(1 << 10)

/* Used by CM_IPU_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_GPU_STATDEP_SHIFT					10
#define OMAP54XX_GPU_STATDEP_MASK					(1 << 10)

/*
 * Used by CM_ABE_AESS_CLKCTRL, CM_ABE_DMIC_CLKCTRL, CM_ABE_L4_ABE_CLKCTRL,
 * CM_ABE_MCASP_CLKCTRL, CM_ABE_MCBSP1_CLKCTRL, CM_ABE_MCBSP2_CLKCTRL,
 * CM_ABE_MCBSP3_CLKCTRL, CM_ABE_MCPDM_CLKCTRL, CM_ABE_SLIMBUS1_CLKCTRL,
 * CM_ABE_TIMER5_CLKCTRL, CM_ABE_TIMER6_CLKCTRL, CM_ABE_TIMER7_CLKCTRL,
 * CM_ABE_TIMER8_CLKCTRL, CM_ABE_WD_TIMER3_CLKCTRL, CM_C2C_C2C_CLKCTRL,
 * CM_C2C_C2C_OCP_FW_CLKCTRL, CM_C2C_MODEM_ICR_CLKCTRL, CM_CAM_CAL_CLKCTRL,
 * CM_CAM_FDIF_CLKCTRL, CM_CAM_ISS_CLKCTRL, CM_CM_CORE_AON_PROFILING_CLKCTRL,
 * CM_CM_CORE_PROFILING_CLKCTRL, CM_COREAON_SMARTREFLEX_CORE_CLKCTRL,
 * CM_COREAON_SMARTREFLEX_MM_CLKCTRL, CM_COREAON_SMARTREFLEX_MPU_CLKCTRL,
 * CM_CUSTEFUSE_EFUSE_CTRL_CUST_CLKCTRL, CM_DMA_DMA_SYSTEM_CLKCTRL,
 * CM_DSP_DSP_CLKCTRL, CM_DSS_BB2D_CLKCTRL, CM_DSS_DSS_CLKCTRL,
 * CM_EMIF_DMM_CLKCTRL, CM_EMIF_EMIF1_CLKCTRL, CM_EMIF_EMIF2_CLKCTRL,
 * CM_EMIF_EMIF_OCP_FW_CLKCTRL, CM_EMU_DEBUGSS_CLKCTRL, CM_GPU_GPU_CLKCTRL,
 * CM_IPU_IPU_CLKCTRL, CM_IVA_IVA_CLKCTRL, CM_IVA_SL2_CLKCTRL,
 * CM_L3INIT_HSI_CLKCTRL, CM_L3INIT_IEEE1500_2_OCP_CLKCTRL,
 * CM_L3INIT_MMC1_CLKCTRL, CM_L3INIT_MMC2_CLKCTRL,
 * CM_L3INIT_MPHY_UNIPRO2_CLKCTRL, CM_L3INIT_OCP2SCP1_CLKCTRL,
 * CM_L3INIT_OCP2SCP3_CLKCTRL, CM_L3INIT_SATA_CLKCTRL,
 * CM_L3INIT_UNIPRO2_CLKCTRL, CM_L3INIT_USB_HOST_HS_CLKCTRL,
 * CM_L3INIT_USB_OTG_SS_CLKCTRL, CM_L3INIT_USB_TLL_HS_CLKCTRL,
 * CM_L3INSTR_DLL_AGING_CLKCTRL, CM_L3INSTR_L3_INSTR_CLKCTRL,
 * CM_L3INSTR_L3_MAIN_3_CLKCTRL, CM_L3INSTR_OCP_WP_NOC_CLKCTRL,
 * CM_L3MAIN1_L3_MAIN_1_CLKCTRL, CM_L3MAIN2_GPMC_CLKCTRL,
 * CM_L3MAIN2_L3_MAIN_2_CLKCTRL, CM_L3MAIN2_OCMC_RAM_CLKCTRL,
 * CM_L4CFG_L4_CFG_CLKCTRL, CM_L4CFG_MAILBOX_CLKCTRL,
 * CM_L4CFG_OCP2SCP2_CLKCTRL, CM_L4CFG_SAR_ROM_CLKCTRL,
 * CM_L4CFG_SPINLOCK_CLKCTRL, CM_L4PER_ELM_CLKCTRL, CM_L4PER_GPIO2_CLKCTRL,
 * CM_L4PER_GPIO3_CLKCTRL, CM_L4PER_GPIO4_CLKCTRL, CM_L4PER_GPIO5_CLKCTRL,
 * CM_L4PER_GPIO6_CLKCTRL, CM_L4PER_GPIO7_CLKCTRL, CM_L4PER_GPIO8_CLKCTRL,
 * CM_L4PER_HDQ1W_CLKCTRL, CM_L4PER_I2C1_CLKCTRL, CM_L4PER_I2C2_CLKCTRL,
 * CM_L4PER_I2C3_CLKCTRL, CM_L4PER_I2C4_CLKCTRL, CM_L4PER_I2C5_CLKCTRL,
 * CM_L4PER_L4_PER_CLKCTRL, CM_L4PER_MCSPI1_CLKCTRL, CM_L4PER_MCSPI2_CLKCTRL,
 * CM_L4PER_MCSPI3_CLKCTRL, CM_L4PER_MCSPI4_CLKCTRL, CM_L4PER_MMC3_CLKCTRL,
 * CM_L4PER_MMC4_CLKCTRL, CM_L4PER_MMC5_CLKCTRL, CM_L4PER_SLIMBUS2_CLKCTRL,
 * CM_L4PER_TIMER10_CLKCTRL, CM_L4PER_TIMER11_CLKCTRL, CM_L4PER_TIMER2_CLKCTRL,
 * CM_L4PER_TIMER3_CLKCTRL, CM_L4PER_TIMER4_CLKCTRL, CM_L4PER_TIMER9_CLKCTRL,
 * CM_L4PER_UART1_CLKCTRL, CM_L4PER_UART2_CLKCTRL, CM_L4PER_UART3_CLKCTRL,
 * CM_L4PER_UART4_CLKCTRL, CM_L4PER_UART5_CLKCTRL, CM_L4PER_UART6_CLKCTRL,
 * CM_L4SEC_AES1_CLKCTRL, CM_L4SEC_AES2_CLKCTRL, CM_L4SEC_DES3DES_CLKCTRL,
 * CM_L4SEC_DMA_CRYPTO_CLKCTRL, CM_L4SEC_FPKA_CLKCTRL, CM_L4SEC_RNG_CLKCTRL,
 * CM_L4SEC_SHA2MD5_CLKCTRL, CM_MIPIEXT_LLI_CLKCTRL,
 * CM_MIPIEXT_LLI_OCP_FW_CLKCTRL, CM_MIPIEXT_MPHY_CLKCTRL,
 * CM_MIPIEXT_UNIPRO1_CLKCTRL, CM_MPU_MPU_CLKCTRL,
 * CM_WKUPAON_COUNTER_32K_CLKCTRL, CM_WKUPAON_GPIO1_CLKCTRL,
 * CM_WKUPAON_KBD_CLKCTRL, CM_WKUPAON_L4_WKUP_CLKCTRL,
 * CM_WKUPAON_SAR_RAM_CLKCTRL, CM_WKUPAON_TIMER12_CLKCTRL,
 * CM_WKUPAON_TIMER1_CLKCTRL, CM_WKUPAON_WD_TIMER1_CLKCTRL,
 * CM_WKUPAON_WD_TIMER2_CLKCTRL
 */
#define OMAP54XX_IDLEST_SHIFT						16
#define OMAP54XX_IDLEST_MASK						(0x3 << 16)

/* Used by CM_L3MAIN2_DYNAMICDEP */
#define OMAP54XX_IPU_DYNDEP_SHIFT					0
#define OMAP54XX_IPU_DYNDEP_MASK					(1 << 0)

/* Used by CM_DMA_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_IPU_STATDEP_SHIFT					0
#define OMAP54XX_IPU_STATDEP_MASK					(1 << 0)

/* Used by CM_DSP_DYNAMICDEP, CM_L3MAIN2_DYNAMICDEP */
#define OMAP54XX_IVA_DYNDEP_SHIFT					2
#define OMAP54XX_IVA_DYNDEP_MASK					(1 << 2)

/*
 * Used by CM_C2C_STATICDEP, CM_CAM_STATICDEP, CM_DMA_STATICDEP,
 * CM_DSP_STATICDEP, CM_DSS_STATICDEP, CM_GPU_STATICDEP, CM_IPU_STATICDEP,
 * CM_L3INIT_STATICDEP, CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_IVA_STATDEP_SHIFT					2
#define OMAP54XX_IVA_STATDEP_MASK					(1 << 2)

/* Used by CM_L4CFG_DYNAMICDEP, CM_L4PER_DYNAMICDEP */
#define OMAP54XX_L3INIT_DYNDEP_SHIFT					7
#define OMAP54XX_L3INIT_DYNDEP_MASK					(1 << 7)

/*
 * Used by CM_C2C_STATICDEP, CM_DMA_STATICDEP, CM_DSP_STATICDEP,
 * CM_IPU_STATICDEP, CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_L3INIT_STATDEP_SHIFT					7
#define OMAP54XX_L3INIT_STATDEP_MASK					(1 << 7)

/*
 * Used by CM_DSP_DYNAMICDEP, CM_DSS_DYNAMICDEP, CM_L3INIT_DYNAMICDEP,
 * CM_L3MAIN2_DYNAMICDEP, CM_L4CFG_DYNAMICDEP, CM_MPU_DYNAMICDEP
 */
#define OMAP54XX_L3MAIN1_DYNDEP_SHIFT					5
#define OMAP54XX_L3MAIN1_DYNDEP_MASK					(1 << 5)

/*
 * Used by CM_C2C_STATICDEP, CM_CAM_STATICDEP, CM_DMA_STATICDEP,
 * CM_DSP_STATICDEP, CM_DSS_STATICDEP, CM_GPU_STATICDEP, CM_IPU_STATICDEP,
 * CM_IVA_STATICDEP, CM_L3INIT_STATICDEP, CM_L4SEC_STATICDEP,
 * CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_L3MAIN1_STATDEP_SHIFT					5
#define OMAP54XX_L3MAIN1_STATDEP_MASK					(1 << 5)

/*
 * Used by CM_C2C_DYNAMICDEP, CM_CAM_DYNAMICDEP, CM_DMA_DYNAMICDEP,
 * CM_DSS_DYNAMICDEP, CM_EMU_DYNAMICDEP, CM_GPU_DYNAMICDEP, CM_IPU_DYNAMICDEP,
 * CM_IVA_DYNAMICDEP, CM_L3INIT_DYNAMICDEP, CM_L3MAIN1_DYNAMICDEP,
 * CM_L4CFG_DYNAMICDEP, CM_L4SEC_DYNAMICDEP, CM_MIPIEXT_DYNAMICDEP
 */
#define OMAP54XX_L3MAIN2_DYNDEP_SHIFT					6
#define OMAP54XX_L3MAIN2_DYNDEP_MASK					(1 << 6)

/*
 * Used by CM_C2C_STATICDEP, CM_CAM_STATICDEP, CM_DMA_STATICDEP,
 * CM_DSP_STATICDEP, CM_DSS_STATICDEP, CM_GPU_STATICDEP, CM_IPU_STATICDEP,
 * CM_IVA_STATICDEP, CM_L3INIT_STATICDEP, CM_L4SEC_STATICDEP,
 * CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_L3MAIN2_STATDEP_SHIFT					6
#define OMAP54XX_L3MAIN2_STATDEP_MASK					(1 << 6)

/* Used by CM_L3MAIN1_DYNAMICDEP */
#define OMAP54XX_L4CFG_DYNDEP_SHIFT					12
#define OMAP54XX_L4CFG_DYNDEP_MASK					(1 << 12)

/*
 * Used by CM_C2C_STATICDEP, CM_DMA_STATICDEP, CM_DSP_STATICDEP,
 * CM_IPU_STATICDEP, CM_L3INIT_STATICDEP, CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_L4CFG_STATDEP_SHIFT					12
#define OMAP54XX_L4CFG_STATDEP_MASK					(1 << 12)

/* Used by CM_L3MAIN2_DYNAMICDEP */
#define OMAP54XX_L4PER_DYNDEP_SHIFT					13
#define OMAP54XX_L4PER_DYNDEP_MASK					(1 << 13)

/*
 * Used by CM_C2C_STATICDEP, CM_DMA_STATICDEP, CM_DSP_STATICDEP,
 * CM_IPU_STATICDEP, CM_L3INIT_STATICDEP, CM_L4SEC_STATICDEP,
 * CM_MIPIEXT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_L4PER_STATDEP_SHIFT					13
#define OMAP54XX_L4PER_STATDEP_MASK					(1 << 13)

/* Used by CM_L3MAIN2_DYNAMICDEP, CM_L4PER_DYNAMICDEP */
#define OMAP54XX_L4SEC_DYNDEP_SHIFT					14
#define OMAP54XX_L4SEC_DYNDEP_MASK					(1 << 14)

/*
 * Used by CM_DMA_STATICDEP, CM_IPU_STATICDEP, CM_L3INIT_STATICDEP,
 * CM_MPU_STATICDEP
 */
#define OMAP54XX_L4SEC_STATDEP_SHIFT					14
#define OMAP54XX_L4SEC_STATDEP_MASK					(1 << 14)

/* Used by CM_L3MAIN2_DYNAMICDEP, CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_MIPIEXT_DYNDEP_SHIFT					21
#define OMAP54XX_MIPIEXT_DYNDEP_MASK					(1 << 21)

/* Used by CM_MPU_STATICDEP */
#define OMAP54XX_MIPIEXT_STATDEP_SHIFT					21
#define OMAP54XX_MIPIEXT_STATDEP_MASK					(1 << 21)

/*
 * Used by CM_SSC_MODFREQDIV_DPLL_ABE, CM_SSC_MODFREQDIV_DPLL_CORE,
 * CM_SSC_MODFREQDIV_DPLL_IVA, CM_SSC_MODFREQDIV_DPLL_MPU,
 * CM_SSC_MODFREQDIV_DPLL_PER, CM_SSC_MODFREQDIV_DPLL_UNIPRO1,
 * CM_SSC_MODFREQDIV_DPLL_UNIPRO2, CM_SSC_MODFREQDIV_DPLL_USB
 */
#define OMAP54XX_MODFREQDIV_EXPONENT_SHIFT				8
#define OMAP54XX_MODFREQDIV_EXPONENT_MASK				(0x7 << 8)

/*
 * Used by CM_SSC_MODFREQDIV_DPLL_ABE, CM_SSC_MODFREQDIV_DPLL_CORE,
 * CM_SSC_MODFREQDIV_DPLL_IVA, CM_SSC_MODFREQDIV_DPLL_MPU,
 * CM_SSC_MODFREQDIV_DPLL_PER, CM_SSC_MODFREQDIV_DPLL_UNIPRO1,
 * CM_SSC_MODFREQDIV_DPLL_UNIPRO2, CM_SSC_MODFREQDIV_DPLL_USB
 */
#define OMAP54XX_MODFREQDIV_MANTISSA_SHIFT				0
#define OMAP54XX_MODFREQDIV_MANTISSA_MASK				(0x7f << 0)

/*
 * Used by CM_ABE_AESS_CLKCTRL, CM_ABE_DMIC_CLKCTRL, CM_ABE_L4_ABE_CLKCTRL,
 * CM_ABE_MCASP_CLKCTRL, CM_ABE_MCBSP1_CLKCTRL, CM_ABE_MCBSP2_CLKCTRL,
 * CM_ABE_MCBSP3_CLKCTRL, CM_ABE_MCPDM_CLKCTRL, CM_ABE_SLIMBUS1_CLKCTRL,
 * CM_ABE_TIMER5_CLKCTRL, CM_ABE_TIMER6_CLKCTRL, CM_ABE_TIMER7_CLKCTRL,
 * CM_ABE_TIMER8_CLKCTRL, CM_ABE_WD_TIMER3_CLKCTRL, CM_C2C_C2C_CLKCTRL,
 * CM_C2C_C2C_OCP_FW_CLKCTRL, CM_C2C_MODEM_ICR_CLKCTRL, CM_CAM_CAL_CLKCTRL,
 * CM_CAM_FDIF_CLKCTRL, CM_CAM_ISS_CLKCTRL, CM_CM_CORE_AON_PROFILING_CLKCTRL,
 * CM_CM_CORE_PROFILING_CLKCTRL, CM_COREAON_SMARTREFLEX_CORE_CLKCTRL,
 * CM_COREAON_SMARTREFLEX_MM_CLKCTRL, CM_COREAON_SMARTREFLEX_MPU_CLKCTRL,
 * CM_CUSTEFUSE_EFUSE_CTRL_CUST_CLKCTRL, CM_DMA_DMA_SYSTEM_CLKCTRL,
 * CM_DSP_DSP_CLKCTRL, CM_DSS_BB2D_CLKCTRL, CM_DSS_DSS_CLKCTRL,
 * CM_EMIF_DMM_CLKCTRL, CM_EMIF_EMIF1_CLKCTRL, CM_EMIF_EMIF2_CLKCTRL,
 * CM_EMIF_EMIF_OCP_FW_CLKCTRL, CM_EMU_DEBUGSS_CLKCTRL, CM_GPU_GPU_CLKCTRL,
 * CM_IPU_IPU_CLKCTRL, CM_IVA_IVA_CLKCTRL, CM_IVA_SL2_CLKCTRL,
 * CM_L3INIT_HSI_CLKCTRL, CM_L3INIT_IEEE1500_2_OCP_CLKCTRL,
 * CM_L3INIT_MMC1_CLKCTRL, CM_L3INIT_MMC2_CLKCTRL,
 * CM_L3INIT_MPHY_UNIPRO2_CLKCTRL, CM_L3INIT_OCP2SCP1_CLKCTRL,
 * CM_L3INIT_OCP2SCP3_CLKCTRL, CM_L3INIT_SATA_CLKCTRL,
 * CM_L3INIT_UNIPRO2_CLKCTRL, CM_L3INIT_USB_HOST_HS_CLKCTRL,
 * CM_L3INIT_USB_OTG_SS_CLKCTRL, CM_L3INIT_USB_TLL_HS_CLKCTRL,
 * CM_L3INSTR_DLL_AGING_CLKCTRL, CM_L3INSTR_L3_INSTR_CLKCTRL,
 * CM_L3INSTR_L3_MAIN_3_CLKCTRL, CM_L3INSTR_OCP_WP_NOC_CLKCTRL,
 * CM_L3MAIN1_L3_MAIN_1_CLKCTRL, CM_L3MAIN2_GPMC_CLKCTRL,
 * CM_L3MAIN2_L3_MAIN_2_CLKCTRL, CM_L3MAIN2_OCMC_RAM_CLKCTRL,
 * CM_L4CFG_L4_CFG_CLKCTRL, CM_L4CFG_MAILBOX_CLKCTRL,
 * CM_L4CFG_OCP2SCP2_CLKCTRL, CM_L4CFG_SAR_ROM_CLKCTRL,
 * CM_L4CFG_SPINLOCK_CLKCTRL, CM_L4PER_ELM_CLKCTRL, CM_L4PER_GPIO2_CLKCTRL,
 * CM_L4PER_GPIO3_CLKCTRL, CM_L4PER_GPIO4_CLKCTRL, CM_L4PER_GPIO5_CLKCTRL,
 * CM_L4PER_GPIO6_CLKCTRL, CM_L4PER_GPIO7_CLKCTRL, CM_L4PER_GPIO8_CLKCTRL,
 * CM_L4PER_HDQ1W_CLKCTRL, CM_L4PER_I2C1_CLKCTRL, CM_L4PER_I2C2_CLKCTRL,
 * CM_L4PER_I2C3_CLKCTRL, CM_L4PER_I2C4_CLKCTRL, CM_L4PER_I2C5_CLKCTRL,
 * CM_L4PER_L4_PER_CLKCTRL, CM_L4PER_MCSPI1_CLKCTRL, CM_L4PER_MCSPI2_CLKCTRL,
 * CM_L4PER_MCSPI3_CLKCTRL, CM_L4PER_MCSPI4_CLKCTRL, CM_L4PER_MMC3_CLKCTRL,
 * CM_L4PER_MMC4_CLKCTRL, CM_L4PER_MMC5_CLKCTRL, CM_L4PER_SLIMBUS2_CLKCTRL,
 * CM_L4PER_TIMER10_CLKCTRL, CM_L4PER_TIMER11_CLKCTRL, CM_L4PER_TIMER2_CLKCTRL,
 * CM_L4PER_TIMER3_CLKCTRL, CM_L4PER_TIMER4_CLKCTRL, CM_L4PER_TIMER9_CLKCTRL,
 * CM_L4PER_UART1_CLKCTRL, CM_L4PER_UART2_CLKCTRL, CM_L4PER_UART3_CLKCTRL,
 * CM_L4PER_UART4_CLKCTRL, CM_L4PER_UART5_CLKCTRL, CM_L4PER_UART6_CLKCTRL,
 * CM_L4SEC_AES1_CLKCTRL, CM_L4SEC_AES2_CLKCTRL, CM_L4SEC_DES3DES_CLKCTRL,
 * CM_L4SEC_DMA_CRYPTO_CLKCTRL, CM_L4SEC_FPKA_CLKCTRL, CM_L4SEC_RNG_CLKCTRL,
 * CM_L4SEC_SHA2MD5_CLKCTRL, CM_MIPIEXT_LLI_CLKCTRL,
 * CM_MIPIEXT_LLI_OCP_FW_CLKCTRL, CM_MIPIEXT_MPHY_CLKCTRL,
 * CM_MIPIEXT_UNIPRO1_CLKCTRL, CM_MPU_MPU_CLKCTRL,
 * CM_WKUPAON_COUNTER_32K_CLKCTRL, CM_WKUPAON_GPIO1_CLKCTRL,
 * CM_WKUPAON_KBD_CLKCTRL, CM_WKUPAON_L4_WKUP_CLKCTRL,
 * CM_WKUPAON_SAR_RAM_CLKCTRL, CM_WKUPAON_TIMER12_CLKCTRL,
 * CM_WKUPAON_TIMER1_CLKCTRL, CM_WKUPAON_WD_TIMER1_CLKCTRL,
 * CM_WKUPAON_WD_TIMER2_CLKCTRL
 */
#define OMAP54XX_MODULEMODE_SHIFT					0
#define OMAP54XX_MODULEMODE_MASK					(0x3 << 0)

/* Used by CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_MPU_DYNDEP_SHIFT					19
#define OMAP54XX_MPU_DYNDEP_MASK					(1 << 19)

/* Used by CM_DSS_DSS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_32KHZ_CLK_SHIFT				11
#define OMAP54XX_OPTFCLKEN_32KHZ_CLK_MASK				(1 << 11)

/* Used by CM_DSS_DSS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_48MHZ_CLK_SHIFT				9
#define OMAP54XX_OPTFCLKEN_48MHZ_CLK_MASK				(1 << 9)

/* Used by CM_COREAON_USB_PHY_CORE_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_CLK32K_SHIFT					8
#define OMAP54XX_OPTFCLKEN_CLK32K_MASK					(1 << 8)

/* Used by CM_CAM_ISS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_CTRLCLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_CTRLCLK_MASK					(1 << 8)

/*
 * Used by CM_L4PER_GPIO2_CLKCTRL, CM_L4PER_GPIO3_CLKCTRL,
 * CM_L4PER_GPIO4_CLKCTRL, CM_L4PER_GPIO5_CLKCTRL, CM_L4PER_GPIO6_CLKCTRL,
 * CM_L4PER_GPIO7_CLKCTRL, CM_L4PER_GPIO8_CLKCTRL, CM_WKUPAON_GPIO1_CLKCTRL
 */
#define OMAP54XX_OPTFCLKEN_DBCLK_SHIFT					8
#define OMAP54XX_OPTFCLKEN_DBCLK_MASK					(1 << 8)

/* Used by CM_EMIF_EMIF_DLL_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_DLL_CLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_DLL_CLK_MASK					(1 << 8)

/* Used by CM_DSS_DSS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_DSSCLK_SHIFT					8
#define OMAP54XX_OPTFCLKEN_DSSCLK_MASK					(1 << 8)

/* Used by CM_ABE_SLIMBUS1_CLKCTRL, CM_L4PER_SLIMBUS2_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_FCLK0_SHIFT					8
#define OMAP54XX_OPTFCLKEN_FCLK0_MASK					(1 << 8)

/* Used by CM_ABE_SLIMBUS1_CLKCTRL, CM_L4PER_SLIMBUS2_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_FCLK1_SHIFT					9
#define OMAP54XX_OPTFCLKEN_FCLK1_MASK					(1 << 9)

/* Used by CM_ABE_SLIMBUS1_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_FCLK2_SHIFT					10
#define OMAP54XX_OPTFCLKEN_FCLK2_MASK					(1 << 10)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_FUNC48M_CLK_SHIFT				15
#define OMAP54XX_OPTFCLKEN_FUNC48M_CLK_MASK				(1 << 15)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_HSIC480M_P1_CLK_SHIFT			13
#define OMAP54XX_OPTFCLKEN_HSIC480M_P1_CLK_MASK				(1 << 13)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_HSIC480M_P2_CLK_SHIFT			14
#define OMAP54XX_OPTFCLKEN_HSIC480M_P2_CLK_MASK				(1 << 14)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_HSIC480M_P3_CLK_SHIFT			7
#define OMAP54XX_OPTFCLKEN_HSIC480M_P3_CLK_MASK				(1 << 7)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_HSIC60M_P1_CLK_SHIFT				11
#define OMAP54XX_OPTFCLKEN_HSIC60M_P1_CLK_MASK				(1 << 11)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_HSIC60M_P2_CLK_SHIFT				12
#define OMAP54XX_OPTFCLKEN_HSIC60M_P2_CLK_MASK				(1 << 12)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_HSIC60M_P3_CLK_SHIFT				6
#define OMAP54XX_OPTFCLKEN_HSIC60M_P3_CLK_MASK				(1 << 6)

/* Used by CM_L3INIT_USB_OTG_SS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_REFCLK960M_SHIFT				8
#define OMAP54XX_OPTFCLKEN_REFCLK960M_MASK				(1 << 8)

/* Used by CM_L3INIT_SATA_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_REF_CLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_REF_CLK_MASK					(1 << 8)

/* Used by CM_WKUPAON_SCRM_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_SCRM_CORE_SHIFT				8
#define OMAP54XX_OPTFCLKEN_SCRM_CORE_MASK				(1 << 8)

/* Used by CM_WKUPAON_SCRM_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_SCRM_PER_SHIFT				9
#define OMAP54XX_OPTFCLKEN_SCRM_PER_MASK				(1 << 9)

/* Used by CM_ABE_SLIMBUS1_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_SLIMBUS_CLK_SHIFT				11
#define OMAP54XX_OPTFCLKEN_SLIMBUS_CLK_MASK				(1 << 11)

/* Renamed from OPTFCLKEN_SLIMBUS_CLK Used by CM_L4PER_SLIMBUS2_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_SLIMBUS_CLK_10_10_SHIFT			10
#define OMAP54XX_OPTFCLKEN_SLIMBUS_CLK_10_10_MASK			(1 << 10)

/* Used by CM_COREAON_IO_SRCOMP_CLKCTRL, CM_WKUPAON_IO_SRCOMP_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_SRCOMP_FCLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_SRCOMP_FCLK_MASK				(1 << 8)

/* Used by CM_DSS_DSS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_SYS_CLK_SHIFT				10
#define OMAP54XX_OPTFCLKEN_SYS_CLK_MASK					(1 << 10)

/* Used by CM_COREAON_BANDGAP_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_TS_FCLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_TS_FCLK_MASK					(1 << 8)

/* Used by CM_MIPIEXT_LLI_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_TXPHY_CLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_TXPHY_CLK_MASK				(1 << 8)

/* Used by CM_MIPIEXT_LLI_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_TXPHY_LS_CLK_SHIFT				9
#define OMAP54XX_OPTFCLKEN_TXPHY_LS_CLK_MASK				(1 << 9)

/* Used by CM_L3INIT_USB_TLL_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_USB_CH0_CLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_USB_CH0_CLK_MASK				(1 << 8)

/* Used by CM_L3INIT_USB_TLL_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_USB_CH1_CLK_SHIFT				9
#define OMAP54XX_OPTFCLKEN_USB_CH1_CLK_MASK				(1 << 9)

/* Used by CM_L3INIT_USB_TLL_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_USB_CH2_CLK_SHIFT				10
#define OMAP54XX_OPTFCLKEN_USB_CH2_CLK_MASK				(1 << 10)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_UTMI_P1_CLK_SHIFT				8
#define OMAP54XX_OPTFCLKEN_UTMI_P1_CLK_MASK				(1 << 8)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_UTMI_P2_CLK_SHIFT				9
#define OMAP54XX_OPTFCLKEN_UTMI_P2_CLK_MASK				(1 << 9)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL */
#define OMAP54XX_OPTFCLKEN_UTMI_P3_CLK_SHIFT				10
#define OMAP54XX_OPTFCLKEN_UTMI_P3_CLK_MASK				(1 << 10)

/* Used by CM_CLKSEL_ABE */
#define OMAP54XX_PAD_CLKS_GATE_SHIFT					8
#define OMAP54XX_PAD_CLKS_GATE_MASK					(1 << 8)

/* Used by CM_RESTORE_ST */
#define OMAP54XX_PHASE1_COMPLETED_SHIFT					0
#define OMAP54XX_PHASE1_COMPLETED_MASK					(1 << 0)

/* Used by CM_RESTORE_ST */
#define OMAP54XX_PHASE2A_COMPLETED_SHIFT				1
#define OMAP54XX_PHASE2A_COMPLETED_MASK					(1 << 1)

/* Used by CM_RESTORE_ST */
#define OMAP54XX_PHASE2B_COMPLETED_SHIFT				2
#define OMAP54XX_PHASE2B_COMPLETED_MASK					(1 << 2)

/* Used by CM_DYN_DEP_PRESCAL */
#define OMAP54XX_PRESCAL_SHIFT						0
#define OMAP54XX_PRESCAL_MASK						(0x3f << 0)

/* Used by REVISION_CM_CORE, REVISION_CM_CORE_AON */
#define OMAP54XX_R_RTL_SHIFT						11
#define OMAP54XX_R_RTL_MASK						(0x1f << 11)

/* Used by CM_L3INIT_USB_HOST_HS_CLKCTRL, CM_L3INIT_USB_TLL_HS_CLKCTRL */
#define OMAP54XX_SAR_MODE_SHIFT						4
#define OMAP54XX_SAR_MODE_MASK						(1 << 4)

/* Used by REVISION_CM_CORE, REVISION_CM_CORE_AON */
#define OMAP54XX_SCHEME_SHIFT						30
#define OMAP54XX_SCHEME_MASK						(0x3 << 30)

/* Used by CM_L4CFG_DYNAMICDEP */
#define OMAP54XX_SDMA_DYNDEP_SHIFT					11
#define OMAP54XX_SDMA_DYNDEP_MASK					(1 << 11)

/* Used by CM_IPU_STATICDEP, CM_MPU_STATICDEP */
#define OMAP54XX_SDMA_STATDEP_SHIFT					11
#define OMAP54XX_SDMA_STATDEP_MASK					(1 << 11)

/* Used by CM_CORE_AON_DEBUG_CFG */
#define OMAP54XX_SEL0_SHIFT						0
#define OMAP54XX_SEL0_MASK						(0x7f << 0)

/* Renamed from SEL0 Used by CM_CORE_DEBUG_CFG */
#define OMAP54XX_SEL0_0_7_SHIFT						0
#define OMAP54XX_SEL0_0_7_MASK						(0xff << 0)

/* Used by CM_CORE_AON_DEBUG_CFG */
#define OMAP54XX_SEL1_SHIFT						8
#define OMAP54XX_SEL1_MASK						(0x7f << 8)

/* Renamed from SEL1 Used by CM_CORE_DEBUG_CFG */
#define OMAP54XX_SEL1_CORE_DEBUG_CFG_SHIFT				8
#define OMAP54XX_SEL1_CORE_DEBUG_CFG_MASK				(0xff << 8)

/* Used by CM_CORE_AON_DEBUG_CFG */
#define OMAP54XX_SEL2_SHIFT						16
#define OMAP54XX_SEL2_MASK						(0x7f << 16)

/* Renamed from SEL2 Used by CM_CORE_DEBUG_CFG */
#define OMAP54XX_SEL2_CORE_DEBUG_CFG_SHIFT				16
#define OMAP54XX_SEL2_CORE_DEBUG_CFG_MASK				(0xff << 16)

/* Used by CM_CORE_AON_DEBUG_CFG */
#define OMAP54XX_SEL3_SHIFT						24
#define OMAP54XX_SEL3_MASK						(0x7f << 24)

/* Renamed from SEL3 Used by CM_CORE_DEBUG_CFG */
#define OMAP54XX_SEL3_CORE_DEBUG_CFG_SHIFT				24
#define OMAP54XX_SEL3_CORE_DEBUG_CFG_MASK				(0xff << 24)

/* Used by CM_CLKSEL_ABE */
#define OMAP54XX_SLIMBUS1_CLK_GATE_SHIFT				10
#define OMAP54XX_SLIMBUS1_CLK_GATE_MASK					(1 << 10)

/*
 * Used by CM_ABE_AESS_CLKCTRL, CM_C2C_C2C_CLKCTRL, CM_CAM_FDIF_CLKCTRL,
 * CM_CAM_ISS_CLKCTRL, CM_DMA_DMA_SYSTEM_CLKCTRL, CM_DSP_DSP_CLKCTRL,
 * CM_DSS_BB2D_CLKCTRL, CM_DSS_DSS_CLKCTRL, CM_EMU_DEBUGSS_CLKCTRL,
 * CM_GPU_GPU_CLKCTRL, CM_IPU_IPU_CLKCTRL, CM_IVA_IVA_CLKCTRL,
 * CM_L3INIT_HSI_CLKCTRL, CM_L3INIT_IEEE1500_2_OCP_CLKCTRL,
 * CM_L3INIT_MMC1_CLKCTRL, CM_L3INIT_MMC2_CLKCTRL, CM_L3INIT_SATA_CLKCTRL,
 * CM_L3INIT_UNIPRO2_CLKCTRL, CM_L3INIT_USB_HOST_HS_CLKCTRL,
 * CM_L3INIT_USB_OTG_SS_CLKCTRL, CM_L4SEC_DMA_CRYPTO_CLKCTRL,
 * CM_MIPIEXT_LLI_CLKCTRL, CM_MIPIEXT_UNIPRO1_CLKCTRL, CM_MPU_MPU_CLKCTRL
 */
#define OMAP54XX_STBYST_SHIFT						18
#define OMAP54XX_STBYST_MASK						(1 << 18)

/*
 * Used by CM_IDLEST_DPLL_ABE, CM_IDLEST_DPLL_CORE, CM_IDLEST_DPLL_IVA,
 * CM_IDLEST_DPLL_MPU, CM_IDLEST_DPLL_PER, CM_IDLEST_DPLL_UNIPRO1,
 * CM_IDLEST_DPLL_UNIPRO2, CM_IDLEST_DPLL_USB
 */
#define OMAP54XX_ST_DPLL_CLK_SHIFT					0
#define OMAP54XX_ST_DPLL_CLK_MASK					(1 << 0)

/*
 * Used by CM_CLKDCOLDO_DPLL_UNIPRO1, CM_CLKDCOLDO_DPLL_UNIPRO2,
 * CM_CLKDCOLDO_DPLL_USB
 */
#define OMAP54XX_ST_DPLL_CLKDCOLDO_SHIFT				9
#define OMAP54XX_ST_DPLL_CLKDCOLDO_MASK					(1 << 9)

/*
 * Used by CM_IDLEST_DPLL_ABE, CM_IDLEST_DPLL_CORE, CM_IDLEST_DPLL_IVA,
 * CM_IDLEST_DPLL_MPU, CM_IDLEST_DPLL_PER, CM_IDLEST_DPLL_UNIPRO1,
 * CM_IDLEST_DPLL_UNIPRO2, CM_IDLEST_DPLL_USB
 */
#define OMAP54XX_ST_DPLL_INIT_SHIFT					4
#define OMAP54XX_ST_DPLL_INIT_MASK					(1 << 4)

/*
 * Used by CM_IDLEST_DPLL_ABE, CM_IDLEST_DPLL_CORE, CM_IDLEST_DPLL_IVA,
 * CM_IDLEST_DPLL_MPU, CM_IDLEST_DPLL_PER, CM_IDLEST_DPLL_UNIPRO1,
 * CM_IDLEST_DPLL_UNIPRO2, CM_IDLEST_DPLL_USB
 */
#define OMAP54XX_ST_DPLL_MODE_SHIFT					1
#define OMAP54XX_ST_DPLL_MODE_MASK					(0x7 << 1)

/* Used by CM_CLKSEL_SYS */
#define OMAP54XX_SYS_CLKSEL_SHIFT					0
#define OMAP54XX_SYS_CLKSEL_MASK					(0x7 << 0)

/*
 * Used by CM_C2C_DYNAMICDEP, CM_DSP_DYNAMICDEP, CM_EMU_DYNAMICDEP,
 * CM_IPU_DYNAMICDEP, CM_L3MAIN1_DYNAMICDEP, CM_L3MAIN2_DYNAMICDEP,
 * CM_L4CFG_DYNAMICDEP, CM_L4PER_DYNAMICDEP, CM_MIPIEXT_DYNAMICDEP,
 * CM_MPU_DYNAMICDEP
 */
#define OMAP54XX_WINDOWSIZE_SHIFT					24
#define OMAP54XX_WINDOWSIZE_MASK					(0xf << 24)

/* Used by CM_L3MAIN1_DYNAMICDEP */
#define OMAP54XX_WKUPAON_DYNDEP_SHIFT					15
#define OMAP54XX_WKUPAON_DYNDEP_MASK					(1 << 15)

/*
 * Used by CM_DMA_STATICDEP, CM_DSP_STATICDEP, CM_IPU_STATICDEP,
 * CM_L3INIT_STATICDEP, CM_MPU_STATICDEP
 */
#define OMAP54XX_WKUPAON_STATDEP_SHIFT					15
#define OMAP54XX_WKUPAON_STATDEP_MASK					(1 << 15)

/* Used by REVISION_CM_CORE, REVISION_CM_CORE_AON */
#define OMAP54XX_X_MAJOR_SHIFT						8
#define OMAP54XX_X_MAJOR_MASK						(0x7 << 8)

/* Used by REVISION_CM_CORE, REVISION_CM_CORE_AON */
#define OMAP54XX_Y_MINOR_SHIFT						0
#define OMAP54XX_Y_MINOR_MASK						(0x3f << 0)
#endif
