/*
 * Hardware modules present on the OMAP54xx chips
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/io.h>

#include <plat/omap_hwmod.h>
#include <plat/cpu.h>
#include <plat/gpio.h>
#include <plat/dma.h>
#include <plat/mcspi.h>
#include <plat/mcbsp.h>
#include <plat/mmc.h>
#include <plat/i2c.h>
#include <plat/dmtimer.h>
#include <plat/scm.h>
#include <plat/common.h>
#include <plat/iommu.h>

#include "omap_hwmod_common_data.h"

#include "smartreflex.h"
#include "cm1_54xx.h"
#include "cm2_54xx.h"
#include "prm54xx.h"
#include "prm-regbits-54xx.h"
#include "wd_timer.h"

/* Base offset for all OMAP5 interrupts external to MPUSS */
#define OMAP54XX_IRQ_GIC_START	32

/* Base offset for all OMAP5 dma requests */
#define OMAP54XX_DMA_REQ_START  1

/* Backward references (IPs with Bus Master capability) */
static struct omap_hwmod omap54xx_aess_hwmod;
static struct omap_hwmod omap54xx_dma_system_hwmod;
static struct omap_hwmod omap54xx_dmm_hwmod;
static struct omap_hwmod omap54xx_dsp_hwmod;
static struct omap_hwmod omap54xx_dss_hwmod;
static struct omap_hwmod omap54xx_emif_ocp_fw_hwmod;
static struct omap_hwmod omap54xx_gpu_hwmod;
static struct omap_hwmod omap54xx_fdif_hwmod;
static struct omap_hwmod omap54xx_hsi_hwmod;
static struct omap_hwmod omap54xx_ipu_hwmod;
static struct omap_hwmod omap54xx_iss_hwmod;
static struct omap_hwmod omap54xx_iva_hwmod;
static struct omap_hwmod omap54xx_l3_instr_hwmod;
static struct omap_hwmod omap54xx_l3_main_1_hwmod;
static struct omap_hwmod omap54xx_l3_main_2_hwmod;
static struct omap_hwmod omap54xx_l3_main_3_hwmod;
static struct omap_hwmod omap54xx_l4_abe_hwmod;
static struct omap_hwmod omap54xx_l4_cfg_hwmod;
static struct omap_hwmod omap54xx_l4_per_hwmod;
static struct omap_hwmod omap54xx_l4_wkup_hwmod;
static struct omap_hwmod omap54xx_mmc1_hwmod;
static struct omap_hwmod omap54xx_mmc2_hwmod;
static struct omap_hwmod omap54xx_mpu_hwmod;
static struct omap_hwmod omap54xx_mpu_private_hwmod;
static struct omap_hwmod omap54xx_sata_hwmod;
static struct omap_hwmod omap54xx_usb_otg_ss_hwmod;
static struct omap_hwmod omap54xx_usb_host_hs_hwmod;
static struct omap_hwmod omap54xx_usb_tll_hs_hwmod;
static struct omap_hwmod omap54xx_sl2if_hwmod;

/*
 * Interconnects omap_hwmod structures
 * hwmods that compose the global OMAP interconnect
 */

/*
 * 'dmm' class
 * instance(s): dmm
 */
static struct omap_hwmod_class omap54xx_dmm_hwmod_class = {
	.name	= "dmm",
};

/* dmm */
static struct omap_hwmod_irq_info omap54xx_dmm_irqs[] = {
	{ .irq = 113 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dmm_addrs[] = {
	{
		.pa_start	= 0x4e000000,
		.pa_end		= 0x4e0007ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> dmm */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__dmm = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_dmm_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_dmm_addrs,
	.user		= OCP_USER_SDMA,
};

/* dmm slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dmm_slaves[] = {
	&omap54xx_l3_main_1__dmm,
};

static struct omap_hwmod omap54xx_dmm_hwmod = {
	.name		= "dmm",
	.class		= &omap54xx_dmm_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.mpu_irqs	= omap54xx_dmm_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_DMM_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_DMM_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_dmm_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dmm_slaves),
};

/*
 * 'emif_ocp_fw' class
 * instance(s): emif_ocp_fw
 */
static struct omap_hwmod_class omap54xx_emif_ocp_fw_hwmod_class = {
	.name	= "emif_ocp_fw",
};

/* emif_ocp_fw */
/* dmm -> emif_ocp_fw */
static struct omap_hwmod_ocp_if omap54xx_dmm__emif_ocp_fw = {
	.master		= &omap54xx_dmm_hwmod,
	.slave		= &omap54xx_emif_ocp_fw_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_emif_ocp_fw_addrs[] = {
	{
		.pa_start	= 0x4a20c000,
		.pa_end		= 0x4a20c0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> emif_ocp_fw */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__emif_ocp_fw = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_emif_ocp_fw_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_emif_ocp_fw_addrs,
	.user		= OCP_USER_MPU,
};

/* emif_ocp_fw slave ports */
static struct omap_hwmod_ocp_if *omap54xx_emif_ocp_fw_slaves[] = {
	&omap54xx_dmm__emif_ocp_fw,
	&omap54xx_l4_cfg__emif_ocp_fw,
};

static struct omap_hwmod omap54xx_emif_ocp_fw_hwmod = {
	.name		= "emif_ocp_fw",
	.class		= &omap54xx_emif_ocp_fw_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF_OCP_FW_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF_OCP_FW_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_emif_ocp_fw_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_emif_ocp_fw_slaves),
};

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2, l3_main_3
 */
static struct omap_hwmod_class omap54xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr */
/* iva -> l3_instr */
static struct omap_hwmod_ocp_if omap54xx_iva__l3_instr = {
	.master		= &omap54xx_iva_hwmod,
	.slave		= &omap54xx_l3_instr_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_3 -> l3_instr */
static struct omap_hwmod_ocp_if omap54xx_l3_main_3__l3_instr = {
	.master		= &omap54xx_l3_main_3_hwmod,
	.slave		= &omap54xx_l3_instr_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_instr slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l3_instr_slaves[] = {
	&omap54xx_iva__l3_instr,
	&omap54xx_l3_main_3__l3_instr,
};

static struct omap_hwmod omap54xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INSTR_L3_INSTR_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_l3_instr_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l3_instr_slaves),
};

/* l3_main_1 */
static struct omap_hwmod_irq_info omap54xx_l3_main_1_irqs[] = {
	{ .name = "dbg_err", .irq = 9 + OMAP54XX_IRQ_GIC_START },
	{ .name = "app_err", .irq = 10 + OMAP54XX_IRQ_GIC_START },
	{ .name = "stat_alarm", .irq = 16 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* dsp -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_dsp__l3_main_1 = {
	.master		= &omap54xx_dsp_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dss -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_dss__l3_main_1 = {
	.master		= &omap54xx_dss_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l3_main_1 = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_1 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc1 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_mmc1__l3_main_1 = {
	.master		= &omap54xx_mmc1_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_mmc2__l3_main_1 = {
	.master		= &omap54xx_mmc2_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_l3_main_1_addrs[] = {
	{
		.pa_start	= 0x44000000,
		.pa_end		= 0x44000fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_mpu__l3_main_1 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_l3_main_1_addrs,
	.user		= OCP_USER_MPU,
};

/* l3_main_1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l3_main_1_slaves[] = {
	&omap54xx_dsp__l3_main_1,
	&omap54xx_dss__l3_main_1,
	&omap54xx_l3_main_2__l3_main_1,
	&omap54xx_l4_cfg__l3_main_1,
	&omap54xx_mmc1__l3_main_1,
	&omap54xx_mmc2__l3_main_1,
	&omap54xx_mpu__l3_main_1,
};

static struct omap_hwmod omap54xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.mpu_irqs	= omap54xx_l3_main_1_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN1_L3_MAIN_1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN1_L3_MAIN_1_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_l3_main_1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l3_main_1_slaves),
};

/* l3_main_2 */
/* dma_system -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_dma_system__l3_main_2 = {
	.master		= &omap54xx_dma_system_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpu -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_gpu__l3_main_2 = {
	.master		= &omap54xx_gpu_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* hsi -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_hsi__l3_main_2 = {
	.master		= &omap54xx_hsi_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* ipu -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_ipu__l3_main_2 = {
	.master		= &omap54xx_ipu_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* iss -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_iss__l3_main_2 = {
	.master		= &omap54xx_iss_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "dpll_core_h23x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* fdif -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_fdif__l3_main_2 = {
	.master		= &omap54xx_fdif_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};


/* iva -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_iva__l3_main_2 = {
	.master		= &omap54xx_iva_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_l3_main_2_addrs[] = {
	{
		.pa_start	= 0x44800000,
		.pa_end		= 0x44803fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l3_main_2 = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_l3_main_2_addrs,
	.user		= OCP_USER_MPU,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_2 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* sata -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_sata__l3_main_2 = {
	.master		= &omap54xx_sata_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_host_hs -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_usb_host_hs__l3_main_2 = {
	.master		= &omap54xx_usb_host_hs_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_otg_ss -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_usb_otg_ss__l3_main_2 = {
	.master		= &omap54xx_usb_otg_ss_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l3_main_2_slaves[] = {
	&omap54xx_dma_system__l3_main_2,
	&omap54xx_gpu__l3_main_2,
	&omap54xx_hsi__l3_main_2,
	&omap54xx_ipu__l3_main_2,
	&omap54xx_iss__l3_main_2,
	&omap54xx_iva__l3_main_2,
	&omap54xx_l3_main_1__l3_main_2,
	&omap54xx_fdif__l3_main_2,
	&omap54xx_l4_cfg__l3_main_2,
	&omap54xx_sata__l3_main_2,
	&omap54xx_usb_host_hs__l3_main_2,
	&omap54xx_usb_otg_ss__l3_main_2,
};

static struct omap_hwmod omap54xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3main2_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN2_L3_MAIN_2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN2_L3_MAIN_2_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_l3_main_2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l3_main_2_slaves),
};

/* l3_main_3 */
static struct omap_hwmod_addr_space omap54xx_l3_main_3_addrs[] = {
	{
		.pa_start	= 0x45000000,
		.pa_end		= 0x45003fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l3_main_3 = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_l3_main_3_addrs,
	.user		= OCP_USER_MPU,
};

/* l3_main_2 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l3_main_3 = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_3 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l3_main_3_slaves[] = {
	&omap54xx_l3_main_1__l3_main_3,
	&omap54xx_l3_main_2__l3_main_3,
	&omap54xx_l4_cfg__l3_main_3,
};

static struct omap_hwmod omap54xx_l3_main_3_hwmod = {
	.name		= "l3_main_3",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INSTR_L3_MAIN_3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INSTR_L3_MAIN_3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_l3_main_3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l3_main_3_slaves),
};

/*
 * 'l4' class
 * instance(s): l4_abe, l4_cfg, l4_per, l4_wkup
 */
static struct omap_hwmod_class omap54xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_abe */
static struct omap_hwmod_addr_space omap54xx_l4_abe_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x401f1000,
		.pa_end		= 0x401f13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* aess -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_aess__l4_abe = {
	.master		= &omap54xx_aess_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_l4_abe_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_l4_abe_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x490f1000,
		.pa_end		= 0x490f13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* aess -> l4_abe (dma) */
static struct omap_hwmod_ocp_if omap54xx_aess__l4_abe_dma = {
	.master		= &omap54xx_aess_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_l4_abe_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* dsp -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_dsp__l4_abe = {
	.master		= &omap54xx_dsp_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_abe = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_mpu__l4_abe = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_abe slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l4_abe_slaves[] = {
	&omap54xx_aess__l4_abe,
	&omap54xx_dsp__l4_abe,
	&omap54xx_l3_main_1__l4_abe,
	&omap54xx_mpu__l4_abe,
	&omap54xx_aess__l4_abe_dma,
};

static struct omap_hwmod omap54xx_l4_abe_hwmod = {
	.name		= "l4_abe",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_L4_ABE_CLKCTRL_OFFSET,
		},
	},
	.slaves		= omap54xx_l4_abe_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l4_abe_slaves),
};

/* l4_cfg */
/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_cfg = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_cfg_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l4_cfg_slaves[] = {
	&omap54xx_l3_main_1__l4_cfg,
};

static struct omap_hwmod omap54xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4CFG_L4_CFG_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4CFG_L4_CFG_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_l4_cfg_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l4_cfg_slaves),
};

/* l4_per */
/* l3_main_2 -> l4_per */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l4_per = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l4_per_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l4_per_slaves[] = {
	&omap54xx_l3_main_2__l4_per,
};

static struct omap_hwmod omap54xx_l4_per_hwmod = {
	.name		= "l4_per",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_L4_PER_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_L4_PER_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_l4_per_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l4_per_slaves),
};

/* l4_wkup */
/* l3_main_1 -> l4_wkup */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_wkup = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_wkup_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup slave ports */
static struct omap_hwmod_ocp_if *omap54xx_l4_wkup_slaves[] = {
	&omap54xx_l3_main_1__l4_wkup,
};

static struct omap_hwmod omap54xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_L4_WKUP_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_L4_WKUP_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_l4_wkup_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_l4_wkup_slaves),
};

/*
 * 'mpu_bus' class
 * instance(s): mpu_private
 */
static struct omap_hwmod_class omap54xx_mpu_bus_hwmod_class = {
	.name	= "mpu_bus",
};

/* mpu_private */
/* mpu -> mpu_private */
static struct omap_hwmod_ocp_if omap54xx_mpu__mpu_private = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_mpu_private_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu_private slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mpu_private_slaves[] = {
	&omap54xx_mpu__mpu_private,
};

static struct omap_hwmod omap54xx_mpu_private_hwmod = {
	.name		= "mpu_private",
	.class		= &omap54xx_mpu_bus_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.slaves		= omap54xx_mpu_private_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mpu_private_slaves),
};

/*
 * Modules omap_hwmod structures
 *
 * The following IPs are excluded for the moment because:
 * - They do not need an explicit SW control using omap_hwmod API.
 * - They still need to be validated with the driver
 *   properly adapted to omap_hwmod / omap_device
 *
 *  bb2d
 *  c2c
 *  c2c_ocp_fw
 *  cal
 *  efuse_ctrl_cust
 *  elm
 *  fdif
 *  hdq1w
 *  ieee1500_2_ocp
 *  lli
 *  lli_ocp_fw
 *  mcasp
 *  modem_icr
 *  mpu_c0
 *  mpu_c1
 *  ocmc_ram
 *  ocp2scp1
 *  ocp2scp2
 *  ocp2scp3
 *  ocp_wp_noc
 *  prcm_mpu
 *  scrm
 *  slimbus1
 *  slimbus2
 *  unipro1
 *  unipro2
 *  usb_host_hs
 *  usb_tll_hs
 */

/*
 * 'aess' class
 * audio engine sub system
 */

static struct omap_hwmod_class_sysconfig omap54xx_aess_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART |
			   MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_aess_hwmod_class = {
	.name	= "aess",
	.sysc	= &omap54xx_aess_sysc,
};

/* aess */
static struct omap_hwmod_irq_info omap54xx_aess_irqs[] = {
	{ .irq = 99 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_aess_sdma_reqs[] = {
	{ .name = "fifo0", .dma_req = 100 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo1", .dma_req = 101 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo2", .dma_req = 102 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo3", .dma_req = 103 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo4", .dma_req = 104 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo5", .dma_req = 105 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo6", .dma_req = 106 + OMAP54XX_DMA_REQ_START },
	{ .name = "fifo7", .dma_req = 107 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* aess master ports */
static struct omap_hwmod_ocp_if *omap54xx_aess_masters[] = {
	&omap54xx_aess__l4_abe,
};

static struct omap_hwmod_addr_space omap54xx_aess_addrs[] = {
	{
		.name		= "dmem",
		.pa_start	= 0x40180000,
		.pa_end		= 0x4018ffff
	},
	{
		.name		= "cmem",
		.pa_start	= 0x401a0000,
		.pa_end		= 0x401a1fff
	},
	{
		.name		= "smem",
		.pa_start	= 0x401c0000,
		.pa_end		= 0x401c5fff
	},
	{
		.name		= "pmem",
		.pa_start	= 0x401e0000,
		.pa_end		= 0x401e1fff
	},
	{
		.name		= "mpu",
		.pa_start	= 0x401f1000,
		.pa_end		= 0x401f13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> aess */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__aess = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_aess_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_aess_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_aess_dma_addrs[] = {
	{
		.name		= "dmem_dma",
		.pa_start	= 0x49080000,
		.pa_end		= 0x4908ffff
	},
	{
		.name		= "cmem_dma",
		.pa_start	= 0x490a0000,
		.pa_end		= 0x490a1fff
	},
	{
		.name		= "smem_dma",
		.pa_start	= 0x490c0000,
		.pa_end		= 0x490c5fff
	},
	{
		.name		= "pmem_dma",
		.pa_start	= 0x490e0000,
		.pa_end		= 0x490e1fff
	},
	{
		.name		= "dma",
		.pa_start	= 0x490f1000,
		.pa_end		= 0x490f13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> aess (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__aess_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_aess_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_aess_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* aess slave ports */
static struct omap_hwmod_ocp_if *omap54xx_aess_slaves[] = {
	&omap54xx_l4_abe__aess,
	&omap54xx_l4_abe__aess_dma,
};

static struct omap_hwmod omap54xx_aess_hwmod = {
	.name		= "aess",
	.class		= &omap54xx_aess_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_aess_irqs,
	.sdma_reqs	= omap54xx_aess_sdma_reqs,
	.main_clk	= "aess_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_AESS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_AESS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_aess_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_aess_slaves),
	.masters	= omap54xx_aess_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_aess_masters),
};

/*
 * 'ctrl_module' class
 * attila core control module
 */

static struct omap_hwmod_class_sysconfig omap54xx_ctrl_module_sysc = {
	.rev_offs       = 0x0000,
	.sysc_offs      = 0x0010,
	.sysc_flags     = SYSC_HAS_SIDLEMODE,
	.idlemodes      = (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
				SIDLE_SMART_WKUP),
	.sysc_fields    = &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_ctrl_module_hwmod_class = {
	.name   = "ctrl_module",
	.sysc   = &omap54xx_ctrl_module_sysc,
};

/* ctrl_module_core */
static struct omap_hwmod omap54xx_ctrl_module_core_hwmod;
static struct omap_hwmod_irq_info omap54xx_ctrl_module_core_irqs[] = {
	{ .name = "sec_evts", .irq = 8 + OMAP44XX_IRQ_GIC_START },
	{ .name = "thermal_alert", .irq = 126 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap54xx_ctrl_module_core_addrs[] = {
	{
		.pa_start       = 0x4a002000,
		.pa_end         = 0x4a0027ff,
		.flags          = ADDR_TYPE_RT
	},
};

/* l4_cfg -> ctrl_module_core */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__ctrl_module_core = {
	.master         = &omap54xx_l4_cfg_hwmod,
	.slave          = &omap54xx_ctrl_module_core_hwmod,
	.clk            = "l4_div_ck",
	.addr           = omap54xx_ctrl_module_core_addrs,
	.user           = OCP_USER_MPU | OCP_USER_SDMA,
};

/* ctrl_module_core slave ports */
static struct omap_hwmod_ocp_if *omap54xx_ctrl_module_core_slaves[] = {
	&omap54xx_l4_cfg__ctrl_module_core,
};

/* scm dev_attr */
static struct omap4plus_scm_dev_attr scm_dev_attr = {
	.rev		= 2,
	.cnt		= 3,
};

static struct omap_hwmod omap54xx_ctrl_module_core_hwmod = {
	.name           = "ctrl_module_core",
	.class          = &omap54xx_ctrl_module_hwmod_class,
	.mpu_irqs       = omap54xx_ctrl_module_core_irqs,
	.main_clk       = "l4_div_ck",
	.slaves         = omap54xx_ctrl_module_core_slaves,
	.slaves_cnt     = ARRAY_SIZE(omap54xx_ctrl_module_core_slaves),
	.dev_attr	= &scm_dev_attr,
	.clkdm_name     = "l4cfg_clkdm",
};

/*
 * 'counter' class
 * 32-bit ordinary counter, clocked by the falling edge of the 32 khz clock
 */

static struct omap_hwmod_class_sysconfig omap54xx_counter_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_counter_hwmod_class = {
	.name	= "counter",
	.sysc	= &omap54xx_counter_sysc,
};

/* counter_32k */
static struct omap_hwmod omap54xx_counter_32k_hwmod;
static struct omap_hwmod_addr_space omap54xx_counter_32k_addrs[] = {
	{
		.pa_start	= 0x4ae04000,
		.pa_end		= 0x4ae0403f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> counter_32k */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__counter_32k = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_counter_32k_hwmod,
	.clk		= "wkupaon_clk_mux_ck",
	.addr		= omap54xx_counter_32k_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* counter_32k slave ports */
static struct omap_hwmod_ocp_if *omap54xx_counter_32k_slaves[] = {
	&omap54xx_l4_wkup__counter_32k,
};

static struct omap_hwmod omap54xx_counter_32k_hwmod = {
	.name		= "counter_32k",
	.class		= &omap54xx_counter_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_COUNTER_32K_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_COUNTER_32K_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_counter_32k_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_counter_32k_slaves),
};

/*
 * 'dma' class
 * dma controller for data exchange between memory to memory (i.e. internal or
 * external memory) and gp peripherals to memory or memory to gp peripherals
 */

static struct omap_hwmod_class_sysconfig omap54xx_dma_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x002c,
	.syss_offs	= 0x0028,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_dma_hwmod_class = {
	.name	= "dma",
	.sysc	= &omap54xx_dma_sysc,
};

/* dma dev_attr */
static struct omap_dma_dev_attr dma_dev_attr = {
	.dev_caps	= RESERVE_CHANNEL | DMA_LINKED_LCH | GLOBAL_PRIORITY |
			  IS_CSSA_32 | IS_CDSA_32 | IS_RW_PRIORITY,
	.lch_count	= 32,
};

/* dma_system */
static struct omap_hwmod_irq_info omap54xx_dma_system_irqs[] = {
	{ .name = "0", .irq = 12 + OMAP54XX_IRQ_GIC_START },
	{ .name = "1", .irq = 13 + OMAP54XX_IRQ_GIC_START },
	{ .name = "2", .irq = 14 + OMAP54XX_IRQ_GIC_START },
	{ .name = "3", .irq = 15 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* dma_system master ports */
static struct omap_hwmod_ocp_if *omap54xx_dma_system_masters[] = {
	&omap54xx_dma_system__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_dma_system_addrs[] = {
	{
		.pa_start	= 0x4a056000,
		.pa_end		= 0x4a056fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> dma_system */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__dma_system = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_dma_system_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dma_system_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dma_system slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dma_system_slaves[] = {
	&omap54xx_l4_cfg__dma_system,
};

static struct omap_hwmod omap54xx_dma_system_hwmod = {
	.name		= "dma_system",
	.class		= &omap54xx_dma_hwmod_class,
	.clkdm_name	= "dma_clkdm",
	.mpu_irqs	= omap54xx_dma_system_irqs,
	.main_clk	= "l3_div_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DMA_DMA_SYSTEM_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DMA_DMA_SYSTEM_CONTEXT_OFFSET,
		},
	},
	.dev_attr	= &dma_dev_attr,
	.slaves		= omap54xx_dma_system_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dma_system_slaves),
	.masters	= omap54xx_dma_system_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_dma_system_masters),
};

/*
 * 'dmic' class
 * digital microphone controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_dmic_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_dmic_hwmod_class = {
	.name	= "dmic",
	.sysc	= &omap54xx_dmic_sysc,
};

/* dmic */
static struct omap_hwmod omap54xx_dmic_hwmod;
static struct omap_hwmod_irq_info omap54xx_dmic_irqs[] = {
	{ .irq = 114 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_dmic_sdma_reqs[] = {
	{ .dma_req = 66 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dmic_addrs[] = {
	{
		.pa_start	= 0x4012e000,
		.pa_end		= 0x4012e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> dmic */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__dmic = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_dmic_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_dmic_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_dmic_dma_addrs[] = {
	{
		.pa_start	= 0x4902e000,
		.pa_end		= 0x4902e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> dmic (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__dmic_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_dmic_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_dmic_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* dmic slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dmic_slaves[] = {
	&omap54xx_l4_abe__dmic,
	&omap54xx_l4_abe__dmic_dma,
};

static struct omap_hwmod omap54xx_dmic_hwmod = {
	.name		= "dmic",
	.class		= &omap54xx_dmic_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_dmic_irqs,
	.sdma_reqs	= omap54xx_dmic_sdma_reqs,
	.main_clk	= "dmic_gfclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_DMIC_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_DMIC_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_dmic_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dmic_slaves),
};

/*
 * 'mmu' class
 * The memory management unit performs virtual to physical address translation
 * for its requestors (remote processors: i.e, dsp, ipu)
 * Adding a separate class for that to control the mmu module separately
 */

static struct omap_hwmod_class_sysconfig omap54xx_mmu_sysc = {
	.rev_offs	= 0x000,
	.sysc_offs	= 0x010,
	.syss_offs	= 0x014,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSC_HAS_AUTOIDLE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_mmu_hwmod_class = {
	.name = "mmu",
	.sysc = &omap54xx_mmu_sysc,
};


/*
 * 'dsp' class
 * dsp sub-system
 */

/* dsp mmu attr */

static struct omap_mmu_dev_attr omap54xx_dsp_mmu_dev_attr = {
	.da_start = 0x0,
	.da_end = 0xfffff000,
	.nr_tlb_entries = 32,
};

static struct omap_hwmod_class omap54xx_dsp_hwmod_class = {
	.name	= "dsp",
};

/* dsp */
static struct omap_hwmod_irq_info omap54xx_dsp_irqs[] = {
	{ .irq = 28 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_rst_info omap54xx_dsp_resets[] = {
	{ .name = "rst_dsp", .rst_shift = 0 },
	{ .name = "dsp_mmu_cache", .rst_shift = 1 },
};

static struct omap_hwmod_rst_info omap54xx_dsp_c0_resets[] = {
	{ .name = "dsp", .rst_shift = 0 },
};

static struct omap_hwmod_addr_space omap54xx_dsp_addrs[] = {
	{
		.pa_start	= 0x4A066000,
		.pa_end		= 0x4A0660ff,
		.flags		= ADDR_TYPE_RT
	},
	{}
};

/* dsp -> iva */
static struct omap_hwmod_ocp_if omap54xx_dsp__iva = {
	.master		= &omap54xx_dsp_hwmod,
	.slave		= &omap54xx_iva_hwmod,
	.clk		= "dpll_iva_h12x2_ck",
};

/* dsp -> sl2if */
static struct omap_hwmod_ocp_if omap54xx_dsp__sl2if = {
	.master		= &omap54xx_dsp_hwmod,
	.slave		= &omap54xx_sl2if_hwmod,
	.clk		= "dpll_iva_h12x2_ck",
};

/* dsp master ports */
static struct omap_hwmod_ocp_if *omap54xx_dsp_masters[] = {
	&omap54xx_dsp__l3_main_1,
	&omap54xx_dsp__l4_abe,
	&omap54xx_dsp__iva,
	&omap54xx_dsp__sl2if,
};

/* l4_cfg -> dsp */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__dsp = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_dsp_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dsp_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dsp slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dsp_slaves[] = {
	&omap54xx_l4_cfg__dsp,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap54xx_dsp_c0_hwmod = {
	.name		= "dsp_c0",
	.class		= &omap54xx_dsp_hwmod_class,
	.clkdm_name	= "dsp_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap54xx_dsp_c0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_dsp_c0_resets),
	.main_clk	= "dsp_fck",
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP54XX_RM_DSP_RSTCTRL_OFFSET,
		},
	},
};

static struct omap_hwmod omap54xx_dsp_hwmod = {
	.name		= "dsp",
	.class		= &omap54xx_mmu_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.clkdm_name	= "dsp_clkdm",
	.mpu_irqs	= omap54xx_dsp_irqs,
	.rst_lines	= omap54xx_dsp_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_dsp_resets),
	.main_clk	= "dsp_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSP_DSP_CLKCTRL_OFFSET,
			.rstctrl_offs = OMAP54XX_RM_DSP_RSTCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSP_DSP_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.dev_attr	= &omap54xx_dsp_mmu_dev_attr,
	.slaves		= omap54xx_dsp_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dsp_slaves),
	.masters	= omap54xx_dsp_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_dsp_masters),
};

/*
 * 'dss' class
 * display sub-system
 */

static struct omap_hwmod_class_sysconfig omap54xx_dss_sysc = {
	.rev_offs	= 0x0000,
	.syss_offs	= 0x0014,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class omap54xx_dss_hwmod_class = {
	.name	= "dss",
	.sysc	= &omap54xx_dss_sysc,
	.reset	= omap_dss_reset,
};

/* dss */
/* dss master ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_masters[] = {
	&omap54xx_dss__l3_main_1,
};

static struct omap_hwmod_addr_space omap54xx_dss_dma_addrs[] = {
	{
		.pa_start	= 0x58000000,
		.pa_end		= 0x5807ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_hwmod,
	.clk		= "dss_fck",
	.addr		= omap54xx_dss_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_addrs[] = {
	{
		.pa_start	= 0x48100000,
		.pa_end		= 0x4817ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_addrs,
	.user		= OCP_USER_MPU,
};

/* dss slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_slaves[] = {
	&omap54xx_l3_main_2__dss,
	&omap54xx_l4_per__dss,
};

static struct omap_hwmod_opt_clk dss_opt_clks[] = {
	{ .role = "32khz_clk", .clk = "dss_32khz_clk" },
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
	{ .role = "hdmi_clk", .clk = "dss_48mhz_clk" },
};

static struct omap_hwmod omap54xx_dss_hwmod = {
	.name		= "dss_core",
	.class		= &omap54xx_dss_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_opt_clks),
	.slaves		= omap54xx_dss_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_slaves),
	.masters	= omap54xx_dss_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_dss_masters),
};

/*
 * 'dispc' class
 * display controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_dispc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_dispc_hwmod_class = {
	.name	= "dispc",
	.sysc	= &omap54xx_dispc_sysc,
};

/* dss_dispc */
static struct omap_hwmod omap54xx_dss_dispc_hwmod;
static struct omap_hwmod_irq_info omap54xx_dss_dispc_irqs[] = {
	{ .irq = 25 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_dss_dispc_sdma_reqs[] = {
	{ .dma_req = 5 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dss_dispc_dma_addrs[] = {
	{
		.pa_start	= 0x58001000,
		.pa_end		= 0x58001fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dispc */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss_dispc = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_dispc_hwmod,
	.clk		= "dss_fck",
	.addr		= omap54xx_dss_dispc_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_dispc_addrs[] = {
	{
		.pa_start	= 0x48101000,
		.pa_end		= 0x48101fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

static struct omap_dss_dispc_dev_attr omap54xx_dss_dispc_dev_attr = {
	.manager_count		= 4,
	.has_framedonetv_irq	= 1
};

/* l4_per -> dss_dispc */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss_dispc = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_dispc_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_dispc_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dispc slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_dispc_slaves[] = {
	&omap54xx_l3_main_2__dss_dispc,
	&omap54xx_l4_per__dss_dispc,
};

static struct omap_hwmod omap54xx_dss_dispc_hwmod = {
	.name		= "dss_dispc",
	.class		= &omap54xx_dispc_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.mpu_irqs	= omap54xx_dss_dispc_irqs,
	.sdma_reqs	= omap54xx_dss_dispc_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_dss_dispc_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_dispc_slaves),
	.dev_attr	= &omap54xx_dss_dispc_dev_attr,
};

/*
 * 'dsi1' class
 * display serial interface controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_dsi1_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_dsi1_hwmod_class = {
	.name	= "dsi1",
	.sysc	= &omap54xx_dsi1_sysc,
};

/* dss_dsi1_a */
static struct omap_hwmod omap54xx_dss_dsi1_a_hwmod;
static struct omap_hwmod_irq_info omap54xx_dss_dsi1_a_irqs[] = {
	{ .irq = 53 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_dss_dsi1_a_sdma_reqs[] = {
	{ .dma_req = 74 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dss_dsi1_a_dma_addrs[] = {
	{
		.pa_start	= 0x58004000,
		.pa_end		= 0x580041ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dsi1_a */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss_dsi1_a = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_dsi1_a_hwmod,
	.clk		= "dss_fck",
	.addr		= omap54xx_dss_dsi1_a_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_dsi1_a_addrs[] = {
	{
		.pa_start	= 0x48104000,
		.pa_end		= 0x481041ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_dsi1_a */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss_dsi1_a = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_dsi1_a_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_dsi1_a_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dsi1_a slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_dsi1_a_slaves[] = {
	&omap54xx_l3_main_2__dss_dsi1_a,
	&omap54xx_l4_per__dss_dsi1_a,
};

static struct omap_hwmod_opt_clk dss_dsi1_a_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
};

static struct omap_hwmod omap54xx_dss_dsi1_a_hwmod = {
	.name		= "dss_dsi1_a",
	.class		= &omap54xx_dsi1_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.mpu_irqs	= omap54xx_dss_dsi1_a_irqs,
	.sdma_reqs	= omap54xx_dss_dsi1_a_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_dsi1_a_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_dsi1_a_opt_clks),
	.slaves		= omap54xx_dss_dsi1_a_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_dsi1_a_slaves),
};

/* dss_dsi1_b */
static struct omap_hwmod omap54xx_dss_dsi1_b_hwmod;
static struct omap_hwmod_addr_space omap54xx_dss_dsi1_b_dma_addrs[] = {
	{
		.pa_start	= 0x58005000,
		.pa_end		= 0x580051ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dsi1_b */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss_dsi1_b = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_dsi1_b_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_dss_dsi1_b_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_dsi1_b_addrs[] = {
	{
		.pa_start	= 0x48105000,
		.pa_end		= 0x481051ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_dsi1_b */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss_dsi1_b = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_dsi1_b_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_dsi1_b_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dsi1_b slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_dsi1_b_slaves[] = {
	&omap54xx_l3_main_2__dss_dsi1_b,
	&omap54xx_l4_per__dss_dsi1_b,
};

static struct omap_hwmod omap54xx_dss_dsi1_b_hwmod = {
	.name		= "dss_dsi1_b",
	.class		= &omap54xx_dsi1_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_dss_dsi1_b_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_dsi1_b_slaves),
};

/* dss_dsi1_c */
static struct omap_hwmod omap54xx_dss_dsi1_c_hwmod;
static struct omap_hwmod_irq_info omap54xx_dss_dsi1_c_irqs[] = {
	{ .irq = 55 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_dss_dsi1_c_sdma_reqs[] = {
	{ .dma_req = 83 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dss_dsi1_c_dma_addrs[] = {
	{
		.pa_start	= 0x58009000,
		.pa_end		= 0x580091ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dsi1_c */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss_dsi1_c = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_dsi1_c_hwmod,
	.clk		= "dss_fck",
	.addr		= omap54xx_dss_dsi1_c_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_dsi1_c_addrs[] = {
	{
		.pa_start	= 0x48109000,
		.pa_end		= 0x481091ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_dsi1_c */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss_dsi1_c = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_dsi1_c_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_dsi1_c_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dsi1_c slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_dsi1_c_slaves[] = {
	&omap54xx_l3_main_2__dss_dsi1_c,
	&omap54xx_l4_per__dss_dsi1_c,
};

static struct omap_hwmod_opt_clk dss_dsi1_c_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
};

static struct omap_hwmod omap54xx_dss_dsi1_c_hwmod = {
	.name		= "dss_dsi1_c",
	.class		= &omap54xx_dsi1_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.mpu_irqs	= omap54xx_dss_dsi1_c_irqs,
	.sdma_reqs	= omap54xx_dss_dsi1_c_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_dsi1_c_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_dsi1_c_opt_clks),
	.slaves		= omap54xx_dss_dsi1_c_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_dsi1_c_slaves),
};

/*
 * 'hdmi' class
 * hdmi controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_hdmi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_hdmi_hwmod_class = {
	.name	= "dss_hdmi",
	.sysc	= &omap54xx_hdmi_sysc,
};

/* dss_hdmi */
static struct omap_hwmod omap54xx_dss_hdmi_hwmod;
static struct omap_hwmod_irq_info omap54xx_dss_hdmi_irqs[] = {
	{ .irq = 101 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_dss_hdmi_sdma_reqs[] = {
	{ .dma_req = 75 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dss_hdmi_dma_addrs[] = {
	{
		.pa_start	= 0x58040000,
		.pa_end		= 0x5807ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_hdmi */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss_hdmi = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_hdmi_hwmod,
	.clk		= "dss_fck",
	.addr		= omap54xx_dss_hdmi_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_hdmi_addrs[] = {
	{
		.pa_start	= 0x48140000,
		.pa_end		= 0x4817ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_hdmi */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss_hdmi = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_hdmi_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_hdmi_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_hdmi slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_hdmi_slaves[] = {
	&omap54xx_l3_main_2__dss_hdmi,
	&omap54xx_l4_per__dss_hdmi,
};

static struct omap_hwmod_opt_clk dss_hdmi_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
};

static struct omap_hwmod omap54xx_dss_hdmi_hwmod = {
	.name		= "dss_hdmi",
	.class		= &omap54xx_hdmi_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.mpu_irqs	= omap54xx_dss_hdmi_irqs,
	.sdma_reqs	= omap54xx_dss_hdmi_sdma_reqs,
	.main_clk	= "dss_48mhz_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_hdmi_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_hdmi_opt_clks),
	.slaves		= omap54xx_dss_hdmi_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_hdmi_slaves),
};

/*
 * 'rfbi' class
 * remote frame buffer interface
 */

static struct omap_hwmod_class_sysconfig omap54xx_rfbi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_rfbi_hwmod_class = {
	.name	= "rfbi",
	.sysc	= &omap54xx_rfbi_sysc,
};

/* dss_rfbi */
static struct omap_hwmod omap54xx_dss_rfbi_hwmod;
static struct omap_hwmod_dma_info omap54xx_dss_rfbi_sdma_reqs[] = {
	{ .dma_req = 13 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_dss_rfbi_dma_addrs[] = {
	{
		.pa_start	= 0x58002000,
		.pa_end		= 0x580020ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_rfbi */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__dss_rfbi = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_dss_rfbi_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_dss_rfbi_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_dss_rfbi_addrs[] = {
	{
		.pa_start	= 0x48102000,
		.pa_end		= 0x481020ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_rfbi */
static struct omap_hwmod_ocp_if omap54xx_l4_per__dss_rfbi = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_dss_rfbi_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_dss_rfbi_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_rfbi slave ports */
static struct omap_hwmod_ocp_if *omap54xx_dss_rfbi_slaves[] = {
	&omap54xx_l3_main_2__dss_rfbi,
	&omap54xx_l4_per__dss_rfbi,
};

static struct omap_hwmod_opt_clk dss_rfbi_opt_clks[] = {
	{ .role = "ick", .clk = "l3_div_ck" },
};

static struct omap_hwmod omap54xx_dss_rfbi_hwmod = {
	.name		= "dss_rfbi",
	.class		= &omap54xx_rfbi_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.sdma_reqs	= omap54xx_dss_rfbi_sdma_reqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_rfbi_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_rfbi_opt_clks),
	.slaves		= omap54xx_dss_rfbi_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_dss_rfbi_slaves),
};

/*
 * 'emif' class
 * external memory interface no1 (wrapper)
 */

static struct omap_hwmod_class omap54xx_emif_hwmod_class = {
	.name	= "emif",
};

/* emif1 */
static struct omap_hwmod omap54xx_emif1_hwmod;
static struct omap_hwmod_irq_info omap54xx_emif1_irqs[] = {
	{ .irq = 110 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* emif_ocp_fw -> emif1 */
static struct omap_hwmod_ocp_if omap54xx_emif_ocp_fw__emif1 = {
	.master		= &omap54xx_emif_ocp_fw_hwmod,
	.slave		= &omap54xx_emif1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_emif1_addrs[] = {
	{
		.pa_start	= 0x4c000000,
		.pa_end		= 0x4c0003ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* mpu -> emif1 */
static struct omap_hwmod_ocp_if omap54xx_mpu__emif1 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_emif1_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_emif1_addrs,
	.user		= OCP_USER_MPU,
};

/* emif1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_emif1_slaves[] = {
	&omap54xx_emif_ocp_fw__emif1,
	&omap54xx_mpu__emif1,
};

static struct omap_hwmod omap54xx_emif1_hwmod = {
	.name		= "emif1",
	.class		= &omap54xx_emif_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap54xx_emif1_irqs,
	.main_clk	= "dpll_core_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_emif1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_emif1_slaves),
};

/* emif2 */
static struct omap_hwmod omap54xx_emif2_hwmod;
static struct omap_hwmod_irq_info omap54xx_emif2_irqs[] = {
	{ .irq = 111 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* emif_ocp_fw -> emif2 */
static struct omap_hwmod_ocp_if omap54xx_emif_ocp_fw__emif2 = {
	.master		= &omap54xx_emif_ocp_fw_hwmod,
	.slave		= &omap54xx_emif2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap54xx_emif2_addrs[] = {
	{
		.pa_start	= 0x4d000000,
		.pa_end		= 0x4d0003ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* mpu -> emif2 */
static struct omap_hwmod_ocp_if omap54xx_mpu__emif2 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_emif2_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_emif2_addrs,
	.user		= OCP_USER_MPU,
};

/* emif2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_emif2_slaves[] = {
	&omap54xx_emif_ocp_fw__emif2,
	&omap54xx_mpu__emif2,
};

static struct omap_hwmod omap54xx_emif2_hwmod = {
	.name		= "emif2",
	.class		= &omap54xx_emif_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap54xx_emif2_irqs,
	.main_clk	= "dpll_core_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		}
	},
	.slaves		= omap54xx_emif2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_emif2_slaves),
};

/*
 * 'fdif' class
 * face detection hw accelerator module
 */

static struct omap_hwmod_class_sysconfig omap54xx_fdif_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	/*
	 * FDIF needs 100 OCP clk cycles delay after a softreset before
	 * accessing sysconfig again.
	 * The lowest frequency at the moment for L3 bus is 100 MHz, so
	 * 1usec delay is needed. Add an x2 margin to be safe (2 usecs).
	 *
	 * TODO: Indicate errata when available.
	 */
	.srst_udelay	= 2,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_fdif_hwmod_class = {
	.name = "fdif",
	.sysc = &omap54xx_fdif_sysc,
};

/* fdif */
static struct omap_hwmod_irq_info omap54xx_fdif_irqs[] = {
	{ .irq = 69 + OMAP44XX_IRQ_GIC_START },
	{}
};

/* fdif master ports */
static struct omap_hwmod_ocp_if *omap54xx_fdif_masters[] = {
	&omap54xx_fdif__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_fdif_addrs[] = {
	{
		.pa_start	= 0x4a10a000,
		.pa_end		= 0x4a10a1ff,
		.flags		= ADDR_TYPE_RT
	},
	{}
};

/* l4_cfg -> fdif */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__fdif = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_fdif_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_fdif_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* fdif slave ports */
static struct omap_hwmod_ocp_if *omap54xx_fdif_slaves[] = {
	&omap54xx_l4_cfg__fdif,
};

static struct omap_hwmod omap54xx_fdif_hwmod = {
	.name		= "fdif",
	.clkdm_name	= "cam_clkdm",
	.class		= &omap54xx_fdif_hwmod_class,
	.mpu_irqs	= omap54xx_fdif_irqs,
	.main_clk	= "fdif_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_CAM_FDIF_CLKCTRL_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_fdif_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_fdif_slaves),
	.masters	= omap54xx_fdif_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_fdif_masters),
};

/*
 * 'gpio' class
 * general purpose io module
 */

static struct omap_hwmod_class_sysconfig omap54xx_gpio_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0114,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_gpio_hwmod_class = {
	.name	= "gpio",
	.sysc	= &omap54xx_gpio_sysc,
	.rev	= 2,
};

/* gpio dev_attr */
static struct omap_gpio_dev_attr gpio_dev_attr = {
	.bank_width	= 32,
	.dbck_flag	= true,
};

/* gpio1 */
static struct omap_hwmod omap54xx_gpio1_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio1_irqs[] = {
	{ .irq = 29 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio1_addrs[] = {
	{
		.pa_start	= 0x4ae10000,
		.pa_end		= 0x4ae101ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> gpio1 */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__gpio1 = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_gpio1_hwmod,
	.clk		= "wkupaon_clk_mux_ck",
	.addr		= omap54xx_gpio1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio1_slaves[] = {
	&omap54xx_l4_wkup__gpio1,
};

static struct omap_hwmod_opt_clk gpio1_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio1_dbclk" },
};

static struct omap_hwmod omap54xx_gpio1_hwmod = {
	.name		= "gpio1",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.mpu_irqs	= omap54xx_gpio1_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_GPIO1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_GPIO1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio1_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio1_slaves),
};

/* gpio2 */
static struct omap_hwmod omap54xx_gpio2_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio2_irqs[] = {
	{ .irq = 30 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio2_addrs[] = {
	{
		.pa_start	= 0x48055000,
		.pa_end		= 0x480551ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio2 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio2 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio2_slaves[] = {
	&omap54xx_l4_per__gpio2,
};

static struct omap_hwmod_opt_clk gpio2_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio2_dbclk" },
};

static struct omap_hwmod omap54xx_gpio2_hwmod = {
	.name		= "gpio2",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap54xx_gpio2_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio2_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio2_slaves),
};

/* gpio3 */
static struct omap_hwmod omap54xx_gpio3_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio3_irqs[] = {
	{ .irq = 31 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio3_addrs[] = {
	{
		.pa_start	= 0x48057000,
		.pa_end		= 0x480571ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio3 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio3 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio3_slaves[] = {
	&omap54xx_l4_per__gpio3,
};

static struct omap_hwmod_opt_clk gpio3_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio3_dbclk" },
};

static struct omap_hwmod omap54xx_gpio3_hwmod = {
	.name		= "gpio3",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap54xx_gpio3_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio3_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio3_slaves),
};

/* gpio4 */
static struct omap_hwmod omap54xx_gpio4_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio4_irqs[] = {
	{ .irq = 32 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio4_addrs[] = {
	{
		.pa_start	= 0x48059000,
		.pa_end		= 0x480591ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio4 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio4 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio4 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio4_slaves[] = {
	&omap54xx_l4_per__gpio4,
};

static struct omap_hwmod_opt_clk gpio4_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio4_dbclk" },
};

static struct omap_hwmod omap54xx_gpio4_hwmod = {
	.name		= "gpio4",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap54xx_gpio4_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO4_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio4_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio4_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio4_slaves),
};

/* gpio5 */
static struct omap_hwmod omap54xx_gpio5_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio5_irqs[] = {
	{ .irq = 33 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio5_addrs[] = {
	{
		.pa_start	= 0x4805b000,
		.pa_end		= 0x4805b1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio5 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio5 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio5_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio5 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio5_slaves[] = {
	&omap54xx_l4_per__gpio5,
};

static struct omap_hwmod_opt_clk gpio5_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio5_dbclk" },
};

static struct omap_hwmod omap54xx_gpio5_hwmod = {
	.name		= "gpio5",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap54xx_gpio5_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO5_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio5_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio5_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio5_slaves),
};

/* gpio6 */
static struct omap_hwmod omap54xx_gpio6_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio6_irqs[] = {
	{ .irq = 34 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio6_addrs[] = {
	{
		.pa_start	= 0x4805d000,
		.pa_end		= 0x4805d1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio6 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio6 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio6_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio6_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio6 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio6_slaves[] = {
	&omap54xx_l4_per__gpio6,
};

static struct omap_hwmod_opt_clk gpio6_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio6_dbclk" },
};

static struct omap_hwmod omap54xx_gpio6_hwmod = {
	.name		= "gpio6",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap54xx_gpio6_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO6_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio6_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio6_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio6_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio6_slaves),
};

/* gpio7 */
static struct omap_hwmod omap54xx_gpio7_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio7_irqs[] = {
	{ .irq = 35 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio7_addrs[] = {
	{
		.pa_start	= 0x48051000,
		.pa_end		= 0x480511ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio7 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio7 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio7_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio7_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio7 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio7_slaves[] = {
	&omap54xx_l4_per__gpio7,
};

static struct omap_hwmod_opt_clk gpio7_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio7_dbclk" },
};

static struct omap_hwmod omap54xx_gpio7_hwmod = {
	.name		= "gpio7",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags          = HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap54xx_gpio7_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO7_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio7_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio7_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio7_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio7_slaves),
};

/* gpio8 */
static struct omap_hwmod omap54xx_gpio8_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpio8_irqs[] = {
	{ .irq = 121 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpio8_addrs[] = {
	{
		.pa_start	= 0x48053000,
		.pa_end		= 0x480531ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio8 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__gpio8 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_gpio8_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_gpio8_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio8 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpio8_slaves[] = {
	&omap54xx_l4_per__gpio8,
};

static struct omap_hwmod_opt_clk gpio8_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio8_dbclk" },
};

static struct omap_hwmod omap54xx_gpio8_hwmod = {
	.name		= "gpio8",
	.class		= &omap54xx_gpio_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags          = HWMOD_CONTROL_OPT_CLKS_IN_RESET | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap54xx_gpio8_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_GPIO8_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_GPIO8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio8_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio8_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap54xx_gpio8_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpio8_slaves),
};

/*
 * 'gpmc' class
 * general purpose memory controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_gpmc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_gpmc_hwmod_class = {
	.name	= "gpmc",
	.sysc	= &omap54xx_gpmc_sysc,
};

/* gpmc */
static struct omap_hwmod omap54xx_gpmc_hwmod;
static struct omap_hwmod_irq_info omap54xx_gpmc_irqs[] = {
	{ .irq = 20 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_gpmc_sdma_reqs[] = {
	{ .dma_req = 3 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_gpmc_addrs[] = {
	{
		.pa_start	= 0x50000000,
		.pa_end		= 0x500003ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> gpmc */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__gpmc = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_gpmc_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_gpmc_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpmc slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpmc_slaves[] = {
	&omap54xx_l3_main_2__gpmc,
};

static struct omap_hwmod omap54xx_gpmc_hwmod = {
	.name		= "gpmc",
	.class		= &omap54xx_gpmc_hwmod_class,
	.clkdm_name	= "l3main2_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap54xx_gpmc_irqs,
	.sdma_reqs	= omap54xx_gpmc_sdma_reqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN2_GPMC_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN2_GPMC_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_gpmc_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpmc_slaves),
};

/*
 * 'gpu' class
 * 2d/3d graphics accelerator
 */

static struct omap_hwmod_class_sysconfig omap54xx_gpu_sysc = {
	.rev_offs       = 0xfe00,
	.sysc_offs      = 0xfe10,
	.sysc_flags     = (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes      = (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
						SIDLE_SMART_WKUP),
	.sysc_fields    = &omap_hwmod_sysc_type2,

};

static struct omap_hwmod_class omap54xx_gpu_hwmod_class = {
	.name	= "gpu",
	.sysc	= &omap54xx_gpu_sysc,
};

/* gpu */
static struct omap_hwmod_irq_info omap54xx_gpu_irqs[] = {
	{ .irq = 21 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* gpu master ports */
static struct omap_hwmod_ocp_if *omap54xx_gpu_masters[] = {
	&omap54xx_gpu__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_gpu_addrs[] = {
	{
		.pa_start	= 0x56000000,
		.pa_end		= 0x5600ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> gpu */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__gpu = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_gpu_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_gpu_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpu slave ports */
static struct omap_hwmod_ocp_if *omap54xx_gpu_slaves[] = {
	&omap54xx_l3_main_2__gpu,
};

static struct omap_hwmod omap54xx_gpu_hwmod = {
	.name		= "gpu",
	.class		= &omap54xx_gpu_hwmod_class,
	.clkdm_name	= "gpu_clkdm",
	.mpu_irqs	= omap54xx_gpu_irqs,
	.main_clk	= "gpu_core_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_GPU_GPU_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_GPU_GPU_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_gpu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_gpu_slaves),
	.masters	= omap54xx_gpu_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_gpu_masters),
};

/*
 * 'hsi' class
 * mipi high-speed synchronous serial interface (multichannel and full-duplex
 * serial if)
 */

static struct omap_hwmod_class_sysconfig omap54xx_hsi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_EMUFREE |
			   SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_hsi_hwmod_class = {
	.name	= "hsi",
	.sysc	= &omap54xx_hsi_sysc,
};

/* hsi */
static struct omap_hwmod_irq_info omap54xx_hsi_irqs[] = {
	{ .name = "mpu_p1", .irq = 67 + OMAP54XX_IRQ_GIC_START },
	{ .name = "mpu_p2", .irq = 68 + OMAP54XX_IRQ_GIC_START },
	{ .name = "mpu_dma", .irq = 71 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* hsi master ports */
static struct omap_hwmod_ocp_if *omap54xx_hsi_masters[] = {
	&omap54xx_hsi__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_hsi_addrs[] = {
	{
		.pa_start	= 0x4a058000,
		.pa_end		= 0x4a05bfff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> hsi */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__hsi = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_hsi_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_hsi_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* hsi slave ports */
static struct omap_hwmod_ocp_if *omap54xx_hsi_slaves[] = {
	&omap54xx_l4_cfg__hsi,
};

static struct omap_hwmod omap54xx_hsi_hwmod = {
	.name		= "hsi",
	.class		= &omap54xx_hsi_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_hsi_irqs,
	.main_clk	= "hsi_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_HSI_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_HSI_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_hsi_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_hsi_slaves),
	.masters	= omap54xx_hsi_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_hsi_masters),
};

/*
 * 'i2c' class
 * multimaster high-speed i2c controller
 */

static struct omap_i2c_dev_attr i2c_dev_attr = {
	.flags	= OMAP_I2C_FLAG_BUS_SHIFT_NONE | OMAP_I2C_FLAG_RESET_REGS_POSTIDLE,
};

static struct omap_hwmod_class_sysconfig omap54xx_i2c_sysc = {
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0090,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_i2c_hwmod_class = {
	.name	= "i2c",
	.sysc	= &omap54xx_i2c_sysc,
	.rev	= OMAP_I2C_IP_VERSION_2,
	.reset	= &omap_i2c_reset,
};

/* i2c1 */
static struct omap_hwmod omap54xx_i2c1_hwmod;
static struct omap_hwmod_irq_info omap54xx_i2c1_irqs[] = {
	{ .irq = 56 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_i2c1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 26 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 27 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_i2c1_addrs[] = {
	{
		.pa_start	= 0x48070000,
		.pa_end		= 0x480700ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c1 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__i2c1 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_i2c1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_i2c1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_i2c1_slaves[] = {
	&omap54xx_l4_per__i2c1,
};

static struct omap_hwmod omap54xx_i2c1_hwmod = {
	.name		= "i2c1",
	.class		= &omap54xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.mpu_irqs	= omap54xx_i2c1_irqs,
	.sdma_reqs	= omap54xx_i2c1_sdma_reqs,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_I2C1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_I2C1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_i2c1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_i2c1_slaves),
	.dev_attr       = &i2c_dev_attr,
};

/* i2c2 */
static struct omap_hwmod omap54xx_i2c2_hwmod;
static struct omap_hwmod_irq_info omap54xx_i2c2_irqs[] = {
	{ .irq = 57 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_i2c2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 28 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 29 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_i2c2_addrs[] = {
	{
		.pa_start	= 0x48072000,
		.pa_end		= 0x480720ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c2 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__i2c2 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_i2c2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_i2c2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_i2c2_slaves[] = {
	&omap54xx_l4_per__i2c2,
};

static struct omap_hwmod omap54xx_i2c2_hwmod = {
	.name		= "i2c2",
	.class		= &omap54xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.mpu_irqs	= omap54xx_i2c2_irqs,
	.sdma_reqs	= omap54xx_i2c2_sdma_reqs,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_I2C2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_I2C2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_i2c2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_i2c2_slaves),
	.dev_attr       = &i2c_dev_attr,
};

/* i2c3 */
static struct omap_hwmod omap54xx_i2c3_hwmod;
static struct omap_hwmod_irq_info omap54xx_i2c3_irqs[] = {
	{ .irq = 61 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_i2c3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 24 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 25 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_i2c3_addrs[] = {
	{
		.pa_start	= 0x48060000,
		.pa_end		= 0x480600ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c3 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__i2c3 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_i2c3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_i2c3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_i2c3_slaves[] = {
	&omap54xx_l4_per__i2c3,
};

static struct omap_hwmod omap54xx_i2c3_hwmod = {
	.name		= "i2c3",
	.class		= &omap54xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.mpu_irqs	= omap54xx_i2c3_irqs,
	.sdma_reqs	= omap54xx_i2c3_sdma_reqs,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_I2C3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_I2C3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_i2c3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_i2c3_slaves),
	.dev_attr       = &i2c_dev_attr,
};

/* i2c4 */
static struct omap_hwmod omap54xx_i2c4_hwmod;
static struct omap_hwmod_irq_info omap54xx_i2c4_irqs[] = {
	{ .irq = 62 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_i2c4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 123 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 124 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_i2c4_addrs[] = {
	{
		.pa_start	= 0x4807a000,
		.pa_end		= 0x4807a0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c4 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__i2c4 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_i2c4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_i2c4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c4 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_i2c4_slaves[] = {
	&omap54xx_l4_per__i2c4,
};

static struct omap_hwmod omap54xx_i2c4_hwmod = {
	.name		= "i2c4",
	.class		= &omap54xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.mpu_irqs	= omap54xx_i2c4_irqs,
	.sdma_reqs	= omap54xx_i2c4_sdma_reqs,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_I2C4_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_I2C4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_i2c4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_i2c4_slaves),
	.dev_attr       = &i2c_dev_attr,
};

/* i2c5 */
static struct omap_hwmod omap54xx_i2c5_hwmod;
static struct omap_hwmod_irq_info omap54xx_i2c5_irqs[] = {
	{ .irq = 60 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_i2c5_addrs[] = {
	{
		.pa_start	= 0x4807c000,
		.pa_end		= 0x4807c0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c5 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__i2c5 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_i2c5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_i2c5_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c5 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_i2c5_slaves[] = {
	&omap54xx_l4_per__i2c5,
};

static struct omap_hwmod omap54xx_i2c5_hwmod = {
	.name		= "i2c5",
	.class		= &omap54xx_i2c_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_16BIT_REG | HWMOD_SET_DEFAULT_CLOCKACT,
	.mpu_irqs	= omap54xx_i2c5_irqs,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_I2C5_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_I2C5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_i2c5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_i2c5_slaves),
	.dev_attr       = &i2c_dev_attr,
};

/*
 * 'ipu' class
 * imaging processor unit
 */

/* ipu mmu attr */

static struct omap_mmu_dev_attr omap54xx_ipu_mmu_dev_attr = {
	.da_start = 0x0,
	.da_end = 0xfffff000,
	.nr_tlb_entries = 32,
};

static struct omap_hwmod_class omap54xx_ipu_hwmod_class = {
	.name	= "ipu",
};

/* ipu */
static struct omap_hwmod_irq_info omap54xx_ipu_irqs[] = {
	{ .irq = 100 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* IPU rst info structures changed back to omap4 scheme. */
static struct omap_hwmod_rst_info omap54xx_ipu_c0_resets[] = {
	{ .name = "cpu0", .rst_shift = 0 },
};

static struct omap_hwmod_rst_info omap54xx_ipu_c1_resets[] = {
	{ .name = "cpu1", .rst_shift = 1 },
};

static struct omap_hwmod_rst_info omap54xx_ipu_resets[] = {
	{ .name = "rst_cpu0", .rst_shift = 0 },
	{ .name = "rst_cpu1", .rst_shift = 1 },
	{ .name = "rst_ipu_mmu_cache", .rst_shift = 2 },
};

/* ipu master ports */
static struct omap_hwmod_ocp_if *omap54xx_ipu_masters[] = {
	&omap54xx_ipu__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_ipu_addrs[] = {
	{
		.pa_start	= 0x55082000,
		.pa_end		= 0x550820ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> ipu */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__ipu = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_ipu_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_ipu_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* ipu slave ports */
static struct omap_hwmod_ocp_if *omap54xx_ipu_slaves[] = {
	&omap54xx_l3_main_2__ipu,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap54xx_ipu_c0_hwmod = {
	.name		= "ipu_c0",
	.class		= &omap54xx_ipu_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.main_clk	= "ipu_fck",
	.rst_lines	= omap54xx_ipu_c0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_ipu_c0_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP54XX_RM_IPU_RSTCTRL_OFFSET,
		},
	},
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap54xx_ipu_c1_hwmod = {
	.name		= "ipu_c1",
	.class		= &omap54xx_ipu_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.main_clk	= "ipu_fck",
	.rst_lines	= omap54xx_ipu_c1_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_ipu_c1_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP54XX_RM_IPU_RSTCTRL_OFFSET,
		},
	},
};

static struct omap_hwmod omap54xx_ipu_hwmod = {
	.name		= "ipu",
	.class		= &omap54xx_mmu_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.mpu_irqs	= omap54xx_ipu_irqs,
	.rst_lines	= omap54xx_ipu_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_ipu_resets),
	.main_clk	= "ipu_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_IPU_IPU_CLKCTRL_OFFSET,
			.rstctrl_offs = OMAP54XX_RM_IPU_RSTCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_IPU_IPU_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.dev_attr	= &omap54xx_ipu_mmu_dev_attr,
	.slaves		= omap54xx_ipu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_ipu_slaves),
	.masters	= omap54xx_ipu_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_ipu_masters),
};

/*
 * 'iss' class
 * external images sensor pixel data processor
 */

static struct omap_hwmod_class_sysconfig omap54xx_iss_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	/*
	 * ISS needs 100 OCP clk cycles delay after a softreset before
	 * accessing sysconfig again.
	 * The lowest frequency at the moment for L3 bus is 100 MHz, so
	 * 1usec delay is needed. Add an x2 margin to be safe (2 usecs).
	 *
	 * TODO: Indicate errata when available.
	 */
	.srst_udelay	= 2,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_iss_hwmod_class = {
	.name	= "iss",
	.sysc	= &omap54xx_iss_sysc,
};

/* iss */
static struct omap_hwmod_irq_info omap54xx_iss_irqs[] = {
	{ .irq = 24 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_iss_sdma_reqs[] = {
	{ .name = "1", .dma_req = 8 + OMAP54XX_DMA_REQ_START },
	{ .name = "2", .dma_req = 9 + OMAP54XX_DMA_REQ_START },
	{ .name = "3", .dma_req = 11 + OMAP54XX_DMA_REQ_START },
	{ .name = "4", .dma_req = 12 + OMAP54XX_DMA_REQ_START },
	{ .name = "5", .dma_req = 30 + OMAP54XX_DMA_REQ_START },
	{ .name = "6", .dma_req = 31 + OMAP54XX_DMA_REQ_START },
	{ .name = "7", .dma_req = 125 + OMAP54XX_DMA_REQ_START },
	{ .name = "8", .dma_req = 126 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* iss master ports */
static struct omap_hwmod_ocp_if *omap54xx_iss_masters[] = {
	&omap54xx_iss__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_iss_addrs[] = {
	{
		.pa_start	= 0x52000000,
		.pa_end		= 0x520000ff,
		.flags		= ADDR_TYPE_RT
	},
	{}
};

/* l3_main_2 -> iss */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__iss = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_iss_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_iss_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* iss slave ports */
static struct omap_hwmod_ocp_if *omap54xx_iss_slaves[] = {
	&omap54xx_l3_main_2__iss,
};

static struct omap_hwmod_opt_clk iss_opt_clks[] = {
	{ .role = "ctrlclk", .clk = "iss_ctrlclk" },
};

static struct omap_hwmod omap54xx_iss_hwmod = {
	.name		= "iss",
	.class		= &omap54xx_iss_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.clkdm_name	= "cam_clkdm",
	.mpu_irqs	= omap54xx_iss_irqs,
	.sdma_reqs	= omap54xx_iss_sdma_reqs,
	.main_clk	= "iss_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_CAM_ISS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_CAM_ISS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= iss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(iss_opt_clks),
	.slaves		= omap54xx_iss_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_iss_slaves),
	.masters	= omap54xx_iss_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_iss_masters),
};

/*
 * 'iva' class
 * multi-standard video encoder/decoder hardware accelerator
 */

static struct omap_hwmod_class_sysconfig omap54xx_iva_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_iva_hwmod_class = {
	.name	= "iva",
	.sysc	= &omap54xx_iva_sysc,
};

static struct omap_hwmod_class omap54xx_iva_seq_hwmod_class = {
	.name	= "iva-seq",
};

/* iva */
static struct omap_hwmod_irq_info omap54xx_iva_irqs[] = {
	{ .name = "sync_1", .irq = 103 + OMAP54XX_IRQ_GIC_START },
	{ .name = "sync_0", .irq = 104 + OMAP54XX_IRQ_GIC_START },
	{ .name = "mailbox_0", .irq = 107 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_rst_info omap54xx_iva_resets[] = {
	{ .name = "logic", .rst_shift = 2 },
};

static struct omap_hwmod_rst_info omap54xx_iva_seq0_resets[] = {
	{ .name = "seq0", .rst_shift = 0 },
};

static struct omap_hwmod_rst_info omap54xx_iva_seq1_resets[] = {
	{ .name = "seq1", .rst_shift = 1 },
};

/* iva -> sl2if */
static struct omap_hwmod_ocp_if omap54xx_iva__sl2if = {
	.master		= &omap54xx_iva_hwmod,
	.slave		= &omap54xx_sl2if_hwmod,
	.clk		= "dpll_iva_h12x2_ck",
};

/* iva master ports */
static struct omap_hwmod_ocp_if *omap54xx_iva_masters[] = {
	&omap54xx_iva__sl2if,
	&omap54xx_iva__l3_main_2,
	&omap54xx_iva__l3_instr,
};

static struct omap_hwmod_addr_space omap54xx_iva_addrs[] = {
	{
		.pa_start	= 0x5a000000,
		.pa_end		= 0x5a07ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> iva */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__iva = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_iva_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap54xx_iva_addrs,
	.user		= OCP_USER_MPU,
};

/* iva slave ports */
static struct omap_hwmod_ocp_if *omap54xx_iva_slaves[] = {
	&omap54xx_dsp__iva,
	&omap54xx_l3_main_2__iva,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap54xx_iva_seq0_hwmod = {
	.name		= "iva_seq0",
	.class		= &omap54xx_iva_seq_hwmod_class,
	.clkdm_name	= "iva_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap54xx_iva_seq0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_iva_seq0_resets),
	.main_clk	= "iva_fck",
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP54XX_RM_IVA_RSTCTRL_OFFSET,
		},
	},
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap54xx_iva_seq1_hwmod = {
	.name		= "iva_seq1",
	.class		= &omap54xx_iva_seq_hwmod_class,
	.clkdm_name	= "iva_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap54xx_iva_seq1_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_iva_seq1_resets),
	.main_clk	= "iva_fck",
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP54XX_RM_IVA_RSTCTRL_OFFSET,
		},
	},
};

static struct omap_hwmod omap54xx_iva_hwmod = {
	.name		= "iva",
	.class		= &omap54xx_iva_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.clkdm_name	= "iva_clkdm",
	.mpu_irqs	= omap54xx_iva_irqs,
	.rst_lines	= omap54xx_iva_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap54xx_iva_resets),
	.main_clk	= "iva_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_IVA_IVA_CLKCTRL_OFFSET,
			.rstctrl_offs = OMAP54XX_RM_IVA_RSTCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_IVA_IVA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_iva_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_iva_slaves),
	.masters	= omap54xx_iva_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_iva_masters),
};

/*
 * 'kbd' class
 * keyboard controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_kbd_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSC_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_kbd_hwmod_class = {
	.name	= "kbd",
	.sysc	= &omap54xx_kbd_sysc,
};

/* kbd */
static struct omap_hwmod omap54xx_kbd_hwmod;
static struct omap_hwmod_irq_info omap54xx_kbd_irqs[] = {
	{ .irq = 120 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_kbd_addrs[] = {
	{
		.pa_start	= 0x4ae1c000,
		.pa_end		= 0x4ae1c07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> kbd */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__kbd = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_kbd_hwmod,
	.clk		= "wkupaon_clk_mux_ck",
	.addr		= omap54xx_kbd_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* kbd slave ports */
static struct omap_hwmod_ocp_if *omap54xx_kbd_slaves[] = {
	&omap54xx_l4_wkup__kbd,
};

static struct omap_hwmod omap54xx_kbd_hwmod = {
	.name		= "kbd",
	.class		= &omap54xx_kbd_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.mpu_irqs	= omap54xx_kbd_irqs,
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_KBD_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_KBD_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_kbd_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_kbd_slaves),
};

/*
 * 'mailbox' class
 * mailbox module allowing communication between the on-chip processors
 * useusing a queued mailbox-interrupt mechanism.
 */

static struct omap_hwmod_class_sysconfig omap54xx_mailbox_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_mailbox_hwmod_class = {
	.name	= "mailbox",
	.sysc	= &omap54xx_mailbox_sysc,
};

/* mailbox */
static struct omap_hwmod omap54xx_mailbox_hwmod;
static struct omap_hwmod_irq_info omap54xx_mailbox_irqs[] = {
	{ .irq = 26 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mailbox_addrs[] = {
	{
		.pa_start	= 0x4a0f4000,
		.pa_end		= 0x4a0f41ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> mailbox */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__mailbox = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_mailbox_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mailbox_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mailbox slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mailbox_slaves[] = {
	&omap54xx_l4_cfg__mailbox,
};

static struct omap_hwmod omap54xx_mailbox_hwmod = {
	.name		= "mailbox",
	.class		= &omap54xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.mpu_irqs	= omap54xx_mailbox_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4CFG_MAILBOX_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4CFG_MAILBOX_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_mailbox_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mailbox_slaves),
};

/*
 * 'mcbsp' class
 * multi channel buffered serial port controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_mcbsp_sysc = {
	.sysc_offs	= 0x008c,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_mcbsp_hwmod_class = {
	.name	= "mcbsp",
	.sysc	= &omap54xx_mcbsp_sysc,
	.rev	= MCBSP_CONFIG_TYPE4,
};

/* mcbsp1 */
static struct omap_hwmod omap54xx_mcbsp1_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcbsp1_irqs[] = {
	{ .name = "common", .irq = 17 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcbsp1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 32 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 33 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcbsp1_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x40122000,
		.pa_end		= 0x401220ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp1 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcbsp1 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcbsp1_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcbsp1_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_mcbsp1_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x49022000,
		.pa_end		= 0x490220ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp1 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcbsp1_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcbsp1_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcbsp1_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcbsp1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcbsp1_slaves[] = {
	&omap54xx_l4_abe__mcbsp1,
	&omap54xx_l4_abe__mcbsp1_dma,
};

#if 0 /* unreferenced */
static struct omap_hwmod_opt_clk mcbsp1_opt_clks[] = {
	{ .role = "pad_fck", .clk = "pad_clks" },
	{ .role = "prcm_fck", .clk = "mcbsp1_sync_mux_ck" },
};
#endif

static struct omap_hwmod omap54xx_mcbsp1_hwmod = {
	.name		= "mcbsp1",
	.class		= &omap54xx_mcbsp_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_mcbsp1_irqs,
	.sdma_reqs	= omap54xx_mcbsp1_sdma_reqs,
	.main_clk	= "mcbsp1_gfclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_MCBSP1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_MCBSP1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mcbsp1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcbsp1_slaves),
};

/* mcbsp2 */
static struct omap_hwmod omap54xx_mcbsp2_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcbsp2_irqs[] = {
	{ .name = "common", .irq = 22 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcbsp2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 16 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 17 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcbsp2_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x40124000,
		.pa_end		= 0x401240ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp2 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcbsp2 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcbsp2_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcbsp2_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_mcbsp2_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x49024000,
		.pa_end		= 0x490240ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp2 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcbsp2_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcbsp2_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcbsp2_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcbsp2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcbsp2_slaves[] = {
	&omap54xx_l4_abe__mcbsp2,
	&omap54xx_l4_abe__mcbsp2_dma,
};

#if 0 /* unreferenced */
static struct omap_hwmod_opt_clk mcbsp2_opt_clks[] = {
	{ .role = "pad_fck", .clk = "pad_clks" },
	{ .role = "prcm_fck", .clk = "mcbsp2_sync_mux_ck" },
};
#endif

static struct omap_hwmod omap54xx_mcbsp2_hwmod = {
	.name		= "mcbsp2",
	.class		= &omap54xx_mcbsp_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_mcbsp2_irqs,
	.sdma_reqs	= omap54xx_mcbsp2_sdma_reqs,
	.main_clk	= "mcbsp2_gfclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_MCBSP2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_MCBSP2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mcbsp2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcbsp2_slaves),
};

/* mcbsp3 */
static struct omap_hwmod omap54xx_mcbsp3_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcbsp3_irqs[] = {
	{ .name = "common", .irq = 23 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcbsp3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 18 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 19 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcbsp3_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x40126000,
		.pa_end		= 0x401260ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp3 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcbsp3 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcbsp3_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcbsp3_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_mcbsp3_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x49026000,
		.pa_end		= 0x490260ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp3 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcbsp3_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcbsp3_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcbsp3_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcbsp3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcbsp3_slaves[] = {
	&omap54xx_l4_abe__mcbsp3,
	&omap54xx_l4_abe__mcbsp3_dma,
};

#if 0 /* unreferenced */
static struct omap_hwmod_opt_clk mcbsp3_opt_clks[] = {
	{ .role = "pad_fck", .clk = "pad_clks" },
	{ .role = "prcm_fck", .clk = "mcbsp3_sync_mux_ck" },
};
#endif

static struct omap_hwmod omap54xx_mcbsp3_hwmod = {
	.name		= "mcbsp3",
	.class		= &omap54xx_mcbsp_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_mcbsp3_irqs,
	.sdma_reqs	= omap54xx_mcbsp3_sdma_reqs,
	.main_clk	= "mcbsp3_gfclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_MCBSP3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_MCBSP3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mcbsp3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcbsp3_slaves),
};

/*
 * 'mcpdm' class
 * multi channel pdm controller (proprietary interface with phoenix power
 * ic)
 */

static struct omap_hwmod_class_sysconfig omap54xx_mcpdm_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_mcpdm_hwmod_class = {
	.name	= "mcpdm",
	.sysc	= &omap54xx_mcpdm_sysc,
};

/* mcpdm */
static struct omap_hwmod omap54xx_mcpdm_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcpdm_irqs[] = {
	{ .irq = 112 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcpdm_sdma_reqs[] = {
	{ .name = "up_link", .dma_req = 64 + OMAP54XX_DMA_REQ_START },
	{ .name = "dn_link", .dma_req = 65 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcpdm_addrs[] = {
	{
		.pa_start	= 0x40132000,
		.pa_end		= 0x4013207f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcpdm */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcpdm = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcpdm_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcpdm_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_mcpdm_dma_addrs[] = {
	{
		.pa_start	= 0x49032000,
		.pa_end		= 0x4903207f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcpdm (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__mcpdm_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_mcpdm_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_mcpdm_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcpdm slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcpdm_slaves[] = {
	&omap54xx_l4_abe__mcpdm,
	&omap54xx_l4_abe__mcpdm_dma,
};

static struct omap_hwmod omap54xx_mcpdm_hwmod = {
	.name		= "mcpdm",
	.class		= &omap54xx_mcpdm_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_mcpdm_irqs,
	.sdma_reqs	= omap54xx_mcpdm_sdma_reqs,
	.main_clk	= "pad_clks_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_MCPDM_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_MCPDM_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mcpdm_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcpdm_slaves),
};

/*
 * 'mcspi' class
 * multichannel serial port interface (mcspi) / master/slave synchronous serial
 * bus
 */

static struct omap_hwmod_class_sysconfig omap54xx_mcspi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_mcspi_hwmod_class = {
	.name	= "mcspi",
	.sysc	= &omap54xx_mcspi_sysc,
	.rev	= OMAP4_MCSPI_REV,
};

/* mcspi1 */
static struct omap_hwmod omap54xx_mcspi1_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcspi1_irqs[] = {
	{ .irq = 65 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcspi1_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 34 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 35 + OMAP54XX_DMA_REQ_START },
	{ .name = "tx1", .dma_req = 36 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx1", .dma_req = 37 + OMAP54XX_DMA_REQ_START },
	{ .name = "tx2", .dma_req = 38 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx2", .dma_req = 39 + OMAP54XX_DMA_REQ_START },
	{ .name = "tx3", .dma_req = 40 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx3", .dma_req = 41 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcspi1_addrs[] = {
	{
		.pa_start	= 0x48098000,
		.pa_end		= 0x480981ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi1 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mcspi1 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mcspi1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mcspi1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcspi1_slaves[] = {
	&omap54xx_l4_per__mcspi1,
};

/* mcspi1 dev_attr */
static struct omap2_mcspi_dev_attr mcspi1_dev_attr = {
	.num_chipselect	= 4,
};

static struct omap_hwmod omap54xx_mcspi1_hwmod = {
	.name		= "mcspi1",
	.class		= &omap54xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mcspi1_irqs,
	.sdma_reqs	= omap54xx_mcspi1_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MCSPI1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MCSPI1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi1_dev_attr,
	.slaves		= omap54xx_mcspi1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcspi1_slaves),
};

/* mcspi2 */
static struct omap_hwmod omap54xx_mcspi2_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcspi2_irqs[] = {
	{ .irq = 66 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcspi2_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 42 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 43 + OMAP54XX_DMA_REQ_START },
	{ .name = "tx1", .dma_req = 44 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx1", .dma_req = 45 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcspi2_addrs[] = {
	{
		.pa_start	= 0x4809a000,
		.pa_end		= 0x4809a1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi2 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mcspi2 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mcspi2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mcspi2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcspi2_slaves[] = {
	&omap54xx_l4_per__mcspi2,
};

/* mcspi2 dev_attr */
static struct omap2_mcspi_dev_attr mcspi2_dev_attr = {
	.num_chipselect	= 2,
};

static struct omap_hwmod omap54xx_mcspi2_hwmod = {
	.name		= "mcspi2",
	.class		= &omap54xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mcspi2_irqs,
	.sdma_reqs	= omap54xx_mcspi2_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MCSPI2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MCSPI2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi2_dev_attr,
	.slaves		= omap54xx_mcspi2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcspi2_slaves),
};

/* mcspi3 */
static struct omap_hwmod omap54xx_mcspi3_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcspi3_irqs[] = {
	{ .irq = 91 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcspi3_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 14 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 15 + OMAP54XX_DMA_REQ_START },
	{ .name = "tx1", .dma_req = 22 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx1", .dma_req = 23 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcspi3_addrs[] = {
	{
		.pa_start	= 0x480b8000,
		.pa_end		= 0x480b81ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi3 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mcspi3 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mcspi3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mcspi3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcspi3_slaves[] = {
	&omap54xx_l4_per__mcspi3,
};

/* mcspi3 dev_attr */
static struct omap2_mcspi_dev_attr mcspi3_dev_attr = {
	.num_chipselect	= 2,
};

static struct omap_hwmod omap54xx_mcspi3_hwmod = {
	.name		= "mcspi3",
	.class		= &omap54xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mcspi3_irqs,
	.sdma_reqs	= omap54xx_mcspi3_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MCSPI3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MCSPI3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi3_dev_attr,
	.slaves		= omap54xx_mcspi3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcspi3_slaves),
};

/* mcspi4 */
static struct omap_hwmod omap54xx_mcspi4_hwmod;
static struct omap_hwmod_irq_info omap54xx_mcspi4_irqs[] = {
	{ .irq = 48 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mcspi4_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 69 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 70 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mcspi4_addrs[] = {
	{
		.pa_start	= 0x480ba000,
		.pa_end		= 0x480ba1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi4 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mcspi4 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mcspi4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mcspi4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi4 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mcspi4_slaves[] = {
	&omap54xx_l4_per__mcspi4,
};

/* mcspi4 dev_attr */
static struct omap2_mcspi_dev_attr mcspi4_dev_attr = {
	.num_chipselect	= 1,
};

static struct omap_hwmod omap54xx_mcspi4_hwmod = {
	.name		= "mcspi4",
	.class		= &omap54xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mcspi4_irqs,
	.sdma_reqs	= omap54xx_mcspi4_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MCSPI4_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MCSPI4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi4_dev_attr,
	.slaves		= omap54xx_mcspi4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mcspi4_slaves),
};

/*
 * 'mmc' class
 * multimedia card high-speed/sd/sdio (mmc/sd/sdio) host controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_mmc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_mmc_hwmod_class = {
	.name	= "mmc",
	.sysc	= &omap54xx_mmc_sysc,
};

/* mmc1 */
static struct omap_hwmod_irq_info omap54xx_mmc1_irqs[] = {
	{ .irq = 83 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mmc1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 60 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 61 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* mmc1 master ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc1_masters[] = {
	&omap54xx_mmc1__l3_main_1,
};

static struct omap_hwmod_addr_space omap54xx_mmc1_addrs[] = {
	{
		.pa_start	= 0x4809c000,
		.pa_end		= 0x4809c3ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc1 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mmc1 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mmc1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mmc1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc1_slaves[] = {
	&omap54xx_l4_per__mmc1,
};

/* mmc1 dev_attr */
static struct omap_mmc_dev_attr mmc1_dev_attr = {
	.flags	= OMAP_HSMMC_SUPPORTS_DUAL_VOLT,
};

static struct omap_hwmod omap54xx_mmc1_hwmod = {
	.name		= "mmc1",
	.class		= &omap54xx_mmc_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_mmc1_irqs,
	.sdma_reqs	= omap54xx_mmc1_sdma_reqs,
	.main_clk	= "mmc1_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_MMC1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_MMC1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mmc1_dev_attr,
	.slaves		= omap54xx_mmc1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mmc1_slaves),
	.masters	= omap54xx_mmc1_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_mmc1_masters),
};

/* mmc2 */
static struct omap_hwmod_irq_info omap54xx_mmc2_irqs[] = {
	{ .irq = 86 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mmc2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 46 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 47 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* mmc2 master ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc2_masters[] = {
	&omap54xx_mmc2__l3_main_1,
};

static struct omap_hwmod_addr_space omap54xx_mmc2_addrs[] = {
	{
		.pa_start	= 0x480b4000,
		.pa_end		= 0x480b43ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc2 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mmc2 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mmc2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mmc2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc2_slaves[] = {
	&omap54xx_l4_per__mmc2,
};

static struct omap_hwmod omap54xx_mmc2_hwmod = {
	.name		= "mmc2",
	.class		= &omap54xx_mmc_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_mmc2_irqs,
	.sdma_reqs	= omap54xx_mmc2_sdma_reqs,
	.main_clk	= "mmc2_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_MMC2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_MMC2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mmc2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mmc2_slaves),
	.masters	= omap54xx_mmc2_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_mmc2_masters),
};

/* mmc3 */
static struct omap_hwmod omap54xx_mmc3_hwmod;
static struct omap_hwmod_irq_info omap54xx_mmc3_irqs[] = {
	{ .irq = 94 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mmc3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 76 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 77 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mmc3_addrs[] = {
	{
		.pa_start	= 0x480ad000,
		.pa_end		= 0x480ad3ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc3 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mmc3 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mmc3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mmc3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc3_slaves[] = {
	&omap54xx_l4_per__mmc3,
};

static struct omap_hwmod omap54xx_mmc3_hwmod = {
	.name		= "mmc3",
	.class		= &omap54xx_mmc_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mmc3_irqs,
	.sdma_reqs	= omap54xx_mmc3_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MMC3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MMC3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mmc3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mmc3_slaves),
};

/* mmc4 */
static struct omap_hwmod omap54xx_mmc4_hwmod;
static struct omap_hwmod_irq_info omap54xx_mmc4_irqs[] = {
	{ .irq = 96 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mmc4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 56 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 57 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mmc4_addrs[] = {
	{
		.pa_start	= 0x480d1000,
		.pa_end		= 0x480d13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc4 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mmc4 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mmc4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mmc4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc4 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc4_slaves[] = {
	&omap54xx_l4_per__mmc4,
};

static struct omap_hwmod omap54xx_mmc4_hwmod = {
	.name		= "mmc4",
	.class		= &omap54xx_mmc_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mmc4_irqs,
	.sdma_reqs	= omap54xx_mmc4_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MMC4_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MMC4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mmc4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mmc4_slaves),
};

/* mmc5 */
static struct omap_hwmod omap54xx_mmc5_hwmod;
static struct omap_hwmod_irq_info omap54xx_mmc5_irqs[] = {
	{ .irq = 59 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_mmc5_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 58 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 59 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_mmc5_addrs[] = {
	{
		.pa_start	= 0x480d5000,
		.pa_end		= 0x480d53ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc5 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__mmc5 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_mmc5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mmc5_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc5 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mmc5_slaves[] = {
	&omap54xx_l4_per__mmc5,
};

static struct omap_hwmod omap54xx_mmc5_hwmod = {
	.name		= "mmc5",
	.class		= &omap54xx_mmc_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_mmc5_irqs,
	.sdma_reqs	= omap54xx_mmc5_sdma_reqs,
	.main_clk	= "func_96m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_MMC5_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_MMC5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_mmc5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mmc5_slaves),
};


/*
 * 'sl2if' class
 * shared level 2 memory interface
 */

static struct omap_hwmod_class omap54xx_sl2if_hwmod_class = {
	.name = "sl2if",
};

/* sl2if */
/* l3_main_2 -> sl2if */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__sl2if = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_sl2if_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* sl2if slave ports */
static struct omap_hwmod_ocp_if *omap54xx_sl2if_slaves[] = {
	&omap54xx_l3_main_2__sl2if,
	&omap54xx_iva__sl2if,
	&omap54xx_dsp__sl2if,
};

static struct omap_hwmod omap54xx_sl2if_hwmod = {
	.name		= "sl2if",
	.class		= &omap54xx_sl2if_hwmod_class,
	.clkdm_name	= "iva_clkdm",
	.main_clk	= "sl2if_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_IVA_SL2_CLKCTRL_OFFSET,
		},
	},
	.slaves		= omap54xx_sl2if_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_sl2if_slaves),
};

/*
 * 'mpu' class
 * mpu sub-system
 */

static struct omap_hwmod_class omap54xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod_irq_info omap54xx_mpu_irqs[] = {
	{ .name = "cmu_mpu", .irq = 6 + OMAP54XX_IRQ_GIC_START },
	{ .name = "mpu_cluster", .irq = 132 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* mpu master ports */
static struct omap_hwmod_ocp_if *omap54xx_mpu_masters[] = {
	&omap54xx_mpu__l3_main_1,
	&omap54xx_mpu__l4_abe,
	&omap54xx_mpu__emif1,
	&omap54xx_mpu__emif2,
};

static struct omap_hwmod_addr_space omap54xx_mpu_addrs[] = {
	{
		.pa_start	= 0x48211000,
		.pa_end		= 0x48310fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> mpu */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__mpu = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_mpu_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_mpu_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu slave ports */
static struct omap_hwmod_ocp_if *omap54xx_mpu_slaves[] = {
	&omap54xx_l4_cfg__mpu,
};

static struct omap_hwmod omap54xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &omap54xx_mpu_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap54xx_mpu_irqs,
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_MPU_MPU_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_MPU_MPU_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_mpu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_mpu_slaves),
	.masters	= omap54xx_mpu_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_mpu_masters),
};

/*
 * 'ocp2scp' class
 * bridge to transform ocp interface protocol to scp (serial control port)
 * protocol
 */
static struct omap_hwmod_class_sysconfig omap54xx_ocp2scp_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_ocp2scp_hwmod_class = {
	.name	= "ocp2scp",
	.sysc	= &omap54xx_ocp2scp_sysc,
};

/* ocp2scp3 */
static struct omap_hwmod omap54xx_ocp2scp3_hwmod;
static struct omap_hwmod_addr_space omap54xx_ocp2scp3_addrs[] = {
	{
		.name		= "ocp2scp3",
		.pa_start	= 0x4a090000,
		.pa_end		= 0x4a09001f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> ocp2scp3 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__ocp2scp3 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_ocp2scp3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_ocp2scp3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* ocp2scp3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_ocp2scp3_slaves[] = {
	&omap54xx_l4_cfg__ocp2scp3,
};

static struct omap_hwmod omap54xx_ocp2scp3_hwmod = {
	.name		= "ocp2scp3",
	.class		= &omap54xx_ocp2scp_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_OCP2SCP3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_OCP2SCP3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap54xx_ocp2scp3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_ocp2scp3_slaves),
};

/*
 * 'sata' class
 * sata:  serial ata interface  gen2 compliant   ( 1 rx/ 1 tx)
 */

static struct omap_hwmod_class_sysconfig omap54xx_sata_sysc = {
	.sysc_offs	= 0x0000,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_sata_hwmod_class = {
	.name	= "sata",
	.sysc	= &omap54xx_sata_sysc,
};

/* sata */
static struct omap_hwmod_irq_info omap54xx_sata_irqs[] = {
	{ .irq = 54 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* sata master ports */
static struct omap_hwmod_ocp_if *omap54xx_sata_masters[] = {
	&omap54xx_sata__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_sata_addrs[] = {

	/*
	 * ahci address space should be always the first element
	 * for the ahci platform driver.
	 */
	{
		.name		= "ahci",
		.pa_start	= 0x4a140000,
		.pa_end		= 0x4a1410ff,
	},
	{
		.name		= "sysc",
		.pa_start	= 0x4A141100,
		.pa_end		= 0x4A141104,
		.flags		= ADDR_TYPE_RT
	},

#if (!defined(CONFIG_MACH_OMAP_5430ZEBU))
	/*
	 * - TODO -
	 * Following PLL addresses will be removed in future,
	 * once the SATA Phy is made as seperate platform driver.
	 */
	{
		.name		= "pll",
		.pa_start	= 0x4A096800,
		.pa_end		= 0x4A096840,
	},
	{
		.name		= "rx",
		.pa_start	= 0x4A096000,
		.pa_end		= 0x4A096080,
	},
	{
		.name		= "tx",
		.pa_start	= 0x4A096400,
		.pa_end		= 0x4A096464,
	},
#endif
	{ }
};

/* l4_cfg -> sata */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__sata = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_sata_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_sata_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* sata slave ports */
static struct omap_hwmod_ocp_if *omap54xx_sata_slaves[] = {
	&omap54xx_l4_cfg__sata,
};

static struct omap_hwmod_opt_clk sata_opt_clks[] = {
	{ .role = "ref_clk", .clk = "sata_ref_clk" },
};

static struct omap_hwmod omap54xx_sata_hwmod = {
	.name		= "sata",
	.class		= &omap54xx_sata_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_sata_irqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_SATA_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_SATA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= sata_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(sata_opt_clks),
	.slaves		= omap54xx_sata_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_sata_slaves),
	.masters	= omap54xx_sata_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_sata_masters),
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
};

/*
 * 'smartreflex' class
 * smartreflex module (monitor silicon performance and outputs a measure of
 * performance error)
 */

/* The IP is not compliant to type1 / type2 scheme */
static struct omap_hwmod_sysc_fields omap_hwmod_sysc_type_smartreflex = {
	.sidle_shift	= 24,
	.enwkup_shift	= 26,
};

static struct omap_hwmod_class_sysconfig omap54xx_smartreflex_sysc = {
	.sysc_offs	= 0x0038,
	.sysc_flags	= (SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type_smartreflex,
};

static struct omap_hwmod_class omap54xx_smartreflex_hwmod_class = {
	.name	= "smartreflex",
	.sysc	= &omap54xx_smartreflex_sysc,
	.rev	= 2,
};

/* smartreflex_core */
/* smartreflex_core */
static struct omap_smartreflex_dev_attr smartreflex_core_dev_attr = {
	.sensor_voltdm_name   = "core",
};

static struct omap_hwmod omap54xx_smartreflex_core_hwmod;
static struct omap_hwmod_irq_info omap54xx_smartreflex_core_irqs[] = {
	{ .irq = 19 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_smartreflex_core_addrs[] = {
	{
		.pa_start	= 0x4a0dd000,
		.pa_end		= 0x4a0dd03f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_core */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__smartreflex_core = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_smartreflex_core_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_smartreflex_core_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_core slave ports */
static struct omap_hwmod_ocp_if *omap54xx_smartreflex_core_slaves[] = {
	&omap54xx_l4_cfg__smartreflex_core,
};

static struct omap_hwmod omap54xx_smartreflex_core_hwmod = {
	.name		= "smartreflex_core",
	.class		= &omap54xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.mpu_irqs	= omap54xx_smartreflex_core_irqs,
	.main_clk	= "wkupaon_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_COREAON_SMARTREFLEX_CORE_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_COREAON_SMARTREFLEX_CORE_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_smartreflex_core_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_smartreflex_core_slaves),
	.dev_attr       = &smartreflex_core_dev_attr,
};

/* smartreflex_mm */
static struct omap_smartreflex_dev_attr smartreflex_mm_dev_attr = {
	.sensor_voltdm_name   = "mm",
};

static struct omap_hwmod omap54xx_smartreflex_mm_hwmod;
static struct omap_hwmod_irq_info omap54xx_smartreflex_mm_irqs[] = {
	{ .irq = 102 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_smartreflex_mm_addrs[] = {
	{
		.pa_start	= 0x4a0db000,
		.pa_end		= 0x4a0db03f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_mm */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__smartreflex_mm = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_smartreflex_mm_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_smartreflex_mm_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_mm slave ports */
static struct omap_hwmod_ocp_if *omap54xx_smartreflex_mm_slaves[] = {
	&omap54xx_l4_cfg__smartreflex_mm,
};

static struct omap_hwmod omap54xx_smartreflex_mm_hwmod = {
	.name		= "smartreflex_mm",
	.class		= &omap54xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.mpu_irqs	= omap54xx_smartreflex_mm_irqs,
	.main_clk	= "wkupaon_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_COREAON_SMARTREFLEX_MM_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_COREAON_SMARTREFLEX_MM_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_smartreflex_mm_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_smartreflex_mm_slaves),
	.dev_attr       = &smartreflex_mm_dev_attr,
};

/* smartreflex_mpu */
static struct omap_smartreflex_dev_attr smartreflex_mpu_dev_attr = {
	.sensor_voltdm_name   = "mpu",
};
static struct omap_hwmod omap54xx_smartreflex_mpu_hwmod;
static struct omap_hwmod_irq_info omap54xx_smartreflex_mpu_irqs[] = {
	{ .irq = 18 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_smartreflex_mpu_addrs[] = {
	{
		.pa_start	= 0x4a0d9000,
		.pa_end		= 0x4a0d903f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_mpu */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__smartreflex_mpu = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_smartreflex_mpu_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_smartreflex_mpu_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_mpu slave ports */
static struct omap_hwmod_ocp_if *omap54xx_smartreflex_mpu_slaves[] = {
	&omap54xx_l4_cfg__smartreflex_mpu,
};

static struct omap_hwmod omap54xx_smartreflex_mpu_hwmod = {
	.name		= "smartreflex_mpu",
	.class		= &omap54xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.mpu_irqs	= omap54xx_smartreflex_mpu_irqs,
	.main_clk	= "wkupaon_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_COREAON_SMARTREFLEX_MPU_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_COREAON_SMARTREFLEX_MPU_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_smartreflex_mpu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_smartreflex_mpu_slaves),
	.dev_attr       = &smartreflex_mpu_dev_attr,
};

/*
 * 'spinlock' class
 * spinlock provides hardware assistance for synchronizing the processes
 * running on multiple processors
 */

static struct omap_hwmod_class_sysconfig omap54xx_spinlock_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_spinlock_hwmod_class = {
	.name	= "spinlock",
	.sysc	= &omap54xx_spinlock_sysc,
};

/* spinlock */
static struct omap_hwmod omap54xx_spinlock_hwmod;
static struct omap_hwmod_addr_space omap54xx_spinlock_addrs[] = {
	{
		.pa_start	= 0x4a0f6000,
		.pa_end		= 0x4a0f6fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> spinlock */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__spinlock = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_spinlock_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_spinlock_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* spinlock slave ports */
static struct omap_hwmod_ocp_if *omap54xx_spinlock_slaves[] = {
	&omap54xx_l4_cfg__spinlock,
};

static struct omap_hwmod omap54xx_spinlock_hwmod = {
	.name		= "spinlock",
	.class		= &omap54xx_spinlock_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4CFG_SPINLOCK_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4CFG_SPINLOCK_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap54xx_spinlock_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_spinlock_slaves),
};

/*
 * 'timer' class
 * general purpose timer module with accurate 1ms tick
 * This class contains several variants: ['timer_1ms', 'timer']
 */

static struct omap_hwmod_class_sysconfig omap54xx_timer_1ms_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_timer_1ms_hwmod_class = {
	.name	= "timer",
	.sysc	= &omap54xx_timer_1ms_sysc,
};

static struct omap_hwmod_class_sysconfig omap54xx_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_timer_hwmod_class = {
	.name	= "timer",
	.sysc	= &omap54xx_timer_sysc,
};

/* timer1 */
static struct omap_hwmod omap54xx_timer1_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer1_irqs[] = {
	{ .irq = 37 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer1_addrs[] = {
	{
		.pa_start	= 0x4ae18000,
		.pa_end		= 0x4ae1807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> timer1 */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__timer1 = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_timer1_hwmod,
	.clk		= "wkupaon_clk_mux_ck",
	.addr		= omap54xx_timer1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer1_slaves[] = {
	&omap54xx_l4_wkup__timer1,
};

static struct omap_hwmod omap54xx_timer1_hwmod = {
	.name		= "timer1",
	.class		= &omap54xx_timer_1ms_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.mpu_irqs	= omap54xx_timer1_irqs,
	.main_clk	= "timer1_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_TIMER1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_TIMER1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer1_slaves),
};

/* timer2 */
static struct omap_hwmod omap54xx_timer2_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer2_irqs[] = {
	{ .irq = 38 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer2_addrs[] = {
	{
		.pa_start	= 0x48032000,
		.pa_end		= 0x4803207f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer2 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__timer2 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_timer2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_timer2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer2_slaves[] = {
	&omap54xx_l4_per__timer2,
};

static struct omap_hwmod omap54xx_timer2_hwmod = {
	.name		= "timer2",
	.class		= &omap54xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_timer2_irqs,
	.main_clk	= "timer2_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_TIMER2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_TIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer2_slaves),
};

/* timer3 */
static struct omap_hwmod omap54xx_timer3_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer3_irqs[] = {
	{ .irq = 39 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer3_addrs[] = {
	{
		.pa_start	= 0x48034000,
		.pa_end		= 0x4803407f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer3 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__timer3 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_timer3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_timer3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer3_slaves[] = {
	&omap54xx_l4_per__timer3,
};

static struct omap_hwmod omap54xx_timer3_hwmod = {
	.name		= "timer3",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_timer3_irqs,
	.main_clk	= "timer3_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_TIMER3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_TIMER3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer3_slaves),
};

/* timer4 */
static struct omap_hwmod omap54xx_timer4_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer4_irqs[] = {
	{ .irq = 40 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer4_addrs[] = {
	{
		.pa_start	= 0x48036000,
		.pa_end		= 0x4803607f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer4 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__timer4 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_timer4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_timer4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer4 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer4_slaves[] = {
	&omap54xx_l4_per__timer4,
};

static struct omap_hwmod omap54xx_timer4_hwmod = {
	.name		= "timer4",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_timer4_irqs,
	.main_clk	= "timer4_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_TIMER4_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_TIMER4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer4_slaves),
};

/* timer5 */
static struct omap_hwmod omap54xx_timer5_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer5_irqs[] = {
	{ .irq = 41 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer5_addrs[] = {
	{
		.pa_start	= 0x40138000,
		.pa_end		= 0x4013807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer5 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer5 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer5_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer5_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_timer5_dma_addrs[] = {
	{
		.pa_start	= 0x49038000,
		.pa_end		= 0x4903807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer5 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer5_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer5_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer5_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer5 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer5_slaves[] = {
	&omap54xx_l4_abe__timer5,
	&omap54xx_l4_abe__timer5_dma,
};

static struct omap_hwmod omap54xx_timer5_hwmod = {
	.name		= "timer5",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_timer5_irqs,
	.main_clk	= "timer5_sync_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_TIMER5_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_TIMER5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer5_slaves),
};

/* timer6 */
static struct omap_hwmod omap54xx_timer6_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer6_irqs[] = {
	{ .irq = 42 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer6_addrs[] = {
	{
		.pa_start	= 0x4013a000,
		.pa_end		= 0x4013a07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer6 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer6 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer6_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer6_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_timer6_dma_addrs[] = {
	{
		.pa_start	= 0x4903a000,
		.pa_end		= 0x4903a07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer6 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer6_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer6_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer6_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer6 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer6_slaves[] = {
	&omap54xx_l4_abe__timer6,
	&omap54xx_l4_abe__timer6_dma,
};

static struct omap_hwmod omap54xx_timer6_hwmod = {
	.name		= "timer6",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_timer6_irqs,
	.main_clk	= "timer6_sync_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_TIMER6_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_TIMER6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer6_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer6_slaves),
};

/* timer7 */
static struct omap_hwmod omap54xx_timer7_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer7_irqs[] = {
	{ .irq = 43 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer7_addrs[] = {
	{
		.pa_start	= 0x4013c000,
		.pa_end		= 0x4013c07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer7 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer7 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer7_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer7_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_timer7_dma_addrs[] = {
	{
		.pa_start	= 0x4903c000,
		.pa_end		= 0x4903c07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer7 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer7_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer7_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer7_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer7 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer7_slaves[] = {
	&omap54xx_l4_abe__timer7,
	&omap54xx_l4_abe__timer7_dma,
};

static struct omap_hwmod omap54xx_timer7_hwmod = {
	.name		= "timer7",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_timer7_irqs,
	.main_clk	= "timer7_sync_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_TIMER7_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_TIMER7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer7_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer7_slaves),
};

/* timer8 */
static struct omap_hwmod omap54xx_timer8_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer8_irqs[] = {
	{ .irq = 44 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer8_addrs[] = {
	{
		.pa_start	= 0x4013e000,
		.pa_end		= 0x4013e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer8 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer8 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer8_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer8_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_timer8_dma_addrs[] = {
	{
		.pa_start	= 0x4903e000,
		.pa_end		= 0x4903e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer8 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__timer8_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_timer8_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_timer8_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer8 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer8_slaves[] = {
	&omap54xx_l4_abe__timer8,
	&omap54xx_l4_abe__timer8_dma,
};

static struct omap_hwmod omap54xx_timer8_hwmod = {
	.name		= "timer8",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_timer8_irqs,
	.main_clk	= "timer8_sync_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_TIMER8_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_TIMER8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer8_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer8_slaves),
};

/* timer9 */
static struct omap_hwmod omap54xx_timer9_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer9_irqs[] = {
	{ .irq = 45 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer9_addrs[] = {
	{
		.pa_start	= 0x4803e000,
		.pa_end		= 0x4803e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer9 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__timer9 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_timer9_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_timer9_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer9 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer9_slaves[] = {
	&omap54xx_l4_per__timer9,
};

static struct omap_hwmod omap54xx_timer9_hwmod = {
	.name		= "timer9",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_timer9_irqs,
	.main_clk	= "timer9_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_TIMER9_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_TIMER9_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer9_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer9_slaves),
};

/* timer10 */
static struct omap_hwmod omap54xx_timer10_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer10_irqs[] = {
	{ .irq = 46 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer10_addrs[] = {
	{
		.pa_start	= 0x48086000,
		.pa_end		= 0x4808607f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer10 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__timer10 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_timer10_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_timer10_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer10 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer10_slaves[] = {
	&omap54xx_l4_per__timer10,
};

static struct omap_hwmod omap54xx_timer10_hwmod = {
	.name		= "timer10",
	.class		= &omap54xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_timer10_irqs,
	.main_clk	= "timer10_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_TIMER10_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_TIMER10_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer10_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer10_slaves),
};

/* timer11 */
static struct omap_hwmod omap54xx_timer11_hwmod;
static struct omap_hwmod_irq_info omap54xx_timer11_irqs[] = {
	{ .irq = 47 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_timer11_addrs[] = {
	{
		.pa_start	= 0x48088000,
		.pa_end		= 0x4808807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer11 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__timer11 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_timer11_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_timer11_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer11 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_timer11_slaves[] = {
	&omap54xx_l4_per__timer11,
};

static struct omap_hwmod omap54xx_timer11_hwmod = {
	.name		= "timer11",
	.class		= &omap54xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_timer11_irqs,
	.main_clk	= "timer11_clk_mux_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_TIMER11_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_TIMER11_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_timer11_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_timer11_slaves),
};

/*
 * 'uart' class
 * universal asynchronous receiver/transmitter (uart)
 */

static struct omap_hwmod_class_sysconfig omap54xx_uart_sysc = {
	.rev_offs	= 0x0050,
	.sysc_offs	= 0x0054,
	.syss_offs	= 0x0058,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART | SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_uart_hwmod_class = {
	.name	= "uart",
	.sysc	= &omap54xx_uart_sysc,
};

/* uart1 */
static struct omap_hwmod omap54xx_uart1_hwmod;
static struct omap_hwmod_irq_info omap54xx_uart1_irqs[] = {
	{ .irq = 72 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_uart1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 48 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 49 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_uart1_addrs[] = {
	{
		.pa_start	= 0x4806a000,
		.pa_end		= 0x4806a0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart1 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__uart1 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_uart1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_uart1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart1 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_uart1_slaves[] = {
	&omap54xx_l4_per__uart1,
};

static struct omap_hwmod omap54xx_uart1_hwmod = {
	.name		= "uart1",
	.class		= &omap54xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_uart1_irqs,
	.sdma_reqs	= omap54xx_uart1_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_UART1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_UART1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_uart1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_uart1_slaves),
};

/* uart2 */
static struct omap_hwmod omap54xx_uart2_hwmod;
static struct omap_hwmod_irq_info omap54xx_uart2_irqs[] = {
	{ .irq = 73 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_uart2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 50 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 51 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_uart2_addrs[] = {
	{
		.pa_start	= 0x4806c000,
		.pa_end		= 0x4806c0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart2 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__uart2 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_uart2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_uart2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_uart2_slaves[] = {
	&omap54xx_l4_per__uart2,
};

static struct omap_hwmod omap54xx_uart2_hwmod = {
	.name		= "uart2",
	.class		= &omap54xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_uart2_irqs,
	.sdma_reqs	= omap54xx_uart2_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_UART2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_UART2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_uart2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_uart2_slaves),
};

/* uart3 */
static struct omap_hwmod omap54xx_uart3_hwmod;
static struct omap_hwmod_irq_info omap54xx_uart3_irqs[] = {
	{ .irq = 74 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_uart3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 52 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 53 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_uart3_addrs[] = {
	{
		.pa_start	= 0x48020000,
		.pa_end		= 0x480200ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart3 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__uart3 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_uart3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_uart3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_uart3_slaves[] = {
	&omap54xx_l4_per__uart3,
};

static struct omap_hwmod omap54xx_uart3_hwmod = {
	.name		= "uart3",
	.class		= &omap54xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap54xx_uart3_irqs,
	.sdma_reqs	= omap54xx_uart3_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_UART3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_UART3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_uart3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_uart3_slaves),
};

/* uart4 */
static struct omap_hwmod omap54xx_uart4_hwmod;
static struct omap_hwmod_irq_info omap54xx_uart4_irqs[] = {
	{ .irq = 70 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_uart4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 54 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 55 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_uart4_addrs[] = {
	{
		.pa_start	= 0x4806e000,
		.pa_end		= 0x4806e0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart4 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__uart4 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_uart4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_uart4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart4 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_uart4_slaves[] = {
	&omap54xx_l4_per__uart4,
};

static struct omap_hwmod omap54xx_uart4_hwmod = {
	.name		= "uart4",
	.class		= &omap54xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_uart4_irqs,
	.sdma_reqs	= omap54xx_uart4_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_UART4_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_UART4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_uart4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_uart4_slaves),
};

/* uart5 */
static struct omap_hwmod omap54xx_uart5_hwmod;
static struct omap_hwmod_irq_info omap54xx_uart5_irqs[] = {
	{ .irq = 105 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_uart5_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 62 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 63 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_uart5_addrs[] = {
	{
		.pa_start	= 0x48066000,
		.pa_end		= 0x480660ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart5 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__uart5 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_uart5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_uart5_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart5 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_uart5_slaves[] = {
	&omap54xx_l4_per__uart5,
};

static struct omap_hwmod omap54xx_uart5_hwmod = {
	.name		= "uart5",
	.class		= &omap54xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_uart5_irqs,
	.sdma_reqs	= omap54xx_uart5_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_UART5_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_UART5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_uart5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_uart5_slaves),
};

/* uart6 */
static struct omap_hwmod omap54xx_uart6_hwmod;
static struct omap_hwmod_irq_info omap54xx_uart6_irqs[] = {
	{ .irq = 106 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap54xx_uart6_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 78 + OMAP54XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 79 + OMAP54XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap54xx_uart6_addrs[] = {
	{
		.pa_start	= 0x48068000,
		.pa_end		= 0x480680ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart6 */
static struct omap_hwmod_ocp_if omap54xx_l4_per__uart6 = {
	.master		= &omap54xx_l4_per_hwmod,
	.slave		= &omap54xx_uart6_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_uart6_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart6 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_uart6_slaves[] = {
	&omap54xx_l4_per__uart6,
};

static struct omap_hwmod omap54xx_uart6_hwmod = {
	.name		= "uart6",
	.class		= &omap54xx_uart_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.mpu_irqs	= omap54xx_uart6_irqs,
	.sdma_reqs	= omap54xx_uart6_sdma_reqs,
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_UART6_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_UART6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_uart6_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_uart6_slaves),
};

/*
 * 'usb_otg_ss' class
 * 2.0 super speed (usb_otg_ss) controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_usb_otg_ss_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_usb_otg_ss_hwmod_class = {
	.name	= "usb_otg_ss",
	.sysc	= &omap54xx_usb_otg_ss_sysc,
};

/* usb_otg_ss */
static struct omap_hwmod_irq_info omap54xx_usb_otg_ss_irqs[] = {
	{ .name = "dwc_usb3", .irq = 92 + OMAP44XX_IRQ_GIC_START },
	{ .name = "wrapper", .irq = 93 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 },
};

/* usb_otg_ss master ports */
static struct omap_hwmod_ocp_if *omap54xx_usb_otg_ss_masters[] = {
	&omap54xx_usb_otg_ss__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_usb_otg_ss_addrs[] = {
	{
		.name           = "dwc_usb3",
		.pa_start       = 0x4a030000,
		.pa_end         = 0x4a03ffff,
		.flags          = ADDR_TYPE_RT
	}, {
		.name           = "wrapper",
		.pa_start       = 0x4a020000,
		.pa_end         = 0x4a02ffff,
		.flags          = ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> usb_otg_ss */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__usb_otg_ss = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_usb_otg_ss_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_usb_otg_ss_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_otg_ss slave ports */
static struct omap_hwmod_ocp_if *omap54xx_usb_otg_ss_slaves[] = {
	&omap54xx_l4_cfg__usb_otg_ss,
};

static struct omap_hwmod_opt_clk usb_otg_ss_opt_clks[] = {
	{ .role = "refclk960m", .clk = "usb_otg_ss_refclk960m_ck" },
};

static struct omap_hwmod omap54xx_usb_otg_ss_hwmod = {
	.name		= "usb_otg_ss",
	.class		= &omap54xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_usb_otg_ss_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_USB_OTG_SS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_USB_OTG_SS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_ss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_ss_opt_clks),
	.slaves		= omap54xx_usb_otg_ss_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_usb_otg_ss_slaves),
	.masters	= omap54xx_usb_otg_ss_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_usb_otg_ss_masters),
};

/*
 * 'usb_host_hs' class
 * high-speed multi-port usb host controller
 */
static struct omap_hwmod_class_sysconfig omap54xx_usb_host_hs_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_usb_host_hs_hwmod_class = {
	.name	= "usb_host_hs",
	.sysc	= &omap54xx_usb_host_hs_sysc,
};

/* usb_host_hs */
static struct omap_hwmod_irq_info omap54xx_usb_host_hs_irqs[] = {
	{ .name = "ohci-irq", .irq = 76 + OMAP44XX_IRQ_GIC_START },
	{ .name = "ehci-irq", .irq = 77 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* usb_host_hs master ports */
static struct omap_hwmod_ocp_if *omap54xx_usb_host_hs_masters[] = {
	&omap54xx_usb_host_hs__l3_main_2,
};

static struct omap_hwmod_addr_space omap54xx_usb_host_hs_addrs[] = {
	{
		.name		= "uhh",
		.pa_start	= 0x4a064000,
		.pa_end		= 0x4a0647ff,
		.flags		= ADDR_TYPE_RT
	},
	{
		.name		= "ohci",
		.pa_start	= 0x4a064800,
		.pa_end		= 0x4a064bff,
	},
	{
		.name		= "ehci",
		.pa_start	= 0x4a064c00,
		.pa_end		= 0x4a064fff,
	},
	{ }
};

/* l4_cfg -> usb_host_hs */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__usb_host_hs = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_usb_host_hs_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_usb_host_hs_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_host_hs slave ports */
static struct omap_hwmod_ocp_if *omap54xx_usb_host_hs_slaves[] = {
	&omap54xx_l4_cfg__usb_host_hs,
};

static struct omap_hwmod_opt_clk usb_host_hs_opt_clks[] = {
	{ .role = "hsic60m_p2_clk", .clk = "usb_host_hs_hsic60m_p2_clk" },
	{ .role = "hsic60m_p3_clk", .clk = "usb_host_hs_hsic60m_p3_clk" },
	{ .role = "utmi_p1_clk", .clk = "usb_host_hs_utmi_p1_clk" },
	{ .role = "utmi_p2_clk", .clk = "usb_host_hs_utmi_p2_clk" },
	{ .role = "utmi_p3_clk", .clk = "usb_host_hs_utmi_p3_clk" },
	{ .role = "hsic480m_p1_clk", .clk = "usb_host_hs_hsic480m_p1_clk" },
	{ .role = "hsic60m_p1_clk", .clk = "usb_host_hs_hsic60m_p1_clk" },
	{ .role = "hsic480m_p3_clk", .clk = "usb_host_hs_hsic480m_p3_clk" },
	{ .role = "hsic480m_p2_clk", .clk = "usb_host_hs_hsic480m_p2_clk" },
};

static struct omap_hwmod omap54xx_usb_host_hs_hwmod = {
	.name		= "usb_host_hs",
	.class		= &omap54xx_usb_host_hs_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_usb_host_hs_irqs,
	.main_clk	= "l3init_60m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_USB_HOST_HS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= usb_host_hs_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_host_hs_opt_clks),
	.slaves		= omap54xx_usb_host_hs_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_usb_host_hs_slaves),
	.masters	= omap54xx_usb_host_hs_masters,
	.masters_cnt	= ARRAY_SIZE(omap54xx_usb_host_hs_masters),

/*
 * TODO:
 * Need check with omap5; But these erratas were exist in omap3 and omap4
 */
/*
 *	Errata: USBHOST Configured In Smart-Idle Can Lead To a Deadlock
 *	id: i660
 *
 *	Description:
 *	In the following configuration :
 *	- USBHOST module is set to smart-idle mode
 *	- PRCM asserts idle_req to the USBHOST module ( This typically happens
 *	  when the system is going to a low power mode : all ports have been
 *	  suspended, the master part of the USBHOST module has entered the
 *	  standby state, and SW has cut the functional clocks.)
 *	- an USBHOST interrupt occurs before the module is able to answer
 *	  idle_ack, typically a remote wakeup IRQ.
 *	Then the USB HOST module will enter a deadlock situation where it is no
 *	more accessible nor functional.
 *
 *	Workaround:
 *	Don't use smart idle; use only force idle, hence HWMOD_SWSUP_SIDLE
 */

/*	Errata: USB host EHCI may stall when entering smart-standby mode
 *	Id: i571
 *
 *	Description:
 *	When the USBHOST module is set to smart-standby mode, and when it is
 *	ready to enter the standby state (i.e. all ports are suspended and
 *	all attached devices are in suspend mode), then it can wrongly assert
 *	the Mstandby signal too early while there are still some residual OCP
 *	transactions ongoing. If this condition occurs, the internal state
 *	machine may go to an undefined state and the USB link may be stuck
 *	upon the next resume.
 *
 *	Workaround:
 *	Don't use smart standby; use only force standby,
 *	hence HWMOD_SWSUP_MSTANDBY
 */

/*	During system boot; If the hwmod framework resets the module
 *	the module will have smart idle settings; which can lead to deadlock
 *	(above Errata Id:i660); so, dont reset the module during boot;
 *	Use HWMOD_INIT_NO_RESET.
 */
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY |
			  HWMOD_INIT_NO_RESET,
};

/*
 * 'usb_tll_hs' class
 * usb_tll_hs module is the adapter on the usb_host_hs ports
 */

static struct omap_hwmod_class_sysconfig omap54xx_usb_tll_hs_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_usb_tll_hs_hwmod_class = {
	.name	= "usb_tll_hs",
	.sysc	= &omap54xx_usb_tll_hs_sysc,
};

/* usb_tll_hs */
static struct omap_hwmod_irq_info omap54xx_usb_tll_hs_irqs[] = {
	{ .irq = 78 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_usb_tll_hs_addrs[] = {
	{
		.name		= "tll",
		.pa_start	= 0x4a062000,
		.pa_end		= 0x4a062fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> usb_tll_hs */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__usb_tll_hs = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_usb_tll_hs_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap54xx_usb_tll_hs_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_tll_hs slave ports */
static struct omap_hwmod_ocp_if *omap54xx_usb_tll_hs_slaves[] = {
	&omap54xx_l4_cfg__usb_tll_hs,
};

static struct omap_hwmod_opt_clk usb_tll_hs_opt_clks[] = {
	{ .role = "usb_ch2_clk", .clk = "usb_tll_hs_usb_ch2_clk" },
	{ .role = "usb_ch0_clk", .clk = "usb_tll_hs_usb_ch0_clk" },
	{ .role = "usb_ch1_clk", .clk = "usb_tll_hs_usb_ch1_clk" },
};

static struct omap_hwmod omap54xx_usb_tll_hs_hwmod = {
	.name		= "usb_tll_hs",
	.class		= &omap54xx_usb_tll_hs_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.mpu_irqs	= omap54xx_usb_tll_hs_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_USB_TLL_HS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_USB_TLL_HS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_tll_hs_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_tll_hs_opt_clks),
	.slaves		= omap54xx_usb_tll_hs_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_usb_tll_hs_slaves),
};

/*
 * 'wd_timer' class
 * 32-bit watchdog upward counter that generates a pulse on the reset pin on
 * overflow condition
 */

static struct omap_hwmod_class_sysconfig omap54xx_wd_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_wd_timer_hwmod_class = {
	.name		= "wd_timer",
	.sysc		= &omap54xx_wd_timer_sysc,
	.pre_shutdown	= &omap2_wd_timer_disable,
};

/* wd_timer2 */
static struct omap_hwmod omap54xx_wd_timer2_hwmod;
static struct omap_hwmod_irq_info omap54xx_wd_timer2_irqs[] = {
	{ .irq = 80 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_wd_timer2_addrs[] = {
	{
		.pa_start	= 0x4ae14000,
		.pa_end		= 0x4ae1407f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> wd_timer2 */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__wd_timer2 = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_wd_timer2_hwmod,
	.clk		= "wkupaon_clk_mux_ck",
	.addr		= omap54xx_wd_timer2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* wd_timer2 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_wd_timer2_slaves[] = {
	&omap54xx_l4_wkup__wd_timer2,
};

static struct omap_hwmod omap54xx_wd_timer2_hwmod = {
	.name		= "wd_timer2",
	.class		= &omap54xx_wd_timer_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.mpu_irqs	= omap54xx_wd_timer2_irqs,
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_WD_TIMER2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_WD_TIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_wd_timer2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_wd_timer2_slaves),
};

/* wd_timer3 */
static struct omap_hwmod omap54xx_wd_timer3_hwmod;
static struct omap_hwmod_irq_info omap54xx_wd_timer3_irqs[] = {
	{ .irq = 36 + OMAP54XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap54xx_wd_timer3_addrs[] = {
	{
		.pa_start	= 0x40130000,
		.pa_end		= 0x4013007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> wd_timer3 */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__wd_timer3 = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_wd_timer3_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_wd_timer3_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap54xx_wd_timer3_dma_addrs[] = {
	{
		.pa_start	= 0x49030000,
		.pa_end		= 0x4903007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> wd_timer3 (dma) */
static struct omap_hwmod_ocp_if omap54xx_l4_abe__wd_timer3_dma = {
	.master		= &omap54xx_l4_abe_hwmod,
	.slave		= &omap54xx_wd_timer3_hwmod,
	.clk		= "abe_iclk",
	.addr		= omap54xx_wd_timer3_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* wd_timer3 slave ports */
static struct omap_hwmod_ocp_if *omap54xx_wd_timer3_slaves[] = {
	&omap54xx_l4_abe__wd_timer3,
	&omap54xx_l4_abe__wd_timer3_dma,
};

static struct omap_hwmod omap54xx_wd_timer3_hwmod = {
	.name		= "wd_timer3",
	.class		= &omap54xx_wd_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap54xx_wd_timer3_irqs,
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_WD_TIMER3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_ABE_WD_TIMER3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap54xx_wd_timer3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap54xx_wd_timer3_slaves),
};

static __initdata struct omap_hwmod *omap54xx_hwmods[] = {

	/* dmm class */
	&omap54xx_dmm_hwmod,

	/* emif_ocp_fw class */
	&omap54xx_emif_ocp_fw_hwmod,

	/* l3 class */
	&omap54xx_l3_instr_hwmod,
	&omap54xx_l3_main_1_hwmod,
	&omap54xx_l3_main_2_hwmod,
	&omap54xx_l3_main_3_hwmod,

	/* l4 class */
#ifndef CONFIG_OMAP_PM_STANDALONE
	&omap54xx_l4_abe_hwmod,
#endif
	&omap54xx_l4_cfg_hwmod,
	&omap54xx_l4_per_hwmod,
	&omap54xx_l4_wkup_hwmod,

	/* mpu_bus class */
	&omap54xx_mpu_private_hwmod,

	/* aess class */
#ifndef CONFIG_OMAP_PM_STANDALONE
	&omap54xx_aess_hwmod,
#endif

	/* counter class */
/*	&omap54xx_counter_32k_hwmod, */

	/* dma class */
	&omap54xx_dma_system_hwmod,

#ifndef CONFIG_OMAP_PM_STANDALONE
	/* dmic class */
	&omap54xx_dmic_hwmod,
#endif

	/* dsp class */
#ifndef CONFIG_OMAP_PM_STANDALONE
	&omap54xx_dsp_hwmod,
	&omap54xx_dsp_c0_hwmod,
#endif

	/* dss class */
	&omap54xx_dss_hwmod,
	&omap54xx_dss_dispc_hwmod,
	&omap54xx_dss_dsi1_a_hwmod,
	&omap54xx_dss_dsi1_b_hwmod,
	&omap54xx_dss_dsi1_c_hwmod,
	&omap54xx_dss_hdmi_hwmod,
	&omap54xx_dss_rfbi_hwmod,

	/* emif class */
	&omap54xx_emif1_hwmod,
	&omap54xx_emif2_hwmod,

	/* fdif class */
	&omap54xx_fdif_hwmod,

	/* gpio class */
	&omap54xx_gpio1_hwmod,
	&omap54xx_gpio2_hwmod,
	&omap54xx_gpio3_hwmod,
	&omap54xx_gpio4_hwmod,
	&omap54xx_gpio5_hwmod,
	&omap54xx_gpio6_hwmod,
	&omap54xx_gpio7_hwmod,
	&omap54xx_gpio8_hwmod,

	/* gpmc class */
	&omap54xx_gpmc_hwmod,

#ifndef CONFIG_OMAP_PM_STANDALONE
	/* gpu class */
	&omap54xx_gpu_hwmod,

	/* hsi class */
	&omap54xx_hsi_hwmod,
#endif

	/* i2c class */
	&omap54xx_i2c1_hwmod,
	&omap54xx_i2c2_hwmod,
	&omap54xx_i2c3_hwmod,
	&omap54xx_i2c4_hwmod,
	&omap54xx_i2c5_hwmod,

#ifndef CONFIG_OMAP_PM_STANDALONE
	/* ipu class */
	&omap54xx_ipu_hwmod,
	&omap54xx_ipu_c0_hwmod,
	&omap54xx_ipu_c1_hwmod,
#endif

	/* iss class */
/*	&omap54xx_iss_hwmod, */

#ifndef CONFIG_OMAP_PM_STANDALONE
	/* iva class */
	&omap54xx_iva_hwmod,
	&omap54xx_iva_seq0_hwmod,
	&omap54xx_iva_seq1_hwmod,
#endif
	/* kbd class */
	&omap54xx_kbd_hwmod,

	/* mailbox class */
	&omap54xx_mailbox_hwmod,

	/* mcbsp class */
	&omap54xx_mcbsp1_hwmod,
	&omap54xx_mcbsp2_hwmod,
	&omap54xx_mcbsp3_hwmod,

#ifndef CONFIG_OMAP_PM_STANDALONE
	/* mcpdm class */
	&omap54xx_mcpdm_hwmod,
#endif
	/* mcspi class */
	&omap54xx_mcspi1_hwmod,
	&omap54xx_mcspi2_hwmod,
	&omap54xx_mcspi3_hwmod,
	&omap54xx_mcspi4_hwmod,

	/* mmc class */
	&omap54xx_mmc1_hwmod,
	&omap54xx_mmc2_hwmod,
	&omap54xx_mmc3_hwmod,
	&omap54xx_mmc4_hwmod,
	&omap54xx_mmc5_hwmod,

	/* mpu class */
	&omap54xx_mpu_hwmod,

#if (!defined(CONFIG_MACH_OMAP_5430ZEBU) && !defined(CONFIG_OMAP5_VIRTIO))
	/* ocp2scp class */
	&omap54xx_ocp2scp3_hwmod,
#endif

#ifndef CONFIG_OMAP_PM_STANDALONE
	/* sata class */
	&omap54xx_sata_hwmod,
#endif

	&omap54xx_sl2if_hwmod,

	/* smartreflex class */
	&omap54xx_smartreflex_core_hwmod,
	&omap54xx_smartreflex_mm_hwmod,
	&omap54xx_smartreflex_mpu_hwmod,

	/* spinlock class */
	&omap54xx_spinlock_hwmod,

	/* timer class */
	&omap54xx_timer1_hwmod,
	&omap54xx_timer2_hwmod,
	&omap54xx_timer3_hwmod,
	&omap54xx_timer4_hwmod,
	&omap54xx_timer5_hwmod,
	&omap54xx_timer6_hwmod,
	&omap54xx_timer7_hwmod,
	&omap54xx_timer8_hwmod,
	&omap54xx_timer9_hwmod,
	&omap54xx_timer10_hwmod,
	&omap54xx_timer11_hwmod,

	/* scm hwmod */
	&omap54xx_ctrl_module_core_hwmod,

	/* uart class */
	&omap54xx_uart1_hwmod,
	&omap54xx_uart2_hwmod,
	&omap54xx_uart3_hwmod,
	&omap54xx_uart4_hwmod,
	&omap54xx_uart5_hwmod,
	&omap54xx_uart6_hwmod,

	/* usb_otg_ss class */
	&omap54xx_usb_otg_ss_hwmod,

	/* usb host class */
	&omap54xx_usb_host_hs_hwmod,
	&omap54xx_usb_tll_hs_hwmod,

	/* wd_timer class */
	&omap54xx_wd_timer2_hwmod,
	&omap54xx_wd_timer3_hwmod,

	NULL,
};

int __init omap54xx_hwmod_init(void)
{
	return omap_hwmod_register(omap54xx_hwmods);
}
