/*
 * OMAP54xx Clock data
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * XXX Some of the ES1 clocks have been removed/changed; once support
 * is added for discriminating clocks by ES level, these should be added back
 * in.
 */

#include <linux/kernel.h>
#include <linux/list.h>
#include <linux/clk.h>
#include <plat/clkdev_omap.h>
#include <plat/cpu.h>

#include <asm/io.h>

#include "clock.h"
#include "clock44xx.h"
#include "clock54xx.h"
#include "cm1_54xx.h"
#include "cm2_54xx.h"
#include "cm-regbits-54xx.h"
#include "prm54xx.h"
#include "prm-regbits-54xx.h"
#include "control.h"
#include "scrm54xx.h"
#include "iomap.h"

/* OMAP4 modulemode control */
#define OMAP54XX_MODULEMODE_HWCTRL			0
#define OMAP54XX_MODULEMODE_SWCTRL			1

static int omap5_virt_l3_set_rate(struct clk *clk, unsigned long rate);
static long omap5_virt_l3_round_rate(struct clk *clk, unsigned long rate);
static unsigned long omap5_virt_l3_recalc(struct clk *clk);

/* Root clocks */

static struct clk pad_clks_ck = {
	.name		= "pad_clks_ck",
	.rate		= 12000000,
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_CLKSEL_ABE,
	.enable_bit	= OMAP54XX_PAD_CLKS_GATE_SHIFT,
};

static struct clk pad_slimbus_core_clks_ck = {
	.name		= "pad_slimbus_core_clks_ck",
	.rate		= 12000000,
	.ops		= &clkops_null,
};

static struct clk secure_32k_clk_src_ck = {
	.name		= "secure_32k_clk_src_ck",
	.rate		= 32768,
	.ops		= &clkops_null,
};

static struct clk slimbus_clk = {
	.name		= "slimbus_clk",
	.rate		= 12000000,
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_CLKSEL_ABE,
	.enable_bit	= OMAP54XX_SLIMBUS1_CLK_GATE_SHIFT,
};

static struct clk sys_32k_ck = {
	.name		= "sys_32k_ck",
	.rate		= 32768,
	.ops		= &clkops_null,
};

static struct clk virt_12000000_ck = {
	.name		= "virt_12000000_ck",
	.ops		= &clkops_null,
	.rate		= 12000000,
};

static struct clk virt_13000000_ck = {
	.name		= "virt_13000000_ck",
	.ops		= &clkops_null,
	.rate		= 13000000,
};

static struct clk virt_16800000_ck = {
	.name		= "virt_16800000_ck",
	.ops		= &clkops_null,
	.rate		= 16800000,
};

static struct clk virt_19200000_ck = {
	.name		= "virt_19200000_ck",
	.ops		= &clkops_null,
	.rate		= 19200000,
};

static struct clk virt_26000000_ck = {
	.name		= "virt_26000000_ck",
	.ops		= &clkops_null,
	.rate		= 26000000,
};

static struct clk virt_27000000_ck = {
	.name		= "virt_27000000_ck",
	.ops		= &clkops_null,
	.rate		= 27000000,
};

static struct clk virt_38400000_ck = {
	.name		= "virt_38400000_ck",
	.ops		= &clkops_null,
	.rate		= 38400000,
};

static const struct clksel_rate div_1_0_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_1_rates[] = {
	{ .div = 1, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_2_rates[] = {
	{ .div = 1, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_3_rates[] = {
	{ .div = 1, .val = 3, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_4_rates[] = {
	{ .div = 1, .val = 4, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_5_rates[] = {
	{ .div = 1, .val = 5, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_6_rates[] = {
	{ .div = 1, .val = 6, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div_1_7_rates[] = {
	{ .div = 1, .val = 7, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel sys_clkin_sel[] = {
	{ .parent = &virt_12000000_ck, .rates = div_1_1_rates },
	{ .parent = &virt_13000000_ck, .rates = div_1_2_rates },
	{ .parent = &virt_16800000_ck, .rates = div_1_3_rates },
	{ .parent = &virt_19200000_ck, .rates = div_1_4_rates },
	{ .parent = &virt_26000000_ck, .rates = div_1_5_rates },
	{ .parent = &virt_27000000_ck, .rates = div_1_6_rates },
	{ .parent = &virt_38400000_ck, .rates = div_1_7_rates },
	{ .parent = NULL },
};

static struct clk sys_clkin_ck = {
	.name		= "sys_clkin_ck",
	.rate		= 38400000,
	.clksel		= sys_clkin_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_SYS,
	.clksel_mask	= OMAP54XX_SYS_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk xclk60mhsp1_ck = {
	.name		= "xclk60mhsp1_ck",
	.rate		= 60000000,
	.ops		= &clkops_null,
};

static struct clk xclk60mhsp2_ck = {
	.name		= "xclk60mhsp2_ck",
	.rate		= 60000000,
	.ops		= &clkops_null,
};

/* Module clocks and DPLL outputs */

static const struct clksel abe_dpll_bypass_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &sys_32k_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk abe_dpll_bypass_clk_mux_ck = {
	.name		= "abe_dpll_bypass_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_WKUPAON,
	.clksel_mask	= OMAP54XX_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk abe_dpll_refclk_mux_ck = {
	.name		= "abe_dpll_refclk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_ABE_PLL_REF,
	.clksel_mask	= OMAP54XX_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

/* DPLL_ABE */
static struct dpll_data dpll_abe_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_ABE,
	.clk_bypass	= &abe_dpll_bypass_clk_mux_ck,
	.clk_ref	= &abe_dpll_refclk_mux_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_ABE,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_ABE,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_ABE,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 2047,
	.max_divider	= 128,
	.min_divider	= 1,
};


static struct clk dpll_abe_ck = {
	.name		= "dpll_abe_ck",
	.parent		= &abe_dpll_refclk_mux_ck,
	.dpll_data	= &dpll_abe_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap4_dpll_regm4xen_recalc,
	.round_rate	= &omap4_dpll_regm4xen_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static struct clk dpll_abe_x2_ck = {
	.name		= "dpll_abe_x2_ck",
	.parent		= &dpll_abe_ck,
	.flags		= CLOCK_CLKOUTX2,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel_rate div31_1to31_rates[] = {
	{ .div = 1, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 2, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 3, .val = 3, .flags = RATE_IN_54XX },
	{ .div = 4, .val = 4, .flags = RATE_IN_54XX },
	{ .div = 5, .val = 5, .flags = RATE_IN_54XX },
	{ .div = 6, .val = 6, .flags = RATE_IN_54XX },
	{ .div = 7, .val = 7, .flags = RATE_IN_54XX },
	{ .div = 8, .val = 8, .flags = RATE_IN_54XX },
	{ .div = 9, .val = 9, .flags = RATE_IN_54XX },
	{ .div = 10, .val = 10, .flags = RATE_IN_54XX },
	{ .div = 11, .val = 11, .flags = RATE_IN_54XX },
	{ .div = 12, .val = 12, .flags = RATE_IN_54XX },
	{ .div = 13, .val = 13, .flags = RATE_IN_54XX },
	{ .div = 14, .val = 14, .flags = RATE_IN_54XX },
	{ .div = 15, .val = 15, .flags = RATE_IN_54XX },
	{ .div = 16, .val = 16, .flags = RATE_IN_54XX },
	{ .div = 17, .val = 17, .flags = RATE_IN_54XX },
	{ .div = 18, .val = 18, .flags = RATE_IN_54XX },
	{ .div = 19, .val = 19, .flags = RATE_IN_54XX },
	{ .div = 20, .val = 20, .flags = RATE_IN_54XX },
	{ .div = 21, .val = 21, .flags = RATE_IN_54XX },
	{ .div = 22, .val = 22, .flags = RATE_IN_54XX },
	{ .div = 23, .val = 23, .flags = RATE_IN_54XX },
	{ .div = 24, .val = 24, .flags = RATE_IN_54XX },
	{ .div = 25, .val = 25, .flags = RATE_IN_54XX },
	{ .div = 26, .val = 26, .flags = RATE_IN_54XX },
	{ .div = 27, .val = 27, .flags = RATE_IN_54XX },
	{ .div = 28, .val = 28, .flags = RATE_IN_54XX },
	{ .div = 29, .val = 29, .flags = RATE_IN_54XX },
	{ .div = 30, .val = 30, .flags = RATE_IN_54XX },
	{ .div = 31, .val = 31, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel_rate div63_1to63_rates[] = {
	{ .div = 1, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 2, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 3, .val = 3, .flags = RATE_IN_54XX },
	{ .div = 4, .val = 4, .flags = RATE_IN_54XX },
	{ .div = 5, .val = 5, .flags = RATE_IN_54XX },
	{ .div = 6, .val = 6, .flags = RATE_IN_54XX },
	{ .div = 7, .val = 7, .flags = RATE_IN_54XX },
	{ .div = 8, .val = 8, .flags = RATE_IN_54XX },
	{ .div = 9, .val = 9, .flags = RATE_IN_54XX },
	{ .div = 10, .val = 10, .flags = RATE_IN_54XX },
	{ .div = 11, .val = 11, .flags = RATE_IN_54XX },
	{ .div = 12, .val = 12, .flags = RATE_IN_54XX },
	{ .div = 13, .val = 13, .flags = RATE_IN_54XX },
	{ .div = 14, .val = 14, .flags = RATE_IN_54XX },
	{ .div = 15, .val = 15, .flags = RATE_IN_54XX },
	{ .div = 16, .val = 16, .flags = RATE_IN_54XX },
	{ .div = 17, .val = 17, .flags = RATE_IN_54XX },
	{ .div = 18, .val = 18, .flags = RATE_IN_54XX },
	{ .div = 19, .val = 19, .flags = RATE_IN_54XX },
	{ .div = 20, .val = 20, .flags = RATE_IN_54XX },
	{ .div = 21, .val = 21, .flags = RATE_IN_54XX },
	{ .div = 22, .val = 22, .flags = RATE_IN_54XX },
	{ .div = 23, .val = 23, .flags = RATE_IN_54XX },
	{ .div = 24, .val = 24, .flags = RATE_IN_54XX },
	{ .div = 25, .val = 25, .flags = RATE_IN_54XX },
	{ .div = 26, .val = 26, .flags = RATE_IN_54XX },
	{ .div = 27, .val = 27, .flags = RATE_IN_54XX },
	{ .div = 28, .val = 28, .flags = RATE_IN_54XX },
	{ .div = 29, .val = 29, .flags = RATE_IN_54XX },
	{ .div = 30, .val = 30, .flags = RATE_IN_54XX },
	{ .div = 31, .val = 31, .flags = RATE_IN_54XX },
	{ .div = 32, .val = 32, .flags = RATE_IN_54XX },
	{ .div = 33, .val = 33, .flags = RATE_IN_54XX },
	{ .div = 34, .val = 34, .flags = RATE_IN_54XX },
	{ .div = 35, .val = 35, .flags = RATE_IN_54XX },
	{ .div = 36, .val = 36, .flags = RATE_IN_54XX },
	{ .div = 37, .val = 37, .flags = RATE_IN_54XX },
	{ .div = 38, .val = 38, .flags = RATE_IN_54XX },
	{ .div = 39, .val = 39, .flags = RATE_IN_54XX },
	{ .div = 40, .val = 40, .flags = RATE_IN_54XX },
	{ .div = 41, .val = 41, .flags = RATE_IN_54XX },
	{ .div = 42, .val = 42, .flags = RATE_IN_54XX },
	{ .div = 43, .val = 43, .flags = RATE_IN_54XX },
	{ .div = 44, .val = 44, .flags = RATE_IN_54XX },
	{ .div = 45, .val = 45, .flags = RATE_IN_54XX },
	{ .div = 46, .val = 46, .flags = RATE_IN_54XX },
	{ .div = 47, .val = 47, .flags = RATE_IN_54XX },
	{ .div = 48, .val = 48, .flags = RATE_IN_54XX },
	{ .div = 49, .val = 49, .flags = RATE_IN_54XX },
	{ .div = 50, .val = 50, .flags = RATE_IN_54XX },
	{ .div = 51, .val = 51, .flags = RATE_IN_54XX },
	{ .div = 52, .val = 52, .flags = RATE_IN_54XX },
	{ .div = 53, .val = 53, .flags = RATE_IN_54XX },
	{ .div = 54, .val = 54, .flags = RATE_IN_54XX },
	{ .div = 55, .val = 55, .flags = RATE_IN_54XX },
	{ .div = 56, .val = 56, .flags = RATE_IN_54XX },
	{ .div = 57, .val = 57, .flags = RATE_IN_54XX },
	{ .div = 58, .val = 58, .flags = RATE_IN_54XX },
	{ .div = 59, .val = 59, .flags = RATE_IN_54XX },
	{ .div = 60, .val = 60, .flags = RATE_IN_54XX },
	{ .div = 61, .val = 61, .flags = RATE_IN_54XX },
	{ .div = 62, .val = 62, .flags = RATE_IN_54XX },
	{ .div = 63, .val = 63, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel dpll_abe_m2x2_div[] = {
	{ .parent = &dpll_abe_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_abe_m2x2_ck = {
	.name		= "dpll_abe_m2x2_ck",
	.parent		= &dpll_abe_x2_ck,
	.clksel		= dpll_abe_m2x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_ABE,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk abe_24m_fclk = {
	.name		= "abe_24m_fclk",
	.parent		= &dpll_abe_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 8,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel_rate div3_1to4_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 2, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 4, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel abe_clk_div[] = {
	{ .parent = &dpll_abe_m2x2_ck, .rates = div3_1to4_rates },
	{ .parent = NULL },
};

static struct clk abe_clk = {
	.name		= "abe_clk",
	.parent		= &dpll_abe_m2x2_ck,
	.clksel		= abe_clk_div,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_ABE,
	.clksel_mask	= OMAP54XX_CLKSEL_OPP_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel_rate div2_1to2_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 2, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel aess_fclk_div[] = {
	{ .parent = &abe_clk, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk aess_fclk = {
	.name		= "aess_fclk",
	.parent		= &abe_clk,
	.clksel		= aess_fclk_div,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_AESS_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_AESS_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk abe_iclk = {
	.name		= "abe_iclk",
	.parent		= &abe_clk,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk cm_core_custefuse_clk_div_ck = {
	.name		= "cm_core_custefuse_clk_div_ck",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk dpll_abe_m3x2_ck = {
	.name		= "dpll_abe_m3x2_ck",
	.parent		= &dpll_abe_x2_ck,
	.clksel		= dpll_abe_m2x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M3_DPLL_ABE,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_CORE */
static struct dpll_data dpll_core_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_CORE,
	.clk_bypass	= &dpll_abe_m3x2_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_CORE,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_CORE,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_CORE,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 2047,
	.max_divider	= 128,
	.min_divider	= 1,
};


static struct clk dpll_core_ck = {
	.name		= "dpll_core_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_core_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_core_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
};

static struct clk dpll_core_x2_ck = {
	.name		= "dpll_core_x2_ck",
	.parent		= &dpll_core_ck,
	.flags		= CLOCK_CLKOUTX2,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_core_h12x2_div[] = {
	{ .parent = &dpll_core_x2_ck, .rates = div63_1to63_rates },
	{ .parent = NULL },
};

static struct clk dpll_core_h12x2_ck = {
	.name		= "dpll_core_h12x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H12_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel_rate div4_1to8_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 2, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 4, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 8, .val = 3, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel div_iva_hs_clk_div[] = {
	{ .parent = &dpll_core_h12x2_ck, .rates = div4_1to8_rates },
	{ .parent = NULL },
};

static struct clk div_iva_hs_clk = {
	.name		= "div_iva_hs_clk",
	.parent		= &dpll_core_h12x2_ck,
	.clksel		= div_iva_hs_clk_div,
	.clksel_reg	= OMAP54XX_CM_BYPCLK_DPLL_IVA,
	.clksel_mask	= OMAP54XX_CLKSEL_0_1_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk div_mpu_hs_clk = {
	.name		= "div_mpu_hs_clk",
	.parent		= &dpll_core_h12x2_ck,
	.clksel		= div_iva_hs_clk_div,
	.clksel_reg	= OMAP54XX_CM_BYPCLK_DPLL_MPU,
	.clksel_mask	= OMAP54XX_CLKSEL_0_1_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk syc_clk_div_ck = {
	.name		= "syc_clk_div_ck",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_null,
	.recalc		= &followparent_recalc,
};

static struct clk per_hs_clk_div_ck = {
	.name		= "per_hs_clk_div_ck",
	.parent		= &dpll_abe_m3x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

/* DPLL_PER */
static struct dpll_data dpll_per_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_PER,
	.clk_bypass	= &per_hs_clk_div_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_PER,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_PER,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_PER,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 2047,
	.max_divider	= 128,
	.min_divider	= 1,
};


static struct clk dpll_per_ck = {
	.name		= "dpll_per_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_per_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static const struct clksel dpll_per_m2_div[] = {
	{ .parent = &dpll_per_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_per_m2_ck = {
	.name		= "dpll_per_m2_ck",
	.parent		= &dpll_per_ck,
	.clksel		= dpll_per_m2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_PER,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk func_24m_clk = {
	.name		= "func_24m_clk",
	.parent		= &dpll_per_m2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 4,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel dmic_sync_mux_sel[] = {
	{ .parent = &abe_24m_fclk, .rates = div_1_0_rates },
	{ .parent = &syc_clk_div_ck, .rates = div_1_1_rates },
	{ .parent = &func_24m_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk dmic_sync_mux_ck = {
	.name		= "dmic_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_DMIC_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel dmic_gfclk_sel[] = {
	{ .parent = &dmic_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk dmic_gfclk = {
	.name		= "dmic_gfclk",
	.parent		= &dmic_sync_mux_ck,
	.clksel		= dmic_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_DMIC_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_24_25_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel dpll_abe_m2_div[] = {
	{ .parent = &dpll_abe_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_abe_m2_ck = {
	.name		= "dpll_abe_m2_ck",
	.parent		= &dpll_abe_ck,
	.clksel		= dpll_abe_m2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_ABE,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_h11x2_ck = {
	.name		= "dpll_core_h11x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H11_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_h13x2_ck = {
	.name		= "dpll_core_h13x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H13_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_h14x2_ck = {
	.name		= "dpll_core_h14x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H14_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_h22x2_ck = {
	.name		= "dpll_core_h22x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H22_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_h23x2_ck = {
	.name		= "dpll_core_h23x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H23_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel dpll_core_m2_div[] = {
	{ .parent = &dpll_core_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_core_m2_ck = {
	.name		= "dpll_core_m2_ck",
	.parent		= &dpll_core_ck,
	.clksel		= dpll_core_m2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap4_core_dpll_m2_set_rate,
};

static const struct clksel dpll_core_m3x2_div[] = {
	{ .parent = &dpll_core_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_core_m3x2_ck = {
	.name		= "dpll_core_m3x2_ck",
	.parent		= &dpll_core_x2_ck,
	.clksel		= dpll_core_m3x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M3_DPLL_CORE,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_IVA */
static struct dpll_data dpll_iva_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_IVA,
	.clk_bypass	= &div_iva_hs_clk,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_IVA,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_IVA,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_IVA,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 2047,
	.max_divider	= 128,
	.min_divider	= 1,
};


static struct clk dpll_iva_ck = {
	.name		= "dpll_iva_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_iva_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static struct clk dpll_iva_x2_ck = {
	.name		= "dpll_iva_x2_ck",
	.parent		= &dpll_iva_ck,
	.flags		= CLOCK_CLKOUTX2,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_iva_h11x2_div[] = {
	{ .parent = &dpll_iva_x2_ck, .rates = div63_1to63_rates },
	{ .parent = NULL },
};

static struct clk dpll_iva_h11x2_ck = {
	.name		= "dpll_iva_h11x2_ck",
	.parent		= &dpll_iva_x2_ck,
	.clksel		= dpll_iva_h11x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H11_DPLL_IVA,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel dpll_iva_h12x2_div[] = {
	{ .parent = &dpll_iva_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_iva_h12x2_ck = {
	.name		= "dpll_iva_h12x2_ck",
	.parent		= &dpll_iva_x2_ck,
	.clksel		= dpll_iva_h12x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H12_DPLL_IVA,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_MPU */
static struct dpll_data dpll_mpu_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_MPU,
	.clk_bypass	= &div_mpu_hs_clk,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_MPU,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_MPU,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_MPU,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 2047,
	.max_divider	= 128,
	.min_divider	= 1,
};


static struct clk dpll_mpu_ck = {
	.name		= "dpll_mpu_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_mpu_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static const struct clksel dpll_mpu_m2_div[] = {
	{ .parent = &dpll_mpu_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_mpu_m2_ck = {
	.name		= "dpll_mpu_m2_ck",
	.parent		= &dpll_mpu_ck,
	.clksel		= dpll_mpu_m2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_MPU,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

#ifdef CONFIG_MACH_OMAP_5430ZEBU
static struct clk virt_dpll_mpu_ck = {
	.name		= "virt_dpll_mpu_ck",
	.parent		= &dpll_mpu_ck,
	.clksel		= dpll_mpu_m2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_MPU,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};
#else
static struct clk virt_dpll_mpu_ck = {
	.name		= "virt_dpll_mpu_ck",
	.parent		= &dpll_mpu_ck,
	.ops		= &clkops_null,
	.recalc		= &omap5_mpu_dpll_recalc,
	.round_rate	= &omap5_mpu_dpll_round_rate,
	.set_rate	= &omap5_mpu_dpll_set_rate,
};
#endif

static struct clk dpll_per_x2_ck = {
	.name		= "dpll_per_x2_ck",
	.parent		= &dpll_per_ck,
	.flags		= CLOCK_CLKOUTX2,
	.ops		= &clkops_null,
	.recalc		= &omap3_clkoutx2_recalc,
};

static const struct clksel dpll_per_h11x2_div[] = {
	{ .parent = &dpll_per_x2_ck, .rates = div63_1to63_rates },
	{ .parent = NULL },
};

static struct clk dpll_per_h11x2_ck = {
	.name		= "dpll_per_h11x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_h11x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H11_DPLL_PER,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_h12x2_ck = {
	.name		= "dpll_per_h12x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_h11x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H12_DPLL_PER,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_h14x2_ck = {
	.name		= "dpll_per_h14x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_h11x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_H14_DPLL_PER,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel dpll_per_m2x2_div[] = {
	{ .parent = &dpll_per_x2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_per_m2x2_ck = {
	.name		= "dpll_per_m2x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_PER,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_per_m3x2_ck = {
	.name		= "dpll_per_m3x2_ck",
	.parent		= &dpll_per_x2_ck,
	.clksel		= dpll_per_m2x2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M3_DPLL_PER,
	.clksel_mask	= OMAP54XX_DIVHS_0_4_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_UNIPRO1 */
static struct dpll_data dpll_unipro1_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_UNIPRO1,
	.clk_bypass	= &sys_clkin_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_UNIPRO1,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_UNIPRO1,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_UNIPRO1,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 4095,
	.max_divider	= 256,
	.min_divider	= 1,
};


static struct clk dpll_unipro1_ck = {
	.name		= "dpll_unipro1_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_unipro1_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static const struct clksel dpll_unipro1_clkdcoldo_div[] = {
	{ .parent = &dpll_unipro1_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_unipro1_clkdcoldo_ck = {
	.name		= "dpll_unipro1_clkdcoldo_ck",
	.parent		= &dpll_unipro1_ck,
	.clksel		= dpll_unipro1_clkdcoldo_div,
	.clksel_reg	= OMAP54XX_CM_CLKDCOLDO_DPLL_USB,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_unipro1_m2_ck = {
	.name		= "dpll_unipro1_m2_ck",
	.parent		= &dpll_unipro1_ck,
	.clksel		= dpll_unipro1_clkdcoldo_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_UNIPRO1,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

/* DPLL_UNIPRO2 */
static struct dpll_data dpll_unipro2_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_UNIPRO2,
	.clk_bypass	= &sys_clkin_ck,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_UNIPRO2,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_UNIPRO2,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_UNIPRO2,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.max_multiplier	= 4095,
	.max_divider	= 256,
	.min_divider	= 1,
};


static struct clk dpll_unipro2_ck = {
	.name		= "dpll_unipro2_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_unipro2_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
};

static const struct clksel dpll_unipro2_clkdcoldo_div[] = {
	{ .parent = &dpll_unipro2_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_unipro2_clkdcoldo_ck = {
	.name		= "dpll_unipro2_clkdcoldo_ck",
	.parent		= &dpll_unipro2_ck,
	.clksel		= dpll_unipro2_clkdcoldo_div,
	.clksel_reg	= OMAP54XX_CM_CLKDCOLDO_DPLL_USB,
	.clksel_mask	= OMAP54XX_DIVHS_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_unipro2_m2_ck = {
	.name		= "dpll_unipro2_m2_ck",
	.parent		= &dpll_unipro2_ck,
	.clksel		= dpll_unipro2_clkdcoldo_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_UNIPRO2,
	.clksel_mask	= OMAP54XX_DIVHS_0_6_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk usb_hs_clk_div_ck = {
	.name		= "usb_hs_clk_div_ck",
	.parent		= &dpll_abe_m3x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 3,
	.recalc		= &omap_fixed_divisor_recalc,
};

/* DPLL_USB */
static struct dpll_data dpll_usb_dd = {
	.mult_div1_reg	= OMAP54XX_CM_CLKSEL_DPLL_USB,
	.clk_bypass	= &usb_hs_clk_div_ck,
	.flags		= DPLL_J_TYPE,
	.clk_ref	= &sys_clkin_ck,
	.control_reg	= OMAP54XX_CM_CLKMODE_DPLL_USB,
	.modes		= (1 << DPLL_LOW_POWER_BYPASS) | (1 << DPLL_LOCKED),
	.autoidle_reg	= OMAP54XX_CM_AUTOIDLE_DPLL_USB,
	.idlest_reg	= OMAP54XX_CM_IDLEST_DPLL_USB,
	.mult_mask	= OMAP54XX_DPLL_MULT_MASK,
	.div1_mask	= OMAP54XX_DPLL_DIV_MASK,
	.enable_mask	= OMAP54XX_DPLL_EN_MASK,
	.autoidle_mask	= OMAP54XX_AUTO_DPLL_MODE_MASK,
	.idlest_mask	= OMAP54XX_ST_DPLL_CLK_MASK,
	.sddiv_mask	= OMAP54XX_DPLL_SD_DIV_MASK,
	.max_multiplier	= 4095,
	.max_divider	= 256,
	.min_divider	= 1,
};


static struct clk dpll_usb_ck = {
	.name		= "dpll_usb_ck",
	.parent		= &sys_clkin_ck,
	.dpll_data	= &dpll_usb_dd,
	.init		= &omap2_init_dpll_parent,
	.ops		= &clkops_omap3_noncore_dpll_ops,
	.recalc		= &omap3_dpll_recalc,
	.round_rate	= &omap2_dpll_round_rate,
	.set_rate	= &omap3_noncore_dpll_set_rate,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk dpll_usb_clkdcoldo_ck = {
	.name		= "dpll_usb_clkdcoldo_ck",
	.parent		= &dpll_usb_ck,
	.clksel_reg	= OMAP54XX_CM_CLKDCOLDO_DPLL_USB,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &followparent_recalc,
};

static const struct clksel dpll_usb_m2_div[] = {
	{ .parent = &dpll_usb_ck, .rates = div31_1to31_rates },
	{ .parent = NULL },
};

static struct clk dpll_usb_m2_ck = {
	.name		= "dpll_usb_m2_ck",
	.parent		= &dpll_usb_ck,
	.clksel		= dpll_usb_m2_div,
	.clksel_reg	= OMAP54XX_CM_DIV_M2_DPLL_USB,
	.clksel_mask	= OMAP54XX_DIVHS_0_6_MASK,
	.ops		= &clkops_omap4_dpllmx_ops,
	.recalc		= &omap3_clkout_mn_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dsp_fck = {
	.name		= "dsp_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_DSP_DSP_CLKCTRL,
	.clkdm_name	= "dsp_clkdm",
	.parent		= &dpll_iva_h11x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk func_12m_fclk = {
	.name		= "func_12m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 16,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk func_24m_fclk = {
	.name		= "func_24m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 8,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk func_48m_fclk = {
	.name		= "func_48m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 4,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk func_96m_fclk = {
	.name		= "func_96m_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 2,
	.recalc		= &omap_fixed_divisor_recalc,
};

static const struct clksel gpu_core_clk_mux_sel[] = {
	{ .parent = &dpll_core_h14x2_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_per_h14x2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk gpu_core_clk_mux_ck = {
	.name		= "gpu_core_clk_mux_ck",
	.parent		= &dpll_core_h14x2_ck,
	.clksel		= gpu_core_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_GPU_GPU_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_GPU_CORE_GCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk gpu_hyd_clk_mux_ck = {
	.name		= "gpu_hyd_clk_mux_ck",
	.parent		= &dpll_core_h14x2_ck,
	.clksel		= gpu_core_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_GPU_GPU_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_GPU_HYD_GCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel l3_div_div[] = {
	{ .parent = &dpll_core_h12x2_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk l3_div_ck = {
	.name		= "l3_div_ck",
	.parent		= &dpll_core_h12x2_ck,
	.clksel		= l3_div_div,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_CORE,
	.clksel_mask	= OMAP54XX_CLKSEL_L3_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel_rate div2_0to8_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 8, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel l3init_60m_fclk_div[] = {
	{ .parent = &dpll_usb_m2_ck, .rates = div2_0to8_rates },
	{ .parent = NULL },
};

static struct clk virt_l3_ck = {
	.name		= "virt_l3_ck",
	.parent		= &dpll_core_h12x2_ck,
	.ops		= &clkops_null,
	.set_rate	= &omap5_virt_l3_set_rate,
	.recalc		= &omap5_virt_l3_recalc,
	.round_rate	= &omap5_virt_l3_round_rate,
};

static struct clk l3init_60m_fclk = {
	.name		= "l3init_60m_fclk",
	.parent		= &dpll_usb_m2_ck,
	.clksel		= l3init_60m_fclk_div,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_USB_60MHZ,
	.clksel_mask	= OMAP54XX_CLKSEL_0_0_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel l4_div_div[] = {
	{ .parent = &l3_div_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk l4_div_ck = {
	.name		= "l4_div_ck",
	.parent		= &l3_div_ck,
	.clksel		= l4_div_div,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_CORE,
	.clksel_mask	= OMAP54XX_CLKSEL_L4_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk lp_clk_div_ck = {
	.name		= "lp_clk_div_ck",
	.parent		= &dpll_abe_m2x2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 16,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk mcasp_sync_mux_ck = {
	.name		= "mcasp_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCASP_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel mcasp_gfclk_sel[] = {
	{ .parent = &mcasp_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk mcasp_gfclk = {
	.name		= "mcasp_gfclk",
	.parent		= &mcasp_sync_mux_ck,
	.clksel		= mcasp_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCASP_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_24_25_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk mcbsp1_sync_mux_ck = {
	.name		= "mcbsp1_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCBSP1_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

#define OMAP54XX_MODULEMODE_SWCTRL 1

static struct clk dss_fck = {
	.name		= "dss_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP54XX_MODULEMODE_SWCTRL,
	.clkdm_name	= "dss_clkdm",
	.parent		= &l3_div_ck,
	.recalc		= &followparent_recalc,
};

/* Leaf clocks controlled by modules */

static const struct clksel mcbsp1_gfclk_sel[] = {
	{ .parent = &mcbsp1_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk mcbsp1_gfclk = {
	.name		= "mcbsp1_gfclk",
	.parent		= &mcbsp1_sync_mux_ck,
	.clksel		= mcbsp1_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCBSP1_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_24_25_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk mcbsp2_sync_mux_ck = {
	.name		= "mcbsp2_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCBSP2_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel mcbsp2_gfclk_sel[] = {
	{ .parent = &mcbsp2_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk mcbsp2_gfclk = {
	.name		= "mcbsp2_gfclk",
	.parent		= &mcbsp2_sync_mux_ck,
	.clksel		= mcbsp2_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCBSP2_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_24_25_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk mcbsp3_sync_mux_ck = {
	.name		= "mcbsp3_sync_mux_ck",
	.parent		= &abe_24m_fclk,
	.clksel		= dmic_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCBSP3_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_INTERNAL_SOURCE_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel mcbsp3_gfclk_sel[] = {
	{ .parent = &mcbsp3_sync_mux_ck, .rates = div_1_0_rates },
	{ .parent = &pad_clks_ck, .rates = div_1_1_rates },
	{ .parent = &slimbus_clk, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static struct clk mcbsp3_gfclk = {
	.name		= "mcbsp3_gfclk",
	.parent		= &mcbsp3_sync_mux_ck,
	.clksel		= mcbsp3_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_MCBSP3_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_24_25_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel mmc1_fclk_mux_sel[] = {
	{ .parent = &dpll_per_h11x2_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_per_m2x2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk mmc1_fclk_mux = {
	.name		= "mmc1_fclk_mux",
	.parent		= &dpll_per_h11x2_ck,
	.clksel		= mmc1_fclk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L3INIT_MMC1_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_SOURCE_24_24_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel mmc1_fclk_div[] = {
	{ .parent = &mmc1_fclk_mux, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk mmc1_fclk = {
	.name		= "mmc1_fclk",
	.parent		= &mmc1_fclk_mux,
	.clksel		= mmc1_fclk_div,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L3INIT_MMC1_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk mmc2_fclk_mux = {
	.name		= "mmc2_fclk_mux",
	.parent		= &dpll_per_h11x2_ck,
	.clksel		= mmc1_fclk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L3INIT_MMC2_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_SOURCE_24_24_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel mmc2_fclk_div[] = {
	{ .parent = &mmc2_fclk_mux, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk mmc2_fclk = {
	.name		= "mmc2_fclk",
	.parent		= &mmc2_fclk_mux,
	.clksel		= mmc2_fclk_div,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L3INIT_MMC2_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_DIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk per_abe_24m_fclk = {
	.name		= "per_abe_24m_fclk",
	.parent		= &dpll_abe_m2_ck,
	.ops		= &clkops_null,
	.fixed_div	= 4,
	.recalc		= &omap_fixed_divisor_recalc,
};

static struct clk timer10_clk_mux_ck = {
	.name		= "timer10_clk_mux_ck",
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L4PER_TIMER10_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk timer11_clk_mux_ck = {
	.name		= "timer11_clk_mux_ck",
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L4PER_TIMER11_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk timer1_clk_mux_ck = {
	.name           = "timer1_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_WKUPAON_TIMER1_CLKCTRL,
	.clksel_mask    = OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name     = "wkupaon_clkdm",
};

static struct clk timer2_clk_mux_ck = {
	.name		= "timer2_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L4PER_TIMER2_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk timer3_clk_mux_ck = {
	.name		= "timer3_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L4PER_TIMER3_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk timer4_clk_mux_ck = {
	.name		= "timer4_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L4PER_TIMER4_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "l4per_clkdm",
};

static const struct clksel timer5_sync_mux_sel[] = {
	{ .parent = &syc_clk_div_ck, .rates = div_1_0_rates },
	{ .parent = &sys_32k_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk timer5_sync_mux_ck = {
	.name		= "timer5_sync_mux_ck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_TIMER5_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "abe_clkdm",
};

static struct clk timer6_sync_mux_ck = {
	.name		= "timer6_sync_mux_ck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_TIMER6_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "abe_clkdm",
};

static struct clk timer7_sync_mux_ck = {
	.name		= "timer7_sync_mux_ck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_TIMER7_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "abe_clkdm",
};

static struct clk timer8_sync_mux_ck = {
	.name		= "timer8_sync_mux_ck",
	.parent		= &syc_clk_div_ck,
	.clksel		= timer5_sync_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_ABE_TIMER8_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "abe_clkdm",
};

static struct clk timer9_clk_mux_ck = {
	.name		= "timer9_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= abe_dpll_bypass_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L4PER_TIMER9_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.clkdm_name	= "l4per_clkdm",
};

static const struct clksel wkupaon_clk_mux_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &lp_clk_div_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk wkupaon_clk_mux_ck = {
	.name		= "wkupaon_clk_mux_ck",
	.parent		= &sys_clkin_ck,
	.clksel		= wkupaon_clk_mux_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_CLKSEL_WKUPAON,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel_rate div3_8to32_rates[] = {
	{ .div = 8, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 16, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 32, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static const struct clksel ts_clk_div_ck_div[] = {
	{ .parent = &wkupaon_clk_mux_ck, .rates = div3_8to32_rates },
	{ .parent = NULL },
};

static struct clk ts_clk_div_ck = {
	.name		= "ts_clk_div_ck",
	.parent		= &wkupaon_clk_mux_ck,
	.enable_reg	= OMAP54XX_CM_COREAON_BANDGAP_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_TS_FCLK_SHIFT,
	.clksel		= ts_clk_div_ck_div,
	.clksel_reg	= OMAP54XX_CM_COREAON_BANDGAP_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_24_25_MASK,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
	.clkdm_name	= "cam_clkdm",
};

static const struct clksel utmi_p1_gfclk_sel[] = {
	{ .parent = &l3init_60m_fclk, .rates = div_1_0_rates },
	{ .parent = &xclk60mhsp1_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk utmi_p1_gfclk = {
	.name		= "utmi_p1_gfclk",
	.parent		= &l3init_60m_fclk,
	.clksel		= utmi_p1_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_UTMI_P1_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

static const struct clksel utmi_p2_gfclk_sel[] = {
	{ .parent = &l3init_60m_fclk, .rates = div_1_0_rates },
	{ .parent = &xclk60mhsp2_ck, .rates = div_1_1_rates },
	{ .parent = NULL },
};

static struct clk utmi_p2_gfclk = {
	.name		= "utmi_p2_gfclk",
	.parent		= &l3init_60m_fclk,
	.clksel		= utmi_p2_gfclk_sel,
	.init		= &omap2_init_clksel_parent,
	.clksel_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_UTMI_P2_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
};

/* Leaf clocks controlled by modules */

static struct clk dss_32khz_clk = {
	.name		= "dss_32khz_clk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_32KHZ_CLK_SHIFT,
	.clkdm_name	= "dss_clkdm",
};

static struct clk dss_48mhz_clk = {
	.name		= "dss_48mhz_clk",
	.parent		= &func_48m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_48MHZ_CLK_SHIFT,
	.clkdm_name	= "dss_clkdm",
};

static struct clk dss_dss_clk = {
	.name		= "dss_dss_clk",
	.parent		= &dpll_per_h12x2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DSSCLK_SHIFT,
	.clkdm_name	= "dss_clkdm",
};

static struct clk dss_sys_clk = {
	.name		= "dss_sys_clk",
	.parent		= &syc_clk_div_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_DSS_DSS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_SYS_CLK_SHIFT,
	.clkdm_name	= "dss_clkdm",
};

static struct clk gpio1_dbclk = {
	.name		= "gpio1_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_WKUPAON_GPIO1_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "wkupaon_clkdm",
};

static struct clk gpio2_dbclk = {
	.name		= "gpio2_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO2_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk gpio3_dbclk = {
	.name		= "gpio3_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO3_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk gpio4_dbclk = {
	.name		= "gpio4_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO4_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk gpio5_dbclk = {
	.name		= "gpio5_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO5_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk gpio6_dbclk = {
	.name		= "gpio6_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO6_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk gpio7_dbclk = {
	.name		= "gpio7_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO7_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk gpio8_dbclk = {
	.name		= "gpio8_dbclk",
	.parent		= &sys_32k_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_GPIO8_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_DBCLK_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk iss_ctrlclk = {
	.name		= "iss_ctrlclk",
	.parent		= &func_96m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_CAM_ISS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_CTRLCLK_SHIFT,
	.clkdm_name	= "cam_clkdm",
};

static struct clk lli_txphy_clk = {
	.name		= "lli_txphy_clk",
	.parent		= &dpll_unipro1_clkdcoldo_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_MIPIEXT_LLI_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_TXPHY_CLK_SHIFT,
	.clkdm_name	= "mipiext_clkdm",
};

static struct clk lli_txphy_ls_clk = {
	.name		= "lli_txphy_ls_clk",
	.parent		= &dpll_unipro1_m2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_MIPIEXT_LLI_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_TXPHY_LS_CLK_SHIFT,
	.clkdm_name	= "mipiext_clkdm",
};

static struct clk sata_ref_clk = {
	.name		= "sata_ref_clk",
	.parent		= &sys_clkin_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_SATA_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_REF_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk slimbus1_slimbus_clk = {
	.name		= "slimbus1_slimbus_clk",
	.parent		= &slimbus_clk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_ABE_SLIMBUS1_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_SLIMBUS_CLK_SHIFT,
	.clkdm_name	= "abe_clkdm",
};

static struct clk slimbus2_slimbus_clk = {
	.name		= "slimbus2_slimbus_clk",
	.parent		= &pad_slimbus_core_clks_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L4PER_SLIMBUS2_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_SLIMBUS_CLK_10_10_SHIFT,
	.clkdm_name	= "l4per_clkdm",
};

static struct clk usb_host_hs_hsic480m_p1_clk = {
	.name		= "usb_host_hs_hsic480m_p1_clk",
	.parent		= &dpll_usb_m2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_HSIC480M_P1_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_hsic480m_p2_clk = {
	.name		= "usb_host_hs_hsic480m_p2_clk",
	.parent		= &dpll_usb_m2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_HSIC480M_P2_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_hsic480m_p3_clk = {
	.name		= "usb_host_hs_hsic480m_p3_clk",
	.parent		= &dpll_usb_m2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_HSIC480M_P3_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_hsic60m_p1_clk = {
	.name		= "usb_host_hs_hsic60m_p1_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_HSIC60M_P1_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_hsic60m_p2_clk = {
	.name		= "usb_host_hs_hsic60m_p2_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_HSIC60M_P2_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_hsic60m_p3_clk = {
	.name		= "usb_host_hs_hsic60m_p3_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_HSIC60M_P3_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_utmi_p1_clk = {
	.name		= "usb_host_hs_utmi_p1_clk",
	.parent		= &utmi_p1_gfclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_UTMI_P1_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_utmi_p2_clk = {
	.name		= "usb_host_hs_utmi_p2_clk",
	.parent		= &utmi_p2_gfclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_UTMI_P2_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_utmi_p3_clk = {
	.name		= "usb_host_hs_utmi_p3_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_UTMI_P3_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_otg_ss_refclk960m_ck = {
	.name		= "usb_otg_ss_refclk960m_ck",
	.parent		= &dpll_usb_clkdcoldo_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_OTG_SS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_REFCLK960M_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_tll_hs_usb_ch0_clk = {
	.name		= "usb_tll_hs_usb_ch0_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_TLL_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_USB_CH0_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_tll_hs_usb_ch1_clk = {
	.name		= "usb_tll_hs_usb_ch1_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_TLL_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_USB_CH1_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_tll_hs_usb_ch2_clk = {
	.name		= "usb_tll_hs_usb_ch2_clk",
	.parent		= &l3init_60m_fclk,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_L3INIT_USB_TLL_HS_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_USB_CH2_CLK_SHIFT,
	.clkdm_name	= "l3init_clkdm",
};

static struct clk usb_host_hs_fck = {
	.name		= "usb_host_hs_fck",
	.ops		= &clkops_omap2_dflt,
	.clkdm_name	= "l3init_clkdm",
	.parent		= &l3init_60m_fclk,
	.recalc		= &followparent_recalc,
};

static struct clk usb_tll_hs_ick = {
	.name		= "usb_tll_hs_ick",
	.ops		= &clkops_omap2_dflt,
	.clkdm_name	= "l3init_clkdm",
	.parent		= &l4_div_ck,
	.recalc		= &followparent_recalc,
};

static const struct clksel fdif_fclk_div[] = {
	{ .parent = &dpll_per_h11x2_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk fdif_fclk = {
	.name		= "fdif_fclk",
	.parent		= &dpll_per_h11x2_ck,
	.clksel		= fdif_fclk_div,
	.clksel_reg	= OMAP54XX_CM_CAM_FDIF_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_FCLK_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
	.clkdm_name	= "cam_clkdm",
};

static struct clk ipu_fck = {
	.name		= "ipu_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_IPU_IPU_CLKCTRL,
	.clkdm_name	= "ipu_clkdm",
	.parent		= &dpll_core_h22x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk iva_fck = {
	.name		= "iva_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_IVA_IVA_CLKCTRL,
	.clkdm_name	= "iva_clkdm",
	.parent		= &dpll_iva_h12x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk iss_fck = {
	.name		= "iss_fck",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_CAM_ISS_CLKCTRL,
	.clkdm_name	= "cam_clkdm",
	.parent		= &dpll_core_h23x2_ck,
	.recalc		= &followparent_recalc,
};

static struct clk sl2if_ick = {
	.name		= "sl2if_ick",
	.ops		= &clkops_omap2_dflt,
	.enable_reg	= OMAP54XX_CM_IVA_SL2_CLKCTRL,
	.clkdm_name	= "iva_clkdm",
	.parent		= &dpll_iva_h12x2_ck,
	.recalc		= &followparent_recalc,
};

static const struct clksel hsi_fclk_div[] = {
	{ .parent = &dpll_per_m2x2_ck, .rates = div2_1to2_rates },
	{ .parent = NULL },
};

static struct clk hsi_fclk = {
	.name		= "hsi_fclk",
	.parent		= &dpll_per_m2x2_ck,
	.clksel		= hsi_fclk_div,
	.clksel_reg	= OMAP54XX_CM_L3INIT_HSI_CLKCTRL,
	.clksel_mask	= OMAP54XX_CLKSEL_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk dpll_core_m3x2_opt_ck = {
	.name		= "dpll_core_m3x2_opt_ck",
	.parent		= &dpll_core_m3x2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_WKUPAON_SCRM_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_SCRM_CORE_SHIFT,
	.clkdm_name	= "wkupaon_clkdm",
};

static struct clk dpll_per_m3x2_opt_ck = {
	.name		= "dpll_per_m3x2_opt_ck",
	.parent		= &dpll_per_m3x2_ck,
	.ops		= &clkops_omap2_dflt,
	.recalc		= &followparent_recalc,
	.enable_reg	= OMAP54XX_CM_WKUPAON_SCRM_CLKCTRL,
	.enable_bit	= OMAP54XX_OPTFCLKEN_SCRM_PER_SHIFT,
	.clkdm_name	= "wkupaon_clkdm",
};

/* SCRM aux clk nodes */

static const struct clksel auxclk_src_sel[] = {
	{ .parent = &sys_clkin_ck, .rates = div_1_0_rates },
	{ .parent = &dpll_core_m3x2_opt_ck, .rates = div_1_1_rates },
	{ .parent = &dpll_per_m3x2_opt_ck, .rates = div_1_2_rates },
	{ .parent = NULL },
};

static const struct clksel_rate div16_1to16_rates[] = {
	{ .div = 1, .val = 0, .flags = RATE_IN_54XX },
	{ .div = 2, .val = 1, .flags = RATE_IN_54XX },
	{ .div = 3, .val = 2, .flags = RATE_IN_54XX },
	{ .div = 4, .val = 3, .flags = RATE_IN_54XX },
	{ .div = 5, .val = 4, .flags = RATE_IN_54XX },
	{ .div = 6, .val = 5, .flags = RATE_IN_54XX },
	{ .div = 7, .val = 6, .flags = RATE_IN_54XX },
	{ .div = 8, .val = 7, .flags = RATE_IN_54XX },
	{ .div = 9, .val = 8, .flags = RATE_IN_54XX },
	{ .div = 10, .val = 9, .flags = RATE_IN_54XX },
	{ .div = 11, .val = 10, .flags = RATE_IN_54XX },
	{ .div = 12, .val = 11, .flags = RATE_IN_54XX },
	{ .div = 13, .val = 12, .flags = RATE_IN_54XX },
	{ .div = 14, .val = 13, .flags = RATE_IN_54XX },
	{ .div = 15, .val = 14, .flags = RATE_IN_54XX },
	{ .div = 16, .val = 15, .flags = RATE_IN_54XX },
	{ .div = 0 },
};

static struct clk auxclk0_src_ck = {
	.name		= "auxclk0_src_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_src_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK0,
	.clksel_mask	= OMAP5_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP5_SCRM_AUXCLK0,
	.enable_bit	= OMAP5_ENABLE_SHIFT,
};

static const struct clksel auxclk0_sel[] = {
	{ .parent = &auxclk0_src_ck, .rates = div16_1to16_rates },
	{ .parent = NULL },
};

static struct clk auxclk0_ck = {
	.name		= "auxclk0_ck",
	.parent		= &auxclk0_src_ck,
	.clksel		= auxclk0_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK0,
	.clksel_mask	= OMAP5_CLKDIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk auxclk1_src_ck = {
	.name		= "auxclk1_src_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_src_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK1,
	.clksel_mask	= OMAP5_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP5_SCRM_AUXCLK1,
	.enable_bit	= OMAP5_ENABLE_SHIFT,
};

static const struct clksel auxclk1_sel[] = {
	{ .parent = &auxclk1_src_ck, .rates = div16_1to16_rates },
	{ .parent = NULL },
};

static struct clk auxclk1_ck = {
	.name		= "auxclk1_ck",
	.parent		= &auxclk1_src_ck,
	.clksel		= auxclk1_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK1,
	.clksel_mask	= OMAP5_CLKDIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk auxclk2_src_ck = {
	.name		= "auxclk2_src_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_src_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK2,
	.clksel_mask	= OMAP5_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP5_SCRM_AUXCLK2,
	.enable_bit	= OMAP5_ENABLE_SHIFT,
};

static const struct clksel auxclk2_sel[] = {
	{ .parent = &auxclk2_src_ck, .rates = div16_1to16_rates },
	{ .parent = NULL },
};

static struct clk auxclk2_ck = {
	.name		= "auxclk2_ck",
	.parent		= &auxclk2_src_ck,
	.clksel		= auxclk2_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK2,
	.clksel_mask	= OMAP5_CLKDIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk auxclk3_src_ck = {
	.name		= "auxclk3_src_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_src_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK3,
	.clksel_mask	= OMAP5_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP5_SCRM_AUXCLK3,
	.enable_bit	= OMAP5_ENABLE_SHIFT,
};

static const struct clksel auxclk3_sel[] = {
	{ .parent = &auxclk3_src_ck, .rates = div16_1to16_rates },
	{ .parent = NULL },
};

static struct clk auxclk3_ck = {
	.name		= "auxclk3_ck",
	.parent		= &auxclk3_src_ck,
	.clksel		= auxclk3_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK3,
	.clksel_mask	= OMAP5_CLKDIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk auxclk4_src_ck = {
	.name		= "auxclk4_src_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_src_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK4,
	.clksel_mask	= OMAP5_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP5_SCRM_AUXCLK4,
	.enable_bit	= OMAP5_ENABLE_SHIFT,
};

static const struct clksel auxclk4_sel[] = {
	{ .parent = &auxclk4_src_ck, .rates = div16_1to16_rates },
	{ .parent = NULL },
};

static struct clk auxclk4_ck = {
	.name		= "auxclk4_ck",
	.parent		= &auxclk4_src_ck,
	.clksel		= auxclk4_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK4,
	.clksel_mask	= OMAP5_CLKDIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static struct clk auxclk5_src_ck = {
	.name		= "auxclk5_src_ck",
	.parent		= &sys_clkin_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_omap2_dflt,
	.clksel		= auxclk_src_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK5,
	.clksel_mask	= OMAP5_SRCSELECT_MASK,
	.recalc		= &omap2_clksel_recalc,
	.enable_reg	= OMAP5_SCRM_AUXCLK5,
	.enable_bit	= OMAP5_ENABLE_SHIFT,
};

static const struct clksel auxclk5_sel[] = {
	{ .parent = &auxclk5_src_ck, .rates = div16_1to16_rates },
	{ .parent = NULL },
};

static struct clk auxclk5_ck = {
	.name		= "auxclk5_ck",
	.parent		= &auxclk5_src_ck,
	.clksel		= auxclk5_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLK5,
	.clksel_mask	= OMAP5_CLKDIV_MASK,
	.ops		= &clkops_null,
	.recalc		= &omap2_clksel_recalc,
	.round_rate	= &omap2_clksel_round_rate,
	.set_rate	= &omap2_clksel_set_rate,
};

static const struct clksel auxclkreq_sel[] = {
	{ .parent = &auxclk0_ck, .rates = div_1_0_rates },
	{ .parent = &auxclk1_ck, .rates = div_1_1_rates },
	{ .parent = &auxclk2_ck, .rates = div_1_2_rates },
	{ .parent = &auxclk3_ck, .rates = div_1_3_rates },
	{ .parent = &auxclk4_ck, .rates = div_1_4_rates },
	{ .parent = &auxclk5_ck, .rates = div_1_5_rates },
	{ .parent = NULL },
};

static struct clk auxclkreq0_ck = {
	.name		= "auxclkreq0_ck",
	.parent		= &auxclk0_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel		= auxclkreq_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLKREQ0,
	.clksel_mask	= OMAP5_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq1_ck = {
	.name		= "auxclkreq1_ck",
	.parent		= &auxclk1_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel		= auxclkreq_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLKREQ1,
	.clksel_mask	= OMAP5_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq2_ck = {
	.name		= "auxclkreq2_ck",
	.parent		= &auxclk2_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel		= auxclkreq_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLKREQ2,
	.clksel_mask	= OMAP5_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq3_ck = {
	.name		= "auxclkreq3_ck",
	.parent		= &auxclk3_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel		= auxclkreq_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLKREQ3,
	.clksel_mask	= OMAP5_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq4_ck = {
	.name		= "auxclkreq4_ck",
	.parent		= &auxclk4_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel		= auxclkreq_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLKREQ4,
	.clksel_mask	= OMAP5_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

static struct clk auxclkreq5_ck = {
	.name		= "auxclkreq5_ck",
	.parent		= &auxclk5_ck,
	.init		= &omap2_init_clksel_parent,
	.ops		= &clkops_null,
	.clksel		= auxclkreq_sel,
	.clksel_reg	= OMAP5_SCRM_AUXCLKREQ5,
	.clksel_mask	= OMAP5_MAPPING_MASK,
	.recalc		= &omap2_clksel_recalc,
};

/*
 * clkdev
 */

static struct omap_clk omap54xx_clks[] = {
	CLK(NULL,	"pad_clks",			&pad_clks_ck,	CK_54XX),
	CLK(NULL,	"pad_clks_ck",			&pad_clks_ck,	CK_54XX),
	CLK(NULL,	"pad_slimbus_core_clks",	&pad_slimbus_core_clks_ck,	CK_54XX),
	CLK(NULL,	"secure_32k_clk_src",		&secure_32k_clk_src_ck,	CK_54XX),
	CLK(NULL,	"slimbus_clk",			&slimbus_clk,	CK_54XX),
	CLK(NULL,	"sys_32k_ck",			&sys_32k_ck,	CK_54XX),
	CLK(NULL,	"virt_12000000_ck",		&virt_12000000_ck,	CK_54XX),
	CLK(NULL,	"virt_13000000_ck",		&virt_13000000_ck,	CK_54XX),
	CLK(NULL,	"virt_16800000_ck",		&virt_16800000_ck,	CK_54XX),
	CLK(NULL,	"virt_19200000_ck",		&virt_19200000_ck,	CK_54XX),
	CLK(NULL,	"virt_26000000_ck",		&virt_26000000_ck,	CK_54XX),
	CLK(NULL,	"virt_27000000_ck",		&virt_27000000_ck,	CK_54XX),
	CLK(NULL,	"virt_38400000_ck",		&virt_38400000_ck,	CK_54XX),
	CLK(NULL,	"sys_clkin_ck",			&sys_clkin_ck,	CK_54XX),
	CLK(NULL,	"xclk60mhsp1_ck",		&xclk60mhsp1_ck,	CK_54XX),
	CLK(NULL,	"xclk60mhsp2_ck",		&xclk60mhsp2_ck,	CK_54XX),
	CLK(NULL,	"abe_dpll_bypass_clk_mux_ck",	&abe_dpll_bypass_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"abe_dpll_refclk_mux_ck",	&abe_dpll_refclk_mux_ck,	CK_54XX),
	CLK(NULL,	"dpll_abe_ck",			&dpll_abe_ck,	CK_54XX),
	CLK(NULL,	"dpll_abe_x2_ck",		&dpll_abe_x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_abe_m2x2_ck",		&dpll_abe_m2x2_ck,	CK_54XX),
	CLK(NULL,	"abe_24m_fclk",			&abe_24m_fclk,	CK_54XX),
	CLK(NULL,	"abe_clk",			&abe_clk,	CK_54XX),
	CLK(NULL,	"aess_fclk",			&aess_fclk,	CK_54XX),
	CLK(NULL,	"abe_iclk",			&abe_iclk,	CK_54XX),
	CLK(NULL,	"cm_core_custefuse_clk_div_ck",	&cm_core_custefuse_clk_div_ck,	CK_54XX),
	CLK(NULL,	"dpll_abe_m3x2_ck",		&dpll_abe_m3x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_ck",			&dpll_core_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_h12x2_ck",		&dpll_core_h12x2_ck,	CK_54XX),
	CLK(NULL,	"virt_l3_ck",			&virt_l3_ck,		CK_54XX),
	CLK(NULL,	"div_iva_hs_clk",		&div_iva_hs_clk,	CK_54XX),
	CLK(NULL,	"div_mpu_hs_clk",		&div_mpu_hs_clk,	CK_54XX),
	CLK(NULL,	"syc_clk_div_ck",		&syc_clk_div_ck,	CK_54XX),
	CLK(NULL,	"per_hs_clk_div_ck",		&per_hs_clk_div_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_ck",			&dpll_per_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_m2_ck",		&dpll_per_m2_ck,	CK_54XX),
	CLK(NULL,	"func_24m_clk",			&func_24m_clk,	CK_54XX),
	CLK(NULL,	"dmic_sync_mux_ck",		&dmic_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"dmic_gfclk",			&dmic_gfclk,	CK_54XX),
	CLK(NULL,	"dmic_fck",			&dmic_gfclk,	CK_54XX), /* fclk alias */
	CLK(NULL,	"dpll_abe_m2_ck",		&dpll_abe_m2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_h11x2_ck",		&dpll_core_h11x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_h13x2_ck",		&dpll_core_h13x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_h14x2_ck",		&dpll_core_h14x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_h22x2_ck",		&dpll_core_h22x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_h23x2_ck",		&dpll_core_h23x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_m2_ck",		&dpll_core_m2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_x2_ck",		&dpll_core_x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_m3x2_ck",		&dpll_core_m3x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_core_m3x2_opt_ck",	&dpll_core_m3x2_opt_ck,	CK_54XX),
	CLK(NULL,	"dpll_iva_ck",			&dpll_iva_ck,	CK_54XX),
	CLK(NULL,	"dpll_iva_x2_ck",		&dpll_iva_x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_iva_h11x2_ck",		&dpll_iva_h11x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_iva_h12x2_ck",		&dpll_iva_h12x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_mpu_ck",			&dpll_mpu_ck,	CK_54XX),
	CLK(NULL,	"dpll_mpu_m2_ck",		&dpll_mpu_m2_ck,	CK_54XX),
	CLK(NULL,	"virt_dpll_mpu_ck",		&virt_dpll_mpu_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_h11x2_ck",		&dpll_per_h11x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_h12x2_ck",		&dpll_per_h12x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_h14x2_ck",		&dpll_per_h14x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_x2_ck",		&dpll_per_x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_m2x2_ck",		&dpll_per_m2x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_m3x2_ck",		&dpll_per_m3x2_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_m3x2_opt_ck",		&dpll_per_m3x2_opt_ck,	CK_54XX),
	CLK(NULL,	"dpll_unipro1_ck",		&dpll_unipro1_ck,	CK_54XX),
	CLK(NULL,	"dpll_unipro1_clkdcoldo_ck",	&dpll_unipro1_clkdcoldo_ck,	CK_54XX),
	CLK(NULL,	"dpll_unipro1_m2_ck",		&dpll_unipro1_m2_ck,	CK_54XX),
	CLK(NULL,	"dpll_unipro2_ck",		&dpll_unipro2_ck,	CK_54XX),
	CLK(NULL,	"dpll_unipro2_clkdcoldo_ck",	&dpll_unipro2_clkdcoldo_ck,	CK_54XX),
	CLK(NULL,	"dpll_unipro2_m2_ck",		&dpll_unipro2_m2_ck,	CK_54XX),
	CLK(NULL,	"usb_hs_clk_div_ck",		&usb_hs_clk_div_ck,	CK_54XX),
	CLK(NULL,	"dpll_usb_ck",			&dpll_usb_ck,	CK_54XX),
	CLK(NULL,	"dpll_usb_clkdcoldo_ck",	&dpll_usb_clkdcoldo_ck,	CK_54XX),
	CLK(NULL,	"dpll_usb_m2_ck",		&dpll_usb_m2_ck,	CK_54XX),
	CLK(NULL,	"dsp_fck",			&dsp_fck,	CK_54XX),
	CLK(NULL,	"func_12m_fclk",		&func_12m_fclk,	CK_54XX),
	CLK(NULL,	"func_24m_fclk",		&func_24m_fclk,	CK_54XX),
	CLK(NULL,	"func_48m_fclk",		&func_48m_fclk,	CK_54XX),
	CLK(NULL,	"func_96m_fclk",		&func_96m_fclk,	CK_54XX),
	CLK(NULL,	"gpu_core_clk_mux_ck",		&gpu_core_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpu_hyd_clk_mux_ck",		&gpu_hyd_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"l3_div_ck",			&l3_div_ck,	CK_54XX),
	CLK(NULL,	"l3init_60m_fclk",		&l3init_60m_fclk,	CK_54XX),
	CLK(NULL,	"l4_div_ck",			&l4_div_ck,	CK_54XX),
	CLK(NULL,	"lp_clk_div_ck",		&lp_clk_div_ck,	CK_54XX),
	CLK(NULL,	"mcasp_sync_mux_ck",		&mcasp_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"mcasp_gfclk",			&mcasp_gfclk,	CK_54XX),
	CLK(NULL,	"mcbsp1_sync_mux_ck",		&mcbsp1_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"mcbsp1_gfclk",			&mcbsp1_gfclk,	CK_54XX),
	CLK(NULL,	"mcbsp2_sync_mux_ck",		&mcbsp2_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"mcbsp2_gfclk",			&mcbsp2_gfclk,	CK_54XX),
	CLK(NULL,	"mcbsp3_sync_mux_ck",		&mcbsp3_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"mcbsp3_gfclk",			&mcbsp3_gfclk,	CK_54XX),
	CLK(NULL,	"mmc1_fclk_mux",		&mmc1_fclk_mux,	CK_54XX),
	CLK(NULL,	"mmc1_fclk",			&mmc1_fclk,	CK_54XX),
	CLK(NULL,	"mmc2_fclk_mux",		&mmc2_fclk_mux,	CK_54XX),
	CLK(NULL,	"mmc2_fclk",			&mmc2_fclk,	CK_54XX),
	CLK(NULL,	"per_abe_24m_fclk",		&per_abe_24m_fclk,	CK_54XX),
	CLK(NULL,	"gpt10_clk_mux_ck",		&timer10_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt11_clk_mux_ck",		&timer11_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt1_clk_mux_ck",		&timer1_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt2_clk_mux_ck",		&timer2_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt3_clk_mux_ck",		&timer3_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt4_clk_mux_ck",		&timer4_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt5_sync_mux_ck",		&timer5_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt6_sync_mux_ck",		&timer6_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt7_sync_mux_ck",		&timer7_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt8_sync_mux_ck",		&timer8_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"gpt9_clk_mux_ck",		&timer9_clk_mux_ck,	CK_54XX),
	CLK(NULL,	"wkupaon_clk_mux_ck",		&wkupaon_clk_mux_ck,	CK_54XX),
	CLK("omap4plus_scm.0",	"ts_fck",	&ts_clk_div_ck,	CK_54XX),
	CLK(NULL,	"utmi_p1_gfclk",		&utmi_p1_gfclk,	CK_54XX),
	CLK(NULL,	"utmi_p2_gfclk",		&utmi_p2_gfclk,	CK_54XX),
	CLK(NULL,	"dpll_core_m3x2_opt_ck",	&dpll_core_m3x2_opt_ck,	CK_54XX),
	CLK(NULL,	"dpll_per_m3x2_opt_ck",		&dpll_per_m3x2_opt_ck,	CK_54XX),
	CLK(NULL,	"dss_sys_clk",			&dss_sys_clk,	CK_54XX),
	CLK(NULL,	"dss_32khz_clk",		&dss_32khz_clk,	CK_54XX),
	CLK(NULL,	"dss_48mhz_clk",		&dss_48mhz_clk,	CK_54XX),
	CLK(NULL,	"dss_dss_clk",			&dss_dss_clk,	CK_54XX),
	CLK("omapdss_dss",	"ick",			&dss_fck,	CK_54XX),
	CLK(NULL,	"gpio1_dbclk",			&gpio1_dbclk,	CK_54XX),
	CLK(NULL,	"gpio2_dbclk",			&gpio2_dbclk,	CK_54XX),
	CLK(NULL,	"gpio3_dbclk",			&gpio3_dbclk,	CK_54XX),
	CLK(NULL,	"gpio4_dbclk",			&gpio4_dbclk,	CK_54XX),
	CLK(NULL,	"gpio5_dbclk",			&gpio5_dbclk,	CK_54XX),
	CLK(NULL,	"gpio6_dbclk",			&gpio6_dbclk,	CK_54XX),
	CLK(NULL,	"gpio7_dbclk",			&gpio7_dbclk,	CK_54XX),
	CLK(NULL,	"gpio8_dbclk",			&gpio8_dbclk,	CK_54XX),
	CLK(NULL,	"iss_ctrlclk",			&iss_ctrlclk,	CK_54XX),
	CLK(NULL,	"iss_fck",			&iss_fck,	CK_54XX),
	CLK(NULL,	"ipu_fck",			&ipu_fck,	CK_54XX),
	CLK(NULL,	"iva_fck",			&iva_fck,	CK_54XX),
	CLK(NULL,	"lli_txphy_clk",		&lli_txphy_clk,	CK_54XX),
	CLK(NULL,	"lli_txphy_ls_clk",		&lli_txphy_ls_clk,	CK_54XX),
	CLK(NULL,	"sata_ref_clk",			&sata_ref_clk,	CK_54XX),
	CLK(NULL,	"sl2if_ick",			&sl2if_ick,	CK_54XX),
	CLK(NULL,	"slimbus1_slimbus_clk",		&slimbus1_slimbus_clk,	CK_54XX),
	CLK(NULL,	"slimbus2_slimbus_clk",		&slimbus2_slimbus_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_hsic480m_p1_clk",	&usb_host_hs_hsic480m_p1_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_hsic480m_p2_clk",	&usb_host_hs_hsic480m_p2_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_hsic480m_p3_clk",	&usb_host_hs_hsic480m_p3_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_hsic60m_p1_clk",	&usb_host_hs_hsic60m_p1_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_hsic60m_p2_clk",	&usb_host_hs_hsic60m_p2_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_hsic60m_p3_clk",	&usb_host_hs_hsic60m_p3_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_utmi_p1_clk",	&usb_host_hs_utmi_p1_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_utmi_p2_clk",	&usb_host_hs_utmi_p2_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_utmi_p3_clk",	&usb_host_hs_utmi_p3_clk,	CK_54XX),
	CLK(NULL,	"usb_host_hs_fck",		&usb_host_hs_fck,		CK_54XX),
	CLK(NULL,	"usb_otg_ss_refclk960m_ck",	&usb_otg_ss_refclk960m_ck,	CK_54XX),
	CLK(NULL,	"usb_tll_hs_usb_ch0_clk",	&usb_tll_hs_usb_ch0_clk,	CK_54XX),
	CLK(NULL,	"usb_tll_hs_usb_ch1_clk",	&usb_tll_hs_usb_ch1_clk,	CK_54XX),
	CLK(NULL,	"usb_tll_hs_usb_ch2_clk",	&usb_tll_hs_usb_ch2_clk,	CK_54XX),
	CLK(NULL,	"usb_tll_hs_ick",		&usb_tll_hs_ick,		CK_54XX),
	CLK(NULL,	"aess_fclk",			&aess_fclk,	CK_54XX),
	CLK(NULL,	"dmic_sync_mux_ck",		&dmic_sync_mux_ck,	CK_54XX),
	CLK(NULL,	"dmic_gfclk",			&dmic_gfclk,	CK_54XX),
	CLK(NULL,	"dmic_fck",			&dmic_gfclk,	CK_54XX),
	CLK(NULL,	"fdif_fclk",			&fdif_fclk,	CK_54XX),
	CLK(NULL,	"hsi_fclk",			&hsi_fclk,	CK_54XX),
	CLK(NULL,	"auxclk0_src_ck",		&auxclk0_src_ck,	CK_54XX),
	CLK(NULL,	"auxclk0_ck",			&auxclk0_ck,	CK_54XX),
	CLK(NULL,	"auxclkreq0_ck",		&auxclkreq0_ck,	CK_54XX),
	CLK(NULL,	"auxclk1_src_ck",		&auxclk1_src_ck,	CK_54XX),
	CLK(NULL,	"auxclk1_ck",			&auxclk1_ck,	CK_54XX),
	CLK(NULL,	"auxclkreq1_ck",		&auxclkreq1_ck,	CK_54XX),
	CLK(NULL,	"auxclk2_src_ck",		&auxclk2_src_ck,	CK_54XX),
	CLK(NULL,	"auxclk2_ck",			&auxclk2_ck,	CK_54XX),
	CLK(NULL,	"auxclkreq2_ck",		&auxclkreq2_ck,	CK_54XX),
	CLK(NULL,	"auxclk3_src_ck",		&auxclk3_src_ck,	CK_54XX),
	CLK(NULL,	"auxclk3_ck",			&auxclk3_ck,	CK_54XX),
	CLK(NULL,	"auxclkreq3_ck",		&auxclkreq3_ck,	CK_54XX),
	CLK(NULL,	"auxclk4_src_ck",		&auxclk4_src_ck,	CK_54XX),
	CLK(NULL,	"auxclk4_ck",			&auxclk4_ck,	CK_54XX),
	CLK(NULL,	"auxclkreq4_ck",		&auxclkreq4_ck,	CK_54XX),
	CLK(NULL,	"auxclk5_src_ck",		&auxclk5_src_ck,	CK_54XX),
	CLK(NULL,	"auxclk5_ck",			&auxclk5_ck,	CK_54XX),
	CLK(NULL,	"auxclkreq5_ck",		&auxclkreq5_ck,	CK_54XX),
	CLK(NULL,	"gpmc_ck",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt1_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt2_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt3_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt4_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt5_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt6_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt7_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt8_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt9_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt10_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"gpt11_ick",			&dummy_ck,	CK_54XX),
	CLK("omap_i2c.1",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_i2c.2",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_i2c.3",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_i2c.4",	"ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"mailboxes_ick",		&dummy_ck,	CK_54XX),
	CLK("omap_hsmmc.0",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_hsmmc.1",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_hsmmc.2",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_hsmmc.3",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap_hsmmc.4",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap-mcbsp.1",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap-mcbsp.2",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap-mcbsp.3",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap-mcbsp.4",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap2_mcspi.1",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap2_mcspi.2",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap2_mcspi.3",	"ick",			&dummy_ck,	CK_54XX),
	CLK("omap2_mcspi.4",	"ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"uart1_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"uart2_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"uart3_ick",			&dummy_ck,	CK_54XX),
	CLK(NULL,	"uart4_ick",			&dummy_ck,	CK_54XX),
	CLK("usbhs-omap.0",	"usbhost_ick",		&dummy_ck,	CK_54XX),
	CLK("usbhs-omap.0",	"usbtll_fck",		&dummy_ck,	CK_54XX),
	CLK("omap_wdt",	"ick",				&dummy_ck,	CK_54XX),
	CLK(NULL,       "gpt1_fck",                     &timer1_clk_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt10_fck",                    &timer10_clk_mux_ck,   CK_54XX),
	CLK(NULL,       "gpt11_fck",                    &timer11_clk_mux_ck,   CK_54XX),
	CLK(NULL,       "gpt2_fck",                     &timer2_clk_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt3_fck",                     &timer3_clk_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt4_fck",                     &timer4_clk_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt5_fck",                     &timer5_sync_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt6_fck",                     &timer6_sync_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt7_fck",                     &timer7_sync_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt8_fck",                     &timer8_sync_mux_ck,    CK_54XX),
	CLK(NULL,       "gpt9_fck",                     &timer9_clk_mux_ck,    CK_54XX),
	CLK("omap_timer.1",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.2",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.3",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.4",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.5",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.6",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.7",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.8",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.9",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.10",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.11",	"32k_ck",	&sys_32k_ck,	CK_54XX),
	CLK("omap_timer.1",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.2",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.3",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.4",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.9",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.10",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.11",	"sys_ck",	&sys_clkin_ck,	CK_54XX),
	CLK("omap_timer.5",	"sys_ck",	&syc_clk_div_ck,	CK_54XX),
	CLK("omap_timer.6",	"sys_ck",	&syc_clk_div_ck,	CK_54XX),
	CLK("omap_timer.7",	"sys_ck",	&syc_clk_div_ck,	CK_54XX),
	CLK("omap_timer.8",	"sys_ck",	&syc_clk_div_ck,	CK_54XX),
};

#define L3_OPP50_RATE				133000000
#define DPLL_CORE_M2_OPP50_RATE		266000000
#define DPLL_CORE_M2_OPP100_RATE	532000000
#define DPLL_CORE_M3_OPP50_RATE		266000000
#define DPLL_CORE_M3_OPP100_RATE	425600000
#define DPLL_CORE_H14_OPP50_RATE	212800000
#define DPLL_CORE_H14_OPP100_RATE	425600000
#define DPLL_CORE_H22_OPP50_RATE	212800000
#define DPLL_CORE_H22_OPP100_RATE	425600000
#define DPLL_CORE_H23_OPP50_RATE	152000000
#define DPLL_CORE_H23_OPP100_RATE	304000000
#define DPLL_PER_M3_OPP50_RATE		192000000
#define DPLL_PER_M3_OPP100_RATE		256000000
#define DPLL_PER_H14_OPP50_RATE		192000000
#define DPLL_PER_H14_OPP100_RATE	512000000

static long omap5_virt_l3_round_rate(struct clk *clk, unsigned long rate)
{
	long parent_rate;

	if (!clk || !clk->parent)
		return 0;

	if (clk->parent->round_rate) {
		parent_rate = clk->parent->round_rate(clk->parent, rate * 2);
		if (parent_rate)
			return parent_rate / 2;
	}
	return 0;
}

static unsigned long omap5_virt_l3_recalc(struct clk *clk)
{
	if (!clk || !clk->parent)
		return 0;

	return clk->parent->rate / 2;
}

static int omap5_clksel_set_rate(struct clk *clk, unsigned long rate)
{
	int ret = -EINVAL;

	if (!clk->set_rate || !clk->round_rate)
		return ret;

	rate = clk->round_rate(clk, rate);
	if (rate) {
		ret = clk->set_rate(clk, rate);
		if (!ret)
			propagate_rate(clk);
	}
	return ret;
}

struct virt_l3_ck_deps {
	unsigned long core_m2_rate;
	unsigned long core_m3_rate;
	unsigned long core_h14_rate;
	unsigned long core_h22_rate;
	unsigned long core_h23_rate;
	unsigned long per_m3_rate;
};

#define NO_OF_L3_OPPS 2
#define L3_OPP_50_INDEX 0
#define L3_OPP_100_INDEX 1

static struct virt_l3_ck_deps omap5_virt_l3_clk_deps[NO_OF_L3_OPPS] = {
	{ /* OPP 50 */
		.core_m2_rate = DPLL_CORE_M2_OPP50_RATE,
		.core_m3_rate = DPLL_CORE_M3_OPP50_RATE,
		.core_h14_rate = DPLL_CORE_H14_OPP50_RATE,
		.core_h22_rate = DPLL_CORE_H22_OPP50_RATE,
		.core_h23_rate = DPLL_CORE_H23_OPP50_RATE,
		.per_m3_rate = DPLL_PER_M3_OPP50_RATE,
	},
	{ /* OPP 100 */
		.core_m2_rate = DPLL_CORE_M2_OPP100_RATE,
		.core_m3_rate = DPLL_CORE_M3_OPP100_RATE,
		.core_h14_rate = DPLL_CORE_H14_OPP100_RATE,
		.core_h22_rate = DPLL_CORE_H22_OPP100_RATE,
		.core_h23_rate = DPLL_CORE_H23_OPP100_RATE,
		.per_m3_rate = DPLL_PER_M3_OPP100_RATE,
	},
};

static int omap5_virt_l3_set_rate(struct clk *clk, unsigned long rate)
{
	struct virt_l3_ck_deps *l3_deps;

	if (rate <= L3_OPP50_RATE)
		l3_deps = &omap5_virt_l3_clk_deps[L3_OPP_50_INDEX];
	else
		l3_deps = &omap5_virt_l3_clk_deps[L3_OPP_100_INDEX];

	omap5_clksel_set_rate(&dpll_core_m2_ck, l3_deps->core_m2_rate);
	omap5_clksel_set_rate(&dpll_core_m3x2_ck, l3_deps->core_m3_rate);
	omap5_clksel_set_rate(&dpll_core_h14x2_ck, l3_deps->core_h14_rate);
	omap5_clksel_set_rate(&dpll_core_h22x2_ck, l3_deps->core_h22_rate);
	omap5_clksel_set_rate(&dpll_core_h23x2_ck, l3_deps->core_h23_rate);

	omap5_clksel_set_rate(&dpll_per_m3x2_ck, l3_deps->per_m3_rate);
	omap5_clksel_set_rate(&dpll_core_h12x2_ck, rate * 2);

	clk->rate = rate;
	return 0;
}

int __init omap5xxx_clk_init(void)
{
	struct omap_clk *c;
	u32 cpu_clkflg = 0;

	if (cpu_is_omap54xx()) {
		cpu_mask = RATE_IN_54XX;
		cpu_clkflg = CK_54XX;
	}

	clk_init(&omap2_clk_functions);

	for (c = omap54xx_clks; c < omap54xx_clks + ARRAY_SIZE(omap54xx_clks);
									  c++)
		clk_preinit(c->lk.clk);

	for (c = omap54xx_clks; c < omap54xx_clks + ARRAY_SIZE(omap54xx_clks);
									  c++)
		if (c->cpu & cpu_clkflg) {
			clkdev_add(&c->lk);
			clk_register(c->lk.clk);
			omap2_init_clk_clkdm(c->lk.clk);
		}

	/* Disable autoidle on all clocks; let the PM code enable it later */
	omap_clk_disable_autoidle_all();

	recalculate_root_clocks();

	/*
	 * Only enable those clocks we will need, let the drivers
	 * enable other clocks as necessary
	 */
	clk_enable_init_clocks();

	return 0;
}
