.TH ifhp 8 "_VERSION_"
.SH NAME
lp_server \- export a printer by simulation a HP JetDirect interface
.SH SYNOPSIS
.B lp_server
[-n port] [-w] [-s stty_options] [-d device] [-r remote_list]
.SH DESCRIPTION
.LP
The
.B lp_server
program will bind to the port specified by the -n option,
and wait for a TCP/IP connection.
It will then open the output device (write only if -w is specified),
applying the specified set of stty options if the device
is a serial port.
It then copies the TCP/IP output to the device output,
and copying the device output to the TCP/IP input.
.LP
The intended use for
.B lp_server
is to allow a serial or parallel printer to be made available to PC
workstations as well as to one or more LPRng servers.
.SH "OPTIONS"
The
.B lp_server
printer recognizes the following options provided by the spooler.
.TP
.BR -d " device"
The output device.
.TP
.BR -n " port"
port to use for connections.
Default is 9100.
.TP
.B -w
Open the output device write only.
Default is read/write.
.TP
.BR -t " stty_options"
A list of stty options to be applied to the device
after opening if it is a serial port.
.TP
.BR -r " remote_list"
A list of host names or IP addresses and masks from which
connections are allowed.
For example,
-r 130.191.10.30/24,dickory
would allow connections from the subnet 130.191.10.0 (24 bit netmask)
and the host dickory.
.SH EXAMPLES
.LP
lp_server -d /dev/lp -w
.LP
Opens the parallel port write only.
.LP
lp_server -d /dev/ttya
   -t "38400 -echo -crmod -raw -oddp -evenp ixon pass8 -ixany cbreak"
.LP
Opens the serial port /dev/ttya,
and sets the various serial port options.
.SH STTY_OPTIONS
.PP
Due to the differences between implementations of UNIX,
there are several sets of
stty options supported.
Systems using the
.IR sgtty 
tty manipulation interface may use the following
.IR stty (1)
options:
.nf
.PP
.ta 16n +16n +16n +16n +16n +16n +16n +16n +16n
bs0	bs1	[-]cbreak	cooked	cr0	
cr1	cr2	cr3	[-]decctlq	[-]echo	
[-]even	ff0	ff1	[-]lcase	[-]litout	
nl0	nl1	nl2	nl3	[-]nl	
[-]noflsh	new	[-]nohang	old	[-]odd	
[-]raw	start	stop	tab0	tab1	
tab2	[-]tabs	[-]tandem	tek	ti700	
[-]tilde	tn300	tty33	tty37	vt05	
[-]evenp	[-]oddp	[-]pass8
.fi
.PP
Systems using
.IR termio 
may use the following options:
.nf
.PP
[-]ignbrk	[-]brkint	[-]ignpar	[-]parmrk	[-]inpck
[-]istrip	[-]inlcr	[-]igncr	[-]icrnl	[-]iuclc
[-]ixon	[-]ixany	[-]ixoff	[-]decctlq	[-]tandem
[-]imaxbel	[-]opost	[-]olcuc	[-]onlcr	[-]ocrnl
[-]onocr	[-]onlret	[-]ofill	[-]ofdel	[-]cstopb
[-]cread	[-]parenb	[-]parodd	[-]hupcl	[-]clocal
[-]loblk	[-]parity	[-]evenp	[-]oddp	[-]stopb
[-]hup	[-]crtscts	[-]isig	[-]noisig	[-]icanon
[-]cbreak	[-]xcase	[-]echo	[-]echoe	[-]echok
[-]crterase	[-]lfkc	[-]echonl	[-]noflsh	[-]tostop
[-]echoctl	[-]ctlecho	[-]echoprt	[-]prterase	[-]echoke
[-]crtkill	[-]lcase	[-]nl	[-]litout	[-]pass8
[-]raw	[-]sane	[-]cooked	[-]nopost	fill
nl0	nl1	cr0	cr1	cr2
cr3	tab0	tab1	tab2	tab3
bs0	bs1	vt0	vt1	ff0
ff1	cs5	cs6	cs7	cs8
nul-fill	del-fill	-tabs 
.fi
.PP
And systems using
.IR termios
may use the following options:
.nf
.PP
[-]ignbrk	[-]brkint	[-]ignpar	[-]parmrk	[-]inpck
[-]istrip	[-]inlcr	[-]igncr	[-]icrnl	[-]iuclc
[-]ixon	[-]ixany	[-]ixoff	[-]imaxbel	[-]pass8
[-]opost	[-]olcuc	[-]onlcr	[-]ocrnl	[-]onocr
[-]onlret	[-]ofill	[-]ofdel	[-]tabs	nl0
nl1	cr0	cr1	cr2	cr3
tab0	tab1	tab2	tab3	bs0
bs1	vt0	vt1	ff0	ff1
cs5	cs6	cs7	cs8	[-]cstopb
[-]cread	[-]parenb	[-]parodd	[-]hupcl	[-]clocal
[-]crtscts	[-]evenp	[-]parity	[-]oddp	[-]pass8
[-]isig	[-]icanon	[-]xcase	[-]echo	[-]echoe
[-]echok	[-]echonl	[-]noflsh	[-]tostop	[-]iexten
[-]echoctl	[-]ctlecho	[-]echoprt	[-]prterase	[-]echoke
[-]crtkill	[-]flusho	[-]pendin
.fi
.SH "SEE ALSO"
.PP
LPRng Documentation,  especially discussions about filters.
.SH "AUTHOR"
.PP
Patrick Powell,  Start Tech, San Diego.
.br
Inspired by Ivan Popov <pin@math.chalmers.se>
