// -*- mode: c++; tab-width: 4; indent-tabs-mode: t -*-
/**
 * @file cache/debtags/serializer.cpp
 * @author Enrico Zini (enrico) <enrico@enricozini.org>
 */

/*
 * System tag database
 *
 * Copyright (C) 2003-2006  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#include <ept/tests/test-utils.h>
#include <ept/cache/debtags/serializer.h>

#include <ept/cache/cache.h>
#include <ept/cache/tag.h>
#include <ept/cache/debtags/vocabulary.h>
#include <tagcoll/utils/set.h>
#include <tagcoll/stream/sink.h>

using namespace tagcoll;
using namespace ept;
using namespace ept::configuration::apt;
using namespace wibble::operators;
using namespace cache;

namespace tut {

struct cache_debtags_serializer_shar : common {
	Index& index() { return apt.index(); }
    TagMap& pt() { return apt.tagMap(); }
    Vocabulary& voc() { return apt.vocabulary(); }
	ept::t::cache::debtags::PkgIdx<ept::configuration::Apt> pkgidx;
	cache_debtags_serializer_shar() : pkgidx(apt) {}
};

TESTGRP( cache_debtags_serializer );

/* Test going from package name to id and vice versa */
template<> template<>
void to::test<1>()
{
	Package pkgFromName = index().packageByName("debtags");
	int id = pkgFromName.ondiskId();
	string nameFromID = pkgidx.name(id);

	ensure_equals(nameFromID, string("debtags"));
}

/* Test going from patch with strings to patch with Ept objects and vice versa */
template<> template<>
void to::test<2>()
{
	Package pkg = index().packageByName("debtags");
	Tag tag = voc().tagByName("use::gameplaying");
	PatchList<Package, Tag> change;
	change.addPatch(Patch<Package, Tag>(pkg, wibble::singleton(tag), wibble::Empty<Tag>()));

	// Serialise to string
	PatchList<std::string, std::string> stringChange;
	change.output(ept::t::cache::debtags::patchToString(tagcoll::inserter(stringChange)));
	ensure_equals(stringChange.size(), 1u);
	ensure_equals(stringChange.begin()->first, string("debtags"));
	ensure_equals(stringChange.begin()->second.item, string("debtags"));
	
	// Deserialise back to ints
	PatchList<int, int> intChange;
	stringChange.output(ept::t::cache::debtags::patchStringToInt<ept::configuration::Apt>(apt, voc(), inserter(intChange)));
	ensure_equals(intChange.size(), 1u);
	ensure_equals(intChange.begin()->first, pkg.ondiskId());
	ensure_equals(intChange.begin()->second.item, pkg.ondiskId());

	string nameFromID = pkgidx.name(intChange.begin()->first);
	ensure_equals(nameFromID, string("debtags"));
}

}

#include <ept/cache/debtags/tagmap.tcc>
#include <ept/cache/debtags/vocabulary.tcc>
#include <ept/cache/debtags/serializer.tcc>

// vim:set ts=4 sw=4:

