/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

[DBus (name = "com.Gwibber.Connection")]
private interface ConnectionInterface : Object {
	public signal void ConnectionOffline ();
	public signal void ConnectionOnline ();
	public abstract bool isConnected () throws DBus.Error;
}

namespace Gwibber
{
    public class Connection : Object
    {
        private const string conn_name  = "com.Gwibber.Connection";
        private const string conn_path  = "/com/gwibber/Connection";
        private const string conn_iface = "com.Gwibber.Connection";

        private ConnectionInterface conn_service;
	private Gwibber.Utils utils;

	/** 
            Connection::is_available:
            @arg0: The current state

            Emitted when com.Gwibber.Connection availability state changes
	*/
	public signal void is_available(bool is_up);


        /** 
            Connection::connection_changed:
            @arg0: The current state

            Emitted when network connection state changes
        */
        public signal void connection_changed(bool is_online);

	public Connection ()
	{
	}

        construct
        {
            try
            {
                var dbus_conn = DBus.Bus.get(DBus.BusType.SESSION);

                this.conn_service = (ConnectionInterface) dbus_conn.get_object(this.conn_name,
                                                                this.conn_path,
                                                                this.conn_iface);
		this.utils = new Gwibber.Utils();
		this.utils.setup(this.conn_name);
		this.utils.available.connect(this.conn_available);

                this.conn_service.ConnectionOffline.connect(this.connection_offline);
                this.conn_service.ConnectionOnline.connect(this.connection_online);
            }
            catch(GLib.Error e)
            {
                warning ("Unable to get Gwibber connection service");
            }
        }

        public bool is_connected()
        {
            try {
                return this.conn_service.isConnected();
            } catch (DBus.Error e) {
                warning (e.message);
                return false;
            }
        }

        private void connection_offline()
        {
            this.connection_changed(false);
        }

        private void connection_online()
        {
            this.connection_changed(true);
        }

	public void conn_available(bool is_up)
	{
		this.is_available(is_up);
	}

    }
}
