/**
 * ===========================================
 * LibLayout : a free Java layouting library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/liblayout/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: AlignmentAdjustReadHandler.java,v 1.6 2007/04/02 11:41:08 taqua Exp $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.jfree.layouting.input.style.parser.stylehandler.line;

import org.jfree.layouting.input.style.keys.line.AlignmentAdjust;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

/**
 * Creation-Date: 28.11.2005, 18:12:27
 *
 * @author Thomas Morgner
 */
public class AlignmentAdjustReadHandler extends OneOfConstantsReadHandler
{
  public AlignmentAdjustReadHandler()
  {
    super(true);
    addValue(AlignmentAdjust.AFTER_EDGE);
    addValue(AlignmentAdjust.ALPHABETIC);
    addValue(AlignmentAdjust.CENTRAL);
    addValue(AlignmentAdjust.HANGING);
    addValue(AlignmentAdjust.IDEOGRAPHIC);
    addValue(AlignmentAdjust.MATHEMATICAL);
    addValue(AlignmentAdjust.MIDDLE);
    addValue(AlignmentAdjust.BEFORE_EDGE);
    addValue(AlignmentAdjust.TEXT_AFTER_EDGE);
    addValue(AlignmentAdjust.TEXT_BEFORE_EDGE);
    addValue(AlignmentAdjust.BASELINE);
  }

  protected CSSValue lookupValue(final LexicalUnit value)
  {
    CSSValue constant = super.lookupValue(value);
    if (constant != null)
    {
      return constant;
    }
    else if (value.getLexicalUnitType() == LexicalUnit.SAC_PERCENTAGE)
    {
      return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE,
              value.getFloatValue());
    }

    return CSSValueFactory.createLengthValue(value);

  }
}
