// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "fxjs/xfa/cjx_defaultui.h"

#include "xfa/fxfa/parser/cxfa_defaultui.h"

CJX_DefaultUi::CJX_DefaultUi(CXFA_DefaultUi* node) : CJX_Node(node) {}

CJX_DefaultUi::~CJX_DefaultUi() = default;

void CJX_DefaultUi::use(CFXJSE_Value* pValue,
                        bool bSetting,
                        XFA_Attribute eAttribute) {
  Script_Attribute_String(pValue, bSetting, eAttribute);
}

void CJX_DefaultUi::usehref(CFXJSE_Value* pValue,
                            bool bSetting,
                            XFA_Attribute eAttribute) {
  Script_Attribute_String(pValue, bSetting, eAttribute);
}
