// Copyright 2017 The PDFium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#ifndef CORE_FPDFAPI_FONT_CPDF_FONTGLOBALS_H_
#define CORE_FPDFAPI_FONT_CPDF_FONTGLOBALS_H_

#include <functional>
#include <map>
#include <memory>

#include "core/fpdfapi/cmaps/fpdf_cmaps.h"
#include "core/fpdfapi/font/cpdf_cidfont.h"
#include "core/fxcrt/retain_ptr.h"
#include "core/fxge/cfx_fontmapper.h"
#include "third_party/base/span.h"

class CFX_StockFontArray;
class CPDF_Font;

class CPDF_FontGlobals {
 public:
  // Per-process singleton which must be managed by callers.
  static void Create();
  static void Destroy();
  static CPDF_FontGlobals* GetInstance();

  // Caller must load the maps before using font globals.
  void LoadEmbeddedMaps();

  void Clear(CPDF_Document* pDoc);
  RetainPtr<CPDF_Font> Find(CPDF_Document* pDoc,
                            CFX_FontMapper::StandardFont index);
  void Set(CPDF_Document* pDoc,
           CFX_FontMapper::StandardFont index,
           RetainPtr<CPDF_Font> pFont);

  void SetEmbeddedCharset(CIDSet idx, pdfium::span<const FXCMAP_CMap> map) {
    m_EmbeddedCharsets[idx] = map;
  }
  pdfium::span<const FXCMAP_CMap> GetEmbeddedCharset(CIDSet idx) const {
    return m_EmbeddedCharsets[idx];
  }
  void SetEmbeddedToUnicode(CIDSet idx, pdfium::span<const uint16_t> map) {
    m_EmbeddedToUnicodes[idx] = map;
  }
  pdfium::span<const uint16_t> GetEmbeddedToUnicode(CIDSet idx) {
    return m_EmbeddedToUnicodes[idx];
  }

  RetainPtr<const CPDF_CMap> GetPredefinedCMap(const ByteString& name);
  CPDF_CID2UnicodeMap* GetCID2UnicodeMap(CIDSet charset);

 private:
  CPDF_FontGlobals();
  ~CPDF_FontGlobals();

  void LoadEmbeddedGB1CMaps();
  void LoadEmbeddedCNS1CMaps();
  void LoadEmbeddedJapan1CMaps();
  void LoadEmbeddedKorea1CMaps();

  std::map<ByteString, RetainPtr<const CPDF_CMap>> m_CMaps;
  std::unique_ptr<CPDF_CID2UnicodeMap> m_CID2UnicodeMaps[CIDSET_NUM_SETS];
  pdfium::span<const FXCMAP_CMap> m_EmbeddedCharsets[CIDSET_NUM_SETS];
  pdfium::span<const uint16_t> m_EmbeddedToUnicodes[CIDSET_NUM_SETS];
  std::map<UnownedPtr<CPDF_Document>,
           std::unique_ptr<CFX_StockFontArray>,
           std::less<>>
      m_StockMap;
};

#endif  // CORE_FPDFAPI_FONT_CPDF_FONTGLOBALS_H_
