/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_ORCUS_GNUMERICCONTEXT_HPP
#define INCLUDED_ORCUS_GNUMERICCONTEXT_HPP

#include "xml_context_base.hpp"
#include "gnumeric_sheet_context.hpp"
#include "orcus/spreadsheet/types.hpp"

#include <vector>

namespace orcus {

namespace spreadsheet { namespace iface {

class import_factory;
class import_sheet;

}}

class gnumeric_content_xml_context : public xml_context_base
{
public:
    gnumeric_content_xml_context(session_context& session_cxt, const tokens& tokens, spreadsheet::iface::import_factory* factory);
    virtual ~gnumeric_content_xml_context();

    virtual xml_context_base* create_child_context(xmlns_id_t ns, xml_token_t name);
    virtual void end_child_context(xmlns_id_t ns, xml_token_t name, xml_context_base* child);

    virtual void start_element(xmlns_id_t ns, xml_token_t name, const xml_token_attrs_t& attrs);
    virtual bool end_element(xmlns_id_t ns, xml_token_t name);
    virtual void characters(std::string_view str, bool transient);

private:
    spreadsheet::iface::import_factory* mp_factory;
    std::unique_ptr<xml_context_base> mp_child;
    spreadsheet::sheet_t m_sheet_count;

    gnumeric_sheet_context m_cxt_sheet;
};

}

#endif
/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
