#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <selinux/selinux.h>


int main(int argc, char **argv)
{
	int i, rc = 0, active, pending, len;
	char **names;

	rc = security_get_boolean_names(&names, &len);
	if (rc) {
		fprintf(stderr, "Error getting boolean names\n");
		exit(1);
	}

	for (i = 0; i < len; i++) {
		active = security_get_boolean_active(names[i]);
		if (active < 0) {
			fprintf(stderr, "Error getting active value for %s\n",
				names[i]);
			rc = -1;
			goto out;
		}
		pending = security_get_boolean_pending(names[i]);
		if (pending < 0) {
			fprintf(stderr, "Error getting active value for %s\n",
				names[i]);
			rc = -1;
			goto out;
		}
		printf("%s --> active: %d pending: %d\n", names[i],
		       active, pending);
	}

out:
	for (i = 0; i < len; i++)
		free(names[i]);
	free(names);
	exit(rc);
}
