/*
 * libspe2 - A wrapper to allow direct execution of SPE binaries
 * Copyright (C) 2005 IBM Corp.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License,
 * or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 *  License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software Foundation,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "spegang.h"
/*
 * libspe-gang
 * =====
 * 
 * This is a convienience library for SPE gangs. It uses libspe-base and pthreads to
 * set up and run gangs of SPE threads. The main thread "sees" a single pthread for
 * the whole gang of N plus N SPE contexts. As with libspe-thread, we need the SPE
 * contexts explicitly to be able to use libspe-base.
 */

/**
 * creates a single pthread for the gang, then one pthread per gang member.
 * It then creates/uses one SPE context in each of the pthreads, loads the
 * corresponding image, and starts execution - asynchronously to the main thread. 
 * For maxmimum flexibility, we allow the main thread to create the SPE
 * context using libspe-base. If *spectx is NULL, a new SPE context will
 * be created and returned. Otherwise *spectx is used in the new thread.
 */
int spe_gang_thread_create(    pthread_t *thread,
                        int number,
                        spe_context_t *spectx[],
                        spe_program_handle_t *spe_program_handle[], void *argp[], void *envp[], 
                        int flags[])
{
}
                       
/**
 * wait for termination of the whole gang (synchronization)
 * status[] returns the exit codes for threads in the gang.
 */
int spe_gang_wait(      pthread_t *thread,
                        int *status[], 
                        int options)
{
}

/**
 */

int spe_gang_defaults(  int policy, 
                        int priority)
{
}






