/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.
                  Let a thousand taggers bloom!

   Copyright (C) Robert Kaye 2003

   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: context.h,v 1.14 2003/11/14 06:54:58 robert Exp $

----------------------------------------------------------------------------*/
#ifndef CONTEXT_H
#define CONTEXT_H

#include "defs.h"

class Context
{
    public:

                 Context(void)
                   {
#if WIN32
                       fileMask = "%sortname\\%album\\%sortname-%album-%0num-%track";
                       variousFileMask = "Various Artists\\%album\\%album-%0num-%artist-%track";
#else
                       fileMask = "%artist/%album/%artist-%album-%0num-%track";
                       variousFileMask = "Various Artists/%album/%album-%0num-%artist-%track";
#endif
                       allowedFileCharacters = ""; // Allow all as per filesystem
                       destDir = "MyMusic";
                       topSrcDir = ".";
                       renameFiles = true;
                       moveFiles = true;
                       writeID3v1 = true;
                       trmThreshold = 80;
                       minThreshold = 50;
                       autoSaveThreshold = 90;
                       debug = false;
                       clearTags = false;
                       pimp = NULL;
                       analyzerPriority = eLow;
                       autoRemoveSavedFiles = false;
                       maxFileNameLen = -1;
                   };

        virtual  ~Context(void) {};

        void      setDestDir (const string &destDir)
                    { this->destDir = destDir; };
        string   &getDestDir (void)
                    { return destDir; };
                
        void      setTopSrcDir (const string &topSrcDir)
                    { this->topSrcDir = topSrcDir; };
        string   &getTopSrcDir (void)
                    { return topSrcDir; };
                
        void      setFileMask (const string &fileMask)
                    { this->fileMask = fileMask; };
        string   &getFileMask (void)
                    { return fileMask; };
                
        void      setVariousFileMask (const string &variousFileMask)
                    { this->variousFileMask = variousFileMask; };
        string   &getVariousFileMask (void)
                    { return variousFileMask; };
                
        void      setAllowedFileCharacters (const string &allowedFileCharacters)
                    { this->allowedFileCharacters = allowedFileCharacters; };
        string   &getAllowedFileCharacters (void)
                    { return allowedFileCharacters; };
                
        void      setRenameFiles (bool renameFiles)
                    { this->renameFiles = renameFiles; };
        bool      getRenameFiles (void)
                    { return renameFiles; };
                
        void      setMoveFiles (bool moveFiles)
                    { this->moveFiles = moveFiles; };
        bool      getMoveFiles (void)
                    { return moveFiles; };
                
        void      setWriteID3v1 (bool writeID3v1)
                    { this->writeID3v1 = writeID3v1; };
        bool      getWriteID3v1 (void)
                    { return writeID3v1; };
                
        void      setDebug (bool debug)
                    { this->debug = debug; };
        bool      getDebug (void)
                    { return debug; };
                
        void      setTRMCollisionThreshold (int trmThreshold)
                    { this->trmThreshold = trmThreshold; };
        int       getTRMCollisionThreshold (void)
                    { return trmThreshold; };
                
        void      setMinTRMThreshold (int minThreshold)
                    { this->minThreshold = minThreshold; };
        int       getMinTRMThreshold (void)
                    { return minThreshold; };
                
        void      setAutoSaveThreshold (int autoSaveThreshold)
                    { this->autoSaveThreshold = autoSaveThreshold; };
        int       getAutoSaveThreshold (void)
                    { return autoSaveThreshold; };
                
        void      setClearTags (bool clearTags)
                    { this->clearTags = clearTags; };
        bool      getClearTags (void)
                    { return clearTags; };
                
        void      setTunePimp (TunePimp *pimp)
                    { this->pimp = pimp; };
        TunePimp *getTunePimp (void)
                    { return pimp; };

        void      setAnalyzerPriority (TPThreadPriorityEnum pri)
                    { analyzerPriority = pri; }
        TPThreadPriorityEnum getAnalyzerPriority (void)
                    { return analyzerPriority; };

        void      setMaxFileNameLen (int maxFileNameLen)
                    { this->maxFileNameLen = maxFileNameLen; };
        int       getMaxFileNameLen (void)
                    { return maxFileNameLen; };
                
        void      setAutoRemoveSavedFiles (bool autoRemoveSavedFiles)
                    { this->autoRemoveSavedFiles = autoRemoveSavedFiles; };
        bool      getAutoRemoveSavedFiles (void)
                    { return autoRemoveSavedFiles; };
                
    private:

        string                fileMask, variousFileMask, destDir, 
                              topSrcDir, allowedFileCharacters;
        bool                  moveFiles, renameFiles, debug;
        bool                  writeID3v1, clearTags, autoRemoveSavedFiles;
        int                   trmThreshold, autoSaveThreshold, minThreshold, maxFileNameLen;
        TunePimp             *pimp;
        TPThreadPriorityEnum  analyzerPriority;
};

#endif
