/*
 * unity-webapps-action-tracker.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#include "unity-webapps-window-tracker.h"
#include "unity-webapps-window-tracker-wnck.h"

#ifdef UNITY_WEBAPPS_TEST_BUILD
#include "unity-webapps-window-tracker-mock.h"
#endif

#include "../unity-webapps-debug.h"

G_DEFINE_ABSTRACT_TYPE(UnityWebappsWindowTracker, unity_webapps_window_tracker, G_TYPE_OBJECT)

enum 
{
  PROP_0,
  PROP_ACTIVE_WINDOW
};

static UnityWebappsWindowTracker *default_tracker = NULL;

#define UNITY_WEBAPPS_WINDOW_TRACKER_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER, UnityWebappsWindowTrackerPrivate))


static void
unity_webapps_window_tracker_finalize (GObject *object)
{

}

static void
unity_webapps_window_tracker_get_property (GObject *object, guint property_id,
					   GValue *value, GParamSpec *pspec)
{
  UnityWebappsWindowTracker *self;
  
  self = UNITY_WEBAPPS_WINDOW_TRACKER (object);
  
  switch (property_id)
    {
    case PROP_ACTIVE_WINDOW:
      g_value_set_uint64 (value, unity_webapps_window_tracker_get_active_window_id (self));
      break;
    }
}

static void
unity_webapps_window_tracker_class_init (UnityWebappsWindowTrackerClass *klass)
{
  GParamSpec *pspec;
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  object_class->finalize = unity_webapps_window_tracker_finalize;
  object_class->get_property = unity_webapps_window_tracker_get_property;
  
  pspec = g_param_spec_uint64 ("active-window-id", "Active Window ID", "Active Window ID which matches certain rules",
			       0, G_MAXUINT64, 0, G_PARAM_READABLE);
  g_object_class_install_property (object_class, PROP_ACTIVE_WINDOW, pspec);
}

static void
unity_webapps_window_tracker_init (UnityWebappsWindowTracker *tracker)
{
  
}

UnityWebappsWindowTracker *
unity_webapps_window_tracker_get_default ()
{
  if (default_tracker == NULL)
    {
#ifndef UNITY_WEBAPPS_TEST_BUILD
      default_tracker = g_object_new (UNITY_WEBAPPS_TYPE_WINDOW_TRACKER_WNCK, NULL);
#else
      default_tracker = g_object_new (UNITY_WEBAPPS_TYPE_WINDOW_TRACKER_MOCK, NULL);
#endif
    }
  return default_tracker;
}

guint64
unity_webapps_window_tracker_get_active_window_id (UnityWebappsWindowTracker *tracker)
{
  g_return_val_if_fail (UNITY_WEBAPPS_IS_WINDOW_TRACKER (tracker), 0);
  
  if (UNITY_WEBAPPS_WINDOW_TRACKER_GET_CLASS (tracker)->get_active_window_id)
    {
      return UNITY_WEBAPPS_WINDOW_TRACKER_GET_CLASS (tracker)->get_active_window_id (tracker);
    }
  return 0;
}
