#include <gio/gio.h>

#include "unity-webapps-application-manifest.h"
#include "unity-webapps-debug.h"

typedef struct _ManifestTestFixture {
  UnityWebappsApplicationManifest *manifest;
} ManifestTestFixture;


static void
setup_fixture_simple (ManifestTestFixture *fixture, gconstpointer user_data)
{
  gboolean loaded;
  fixture->manifest = unity_webapps_application_manifest_new ();
  loaded = unity_webapps_application_manifest_load_from_file (fixture->manifest, "test-manifest-1.json");
  g_assert (loaded);
}


static void
teardown_fixture_simple (ManifestTestFixture *fixture, gconstpointer user_data)
{
  g_object_unref (G_OBJECT (fixture->manifest));
}

static void
test_load_simple_manifest_names_1 (ManifestTestFixture *fixture, gconstpointer user_data)
{
  g_assert_cmpstr ("TestApplication", ==, unity_webapps_application_manifest_get_name (fixture->manifest));
  g_assert_cmpstr ("webapps-test-application", ==, unity_webapps_application_manifest_get_package_name (fixture->manifest));
}


static void
test_load_simple_manifest_domain_1 (ManifestTestFixture *fixture, gconstpointer user_data)
{
  g_assert_cmpstr ("test.ts", ==, unity_webapps_application_manifest_get_domain (fixture->manifest));
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  unity_webapps_debug_initialize_flags ();
  
  g_test_add("/Applications/Manifest/Simple/Names", ManifestTestFixture, NULL,
	     setup_fixture_simple, test_load_simple_manifest_names_1, teardown_fixture_simple);
  g_test_add("/Applications/Manifest/Simple/Domain", ManifestTestFixture, NULL,
	     setup_fixture_simple, test_load_simple_manifest_domain_1, teardown_fixture_simple);
  
  return g_test_run ();
}
