#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;
static UnityWebappsService *service = NULL;
  


guint count = 2;

static void
raise_one (UnityWebappsContext *context,
           const gchar *file,
	   gpointer user_data)
{
  uwa_emit_test_finished ();
}

static void
raise_two (UnityWebappsContext *context,
           const gchar *file,
	   gpointer user_data)
{
  g_warning ("Got wrong raise signal");
  exit (1);
}

static gboolean
change_activity (gpointer user_data)
{
  UnityWebappsContext *context;
  
  context = (UnityWebappsContext *)user_data;
  
  printf("Fooo \n");
  
  unity_webapps_context_set_view_is_active (context, FALSE);
  
  return FALSE;
}

static void
context_two_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_context_on_raise_callback (context, raise_two, NULL);
  unity_webapps_context_set_view_is_active (context, TRUE);
  
  g_timeout_add_seconds (1, change_activity, context);
}

static void
context_one_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_context_on_raise_callback (context, raise_one, NULL);
  unity_webapps_context_set_view_is_active (context, TRUE);
  
  unity_webapps_indicator_show_indicator (context, "Multicontext raise test");

  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_two_ready, NULL);

}




gint
main (gint argc, gchar **argv)
{
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_one_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
