/*
 * unity-webapps-service-preinstalled-app.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <gio/gdesktopappinfo.h>

#include "unity-webapps-service-preinstalled-app.h"

#define AMAZON_DESKTOP_FILE "ubuntu-amazon-default.desktop"
#define UBUNTU_ONE_DESKTOP_FILE "UbuntuOneMusiconeubuntucom.desktop"

static GHashTable *
unity_webapps_service_get_preinstalled_desktop_ids_by_webapp_id ()
{
  GDesktopAppInfo *desktop_file;
  GHashTable *desktop_ids;
  
  desktop_ids = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, NULL);

  desktop_file = g_desktop_app_info_new (AMAZON_DESKTOP_FILE);
  if (desktop_file)
    {
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.com)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.com)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.ca)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.ca)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.cn)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.cn)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.co.uk)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.co.uk)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.fr)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.fr)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.it)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.it)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.es)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.es)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, amazon.de)", AMAZON_DESKTOP_FILE);
      g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.de)", AMAZON_DESKTOP_FILE);
      g_object_unref (desktop_file);
    }

  desktop_file = g_desktop_app_info_new (UBUNTU_ONE_DESKTOP_FILE);
  if (desktop_file)
    {
      g_hash_table_insert (desktop_ids, "(Ubuntu One Music, one.ubuntu.com)", UBUNTU_ONE_DESKTOP_FILE);
      g_object_unref (desktop_file);
    }

  return desktop_ids;
}

const gchar *
unity_webapps_service_get_preinstalled_app_desktop_id (const gchar *name, const gchar *domain)
{
  // Note this is static if refactoring :)
  static GHashTable *desktop_ids = NULL;
  gchar *webapp_id, *desktop_id;
  
  if (desktop_ids == NULL)
    {
      desktop_ids = unity_webapps_service_get_preinstalled_desktop_ids_by_webapp_id ();
    }
  
  webapp_id = g_strdup_printf("(%s, %s)", name, domain);
  desktop_id = g_hash_table_lookup (desktop_ids, webapp_id);

  g_free (webapp_id);
  
  return desktop_id;
}
