/* unity-scope.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-scope.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dee.h>


#define UNITY_TYPE_SCOPE_IMPL (unity_scope_impl_get_type ())
#define UNITY_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImpl))
#define UNITY_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))
#define UNITY_IS_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_IS_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_SCOPE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))

typedef struct _UnityScopeImpl UnityScopeImpl;
typedef struct _UnityScopeImplClass UnityScopeImplClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_VIEW_TYPE (unity_view_type_get_type ())

#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;
typedef struct _UnityScopeImplPrivate UnityScopeImplPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeActivateData UnityScopeActivateData;
typedef struct _UnityScopeSearchData UnityScopeSearchData;
typedef struct _UnityScopeGlobalSearchData UnityScopeGlobalSearchData;
typedef struct _UnityScopePreviewData UnityScopePreviewData;

struct _UnityScopePrivate {
	gboolean _active;
	gboolean _exported;
	gboolean _search_in_global;
	gchar* _dbus_path;
	UnityOptionsFilter* _sources;
	UnityLensSearch* last_search[2];
	UnityScopeImpl* _pimpl;
	gboolean is_local;
};

typedef enum  {
	UNITY_VIEW_TYPE_HIDDEN,
	UNITY_VIEW_TYPE_HOME_VIEW,
	UNITY_VIEW_TYPE_LENS_VIEW
} UnityViewType;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_view_type) (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_view_type_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityScopeImpl {
	GObject parent_instance;
	UnityScopeImplPrivate * priv;
	DeeSerializableModel* _results_model;
	DeeSerializableModel* _global_results_model;
	DeeSerializableModel* _filters_model;
};

struct _UnityScopeImplClass {
	GObjectClass parent_class;
};

struct _UnityScopeActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	UnityActivationReplyRaw _tmp3_;
	UnityActivationReplyRaw reply;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	UnityActivationReplyRaw res;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GHashTable* _tmp11_;
	GError * _inner_error_;
};

struct _UnityScopeSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _result_;
	GError * _inner_error_;
};

struct _UnityScopeGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _result_;
	GError * _inner_error_;
};

struct _UnityScopePreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	UnityPreviewReplyRaw _tmp2_;
	UnityPreviewReplyRaw reply;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	UnityPreviewReplyRaw _tmp8_;
	GError * _inner_error_;
};


static gpointer unity_scope_parent_class = NULL;

GType unity_scope_impl_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE, UnityScopePrivate))
enum  {
	UNITY_SCOPE_DUMMY_PROPERTY,
	UNITY_SCOPE_ACTIVE,
	UNITY_SCOPE_EXPORTED,
	UNITY_SCOPE_SEARCH_IN_GLOBAL,
	UNITY_SCOPE_DBUS_PATH,
	UNITY_SCOPE_SOURCES,
	UNITY_SCOPE_FILTERS,
	UNITY_SCOPE_RESULTS_MODEL,
	UNITY_SCOPE_GLOBAL_RESULTS_MODEL
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void unity_scope_impl_export (UnityScopeImpl* self, GError** error);
static void unity_scope_set_exported (UnityScope* self, gboolean value);
static void unity_scope_prepare_search (UnityScope* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
void unity_scope_impl_update_search_key (UnityScopeImpl* self, UnityLensSearch* ls, UnitySearchType search_type);
void unity_scope_impl_schedule_search_changed (UnityScopeImpl* self, UnityLensSearch* search, UnitySearchType search_type, gboolean wait_for_view, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_impl_schedule_search_changed_finish (UnityScopeImpl* self, GAsyncResult* _res_);
void unity_scope_impl_invalidate_search (UnityScopeImpl* self, UnitySearchType search_type);
UnityLensSearch* unity_scope_get_last_search (UnityScope* self, UnitySearchType search_type);
void unity_scope_set_last_search (UnityScope* self, UnityLensSearch* search, UnitySearchType search_type);
GType unity_view_type_get_type (void) G_GNUC_CONST;
void unity_scope_set_view_type_internal (UnityScope* self, UnityViewType view_type);
void unity_scope_impl_set_view_type (UnityScopeImpl* self, UnityViewType value);
void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void unity_filter_option_set_active (UnityFilterOption* self, gboolean value);
void unity_scope_set_local (UnityScope* self, gboolean is_local_);
DeeSerializableModel* unity_scope_get_filter_model (UnityScope* self);
GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
static void unity_scope_activate_data_free (gpointer _data);
void unity_scope_activate (UnityScope* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_activate_finish (UnityScope* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
static gboolean unity_scope_activate_co (UnityScopeActivateData* _data_);
void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
static void unity_scope_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_search_data_free (gpointer _data);
void unity_scope_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_search_finish (UnityScope* self, GAsyncResult* _res_, GError** error);
static gboolean unity_scope_search_co (UnityScopeSearchData* _data_);
void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_global_search_data_free (gpointer _data);
void unity_scope_global_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_global_search_finish (UnityScope* self, GAsyncResult* _res_, GError** error);
static gboolean unity_scope_global_search_co (UnityScopeGlobalSearchData* _data_);
void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_preview_data_free (gpointer _data);
void unity_scope_preview (UnityScope* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_preview_finish (UnityScope* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
static gboolean unity_scope_preview_co (UnityScopePreviewData* _data_);
void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
static void unity_scope_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_scope_set_sources (UnityScope* self, UnityOptionsFilter* value);
static void g_cclosure_user_marshal_OBJECT__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_ENUM_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_STRING__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * unity_scope_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
UnityScopeImpl* unity_scope_impl_new (UnityScope* owner);
UnityScopeImpl* unity_scope_impl_construct (GType object_type, UnityScope* owner);
static void unity_scope_finalize (GObject* obj);
static void _vala_unity_scope_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_scope_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType unity_search_type_get_type (void) {
	static volatile gsize unity_search_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_search_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_SEARCH_TYPE_DEFAULT, "UNITY_SEARCH_TYPE_DEFAULT", "default"}, {UNITY_SEARCH_TYPE_GLOBAL, "UNITY_SEARCH_TYPE_GLOBAL", "global"}, {UNITY_SEARCH_TYPE_N_TYPES, "UNITY_SEARCH_TYPE_N_TYPES", "n-types"}, {0, NULL, NULL}};
		GType unity_search_type_type_id;
		unity_search_type_type_id = g_enum_register_static ("UnitySearchType", values);
		g_once_init_leave (&unity_search_type_type_id__volatile, unity_search_type_type_id);
	}
	return unity_search_type_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


UnityScope* unity_scope_construct (GType object_type, const gchar* dbus_path_) {
	UnityScope * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (dbus_path_ != NULL, NULL);
	_tmp0_ = dbus_path_;
	self = (UnityScope*) g_object_new (object_type, "dbus-path", _tmp0_, NULL);
	return self;
}


UnityScope* unity_scope_new (const gchar* dbus_path_) {
	return unity_scope_construct (UNITY_TYPE_SCOPE, dbus_path_);
}


void unity_scope_export (UnityScope* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_exported;
	if (!_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->is_local;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		UnityScopeImpl* _tmp4_;
		_tmp4_ = self->priv->_pimpl;
		unity_scope_impl_export (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		unity_scope_set_exported (self, TRUE);
		unity_scope_prepare_search (self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityFilter* unity_scope_get_filter (UnityScope* self, const gchar* id) {
	UnityFilter* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->_filters;
	{
		GList* filter_collection = NULL;
		GList* filter_it = NULL;
		filter_collection = _tmp0_;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* _tmp1_;
			UnityFilter* filter = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilter*) filter_it->data);
			filter = _tmp1_;
			{
				UnityFilter* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp2_ = filter;
				_tmp3_ = unity_filter_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = id;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = filter;
					return result;
				}
				_g_object_unref0 (filter);
			}
		}
	}
	result = NULL;
	return result;
}


/**
   * Invalidates current search and queues new search.
   *
   * This method will invalidate (and cancel) last search and queue a new
   * search (with the same search_string). The {@link Scope.search_changed}
   * signal will be emitted immediately in case the Lens managing this scope
   * is active, or as soon as it becomes active.
   *
   * @param search_type: Type of search to queue.
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


void unity_scope_queue_search_changed (UnityScope* self, UnitySearchType search_type) {
	UnitySearchType _tmp0_;
	UnitySearchType _tmp1_;
	gboolean is_global_search;
	UnitySearchType _tmp2_;
	UnityLensSearch* _tmp3_;
	UnityLensSearch* _tmp4_;
	UnityLensSearch* search;
	UnitySearchType _tmp5_;
	UnityLensSearch* _tmp6_;
	UnityScopeImpl* _tmp22_;
	UnityLensSearch* _tmp23_;
	UnitySearchType _tmp24_;
	UnityScopeImpl* _tmp25_;
	UnityLensSearch* _tmp26_;
	UnitySearchType _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = search_type;
	g_return_if_fail (_tmp0_ < UNITY_SEARCH_TYPE_N_TYPES);
	_tmp1_ = search_type;
	is_global_search = _tmp1_ == UNITY_SEARCH_TYPE_GLOBAL;
	_tmp2_ = search_type;
	_tmp3_ = self->priv->last_search[_tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	search = _tmp4_;
	_tmp5_ = search_type;
	unity_scope_invalidate_search (self, _tmp5_);
	_tmp6_ = search;
	if (_tmp6_ == NULL) {
		GHashFunc _tmp7_;
		GEqualFunc _tmp8_;
		GHashTable* _tmp9_;
		GHashTable* ht;
		DeeSerializableModel* _tmp10_ = NULL;
		gboolean _tmp11_;
		DeeSerializableModel* _tmp16_;
		DeeSerializableModel* _tmp17_;
		DeeSerializableModel* model;
		GHashTable* _tmp18_;
		DeeSerializableModel* _tmp19_;
		UnityLensSearch* _tmp20_;
		UnityLensSearch* _tmp21_;
		_tmp7_ = g_str_hash;
		_tmp8_ = g_str_equal;
		_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_variant_unref0_);
		ht = _tmp9_;
		_tmp11_ = is_global_search;
		if (_tmp11_) {
			DeeSerializableModel* _tmp12_;
			DeeSerializableModel* _tmp13_;
			_tmp12_ = unity_scope_get_global_results_model (self);
			_tmp13_ = _tmp12_;
			_tmp10_ = _tmp13_;
		} else {
			DeeSerializableModel* _tmp14_;
			DeeSerializableModel* _tmp15_;
			_tmp14_ = unity_scope_get_results_model (self);
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp15_;
		}
		_tmp16_ = _tmp10_;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		model = _tmp17_;
		_tmp18_ = ht;
		_tmp19_ = model;
		_tmp20_ = unity_lens_search_new ("", _tmp18_, _tmp19_);
		_tmp21_ = g_object_ref_sink (_tmp20_);
		_g_object_unref0 (search);
		search = _tmp21_;
		_g_object_unref0 (model);
		_g_hash_table_unref0 (ht);
	}
	_tmp22_ = self->priv->_pimpl;
	_tmp23_ = search;
	_tmp24_ = search_type;
	unity_scope_impl_update_search_key (_tmp22_, _tmp23_, _tmp24_);
	_tmp25_ = self->priv->_pimpl;
	_tmp26_ = search;
	_tmp27_ = search_type;
	unity_scope_impl_schedule_search_changed (_tmp25_, _tmp26_, _tmp27_, TRUE, NULL, NULL);
	_g_object_unref0 (search);
}


/**
   * Invalidates last search.
   *
   * Invalidate last search, so that the next search request will trigger
   * the {@link Scope.search_changed} signal even if the search would be
   * otherwise discarded because of unchanged search key.
   *
   * @param search_type: Type of search to invalidate.
   * @see Scope.generate_search_key
   */
void unity_scope_invalidate_search (UnityScope* self, UnitySearchType search_type) {
	UnitySearchType _tmp0_;
	UnityScopeImpl* _tmp1_;
	UnitySearchType _tmp2_;
	UnitySearchType _tmp3_;
	UnityLensSearch* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = search_type;
	g_return_if_fail (_tmp0_ < UNITY_SEARCH_TYPE_N_TYPES);
	_tmp1_ = self->priv->_pimpl;
	_tmp2_ = search_type;
	unity_scope_impl_invalidate_search (_tmp1_, _tmp2_);
	_tmp3_ = search_type;
	_g_object_unref0 (self->priv->last_search[_tmp3_]);
	self->priv->last_search[_tmp3_] = NULL;
	_tmp4_ = self->priv->last_search[_tmp3_];
}


UnityLensSearch* unity_scope_get_last_search (UnityScope* self, UnitySearchType search_type) {
	UnityLensSearch* result = NULL;
	UnitySearchType _tmp0_;
	UnityLensSearch* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = search_type;
	_tmp1_ = self->priv->last_search[_tmp0_];
	result = _tmp1_;
	return result;
}


void unity_scope_set_last_search (UnityScope* self, UnityLensSearch* search, UnitySearchType search_type) {
	UnitySearchType _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	UnityLensSearch* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = search_type;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->last_search[_tmp0_]);
	self->priv->last_search[_tmp0_] = _tmp2_;
	_tmp3_ = self->priv->last_search[_tmp0_];
}


void unity_scope_set_view_type_internal (UnityScope* self, UnityViewType view_type) {
	UnityScopeImpl* _tmp0_;
	UnityViewType _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pimpl;
	_tmp1_ = view_type;
	unity_scope_impl_set_view_type (_tmp0_, _tmp1_);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1) {
	UnityOptionsFilter* _tmp0_;
	GList* _tmp1_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sources;
	_tmp1_ = _tmp0_->options;
	{
		GList* filter_option_collection = NULL;
		GList* filter_option_it = NULL;
		filter_option_collection = _tmp1_;
		for (filter_option_it = filter_option_collection; filter_option_it != NULL; filter_option_it = filter_option_it->next) {
			UnityFilterOption* _tmp2_;
			UnityFilterOption* filter_option = NULL;
			_tmp2_ = _g_object_ref0 ((UnityFilterOption*) filter_option_it->data);
			filter_option = _tmp2_;
			{
				UnityFilterOption* _tmp3_;
				UnityFilterOption* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				_tmp3_ = filter_option;
				_tmp4_ = filter_option;
				_tmp5_ = unity_filter_option_get_id (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = active_sources_;
				_tmp7__length1 = active_sources__length1;
				unity_filter_option_set_active (_tmp3_, _vala_string_array_contains (_tmp7_, _tmp7__length1, _tmp6_));
				_g_object_unref0 (filter_option);
			}
		}
	}
	_tmp8_ = active_sources_;
	_tmp8__length1 = active_sources__length1;
	g_signal_emit_by_name (self, "active-sources-changed", _tmp8_, _tmp8__length1);
}


void unity_scope_set_local (UnityScope* self, gboolean is_local_) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_local_;
	self->priv->is_local = _tmp0_;
	_tmp1_ = self->priv->is_local;
	if (_tmp1_) {
		unity_scope_prepare_search (self);
	}
}


static void unity_scope_prepare_search (UnityScope* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_in_global;
	if (_tmp0_) {
		unity_scope_queue_search_changed (self, UNITY_SEARCH_TYPE_GLOBAL);
	}
}


DeeSerializableModel* unity_scope_get_filter_model (UnityScope* self) {
	DeeSerializableModel* result = NULL;
	UnityScopeImpl* _tmp0_;
	DeeSerializableModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pimpl;
	_tmp1_ = _tmp0_->_filters_model;
	result = _tmp1_;
	return result;
}


static void unity_scope_activate_data_free (gpointer _data) {
	UnityScopeActivateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_activation_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeActivateData, _data_);
}


void unity_scope_activate (UnityScope* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeActivateData* _data_;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	_data_ = g_slice_new0 (UnityScopeActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	_tmp3_ = action_type;
	_data_->action_type = _tmp3_;
	unity_scope_activate_co (_data_);
}


void unity_scope_activate_finish (UnityScope* self, GAsyncResult* _res_, UnityActivationReplyRaw* result) {
	UnityScopeActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_activate_co (_data_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean unity_scope_activate_co (UnityScopeActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_pimpl;
		_data_->_tmp1_ = _data_->uri;
		_data_->_tmp2_ = _data_->action_type;
		memset (&_data_->_tmp3_, 0, sizeof (UnityActivationReplyRaw));
		_data_->_state_ = 1;
		unity_scope_service_activate ((UnityScopeService*) _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, unity_scope_activate_ready, _data_);
		return FALSE;
		_state_1:
		unity_scope_service_activate_finish ((UnityScopeService*) _data_->_tmp0_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error_);
		_data_->reply = _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_data_->result = _data_->reply;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally18;
	__catch18_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat ("Unable to activate scope: ", _data_->_tmp6_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		g_warning ("unity-scope.vala:199: %s", _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally18:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	memset (&_data_->res, 0, sizeof (UnityActivationReplyRaw));
	_data_->_tmp9_ = _data_->uri;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (_data_->res.uri);
	_data_->res.uri = _data_->_tmp10_;
	_data_->res.handled = (guint) UNITY_HANDLED_TYPE_NOT_HANDLED;
	_data_->_tmp11_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (_data_->res.hints);
	_data_->res.hints = _data_->_tmp11_;
	_data_->result = _data_->res;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	unity_activation_reply_raw_destroy (&_data_->res);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_search_data_free (gpointer _data) {
	UnityScopeSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeSearchData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity_scope_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeSearchData* _data_;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	_data_ = g_slice_new0 (UnityScopeSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_search_co (_data_);
}


GHashTable* unity_scope_search_finish (UnityScope* self, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityScopeSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_search_co (_data_);
}


static gboolean unity_scope_search_co (UnityScopeSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_pimpl;
	_data_->_tmp1_ = _data_->search_string;
	_data_->_tmp2_ = _data_->hints;
	_data_->_state_ = 1;
	unity_scope_service_search ((UnityScopeService*) _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, unity_scope_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = unity_scope_service_search_finish ((UnityScopeService*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->_result_ = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_global_search_data_free (gpointer _data) {
	UnityScopeGlobalSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeGlobalSearchData, _data_);
}


void unity_scope_global_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeGlobalSearchData* _data_;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	_data_ = g_slice_new0 (UnityScopeGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_global_search_co (_data_);
}


GHashTable* unity_scope_global_search_finish (UnityScope* self, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityScopeGlobalSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeGlobalSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_global_search_co (_data_);
}


static gboolean unity_scope_global_search_co (UnityScopeGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_pimpl;
	_data_->_tmp1_ = _data_->search_string;
	_data_->_tmp2_ = _data_->hints;
	_data_->_state_ = 1;
	unity_scope_service_global_search ((UnityScopeService*) _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, unity_scope_global_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = unity_scope_service_global_search_finish ((UnityScopeService*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->_result_ = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_preview_data_free (gpointer _data) {
	UnityScopePreviewData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_preview_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopePreviewData, _data_);
}


void unity_scope_preview (UnityScope* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopePreviewData* _data_;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (UnityScopePreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_preview_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	unity_scope_preview_co (_data_);
}


void unity_scope_preview_finish (UnityScope* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result) {
	UnityScopePreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopePreviewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_preview_co (_data_);
}


static gboolean unity_scope_preview_co (UnityScopePreviewData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_pimpl;
		_data_->_tmp1_ = _data_->uri;
		memset (&_data_->_tmp2_, 0, sizeof (UnityPreviewReplyRaw));
		_data_->_state_ = 1;
		unity_scope_service_preview ((UnityScopeService*) _data_->_tmp0_, _data_->_tmp1_, unity_scope_preview_ready, _data_);
		return FALSE;
		_state_1:
		unity_scope_service_preview_finish ((UnityScopeService*) _data_->_tmp0_, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error_);
		_data_->reply = _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_data_->result = _data_->reply;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally19;
	__catch19_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_strconcat ("Unable to preview scope: ", _data_->_tmp5_, NULL);
		_data_->_tmp7_ = _data_->_tmp6_;
		g_warning ("unity-scope.vala:228: %s", _data_->_tmp7_);
		_g_free0 (_data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally19:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	memset (&_data_->_tmp8_, 0, sizeof (UnityPreviewReplyRaw));
	memset (&_data_->_tmp8_, 0, sizeof (UnityPreviewReplyRaw));
	_data_->result = _data_->_tmp8_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gboolean unity_scope_get_active (UnityScope* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void unity_scope_set_active (UnityScope* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_active = _tmp0_;
	g_object_notify ((GObject *) self, "active");
}


gboolean unity_scope_get_exported (UnityScope* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_exported;
	result = _tmp0_;
	return result;
}


static void unity_scope_set_exported (UnityScope* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_exported = _tmp0_;
	g_object_notify ((GObject *) self, "exported");
}


gboolean unity_scope_get_search_in_global (UnityScope* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_search_in_global;
	result = _tmp0_;
	return result;
}


void unity_scope_set_search_in_global (UnityScope* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_search_in_global = _tmp0_;
	g_object_notify ((GObject *) self, "search-in-global");
}


const gchar* unity_scope_get_dbus_path (UnityScope* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dbus_path;
	result = _tmp0_;
	return result;
}


static void unity_scope_set_dbus_path (UnityScope* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp1_;
	g_object_notify ((GObject *) self, "dbus-path");
}


UnityOptionsFilter* unity_scope_get_sources (UnityScope* self) {
	UnityOptionsFilter* result;
	UnityOptionsFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sources;
	result = _tmp0_;
	return result;
}


void unity_scope_set_sources (UnityScope* self, UnityOptionsFilter* value) {
	UnityOptionsFilter* _tmp0_;
	UnityOptionsFilter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_sources);
	self->priv->_sources = _tmp1_;
	g_object_notify ((GObject *) self, "sources");
}


GList* unity_scope_get_filters (UnityScope* self) {
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_filters;
	result = _tmp0_;
	return result;
}


DeeSerializableModel* unity_scope_get_results_model (UnityScope* self) {
	DeeSerializableModel* result;
	UnityScopeImpl* _tmp0_;
	DeeSerializableModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pimpl;
	_tmp1_ = _tmp0_->_results_model;
	result = _tmp1_;
	return result;
}


DeeSerializableModel* unity_scope_get_global_results_model (UnityScope* self) {
	DeeSerializableModel* result;
	UnityScopeImpl* _tmp0_;
	DeeSerializableModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pimpl;
	_tmp1_ = _tmp0_->_global_results_model;
	result = _tmp1_;
	return result;
}


static void g_cclosure_user_marshal_OBJECT__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gpointer (*GMarshalFunc_OBJECT__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_OBJECT__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gpointer v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_OBJECT__STRING) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
	g_value_take_object (return_value, v_return);
}


static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_ENUM_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_ENUM_OBJECT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_ENUM_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_ENUM_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_enum (param_values + 2), g_value_get_object (param_values + 3), data2);
}


static void g_cclosure_user_marshal_STRING__OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef const char* (*GMarshalFunc_STRING__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_STRING__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	const char* v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_STRING__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_take_string (return_value, v_return);
}


static GObject * unity_scope_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityScope * self;
	UnityCheckOptionFilter* _tmp0_;
	UnityCheckOptionFilter* _tmp1_;
	UnityScopeImpl* _tmp2_;
	parent_class = G_OBJECT_CLASS (unity_scope_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SCOPE (obj);
	_tmp0_ = unity_check_option_filter_new ("sources", "Sources", NULL, TRUE);
	_tmp1_ = _tmp0_;
	unity_scope_set_sources (self, (UnityOptionsFilter*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = unity_scope_impl_new (self);
	_g_object_unref0 (self->priv->_pimpl);
	self->priv->_pimpl = _tmp2_;
	G_STATIC_ASSERT (UNITY_SEARCH_TYPE_N_TYPES == 2);
	return obj;
}


static void unity_scope_class_init (UnityScopeClass * klass) {
	unity_scope_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_scope_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_SEARCH_IN_GLOBAL, g_param_spec_boolean ("search-in-global", "search-in-global", "search-in-global", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_SOURCES, g_param_spec_object ("sources", "sources", "sources", UNITY_TYPE_OPTIONS_FILTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_FILTERS, g_param_spec_pointer ("filters", "filters", "filters", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_RESULTS_MODEL, g_param_spec_object ("results-model", "results-model", "results-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_GLOBAL_RESULTS_MODEL, g_param_spec_object ("global-results-model", "global-results-model", "global-results-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("activate_uri", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__STRING, UNITY_TYPE_ACTIVATION_RESPONSE, 1, G_TYPE_STRING);
	g_signal_new ("preview_uri", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__STRING, UNITY_TYPE_PREVIEW, 1, G_TYPE_STRING);
	g_signal_new ("filters_changed", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("active_sources_changed", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT, G_TYPE_NONE, 2, G_TYPE_STRV, G_TYPE_INT);
	g_signal_new ("search_changed", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_ENUM_OBJECT, G_TYPE_NONE, 3, UNITY_TYPE_LENS_SEARCH, UNITY_TYPE_SEARCH_TYPE, G_TYPE_CANCELLABLE);
	g_signal_new ("generate_search_key", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_user_marshal_STRING__OBJECT, G_TYPE_STRING, 1, UNITY_TYPE_LENS_SEARCH);
}


static void unity_scope_instance_init (UnityScope * self) {
	self->priv = UNITY_SCOPE_GET_PRIVATE (self);
	self->priv->_active = FALSE;
	self->priv->_exported = FALSE;
	self->priv->_search_in_global = TRUE;
	self->priv->is_local = FALSE;
	self->_filters = NULL;
}


static void unity_scope_finalize (GObject* obj) {
	UnityScope * self;
	self = UNITY_SCOPE (obj);
	_g_free0 (self->priv->_dbus_path);
	_g_object_unref0 (self->priv->_sources);
	_vala_array_destroy (self->priv->last_search, 2, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->priv->_pimpl);
	__g_list_free__g_object_unref0_0 (self->_filters);
	G_OBJECT_CLASS (unity_scope_parent_class)->finalize (obj);
}


GType unity_scope_get_type (void) {
	static volatile gsize unity_scope_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScope), 0, (GInstanceInitFunc) unity_scope_instance_init, NULL };
		GType unity_scope_type_id;
		unity_scope_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScope", &g_define_type_info, 0);
		g_once_init_leave (&unity_scope_type_id__volatile, unity_scope_type_id);
	}
	return unity_scope_type_id__volatile;
}


static void _vala_unity_scope_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScope * self;
	self = UNITY_SCOPE (object);
	switch (property_id) {
		case UNITY_SCOPE_ACTIVE:
		g_value_set_boolean (value, unity_scope_get_active (self));
		break;
		case UNITY_SCOPE_EXPORTED:
		g_value_set_boolean (value, unity_scope_get_exported (self));
		break;
		case UNITY_SCOPE_SEARCH_IN_GLOBAL:
		g_value_set_boolean (value, unity_scope_get_search_in_global (self));
		break;
		case UNITY_SCOPE_DBUS_PATH:
		g_value_set_string (value, unity_scope_get_dbus_path (self));
		break;
		case UNITY_SCOPE_SOURCES:
		g_value_set_object (value, unity_scope_get_sources (self));
		break;
		case UNITY_SCOPE_FILTERS:
		g_value_set_pointer (value, unity_scope_get_filters (self));
		break;
		case UNITY_SCOPE_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_get_results_model (self));
		break;
		case UNITY_SCOPE_GLOBAL_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_get_global_results_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScope * self;
	self = UNITY_SCOPE (object);
	switch (property_id) {
		case UNITY_SCOPE_ACTIVE:
		unity_scope_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_EXPORTED:
		unity_scope_set_exported (self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_SEARCH_IN_GLOBAL:
		unity_scope_set_search_in_global (self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_DBUS_PATH:
		unity_scope_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_SCOPE_SOURCES:
		unity_scope_set_sources (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



