/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Dee;

namespace Unity.Protocol {

/* The raw type that get's passed over DBus to Unity */
public struct LensInfo
{
  public string dbus_path;
  public bool search_in_global;
  public bool visible;
  public string search_hint;
  public string private_connection_name;
  public string results_model_name;
  public string global_results_model_name;
  public string categories_model_name;
  public string filters_model_name;
  public HashTable<string, Variant> hints;
}

/* The error types that can be thrown from DBus methods */
[DBus (name = "com.canonical.Unity.LensError")]
public errordomain LensError
{
  FAILED,
  INVALID_SCOPE
}


public enum HandledType
{
  NOT_HANDLED,
  SHOW_DASH,
  HIDE_DASH,
  GOTO_DASH_URI,
  SHOW_PREVIEW
}

public enum ActionType
{
  ACTIVATE_RESULT,
  PREVIEW_RESULT,
  PREVIEW_ACTION,
  PREVIEW_BUILTIN_ACTION
}

public enum ViewType
{
  HIDDEN,
  HOME_VIEW,
  LENS_VIEW
}

/**
 * LensService:
 *
 * The Lens interface exported on DBus
 */
[DBus (name = "com.canonical.Unity.Lens")]
public interface LensService : GLib.Object
{
  public async abstract void info_request () throws IOError;

  // FIXME: should have the hints param and activate_with_hints should go away
  public async abstract ActivationReplyRaw activate (
      string uri, uint action_type) throws IOError, LensError;

  public async abstract ActivationReplyRaw activate_with_hints (
      string uri, uint action_type, HashTable<string, Variant> hints) throws IOError, LensError;

  public async abstract HashTable<string, Variant> update_preview_property (string uri, HashTable<string, Variant> values) throws IOError, LensError;

  public async abstract HashTable<string, Variant> search (
      string search_string, HashTable<string, Variant> hints) throws IOError;

  public async abstract HashTable<string, Variant> global_search (
      string search_string, HashTable<string, Variant> hints) throws IOError;
  
  public async abstract void update_filter (string filter_name,
                                            HashTable<string, Variant> properties) throws IOError;
  
  public async abstract void set_view_type (uint view_type) throws IOError;
  
  public signal void changed (LensInfo lens_info);
}

} /* namespace unity */
