#!/usr/bin/python -u
#
# Those are the autogenerated Python bindings for libvirt.
# Check python/generator.py in the source distribution of libvir
# to find out more about the generation process
#
import libvirtmod
import types

# The root of all libxml2 errors.
class libvirtError(Exception):
    pass


#
# register the libvirt global error handler
#
def registerErrorHandler(f, ctx):
    """Register a Python written function to for error reporting.
       The function is called back as f(ctx, error), with error
       being a list of informations about the error being raised.
       Returns 1 in case of success."""
    return libvirtmod.virRegisterErrorHandler(f,ctx)

# WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
#
# Everything before this line comes from libvir.py
# Everything after this line is automatically generated
#
# WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
#
# Functions from module libvirt
#

def open(name):
    """This function should be called first to get a connection to
       the Hypervisor and xen store """
    ret = libvirtmod.virConnectOpen(name)
    if ret is None:raise libvirtError('virConnectOpen() failed')
    return virConnect(_obj=ret)

def openReadOnly(name):
    """This function should be called first to get a restricted
       connection to the libbrary functionalities. The set of
       APIs usable are then restricted on the available methods
       to control the domains. """
    ret = libvirtmod.virConnectOpenReadOnly(name)
    if ret is None:raise libvirtError('virConnectOpenReadOnly() failed')
    return virConnect(_obj=ret)

def virInitialize():
    """Initialize the library. It's better to call this routine at
       startup in multithreaded applications to avoid potential
       race when initializing the library. """
    ret = libvirtmod.virInitialize()
    return ret

#
# Functions from module virterror
#

def virResetLastError():
    """Reset the last error caught at the library level. """
    libvirtmod.virResetLastError()

class virDomain:
    def __init__(self, _obj=None):
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virDomainFree(self._o)
        self._o = None

    #
    # virDomain functions from module libvirt
    #

    def ID(self):
        """Get the hypervisor ID number for the domain """
        ret = libvirtmod.virDomainGetID(self._o)
        return ret

    def OSType(self):
        """Get the type of domain operation system. """
        ret = libvirtmod.virDomainGetOSType(self._o)
        return ret

    def XMLDesc(self, flags):
        """Provide an XML description of the domain. The description
           may be reused later to relaunch the domain with
           virDomainCreateLinux(). """
        ret = libvirtmod.virDomainGetXMLDesc(self._o, flags)
        return ret

    def create(self):
        """launch a defined domain. If the call succeed the domain
           moves from the defined to the running domains pools. """
        ret = libvirtmod.virDomainCreate(self._o)
        return ret

    def destroy(self):
        """Destroy the domain object. The running instance is shutdown
           if not down already and all resources used by it are given
           back to the hypervisor. The data structure is freed and
           should not be used thereafter if the call does not return
           an error. This function may requires priviledged access """
        ret = libvirtmod.virDomainDestroy(self._o)
        self._o = None
        return ret

    def maxMemory(self):
        """Retrieve the maximum amount of physical memory allocated to
           a domain. If domain is None, then this get the amount of
           memory reserved to Domain0 i.e. the domain where the
           application runs. """
        ret = libvirtmod.virDomainGetMaxMemory(self._o)
        return ret

    def name(self):
        """Get the public name for that domain """
        ret = libvirtmod.virDomainGetName(self._o)
        return ret

    def pinVcpu(self, vcpu, cpumap, maplen):
        """Dynamically change the real CPUs which can be allocated to
           a virtual CPU. This function requires priviledged access
           to the hypervisor. """
        ret = libvirtmod.virDomainPinVcpu(self._o, vcpu, cpumap, maplen)
        return ret

    def reboot(self, flags):
        """Reboot a domain, the domain object is still usable there
           after but the domain OS is being stopped for a restart.
           Note that the guest OS may ignore the request. """
        ret = libvirtmod.virDomainReboot(self._o, flags)
        return ret

    def resume(self):
        """Resume an suspended domain, the process is restarted from
           the state where it was frozen by calling
           virSuspendDomain(). This function may requires priviledged
           access """
        ret = libvirtmod.virDomainResume(self._o)
        return ret

    def save(self, to):
        """This method will suspend a domain and save its memory
           contents to a file on disk. After the call, if successful,
           the domain is not listed as running anymore (this may be a
           problem). Use virDomainRestore() to restore a domain after
           saving. """
        ret = libvirtmod.virDomainSave(self._o, to)
        return ret

    def setMaxMemory(self, memory):
        """Dynamically change the maximum amount of physical memory
           allocated to a domain. If domain is None, then this change
           the amount of memory reserved to Domain0 i.e. the domain
           where the application runs. This function requires
           priviledged access to the hypervisor. """
        ret = libvirtmod.virDomainSetMaxMemory(self._o, memory)
        return ret

    def setMemory(self, memory):
        """Dynamically change the target amount of physical memory
           allocated to a domain. If domain is None, then this change
           the amount of memory reserved to Domain0 i.e. the domain
           where the application runs. This function may requires
           priviledged access to the hypervisor. """
        ret = libvirtmod.virDomainSetMemory(self._o, memory)
        return ret

    def setVcpus(self, nvcpus):
        """Dynamically change the number of virtual CPUs used by the
           domain. Note that this call may fail if the underlying
           virtualization hypervisor does not support it or if
           growing the number is arbitrary limited. This function
           requires priviledged access to the hypervisor. """
        ret = libvirtmod.virDomainSetVcpus(self._o, nvcpus)
        return ret

    def shutdown(self):
        """Shutdown a domain, the domain object is still usable there
           after but the domain OS is being stopped. Note that the
           guest OS may ignore the request.  TODO: should we add an
           option for reboot, knowing it may not be doable in the
           general case ? """
        ret = libvirtmod.virDomainShutdown(self._o)
        return ret

    def suspend(self):
        """Suspends an active domain, the process is frozen without
           further access to CPU resources and I/O but the memory
           used by the domain at the hypervisor level will stay
           allocated. Use virDomainResume() to reactivate the domain.
           This function may requires priviledged access. """
        ret = libvirtmod.virDomainSuspend(self._o)
        return ret

    def uUIDString(self, buf):
        """Get the UUID for a domain as string. For more information
           about UUID see RFC4122. """
        ret = libvirtmod.virDomainGetUUIDString(self._o, buf)
        return ret

    def undefine(self):
        """undefine a domain but does not stop it if it is running """
        ret = libvirtmod.virDomainUndefine(self._o)
        return ret

    #
    # virDomain functions from module python
    #

    def UUID(self):
        """Extract the UUID unique Identifier of a domain. """
        ret = libvirtmod.virDomainGetUUID(self._o)
        return ret

    def info(self):
        """Extract informations about a domain. Note that if the
           connection used to get the domain is limited only a
           partial set of the informations can be extracted. """
        ret = libvirtmod.virDomainGetInfo(self._o)
        return ret

class virConnect:
    def __init__(self, _obj=None):
        if _obj != None:self._o = _obj;return
        self._o = None

    def __del__(self):
        if self._o != None:
            libvirtmod.virConnectClose(self._o)
        self._o = None

    #
    # virConnect functions from module libvirt
    #

    def createLinux(self, xmlDesc, flags):
        """Launch a new Linux guest domain, based on an XML
           description similar to the one returned by
           virDomainGetXMLDesc() This function may requires
           priviledged access to the hypervisor. """
        ret = libvirtmod.virDomainCreateLinux(self._o, xmlDesc, flags)
        if ret is None:raise libvirtError('virDomainCreateLinux() failed')
        __tmp = virDomain(_obj=ret)
        return __tmp

    def defineXML(self, xml):
        """define a domain, but does not start it """
        ret = libvirtmod.virDomainDefineXML(self._o, xml)
        if ret is None:raise libvirtError('virDomainDefineXML() failed')
        __tmp = virDomain(_obj=ret)
        return __tmp

    def getType(self):
        """Get the name of the Hypervisor software used. """
        ret = libvirtmod.virConnectGetType(self._o)
        return ret

    def lookupByID(self, id):
        """Try to find a domain based on the hypervisor ID number """
        ret = libvirtmod.virDomainLookupByID(self._o, id)
        if ret is None:raise libvirtError('virDomainLookupByID() failed')
        __tmp = virDomain(_obj=ret)
        return __tmp

    def lookupByName(self, name):
        """Try to lookup a domain on the given hypervisor based on its
           name. """
        ret = libvirtmod.virDomainLookupByName(self._o, name)
        if ret is None:raise libvirtError('virDomainLookupByName() failed')
        __tmp = virDomain(_obj=ret)
        return __tmp

    def lookupByUUIDString(self, uuidstr):
        """Try to lookup a domain on the given hypervisor based on its
           UUID. """
        ret = libvirtmod.virDomainLookupByUUIDString(self._o, uuidstr)
        if ret is None:raise libvirtError('virDomainLookupByUUIDString() failed')
        __tmp = virDomain(_obj=ret)
        return __tmp

    def numOfDefinedDomains(self):
        """Provides the number of active domains. """
        ret = libvirtmod.virConnectNumOfDefinedDomains(self._o)
        return ret

    def numOfDomains(self):
        """Provides the number of active domains. """
        ret = libvirtmod.virConnectNumOfDomains(self._o)
        return ret

    def restore(self, frm):
        """This method will restore a domain saved to disk by
           virDomainSave(). """
        ret = libvirtmod.virDomainRestore(self._o, frm)
        return ret

    #
    # virConnect functions from module python
    #

    def getInfo(self):
        """Extract hardware informations about the Node. """
        ret = libvirtmod.virNodeGetInfo(self._o)
        return ret

    def listDomainsID(self):
        """Returns the list of the ID of the domains on the hypervisor """
        ret = libvirtmod.virConnectListDomainsID(self._o)
        return ret

    def lookupByUUID(self, uuid):
        """Try to lookup a domain on the given hypervisor based on its
           UUID. """
        ret = libvirtmod.virDomainLookupByUUID(self._o, uuid)
        if ret is None:raise libvirtError('virDomainLookupByUUID() failed')
        __tmp = virDomain(_obj=ret)
        return __tmp

    #
    # virConnect functions from module virterror
    #

    def virConnResetLastError(self):
        """Reset the last error caught on that connection """
        libvirtmod.virConnResetLastError(self._o)

# virErrorLevel
VIR_ERR_NONE = 0
VIR_ERR_WARNING = 1
VIR_ERR_ERROR = 2

# virDomainState
VIR_DOMAIN_NOSTATE = 0
VIR_DOMAIN_RUNNING = 1
VIR_DOMAIN_BLOCKED = 2
VIR_DOMAIN_PAUSED = 3
VIR_DOMAIN_SHUTDOWN = 4
VIR_DOMAIN_SHUTOFF = 5
VIR_DOMAIN_CRASHED = 6

# virDeviceMode
VIR_DEVICE_DEFAULT = 0
VIR_DEVICE_RO = 1
VIR_DEVICE_RW = 2
VIR_DEVICE_RW_FORCE = 3

# virErrorDomain
VIR_FROM_NONE = 0
VIR_FROM_XEN = 1
VIR_FROM_XEND = 2
VIR_FROM_XENSTORE = 3
VIR_FROM_SEXPR = 4
VIR_FROM_XML = 5
VIR_FROM_DOM = 6
VIR_FROM_RPC = 7
VIR_FROM_PROXY = 8
VIR_FROM_CONF = 9

# virDomainRestart
VIR_DOMAIN_DESTROY = 1
VIR_DOMAIN_RESTART = 2
VIR_DOMAIN_PRESERVE = 3
VIR_DOMAIN_RENAME_RESTART = 4

# virErrorNumber
VIR_ERR_OK = 0
VIR_ERR_INTERNAL_ERROR = 1
VIR_ERR_NO_MEMORY = 2
VIR_ERR_NO_SUPPORT = 3
VIR_ERR_UNKNOWN_HOST = 4
VIR_ERR_NO_CONNECT = 5
VIR_ERR_INVALID_CONN = 6
VIR_ERR_INVALID_DOMAIN = 7
VIR_ERR_INVALID_ARG = 8
VIR_ERR_OPERATION_FAILED = 9
VIR_ERR_GET_FAILED = 10
VIR_ERR_POST_FAILED = 11
VIR_ERR_HTTP_ERROR = 12
VIR_ERR_SEXPR_SERIAL = 13
VIR_ERR_NO_XEN = 14
VIR_ERR_XEN_CALL = 15
VIR_ERR_OS_TYPE = 16
VIR_ERR_NO_KERNEL = 17
VIR_ERR_NO_ROOT = 18
VIR_ERR_NO_SOURCE = 19
VIR_ERR_NO_TARGET = 20
VIR_ERR_NO_NAME = 21
VIR_ERR_NO_OS = 22
VIR_ERR_NO_DEVICE = 23
VIR_ERR_NO_XENSTORE = 24
VIR_ERR_DRIVER_FULL = 25
VIR_ERR_CALL_FAILED = 26
VIR_ERR_XML_ERROR = 27
VIR_ERR_DOM_EXIST = 28
VIR_ERR_OPERATION_DENIED = 29
VIR_ERR_OPEN_FAILED = 30
VIR_ERR_READ_FAILED = 31
VIR_ERR_PARSE_FAILED = 32
VIR_ERR_CONF_SYNTAX = 33
VIR_ERR_WRITE_FAILED = 34

# virDomainCreateFlags
VIR_DOMAIN_NONE = 0

# virVcpuState
VIR_VCPU_OFFLINE = 0
VIR_VCPU_RUNNING = 1
VIR_VCPU_BLOCKED = 2

