/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    Label connStatusLabel;
    AuthPanel authenticator;
    AuthUnixLoginPanel authenticatorUnixLogin;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String socketFactory;
    String host;
    int port;
    boolean showControls;
    boolean offerRelogin;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    boolean disableSSL;
    String GET;
    String CONNECT;
    String urlPrefix;
    boolean forceProxy;
    public static Applet refApplet;

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    public void init() {
        this.readParameters();
        refApplet = this;
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        this.authenticator = new AuthPanel(this);
        this.authenticatorUnixLogin = new AuthUnixLoginPanel();
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public void update(Graphics graphics) {
    }

    public void run() {
        block19: {
            this.gridbag = new GridBagLayout();
            this.vncContainer.setLayout(this.gridbag);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            if (this.showControls) {
                this.buttonPanel = new ButtonPanel(this);
                this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
                this.vncContainer.add(this.buttonPanel);
            }
            try {
                this.connectAndAuthenticate();
                this.doProtocolInitialisation();
                this.vc = new VncCanvas(this);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                if (this.inSeparateFrame) {
                    Panel panel = new Panel();
                    panel.setLayout(new FlowLayout(0, 0, 0));
                    panel.add(this.vc);
                    this.desktopScrollPane = new ScrollPane(0);
                    gridBagConstraints.fill = 1;
                    this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                    this.desktopScrollPane.add(panel);
                    this.vncFrame.add(this.desktopScrollPane);
                    this.vncFrame.setTitle(this.rfb.desktopName);
                    this.vncFrame.pack();
                    this.vc.resizeDesktopFrame();
                } else {
                    this.gridbag.setConstraints(this.vc, gridBagConstraints);
                    this.add(this.vc);
                    this.validate();
                }
                if (this.showControls) {
                    this.buttonPanel.enableButtons();
                }
                this.moveFocusToDesktop();
                this.processNormalProtocol();
            }
            catch (NoRouteToHostException noRouteToHostException) {
                this.fatalError("Network error: no route to server: " + this.host, noRouteToHostException);
            }
            catch (UnknownHostException unknownHostException) {
                this.fatalError("Network error: server name unknown: " + this.host, unknownHostException);
            }
            catch (ConnectException connectException) {
                this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port, connectException);
            }
            catch (EOFException eOFException) {
                if (this.showOfflineDesktop) {
                    eOFException.printStackTrace();
                    System.out.println("Network error: remote side closed connection");
                    if (this.vc != null) {
                        this.vc.enableInput(false);
                    }
                    if (this.inSeparateFrame) {
                        this.vncFrame.setTitle(this.rfb.desktopName + " [disconnected]");
                    }
                    if (this.rfb != null && !this.rfb.closed()) {
                        this.rfb.close();
                    }
                    if (!this.showControls || this.buttonPanel == null) break block19;
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                    break block19;
                }
                this.fatalError("Network error: remote side closed connection", eOFException);
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                if (string != null && string.length() != 0) {
                    this.fatalError("Network Error: " + string, iOException);
                    break block19;
                }
                this.fatalError(iOException.toString(), iOException);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (string != null && string.length() != 0) {
                    this.fatalError("Error: " + string, exception);
                    break block19;
                }
                this.fatalError(exception.toString(), exception);
            }
        }
    }

    void processNormalProtocol() throws Exception {
        try {
            this.vc.processNormalProtocol();
        }
        catch (Exception exception) {
            if (this.rfbThread == null) {
                System.out.println("Ignoring RFB socket exceptions because applet is stopping");
            }
            throw exception;
        }
    }

    void connectAndAuthenticate() throws Exception {
        this.showConnectionStatus("Initializing...");
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
        }
        while (!this.tryAuthenticate()) {
            this.authenticator.retry();
            this.authenticatorUnixLogin.retry();
        }
    }

    boolean tryAuthenticate() throws Exception {
        this.showConnectionStatus("Connecting to " + this.host + ", port " + this.port + "...");
        this.rfb = new RfbProto(this.host, this.port, this);
        this.showConnectionStatus("Connected to server");
        this.rfb.readVersionMsg();
        this.showConnectionStatus("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        this.showConnectionStatus("Using RFB protocol version " + this.rfb.clientMajor + "." + this.rfb.clientMinor);
        int n = this.rfb.negotiateSecurity();
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 16: {
                this.showConnectionStatus("Enabling TightVNC protocol extensions");
                this.rfb.initCapabilities();
                this.rfb.setupTunneling();
                n2 = this.rfb.negotiateAuthenticationTight();
                break;
            }
            default: {
                throw new Exception("Unknown security type " + n);
            }
        }
        boolean bl = false;
        switch (n2) {
            case 1: {
                this.showConnectionStatus("No authentication needed");
                bl = true;
                break;
            }
            case 2: {
                this.showConnectionStatus("Performing standard VNC authentication");
                if (this.authenticator.isInteractionNecessary()) {
                    this.showAuthPanel(this.authenticator);
                    this.authenticator.moveFocusToDefaultField();
                }
                bl = this.authenticator.tryAuthenticate(this.rfb);
                if (this.authenticator.isInteractionNecessary()) {
                    this.vncContainer.remove(this.authenticator);
                    break;
                }
                if (bl) break;
                throw new Exception("VNC authentication failed");
            }
            case 129: {
                this.showConnectionStatus("Performing Unix login-style authentication");
                this.showAuthPanel(this.authenticatorUnixLogin);
                this.authenticatorUnixLogin.moveFocusToDefaultField();
                bl = this.authenticatorUnixLogin.tryAuthenticate(this.rfb);
                this.vncContainer.remove(this.authenticatorUnixLogin);
                break;
            }
            default: {
                throw new Exception("Unknown authentication scheme " + n2);
            }
        }
        if (!bl) {
            this.rfb.close();
        }
        return bl;
    }

    void showConnectionStatus(String string) {
        if (string == null) {
            if (this.vncContainer.isAncestorOf(this.connStatusLabel)) {
                this.vncContainer.remove(this.connStatusLabel);
            }
            return;
        }
        System.out.println(string);
        if (this.connStatusLabel == null) {
            this.connStatusLabel = new Label("Status: " + string);
            this.connStatusLabel.setFont(new Font("Helvetica", 0, 12));
        } else {
            this.connStatusLabel.setText("Status: " + string);
        }
        if (!this.vncContainer.isAncestorOf(this.connStatusLabel)) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(20, 30, 20, 30);
            this.gridbag.setConstraints(this.connStatusLabel, gridBagConstraints);
            this.vncContainer.add(this.connStatusLabel);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    void showAuthPanel(Panel panel) {
        this.showConnectionStatus(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 50;
        this.gridbag.setConstraints(panel, gridBagConstraints);
        this.vncContainer.add(panel);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
        this.showConnectionStatus(null);
    }

    void setEncodings() {
        block3: {
            try {
                if (this.rfb == null || !this.rfb.inNormalProtocol) break block3;
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    return true;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[this.options.cursorUpdatesIndex].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[this.options.eightBitColorsIndex].getSelectedItem();
                this.options.choices[this.options.cursorUpdatesIndex].select("Disable");
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select("No");
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[this.options.cursorUpdatesIndex].select(this.cursorUpdatesDef);
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select(this.eightBitColorsDef);
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.showControls = true;
        string = this.readParameter("Show Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.offerRelogin = true;
        string = this.readParameter("Offer Relogin", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.offerRelogin = false;
        }
        this.showOfflineDesktop = false;
        string = this.readParameter("Show Offline Desktop", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
        this.socketFactory = this.readParameter("SocketFactory", false);
        this.disableSSL = false;
        string = this.readParameter("DisableSSL", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.disableSSL = true;
        }
        this.CONNECT = this.readParameter("CONNECT", false);
        if (this.CONNECT != null) {
            this.CONNECT = this.CONNECT.replaceAll(" ", ":");
        }
        this.GET = this.readParameter("GET", false);
        this.urlPrefix = "";
        if (this.GET != null) {
            this.GET = this.GET.replaceAll("%2F", "/");
            this.GET = this.GET.replaceAll("%2f", "/");
            this.GET = this.GET.replaceAll("_2F_", "/");
            if (!this.GET.equals("1")) {
                if (this.GET.indexOf("/") != 0) {
                    this.urlPrefix = this.urlPrefix + "/";
                }
                this.urlPrefix = this.urlPrefix + this.GET;
            }
        }
        this.urlPrefix = this.urlPrefix.replaceAll("%2f", "/");
        System.out.println("urlPrefix: " + this.urlPrefix);
        this.forceProxy = false;
        string = this.readParameter("forceProxy", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.forceProxy = true;
        }
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(string + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(string + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(string + " parameter not specified");
        }
        return null;
    }

    int readIntParameter(String string, int n) {
        int n2;
        block2: {
            String string2 = this.readParameter(string, false);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            } else if (this.vncContainer.isAncestorOf(this.authenticator)) {
                this.authenticator.moveFocusToDefaultField();
            } else if (this.vncContainer.isAncestorOf(this.authenticatorUnixLogin)) {
                this.authenticatorUnixLogin.moveFocusToDefaultField();
            }
        }
    }

    public synchronized void disconnect() {
        System.out.println("Disconnect");
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.showMessage("Disconnected");
        } else {
            System.exit(0);
        }
    }

    public synchronized void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public synchronized void fatalError(String string, Exception exception) {
        if (this.rfb != null && this.rfb.closed()) {
            System.out.println("RFB thread finished");
            return;
        }
        System.out.println(string);
        exception.printStackTrace();
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inAnApplet) {
            this.showMessage(string);
        } else {
            System.exit(1);
        }
    }

    void showMessage(String string) {
        this.vncContainer.removeAll();
        Label label = new Label(string, 1);
        label.setFont(new Font("Helvetica", 0, 12));
        if (this.offerRelogin) {
            Panel panel = new Panel(new GridLayout(0, 1));
            Panel panel2 = new Panel(new FlowLayout(0));
            panel2.add(panel);
            this.vncContainer.setLayout(new FlowLayout(0, 30, 16));
            this.vncContainer.add(panel2);
            Panel panel3 = new Panel(new FlowLayout(1));
            panel3.add(label);
            panel.add(panel3);
            panel.add(new ReloginPanel(this));
        } else {
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    public void stop() {
        System.out.println("Stopping applet");
        this.rfbThread = null;
    }

    public void destroy() {
        System.out.println("Destroying applet");
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public void enableInput(boolean bl) {
        this.vc.enableInput(bl);
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Closing window");
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncContainer.hide();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.vncFrame.isAncestorOf(this.authenticator)) {
            this.authenticator.moveFocusToDefaultField();
        } else if (this.vncContainer.isAncestorOf(this.authenticatorUnixLogin)) {
            this.authenticatorUnixLogin.moveFocusToDefaultField();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

