/* Copyright (C) 1996 Bjoern Beutel. */

/* Description. =============================================================*/

/* Invoke the display process from Malaga. */

/* Includes. ================================================================*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <setjmp.h>
#include <glib.h>
#include "basic.h"
#include "files.h"
#include "input.h"
#include "commands.h"
#include "processes.h"
#include "display.h"

/* Global variables. ========================================================*/

FILE *display_stream; /* Stream to send data to the display process. */

/* Variables. ===============================================================*/

static process_t display_process;

/* Functions. ===============================================================*/

void 
stop_display_process( void )
/* Stop the Malaga display process. */
{ 
  stop_process( &display_process );
  display_stream = NULL;
}

/*---------------------------------------------------------------------------*/

void 
start_display_process( void )
/* Start the Malaga display process by executing DISPLAY_COMMAND_LINE
 * if it is not already running. */
{ 
  display_process.use_input = FALSE;
  display_process.use_output = TRUE;
  display_process.name = "display process";
  if (display_process.command_line == NULL) 
    display_process.command_line = new_string( "malshow", NULL );
  start_process( &display_process );
  display_stream = display_process.output_stream;
}

/*---------------------------------------------------------------------------*/

static void 
do_display_line_option( string_t arguments )
/* Set the command line to start the display process. */
{ 
  if (*arguments == EOS) 
  { 
    printf( "display-line: \"%s\"\n", (display_process.command_line == NULL ?
				       "" : display_process.command_line) );
  } 
  else 
  { 
    stop_display_process();
    display_process.command_line = parse_word( &arguments );
  }
  parse_end( &arguments );
}

command_t display_line_option = 
{ 
  "display-line display", do_display_line_option,
  "Usage: set display-line \"DISPLAY_COMMAND_LINE\"\n"
  "Set the command line that is used to start the display process.\n"
};

/* End of file. =============================================================*/
