/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_LOAD_CONST_RAM},
	{707, PKT3_WRITE_CONST_RAM},
	{723, PKT3_DUMP_CONST_RAM},
	{738, PKT3_INCREMENT_CE_COUNTER},
	{759, PKT3_INCREMENT_DE_COUNTER},
	{780, PKT3_WAIT_ON_CE_COUNTER},
	{799, PKT3_IT_OPCODE_C},
	{811, PKT3_CP_DMA},
	{818, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{827, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{849, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{877, S_370_ENGINE_SEL(~0u), 4, 0},
	{888, S_370_WR_CONFIRM(~0u)},
	{899, S_370_WR_ONE_ADDR(~0u)},
	{972, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{980, S_3F2_IB_SIZE(~0u)},
	{988, S_3F2_CHAIN(~0u)},
	{994, S_3F2_VALID(~0u)},
	/* 9 */
	{1000, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{1012, S_411_CP_SYNC(~0u)},
	{1044, S_411_SRC_SEL(~0u), 4, 10},
	{1052, S_411_ENGINE(~0u), 2, 0},
	{1091, S_411_DSL_SEL(~0u), 4, 14},
	{1099, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{1111, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{1123, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{1135, S_414_BYTE_COUNT_GFX6(~0u)},
	{1151, S_414_BYTE_COUNT_GFX9(~0u)},
	{1167, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{1220, S_414_SRC_SWAP(~0u), 4, 18},
	{1229, S_414_DST_SWAP(~0u), 4, 18},
	{1245, S_414_SAS(~0u), 2, 22},
	{1249, S_414_DAS(~0u), 2, 22},
	{1276, S_414_SAIC(~0u), 2, 24},
	{1281, S_414_DAIC(~0u), 2, 24},
	{1286, S_414_RAW_WAIT(~0u)},
	{1295, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{1012, S_500_CP_SYNC(~0u)},
	{1044, S_500_SRC_SEL(~0u), 4, 10},
	{1091, S_500_DSL_SEL(~0u), 4, 14},
	{1052, S_500_ENGINE(~0u), 2, 0},
	/* 32 */
	{1319, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1335, S_000E4C_TST_RQ_PENDING(~0u)},
	{1350, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1367, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1383, S_000E4C_VP8_BUSY(~0u)},
	{1392, S_000E4C_SDMA_BUSY(~0u)},
	{1402, S_000E4C_SDMA1_BUSY(~0u)},
	{1413, S_000E4C_VCE0_BUSY(~0u)},
	{1423, S_000E4C_XDMA_BUSY(~0u)},
	{1433, S_000E4C_CHUB_BUSY(~0u)},
	{1443, S_000E4C_SDMA2_BUSY(~0u)},
	{1454, S_000E4C_SDMA3_BUSY(~0u)},
	{1465, S_000E4C_SAMSCP_BUSY(~0u)},
	{1477, S_000E4C_ISP_BUSY(~0u)},
	{1486, S_000E4C_VCE1_BUSY(~0u)},
	{1496, S_000E4C_ODE_BUSY(~0u)},
	{1505, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1522, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1539, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1557, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1572, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 53 */
	{1588, S_000E50_UVD_RQ_PENDING(~0u)},
	{1603, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1621, S_000E50_ACP_RQ_PENDING(~0u)},
	{1636, S_000E50_SMU_RQ_PENDING(~0u)},
	{1651, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1667, S_000E50_HI_RQ_PENDING(~0u)},
	{1681, S_000E50_VMC_BUSY(~0u)},
	{1690, S_000E50_MCB_BUSY(~0u)},
	{1699, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1720, S_000E50_MCC_BUSY(~0u)},
	{1729, S_000E50_MCD_BUSY(~0u)},
	{1738, S_000E50_VMC1_BUSY(~0u)},
	{1748, S_000E50_SEM_BUSY(~0u)},
	{1757, S_000E50_ACP_BUSY(~0u)},
	{1766, S_000E50_IH_BUSY(~0u)},
	{1774, S_000E50_UVD_BUSY(~0u)},
	{1783, S_000E50_SAMMSP_BUSY(~0u)},
	{1795, S_000E50_GCATCL2_BUSY(~0u)},
	{1808, S_000E50_OSATCL2_BUSY(~0u)},
	{1821, S_000E50_BIF_BUSY(~0u)},
	/* 73 */
	{1830, S_000E54_MCC0_BUSY(~0u)},
	{1840, S_000E54_MCC1_BUSY(~0u)},
	{1850, S_000E54_MCC2_BUSY(~0u)},
	{1860, S_000E54_MCC3_BUSY(~0u)},
	{1870, S_000E54_MCC4_BUSY(~0u)},
	{1880, S_000E54_MCC5_BUSY(~0u)},
	{1890, S_000E54_MCC6_BUSY(~0u)},
	{1900, S_000E54_MCC7_BUSY(~0u)},
	{1910, S_000E54_MCD0_BUSY(~0u)},
	{1920, S_000E54_MCD1_BUSY(~0u)},
	{1930, S_000E54_MCD2_BUSY(~0u)},
	{1940, S_000E54_MCD3_BUSY(~0u)},
	{1950, S_000E54_MCD4_BUSY(~0u)},
	{1960, S_000E54_MCD5_BUSY(~0u)},
	{1970, S_000E54_MCD6_BUSY(~0u)},
	{1980, S_000E54_MCD7_BUSY(~0u)},
	/* 89 */
	{1990, S_00D034_IDLE(~0u)},
	{1995, S_00D034_REG_IDLE(~0u)},
	{2004, S_00D034_RB_EMPTY(~0u)},
	{2013, S_00D034_RB_FULL(~0u)},
	{2021, S_00D034_RB_CMD_IDLE(~0u)},
	{2033, S_00D034_RB_CMD_FULL(~0u)},
	{2045, S_00D034_IB_CMD_IDLE(~0u)},
	{2057, S_00D034_IB_CMD_FULL(~0u)},
	{2069, S_00D034_BLOCK_IDLE(~0u)},
	{2080, S_00D034_INSIDE_IB(~0u)},
	{2090, S_00D034_EX_IDLE(~0u)},
	{2098, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2124, S_00D034_PACKET_READY(~0u)},
	{2137, S_00D034_MC_WR_IDLE(~0u)},
	{2148, S_00D034_SRBM_IDLE(~0u)},
	{2158, S_00D034_CONTEXT_EMPTY(~0u)},
	{2172, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2188, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2204, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2220, S_00D034_MC_RD_IDLE(~0u)},
	{2231, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2248, S_00D034_MC_RD_RET_STALL(~0u)},
	{2264, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2283, S_00D034_PREV_CMD_IDLE(~0u)},
	{2297, S_00D034_SEM_IDLE(~0u)},
	{2306, S_00D034_SEM_REQ_STALL(~0u)},
	{2320, S_00D034_SEM_RESP_STATE(~0u)},
	{2335, S_00D034_INT_IDLE(~0u)},
	{2344, S_00D034_INT_REQ_STALL(~0u)},
	/* 118 */
	{2358, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2381, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2404, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2427, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2447, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2467, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2487, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2507, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2527, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2547, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2567, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2587, S_008008_RLC_RQ_PENDING(~0u)},
	{2602, S_008008_RLC_BUSY(~0u)},
	{2611, S_008008_TC_BUSY(~0u)},
	{2619, S_008008_TCC_CC_RESIDENT(~0u)},
	{2635, S_008008_CPF_BUSY(~0u)},
	{2644, S_008008_CPC_BUSY(~0u)},
	{2653, S_008008_CPG_BUSY(~0u)},
	{2662, S_008008_UTCL2_BUSY(~0u)},
	{2673, S_008008_EA_BUSY(~0u)},
	{2681, S_008008_RMI_BUSY(~0u)},
	{2690, S_008008_UTCL2_RQ_PENDING(~0u)},
	{2707, S_008008_CPF_RQ_PENDING(~0u)},
	{2722, S_008008_EA_LINK_BUSY(~0u)},
	{2735, S_008008_CPAXI_BUSY(~0u)},
	/* 143 */
	{2746, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2769, S_008010_SRBM_RQ_PENDING(~0u)},
	{2785, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2808, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2831, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2850, S_008010_DB_CLEAN(~0u)},
	{2859, S_008010_CB_CLEAN(~0u)},
	{2868, S_008010_TA_BUSY(~0u)},
	{2876, S_008010_GDS_BUSY(~0u)},
	{2885, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2900, S_008010_VGT_BUSY(~0u)},
	{2909, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2924, S_008010_IA_BUSY(~0u)},
	{2932, S_008010_SX_BUSY(~0u)},
	{2940, S_008010_WD_BUSY(~0u)},
	{2948, S_008010_SPI_BUSY(~0u)},
	{2957, S_008010_BCI_BUSY(~0u)},
	{2966, S_008010_SC_BUSY(~0u)},
	{2974, S_008010_PA_BUSY(~0u)},
	{2982, S_008010_DB_BUSY(~0u)},
	{2990, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1469, S_008010_CP_BUSY(~0u)},
	{1691, S_008010_CB_BUSY(~0u)},
	{3008, S_008010_GUI_ACTIVE(~0u)},
	{3019, S_008010_RSMU_RQ_PENDING(~0u)},
	/* 168 */
	{3035, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 169 */
	{3054, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{3070, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{3086, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{3104, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{3122, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{3140, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{3158, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{3176, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{3194, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{3212, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3230, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3247, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3263, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3279, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3295, S_0085F0_TC_ACTION_ENA(~0u)},
	{3309, S_0085F0_CB_ACTION_ENA(~0u)},
	{3323, S_0085F0_DB_ACTION_ENA(~0u)},
	{3337, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3358, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 188 */
	{2850, S_008014_DB_CLEAN(~0u)},
	{2859, S_008014_CB_CLEAN(~0u)},
	{2957, S_008014_BCI_BUSY(~0u)},
	{2900, S_008014_VGT_BUSY(~0u)},
	{2974, S_008014_PA_BUSY(~0u)},
	{2868, S_008014_TA_BUSY(~0u)},
	{2932, S_008014_SX_BUSY(~0u)},
	{2948, S_008014_SPI_BUSY(~0u)},
	{2966, S_008014_SC_BUSY(~0u)},
	{2982, S_008014_DB_BUSY(~0u)},
	{1691, S_008014_CB_BUSY(~0u)},
	{2681, S_008014_RMI_BUSY(~0u)},
	/* 200 */
	{2850, S_008018_DB_CLEAN(~0u)},
	{2859, S_008018_CB_CLEAN(~0u)},
	{2957, S_008018_BCI_BUSY(~0u)},
	{2900, S_008018_VGT_BUSY(~0u)},
	{2974, S_008018_PA_BUSY(~0u)},
	{2868, S_008018_TA_BUSY(~0u)},
	{2932, S_008018_SX_BUSY(~0u)},
	{2948, S_008018_SPI_BUSY(~0u)},
	{2966, S_008018_SC_BUSY(~0u)},
	{2982, S_008018_DB_BUSY(~0u)},
	{1691, S_008018_CB_BUSY(~0u)},
	{2681, S_008018_RMI_BUSY(~0u)},
	/* 212 */
	{2850, S_008038_DB_CLEAN(~0u)},
	{2859, S_008038_CB_CLEAN(~0u)},
	{2957, S_008038_BCI_BUSY(~0u)},
	{2900, S_008038_VGT_BUSY(~0u)},
	{2974, S_008038_PA_BUSY(~0u)},
	{2868, S_008038_TA_BUSY(~0u)},
	{2932, S_008038_SX_BUSY(~0u)},
	{2948, S_008038_SPI_BUSY(~0u)},
	{2966, S_008038_SC_BUSY(~0u)},
	{2982, S_008038_DB_BUSY(~0u)},
	{1691, S_008038_CB_BUSY(~0u)},
	{2681, S_008038_RMI_BUSY(~0u)},
	/* 224 */
	{2850, S_00803C_DB_CLEAN(~0u)},
	{2859, S_00803C_CB_CLEAN(~0u)},
	{2957, S_00803C_BCI_BUSY(~0u)},
	{2900, S_00803C_VGT_BUSY(~0u)},
	{2974, S_00803C_PA_BUSY(~0u)},
	{2868, S_00803C_TA_BUSY(~0u)},
	{2932, S_00803C_SX_BUSY(~0u)},
	{2948, S_00803C_SPI_BUSY(~0u)},
	{2966, S_00803C_SC_BUSY(~0u)},
	{2982, S_00803C_DB_BUSY(~0u)},
	{1691, S_00803C_CB_BUSY(~0u)},
	{2681, S_00803C_RMI_BUSY(~0u)},
	/* 236 */
	{3035, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 237 */
	{3379, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 238 */
	{3398, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 239 */
	{3054, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{3070, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3416, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3433, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{3086, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{3104, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{3122, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{3140, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{3158, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{3176, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{3194, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{3212, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3230, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3450, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3470, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3488, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3247, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3263, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3279, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3295, S_0301F0_TC_ACTION_ENA(~0u)},
	{3309, S_0301F0_CB_ACTION_ENA(~0u)},
	{3323, S_0301F0_DB_ACTION_ENA(~0u)},
	{3337, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3505, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3358, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3530, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3554, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	{3571, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{3588, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	/* 268 */
	{3615, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3633, S_0301FC_MEID(~0u)},
	{3638, S_0301FC_PHASE1_STATUS(~0u)},
	{3645, S_0301FC_STATUS(~0u)},
	/* 272 */
	{3652, S_008210_MEC1_BUSY(~0u)},
	{3662, S_008210_MEC2_BUSY(~0u)},
	{3672, S_008210_DC0_BUSY(~0u)},
	{3681, S_008210_DC1_BUSY(~0u)},
	{3690, S_008210_RCIU1_BUSY(~0u)},
	{3701, S_008210_RCIU2_BUSY(~0u)},
	{3712, S_008210_ROQ1_BUSY(~0u)},
	{3722, S_008210_ROQ2_BUSY(~0u)},
	{3732, S_008210_TCIU_BUSY(~0u)},
	{3742, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3759, S_008210_QU_BUSY(~0u)},
	{3767, S_008210_ATCL2IU_BUSY(~0u)},
	{3780, S_008210_CPG_CPC_BUSY(~0u)},
	{3793, S_008210_CPF_CPC_BUSY(~0u)},
	{2644, S_008210_CPC_BUSY(~0u)},
	{3806, S_008210_UTCL2IU_BUSY(~0u)},
	{3819, S_008210_SAVE_RESTORE_BUSY(~0u)},
	/* 289 */
	{3837, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3852, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3872, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3888, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3906, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3926, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3945, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3964, S_008214_MEC1_TC_BUSY(~0u)},
	{3977, S_008214_MEC1_DMA_BUSY(~0u)},
	{3991, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{4015, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{4031, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{4047, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{4063, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{4079, S_008214_MEC2_LOAD_BUSY(~0u)},
	{4094, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{4114, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{4130, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{4148, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{4168, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{4187, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{4206, S_008214_MEC2_TC_BUSY(~0u)},
	{4219, S_008214_MEC2_DMA_BUSY(~0u)},
	{4233, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{4257, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{4273, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{4289, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4305, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 317 */
	{4321, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4340, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4360, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4379, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4400, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4418, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4441, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4463, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4484, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4502, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4525, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4547, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4571, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4595, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	{4618, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4642, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{4666, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 334 */
	{4689, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4708, S_00821C_CSF_BUSY(~0u)},
	{4717, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4732, S_00821C_ROQ_RING_BUSY(~0u)},
	{4746, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4765, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4784, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4799, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4816, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4838, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4860, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4875, S_00821C_INTERRUPT_BUSY(~0u)},
	{3732, S_00821C_TCIU_BUSY(~0u)},
	{4890, S_00821C_HQD_BUSY(~0u)},
	{4899, S_00821C_PRT_BUSY(~0u)},
	{3767, S_00821C_ATCL2IU_BUSY(~0u)},
	{4908, S_00821C_CPF_GFX_BUSY(~0u)},
	{4921, S_00821C_CPF_CMP_BUSY(~0u)},
	{4934, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4953, S_00821C_CPC_CPF_BUSY(~0u)},
	{2635, S_00821C_CPF_BUSY(~0u)},
	{3806, S_00821C_UTCL2IU_BUSY(~0u)},
	/* 356 */
	{4966, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4984, S_008220_CSF_RING_BUSY(~0u)},
	{4998, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{5017, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{5036, S_008220_CSF_STATE_BUSY(~0u)},
	{5051, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{5069, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{5087, S_008220_CSF_ARBITER_BUSY(~0u)},
	{5104, S_008220_CSF_INPUT_BUSY(~0u)},
	{5119, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{5141, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{5165, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{5183, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{5201, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{5222, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{5246, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{5272, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{5289, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{5309, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{5329, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{5349, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5370, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5393, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5414, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5433, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5450, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5466, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5482, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5498, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5517, S_008220_HQD_PQ_BUSY(~0u)},
	{5529, S_008220_HQD_IB_BUSY(~0u)},
	/* 387 */
	{5541, S_008224_RING_FETCHING_DATA(~0u)},
	{5560, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5580, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5600, S_008224_STATE_FETCHING_DATA(~0u)},
	{5620, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5641, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4547, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4571, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4595, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	{4618, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4642, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{5662, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{5689, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{5716, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 401 */
	{5737, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 402 */
	{5756, S_0088B0_PRIM_COUNT(~0u)},
	/* 403 */
	{5767, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5786, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5807, S_0088C4_ES_LIMIT(~0u)},
	/* 406 */
	{5816, S_0088D4_VERT_REUSE(~0u)},
	/* 407 */
	{6343, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 408 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 409 */
	{38, S_008988_SIZE(~0u)},
	/* 410 */
	{6395, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 411 */
	{6413, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{6434, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6447, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6470, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 415 */
	{6490, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 416 */
	{6509, S_008B10_CURRENT_PTR(~0u)},
	{6521, S_008B10_CURRENT_COUNT(~0u)},
	/* 418 */
	{6535, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6560, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6598, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6639, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6662, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6685, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6709, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6739, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6768, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6794, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6823, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6848, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5620, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5641, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6883, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6911, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4547, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4571, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4595, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	{4618, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4642, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{4666, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 440 */
	{6941, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6968, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6995, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{7024, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{7053, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{7082, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7110, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7140, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{7167, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{7195, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{7220, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{7246, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{7271, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{7295, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{7320, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{7348, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 456 */
	{7377, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{7403, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{7429, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7456, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7482, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7504, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7531, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7553, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7577, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7602, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7625, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7652, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7677, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7705, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7730, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7755, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7780, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7809, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7840, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7868, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7895, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7925, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7952, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7979, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{8006, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{8032, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{8056, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{8088, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{8115, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 485 */
	{4732, S_008680_ROQ_RING_BUSY(~0u)},
	{4746, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4765, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4784, S_008680_ROQ_STATE_BUSY(~0u)},
	{8141, S_008680_DC_BUSY(~0u)},
	{3767, S_008680_ATCL2IU_BUSY(~0u)},
	{8149, S_008680_PFP_BUSY(~0u)},
	{8158, S_008680_MEQ_BUSY(~0u)},
	{8167, S_008680_ME_BUSY(~0u)},
	{8175, S_008680_QUERY_BUSY(~0u)},
	{4860, S_008680_SEMAPHORE_BUSY(~0u)},
	{4875, S_008680_INTERRUPT_BUSY(~0u)},
	{8186, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1393, S_008680_DMA_BUSY(~0u)},
	{8204, S_008680_RCIU_BUSY(~0u)},
	{3742, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{8214, S_008680_CPC_CPG_BUSY(~0u)},
	{8227, S_008680_CE_BUSY(~0u)},
	{3732, S_008680_TCIU_BUSY(~0u)},
	{4799, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4816, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4838, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1469, S_008680_CP_BUSY(~0u)},
	{3806, S_008680_UTCL2IU_BUSY(~0u)},
	/* 509 */
	{8235, S_030800_INSTANCE_INDEX(~0u)},
	{8250, S_030800_SH_INDEX(~0u)},
	{8259, S_030800_SE_INDEX(~0u)},
	{8268, S_030800_SH_BROADCAST_WRITES(~0u)},
	{8288, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{8314, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 515 */
	{6343, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 516 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{8334, S_03090C_PRIMGEN_EN(~0u)},
	/* 518 */
	{38, S_030938_SIZE(~0u)},
	/* 519 */
	{6395, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{8393, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 521 */
	{6490, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 522 */
	{6509, S_030A04_CURRENT_PTR(~0u)},
	{6521, S_030A04_CURRENT_COUNT(~0u)},
	/* 524 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 526 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 528 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 530 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 532 */
	{8413, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{8439, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8462, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8487, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8518, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8552, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8572, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8599, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8627, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 541 */
	{8662, S_008C08_INST_INVALIDATE(~0u)},
	{8678, S_008C08_DATA_INVALIDATE(~0u)},
	/* 543 */
	{8662, S_030D20_INST_INVALIDATE(~0u)},
	{8678, S_030D20_DATA_INVALIDATE(~0u)},
	{8694, S_030D20_INVALIDATE_VOLATILE(~0u)},
	{8714, S_030D20_TARGET_INST(~0u)},
	{8726, S_030D20_TARGET_DATA(~0u)},
	{8667, S_030D20_INVALIDATE(~0u)},
	{8738, S_030D20_WRITEBACK(~0u)},
	{8748, S_030D20_VOL(~0u)},
	{8752, S_030D20_COMPLETE(~0u)},
	/* 552 */
	{8761, S_008C0C_RET(~0u)},
	{8765, S_008C0C_RUI(~0u)},
	{8769, S_008C0C_RNG(~0u)},
	/* 555 */
	{8342, S_008DFC_EN(~0u)},
	{8832, S_008DFC_TGT(~0u), 33, 90},
	{8836, S_008DFC_COMPR(~0u)},
	{3049, S_008DFC_DONE(~0u)},
	{8842, S_008DFC_VM(~0u)},
	{8862, S_008DFC_ENCODING(~0u), 63, 123},
	/* 561 */
	{8871, S_030E04_ADDRESS(~0u)},
	/* 562 */
	{8879, S_030F04_COUNT_HI(~0u)},
	/* 563 */
	{8888, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8904, S_008F04_STRIDE(~0u)},
	{8911, S_008F04_CACHE_SWIZZLE(~0u)},
	{8925, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 567 */
	{8879, S_030F0C_COUNT_HI(~0u)},
	/* 568 */
	{9030, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{9040, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{9050, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{9060, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{9244, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{9636, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{9648, S_008F0C_ELEMENT_SIZE(~0u)},
	{9661, S_008F0C_INDEX_STRIDE(~0u)},
	{9674, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9689, S_008F0C_ATC(~0u)},
	{9693, S_008F0C_HASH_ENABLE(~0u)},
	{9705, S_008F0C_HEAP(~0u)},
	{9710, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	{9785, S_008F0C_USER_VM_ENABLE(~0u)},
	{9800, S_008F0C_USER_VM_MODE(~0u)},
	{9813, S_008F0C_NV(~0u)},
	/* 585 */
	{8879, S_030F14_COUNT_HI(~0u)},
	/* 586 */
	{8888, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9816, S_008F14_MIN_LOD(~0u)},
	{11449, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{11833, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{9710, S_008F14_MTYPE(~0u)},
	{12421, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 302},
	{12514, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 366},
	{12749, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 377},
	{12999, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 390},
	{13198, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 404},
	{9813, S_008F14_NV(~0u)},
	{13217, S_008F14_META_DIRECT(~0u)},
	/* 598 */
	{13229, S_008F18_WIDTH(~0u)},
	{13235, S_008F18_HEIGHT(~0u)},
	{13242, S_008F18_PERF_MOD(~0u)},
	{13251, S_008F18_INTERLACED(~0u)},
	/* 602 */
	{8879, S_030F1C_COUNT_HI(~0u)},
	/* 603 */
	{9030, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{9040, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{9050, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{9060, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{13262, S_008F1C_BASE_LEVEL(~0u)},
	{13273, S_008F1C_LAST_LEVEL(~0u)},
	{13284, S_008F1C_TILING_INDEX(~0u)},
	{13297, S_008F1C_POW2_PAD(~0u)},
	{9710, S_008F1C_MTYPE(~0u)},
	{9689, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 414},
	{13608, S_008F1C_SW_MODE(~0u)},
	/* 615 */
	{13616, S_008F20_DEPTH(~0u)},
	{13622, S_008F20_PITCH_GFX6(~0u)},
	{13633, S_008F20_PITCH_GFX9(~0u)},
	{13740, S_008F20_BC_SWIZZLE(~0u), 6, 430},
	/* 619 */
	{13751, S_008F24_BASE_ARRAY(~0u)},
	{13762, S_008F24_LAST_ARRAY(~0u)},
	{13773, S_008F24_ARRAY_PITCH(~0u)},
	{13785, S_008F24_META_DATA_ADDRESS(~0u)},
	{13803, S_008F24_META_LINEAR(~0u)},
	{13815, S_008F24_META_PIPE_ALIGNED(~0u)},
	{13833, S_008F24_META_RB_ALIGNED(~0u)},
	{13849, S_008F24_MAX_MIP(~0u)},
	/* 627 */
	{13857, S_008F28_MIN_LOD_WARN(~0u)},
	{13870, S_008F28_COUNTER_BANK_ID(~0u)},
	{13886, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{13901, S_008F28_COMPRESSION_EN(~0u)},
	{13916, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{13932, S_008F28_COLOR_TRANSFORM(~0u)},
	{13948, S_008F28_LOST_ALPHA_BITS(~0u)},
	{13964, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 635 */
	{14162, S_008F30_CLAMP_X(~0u), 8, 436},
	{14170, S_008F30_CLAMP_Y(~0u), 8, 436},
	{14178, S_008F30_CLAMP_Z(~0u), 8, 436},
	{14186, S_008F30_MAX_ANISO_RATIO(~0u)},
	{14434, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 444},
	{14453, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{14472, S_008F30_ANISO_THRESHOLD(~0u)},
	{14488, S_008F30_MC_COORD_TRUNC(~0u)},
	{14503, S_008F30_FORCE_DEGAMMA(~0u)},
	{14517, S_008F30_ANISO_BIAS(~0u)},
	{14528, S_008F30_TRUNC_COORD(~0u)},
	{14540, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{14558, S_008F30_FILTER_MODE(~0u)},
	{14570, S_008F30_COMPAT_MODE(~0u)},
	/* 649 */
	{9816, S_008F34_MIN_LOD(~0u)},
	{14582, S_008F34_MAX_LOD(~0u)},
	{14590, S_008F34_PERF_MIP(~0u)},
	{14599, S_008F34_PERF_Z(~0u)},
	/* 653 */
	{14606, S_008F38_LOD_BIAS(~0u)},
	{14615, S_008F38_LOD_BIAS_SEC(~0u)},
	{14677, S_008F38_XY_MAG_FILTER(~0u), 2, 452},
	{14752, S_008F38_XY_MIN_FILTER(~0u), 4, 454},
	{14832, S_008F38_Z_FILTER(~0u), 3, 458},
	{14841, S_008F38_MIP_FILTER(~0u), 3, 458},
	{14852, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{14871, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{14888, S_008F38_FILTER_PREC_FIX(~0u)},
	{14904, S_008F38_ANISO_OVERRIDE(~0u)},
	{14919, S_008F38_BLEND_ZERO_PRT(~0u)},
	/* 664 */
	{14934, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{15078, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 461},
	{15096, S_008F3C_SKIP_DEGAMMA(~0u)},
	/* 667 */
	{15109, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{15126, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{15143, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{15160, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{15177, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 672 */
	{15194, S_0090E0_PS_CU_EN(~0u)},
	{15203, S_0090E0_VS_CU_EN(~0u)},
	/* 674 */
	{15212, S_0090E4_GS_CU_EN(~0u)},
	{15221, S_0090E4_ES_CU_EN(~0u)},
	/* 676 */
	{15230, S_0090E8_LSHS_CU_EN(~0u)},
	/* 677 */
	{15241, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 678 */
	{15241, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 679 */
	{15258, S_0090F0_RING_ORDER_TS0(~0u), 1, 465},
	{15273, S_0090F0_RING_ORDER_TS1(~0u)},
	{15288, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 682 */
	{15303, S_00C700_PIPE_ORDER_TS0(~0u)},
	{15318, S_00C700_PIPE_ORDER_TS1(~0u)},
	{15333, S_00C700_PIPE_ORDER_TS2(~0u)},
	{15348, S_00C700_PIPE_ORDER_TS3(~0u)},
	{15363, S_00C700_TS0_DUR_MULT(~0u)},
	{15376, S_00C700_TS1_DUR_MULT(~0u)},
	{15389, S_00C700_TS2_DUR_MULT(~0u)},
	{15402, S_00C700_TS3_DUR_MULT(~0u)},
	/* 690 */
	{15415, S_0090F4_TS0_DURATION(~0u)},
	{15428, S_0090F4_TS1_DURATION(~0u)},
	/* 692 */
	{15441, S_0090F8_TS2_DURATION(~0u)},
	/* 693 */
	{38, S_008F40_SIZE(~0u)},
	/* 694 */
	{669, S_008F44_OFFSET(~0u)},
	/* 695 */
	{8879, S_030FFC_COUNT_HI(~0u)},
	/* 696 */
	{15454, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{15473, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{15492, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{15514, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{15536, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 701 */
	{15805, S_00913C_VTX_DONE_DELAY(~0u), 16, 466},
	{15820, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{15844, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{15860, S_00913C_PC_LIMIT_STRICT(~0u)},
	{15876, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 706 */
	{15890, S_00936C_TYPE_A(~0u)},
	{15897, S_00936C_VGPR_A(~0u)},
	{15904, S_00936C_SGPR_A(~0u)},
	{15911, S_00936C_LDS_A(~0u)},
	{15917, S_00936C_WAVES_A(~0u)},
	{15925, S_00936C_EN_A(~0u)},
	{15930, S_00936C_TYPE_B(~0u)},
	{15937, S_00936C_VGPR_B(~0u)},
	{15944, S_00936C_SGPR_B(~0u)},
	{15951, S_00936C_LDS_B(~0u)},
	{15957, S_00936C_WAVES_B(~0u)},
	{15965, S_00936C_EN_B(~0u)},
	/* 718 */
	{15970, S_009858_MSAA1_X(~0u)},
	{15978, S_009858_MSAA1_Y(~0u)},
	{15986, S_009858_MSAA2_X(~0u)},
	{15994, S_009858_MSAA2_Y(~0u)},
	{16002, S_009858_MSAA4_X(~0u)},
	{16010, S_009858_MSAA4_Y(~0u)},
	{16018, S_009858_MSAA8_X(~0u)},
	{16026, S_009858_MSAA8_Y(~0u)},
	{16034, S_009858_MSAA16_X(~0u)},
	{16043, S_009858_MSAA16_Y(~0u)},
	/* 728 */
	{16052, S_0098F8_NUM_PIPES(~0u)},
	{16062, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{16088, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{16109, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{16133, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{16157, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{16171, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{16191, S_0098F8_ROW_SIZE(~0u)},
	{16200, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{16216, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{16242, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{16263, S_0098F8_NUM_BANKS(~0u)},
	{16273, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{16297, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{16311, S_0098F8_NUM_RB_PER_SE(~0u)},
	{16325, S_0098F8_SE_ENABLE(~0u)},
	/* 744 */
	{16452, S_009910_MICRO_TILE_MODE(~0u), 4, 482},
	{16697, S_009910_ARRAY_MODE(~0u), 16, 486},
	{17059, S_009910_PIPE_CONFIG(~0u), 15, 502},
	{17249, S_009910_TILE_SPLIT(~0u), 7, 517},
	{17352, S_009910_BANK_WIDTH(~0u), 4, 524},
	{17459, S_009910_BANK_HEIGHT(~0u), 4, 528},
	{17571, S_009910_MACRO_TILE_ASPECT(~0u), 4, 532},
	{16263, S_009910_NUM_BANKS(~0u), 4, 536},
	{17689, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 540},
	{17709, S_009910_SAMPLE_SPLIT(~0u)},
	/* 754 */
	{17352, S_009990_BANK_WIDTH(~0u)},
	{17459, S_009990_BANK_HEIGHT(~0u)},
	{17571, S_009990_MACRO_TILE_ASPECT(~0u)},
	{16263, S_009990_NUM_BANKS(~0u)},
	/* 758 */
	{17722, S_00B004_MEM_BASE(~0u)},
	/* 759 */
	{17722, S_00B00C_MEM_BASE(~0u)},
	/* 760 */
	{15197, S_00B01C_CU_EN(~0u)},
	{17731, S_00B01C_WAVE_LIMIT(~0u)},
	{17742, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{17761, S_00B01C_SIMD_DISABLE(~0u)},
	/* 764 */
	{17722, S_00B024_MEM_BASE(~0u)},
	/* 765 */
	{17774, S_00B028_VGPRS(~0u)},
	{17780, S_00B028_SGPRS(~0u)},
	{15464, S_00B028_PRIORITY(~0u)},
	{17829, S_00B028_FLOAT_MODE(~0u), 241, 544},
	{17840, S_00B028_PRIV(~0u)},
	{17845, S_00B028_DX10_CLAMP(~0u)},
	{17856, S_00B028_DEBUG_MODE(~0u)},
	{17867, S_00B028_IEEE_MODE(~0u)},
	{17877, S_00B028_CU_GROUP_DISABLE(~0u)},
	{17894, S_00B028_CACHE_CTL(~0u)},
	{17904, S_00B028_CDBG_USER(~0u)},
	{17914, S_00B028_FP16_OVFL(~0u)},
	/* 777 */
	{17924, S_00B02C_SCRATCH_EN(~0u)},
	{17935, S_00B02C_USER_SGPR(~0u)},
	{17945, S_00B02C_TRAP_PRESENT(~0u)},
	{17958, S_00B02C_WAVE_CNT_EN(~0u)},
	{17970, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{17985, S_00B02C_EXCP_EN_SI(~0u)},
	{17996, S_00B02C_EXCP_EN(~0u)},
	{18004, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{18026, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{18051, S_00B02C_SKIP_USGPR0(~0u)},
	{18063, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 788 */
	{17722, S_00B104_MEM_BASE(~0u)},
	/* 789 */
	{17722, S_00B10C_MEM_BASE(~0u)},
	/* 790 */
	{15197, S_00B118_CU_EN(~0u)},
	{17731, S_00B118_WAVE_LIMIT(~0u)},
	{17742, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{17761, S_00B118_SIMD_DISABLE(~0u)},
	/* 794 */
	{5810, S_00B11C_LIMIT(~0u)},
	/* 795 */
	{17722, S_00B124_MEM_BASE(~0u)},
	/* 796 */
	{17774, S_00B128_VGPRS(~0u)},
	{17780, S_00B128_SGPRS(~0u)},
	{15464, S_00B128_PRIORITY(~0u)},
	{17829, S_00B128_FLOAT_MODE(~0u)},
	{17840, S_00B128_PRIV(~0u)},
	{17845, S_00B128_DX10_CLAMP(~0u)},
	{17856, S_00B128_DEBUG_MODE(~0u)},
	{17867, S_00B128_IEEE_MODE(~0u)},
	{18077, S_00B128_VGPR_COMP_CNT(~0u)},
	{18091, S_00B128_CU_GROUP_ENABLE(~0u)},
	{17894, S_00B128_CACHE_CTL(~0u)},
	{17904, S_00B128_CDBG_USER(~0u)},
	{17914, S_00B128_FP16_OVFL(~0u)},
	/* 809 */
	{17924, S_00B12C_SCRATCH_EN(~0u)},
	{17935, S_00B12C_USER_SGPR(~0u)},
	{17945, S_00B12C_TRAP_PRESENT(~0u)},
	{18107, S_00B12C_OC_LDS_EN(~0u)},
	{18117, S_00B12C_SO_BASE0_EN(~0u)},
	{18129, S_00B12C_SO_BASE1_EN(~0u)},
	{18141, S_00B12C_SO_BASE2_EN(~0u)},
	{18153, S_00B12C_SO_BASE3_EN(~0u)},
	{18165, S_00B12C_SO_EN(~0u)},
	{17985, S_00B12C_EXCP_EN_SI(~0u)},
	{17996, S_00B12C_EXCP_EN(~0u)},
	{18171, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{18188, S_00B12C_PC_BASE_EN(~0u)},
	{18051, S_00B12C_SKIP_USGPR0(~0u)},
	{18063, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 824 */
	{17722, S_00B204_MEM_BASE(~0u)},
	/* 825 */
	{17722, S_00B20C_MEM_BASE(~0u)},
	/* 826 */
	{15197, S_00B21C_CU_EN(~0u)},
	{17731, S_00B21C_WAVE_LIMIT(~0u)},
	{17742, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{18199, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	{17761, S_00B21C_SIMD_DISABLE(~0u)},
	/* 831 */
	{17722, S_00B224_MEM_BASE(~0u)},
	/* 832 */
	{17774, S_00B228_VGPRS(~0u)},
	{17780, S_00B228_SGPRS(~0u)},
	{15464, S_00B228_PRIORITY(~0u)},
	{17829, S_00B228_FLOAT_MODE(~0u)},
	{17840, S_00B228_PRIV(~0u)},
	{17845, S_00B228_DX10_CLAMP(~0u)},
	{17856, S_00B228_DEBUG_MODE(~0u)},
	{17867, S_00B228_IEEE_MODE(~0u)},
	{18091, S_00B228_CU_GROUP_ENABLE(~0u)},
	{17894, S_00B228_CACHE_CTL(~0u)},
	{17904, S_00B228_CDBG_USER(~0u)},
	{18216, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{17914, S_00B228_FP16_OVFL(~0u)},
	/* 845 */
	{17924, S_00B22C_SCRATCH_EN(~0u)},
	{17935, S_00B22C_USER_SGPR(~0u)},
	{17945, S_00B22C_TRAP_PRESENT(~0u)},
	{17985, S_00B22C_EXCP_EN_SI(~0u)},
	{17996, S_00B22C_EXCP_EN(~0u)},
	{18233, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{18107, S_00B22C_OC_LDS_EN(~0u)},
	{17976, S_00B22C_LDS_SIZE(~0u)},
	{18051, S_00B22C_SKIP_USGPR0(~0u)},
	{18063, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 855 */
	{17722, S_00B304_MEM_BASE(~0u)},
	/* 856 */
	{17722, S_00B30C_MEM_BASE(~0u)},
	/* 857 */
	{15197, S_00B31C_CU_EN(~0u)},
	{17731, S_00B31C_WAVE_LIMIT(~0u)},
	{17742, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{18199, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 861 */
	{17722, S_00B324_MEM_BASE(~0u)},
	/* 862 */
	{17774, S_00B328_VGPRS(~0u)},
	{17780, S_00B328_SGPRS(~0u)},
	{15464, S_00B328_PRIORITY(~0u)},
	{17829, S_00B328_FLOAT_MODE(~0u)},
	{17840, S_00B328_PRIV(~0u)},
	{17845, S_00B328_DX10_CLAMP(~0u)},
	{17856, S_00B328_DEBUG_MODE(~0u)},
	{17867, S_00B328_IEEE_MODE(~0u)},
	{18077, S_00B328_VGPR_COMP_CNT(~0u)},
	{18091, S_00B328_CU_GROUP_ENABLE(~0u)},
	{17894, S_00B328_CACHE_CTL(~0u)},
	{17904, S_00B328_CDBG_USER(~0u)},
	/* 874 */
	{17924, S_00B32C_SCRATCH_EN(~0u)},
	{17935, S_00B32C_USER_SGPR(~0u)},
	{17945, S_00B32C_TRAP_PRESENT(~0u)},
	{18107, S_00B32C_OC_LDS_EN(~0u)},
	{17985, S_00B32C_EXCP_EN_SI(~0u)},
	{17996, S_00B32C_EXCP_EN(~0u)},
	{17976, S_00B32C_LDS_SIZE(~0u)},
	/* 881 */
	{17722, S_00B404_MEM_BASE(~0u)},
	/* 882 */
	{17722, S_00B40C_MEM_BASE(~0u)},
	/* 883 */
	{17731, S_00B41C_WAVE_LIMIT(~0u)},
	{17742, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{18199, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	{17761, S_00B41C_SIMD_DISABLE(~0u)},
	{15197, S_00B41C_CU_EN(~0u)},
	/* 888 */
	{17722, S_00B424_MEM_BASE(~0u)},
	/* 889 */
	{17774, S_00B428_VGPRS(~0u)},
	{17780, S_00B428_SGPRS(~0u)},
	{15464, S_00B428_PRIORITY(~0u)},
	{17829, S_00B428_FLOAT_MODE(~0u)},
	{17840, S_00B428_PRIV(~0u)},
	{17845, S_00B428_DX10_CLAMP(~0u)},
	{17856, S_00B428_DEBUG_MODE(~0u)},
	{17867, S_00B428_IEEE_MODE(~0u)},
	{17894, S_00B428_CACHE_CTL(~0u)},
	{17904, S_00B428_CDBG_USER(~0u)},
	{18250, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{17914, S_00B428_FP16_OVFL(~0u)},
	/* 901 */
	{17924, S_00B42C_SCRATCH_EN(~0u)},
	{17935, S_00B42C_USER_SGPR(~0u)},
	{17945, S_00B42C_TRAP_PRESENT(~0u)},
	{18107, S_00B42C_OC_LDS_EN(~0u)},
	{18267, S_00B42C_TG_SIZE_EN(~0u)},
	{17985, S_00B42C_EXCP_EN_SI(~0u)},
	{18278, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	{17996, S_00B42C_EXCP_EN(~0u)},
	{17976, S_00B42C_LDS_SIZE(~0u)},
	{18051, S_00B42C_SKIP_USGPR0(~0u)},
	{18063, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 912 */
	{17722, S_00B504_MEM_BASE(~0u)},
	/* 913 */
	{17722, S_00B50C_MEM_BASE(~0u)},
	/* 914 */
	{15197, S_00B51C_CU_EN(~0u)},
	{17731, S_00B51C_WAVE_LIMIT(~0u)},
	{17742, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{18199, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 918 */
	{17722, S_00B524_MEM_BASE(~0u)},
	/* 919 */
	{17774, S_00B528_VGPRS(~0u)},
	{17780, S_00B528_SGPRS(~0u)},
	{15464, S_00B528_PRIORITY(~0u)},
	{17829, S_00B528_FLOAT_MODE(~0u)},
	{17840, S_00B528_PRIV(~0u)},
	{17845, S_00B528_DX10_CLAMP(~0u)},
	{17856, S_00B528_DEBUG_MODE(~0u)},
	{17867, S_00B528_IEEE_MODE(~0u)},
	{18077, S_00B528_VGPR_COMP_CNT(~0u)},
	{17894, S_00B528_CACHE_CTL(~0u)},
	{17904, S_00B528_CDBG_USER(~0u)},
	/* 930 */
	{17924, S_00B52C_SCRATCH_EN(~0u)},
	{17935, S_00B52C_USER_SGPR(~0u)},
	{17945, S_00B52C_TRAP_PRESENT(~0u)},
	{17976, S_00B52C_LDS_SIZE(~0u)},
	{17985, S_00B52C_EXCP_EN_SI(~0u)},
	{17996, S_00B52C_EXCP_EN(~0u)},
	/* 936 */
	{18293, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{18311, S_00B800_PARTIAL_TG_EN(~0u)},
	{18325, S_00B800_FORCE_START_AT_000(~0u)},
	{18344, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{18364, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{18384, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{18406, S_00B800_ORDER_MODE(~0u)},
	{18417, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{18437, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{18455, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{18473, S_00B800_DATA_ATC(~0u)},
	{18482, S_00B800_RESTORE(~0u)},
	{953, S_00B800_RESERVED(~0u)},
	/* 949 */
	{18490, S_00B81C_NUM_THREAD_FULL(~0u)},
	{18506, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 951 */
	{18490, S_00B820_NUM_THREAD_FULL(~0u)},
	{18506, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 953 */
	{18490, S_00B824_NUM_THREAD_FULL(~0u)},
	{18506, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 955 */
	{15241, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 956 */
	{18525, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 957 */
	{18545, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 958 */
	{391, S_00B834_DATA(~0u)},
	{18562, S_00B834_INST_ATC(~0u)},
	/* 960 */
	{391, S_00B83C_DATA(~0u)},
	/* 961 */
	{391, S_00B844_DATA(~0u)},
	/* 962 */
	{17774, S_00B848_VGPRS(~0u)},
	{17780, S_00B848_SGPRS(~0u)},
	{15464, S_00B848_PRIORITY(~0u)},
	{17829, S_00B848_FLOAT_MODE(~0u)},
	{17840, S_00B848_PRIV(~0u)},
	{17845, S_00B848_DX10_CLAMP(~0u)},
	{17856, S_00B848_DEBUG_MODE(~0u)},
	{17867, S_00B848_IEEE_MODE(~0u)},
	{18571, S_00B848_BULKY(~0u)},
	{17904, S_00B848_CDBG_USER(~0u)},
	{17914, S_00B848_FP16_OVFL(~0u)},
	/* 973 */
	{17924, S_00B84C_SCRATCH_EN(~0u)},
	{17935, S_00B84C_USER_SGPR(~0u)},
	{17945, S_00B84C_TRAP_PRESENT(~0u)},
	{18577, S_00B84C_TGID_X_EN(~0u)},
	{18587, S_00B84C_TGID_Y_EN(~0u)},
	{18597, S_00B84C_TGID_Z_EN(~0u)},
	{18267, S_00B84C_TG_SIZE_EN(~0u)},
	{18607, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{18622, S_00B84C_EXCP_EN_MSB(~0u)},
	{17976, S_00B84C_LDS_SIZE(~0u)},
	{17996, S_00B84C_EXCP_EN(~0u)},
	{18051, S_00B84C_SKIP_USGPR0(~0u)},
	/* 985 */
	{391, S_00B850_DATA(~0u)},
	/* 986 */
	{18634, S_00B854_WAVES_PER_SH_SI(~0u)},
	{18650, S_00B854_WAVES_PER_SH(~0u)},
	{18663, S_00B854_TG_PER_CU(~0u)},
	{18673, S_00B854_LOCK_THRESHOLD(~0u)},
	{18688, S_00B854_SIMD_DEST_CNTL(~0u)},
	{18703, S_00B854_FORCE_SIMD_DIST(~0u)},
	{18719, S_00B854_CU_GROUP_COUNT(~0u)},
	{17761, S_00B854_SIMD_DISABLE(~0u)},
	/* 994 */
	{18734, S_00B858_SH0_CU_EN(~0u)},
	{18744, S_00B858_SH1_CU_EN(~0u)},
	/* 996 */
	{18734, S_00B85C_SH0_CU_EN(~0u)},
	{18744, S_00B85C_SH1_CU_EN(~0u)},
	/* 998 */
	{18754, S_00B860_WAVES(~0u)},
	{18760, S_00B860_WAVESIZE(~0u)},
	/* 1000 */
	{18734, S_00B864_SH0_CU_EN(~0u)},
	{18744, S_00B864_SH1_CU_EN(~0u)},
	/* 1002 */
	{18734, S_00B868_SH0_CU_EN(~0u)},
	{18744, S_00B868_SH1_CU_EN(~0u)},
	/* 1004 */
	{18769, S_00B87C_SEND_SEID(~0u)},
	{16780, S_00B87C_RESERVED2(~0u)},
	{18779, S_00B87C_RESERVED3(~0u)},
	{18789, S_00B87C_RESERVED4(~0u)},
	{18799, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 1009 */
	{18812, S_00B888_PAYLOAD(~0u)},
	{18820, S_00B888_IS_EVENT(~0u)},
	{18829, S_00B888_IS_STATE(~0u)},
	/* 1012 */
	{906, S_00B890_ADDR(~0u)},
	/* 1013 */
	{9689, S_00B894_ATC(~0u)},
	{9710, S_00B894_MTYPE(~0u)},
	/* 1015 */
	{18838, S_034404_PERFCOUNTER_HI(~0u)},
	/* 1016 */
	{18853, S_036004_PERF_SEL2(~0u)},
	{18863, S_036004_PERF_SEL3(~0u)},
	{18873, S_036004_CNTR_SEL2(~0u)},
	{18883, S_036004_CNTR_SEL3(~0u)},
	{18893, S_036004_CNTR_MODE3(~0u)},
	{18904, S_036004_CNTR_MODE2(~0u)},
	/* 1022 */
	{18915, S_036008_PERF_SEL(~0u)},
	{18924, S_036008_PERF_SEL1(~0u)},
	{18934, S_036008_CNTR_MODE(~0u)},
	{18944, S_036008_CNTR_SEL0(~0u)},
	{18954, S_036008_CNTR_SEL1(~0u)},
	{18964, S_036008_SPM_MODE(~0u)},
	{18973, S_036008_CNTR_MODE1(~0u)},
	{18984, S_036008_CNTR_MODE0(~0u)},
	/* 1030 */
	{18853, S_036010_PERF_SEL2(~0u)},
	{18863, S_036010_PERF_SEL3(~0u)},
	{18873, S_036010_CNTR_SEL2(~0u)},
	{18883, S_036010_CNTR_SEL3(~0u)},
	{18893, S_036010_CNTR_MODE3(~0u)},
	{18904, S_036010_CNTR_MODE2(~0u)},
	/* 1036 */
	{18853, S_036018_PERF_SEL2(~0u)},
	{18863, S_036018_PERF_SEL3(~0u)},
	{18873, S_036018_CNTR_SEL2(~0u)},
	{18883, S_036018_CNTR_SEL3(~0u)},
	{18893, S_036018_CNTR_MODE3(~0u)},
	{18904, S_036018_CNTR_MODE2(~0u)},
	/* 1042 */
	{18915, S_03601C_PERF_SEL(~0u)},
	{18924, S_03601C_PERF_SEL1(~0u)},
	{18934, S_03601C_CNTR_MODE(~0u)},
	{18944, S_03601C_CNTR_SEL0(~0u)},
	{18954, S_03601C_CNTR_SEL1(~0u)},
	{18964, S_03601C_SPM_MODE(~0u)},
	{18973, S_03601C_CNTR_MODE1(~0u)},
	{18984, S_03601C_CNTR_MODE0(~0u)},
	/* 1050 */
	{19042, S_036020_PERFMON_STATE(~0u), 3, 785},
	{19056, S_036020_SPM_PERFMON_STATE(~0u)},
	{19074, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{19094, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 1054 */
	{18915, S_036024_PERF_SEL(~0u)},
	{18924, S_036024_PERF_SEL1(~0u)},
	{18934, S_036024_CNTR_MODE(~0u)},
	{18944, S_036024_CNTR_SEL0(~0u)},
	{18954, S_036024_CNTR_SEL1(~0u)},
	{18964, S_036024_SPM_MODE(~0u)},
	{18973, S_036024_CNTR_MODE1(~0u)},
	{18984, S_036024_CNTR_MODE0(~0u)},
	/* 1062 */
	{18915, S_036100_PERF_SEL(~0u)},
	{19116, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19143, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19170, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19197, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19249, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19302, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19328, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19382, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19408, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{19434, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{19460, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{19487, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19514, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{19541, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{19567, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{19593, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{19622, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{19648, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1084 */
	{18915, S_036108_PERF_SEL(~0u)},
	{19116, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19143, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19197, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19249, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19382, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19170, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19302, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19487, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19648, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1097 */
	{18915, S_03610C_PERF_SEL(~0u)},
	{19116, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19143, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19197, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19249, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19382, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19170, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19302, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19487, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19648, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1110 */
	{18915, S_036110_PERF_SEL(~0u)},
	{19116, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19143, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19197, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19249, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19382, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19170, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19302, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19487, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19648, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1123 */
	{18915, S_036114_PERF_SEL(~0u)},
	{19116, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19143, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19197, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19249, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19382, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19170, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19302, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19487, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19648, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1136 */
	{18915, S_036200_PERF_SEL(~0u)},
	{19675, S_036200_PERF_MODE(~0u)},
	/* 1138 */
	{18915, S_036210_PERF_SEL(~0u)},
	{18924, S_036210_PERF_SEL1(~0u)},
	{18934, S_036210_CNTR_MODE(~0u)},
	{19685, S_036210_PERF_MODE1(~0u)},
	{19675, S_036210_PERF_MODE(~0u)},
	/* 1143 */
	{18853, S_036220_PERF_SEL2(~0u)},
	{18863, S_036220_PERF_SEL3(~0u)},
	{19696, S_036220_PERF_MODE3(~0u)},
	{19707, S_036220_PERF_MODE2(~0u)},
	/* 1147 */
	{18915, S_036230_PERF_SEL(~0u)},
	{18924, S_036230_PERF_SEL1(~0u)},
	{18934, S_036230_CNTR_MODE(~0u)},
	{19685, S_036230_PERF_MODE1(~0u)},
	{19675, S_036230_PERF_MODE(~0u)},
	/* 1152 */
	{18853, S_036240_PERF_SEL2(~0u)},
	{18863, S_036240_PERF_SEL3(~0u)},
	{19696, S_036240_PERF_MODE3(~0u)},
	{19707, S_036240_PERF_MODE2(~0u)},
	/* 1156 */
	{19718, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1157 */
	{18915, S_036400_PERF_SEL(~0u)},
	{18924, S_036400_PERF_SEL1(~0u)},
	{18934, S_036400_CNTR_MODE(~0u)},
	/* 1160 */
	{18853, S_036404_PERF_SEL2(~0u)},
	{18863, S_036404_PERF_SEL3(~0u)},
	/* 1162 */
	{18915, S_036500_PERF_SEL(~0u)},
	{18924, S_036500_PERF_SEL1(~0u)},
	{18934, S_036500_CNTR_MODE(~0u)},
	/* 1165 */
	{18853, S_036504_PERF_SEL2(~0u)},
	{18863, S_036504_PERF_SEL3(~0u)},
	/* 1167 */
	{18915, S_036600_PERF_SEL(~0u)},
	{18924, S_036600_PERF_SEL1(~0u)},
	{18934, S_036600_CNTR_MODE(~0u)},
	{19685, S_036600_PERF_MODE1(~0u)},
	{19675, S_036600_PERF_MODE(~0u)},
	/* 1172 */
	{18853, S_036610_PERF_SEL2(~0u)},
	{18863, S_036610_PERF_SEL3(~0u)},
	{19696, S_036610_PERF_MODE3(~0u)},
	{19707, S_036610_PERF_MODE2(~0u)},
	/* 1176 */
	{19740, S_036628_BIN0_MIN(~0u)},
	{19749, S_036628_BIN0_MAX(~0u)},
	{19758, S_036628_BIN1_MIN(~0u)},
	{19767, S_036628_BIN1_MAX(~0u)},
	{19776, S_036628_BIN2_MIN(~0u)},
	{19785, S_036628_BIN2_MAX(~0u)},
	{19794, S_036628_BIN3_MIN(~0u)},
	{19803, S_036628_BIN3_MAX(~0u)},
	/* 1184 */
	{18915, S_036700_PERF_SEL(~0u)},
	{19812, S_036700_SQC_BANK_MASK(~0u)},
	{19826, S_036700_SQC_CLIENT_MASK(~0u)},
	{18964, S_036700_SPM_MODE(~0u)},
	{19842, S_036700_SIMD_MASK(~0u)},
	{19675, S_036700_PERF_MODE(~0u)},
	/* 1190 */
	{19852, S_036780_PS_EN(~0u)},
	{19858, S_036780_VS_EN(~0u)},
	{19864, S_036780_GS_EN(~0u)},
	{19870, S_036780_ES_EN(~0u)},
	{19876, S_036780_HS_EN(~0u)},
	{19882, S_036780_LS_EN(~0u)},
	{19888, S_036780_CS_EN(~0u)},
	{19894, S_036780_CNTR_RATE(~0u)},
	{19904, S_036780_DISABLE_FLUSH(~0u)},
	/* 1199 */
	{19918, S_036784_SH0_MASK(~0u)},
	{19927, S_036784_SH1_MASK(~0u)},
	/* 1201 */
	{19936, S_036788_FORCE_EN(~0u)},
	/* 1202 */
	{19945, S_036900_PERFCOUNTER_SELECT(~0u)},
	{19964, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{18934, S_036900_CNTR_MODE(~0u)},
	/* 1205 */
	{19984, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{20004, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1207 */
	{19945, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{19964, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{18934, S_036A00_CNTR_MODE(~0u)},
	/* 1210 */
	{19984, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{20004, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1212 */
	{18915, S_036B00_PERF_SEL(~0u)},
	{18924, S_036B00_PERF_SEL1(~0u)},
	{18934, S_036B00_CNTR_MODE(~0u)},
	{19685, S_036B00_PERF_MODE1(~0u)},
	{19675, S_036B00_PERF_MODE(~0u)},
	/* 1217 */
	{18853, S_036B04_PERF_SEL2(~0u)},
	{18863, S_036B04_PERF_SEL3(~0u)},
	{19696, S_036B04_PERF_MODE3(~0u)},
	{19707, S_036B04_PERF_MODE2(~0u)},
	/* 1221 */
	{18915, S_036C00_PERF_SEL(~0u)},
	{18924, S_036C00_PERF_SEL1(~0u)},
	{18934, S_036C00_CNTR_MODE(~0u)},
	{19685, S_036C00_PERF_MODE1(~0u)},
	{19675, S_036C00_PERF_MODE(~0u)},
	/* 1226 */
	{18853, S_036C04_PERF_SEL2(~0u)},
	{18863, S_036C04_PERF_SEL3(~0u)},
	{19696, S_036C04_PERF_MODE3(~0u)},
	{19707, S_036C04_PERF_MODE2(~0u)},
	/* 1230 */
	{18915, S_036D00_PERF_SEL(~0u)},
	{18924, S_036D00_PERF_SEL1(~0u)},
	{18934, S_036D00_CNTR_MODE(~0u)},
	{19685, S_036D00_PERF_MODE1(~0u)},
	{19675, S_036D00_PERF_MODE(~0u)},
	/* 1235 */
	{18853, S_036D04_PERF_SEL2(~0u)},
	{18863, S_036D04_PERF_SEL3(~0u)},
	{19696, S_036D04_PERF_MODE3(~0u)},
	{19707, S_036D04_PERF_MODE2(~0u)},
	/* 1239 */
	{18915, S_036E00_PERF_SEL(~0u)},
	{18924, S_036E00_PERF_SEL1(~0u)},
	{18934, S_036E00_CNTR_MODE(~0u)},
	{19685, S_036E00_PERF_MODE1(~0u)},
	{19675, S_036E00_PERF_MODE(~0u)},
	/* 1244 */
	{18853, S_036E04_PERF_SEL2(~0u)},
	{18863, S_036E04_PERF_SEL3(~0u)},
	{19707, S_036E04_PERF_MODE2(~0u)},
	{19696, S_036E04_PERF_MODE3(~0u)},
	/* 1248 */
	{18915, S_036E40_PERF_SEL(~0u)},
	{18924, S_036E40_PERF_SEL1(~0u)},
	{18934, S_036E40_CNTR_MODE(~0u)},
	{19685, S_036E40_PERF_MODE1(~0u)},
	{19675, S_036E40_PERF_MODE(~0u)},
	/* 1253 */
	{18853, S_036E44_PERF_SEL2(~0u)},
	{18863, S_036E44_PERF_SEL3(~0u)},
	{19707, S_036E44_PERF_MODE2(~0u)},
	{19696, S_036E44_PERF_MODE3(~0u)},
	/* 1257 */
	{20024, S_037000_OP_FILTER_ENABLE(~0u)},
	{20041, S_037000_OP_FILTER_SEL(~0u)},
	{20055, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{20076, S_037000_FORMAT_FILTER_SEL(~0u)},
	{20094, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{20114, S_037000_CLEAR_FILTER_SEL(~0u)},
	{20131, S_037000_MRT_FILTER_ENABLE(~0u)},
	{20149, S_037000_MRT_FILTER_SEL(~0u)},
	{20164, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{20190, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{20213, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{20241, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1269 */
	{18915, S_037004_PERF_SEL(~0u)},
	{18924, S_037004_PERF_SEL1(~0u)},
	{18934, S_037004_CNTR_MODE(~0u)},
	{19685, S_037004_PERF_MODE1(~0u)},
	{19675, S_037004_PERF_MODE(~0u)},
	/* 1274 */
	{18853, S_037008_PERF_SEL2(~0u)},
	{18863, S_037008_PERF_SEL3(~0u)},
	{19696, S_037008_PERF_MODE3(~0u)},
	{19707, S_037008_PERF_MODE2(~0u)},
	/* 1278 */
	{18915, S_037100_PERF_SEL(~0u)},
	{18924, S_037100_PERF_SEL1(~0u)},
	{18934, S_037100_CNTR_MODE(~0u)},
	{19685, S_037100_PERF_MODE1(~0u)},
	{19675, S_037100_PERF_MODE(~0u)},
	/* 1283 */
	{18853, S_037104_PERF_SEL2(~0u)},
	{18863, S_037104_PERF_SEL3(~0u)},
	{19696, S_037104_PERF_MODE3(~0u)},
	{19707, S_037104_PERF_MODE2(~0u)},
	/* 1287 */
	{20266, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{20285, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{20306, S_028000_DEPTH_COPY(~0u)},
	{20317, S_028000_STENCIL_COPY(~0u)},
	{20330, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{20349, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{20374, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{20397, S_028000_COPY_CENTROID(~0u)},
	{20411, S_028000_COPY_SAMPLE(~0u)},
	{20423, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1297 */
	{20441, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{20465, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{20486, S_028004_SAMPLE_RATE(~0u)},
	{20498, S_028004_ZPASS_ENABLE(~0u)},
	{20511, S_028004_ZFAIL_ENABLE(~0u)},
	{20524, S_028004_SFAIL_ENABLE(~0u)},
	{20537, S_028004_DBFAIL_ENABLE(~0u)},
	{20551, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{20569, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1306 */
	{20586, S_028008_SLICE_START(~0u)},
	{20598, S_028008_SLICE_MAX(~0u)},
	{20608, S_028008_Z_READ_ONLY(~0u)},
	{20620, S_028008_STENCIL_READ_ONLY(~0u)},
	{20638, S_028008_MIPID(~0u)},
	/* 1311 */
	{20696, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 788},
	{20713, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 788},
	{20731, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 788},
	{20749, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{20770, S_02800C_FAST_Z_DISABLE(~0u)},
	{20785, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{20806, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{20824, S_02800C_FORCE_COLOR_KILL(~0u)},
	{20841, S_02800C_FORCE_Z_READ(~0u)},
	{20854, S_02800C_FORCE_STENCIL_READ(~0u)},
	{20873, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 788},
	{20892, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{20916, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{20939, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{20956, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{21041, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 792},
	{21060, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{21077, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{21101, S_02800C_FORCE_Z_DIRTY(~0u)},
	{21115, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{21135, S_02800C_FORCE_Z_VALID(~0u)},
	{21149, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{21169, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1334 */
	{21243, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 796},
	{21272, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{21303, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{21339, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{21374, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{21402, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{21424, S_028010_DISABLE_REG_SNOOP(~0u)},
	{21442, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{21474, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{21500, S_028010_HIZ_ZFUNC(~0u)},
	{21510, S_028010_HIS_SFUNC_FF(~0u)},
	{21523, S_028010_HIS_SFUNC_BF(~0u)},
	{21536, S_028010_PRESERVE_ZRANGE(~0u)},
	{21552, S_028010_PRESERVE_SRESULTS(~0u)},
	{21570, S_028010_DISABLE_FAST_PASS(~0u)},
	{21588, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 1350 */
	{21616, S_028028_CLEAR(~0u)},
	/* 1351 */
	{21622, S_028030_TL_X(~0u)},
	{21627, S_028030_TL_Y(~0u)},
	/* 1353 */
	{21632, S_028034_BR_X(~0u)},
	{21637, S_028034_BR_Y(~0u)},
	/* 1355 */
	{21642, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{16697, S_02803C_ARRAY_MODE(~0u), 7, 800},
	{17059, S_02803C_PIPE_CONFIG(~0u), 18, 807},
	{17352, S_02803C_BANK_WIDTH(~0u), 4, 524},
	{17459, S_02803C_BANK_HEIGHT(~0u), 4, 528},
	{17571, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 532},
	{16263, S_02803C_NUM_BANKS(~0u), 4, 536},
	/* 1362 */
	{9248, S_028040_FORMAT(~0u), 4, 825},
	{21794, S_028040_NUM_SAMPLES(~0u)},
	{17249, S_028040_TILE_SPLIT(~0u), 7, 517},
	{21806, S_028040_TILE_MODE_INDEX(~0u)},
	{21822, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{21846, S_028040_ALLOW_EXPCLEAR(~0u)},
	{21861, S_028040_READ_SIZE(~0u)},
	{21871, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{21891, S_028040_CLEAR_DISALLOWED(~0u)},
	{21908, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1372 */
	{9248, S_028044_FORMAT(~0u), 2, 829},
	{17249, S_028044_TILE_SPLIT(~0u), 7, 517},
	{21806, S_028044_TILE_MODE_INDEX(~0u)},
	{21846, S_028044_ALLOW_EXPCLEAR(~0u)},
	{21951, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{21891, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1378 */
	{21972, S_028058_PITCH_TILE_MAX(~0u)},
	{21987, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1380 */
	{22003, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1381 */
	{8871, S_028084_ADDRESS(~0u)},
	/* 1382 */
	{22018, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 1383 */
	{22018, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 1384 */
	{22018, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 1385 */
	{22018, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 1386 */
	{22036, S_028200_WINDOW_X_OFFSET(~0u)},
	{22052, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1388 */
	{21622, S_028204_TL_X(~0u)},
	{21627, S_028204_TL_Y(~0u)},
	{22068, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1391 */
	{21632, S_028208_BR_X(~0u)},
	{21637, S_028208_BR_Y(~0u)},
	/* 1393 */
	{22090, S_02820C_CLIP_RULE(~0u)},
	/* 1394 */
	{21622, S_028210_TL_X(~0u)},
	{21627, S_028210_TL_Y(~0u)},
	/* 1396 */
	{21632, S_028214_BR_X(~0u)},
	{21637, S_028214_BR_Y(~0u)},
	/* 1398 */
	{22100, S_028230_ER_TRI(~0u)},
	{14642, S_028230_ER_POINT(~0u)},
	{22107, S_028230_ER_RECT(~0u)},
	{22115, S_028230_ER_LINE_LR(~0u)},
	{22126, S_028230_ER_LINE_RL(~0u)},
	{22137, S_028230_ER_LINE_TB(~0u)},
	{22148, S_028230_ER_LINE_BT(~0u)},
	/* 1405 */
	{22159, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{22178, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1407 */
	{22197, S_028238_TARGET0_ENABLE(~0u)},
	{22212, S_028238_TARGET1_ENABLE(~0u)},
	{22227, S_028238_TARGET2_ENABLE(~0u)},
	{22242, S_028238_TARGET3_ENABLE(~0u)},
	{22257, S_028238_TARGET4_ENABLE(~0u)},
	{22272, S_028238_TARGET5_ENABLE(~0u)},
	{22287, S_028238_TARGET6_ENABLE(~0u)},
	{22302, S_028238_TARGET7_ENABLE(~0u)},
	/* 1415 */
	{22317, S_02823C_OUTPUT0_ENABLE(~0u)},
	{22332, S_02823C_OUTPUT1_ENABLE(~0u)},
	{22347, S_02823C_OUTPUT2_ENABLE(~0u)},
	{22362, S_02823C_OUTPUT3_ENABLE(~0u)},
	{22377, S_02823C_OUTPUT4_ENABLE(~0u)},
	{22392, S_02823C_OUTPUT5_ENABLE(~0u)},
	{22407, S_02823C_OUTPUT6_ENABLE(~0u)},
	{22422, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1423 */
	{21622, S_028240_TL_X(~0u)},
	{21627, S_028240_TL_Y(~0u)},
	{22068, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1426 */
	{21632, S_028244_BR_X(~0u)},
	{21637, S_028244_BR_Y(~0u)},
	/* 1428 */
	{21622, S_028250_TL_X(~0u)},
	{21627, S_028250_TL_Y(~0u)},
	{22068, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1431 */
	{21632, S_028254_BR_X(~0u)},
	{21637, S_028254_BR_Y(~0u)},
	/* 1433 */
	{22529, S_028350_RB_MAP_PKR0(~0u), 4, 831},
	{22541, S_028350_RB_MAP_PKR1(~0u), 4, 831},
	{22653, S_028350_RB_XSEL2(~0u), 4, 835},
	{22662, S_028350_RB_XSEL(~0u)},
	{22670, S_028350_RB_YSEL(~0u)},
	{22774, S_028350_PKR_MAP(~0u), 4, 839},
	{22882, S_028350_PKR_XSEL(~0u), 4, 843},
	{22991, S_028350_PKR_YSEL(~0u), 4, 847},
	{23104, S_028350_PKR_XSEL2(~0u), 4, 851},
	{23206, S_028350_SC_MAP(~0u), 4, 855},
	{23352, S_028350_SC_XSEL(~0u), 4, 859},
	{23499, S_028350_SC_YSEL(~0u), 4, 863},
	{23599, S_028350_SE_MAP(~0u), 4, 867},
	{23745, S_028350_SE_XSEL_GFX6(~0u), 4, 871},
	{23897, S_028350_SE_YSEL_GFX6(~0u), 4, 875},
	{23910, S_028350_SE_XSEL_GFX9(~0u)},
	{23923, S_028350_SE_YSEL_GFX9(~0u)},
	/* 1450 */
	{24048, S_028354_SE_PAIR_MAP(~0u), 4, 879},
	{24219, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 883},
	{24396, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 887},
	{24414, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{24432, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 1455 */
	{20551, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{20569, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1457 */
	{24450, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{24477, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{24516, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1460 */
	{24782, S_02842C_STENCILFAIL(~0u), 16, 891},
	{24794, S_02842C_STENCILZPASS(~0u), 16, 891},
	{24807, S_02842C_STENCILZFAIL(~0u), 16, 891},
	{24820, S_02842C_STENCILFAIL_BF(~0u), 16, 891},
	{24835, S_02842C_STENCILZPASS_BF(~0u), 16, 891},
	{24851, S_02842C_STENCILZFAIL_BF(~0u), 16, 891},
	/* 1466 */
	{24867, S_028430_STENCILTESTVAL(~0u)},
	{24882, S_028430_STENCILMASK(~0u)},
	{24894, S_028430_STENCILWRITEMASK(~0u)},
	{24911, S_028430_STENCILOPVAL(~0u)},
	/* 1470 */
	{24924, S_028434_STENCILTESTVAL_BF(~0u)},
	{24942, S_028434_STENCILMASK_BF(~0u)},
	{24957, S_028434_STENCILWRITEMASK_BF(~0u)},
	{24977, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1474 */
	{669, S_028644_OFFSET(~0u)},
	{25000, S_028644_DEFAULT_VAL(~0u), 1, 907},
	{25012, S_028644_FLAT_SHADE(~0u)},
	{25023, S_028644_CYL_WRAP(~0u)},
	{25032, S_028644_PT_SPRITE_TEX(~0u)},
	{25046, S_028644_DUP(~0u)},
	{25050, S_028644_FP16_INTERP_MODE(~0u)},
	{25067, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{25085, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{25103, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{25123, S_028644_ATTR0_VALID(~0u)},
	{25135, S_028644_ATTR1_VALID(~0u)},
	/* 1486 */
	{25147, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{25163, S_0286C4_VS_HALF_PACK(~0u)},
	{25176, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{25191, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1490 */
	{25211, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{25228, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{25245, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{25264, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{25285, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{25303, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{25321, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{25341, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{25362, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{25378, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{25394, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{25410, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{25426, S_0286CC_FRONT_FACE_ENA(~0u)},
	{25441, S_0286CC_ANCILLARY_ENA(~0u)},
	{25455, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{25475, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1506 */
	{25211, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{25228, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{25245, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{25264, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{25285, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{25303, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{25321, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{25341, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{25362, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{25378, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{25394, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{25410, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{25426, S_0286D0_FRONT_FACE_ENA(~0u)},
	{25441, S_0286D0_ANCILLARY_ENA(~0u)},
	{25455, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{25475, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1522 */
	{25492, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{25507, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{25630, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 908},
	{25648, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 908},
	{25666, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 908},
	{25684, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 908},
	{25702, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1529 */
	{25719, S_0286D8_NUM_INTERP(~0u)},
	{25730, S_0286D8_PARAM_GEN(~0u)},
	{25740, S_0286D8_FOG_ADDR(~0u)},
	{25749, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{25769, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	{25789, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{25806, S_0286D8_LATE_PC_DEALLOC(~0u)},
	/* 1536 */
	{25822, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{25840, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{25860, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{25879, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{25949, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 913},
	{25968, S_0286E0_POS_FLOAT_ULC(~0u)},
	{25982, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1543 */
	{18754, S_0286E8_WAVES(~0u)},
	{18760, S_0286E8_WAVESIZE(~0u)},
	/* 1545 */
	{26002, S_028704_NUM_PS_WAVES(~0u)},
	{26015, S_028704_NUM_VS_WAVES(~0u)},
	{26028, S_028704_NUM_GS_WAVES(~0u)},
	{26041, S_028704_NUM_ES_WAVES(~0u)},
	{26054, S_028704_NUM_HS_WAVES(~0u)},
	/* 1550 */
	{26067, S_028708_NUM_LS_WAVES(~0u)},
	/* 1551 */
	{26168, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 914},
	{26187, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 914},
	{26206, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 914},
	{26225, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 914},
	/* 1555 */
	{26444, S_028710_Z_EXPORT_FORMAT(~0u), 10, 919},
	/* 1556 */
	{26460, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 919},
	{26479, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 919},
	{26498, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 919},
	{26517, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 919},
	{26536, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 919},
	{26555, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 919},
	{26574, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 919},
	{26593, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 919},
	/* 1564 */
	{26847, S_028754_MRT0(~0u), 11, 929},
	{26852, S_028754_MRT1(~0u)},
	{26857, S_028754_MRT2(~0u)},
	{26862, S_028754_MRT3(~0u)},
	{26867, S_028754_MRT4(~0u)},
	{26872, S_028754_MRT5(~0u)},
	{26877, S_028754_MRT6(~0u)},
	{26882, S_028754_MRT7(~0u)},
	/* 1572 */
	{26967, S_028758_MRT0_EPSILON(~0u), 16, 940},
	{26980, S_028758_MRT1_EPSILON(~0u)},
	{26993, S_028758_MRT2_EPSILON(~0u)},
	{27006, S_028758_MRT3_EPSILON(~0u)},
	{27019, S_028758_MRT4_EPSILON(~0u)},
	{27032, S_028758_MRT5_EPSILON(~0u)},
	{27045, S_028758_MRT6_EPSILON(~0u)},
	{27058, S_028758_MRT7_EPSILON(~0u)},
	/* 1580 */
	{27071, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{27094, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{27117, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{27140, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{27163, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{27186, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{27209, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{27232, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{27255, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{27278, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{27301, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{27324, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{27347, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{27370, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{27393, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{27416, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{27439, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1597 */
	{27730, S_028760_COLOR_SRC_OPT(~0u), 8, 956},
	{27744, S_028760_COLOR_DST_OPT(~0u)},
	{27892, S_028760_COLOR_COMB_FCN(~0u), 8, 964},
	{27907, S_028760_ALPHA_SRC_OPT(~0u)},
	{27921, S_028760_ALPHA_DST_OPT(~0u)},
	{27935, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1603 */
	{27730, S_028764_COLOR_SRC_OPT(~0u)},
	{27744, S_028764_COLOR_DST_OPT(~0u)},
	{27892, S_028764_COLOR_COMB_FCN(~0u)},
	{27907, S_028764_ALPHA_SRC_OPT(~0u)},
	{27921, S_028764_ALPHA_DST_OPT(~0u)},
	{27935, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1609 */
	{27730, S_028768_COLOR_SRC_OPT(~0u)},
	{27744, S_028768_COLOR_DST_OPT(~0u)},
	{27892, S_028768_COLOR_COMB_FCN(~0u)},
	{27907, S_028768_ALPHA_SRC_OPT(~0u)},
	{27921, S_028768_ALPHA_DST_OPT(~0u)},
	{27935, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1615 */
	{27730, S_02876C_COLOR_SRC_OPT(~0u)},
	{27744, S_02876C_COLOR_DST_OPT(~0u)},
	{27892, S_02876C_COLOR_COMB_FCN(~0u)},
	{27907, S_02876C_ALPHA_SRC_OPT(~0u)},
	{27921, S_02876C_ALPHA_DST_OPT(~0u)},
	{27935, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1621 */
	{27730, S_028770_COLOR_SRC_OPT(~0u)},
	{27744, S_028770_COLOR_DST_OPT(~0u)},
	{27892, S_028770_COLOR_COMB_FCN(~0u)},
	{27907, S_028770_ALPHA_SRC_OPT(~0u)},
	{27921, S_028770_ALPHA_DST_OPT(~0u)},
	{27935, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1627 */
	{27730, S_028774_COLOR_SRC_OPT(~0u)},
	{27744, S_028774_COLOR_DST_OPT(~0u)},
	{27892, S_028774_COLOR_COMB_FCN(~0u)},
	{27907, S_028774_ALPHA_SRC_OPT(~0u)},
	{27921, S_028774_ALPHA_DST_OPT(~0u)},
	{27935, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1633 */
	{27730, S_028778_COLOR_SRC_OPT(~0u)},
	{27744, S_028778_COLOR_DST_OPT(~0u)},
	{27892, S_028778_COLOR_COMB_FCN(~0u)},
	{27907, S_028778_ALPHA_SRC_OPT(~0u)},
	{27921, S_028778_ALPHA_DST_OPT(~0u)},
	{27935, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1639 */
	{27730, S_02877C_COLOR_SRC_OPT(~0u)},
	{27744, S_02877C_COLOR_DST_OPT(~0u)},
	{27892, S_02877C_COLOR_COMB_FCN(~0u)},
	{27907, S_02877C_ALPHA_SRC_OPT(~0u)},
	{27921, S_02877C_ALPHA_DST_OPT(~0u)},
	{27935, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1645 */
	{28344, S_028780_COLOR_SRCBLEND(~0u), 21, 972},
	{27892, S_028780_COLOR_COMB_FCN(~0u), 5, 993},
	{28449, S_028780_COLOR_DESTBLEND(~0u), 21, 972},
	{28465, S_028780_ALPHA_SRCBLEND(~0u), 21, 972},
	{27935, S_028780_ALPHA_COMB_FCN(~0u), 5, 993},
	{28480, S_028780_ALPHA_DESTBLEND(~0u), 21, 972},
	{28496, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{842, S_028780_ENABLE(~0u)},
	{28517, S_028780_DISABLE_ROP3(~0u)},
	/* 1654 */
	{28530, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1655 */
	{28543, S_0287E4_BASE_ADDR_GFX6(~0u)},
	{28558, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 1657 */
	{28651, S_0287F0_SOURCE_SELECT(~0u), 4, 998},
	{28697, S_0287F0_MAJOR_MODE(~0u), 2, 1002},
	{28708, S_0287F0_NOT_EOP(~0u)},
	{28716, S_0287F0_USE_OPAQUE(~0u)},
	{28727, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{28742, S_0287F0_UNROLLED_INST(~0u)},
	{28756, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{28773, S_0287F0_REG_RT_INDEX(~0u)},
	/* 1665 */
	{28786, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1666 */
	{28798, S_028800_STENCIL_ENABLE(~0u)},
	{20704, S_028800_Z_ENABLE(~0u)},
	{28813, S_028800_Z_WRITE_ENABLE(~0u)},
	{28828, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{21504, S_028800_ZFUNC(~0u), 8, 1004},
	{28943, S_028800_BACKFACE_ENABLE(~0u)},
	{29046, S_028800_STENCILFUNC(~0u), 8, 1012},
	{29058, S_028800_STENCILFUNC_BF(~0u), 8, 1012},
	{29073, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{29107, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1676 */
	{29142, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{29161, S_028804_PS_ITER_SAMPLES(~0u)},
	{29177, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{29201, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{29227, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{29254, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{29276, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{29295, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{29313, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{29340, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{29367, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{29392, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1688 */
	{29423, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{29441, S_028808_DEGAMMA_ENABLE(~0u)},
	{9808, S_028808_MODE(~0u), 7, 1020},
	{28525, S_028808_ROP3(~0u), 256, 1027},
	/* 1692 */
	{29746, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{29762, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{29793, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{20762, S_02880C_Z_ORDER(~0u), 4, 1283},
	{29872, S_02880C_KILL_ENABLE(~0u)},
	{29884, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{29908, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{29927, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{29945, S_02880C_EXEC_ON_NOOP(~0u)},
	{29958, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{29980, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{30070, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1287},
	{30092, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{30110, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{30141, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{30160, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 1708 */
	{30185, S_028810_UCP_ENA_0(~0u)},
	{30195, S_028810_UCP_ENA_1(~0u)},
	{30205, S_028810_UCP_ENA_2(~0u)},
	{30215, S_028810_UCP_ENA_3(~0u)},
	{30225, S_028810_UCP_ENA_4(~0u)},
	{30235, S_028810_UCP_ENA_5(~0u)},
	{30245, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{30264, S_028810_PS_UCP_MODE(~0u)},
	{30276, S_028810_CLIP_DISABLE(~0u)},
	{30289, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{30307, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{30330, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{30348, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{30368, S_028810_VTX_KILL_OR(~0u)},
	{30380, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{30402, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{30426, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{30452, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{30471, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1727 */
	{30489, S_028814_CULL_FRONT(~0u)},
	{30500, S_028814_CULL_BACK(~0u)},
	{30510, S_028814_FACE(~0u)},
	{30525, S_028814_POLY_MODE(~0u), 2, 1291},
	{30591, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1293},
	{30612, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1293},
	{30632, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{30657, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{30681, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{30705, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{30730, S_028814_PROVOKING_VTX_LAST(~0u)},
	{30749, S_028814_PERSP_CORR_DIS(~0u)},
	{30764, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{30782, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{30820, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 1742 */
	{30843, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{30861, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{30880, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{30898, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{30917, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{30935, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{30954, S_028818_VTX_XY_FMT(~0u)},
	{30965, S_028818_VTX_Z_FMT(~0u)},
	{30975, S_028818_VTX_W0_FMT(~0u)},
	{30986, S_028818_PERFCOUNTER_REF(~0u)},
	/* 1752 */
	{31002, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{31018, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{31034, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{31050, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{31066, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{31082, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{31098, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{31114, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{31130, S_02881C_CULL_DIST_ENA_0(~0u)},
	{31146, S_02881C_CULL_DIST_ENA_1(~0u)},
	{31162, S_02881C_CULL_DIST_ENA_2(~0u)},
	{31178, S_02881C_CULL_DIST_ENA_3(~0u)},
	{31194, S_02881C_CULL_DIST_ENA_4(~0u)},
	{31210, S_02881C_CULL_DIST_ENA_5(~0u)},
	{31226, S_02881C_CULL_DIST_ENA_6(~0u)},
	{31242, S_02881C_CULL_DIST_ENA_7(~0u)},
	{31258, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{31277, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{31295, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{31322, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{31344, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{31362, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{31382, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{31405, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{31428, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{31453, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{31473, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{31492, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 1780 */
	{31515, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{31534, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{31552, S_028820_VTE_W_INF_DISCARD(~0u)},
	{31570, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{31588, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{31606, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{31623, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{31640, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{31661, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{31678, S_028820_VS_XY_INF_RETAIN(~0u)},
	{31695, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{31711, S_028820_VS_Z_INF_RETAIN(~0u)},
	{31727, S_028820_VS_W_NAN_TO_INF(~0u)},
	{31743, S_028820_VS_W_INF_RETAIN(~0u)},
	{31759, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{31784, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1796 */
	{31804, S_028824_LINE_STIPPLE_RESET(~0u)},
	{31823, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{31842, S_028824_FRACTIONAL_ACCUM(~0u)},
	{31859, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1800 */
	{31874, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{31898, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{31918, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{31939, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{31964, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{31984, S_02882C_LINE_EXPAND_ENA(~0u)},
	{32000, S_02882C_POINT_EXPAND_ENA(~0u)},
	{32017, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{32038, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{32059, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{32080, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1811 */
	{32102, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{31874, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{31898, S_028830_LINE_FILTER_DISABLE(~0u)},
	{31918, S_028830_POINT_FILTER_DISABLE(~0u)},
	{31939, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	{32127, S_028830_SRBSL_ENABLE(~0u)},
	/* 1817 */
	{13235, S_028A00_HEIGHT(~0u)},
	{13229, S_028A00_WIDTH(~0u)},
	/* 1819 */
	{32140, S_028A04_MIN_SIZE(~0u)},
	{32149, S_028A04_MAX_SIZE(~0u)},
	/* 1821 */
	{13229, S_028A08_WIDTH(~0u)},
	/* 1822 */
	{32158, S_028A0C_LINE_PATTERN(~0u)},
	{32171, S_028A0C_REPEAT_COUNT(~0u)},
	{32184, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{32202, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1826 */
	{32323, S_028A10_PATH_SELECT(~0u), 5, 1296},
	/* 1827 */
	{32335, S_028A14_TESS_MODE(~0u)},
	/* 1828 */
	{32345, S_028A20_REUSE_DEPTH(~0u)},
	/* 1829 */
	{6343, S_028A24_PRIM_TYPE(~0u), 18, 1301},
	{32712, S_028A24_RETAIN_ORDER(~0u)},
	{32725, S_028A24_RETAIN_QUADS(~0u)},
	{32806, S_028A24_PRIM_ORDER(~0u), 5, 1319},
	/* 1833 */
	{32817, S_028A28_FIRST_DECR(~0u)},
	/* 1834 */
	{32823, S_028A2C_DECR(~0u)},
	/* 1835 */
	{32828, S_028A30_COMP_X_EN(~0u)},
	{32838, S_028A30_COMP_Y_EN(~0u)},
	{32848, S_028A30_COMP_Z_EN(~0u)},
	{32858, S_028A30_COMP_W_EN(~0u)},
	{8904, S_028A30_STRIDE(~0u)},
	{32868, S_028A30_SHIFT(~0u)},
	/* 1841 */
	{32828, S_028A34_COMP_X_EN(~0u)},
	{32838, S_028A34_COMP_Y_EN(~0u)},
	{32848, S_028A34_COMP_Z_EN(~0u)},
	{32858, S_028A34_COMP_W_EN(~0u)},
	{8904, S_028A34_STRIDE(~0u)},
	{32868, S_028A34_SHIFT(~0u)},
	/* 1847 */
	{33033, S_028A38_X_CONV(~0u), 9, 1324},
	{22043, S_028A38_X_OFFSET(~0u)},
	{33040, S_028A38_Y_CONV(~0u), 9, 1324},
	{22059, S_028A38_Y_OFFSET(~0u)},
	{33047, S_028A38_Z_CONV(~0u), 9, 1324},
	{33054, S_028A38_Z_OFFSET(~0u)},
	{33063, S_028A38_W_CONV(~0u), 9, 1324},
	{33070, S_028A38_W_OFFSET(~0u)},
	/* 1855 */
	{33033, S_028A3C_X_CONV(~0u), 9, 1324},
	{22043, S_028A3C_X_OFFSET(~0u)},
	{33040, S_028A3C_Y_CONV(~0u), 9, 1324},
	{22059, S_028A3C_Y_OFFSET(~0u)},
	{33047, S_028A3C_Z_CONV(~0u), 9, 1324},
	{33054, S_028A3C_Z_OFFSET(~0u)},
	{33063, S_028A3C_W_CONV(~0u), 9, 1324},
	{33070, S_028A3C_W_OFFSET(~0u)},
	/* 1863 */
	{9808, S_028A40_MODE(~0u), 6, 1333},
	{8965, S_028A40_RESERVED_0(~0u)},
	{33197, S_028A40_CUT_MODE(~0u), 4, 1339},
	{8983, S_028A40_RESERVED_1(~0u)},
	{33206, S_028A40_GS_C_PACK_EN(~0u)},
	{33219, S_028A40_RESERVED_2(~0u)},
	{33230, S_028A40_ES_PASSTHRU(~0u)},
	{33242, S_028A40_COMPUTE_MODE(~0u)},
	{33255, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{33273, S_028A40_ELEMENT_INFO_EN(~0u)},
	{33289, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{33308, S_028A40_SUPPRESS_CUTS(~0u)},
	{33322, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{33340, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{33391, S_028A40_ONCHIP(~0u), 4, 1343},
	{33398, S_028A40_RESERVED_3(~0u)},
	{33409, S_028A40_RESERVED_4(~0u)},
	{33420, S_028A40_RESERVED_5(~0u)},
	/* 1881 */
	{33431, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{33451, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{33471, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 1884 */
	{33495, S_028A48_MSAA_ENABLE(~0u)},
	{33507, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{33528, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{33548, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{33573, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{33594, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{33617, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 1891 */
	{33647, S_028A4C_WALK_SIZE(~0u)},
	{33657, S_028A4C_WALK_ALIGNMENT(~0u)},
	{33672, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{33697, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{33715, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{33731, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{33736, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{33759, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{33778, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{33800, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{33816, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{33832, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{33848, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{33867, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{33893, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{33908, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{33948, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{33975, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{33998, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{34014, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{34044, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{34068, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{34089, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{34119, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1915 */
	{34143, S_028A54_GS_PER_ES(~0u)},
	/* 1916 */
	{34153, S_028A58_ES_PER_GS(~0u)},
	/* 1917 */
	{34163, S_028A5C_GS_PER_VS(~0u)},
	/* 1918 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1919 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1920 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1921 */
	{34241, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1347},
	{34254, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{34269, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{34284, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{34299, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1926 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1350},
	{34436, S_028A7C_SWAP_MODE(~0u), 4, 1353},
	{34497, S_028A7C_BUF_TYPE(~0u), 3, 1357},
	{34539, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 1360},
	{34556, S_028A7C_RDREQ_POLICY(~0u)},
	{9689, S_028A7C_ATC(~0u)},
	{28708, S_028A7C_NOT_EOP(~0u)},
	{34569, S_028A7C_REQ_PATH(~0u)},
	{9710, S_028A7C_MTYPE(~0u)},
	{8334, S_028A7C_PRIMGEN_EN(~0u)},
	/* 1936 */
	{34578, S_028A84_PRIMITIVEID_EN(~0u)},
	{34593, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{34614, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 1939 */
	{35674, S_028A90_EVENT_TYPE(~0u), 63, 1362},
	{35685, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{35701, S_028A90_EXTENDED_EVENT(~0u)},
	{35716, S_028A90_ADDRESS_HI_GFX9(~0u)},
	/* 1943 */
	{35732, S_028A94_RESET_EN(~0u)},
	/* 1944 */
	{35741, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{35756, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{35775, S_028AA8_SWITCH_ON_EOP(~0u)},
	{35789, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{35808, S_028AA8_SWITCH_ON_EOI(~0u)},
	{35822, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{35839, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1951 */
	{35859, S_028AAC_ITEMSIZE(~0u)},
	/* 1952 */
	{35859, S_028AB0_ITEMSIZE(~0u)},
	/* 1953 */
	{35868, S_028AB4_REUSE_OFF(~0u)},
	/* 1954 */
	{35878, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1955 */
	{13808, S_028ABC_LINEAR(~0u)},
	{35889, S_028ABC_FULL_CACHE(~0u)},
	{35900, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{35923, S_028ABC_PRELOAD(~0u)},
	{35931, S_028ABC_PREFETCH_WIDTH(~0u)},
	{35946, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{35962, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{35986, S_028ABC_TC_COMPATIBLE(~0u)},
	{13820, S_028ABC_PIPE_ALIGNED(~0u)},
	{13838, S_028ABC_RB_ALIGNED(~0u)},
	/* 1965 */
	{36000, S_028AC0_COMPAREFUNC0(~0u), 8, 1012},
	{36013, S_028AC0_COMPAREVALUE0(~0u)},
	{36027, S_028AC0_COMPAREMASK0(~0u)},
	{20723, S_028AC0_ENABLE0(~0u)},
	/* 1969 */
	{36040, S_028AC4_COMPAREFUNC1(~0u), 8, 1012},
	{36053, S_028AC4_COMPAREVALUE1(~0u)},
	{36067, S_028AC4_COMPAREMASK1(~0u)},
	{20741, S_028AC4_ENABLE1(~0u)},
	/* 1973 */
	{36080, S_028AC8_START_X(~0u)},
	{36088, S_028AC8_START_Y(~0u)},
	{36096, S_028AC8_MAX_X(~0u)},
	{36102, S_028AC8_MAX_Y(~0u)},
	/* 1977 */
	{8904, S_028AD4_STRIDE(~0u)},
	/* 1978 */
	{8904, S_028AE4_STRIDE(~0u)},
	/* 1979 */
	{8904, S_028AF4_STRIDE(~0u)},
	/* 1980 */
	{8904, S_028B04_STRIDE(~0u)},
	/* 1981 */
	{36108, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1982 */
	{36122, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1983 */
	{36135, S_028B50_ACCUM_ISOLINE(~0u)},
	{36149, S_028B50_ACCUM_TRI(~0u)},
	{36159, S_028B50_ACCUM_QUAD(~0u)},
	{36170, S_028B50_DONUT_SPLIT(~0u)},
	{36182, S_028B50_TRAP_SPLIT(~0u)},
	/* 1988 */
	{19882, S_028B54_LS_EN(~0u), 3, 1425},
	{19876, S_028B54_HS_EN(~0u)},
	{19870, S_028B54_ES_EN(~0u), 3, 1428},
	{19864, S_028B54_GS_EN(~0u)},
	{19858, S_028B54_VS_EN(~0u), 3, 1431},
	{36316, S_028B54_DYNAMIC_HS(~0u)},
	{18171, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{36327, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{36347, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{36367, S_028B54_VS_WAVE_ID_EN(~0u)},
	{8334, S_028B54_PRIMGEN_EN(~0u)},
	{36381, S_028B54_ORDERED_ID_MODE(~0u)},
	{35839, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{36397, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2002 */
	{36412, S_028B58_NUM_PATCHES(~0u)},
	{36424, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{36440, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 2005 */
	{35859, S_028B5C_ITEMSIZE(~0u)},
	/* 2006 */
	{35859, S_028B60_ITEMSIZE(~0u)},
	/* 2007 */
	{35859, S_028B64_ITEMSIZE(~0u)},
	/* 2008 */
	{35859, S_028B68_ITEMSIZE(~0u)},
	/* 2009 */
	{209, S_028B6C_TYPE(~0u), 3, 1434},
	{36546, S_028B6C_PARTITIONING(~0u), 4, 1437},
	{36623, S_028B6C_TOPOLOGY(~0u), 4, 1441},
	{36632, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{36652, S_028B6C_DEPRECATED(~0u)},
	{36663, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{36685, S_028B6C_DISABLE_DONUTS(~0u)},
	{34539, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 1445},
	{34556, S_028B6C_RDREQ_POLICY(~0u)},
	{36824, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1448},
	{9710, S_028B6C_MTYPE(~0u)},
	/* 2020 */
	{36842, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{36863, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{36885, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{36907, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{36929, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{36951, S_028B70_OFFSET_ROUND(~0u)},
	/* 2026 */
	{36964, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{36992, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 2028 */
	{842, S_028B90_ENABLE(~0u)},
	{18087, S_028B90_CNT(~0u)},
	/* 2030 */
	{37020, S_028B94_STREAMOUT_0_EN(~0u)},
	{37035, S_028B94_STREAMOUT_1_EN(~0u)},
	{37050, S_028B94_STREAMOUT_2_EN(~0u)},
	{37065, S_028B94_STREAMOUT_3_EN(~0u)},
	{37080, S_028B94_RAST_STREAM(~0u)},
	{37092, S_028B94_RAST_STREAM_MASK(~0u)},
	{37109, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	{37130, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	/* 2038 */
	{37150, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{37169, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{37188, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{37207, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 2042 */
	{37226, S_028BD4_DISTANCE_0(~0u)},
	{37237, S_028BD4_DISTANCE_1(~0u)},
	{37248, S_028BD4_DISTANCE_2(~0u)},
	{37259, S_028BD4_DISTANCE_3(~0u)},
	{37270, S_028BD4_DISTANCE_4(~0u)},
	{37281, S_028BD4_DISTANCE_5(~0u)},
	{37292, S_028BD4_DISTANCE_6(~0u)},
	{37303, S_028BD4_DISTANCE_7(~0u)},
	/* 2050 */
	{37314, S_028BD8_DISTANCE_8(~0u)},
	{37325, S_028BD8_DISTANCE_9(~0u)},
	{37336, S_028BD8_DISTANCE_10(~0u)},
	{37348, S_028BD8_DISTANCE_11(~0u)},
	{37360, S_028BD8_DISTANCE_12(~0u)},
	{37372, S_028BD8_DISTANCE_13(~0u)},
	{37384, S_028BD8_DISTANCE_14(~0u)},
	{37396, S_028BD8_DISTANCE_15(~0u)},
	/* 2058 */
	{37408, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{37426, S_028BDC_LAST_PIXEL(~0u)},
	{37437, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{37462, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 2062 */
	{37484, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{37501, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{37523, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{37539, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{37560, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{37583, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2068 */
	{37609, S_028BE4_PIX_CENTER(~0u)},
	{37670, S_028BE4_ROUND_MODE(~0u), 4, 1452},
	{37886, S_028BE4_QUANT_MODE(~0u), 8, 1456},
	/* 2071 */
	{37897, S_028BF8_S0_X(~0u)},
	{37902, S_028BF8_S0_Y(~0u)},
	{37907, S_028BF8_S1_X(~0u)},
	{37912, S_028BF8_S1_Y(~0u)},
	{37917, S_028BF8_S2_X(~0u)},
	{37922, S_028BF8_S2_Y(~0u)},
	{37927, S_028BF8_S3_X(~0u)},
	{37932, S_028BF8_S3_Y(~0u)},
	/* 2079 */
	{37937, S_028BFC_S4_X(~0u)},
	{37942, S_028BFC_S4_Y(~0u)},
	{37947, S_028BFC_S5_X(~0u)},
	{37952, S_028BFC_S5_Y(~0u)},
	{37957, S_028BFC_S6_X(~0u)},
	{37962, S_028BFC_S6_Y(~0u)},
	{37967, S_028BFC_S7_X(~0u)},
	{37972, S_028BFC_S7_Y(~0u)},
	/* 2087 */
	{37977, S_028C00_S8_X(~0u)},
	{37982, S_028C00_S8_Y(~0u)},
	{37987, S_028C00_S9_X(~0u)},
	{37992, S_028C00_S9_Y(~0u)},
	{37997, S_028C00_S10_X(~0u)},
	{38003, S_028C00_S10_Y(~0u)},
	{38009, S_028C00_S11_X(~0u)},
	{38015, S_028C00_S11_Y(~0u)},
	/* 2095 */
	{38021, S_028C04_S12_X(~0u)},
	{38027, S_028C04_S12_Y(~0u)},
	{38033, S_028C04_S13_X(~0u)},
	{38039, S_028C04_S13_Y(~0u)},
	{38045, S_028C04_S14_X(~0u)},
	{38051, S_028C04_S14_Y(~0u)},
	{38057, S_028C04_S15_X(~0u)},
	{38063, S_028C04_S15_Y(~0u)},
	/* 2103 */
	{37897, S_028C08_S0_X(~0u)},
	{37902, S_028C08_S0_Y(~0u)},
	{37907, S_028C08_S1_X(~0u)},
	{37912, S_028C08_S1_Y(~0u)},
	{37917, S_028C08_S2_X(~0u)},
	{37922, S_028C08_S2_Y(~0u)},
	{37927, S_028C08_S3_X(~0u)},
	{37932, S_028C08_S3_Y(~0u)},
	/* 2111 */
	{37937, S_028C0C_S4_X(~0u)},
	{37942, S_028C0C_S4_Y(~0u)},
	{37947, S_028C0C_S5_X(~0u)},
	{37952, S_028C0C_S5_Y(~0u)},
	{37957, S_028C0C_S6_X(~0u)},
	{37962, S_028C0C_S6_Y(~0u)},
	{37967, S_028C0C_S7_X(~0u)},
	{37972, S_028C0C_S7_Y(~0u)},
	/* 2119 */
	{37977, S_028C10_S8_X(~0u)},
	{37982, S_028C10_S8_Y(~0u)},
	{37987, S_028C10_S9_X(~0u)},
	{37992, S_028C10_S9_Y(~0u)},
	{37997, S_028C10_S10_X(~0u)},
	{38003, S_028C10_S10_Y(~0u)},
	{38009, S_028C10_S11_X(~0u)},
	{38015, S_028C10_S11_Y(~0u)},
	/* 2127 */
	{38021, S_028C14_S12_X(~0u)},
	{38027, S_028C14_S12_Y(~0u)},
	{38033, S_028C14_S13_X(~0u)},
	{38039, S_028C14_S13_Y(~0u)},
	{38045, S_028C14_S14_X(~0u)},
	{38051, S_028C14_S14_Y(~0u)},
	{38057, S_028C14_S15_X(~0u)},
	{38063, S_028C14_S15_Y(~0u)},
	/* 2135 */
	{37897, S_028C18_S0_X(~0u)},
	{37902, S_028C18_S0_Y(~0u)},
	{37907, S_028C18_S1_X(~0u)},
	{37912, S_028C18_S1_Y(~0u)},
	{37917, S_028C18_S2_X(~0u)},
	{37922, S_028C18_S2_Y(~0u)},
	{37927, S_028C18_S3_X(~0u)},
	{37932, S_028C18_S3_Y(~0u)},
	/* 2143 */
	{37937, S_028C1C_S4_X(~0u)},
	{37942, S_028C1C_S4_Y(~0u)},
	{37947, S_028C1C_S5_X(~0u)},
	{37952, S_028C1C_S5_Y(~0u)},
	{37957, S_028C1C_S6_X(~0u)},
	{37962, S_028C1C_S6_Y(~0u)},
	{37967, S_028C1C_S7_X(~0u)},
	{37972, S_028C1C_S7_Y(~0u)},
	/* 2151 */
	{37977, S_028C20_S8_X(~0u)},
	{37982, S_028C20_S8_Y(~0u)},
	{37987, S_028C20_S9_X(~0u)},
	{37992, S_028C20_S9_Y(~0u)},
	{37997, S_028C20_S10_X(~0u)},
	{38003, S_028C20_S10_Y(~0u)},
	{38009, S_028C20_S11_X(~0u)},
	{38015, S_028C20_S11_Y(~0u)},
	/* 2159 */
	{38021, S_028C24_S12_X(~0u)},
	{38027, S_028C24_S12_Y(~0u)},
	{38033, S_028C24_S13_X(~0u)},
	{38039, S_028C24_S13_Y(~0u)},
	{38045, S_028C24_S14_X(~0u)},
	{38051, S_028C24_S14_Y(~0u)},
	{38057, S_028C24_S15_X(~0u)},
	{38063, S_028C24_S15_Y(~0u)},
	/* 2167 */
	{37897, S_028C28_S0_X(~0u)},
	{37902, S_028C28_S0_Y(~0u)},
	{37907, S_028C28_S1_X(~0u)},
	{37912, S_028C28_S1_Y(~0u)},
	{37917, S_028C28_S2_X(~0u)},
	{37922, S_028C28_S2_Y(~0u)},
	{37927, S_028C28_S3_X(~0u)},
	{37932, S_028C28_S3_Y(~0u)},
	/* 2175 */
	{37937, S_028C2C_S4_X(~0u)},
	{37942, S_028C2C_S4_Y(~0u)},
	{37947, S_028C2C_S5_X(~0u)},
	{37952, S_028C2C_S5_Y(~0u)},
	{37957, S_028C2C_S6_X(~0u)},
	{37962, S_028C2C_S6_Y(~0u)},
	{37967, S_028C2C_S7_X(~0u)},
	{37972, S_028C2C_S7_Y(~0u)},
	/* 2183 */
	{37977, S_028C30_S8_X(~0u)},
	{37982, S_028C30_S8_Y(~0u)},
	{37987, S_028C30_S9_X(~0u)},
	{37992, S_028C30_S9_Y(~0u)},
	{37997, S_028C30_S10_X(~0u)},
	{38003, S_028C30_S10_Y(~0u)},
	{38009, S_028C30_S11_X(~0u)},
	{38015, S_028C30_S11_Y(~0u)},
	/* 2191 */
	{38021, S_028C34_S12_X(~0u)},
	{38027, S_028C34_S12_Y(~0u)},
	{38033, S_028C34_S13_X(~0u)},
	{38039, S_028C34_S13_Y(~0u)},
	{38045, S_028C34_S14_X(~0u)},
	{38051, S_028C34_S14_Y(~0u)},
	{38057, S_028C34_S15_X(~0u)},
	{38063, S_028C34_S15_Y(~0u)},
	/* 2199 */
	{38069, S_028C38_AA_MASK_X0Y0(~0u)},
	{38082, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2201 */
	{38095, S_028C3C_AA_MASK_X0Y1(~0u)},
	{38108, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2203 */
	{38121, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{18004, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{18026, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2206 */
	{38150, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2207 */
	{38166, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2208 */
	{21978, S_028C64_TILE_MAX(~0u)},
	{38179, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2210 */
	{21978, S_028C68_TILE_MAX(~0u)},
	/* 2211 */
	{20586, S_028C6C_SLICE_START(~0u)},
	{20598, S_028C6C_SLICE_MAX(~0u)},
	{38194, S_028C6C_MIP_LEVEL(~0u)},
	/* 2214 */
	{38255, S_028C70_ENDIAN(~0u), 4, 1464},
	{9248, S_028C70_FORMAT(~0u), 23, 1468},
	{16474, S_028C70_LINEAR_GENERAL(~0u)},
	{38622, S_028C70_NUMBER_TYPE(~0u), 8, 1491},
	{38678, S_028C70_COMP_SWAP(~0u), 4, 1499},
	{29490, S_028C70_FAST_CLEAR(~0u)},
	{21178, S_028C70_COMPRESSION(~0u)},
	{38688, S_028C70_BLEND_CLAMP(~0u)},
	{38700, S_028C70_BLEND_BYPASS(~0u)},
	{38713, S_028C70_SIMPLE_FLOAT(~0u)},
	{37670, S_028C70_ROUND_MODE(~0u)},
	{38726, S_028C70_CMASK_IS_LINEAR(~0u)},
	{38953, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1503},
	{38975, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1503},
	{38999, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{39025, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{39051, S_028C70_DCC_ENABLE(~0u)},
	{39062, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2232 */
	{21806, S_028C74_TILE_MODE_INDEX(~0u)},
	{39078, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{39100, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{21794, S_028C74_NUM_SAMPLES(~0u)},
	{39118, S_028C74_NUM_FRAGMENTS(~0u)},
	{39132, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{39150, S_028C74_MIP0_DEPTH(~0u)},
	{13803, S_028C74_META_LINEAR(~0u)},
	{39161, S_028C74_COLOR_SW_MODE(~0u)},
	{39175, S_028C74_FMASK_SW_MODE(~0u)},
	{39189, S_028C74_RESOURCE_TYPE(~0u), 4, 1511},
	{13838, S_028C74_RB_ALIGNED(~0u)},
	{13820, S_028C74_PIPE_ALIGNED(~0u)},
	/* 2245 */
	{24450, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{39203, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{39220, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{39248, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{39274, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{13932, S_028C78_COLOR_TRANSFORM(~0u)},
	{39300, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{39323, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{39343, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2254 */
	{21978, S_028C80_TILE_MAX(~0u)},
	/* 2255 */
	{21978, S_028C88_TILE_MAX(~0u)},
	/* 2256 */
	{35732, S_03092C_RESET_EN(~0u)},
	{39365, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2258 */
	{39380, S_030944_BASE_HI(~0u)},
	/* 2259 */
	{39380, S_03094C_BASE_HI(~0u)},
	/* 2260 */
	{39380, S_030954_BASE_HI(~0u)},
	/* 2261 */
	{39380, S_03095C_BASE_HI(~0u)},
	/* 2262 */
	{35741, S_030960_PRIMGROUP_SIZE(~0u)},
	{35756, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{35775, S_030960_SWITCH_ON_EOP(~0u)},
	{35789, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{35808, S_030960_SWITCH_ON_EOI(~0u)},
	{35822, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{39388, S_030960_EN_INST_OPT_BASIC(~0u)},
	{39406, S_030960_EN_INST_OPT_ADV(~0u)},
	{39422, S_030960_HW_USE_ONLY(~0u)},
	/* 2271 */
	{39434, S_030D24_DWB(~0u)},
	{21109, S_030D24_DIRTY(~0u)},
	/* 2273 */
	{39438, S_030E08_GRAD_ADJ_0(~0u)},
	{39449, S_030E08_GRAD_ADJ_1(~0u)},
	{39460, S_030E08_GRAD_ADJ_2(~0u)},
	{39471, S_030E08_GRAD_ADJ_3(~0u)},
	/* 2277 */
	{15454, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{15473, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{15492, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{15514, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{15536, S_031100_RSRC_MGMT_RESET(~0u)},
	{39482, S_031100_TTRACE_STALL_ALL(~0u)},
	{39499, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{39517, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{39533, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2286 */
	{15805, S_031104_VTX_DONE_DELAY(~0u)},
	{15820, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{39554, S_031104_BATON_RESET_DISABLE(~0u)},
	{15844, S_031104_PC_LIMIT_ENABLE(~0u)},
	{15860, S_031104_PC_LIMIT_STRICT(~0u)},
	{39574, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{39600, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{39617, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{39633, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{39654, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{15876, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2297 */
	{39675, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{39716, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2299 */
	{17924, S_00B1F0_SCRATCH_EN(~0u)},
	{17935, S_00B1F0_USER_SGPR(~0u)},
	{17945, S_00B1F0_TRAP_PRESENT(~0u)},
	{17996, S_00B1F0_EXCP_EN(~0u)},
	{18077, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{18107, S_00B1F0_OC_LDS_EN(~0u)},
	{17976, S_00B1F0_LDS_SIZE(~0u)},
	{18051, S_00B1F0_SKIP_USGPR0(~0u)},
	{18063, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2308 */
	{18199, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{39755, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2310 */
	{17722, S_00B214_MEM_BASE(~0u)},
	/* 2311 */
	{18199, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2312 */
	{17722, S_00B414_MEM_BASE(~0u)},
	/* 2313 */
	{391, S_00B83C_DATA(~0u)},
	/* 2314 */
	{391, S_00B844_DATA(~0u)},
	/* 2315 */
	{441, S_036028_INDEX(~0u)},
	{14427, S_036028_ALWAYS(~0u)},
	{842, S_036028_ENABLE(~0u)},
	/* 2318 */
	{441, S_03602C_INDEX(~0u)},
	{14427, S_03602C_ALWAYS(~0u)},
	{842, S_03602C_ENABLE(~0u)},
	/* 2321 */
	{441, S_036030_INDEX(~0u)},
	{21616, S_036030_CLEAR(~0u)},
	{842, S_036030_ENABLE(~0u)},
	/* 2324 */
	{441, S_036034_INDEX(~0u)},
	{21616, S_036034_CLEAR(~0u)},
	{842, S_036034_ENABLE(~0u)},
	/* 2327 */
	{441, S_036038_INDEX(~0u)},
	{21616, S_036038_CLEAR(~0u)},
	{842, S_036038_ENABLE(~0u)},
	/* 2330 */
	{39380, S_028018_BASE_HI(~0u)},
	/* 2331 */
	{39780, S_02801C_X_MAX(~0u)},
	{39786, S_02801C_Y_MAX(~0u)},
	/* 2333 */
	{9248, S_028038_FORMAT(~0u)},
	{21794, S_028038_NUM_SAMPLES(~0u)},
	{13608, S_028038_SW_MODE(~0u)},
	{39792, S_028038_PARTIALLY_RESIDENT(~0u)},
	{39811, S_028038_FAULT_BEHAVIOR(~0u)},
	{39826, S_028038_ITERATE_FLUSH(~0u)},
	{39840, S_028038_MAXMIP(~0u)},
	{21822, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{21846, S_028038_ALLOW_EXPCLEAR(~0u)},
	{21861, S_028038_READ_SIZE(~0u)},
	{21871, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{21891, S_028038_CLEAR_DISALLOWED(~0u)},
	{21908, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2346 */
	{9248, S_02803C_FORMAT(~0u)},
	{13608, S_02803C_SW_MODE(~0u)},
	{39792, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{39811, S_02803C_FAULT_BEHAVIOR(~0u)},
	{39826, S_02803C_ITERATE_FLUSH(~0u)},
	{21846, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{21951, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{21891, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2354 */
	{39380, S_028044_BASE_HI(~0u)},
	/* 2355 */
	{39380, S_02804C_BASE_HI(~0u)},
	/* 2356 */
	{39380, S_028054_BASE_HI(~0u)},
	/* 2357 */
	{39380, S_02805C_BASE_HI(~0u)},
	/* 2358 */
	{39856, S_028060_PUNCHOUT_MODE(~0u), 4, 1515},
	{39870, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{39895, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2361 */
	{39913, S_028064_PS_INVOKE_MASK(~0u)},
	/* 2362 */
	{39928, S_028068_EPITCH(~0u)},
	/* 2363 */
	{39928, S_02806C_EPITCH(~0u)},
	/* 2364 */
	{842, S_02835C_ENABLE(~0u)},
	{39935, S_02835C_NUM_SE(~0u)},
	{16311, S_02835C_NUM_RB_PER_SE(~0u)},
	{39942, S_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING(~0u)},
	/* 2368 */
	{39977, S_028360_PERFMON_ENABLE(~0u)},
	/* 2369 */
	{39992, S_0283A0_LEFT_QTR(~0u)},
	{40001, S_0283A0_LEFT_HALF(~0u)},
	{40011, S_0283A0_RIGHT_HALF(~0u)},
	{40022, S_0283A0_RIGHT_QTR(~0u)},
	/* 2373 */
	{39992, S_0283A4_LEFT_QTR(~0u)},
	{40001, S_0283A4_LEFT_HALF(~0u)},
	{40011, S_0283A4_RIGHT_HALF(~0u)},
	{40022, S_0283A4_RIGHT_QTR(~0u)},
	/* 2377 */
	{40032, S_0283A8_TOP_QTR(~0u)},
	{40040, S_0283A8_TOP_HALF(~0u)},
	{40049, S_0283A8_BOT_HALF(~0u)},
	{40058, S_0283A8_BOT_QTR(~0u)},
	/* 2381 */
	{40066, S_0283AC_LEFT_EYE_FOV_LEFT(~0u)},
	{40084, S_0283AC_LEFT_EYE_FOV_RIGHT(~0u)},
	{40103, S_0283AC_RIGHT_EYE_FOV_LEFT(~0u)},
	{40122, S_0283AC_RIGHT_EYE_FOV_RIGHT(~0u)},
	/* 2385 */
	{40142, S_0283B0_FOV_TOP(~0u)},
	{40150, S_0283B0_FOV_BOT(~0u)},
	/* 2387 */
	{39928, S_0287A0_EPITCH(~0u)},
	/* 2388 */
	{39928, S_0287A4_EPITCH(~0u)},
	/* 2389 */
	{39928, S_0287A8_EPITCH(~0u)},
	/* 2390 */
	{39928, S_0287AC_EPITCH(~0u)},
	/* 2391 */
	{39928, S_0287B0_EPITCH(~0u)},
	/* 2392 */
	{39928, S_0287B4_EPITCH(~0u)},
	/* 2393 */
	{39928, S_0287B8_EPITCH(~0u)},
	/* 2394 */
	{39928, S_0287BC_EPITCH(~0u)},
	/* 2395 */
	{40158, S_028834_OBJ_ID_SEL(~0u)},
	{40169, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{40187, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2398 */
	{40206, S_028838_VERTEX_REUSE_OFF(~0u)},
	{40223, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2400 */
	{40247, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{40272, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{40293, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{40315, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{40341, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2405 */
	{40358, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2406 */
	{40381, S_028A98_OBJPRIM_ID_EN(~0u)},
	{40395, S_028A98_EN_REG_RT_INDEX(~0u)},
	{40411, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{40430, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2410 */
	{40448, S_028A9C_COMPOUND_INDEX_EN(~0u)},
	/* 2411 */
	{35674, S_028B9C_EVENT_TYPE(~0u)},
	{8893, S_028B9C_ADDRESS_HI(~0u)},
	{35701, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2414 */
	{40556, S_028C44_BINNING_MODE(~0u), 4, 1519},
	{40569, S_028C44_BIN_SIZE_X(~0u)},
	{40580, S_028C44_BIN_SIZE_Y(~0u)},
	{40591, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{40609, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{40627, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{40650, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{40676, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{40698, S_028C44_FPOVS_PER_BATCH(~0u)},
	{40714, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 2424 */
	{40736, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{40752, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 2426 */
	{40771, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{40788, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{40812, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{40830, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{40855, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{40885, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{40900, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{40915, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{40950, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{40986, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{41030, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{41054, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{41090, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{41126, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{41152, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{41176, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{41196, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{41217, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 2444 */
	{41242, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 2445 */
	{41263, S_028C64_BASE_256B(~0u)},
	/* 2446 */
	{41273, S_028C68_MIP0_HEIGHT(~0u)},
	{41285, S_028C68_MIP0_WIDTH(~0u)},
	{13849, S_028C68_MAX_MIP(~0u)},
	/* 2449 */
	{41263, S_028C80_BASE_256B(~0u)},
	/* 2450 */
	{41263, S_028C88_BASE_256B(~0u)},
	/* 2451 */
	{41263, S_028C98_BASE_256B(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{41296, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{1111, R_371_DST_ADDR_LO},
	{1123, R_372_DST_ADDR_HI},
	{41311, R_3F0_IB_BASE_LO},
	{41322, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{41333, R_410_CP_DMA_WORD0, 1, 9},
	{41346, R_411_CP_DMA_WORD1, 5, 10},
	{41359, R_412_CP_DMA_WORD2, 1, 15},
	{41372, R_413_CP_DMA_WORD3, 1, 16},
	{41385, R_414_COMMAND, 11, 17},
	{41393, R_500_DMA_DATA_WORD0, 4, 28},
	{1000, R_501_SRC_ADDR_LO},
	{1099, R_502_SRC_ADDR_HI},
	{1111, R_503_DST_ADDR_LO},
	{1123, R_504_DST_ADDR_HI},
	{41408, R_000E4C_SRBM_STATUS2, 21, 32},
	{41421, R_000E50_SRBM_STATUS, 20, 53},
	{41433, R_000E54_SRBM_STATUS3, 16, 73},
	{41446, R_00D034_SDMA0_STATUS_REG, 29, 89},
	{41463, R_00D834_SDMA1_STATUS_REG, 29, 89},
	{41480, R_008008_GRBM_STATUS2, 25, 118},
	{41493, R_008010_GRBM_STATUS, 25, 143},
	{41505, R_0084FC_CP_STRMOUT_CNTL, 1, 168},
	{41521, R_0085F0_CP_COHER_CNTL, 19, 169},
	{41535, R_0085F4_CP_COHER_SIZE},
	{41549, R_0085F8_CP_COHER_BASE},
	{41563, R_008014_GRBM_STATUS_SE0, 12, 188},
	{41579, R_008018_GRBM_STATUS_SE1, 12, 200},
	{41595, R_008038_GRBM_STATUS_SE2, 12, 212},
	{41611, R_00803C_GRBM_STATUS_SE3, 12, 224},
	{41505, R_0300FC_CP_STRMOUT_CNTL, 1, 236},
	{41627, R_0301E4_CP_COHER_BASE_HI, 1, 237},
	{41644, R_0301EC_CP_COHER_START_DELAY, 1, 238},
	{41521, R_0301F0_CP_COHER_CNTL, 29, 239},
	{41535, R_0301F4_CP_COHER_SIZE},
	{41549, R_0301F8_CP_COHER_BASE},
	{41665, R_0301FC_CP_COHER_STATUS, 4, 268},
	{41681, R_008210_CP_CPC_STATUS, 17, 272},
	{41695, R_008214_CP_CPC_BUSY_STAT, 28, 289},
	{41712, R_008218_CP_CPC_STALLED_STAT1, 17, 317},
	{41733, R_00821C_CP_CPF_STATUS, 22, 334},
	{41747, R_008220_CP_CPF_BUSY_STAT, 31, 356},
	{41764, R_008224_CP_CPF_STALLED_STAT1, 14, 387},
	{41785, R_030230_CP_COHER_SIZE_HI, 1, 401},
	{41802, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 402},
	{41825, R_0088C4_VGT_CACHE_INVALIDATION, 3, 403},
	{41848, R_0088C8_VGT_ESGS_RING_SIZE},
	{41867, R_0088CC_VGT_GSVS_RING_SIZE},
	{41886, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 406},
	{41906, R_008958_VGT_PRIMITIVE_TYPE, 1, 407},
	{41925, R_00895C_VGT_INDEX_TYPE, 1, 408},
	{41940, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{41973, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{42006, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{42039, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{42072, R_008970_VGT_NUM_INDICES},
	{42088, R_008974_VGT_NUM_INSTANCES},
	{42106, R_008988_VGT_TF_RING_SIZE, 1, 409},
	{42123, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 410},
	{42144, R_0089B8_VGT_TF_MEMORY_BASE},
	{42163, R_008A14_PA_CL_ENHANCE, 4, 411},
	{42177, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 415},
	{42202, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 416},
	{42227, R_008670_CP_STALLED_STAT3, 22, 418},
	{42244, R_008674_CP_STALLED_STAT1, 16, 440},
	{42261, R_008678_CP_STALLED_STAT2, 29, 456},
	{42278, R_008680_CP_STAT, 24, 485},
	{42286, R_030800_GRBM_GFX_INDEX, 6, 509},
	{41848, R_030900_VGT_ESGS_RING_SIZE},
	{41867, R_030904_VGT_GSVS_RING_SIZE},
	{41906, R_030908_VGT_PRIMITIVE_TYPE, 1, 515},
	{41925, R_03090C_VGT_INDEX_TYPE, 2, 516},
	{41940, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{41973, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{42006, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{42039, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{42072, R_030930_VGT_NUM_INDICES},
	{42088, R_030934_VGT_NUM_INSTANCES},
	{42106, R_030938_VGT_TF_RING_SIZE, 1, 518},
	{42123, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 519},
	{42144, R_030940_VGT_TF_MEMORY_BASE},
	{42177, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 521},
	{42202, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 522},
	{42301, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 524},
	{42327, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 526},
	{42353, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 528},
	{42379, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 530},
	{42405, R_008BF0_PA_SC_ENHANCE, 9, 532},
	{42419, R_008C08_SQC_CACHES, 2, 541},
	{42419, R_030D20_SQC_CACHES, 9, 543},
	{42430, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 552},
	{42449, R_008DFC_SQ_EXP_0, 6, 555},
	{42458, R_030E00_TA_CS_BC_BASE_ADDR},
	{42477, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 561},
	{42499, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{42523, R_008F00_SQ_BUF_RSRC_WORD0},
	{42541, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 562},
	{42564, R_008F04_SQ_BUF_RSRC_WORD1, 4, 563},
	{42582, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{42606, R_008F08_SQ_BUF_RSRC_WORD2},
	{42624, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 567},
	{42647, R_008F0C_SQ_BUF_RSRC_WORD3, 17, 568},
	{42665, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{42689, R_008F10_SQ_IMG_RSRC_WORD0},
	{42707, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 585},
	{42730, R_008F14_SQ_IMG_RSRC_WORD1, 12, 586},
	{42748, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{42772, R_008F18_SQ_IMG_RSRC_WORD2, 4, 598},
	{42790, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 602},
	{42813, R_008F1C_SQ_IMG_RSRC_WORD3, 12, 603},
	{42831, R_008F20_SQ_IMG_RSRC_WORD4, 4, 615},
	{42849, R_008F24_SQ_IMG_RSRC_WORD5, 8, 619},
	{42867, R_008F28_SQ_IMG_RSRC_WORD6, 8, 627},
	{42885, R_008F2C_SQ_IMG_RSRC_WORD7},
	{42903, R_008F30_SQ_IMG_SAMP_WORD0, 14, 635},
	{42921, R_008F34_SQ_IMG_SAMP_WORD1, 4, 649},
	{42939, R_008F38_SQ_IMG_SAMP_WORD2, 11, 653},
	{42957, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 664},
	{42975, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 667},
	{42995, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 672},
	{43020, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 674},
	{43045, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 676},
	{43070, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 677},
	{43070, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 678},
	{43089, R_0090F0_SPI_ARB_PRIORITY, 3, 679},
	{43089, R_00C700_SPI_ARB_PRIORITY, 8, 682},
	{43106, R_0090F4_SPI_ARB_CYCLES_0, 2, 690},
	{43123, R_0090F8_SPI_ARB_CYCLES_1, 1, 692},
	{43140, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 693},
	{43162, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 694},
	{43184, R_030FF8_DB_ZPASS_COUNT_LOW},
	{43203, R_030FFC_DB_ZPASS_COUNT_HI, 1, 695},
	{43221, R_009100_SPI_CONFIG_CNTL, 5, 696},
	{43237, R_00913C_SPI_CONFIG_CNTL_1, 5, 701},
	{43255, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 706},
	{42458, R_00950C_TA_CS_BC_BASE_ADDR},
	{43284, R_009858_DB_SUBTILE_CONTROL, 10, 718},
	{43303, R_0098F8_GB_ADDR_CONFIG, 16, 728},
	{43318, R_009910_GB_TILE_MODE0, 10, 744},
	{43332, R_009914_GB_TILE_MODE1, 10, 744},
	{43346, R_009918_GB_TILE_MODE2, 10, 744},
	{43360, R_00991C_GB_TILE_MODE3, 10, 744},
	{43374, R_009920_GB_TILE_MODE4, 10, 744},
	{43388, R_009924_GB_TILE_MODE5, 10, 744},
	{43402, R_009928_GB_TILE_MODE6, 10, 744},
	{43416, R_00992C_GB_TILE_MODE7, 10, 744},
	{43430, R_009930_GB_TILE_MODE8, 10, 744},
	{43444, R_009934_GB_TILE_MODE9, 10, 744},
	{43458, R_009938_GB_TILE_MODE10, 10, 744},
	{43473, R_00993C_GB_TILE_MODE11, 10, 744},
	{43488, R_009940_GB_TILE_MODE12, 10, 744},
	{43503, R_009944_GB_TILE_MODE13, 10, 744},
	{43518, R_009948_GB_TILE_MODE14, 10, 744},
	{43533, R_00994C_GB_TILE_MODE15, 10, 744},
	{43548, R_009950_GB_TILE_MODE16, 10, 744},
	{43563, R_009954_GB_TILE_MODE17, 10, 744},
	{43578, R_009958_GB_TILE_MODE18, 10, 744},
	{43593, R_00995C_GB_TILE_MODE19, 10, 744},
	{43608, R_009960_GB_TILE_MODE20, 10, 744},
	{43623, R_009964_GB_TILE_MODE21, 10, 744},
	{43638, R_009968_GB_TILE_MODE22, 10, 744},
	{43653, R_00996C_GB_TILE_MODE23, 10, 744},
	{43668, R_009970_GB_TILE_MODE24, 10, 744},
	{43683, R_009974_GB_TILE_MODE25, 10, 744},
	{43698, R_009978_GB_TILE_MODE26, 10, 744},
	{43713, R_00997C_GB_TILE_MODE27, 10, 744},
	{43728, R_009980_GB_TILE_MODE28, 10, 744},
	{43743, R_009984_GB_TILE_MODE29, 10, 744},
	{43758, R_009988_GB_TILE_MODE30, 10, 744},
	{43773, R_00998C_GB_TILE_MODE31, 10, 744},
	{43788, R_009990_GB_MACROTILE_MODE0, 4, 754},
	{43807, R_009994_GB_MACROTILE_MODE1, 4, 754},
	{43826, R_009998_GB_MACROTILE_MODE2, 4, 754},
	{43845, R_00999C_GB_MACROTILE_MODE3, 4, 754},
	{43864, R_0099A0_GB_MACROTILE_MODE4, 4, 754},
	{43883, R_0099A4_GB_MACROTILE_MODE5, 4, 754},
	{43902, R_0099A8_GB_MACROTILE_MODE6, 4, 754},
	{43921, R_0099AC_GB_MACROTILE_MODE7, 4, 754},
	{43940, R_0099B0_GB_MACROTILE_MODE8, 4, 754},
	{43959, R_0099B4_GB_MACROTILE_MODE9, 4, 754},
	{43978, R_0099B8_GB_MACROTILE_MODE10, 4, 754},
	{43998, R_0099BC_GB_MACROTILE_MODE11, 4, 754},
	{44018, R_0099C0_GB_MACROTILE_MODE12, 4, 754},
	{44038, R_0099C4_GB_MACROTILE_MODE13, 4, 754},
	{44058, R_0099C8_GB_MACROTILE_MODE14, 4, 754},
	{44078, R_0099CC_GB_MACROTILE_MODE15, 4, 754},
	{44098, R_00B000_SPI_SHADER_TBA_LO_PS},
	{44119, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 758},
	{44140, R_00B008_SPI_SHADER_TMA_LO_PS},
	{44161, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 759},
	{44182, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 760},
	{44206, R_00B020_SPI_SHADER_PGM_LO_PS},
	{44227, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 764},
	{44248, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 12, 765},
	{44272, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 11, 777},
	{44296, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{44322, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{44348, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{44374, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{44400, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{44426, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{44452, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{44478, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{44504, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{44530, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{44556, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{44583, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{44610, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{44637, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{44664, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{44691, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{44718, R_00B100_SPI_SHADER_TBA_LO_VS},
	{44739, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 788},
	{44760, R_00B108_SPI_SHADER_TMA_LO_VS},
	{44781, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 789},
	{44802, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 790},
	{44826, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 794},
	{44851, R_00B120_SPI_SHADER_PGM_LO_VS},
	{44872, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 795},
	{44893, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 13, 796},
	{44917, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 15, 809},
	{44941, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{44967, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{44993, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{45019, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{45045, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{45071, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{45097, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{45123, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{45149, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{45175, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{45201, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{45228, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{45255, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{45282, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{45309, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{45336, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{45363, R_00B200_SPI_SHADER_TBA_LO_GS},
	{45384, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 824},
	{45405, R_00B208_SPI_SHADER_TMA_LO_GS},
	{45426, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 825},
	{45447, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 5, 826},
	{45471, R_00B220_SPI_SHADER_PGM_LO_GS},
	{45492, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 831},
	{45513, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 13, 832},
	{45537, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 10, 845},
	{45561, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{45587, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{45613, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{45639, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{45665, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{45691, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{45717, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{45743, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{45769, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{45795, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{45821, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{45848, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{45875, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{45902, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{45929, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{45956, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{45983, R_00B300_SPI_SHADER_TBA_LO_ES},
	{46004, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 855},
	{46025, R_00B308_SPI_SHADER_TMA_LO_ES},
	{46046, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 856},
	{46067, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 857},
	{46091, R_00B320_SPI_SHADER_PGM_LO_ES},
	{46112, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 861},
	{46133, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 862},
	{46157, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 874},
	{46181, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{46207, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{46233, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{46259, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{46285, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{46311, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{46337, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{46363, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{46389, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{46415, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{46441, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{46468, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{46495, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{46522, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{46549, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{46576, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{46603, R_00B400_SPI_SHADER_TBA_LO_HS},
	{46624, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 881},
	{46645, R_00B408_SPI_SHADER_TMA_LO_HS},
	{46666, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 882},
	{46687, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 5, 883},
	{46711, R_00B420_SPI_SHADER_PGM_LO_HS},
	{46732, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 888},
	{46753, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 12, 889},
	{46777, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 11, 901},
	{46801, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{46827, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{46853, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{46879, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{46905, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{46931, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{46957, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{46983, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{47009, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{47035, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{47061, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{47088, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{47115, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{47142, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{47169, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{47196, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{47223, R_00B500_SPI_SHADER_TBA_LO_LS},
	{47244, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 912},
	{47265, R_00B508_SPI_SHADER_TMA_LO_LS},
	{47286, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 913},
	{47307, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 914},
	{47331, R_00B520_SPI_SHADER_PGM_LO_LS},
	{47352, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 918},
	{47373, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 919},
	{47397, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 930},
	{47421, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{47447, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{47473, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{47499, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{47525, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{47551, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{47577, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{47603, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{47629, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{47655, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{47681, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{47708, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{47735, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{47762, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{47789, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{47816, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{47843, R_00B800_COMPUTE_DISPATCH_INITIATOR, 13, 936},
	{47870, R_00B804_COMPUTE_DIM_X},
	{47884, R_00B808_COMPUTE_DIM_Y},
	{47898, R_00B80C_COMPUTE_DIM_Z},
	{47912, R_00B810_COMPUTE_START_X},
	{47928, R_00B814_COMPUTE_START_Y},
	{47944, R_00B818_COMPUTE_START_Z},
	{47960, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 949},
	{47981, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 951},
	{48002, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 953},
	{48023, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 955},
	{48043, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 956},
	{48071, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 957},
	{48096, R_00B830_COMPUTE_PGM_LO},
	{48111, R_00B834_COMPUTE_PGM_HI, 2, 958},
	{48126, R_00B838_COMPUTE_TBA_LO},
	{48141, R_00B83C_COMPUTE_TBA_HI, 1, 960},
	{48156, R_00B840_COMPUTE_TMA_LO},
	{48171, R_00B844_COMPUTE_TMA_HI, 1, 961},
	{48186, R_00B848_COMPUTE_PGM_RSRC1, 11, 962},
	{48204, R_00B84C_COMPUTE_PGM_RSRC2, 12, 973},
	{48222, R_00B850_COMPUTE_VMID, 1, 985},
	{48235, R_00B854_COMPUTE_RESOURCE_LIMITS, 8, 986},
	{48259, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 994},
	{48290, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 996},
	{48321, R_00B860_COMPUTE_TMPRING_SIZE, 2, 998},
	{48342, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 1000},
	{48373, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 1002},
	{48404, R_00B86C_COMPUTE_RESTART_X},
	{48422, R_00B870_COMPUTE_RESTART_Y},
	{48440, R_00B874_COMPUTE_RESTART_Z},
	{48458, R_00B87C_COMPUTE_MISC_RESERVED, 5, 1004},
	{48480, R_00B880_COMPUTE_DISPATCH_ID},
	{48500, R_00B884_COMPUTE_THREADGROUP_ID},
	{48523, R_00B888_COMPUTE_RELAUNCH, 3, 1009},
	{48540, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{48569, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 1012},
	{48598, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 1013},
	{48627, R_00B900_COMPUTE_USER_DATA_0},
	{48647, R_00B904_COMPUTE_USER_DATA_1},
	{48667, R_00B908_COMPUTE_USER_DATA_2},
	{48687, R_00B90C_COMPUTE_USER_DATA_3},
	{48707, R_00B910_COMPUTE_USER_DATA_4},
	{48727, R_00B914_COMPUTE_USER_DATA_5},
	{48747, R_00B918_COMPUTE_USER_DATA_6},
	{48767, R_00B91C_COMPUTE_USER_DATA_7},
	{48787, R_00B920_COMPUTE_USER_DATA_8},
	{48807, R_00B924_COMPUTE_USER_DATA_9},
	{48827, R_00B928_COMPUTE_USER_DATA_10},
	{48848, R_00B92C_COMPUTE_USER_DATA_11},
	{48869, R_00B930_COMPUTE_USER_DATA_12},
	{48890, R_00B934_COMPUTE_USER_DATA_13},
	{48911, R_00B938_COMPUTE_USER_DATA_14},
	{48932, R_00B93C_COMPUTE_USER_DATA_15},
	{48953, R_00B9FC_COMPUTE_NOWHERE},
	{48969, R_034000_CPG_PERFCOUNTER1_LO},
	{48989, R_034004_CPG_PERFCOUNTER1_HI},
	{49009, R_034008_CPG_PERFCOUNTER0_LO},
	{49029, R_03400C_CPG_PERFCOUNTER0_HI},
	{49049, R_034010_CPC_PERFCOUNTER1_LO},
	{49069, R_034014_CPC_PERFCOUNTER1_HI},
	{49089, R_034018_CPC_PERFCOUNTER0_LO},
	{49109, R_03401C_CPC_PERFCOUNTER0_HI},
	{49129, R_034020_CPF_PERFCOUNTER1_LO},
	{49149, R_034024_CPF_PERFCOUNTER1_HI},
	{49169, R_034028_CPF_PERFCOUNTER0_LO},
	{49189, R_03402C_CPF_PERFCOUNTER0_HI},
	{49209, R_034100_GRBM_PERFCOUNTER0_LO},
	{49230, R_034104_GRBM_PERFCOUNTER0_HI},
	{49251, R_03410C_GRBM_PERFCOUNTER1_LO},
	{49272, R_034110_GRBM_PERFCOUNTER1_HI},
	{49293, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{49317, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{49341, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{49365, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{49389, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{49413, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{49437, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{49461, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{49485, R_034200_WD_PERFCOUNTER0_LO},
	{49504, R_034204_WD_PERFCOUNTER0_HI},
	{49523, R_034208_WD_PERFCOUNTER1_LO},
	{49542, R_03420C_WD_PERFCOUNTER1_HI},
	{49561, R_034210_WD_PERFCOUNTER2_LO},
	{49580, R_034214_WD_PERFCOUNTER2_HI},
	{49599, R_034218_WD_PERFCOUNTER3_LO},
	{49618, R_03421C_WD_PERFCOUNTER3_HI},
	{49637, R_034220_IA_PERFCOUNTER0_LO},
	{49656, R_034224_IA_PERFCOUNTER0_HI},
	{49675, R_034228_IA_PERFCOUNTER1_LO},
	{49694, R_03422C_IA_PERFCOUNTER1_HI},
	{49713, R_034230_IA_PERFCOUNTER2_LO},
	{49732, R_034234_IA_PERFCOUNTER2_HI},
	{49751, R_034238_IA_PERFCOUNTER3_LO},
	{49770, R_03423C_IA_PERFCOUNTER3_HI},
	{49789, R_034240_VGT_PERFCOUNTER0_LO},
	{49809, R_034244_VGT_PERFCOUNTER0_HI},
	{49829, R_034248_VGT_PERFCOUNTER1_LO},
	{49849, R_03424C_VGT_PERFCOUNTER1_HI},
	{49869, R_034250_VGT_PERFCOUNTER2_LO},
	{49889, R_034254_VGT_PERFCOUNTER2_HI},
	{49909, R_034258_VGT_PERFCOUNTER3_LO},
	{49929, R_03425C_VGT_PERFCOUNTER3_HI},
	{49949, R_034400_PA_SU_PERFCOUNTER0_LO},
	{49971, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 1015},
	{49993, R_034408_PA_SU_PERFCOUNTER1_LO},
	{50015, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 1015},
	{50037, R_034410_PA_SU_PERFCOUNTER2_LO},
	{50059, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 1015},
	{50081, R_034418_PA_SU_PERFCOUNTER3_LO},
	{50103, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 1015},
	{50125, R_034500_PA_SC_PERFCOUNTER0_LO},
	{50147, R_034504_PA_SC_PERFCOUNTER0_HI},
	{50169, R_034508_PA_SC_PERFCOUNTER1_LO},
	{50191, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{50213, R_034510_PA_SC_PERFCOUNTER2_LO},
	{50235, R_034514_PA_SC_PERFCOUNTER2_HI},
	{50257, R_034518_PA_SC_PERFCOUNTER3_LO},
	{50279, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{50301, R_034520_PA_SC_PERFCOUNTER4_LO},
	{50323, R_034524_PA_SC_PERFCOUNTER4_HI},
	{50345, R_034528_PA_SC_PERFCOUNTER5_LO},
	{50367, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{50389, R_034530_PA_SC_PERFCOUNTER6_LO},
	{50411, R_034534_PA_SC_PERFCOUNTER6_HI},
	{50433, R_034538_PA_SC_PERFCOUNTER7_LO},
	{50455, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{50477, R_034600_SPI_PERFCOUNTER0_HI},
	{50497, R_034604_SPI_PERFCOUNTER0_LO},
	{50517, R_034608_SPI_PERFCOUNTER1_HI},
	{50537, R_03460C_SPI_PERFCOUNTER1_LO},
	{50557, R_034610_SPI_PERFCOUNTER2_HI},
	{50577, R_034614_SPI_PERFCOUNTER2_LO},
	{50597, R_034618_SPI_PERFCOUNTER3_HI},
	{50617, R_03461C_SPI_PERFCOUNTER3_LO},
	{50637, R_034620_SPI_PERFCOUNTER4_HI},
	{50657, R_034624_SPI_PERFCOUNTER4_LO},
	{50677, R_034628_SPI_PERFCOUNTER5_HI},
	{50697, R_03462C_SPI_PERFCOUNTER5_LO},
	{50717, R_034700_SQ_PERFCOUNTER0_LO},
	{50736, R_034704_SQ_PERFCOUNTER0_HI},
	{50755, R_034708_SQ_PERFCOUNTER1_LO},
	{50774, R_03470C_SQ_PERFCOUNTER1_HI},
	{50793, R_034710_SQ_PERFCOUNTER2_LO},
	{50812, R_034714_SQ_PERFCOUNTER2_HI},
	{50831, R_034718_SQ_PERFCOUNTER3_LO},
	{50850, R_03471C_SQ_PERFCOUNTER3_HI},
	{50869, R_034720_SQ_PERFCOUNTER4_LO},
	{50888, R_034724_SQ_PERFCOUNTER4_HI},
	{50907, R_034728_SQ_PERFCOUNTER5_LO},
	{50926, R_03472C_SQ_PERFCOUNTER5_HI},
	{50945, R_034730_SQ_PERFCOUNTER6_LO},
	{50964, R_034734_SQ_PERFCOUNTER6_HI},
	{50983, R_034738_SQ_PERFCOUNTER7_LO},
	{51002, R_03473C_SQ_PERFCOUNTER7_HI},
	{51021, R_034740_SQ_PERFCOUNTER8_LO},
	{51040, R_034744_SQ_PERFCOUNTER8_HI},
	{51059, R_034748_SQ_PERFCOUNTER9_LO},
	{51078, R_03474C_SQ_PERFCOUNTER9_HI},
	{51097, R_034750_SQ_PERFCOUNTER10_LO},
	{51117, R_034754_SQ_PERFCOUNTER10_HI},
	{51137, R_034758_SQ_PERFCOUNTER11_LO},
	{51157, R_03475C_SQ_PERFCOUNTER11_HI},
	{51177, R_034760_SQ_PERFCOUNTER12_LO},
	{51197, R_034764_SQ_PERFCOUNTER12_HI},
	{51217, R_034768_SQ_PERFCOUNTER13_LO},
	{51237, R_03476C_SQ_PERFCOUNTER13_HI},
	{51257, R_034770_SQ_PERFCOUNTER14_LO},
	{51277, R_034774_SQ_PERFCOUNTER14_HI},
	{51297, R_034778_SQ_PERFCOUNTER15_LO},
	{51317, R_03477C_SQ_PERFCOUNTER15_HI},
	{51337, R_034900_SX_PERFCOUNTER0_LO},
	{51356, R_034904_SX_PERFCOUNTER0_HI},
	{51375, R_034908_SX_PERFCOUNTER1_LO},
	{51394, R_03490C_SX_PERFCOUNTER1_HI},
	{51413, R_034910_SX_PERFCOUNTER2_LO},
	{51432, R_034914_SX_PERFCOUNTER2_HI},
	{51451, R_034918_SX_PERFCOUNTER3_LO},
	{51470, R_03491C_SX_PERFCOUNTER3_HI},
	{51489, R_034A00_GDS_PERFCOUNTER0_LO},
	{51509, R_034A04_GDS_PERFCOUNTER0_HI},
	{51529, R_034A08_GDS_PERFCOUNTER1_LO},
	{51549, R_034A0C_GDS_PERFCOUNTER1_HI},
	{51569, R_034A10_GDS_PERFCOUNTER2_LO},
	{51589, R_034A14_GDS_PERFCOUNTER2_HI},
	{51609, R_034A18_GDS_PERFCOUNTER3_LO},
	{51629, R_034A1C_GDS_PERFCOUNTER3_HI},
	{51649, R_034B00_TA_PERFCOUNTER0_LO},
	{51668, R_034B04_TA_PERFCOUNTER0_HI},
	{51687, R_034B08_TA_PERFCOUNTER1_LO},
	{51706, R_034B0C_TA_PERFCOUNTER1_HI},
	{51725, R_034C00_TD_PERFCOUNTER0_LO},
	{51744, R_034C04_TD_PERFCOUNTER0_HI},
	{51763, R_034C08_TD_PERFCOUNTER1_LO},
	{51782, R_034C0C_TD_PERFCOUNTER1_HI},
	{51801, R_034D00_TCP_PERFCOUNTER0_LO},
	{51821, R_034D04_TCP_PERFCOUNTER0_HI},
	{51841, R_034D08_TCP_PERFCOUNTER1_LO},
	{51861, R_034D0C_TCP_PERFCOUNTER1_HI},
	{51881, R_034D10_TCP_PERFCOUNTER2_LO},
	{51901, R_034D14_TCP_PERFCOUNTER2_HI},
	{51921, R_034D18_TCP_PERFCOUNTER3_LO},
	{51941, R_034D1C_TCP_PERFCOUNTER3_HI},
	{51961, R_034E00_TCC_PERFCOUNTER0_LO},
	{51981, R_034E04_TCC_PERFCOUNTER0_HI},
	{52001, R_034E08_TCC_PERFCOUNTER1_LO},
	{52021, R_034E0C_TCC_PERFCOUNTER1_HI},
	{52041, R_034E10_TCC_PERFCOUNTER2_LO},
	{52061, R_034E14_TCC_PERFCOUNTER2_HI},
	{52081, R_034E18_TCC_PERFCOUNTER3_LO},
	{52101, R_034E1C_TCC_PERFCOUNTER3_HI},
	{52121, R_034E40_TCA_PERFCOUNTER0_LO},
	{52141, R_034E44_TCA_PERFCOUNTER0_HI},
	{52161, R_034E48_TCA_PERFCOUNTER1_LO},
	{52181, R_034E4C_TCA_PERFCOUNTER1_HI},
	{52201, R_034E50_TCA_PERFCOUNTER2_LO},
	{52221, R_034E54_TCA_PERFCOUNTER2_HI},
	{52241, R_034E58_TCA_PERFCOUNTER3_LO},
	{52261, R_034E5C_TCA_PERFCOUNTER3_HI},
	{52281, R_035018_CB_PERFCOUNTER0_LO},
	{52300, R_03501C_CB_PERFCOUNTER0_HI},
	{52319, R_035020_CB_PERFCOUNTER1_LO},
	{52338, R_035024_CB_PERFCOUNTER1_HI},
	{52357, R_035028_CB_PERFCOUNTER2_LO},
	{52376, R_03502C_CB_PERFCOUNTER2_HI},
	{52395, R_035030_CB_PERFCOUNTER3_LO},
	{52414, R_035034_CB_PERFCOUNTER3_HI},
	{52433, R_035100_DB_PERFCOUNTER0_LO},
	{52452, R_035104_DB_PERFCOUNTER0_HI},
	{52471, R_035108_DB_PERFCOUNTER1_LO},
	{52490, R_03510C_DB_PERFCOUNTER1_HI},
	{52509, R_035110_DB_PERFCOUNTER2_LO},
	{52528, R_035114_DB_PERFCOUNTER2_HI},
	{52547, R_035118_DB_PERFCOUNTER3_LO},
	{52566, R_03511C_DB_PERFCOUNTER3_HI},
	{52585, R_035200_RLC_PERFCOUNTER0_LO},
	{52605, R_035204_RLC_PERFCOUNTER0_HI},
	{52625, R_035208_RLC_PERFCOUNTER1_LO},
	{52645, R_03520C_RLC_PERFCOUNTER1_HI},
	{52665, R_036000_CPG_PERFCOUNTER1_SELECT, 8, 1022},
	{52689, R_036004_CPG_PERFCOUNTER0_SELECT1, 6, 1016},
	{52714, R_036008_CPG_PERFCOUNTER0_SELECT, 8, 1022},
	{52738, R_03600C_CPC_PERFCOUNTER1_SELECT, 8, 1054},
	{52762, R_036010_CPC_PERFCOUNTER0_SELECT1, 6, 1030},
	{52787, R_036014_CPF_PERFCOUNTER1_SELECT, 8, 1042},
	{52811, R_036018_CPF_PERFCOUNTER0_SELECT1, 6, 1036},
	{52836, R_03601C_CPF_PERFCOUNTER0_SELECT, 8, 1042},
	{52860, R_036020_CP_PERFMON_CNTL, 4, 1050},
	{52876, R_036024_CPC_PERFCOUNTER0_SELECT, 8, 1054},
	{52900, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 1062},
	{52925, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 1062},
	{52950, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 1084},
	{52978, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 1097},
	{53006, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 1110},
	{53034, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 1123},
	{53062, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1136},
	{53085, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1136},
	{53108, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1136},
	{53131, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1136},
	{53154, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1138},
	{53177, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1138},
	{53200, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1138},
	{53223, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1138},
	{53246, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1143},
	{53270, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1147},
	{53294, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1147},
	{53318, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1147},
	{53342, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1147},
	{53366, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1152},
	{53391, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{53416, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1156},
	{53442, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1157},
	{53468, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1160},
	{53495, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1157},
	{53521, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{53548, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1157},
	{53574, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1157},
	{53600, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1162},
	{53626, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1165},
	{53653, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1162},
	{53679, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1162},
	{53705, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1162},
	{53731, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1162},
	{53757, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1162},
	{53783, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1162},
	{53809, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1162},
	{53835, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 1167},
	{53859, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 1167},
	{53883, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 1167},
	{53907, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 1167},
	{53931, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 1172},
	{53956, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{53981, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{54006, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{54031, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 1167},
	{54055, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 1167},
	{54079, R_036628_SPI_PERFCOUNTER_BINS, 8, 1176},
	{54100, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1184},
	{54123, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1184},
	{54146, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1184},
	{54169, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1184},
	{54192, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1184},
	{54215, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1184},
	{54238, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1184},
	{54261, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1184},
	{54284, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1184},
	{54307, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1184},
	{54330, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1184},
	{54354, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1184},
	{54378, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1184},
	{54402, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1184},
	{54426, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1184},
	{54450, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1184},
	{54474, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1190},
	{54494, R_036784_SQ_PERFCOUNTER_MASK, 2, 1199},
	{54514, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1201},
	{54535, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1202},
	{54558, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1202},
	{54581, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1202},
	{54604, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1202},
	{54627, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1205},
	{54651, R_036914_SX_PERFCOUNTER1_SELECT1},
	{54675, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1207},
	{54699, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1207},
	{54723, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1207},
	{54747, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1207},
	{54771, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1210},
	{54796, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1212},
	{54819, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1217},
	{54843, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1212},
	{54866, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1221},
	{54889, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1226},
	{54913, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1221},
	{54936, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1230},
	{54960, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1235},
	{54985, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1230},
	{55009, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{55034, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1230},
	{55058, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1230},
	{55082, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1239},
	{55106, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1244},
	{55131, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1239},
	{55155, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{55180, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1239},
	{55204, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1239},
	{55228, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1248},
	{55252, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1253},
	{55277, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1248},
	{55301, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{55326, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1248},
	{55350, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1248},
	{55374, R_037000_CB_PERFCOUNTER_FILTER, 12, 1257},
	{55396, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1269},
	{55419, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1274},
	{55443, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1269},
	{55466, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1269},
	{55489, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1269},
	{55512, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1278},
	{55535, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1283},
	{55559, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1278},
	{55582, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{55606, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1278},
	{55629, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1278},
	{55652, R_028000_DB_RENDER_CONTROL, 10, 1287},
	{55670, R_028004_DB_COUNT_CONTROL, 9, 1297},
	{55687, R_028008_DB_DEPTH_VIEW, 5, 1306},
	{55701, R_02800C_DB_RENDER_OVERRIDE, 23, 1311},
	{55720, R_028010_DB_RENDER_OVERRIDE2, 16, 1334},
	{55740, R_028014_DB_HTILE_DATA_BASE},
	{55759, R_028020_DB_DEPTH_BOUNDS_MIN},
	{55779, R_028024_DB_DEPTH_BOUNDS_MAX},
	{55799, R_028028_DB_STENCIL_CLEAR, 1, 1350},
	{55816, R_02802C_DB_DEPTH_CLEAR},
	{55831, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1351},
	{55855, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1353},
	{55879, R_02803C_DB_DEPTH_INFO, 7, 1355},
	{55893, R_028040_DB_Z_INFO, 10, 1362},
	{55903, R_028044_DB_STENCIL_INFO, 6, 1372},
	{55919, R_028048_DB_Z_READ_BASE},
	{55934, R_02804C_DB_STENCIL_READ_BASE},
	{55955, R_028050_DB_Z_WRITE_BASE},
	{55971, R_028054_DB_STENCIL_WRITE_BASE},
	{55993, R_028058_DB_DEPTH_SIZE, 2, 1378},
	{56007, R_02805C_DB_DEPTH_SLICE, 1, 1380},
	{56022, R_028080_TA_BC_BASE_ADDR},
	{56038, R_028084_TA_BC_BASE_ADDR_HI, 1, 1381},
	{56057, R_0281E8_COHER_DEST_BASE_HI_0, 1, 1382},
	{56078, R_0281EC_COHER_DEST_BASE_HI_1, 1, 1383},
	{56099, R_0281F0_COHER_DEST_BASE_HI_2, 1, 1384},
	{56120, R_0281F4_COHER_DEST_BASE_HI_3, 1, 1385},
	{56141, R_0281F8_COHER_DEST_BASE_2},
	{56159, R_0281FC_COHER_DEST_BASE_3},
	{56177, R_028200_PA_SC_WINDOW_OFFSET, 2, 1386},
	{56197, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1388},
	{56221, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1391},
	{56245, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1393},
	{56265, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1394},
	{56285, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1396},
	{56305, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1394},
	{56325, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1396},
	{56345, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1394},
	{56365, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1396},
	{56385, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1394},
	{56405, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1396},
	{56425, R_028230_PA_SC_EDGERULE, 7, 1398},
	{56440, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1405},
	{56469, R_028238_CB_TARGET_MASK, 8, 1407},
	{56484, R_02823C_CB_SHADER_MASK, 8, 1415},
	{56499, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1423},
	{56524, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1426},
	{56549, R_028248_COHER_DEST_BASE_0},
	{56567, R_02824C_COHER_DEST_BASE_1},
	{56585, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1428},
	{56610, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1431},
	{56635, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1428},
	{56660, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1431},
	{56685, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1428},
	{56710, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1431},
	{56735, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1428},
	{56760, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1431},
	{56785, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1428},
	{56810, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1431},
	{56835, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1428},
	{56860, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1431},
	{56885, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1428},
	{56910, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1431},
	{56935, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1428},
	{56960, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1431},
	{56985, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1428},
	{57010, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1431},
	{57035, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1428},
	{57060, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1431},
	{57085, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1428},
	{57111, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1431},
	{57137, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1428},
	{57163, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1431},
	{57189, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1428},
	{57215, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1431},
	{57241, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1428},
	{57267, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1431},
	{57293, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1428},
	{57319, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1431},
	{57345, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1428},
	{57371, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1431},
	{57397, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{57416, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{57435, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{57454, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{57473, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{57492, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{57511, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{57530, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{57549, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{57568, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{57587, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{57606, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{57625, R_028300_PA_SC_VPORT_ZMIN_6},
	{57644, R_028304_PA_SC_VPORT_ZMAX_6},
	{57663, R_028308_PA_SC_VPORT_ZMIN_7},
	{57682, R_02830C_PA_SC_VPORT_ZMAX_7},
	{57701, R_028310_PA_SC_VPORT_ZMIN_8},
	{57720, R_028314_PA_SC_VPORT_ZMAX_8},
	{57739, R_028318_PA_SC_VPORT_ZMIN_9},
	{57758, R_02831C_PA_SC_VPORT_ZMAX_9},
	{57777, R_028320_PA_SC_VPORT_ZMIN_10},
	{57797, R_028324_PA_SC_VPORT_ZMAX_10},
	{57817, R_028328_PA_SC_VPORT_ZMIN_11},
	{57837, R_02832C_PA_SC_VPORT_ZMAX_11},
	{57857, R_028330_PA_SC_VPORT_ZMIN_12},
	{57877, R_028334_PA_SC_VPORT_ZMAX_12},
	{57897, R_028338_PA_SC_VPORT_ZMIN_13},
	{57917, R_02833C_PA_SC_VPORT_ZMAX_13},
	{57937, R_028340_PA_SC_VPORT_ZMIN_14},
	{57957, R_028344_PA_SC_VPORT_ZMAX_14},
	{57977, R_028348_PA_SC_VPORT_ZMIN_15},
	{57997, R_02834C_PA_SC_VPORT_ZMAX_15},
	{58017, R_028350_PA_SC_RASTER_CONFIG, 17, 1433},
	{58037, R_028354_PA_SC_RASTER_CONFIG_1, 5, 1450},
	{58059, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1455},
	{58087, R_028400_VGT_MAX_VTX_INDX},
	{58104, R_028404_VGT_MIN_VTX_INDX},
	{58121, R_028408_VGT_INDX_OFFSET},
	{58137, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{58166, R_028414_CB_BLEND_RED},
	{58179, R_028418_CB_BLEND_GREEN},
	{58194, R_02841C_CB_BLEND_BLUE},
	{58208, R_028420_CB_BLEND_ALPHA},
	{58223, R_028424_CB_DCC_CONTROL, 3, 1457},
	{58238, R_02842C_DB_STENCIL_CONTROL, 6, 1460},
	{58257, R_028430_DB_STENCILREFMASK, 4, 1466},
	{58275, R_028434_DB_STENCILREFMASK_BF, 4, 1470},
	{58296, R_02843C_PA_CL_VPORT_XSCALE},
	{58315, R_028440_PA_CL_VPORT_XOFFSET},
	{58335, R_028444_PA_CL_VPORT_YSCALE},
	{58354, R_028448_PA_CL_VPORT_YOFFSET},
	{58374, R_02844C_PA_CL_VPORT_ZSCALE},
	{58393, R_028450_PA_CL_VPORT_ZOFFSET},
	{58413, R_028454_PA_CL_VPORT_XSCALE_1},
	{58434, R_028458_PA_CL_VPORT_XOFFSET_1},
	{58456, R_02845C_PA_CL_VPORT_YSCALE_1},
	{58477, R_028460_PA_CL_VPORT_YOFFSET_1},
	{58499, R_028464_PA_CL_VPORT_ZSCALE_1},
	{58520, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{58542, R_02846C_PA_CL_VPORT_XSCALE_2},
	{58563, R_028470_PA_CL_VPORT_XOFFSET_2},
	{58585, R_028474_PA_CL_VPORT_YSCALE_2},
	{58606, R_028478_PA_CL_VPORT_YOFFSET_2},
	{58628, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{58649, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{58671, R_028484_PA_CL_VPORT_XSCALE_3},
	{58692, R_028488_PA_CL_VPORT_XOFFSET_3},
	{58714, R_02848C_PA_CL_VPORT_YSCALE_3},
	{58735, R_028490_PA_CL_VPORT_YOFFSET_3},
	{58757, R_028494_PA_CL_VPORT_ZSCALE_3},
	{58778, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{58800, R_02849C_PA_CL_VPORT_XSCALE_4},
	{58821, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{58843, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{58864, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{58886, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{58907, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{58929, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{58950, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{58972, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{58993, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{59015, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{59036, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{59058, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{59079, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{59101, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{59122, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{59144, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{59165, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{59187, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{59208, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{59230, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{59251, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{59273, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{59294, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{59316, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{59337, R_028500_PA_CL_VPORT_XOFFSET_8},
	{59359, R_028504_PA_CL_VPORT_YSCALE_8},
	{59380, R_028508_PA_CL_VPORT_YOFFSET_8},
	{59402, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{59423, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{59445, R_028514_PA_CL_VPORT_XSCALE_9},
	{59466, R_028518_PA_CL_VPORT_XOFFSET_9},
	{59488, R_02851C_PA_CL_VPORT_YSCALE_9},
	{59509, R_028520_PA_CL_VPORT_YOFFSET_9},
	{59531, R_028524_PA_CL_VPORT_ZSCALE_9},
	{59552, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{59574, R_02852C_PA_CL_VPORT_XSCALE_10},
	{59596, R_028530_PA_CL_VPORT_XOFFSET_10},
	{59619, R_028534_PA_CL_VPORT_YSCALE_10},
	{59641, R_028538_PA_CL_VPORT_YOFFSET_10},
	{59664, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{59686, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{59709, R_028544_PA_CL_VPORT_XSCALE_11},
	{59731, R_028548_PA_CL_VPORT_XOFFSET_11},
	{59754, R_02854C_PA_CL_VPORT_YSCALE_11},
	{59776, R_028550_PA_CL_VPORT_YOFFSET_11},
	{59799, R_028554_PA_CL_VPORT_ZSCALE_11},
	{59821, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{59844, R_02855C_PA_CL_VPORT_XSCALE_12},
	{59866, R_028560_PA_CL_VPORT_XOFFSET_12},
	{59889, R_028564_PA_CL_VPORT_YSCALE_12},
	{59911, R_028568_PA_CL_VPORT_YOFFSET_12},
	{59934, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{59956, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{59979, R_028574_PA_CL_VPORT_XSCALE_13},
	{60001, R_028578_PA_CL_VPORT_XOFFSET_13},
	{60024, R_02857C_PA_CL_VPORT_YSCALE_13},
	{60046, R_028580_PA_CL_VPORT_YOFFSET_13},
	{60069, R_028584_PA_CL_VPORT_ZSCALE_13},
	{60091, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{60114, R_02858C_PA_CL_VPORT_XSCALE_14},
	{60136, R_028590_PA_CL_VPORT_XOFFSET_14},
	{60159, R_028594_PA_CL_VPORT_YSCALE_14},
	{60181, R_028598_PA_CL_VPORT_YOFFSET_14},
	{60204, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{60226, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{60249, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{60271, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{60294, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{60316, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{60339, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{60361, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{60384, R_0285BC_PA_CL_UCP_0_X},
	{60398, R_0285C0_PA_CL_UCP_0_Y},
	{60412, R_0285C4_PA_CL_UCP_0_Z},
	{60426, R_0285C8_PA_CL_UCP_0_W},
	{60440, R_0285CC_PA_CL_UCP_1_X},
	{60454, R_0285D0_PA_CL_UCP_1_Y},
	{60468, R_0285D4_PA_CL_UCP_1_Z},
	{60482, R_0285D8_PA_CL_UCP_1_W},
	{60496, R_0285DC_PA_CL_UCP_2_X},
	{60510, R_0285E0_PA_CL_UCP_2_Y},
	{60524, R_0285E4_PA_CL_UCP_2_Z},
	{60538, R_0285E8_PA_CL_UCP_2_W},
	{60552, R_0285EC_PA_CL_UCP_3_X},
	{60566, R_0285F0_PA_CL_UCP_3_Y},
	{60580, R_0285F4_PA_CL_UCP_3_Z},
	{60594, R_0285F8_PA_CL_UCP_3_W},
	{60608, R_0285FC_PA_CL_UCP_4_X},
	{60622, R_028600_PA_CL_UCP_4_Y},
	{60636, R_028604_PA_CL_UCP_4_Z},
	{60650, R_028608_PA_CL_UCP_4_W},
	{60664, R_02860C_PA_CL_UCP_5_X},
	{60678, R_028610_PA_CL_UCP_5_Y},
	{60692, R_028614_PA_CL_UCP_5_Z},
	{60706, R_028618_PA_CL_UCP_5_W},
	{60720, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1474},
	{60740, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1474},
	{60760, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1474},
	{60780, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1474},
	{60800, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1474},
	{60820, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1474},
	{60840, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1474},
	{60860, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1474},
	{60880, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1474},
	{60900, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1474},
	{60920, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1474},
	{60941, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1474},
	{60962, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1474},
	{60983, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1474},
	{61004, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1474},
	{61025, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1474},
	{61046, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1474},
	{61067, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1474},
	{61088, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1474},
	{61109, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1474},
	{61130, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1474},
	{61151, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1474},
	{61172, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1474},
	{61193, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1474},
	{61214, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1474},
	{61235, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1474},
	{61256, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1474},
	{61277, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1474},
	{61298, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1474},
	{61319, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1474},
	{61340, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1474},
	{61361, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1474},
	{61382, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1486},
	{61400, R_0286CC_SPI_PS_INPUT_ENA, 16, 1490},
	{61417, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1506},
	{61435, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1522},
	{61456, R_0286D8_SPI_PS_IN_CONTROL, 7, 1529},
	{61474, R_0286E0_SPI_BARYC_CNTL, 7, 1536},
	{61489, R_0286E8_SPI_TMPRING_SIZE, 2, 1543},
	{61506, R_028704_SPI_WAVE_MGMT_1, 5, 1545},
	{61522, R_028708_SPI_WAVE_MGMT_2, 1, 1550},
	{61538, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1551},
	{61560, R_028710_SPI_SHADER_Z_FORMAT, 1, 1555},
	{61580, R_028714_SPI_SHADER_COL_FORMAT, 8, 1556},
	{61602, R_028754_SX_PS_DOWNCONVERT, 8, 1564},
	{61620, R_028758_SX_BLEND_OPT_EPSILON, 8, 1572},
	{61641, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1580},
	{61662, R_028760_SX_MRT0_BLEND_OPT, 6, 1597},
	{61680, R_028764_SX_MRT1_BLEND_OPT, 6, 1603},
	{61698, R_028768_SX_MRT2_BLEND_OPT, 6, 1609},
	{61716, R_02876C_SX_MRT3_BLEND_OPT, 6, 1615},
	{61734, R_028770_SX_MRT4_BLEND_OPT, 6, 1621},
	{61752, R_028774_SX_MRT5_BLEND_OPT, 6, 1627},
	{61770, R_028778_SX_MRT6_BLEND_OPT, 6, 1633},
	{61788, R_02877C_SX_MRT7_BLEND_OPT, 6, 1639},
	{61806, R_028780_CB_BLEND0_CONTROL, 9, 1645},
	{61824, R_028784_CB_BLEND1_CONTROL, 9, 1645},
	{61842, R_028788_CB_BLEND2_CONTROL, 9, 1645},
	{61860, R_02878C_CB_BLEND3_CONTROL, 9, 1645},
	{61878, R_028790_CB_BLEND4_CONTROL, 9, 1645},
	{61896, R_028794_CB_BLEND5_CONTROL, 9, 1645},
	{61914, R_028798_CB_BLEND6_CONTROL, 9, 1645},
	{61932, R_02879C_CB_BLEND7_CONTROL, 9, 1645},
	{61950, R_0287CC_CS_COPY_STATE, 1, 1654},
	{61964, R_0287D4_PA_CL_POINT_X_RAD},
	{61982, R_0287D8_PA_CL_POINT_Y_RAD},
	{62000, R_0287DC_PA_CL_POINT_SIZE},
	{62017, R_0287E0_PA_CL_POINT_CULL_RAD},
	{62038, R_0287E4_VGT_DMA_BASE_HI, 2, 1655},
	{62054, R_0287E8_VGT_DMA_BASE},
	{62067, R_0287F0_VGT_DRAW_INITIATOR, 8, 1657},
	{62086, R_0287F4_VGT_IMMED_DATA},
	{62101, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1665},
	{62123, R_028800_DB_DEPTH_CONTROL, 10, 1666},
	{62140, R_028804_DB_EQAA, 12, 1676},
	{62148, R_028808_CB_COLOR_CONTROL, 4, 1688},
	{62165, R_02880C_DB_SHADER_CONTROL, 16, 1692},
	{62183, R_028810_PA_CL_CLIP_CNTL, 19, 1708},
	{62199, R_028814_PA_SU_SC_MODE_CNTL, 15, 1727},
	{62218, R_028818_PA_CL_VTE_CNTL, 10, 1742},
	{62233, R_02881C_PA_CL_VS_OUT_CNTL, 28, 1752},
	{62251, R_028820_PA_CL_NANINF_CNTL, 16, 1780},
	{62269, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1796},
	{62293, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{62318, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1800},
	{62341, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 6, 1811},
	{62370, R_028A00_PA_SU_POINT_SIZE, 2, 1817},
	{62387, R_028A04_PA_SU_POINT_MINMAX, 2, 1819},
	{62406, R_028A08_PA_SU_LINE_CNTL, 1, 1821},
	{62422, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1822},
	{62441, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1826},
	{62462, R_028A14_VGT_HOS_CNTL, 1, 1827},
	{62475, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{62498, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{62521, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1828},
	{62541, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1829},
	{62561, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1833},
	{62582, R_028A2C_VGT_GROUP_DECR, 1, 1834},
	{62597, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1835},
	{62619, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1841},
	{62641, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1847},
	{62667, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1855},
	{62693, R_028A40_VGT_GS_MODE, 18, 1863},
	{62705, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 1881},
	{62724, R_028A48_PA_SC_MODE_CNTL_0, 7, 1884},
	{62742, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1891},
	{62760, R_028A50_VGT_ENHANCE},
	{62772, R_028A54_VGT_GS_PER_ES, 1, 1915},
	{62786, R_028A58_VGT_ES_PER_GS, 1, 1916},
	{62800, R_028A5C_VGT_GS_PER_VS, 1, 1917},
	{62814, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1918},
	{62837, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1919},
	{62860, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1920},
	{62883, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1921},
	{62904, R_028A70_IA_ENHANCE},
	{62915, R_028A74_VGT_DMA_SIZE},
	{62928, R_028A78_VGT_DMA_MAX_SIZE},
	{62945, R_028A7C_VGT_DMA_INDEX_TYPE, 10, 1926},
	{62964, R_028A80_WD_ENHANCE},
	{62975, R_028A84_VGT_PRIMITIVEID_EN, 3, 1936},
	{62994, R_028A88_VGT_DMA_NUM_INSTANCES},
	{63016, R_028A8C_VGT_PRIMITIVEID_RESET},
	{63038, R_028A90_VGT_EVENT_INITIATOR, 4, 1939},
	{63058, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1943},
	{63085, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{63110, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{63135, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1944},
	{63154, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1951},
	{63177, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1952},
	{63200, R_028AB4_VGT_REUSE_OFF, 1, 1953},
	{63214, R_028AB8_VGT_VTX_CNT_EN, 1, 1954},
	{63229, R_028ABC_DB_HTILE_SURFACE, 10, 1955},
	{63246, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1965},
	{63273, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1969},
	{63300, R_028AC8_DB_PRELOAD_CONTROL, 4, 1973},
	{63319, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{63345, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1977},
	{63370, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{63398, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{63424, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1978},
	{63449, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{63477, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{63503, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1979},
	{63528, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{63556, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{63582, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1980},
	{63607, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{63635, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{63666, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{63709, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1981},
	{63747, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1982},
	{63767, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1983},
	{63789, R_028B54_VGT_SHADER_STAGES_EN, 14, 1988},
	{63810, R_028B58_VGT_LS_HS_CONFIG, 3, 2002},
	{63827, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 2005},
	{63848, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 2006},
	{63871, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 2007},
	{63894, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 2008},
	{63917, R_028B6C_VGT_TF_PARAM, 11, 2009},
	{63930, R_028B70_DB_ALPHA_TO_MASK, 6, 2020},
	{63947, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{63971, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 2026},
	{64001, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{64025, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{64055, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{64086, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{64115, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{64145, R_028B90_VGT_GS_INSTANCE_CNT, 2, 2028},
	{64165, R_028B94_VGT_STRMOUT_CONFIG, 8, 2030},
	{64184, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 2038},
	{64210, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 2042},
	{64236, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 2050},
	{64262, R_028BDC_PA_SC_LINE_CNTL, 4, 2058},
	{64278, R_028BE0_PA_SC_AA_CONFIG, 6, 2062},
	{64294, R_028BE4_PA_SU_VTX_CNTL, 3, 2068},
	{64309, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{64332, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{64355, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{64378, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{64401, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 2071},
	{64435, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 2079},
	{64469, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 2087},
	{64503, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 2095},
	{64537, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 2103},
	{64571, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 2111},
	{64605, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 2119},
	{64639, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 2127},
	{64673, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 2135},
	{64707, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 2143},
	{64741, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 2151},
	{64775, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 2159},
	{64809, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 2167},
	{64843, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2175},
	{64877, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2183},
	{64911, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2191},
	{64945, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2199},
	{64969, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2201},
	{64993, R_028C40_PA_SC_SHADER_CONTROL, 3, 2203},
	{65014, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2206},
	{65042, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2207},
	{65063, R_028C60_CB_COLOR0_BASE},
	{65078, R_028C64_CB_COLOR0_PITCH, 2, 2208},
	{65094, R_028C68_CB_COLOR0_SLICE, 1, 2210},
	{65110, R_028C6C_CB_COLOR0_VIEW, 3, 2211},
	{65125, R_028C70_CB_COLOR0_INFO, 18, 2214},
	{65140, R_028C74_CB_COLOR0_ATTRIB, 13, 2232},
	{65157, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2245},
	{65179, R_028C7C_CB_COLOR0_CMASK},
	{65195, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2254},
	{65217, R_028C84_CB_COLOR0_FMASK},
	{65233, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2255},
	{65255, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{65277, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{65299, R_028C94_CB_COLOR0_DCC_BASE},
	{65318, R_028C9C_CB_COLOR1_BASE},
	{65333, R_028CA0_CB_COLOR1_PITCH, 2, 2208},
	{65349, R_028CA4_CB_COLOR1_SLICE, 1, 2210},
	{65365, R_028CA8_CB_COLOR1_VIEW, 3, 2211},
	{65380, R_028CAC_CB_COLOR1_INFO, 18, 2214},
	{65395, R_028CB0_CB_COLOR1_ATTRIB, 13, 2232},
	{65412, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2245},
	{65434, R_028CB8_CB_COLOR1_CMASK},
	{65450, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2254},
	{65472, R_028CC0_CB_COLOR1_FMASK},
	{65488, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2255},
	{65510, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{65532, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{65554, R_028CD0_CB_COLOR1_DCC_BASE},
	{65573, R_028CD8_CB_COLOR2_BASE},
	{65588, R_028CDC_CB_COLOR2_PITCH, 2, 2208},
	{65604, R_028CE0_CB_COLOR2_SLICE, 1, 2210},
	{65620, R_028CE4_CB_COLOR2_VIEW, 3, 2211},
	{65635, R_028CE8_CB_COLOR2_INFO, 18, 2214},
	{65650, R_028CEC_CB_COLOR2_ATTRIB, 13, 2232},
	{65667, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2245},
	{65689, R_028CF4_CB_COLOR2_CMASK},
	{65705, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2254},
	{65727, R_028CFC_CB_COLOR2_FMASK},
	{65743, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2255},
	{65765, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{65787, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{65809, R_028D0C_CB_COLOR2_DCC_BASE},
	{65828, R_028D14_CB_COLOR3_BASE},
	{65843, R_028D18_CB_COLOR3_PITCH, 2, 2208},
	{65859, R_028D1C_CB_COLOR3_SLICE, 1, 2210},
	{65875, R_028D20_CB_COLOR3_VIEW, 3, 2211},
	{65890, R_028D24_CB_COLOR3_INFO, 18, 2214},
	{65905, R_028D28_CB_COLOR3_ATTRIB, 13, 2232},
	{65922, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2245},
	{65944, R_028D30_CB_COLOR3_CMASK},
	{65960, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2254},
	{65982, R_028D38_CB_COLOR3_FMASK},
	{65998, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2255},
	{66020, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{66042, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{66064, R_028D48_CB_COLOR3_DCC_BASE},
	{66083, R_028D50_CB_COLOR4_BASE},
	{66098, R_028D54_CB_COLOR4_PITCH, 2, 2208},
	{66114, R_028D58_CB_COLOR4_SLICE, 1, 2210},
	{66130, R_028D5C_CB_COLOR4_VIEW, 3, 2211},
	{66145, R_028D60_CB_COLOR4_INFO, 18, 2214},
	{66160, R_028D64_CB_COLOR4_ATTRIB, 13, 2232},
	{66177, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2245},
	{66199, R_028D6C_CB_COLOR4_CMASK},
	{66215, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2254},
	{66237, R_028D74_CB_COLOR4_FMASK},
	{66253, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2255},
	{66275, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{66297, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{66319, R_028D84_CB_COLOR4_DCC_BASE},
	{66338, R_028D8C_CB_COLOR5_BASE},
	{66353, R_028D90_CB_COLOR5_PITCH, 2, 2208},
	{66369, R_028D94_CB_COLOR5_SLICE, 1, 2210},
	{66385, R_028D98_CB_COLOR5_VIEW, 3, 2211},
	{66400, R_028D9C_CB_COLOR5_INFO, 18, 2214},
	{66415, R_028DA0_CB_COLOR5_ATTRIB, 13, 2232},
	{66432, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2245},
	{66454, R_028DA8_CB_COLOR5_CMASK},
	{66470, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2254},
	{66492, R_028DB0_CB_COLOR5_FMASK},
	{66508, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2255},
	{66530, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{66552, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{66574, R_028DC0_CB_COLOR5_DCC_BASE},
	{66593, R_028DC8_CB_COLOR6_BASE},
	{66608, R_028DCC_CB_COLOR6_PITCH, 2, 2208},
	{66624, R_028DD0_CB_COLOR6_SLICE, 1, 2210},
	{66640, R_028DD4_CB_COLOR6_VIEW, 3, 2211},
	{66655, R_028DD8_CB_COLOR6_INFO, 18, 2214},
	{66670, R_028DDC_CB_COLOR6_ATTRIB, 13, 2232},
	{66687, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2245},
	{66709, R_028DE4_CB_COLOR6_CMASK},
	{66725, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2254},
	{66747, R_028DEC_CB_COLOR6_FMASK},
	{66763, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2255},
	{66785, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{66807, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{66829, R_028DFC_CB_COLOR6_DCC_BASE},
	{66848, R_028E04_CB_COLOR7_BASE},
	{66863, R_028E08_CB_COLOR7_PITCH, 2, 2208},
	{66879, R_028E0C_CB_COLOR7_SLICE, 1, 2210},
	{66895, R_028E10_CB_COLOR7_VIEW, 3, 2211},
	{66910, R_028E14_CB_COLOR7_INFO, 18, 2214},
	{66925, R_028E18_CB_COLOR7_ATTRIB, 13, 2232},
	{66942, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2245},
	{66964, R_028E20_CB_COLOR7_CMASK},
	{66980, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2254},
	{67002, R_028E28_CB_COLOR7_FMASK},
	{67018, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2255},
	{67040, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{67062, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{67084, R_028E38_CB_COLOR7_DCC_BASE},
	{58087, R_030920_VGT_MAX_VTX_INDX},
	{58104, R_030924_VGT_MIN_VTX_INDX},
	{58121, R_030928_VGT_INDX_OFFSET},
	{63058, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2256},
	{67103, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2258},
	{67125, R_030948_WD_POS_BUF_BASE},
	{67141, R_03094C_WD_POS_BUF_BASE_HI, 1, 2259},
	{67160, R_030950_WD_CNTL_SB_BUF_BASE},
	{67180, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2260},
	{67203, R_030958_WD_INDEX_BUF_BASE},
	{67221, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2261},
	{63135, R_030960_IA_MULTI_VGT_PARAM, 9, 2262},
	{67242, R_030964_VGT_OBJECT_ID},
	{67256, R_030968_VGT_INSTANCE_BASE_ID},
	{67277, R_030D24_SQC_WRITEBACK, 2, 2271},
	{67291, R_030E08_TA_GRAD_ADJ_UCONFIG, 4, 2273},
	{43221, R_031100_SPI_CONFIG_CNTL, 9, 2277},
	{43237, R_031104_SPI_CONFIG_CNTL_1, 11, 2286},
	{67311, R_031108_SPI_CONFIG_CNTL_2, 2, 2297},
	{67329, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{67356, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{67383, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{67410, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{67437, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{67464, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{67491, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{67518, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{67545, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{67572, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{67599, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{67626, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{67653, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{67680, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{67707, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{67734, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{67761, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{67788, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{67815, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{67842, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{67869, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{67896, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{67923, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{67950, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{67977, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{68004, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{68031, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{68058, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{68085, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{68112, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{68139, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{68166, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{68193, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2299},
	{68220, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2308},
	{68244, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{68276, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{46091, R_00B210_SPI_SHADER_PGM_LO_ES},
	{46112, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2310},
	{68308, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{68335, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{68362, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{68389, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{68416, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{68443, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{68470, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{68497, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{68524, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{68551, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{68578, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{68605, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{68632, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{68659, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{68686, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{68713, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{68740, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2311},
	{68764, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{68796, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{47331, R_00B410_SPI_SHADER_PGM_LO_LS},
	{47352, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2312},
	{47421, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{47447, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{47473, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{47499, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{47525, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{47551, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{47577, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{47603, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{47629, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{47655, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{47681, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{47708, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{47735, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{47762, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{47789, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{47816, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{68828, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{68855, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{68882, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{68909, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{68936, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{68963, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{68990, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{69017, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{69044, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{69071, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{69098, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{69125, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{69152, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{69179, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{69206, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{69233, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{69260, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{69290, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{69320, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{69350, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{69380, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{69410, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{69440, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{69470, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{69500, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{69530, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{69560, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{69591, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{69622, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{69653, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{69684, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{69715, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{69746, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{69777, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{69808, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{69839, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{69870, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{69901, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{69932, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{69963, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{69994, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{70025, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{70056, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{70087, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{70118, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{70149, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{70180, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{70211, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{70242, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{70271, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 2313},
	{70300, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{70333, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 2314},
	{70366, R_034030_CPF_LATENCY_STATS_DATA},
	{70389, R_034034_CPG_LATENCY_STATS_DATA},
	{70412, R_034038_CPC_LATENCY_STATS_DATA},
	{70435, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2315},
	{70469, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2318},
	{70503, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2321},
	{70528, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2324},
	{70553, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2327},
	{70578, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2330},
	{55993, R_02801C_DB_DEPTH_SIZE, 2, 2331},
	{55893, R_028038_DB_Z_INFO, 13, 2333},
	{55903, R_02803C_DB_STENCIL_INFO, 8, 2346},
	{55919, R_028040_DB_Z_READ_BASE},
	{70600, R_028044_DB_Z_READ_BASE_HI, 1, 2354},
	{55934, R_028048_DB_STENCIL_READ_BASE},
	{70618, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2355},
	{70642, R_028054_DB_Z_WRITE_BASE_HI, 1, 2356},
	{55971, R_028058_DB_STENCIL_WRITE_BASE},
	{70661, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2357},
	{70686, R_028060_DB_DFSM_CONTROL, 3, 2358},
	{70702, R_028064_DB_RENDER_FILTER, 1, 2361},
	{70719, R_028068_DB_Z_INFO2, 1, 2362},
	{70730, R_02806C_DB_STENCIL_INFO2, 1, 2363},
	{70747, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 4, 2364},
	{70776, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2368},
	{70797, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2369},
	{70819, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2373},
	{70840, R_0283A8_PA_SC_HORIZ_GRID, 4, 2377},
	{70857, R_0283AC_PA_SC_FOV_WINDOW_LR, 4, 2381},
	{70877, R_0283B0_PA_SC_FOV_WINDOW_TB, 2, 2385},
	{70897, R_0287A0_CB_MRT0_EPITCH, 1, 2387},
	{70912, R_0287A4_CB_MRT1_EPITCH, 1, 2388},
	{70927, R_0287A8_CB_MRT2_EPITCH, 1, 2389},
	{70942, R_0287AC_CB_MRT3_EPITCH, 1, 2390},
	{70957, R_0287B0_CB_MRT4_EPITCH, 1, 2391},
	{70972, R_0287B4_CB_MRT5_EPITCH, 1, 2392},
	{70987, R_0287B8_CB_MRT6_EPITCH, 1, 2393},
	{71002, R_0287BC_CB_MRT7_EPITCH, 1, 2394},
	{71017, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2395},
	{71039, R_028838_PA_CL_NGG_CNTL, 2, 2398},
	{71054, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2400},
	{71084, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2405},
	{71114, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2406},
	{71136, R_028A9C_VGT_INDEX_PAYLOAD_CNTL, 1, 2410},
	{71159, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2411},
	{71183, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2414},
	{71203, R_028C48_PA_SC_BINNER_CNTL_1, 2, 2424},
	{71223, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 2426},
	{71261, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 2444},
	{71281, R_028C64_CB_COLOR0_BASE_EXT, 1, 2445},
	{71300, R_028C68_CB_COLOR0_ATTRIB2, 3, 2446},
	{71318, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 2449},
	{71343, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 2450},
	{71368, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 2451},
	{71391, R_028CA0_CB_COLOR1_BASE_EXT, 1, 2445},
	{71410, R_028CA4_CB_COLOR1_ATTRIB2},
	{71428, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 2449},
	{71453, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 2450},
	{71478, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 2451},
	{71501, R_028CDC_CB_COLOR2_BASE_EXT, 1, 2445},
	{71520, R_028CE0_CB_COLOR2_ATTRIB2},
	{71538, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 2449},
	{71563, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 2450},
	{71588, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 2451},
	{71611, R_028D18_CB_COLOR3_BASE_EXT, 1, 2445},
	{71630, R_028D1C_CB_COLOR3_ATTRIB2},
	{71648, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 2449},
	{71673, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 2450},
	{71698, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 2451},
	{71721, R_028D54_CB_COLOR4_BASE_EXT, 1, 2445},
	{71740, R_028D58_CB_COLOR4_ATTRIB2},
	{71758, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 2449},
	{71783, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 2450},
	{71808, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 2451},
	{71831, R_028D90_CB_COLOR5_BASE_EXT, 1, 2445},
	{71850, R_028D94_CB_COLOR5_ATTRIB2},
	{71868, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 2449},
	{71893, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 2450},
	{71918, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 2451},
	{71941, R_028DCC_CB_COLOR6_BASE_EXT, 1, 2445},
	{71960, R_028DD0_CB_COLOR6_ATTRIB2},
	{71978, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 2449},
	{72003, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 2450},
	{72028, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 2451},
	{72051, R_028E08_CB_COLOR7_BASE_EXT, 1, 2445},
	{72070, R_028E0C_CB_COLOR7_ATTRIB2},
	{72088, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 2449},
	{72113, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 2450},
	{72138, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 2451},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 441, 436, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"LOAD_CONST_RAM\0" /* 692 */
	"WRITE_CONST_RAM\0" /* 707 */
	"DUMP_CONST_RAM\0" /* 723 */
	"INCREMENT_CE_COUNTER\0" /* 738 */
	"INCREMENT_DE_COUNTER\0" /* 759 */
	"WAIT_ON_CE_COUNTER\0" /* 780 */
	"IT_OPCODE_C\0" /* 799 */
	"CP_DMA\0" /* 811 */
	"DMA_DATA\0" /* 818 */
	"COUNT_INDIRECT_ENABLE\0" /* 842, 827 */
	"DRAW_INDEX_ENABLE\0" /* 849 */
	"PFP\0" /* 867 */
	"CE\0" /* 871 */
	"DE\0" /* 874 */
	"ENGINE_SEL\0" /* 877 */
	"WR_CONFIRM\0" /* 888 */
	"WR_ONE_ADDR\0" /* 906, 899 */
	"MEM_MAPPED_REGISTER\0" /* 922, 911 */
	"MEMORY_SYNC\0" /* 931 */
	"TC_L2\0" /* 943 */
	"GDS\0" /* 949 */
	"RESERVED\0" /* 953 */
	"MEM_ASYNC\0" /* 962 */
	"DST_SEL\0" /* 972 */
	"IB_SIZE\0" /* 980 */
	"CHAIN\0" /* 988 */
	"VALID\0" /* 994 */
	"SRC_ADDR_LO\0" /* 1000 */
	"CP_SYNC\0" /* 1012 */
	"SRC_ADDR\0" /* 1020 */
	"SRC_ADDR_TC_L2\0" /* 1029 */
	"SRC_SEL\0" /* 1044 */
	"ENGINE\0" /* 1052 */
	"DST_ADDR\0" /* 1059 */
	"NOWHERE\0" /* 1068 */
	"DST_ADDR_TC_L2\0" /* 1076 */
	"DSL_SEL\0" /* 1091 */
	"SRC_ADDR_HI\0" /* 1099 */
	"DST_ADDR_LO\0" /* 1111 */
	"DST_ADDR_HI\0" /* 1123 */
	"BYTE_COUNT_GFX6\0" /* 1135 */
	"BYTE_COUNT_GFX9\0" /* 1151 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 1167 */
	"NONE\0" /* 1191 */
	"8_IN_16\0" /* 1196 */
	"8_IN_32\0" /* 1204 */
	"8_IN_64\0" /* 1212 */
	"SRC_SWAP\0" /* 1220 */
	"DST_SWAP\0" /* 1229 */
	"MEMORY\0" /* 1238 */
	"SAS\0" /* 1245 */
	"DAS\0" /* 1249 */
	"INCREMENT\0" /* 1253 */
	"NO_INCREMENT\0" /* 1263 */
	"SAIC\0" /* 1276 */
	"DAIC\0" /* 1281 */
	"RAW_WAIT\0" /* 1286 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 1295 */
	"SDMA_RQ_PENDING\0" /* 1319 */
	"TST_RQ_PENDING\0" /* 1335 */
	"SDMA1_RQ_PENDING\0" /* 1350 */
	"VCE0_RQ_PENDING\0" /* 1367 */
	"VP8_BUSY\0" /* 1383 */
	"SDMA_BUSY\0" /* 1392, 1393 */
	"SDMA1_BUSY\0" /* 1402 */
	"VCE0_BUSY\0" /* 1413 */
	"XDMA_BUSY\0" /* 1423 */
	"CHUB_BUSY\0" /* 1433 */
	"SDMA2_BUSY\0" /* 1443 */
	"SDMA3_BUSY\0" /* 1454 */
	"SAMSCP_BUSY\0" /* 1465, 1469 */
	"ISP_BUSY\0" /* 1477 */
	"VCE1_BUSY\0" /* 1486 */
	"ODE_BUSY\0" /* 1496 */
	"SDMA2_RQ_PENDING\0" /* 1505 */
	"SDMA3_RQ_PENDING\0" /* 1522 */
	"SAMSCP_RQ_PENDING\0" /* 1539 */
	"ISP_RQ_PENDING\0" /* 1557 */
	"VCE1_RQ_PENDING\0" /* 1572 */
	"UVD_RQ_PENDING\0" /* 1588 */
	"SAMMSP_RQ_PENDING\0" /* 1603 */
	"ACP_RQ_PENDING\0" /* 1621 */
	"SMU_RQ_PENDING\0" /* 1636 */
	"GRBM_RQ_PENDING\0" /* 1651 */
	"HI_RQ_PENDING\0" /* 1667 */
	"VMC_BUSY\0" /* 1681 */
	"MCB_BUSY\0" /* 1690, 1691 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1699 */
	"MCC_BUSY\0" /* 1720 */
	"MCD_BUSY\0" /* 1729 */
	"VMC1_BUSY\0" /* 1738 */
	"SEM_BUSY\0" /* 1748 */
	"ACP_BUSY\0" /* 1757 */
	"IH_BUSY\0" /* 1766 */
	"UVD_BUSY\0" /* 1774 */
	"SAMMSP_BUSY\0" /* 1783 */
	"GCATCL2_BUSY\0" /* 1795 */
	"OSATCL2_BUSY\0" /* 1808 */
	"BIF_BUSY\0" /* 1821 */
	"MCC0_BUSY\0" /* 1830 */
	"MCC1_BUSY\0" /* 1840 */
	"MCC2_BUSY\0" /* 1850 */
	"MCC3_BUSY\0" /* 1860 */
	"MCC4_BUSY\0" /* 1870 */
	"MCC5_BUSY\0" /* 1880 */
	"MCC6_BUSY\0" /* 1890 */
	"MCC7_BUSY\0" /* 1900 */
	"MCD0_BUSY\0" /* 1910 */
	"MCD1_BUSY\0" /* 1920 */
	"MCD2_BUSY\0" /* 1930 */
	"MCD3_BUSY\0" /* 1940 */
	"MCD4_BUSY\0" /* 1950 */
	"MCD5_BUSY\0" /* 1960 */
	"MCD6_BUSY\0" /* 1970 */
	"MCD7_BUSY\0" /* 1980 */
	"IDLE\0" /* 1990 */
	"REG_IDLE\0" /* 1995 */
	"RB_EMPTY\0" /* 2004 */
	"RB_FULL\0" /* 2013 */
	"RB_CMD_IDLE\0" /* 2021 */
	"RB_CMD_FULL\0" /* 2033 */
	"IB_CMD_IDLE\0" /* 2045 */
	"IB_CMD_FULL\0" /* 2057 */
	"BLOCK_IDLE\0" /* 2069 */
	"INSIDE_IB\0" /* 2080 */
	"EX_IDLE\0" /* 2090 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 2098 */
	"PACKET_READY\0" /* 2124 */
	"MC_WR_IDLE\0" /* 2137 */
	"SRBM_IDLE\0" /* 2148 */
	"CONTEXT_EMPTY\0" /* 2158 */
	"DELTA_RPTR_FULL\0" /* 2172 */
	"RB_MC_RREQ_IDLE\0" /* 2188 */
	"IB_MC_RREQ_IDLE\0" /* 2204 */
	"MC_RD_IDLE\0" /* 2220 */
	"DELTA_RPTR_EMPTY\0" /* 2231 */
	"MC_RD_RET_STALL\0" /* 2248 */
	"MC_RD_NO_POLL_IDLE\0" /* 2264 */
	"PREV_CMD_IDLE\0" /* 2283 */
	"SEM_IDLE\0" /* 2297 */
	"SEM_REQ_STALL\0" /* 2306 */
	"SEM_RESP_STATE\0" /* 2320 */
	"INT_IDLE\0" /* 2335 */
	"INT_REQ_STALL\0" /* 2344 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2358 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2381 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2404 */
	"ME1PIPE0_RQ_PENDING\0" /* 2427 */
	"ME1PIPE1_RQ_PENDING\0" /* 2447 */
	"ME1PIPE2_RQ_PENDING\0" /* 2467 */
	"ME1PIPE3_RQ_PENDING\0" /* 2487 */
	"ME2PIPE0_RQ_PENDING\0" /* 2507 */
	"ME2PIPE1_RQ_PENDING\0" /* 2527 */
	"ME2PIPE2_RQ_PENDING\0" /* 2547 */
	"ME2PIPE3_RQ_PENDING\0" /* 2567 */
	"RLC_RQ_PENDING\0" /* 2587 */
	"RLC_BUSY\0" /* 2602 */
	"TC_BUSY\0" /* 2611 */
	"TCC_CC_RESIDENT\0" /* 2619 */
	"CPF_BUSY\0" /* 2635 */
	"CPC_BUSY\0" /* 2644 */
	"CPG_BUSY\0" /* 2653 */
	"UTCL2_BUSY\0" /* 2662 */
	"EA_BUSY\0" /* 2673 */
	"RMI_BUSY\0" /* 2681 */
	"UTCL2_RQ_PENDING\0" /* 2690 */
	"CPF_RQ_PENDING\0" /* 2707 */
	"EA_LINK_BUSY\0" /* 2722 */
	"CPAXI_BUSY\0" /* 2735 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2746 */
	"SRBM_RQ_PENDING\0" /* 2769 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2785 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2808 */
	"GDS_DMA_RQ_PENDING\0" /* 2831 */
	"DB_CLEAN\0" /* 2850 */
	"CB_CLEAN\0" /* 2859 */
	"TA_BUSY\0" /* 2868 */
	"GDS_BUSY\0" /* 2876 */
	"WD_BUSY_NO_DMA\0" /* 2885 */
	"VGT_BUSY\0" /* 2900 */
	"IA_BUSY_NO_DMA\0" /* 2909 */
	"IA_BUSY\0" /* 2924 */
	"SX_BUSY\0" /* 2932 */
	"WD_BUSY\0" /* 2940 */
	"SPI_BUSY\0" /* 2948 */
	"BCI_BUSY\0" /* 2957 */
	"SC_BUSY\0" /* 2966 */
	"PA_BUSY\0" /* 2974 */
	"DB_BUSY\0" /* 2982 */
	"CP_COHERENCY_BUSY\0" /* 2990 */
	"GUI_ACTIVE\0" /* 3008 */
	"RSMU_RQ_PENDING\0" /* 3019 */
	"OFFSET_UPDATE_DONE\0" /* 3049, 3035 */
	"DEST_BASE_0_ENA\0" /* 3054 */
	"DEST_BASE_1_ENA\0" /* 3070 */
	"CB0_DEST_BASE_ENA\0" /* 3086 */
	"CB1_DEST_BASE_ENA\0" /* 3104 */
	"CB2_DEST_BASE_ENA\0" /* 3122 */
	"CB3_DEST_BASE_ENA\0" /* 3140 */
	"CB4_DEST_BASE_ENA\0" /* 3158 */
	"CB5_DEST_BASE_ENA\0" /* 3176 */
	"CB6_DEST_BASE_ENA\0" /* 3194 */
	"CB7_DEST_BASE_ENA\0" /* 3212 */
	"DB_DEST_BASE_ENA\0" /* 3230 */
	"DEST_BASE_2_ENA\0" /* 3247 */
	"DEST_BASE_3_ENA\0" /* 3263 */
	"TCL1_ACTION_ENA\0" /* 3279 */
	"TC_ACTION_ENA\0" /* 3295 */
	"CB_ACTION_ENA\0" /* 3309 */
	"DB_ACTION_ENA\0" /* 3323 */
	"SH_KCACHE_ACTION_ENA\0" /* 3337 */
	"SH_ICACHE_ACTION_ENA\0" /* 3358 */
	"COHER_BASE_HI_256B\0" /* 3379 */
	"START_DELAY_COUNT\0" /* 3398 */
	"TC_SD_ACTION_ENA\0" /* 3416 */
	"TC_NC_ACTION_ENA\0" /* 3433 */
	"TCL1_VOL_ACTION_ENA\0" /* 3450 */
	"TC_VOL_ACTION_ENA\0" /* 3470 */
	"TC_WB_ACTION_ENA\0" /* 3488 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3505 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3530 */
	"SH_SD_ACTION_ENA\0" /* 3554 */
	"TC_WC_ACTION_ENA\0" /* 3571 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 3588 */
	"MATCHING_GFX_CNTX\0" /* 3615 */
	"MEID\0" /* 3633 */
	"PHASE1_STATUS\0" /* 3645, 3638 */
	"MEC1_BUSY\0" /* 3652 */
	"MEC2_BUSY\0" /* 3662 */
	"DC0_BUSY\0" /* 3672 */
	"DC1_BUSY\0" /* 3681 */
	"RCIU1_BUSY\0" /* 3690 */
	"RCIU2_BUSY\0" /* 3701 */
	"ROQ1_BUSY\0" /* 3712 */
	"ROQ2_BUSY\0" /* 3722 */
	"TCIU_BUSY\0" /* 3732 */
	"SCRATCH_RAM_BUSY\0" /* 3742 */
	"QU_BUSY\0" /* 3759 */
	"ATCL2IU_BUSY\0" /* 3767 */
	"CPG_CPC_BUSY\0" /* 3780 */
	"CPF_CPC_BUSY\0" /* 3793 */
	"UTCL2IU_BUSY\0" /* 3806 */
	"SAVE_RESTORE_BUSY\0" /* 3819 */
	"MEC1_LOAD_BUSY\0" /* 3837 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3852 */
	"MEC1_MUTEX_BUSY\0" /* 3872 */
	"MEC1_MESSAGE_BUSY\0" /* 3888 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3906 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3926 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3945 */
	"MEC1_TC_BUSY\0" /* 3964 */
	"MEC1_DMA_BUSY\0" /* 3977 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3991 */
	"MEC1_PIPE0_BUSY\0" /* 4015 */
	"MEC1_PIPE1_BUSY\0" /* 4031 */
	"MEC1_PIPE2_BUSY\0" /* 4047 */
	"MEC1_PIPE3_BUSY\0" /* 4063 */
	"MEC2_LOAD_BUSY\0" /* 4079 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 4094 */
	"MEC2_MUTEX_BUSY\0" /* 4114 */
	"MEC2_MESSAGE_BUSY\0" /* 4130 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 4148 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 4168 */
	"MEC2_IB_QUEUE_BUSY\0" /* 4187 */
	"MEC2_TC_BUSY\0" /* 4206 */
	"MEC2_DMA_BUSY\0" /* 4219 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 4233 */
	"MEC2_PIPE0_BUSY\0" /* 4257 */
	"MEC2_PIPE1_BUSY\0" /* 4273 */
	"MEC2_PIPE2_BUSY\0" /* 4289 */
	"MEC2_PIPE3_BUSY\0" /* 4305 */
	"RCIU_TX_FREE_STALL\0" /* 4321 */
	"RCIU_PRIV_VIOLATION\0" /* 4340 */
	"TCIU_TX_FREE_STALL\0" /* 4360 */
	"MEC1_DECODING_PACKET\0" /* 4379 */
	"MEC1_WAIT_ON_RCIU\0" /* 4400 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4418 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4441 */
	"MEC2_DECODING_PACKET\0" /* 4463 */
	"MEC2_WAIT_ON_RCIU\0" /* 4484 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4502 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4525 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4547 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4571 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4595 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 4618 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 4642 */
	"UTCL1_WAITING_ON_TRANS\0" /* 4666 */
	"POST_WPTR_GFX_BUSY\0" /* 4689 */
	"CSF_BUSY\0" /* 4708 */
	"ROQ_ALIGN_BUSY\0" /* 4717 */
	"ROQ_RING_BUSY\0" /* 4732 */
	"ROQ_INDIRECT1_BUSY\0" /* 4746 */
	"ROQ_INDIRECT2_BUSY\0" /* 4765 */
	"ROQ_STATE_BUSY\0" /* 4784 */
	"ROQ_CE_RING_BUSY\0" /* 4799 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4816 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4838 */
	"SEMAPHORE_BUSY\0" /* 4860 */
	"INTERRUPT_BUSY\0" /* 4875 */
	"HQD_BUSY\0" /* 4890 */
	"PRT_BUSY\0" /* 4899 */
	"CPF_GFX_BUSY\0" /* 4908 */
	"CPF_CMP_BUSY\0" /* 4921 */
	"GRBM_CPF_STAT_BUSY\0" /* 4934 */
	"CPC_CPF_BUSY\0" /* 4953 */
	"REG_BUS_FIFO_BUSY\0" /* 4966 */
	"CSF_RING_BUSY\0" /* 4984 */
	"CSF_INDIRECT1_BUSY\0" /* 4998 */
	"CSF_INDIRECT2_BUSY\0" /* 5017 */
	"CSF_STATE_BUSY\0" /* 5036 */
	"CSF_CE_INDR1_BUSY\0" /* 5051 */
	"CSF_CE_INDR2_BUSY\0" /* 5069 */
	"CSF_ARBITER_BUSY\0" /* 5087 */
	"CSF_INPUT_BUSY\0" /* 5104 */
	"OUTSTANDING_READ_TAGS\0" /* 5119 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 5141 */
	"HQD_DISPATCH_BUSY\0" /* 5165 */
	"HQD_IQ_TIMER_BUSY\0" /* 5183 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 5201 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 5222 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 5246 */
	"HQD_MESSAGE_BUSY\0" /* 5272 */
	"HQD_PQ_FETCHER_BUSY\0" /* 5289 */
	"HQD_IB_FETCHER_BUSY\0" /* 5309 */
	"HQD_IQ_FETCHER_BUSY\0" /* 5329 */
	"HQD_EOP_FETCHER_BUSY\0" /* 5349 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5370 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5393 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5414 */
	"HQD_ROQ_EOP_BUSY\0" /* 5433 */
	"HQD_ROQ_IQ_BUSY\0" /* 5450 */
	"HQD_ROQ_PQ_BUSY\0" /* 5466 */
	"HQD_ROQ_IB_BUSY\0" /* 5482 */
	"HQD_WPTR_POLL_BUSY\0" /* 5498 */
	"HQD_PQ_BUSY\0" /* 5517 */
	"HQD_IB_BUSY\0" /* 5529 */
	"RING_FETCHING_DATA\0" /* 5541 */
	"INDR1_FETCHING_DATA\0" /* 5560 */
	"INDR2_FETCHING_DATA\0" /* 5580 */
	"STATE_FETCHING_DATA\0" /* 5600 */
	"TCIU_WAITING_ON_FREE\0" /* 5620 */
	"TCIU_WAITING_ON_TAGS\0" /* 5641 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 5662 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 5689 */
	"RCIU_WAITING_ON_FREE\0" /* 5716 */
	"COHER_SIZE_HI_256B\0" /* 5737 */
	"PRIM_COUNT\0" /* 5756 */
	"VS_NO_EXTRA_BUFFER\0" /* 5767 */
	"STREAMOUT_FULL_FLUSH\0" /* 5786 */
	"ES_LIMIT\0" /* 5810, 5807 */
	"VERT_REUSE\0" /* 5816 */
	"DI_PT_NONE\0" /* 5827 */
	"DI_PT_POINTLIST\0" /* 5838 */
	"DI_PT_LINELIST\0" /* 5854 */
	"DI_PT_LINESTRIP\0" /* 5869 */
	"DI_PT_TRILIST\0" /* 5885 */
	"DI_PT_TRIFAN\0" /* 5899 */
	"DI_PT_TRISTRIP\0" /* 5912 */
	"DI_PT_UNUSED_0\0" /* 5927 */
	"DI_PT_UNUSED_1\0" /* 5942 */
	"DI_PT_PATCH\0" /* 5957 */
	"DI_PT_LINELIST_ADJ\0" /* 5969 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5988 */
	"DI_PT_TRILIST_ADJ\0" /* 6008 */
	"DI_PT_TRISTRIP_ADJ\0" /* 6026 */
	"DI_PT_UNUSED_3\0" /* 6045 */
	"DI_PT_UNUSED_4\0" /* 6060 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 6075 */
	"DI_PT_RECTLIST\0" /* 6097 */
	"DI_PT_LINELOOP\0" /* 6112 */
	"DI_PT_QUADLIST\0" /* 6127 */
	"DI_PT_QUADSTRIP\0" /* 6142 */
	"DI_PT_POLYGON\0" /* 6158 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 6172 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 6199 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 6226 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 6253 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 6280 */
	"DI_PT_2D_LINE_STRIP\0" /* 6304 */
	"DI_PT_2D_TRI_STRIP\0" /* 6324 */
	"PRIM_TYPE\0" /* 6343 */
	"DI_INDEX_SIZE_16_BIT\0" /* 6353 */
	"DI_INDEX_SIZE_32_BIT\0" /* 6374 */
	"OFFCHIP_BUFFERING\0" /* 6395 */
	"CLIP_VTX_REORDER_ENA\0" /* 6413 */
	"NUM_CLIP_SEQ\0" /* 6434 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6447 */
	"VE_NAN_PROC_DISABLE\0" /* 6470 */
	"LINE_STIPPLE_VALUE\0" /* 6490 */
	"CURRENT_PTR\0" /* 6509 */
	"CURRENT_COUNT\0" /* 6521 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6535 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6560 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6598 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6639 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6662 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6685 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6709 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6739 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6768 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6794 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6823 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6848 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6883 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6911 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6941 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6968 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6995 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 7024 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 7053 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 7082 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7110 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 7140 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 7167 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 7195 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 7220 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 7246 */
	"RCIU_STALLED_ON_ME_READ\0" /* 7271 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 7295 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 7320 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 7348 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 7377 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 7403 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 7429 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7456 */
	"PFP_RCIU_READ_PENDING\0" /* 7482 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7504 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7531 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7553 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7577 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7602 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7625 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7652 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7677 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7705 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7730 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7755 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7780 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7809 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7840 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7868 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7895 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7925 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7952, 7971 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7979, 7998 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 8006 */
	"APPEND_ACTIVE_PARTITION\0" /* 8032 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 8056 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 8088 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 8115 */
	"DC_BUSY\0" /* 8141 */
	"PFP_BUSY\0" /* 8149 */
	"MEQ_BUSY\0" /* 8158 */
	"ME_BUSY\0" /* 8167 */
	"QUERY_BUSY\0" /* 8175 */
	"SURFACE_SYNC_BUSY\0" /* 8186 */
	"RCIU_BUSY\0" /* 8204 */
	"CPC_CPG_BUSY\0" /* 8214 */
	"CE_BUSY\0" /* 8227 */
	"INSTANCE_INDEX\0" /* 8235 */
	"SH_INDEX\0" /* 8250 */
	"SE_INDEX\0" /* 8259 */
	"SH_BROADCAST_WRITES\0" /* 8268 */
	"INSTANCE_BROADCAST_WRITES\0" /* 8288 */
	"SE_BROADCAST_WRITES\0" /* 8314 */
	"PRIMGEN_EN\0" /* 8342, 8334 */
	"X_8K_DWORDS\0" /* 8345 */
	"X_4K_DWORDS\0" /* 8357 */
	"X_2K_DWORDS\0" /* 8369 */
	"X_1K_DWORDS\0" /* 8381 */
	"OFFCHIP_GRANULARITY\0" /* 8393 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 8413 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 8439 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8462 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8487 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8518 */
	"DISABLE_SCISSOR_FIX\0" /* 8552 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8572 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8599 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8627 */
	"INST_INVALIDATE\0" /* 8667, 8662 */
	"DATA_INVALIDATE\0" /* 8678 */
	"INVALIDATE_VOLATILE\0" /* 8694 */
	"TARGET_INST\0" /* 8714 */
	"TARGET_DATA\0" /* 8726 */
	"WRITEBACK\0" /* 8738 */
	"VOL\0" /* 8748 */
	"COMPLETE\0" /* 8752 */
	"RET\0" /* 8761 */
	"RUI\0" /* 8765 */
	"RNG\0" /* 8769 */
	"SQ_EXP_MRT\0" /* 8773 */
	"SQ_EXP_MRTZ\0" /* 8784 */
	"SQ_EXP_NULL\0" /* 8796 */
	"SQ_EXP_POS\0" /* 8808 */
	"SQ_EXP_PARAM\0" /* 8819 */
	"TGT\0" /* 8832 */
	"COMPR\0" /* 8836 */
	"VM\0" /* 8842 */
	"SQ_ENC_EXP_FIELD\0" /* 8845 */
	"ENCODING\0" /* 8862 */
	"ADDRESS\0" /* 8871 */
	"COUNT_HI\0" /* 8879 */
	"BASE_ADDRESS_HI\0" /* 8888, 8893 */
	"STRIDE\0" /* 8904 */
	"CACHE_SWIZZLE\0" /* 8911 */
	"SWIZZLE_ENABLE\0" /* 8925 */
	"SQ_SEL_0\0" /* 8940 */
	"SQ_SEL_1\0" /* 8949 */
	"SQ_SEL_RESERVED_0\0" /* 8965, 8958 */
	"SQ_SEL_RESERVED_1\0" /* 8976, 8983 */
	"SQ_SEL_X\0" /* 8994 */
	"SQ_SEL_Y\0" /* 9003 */
	"SQ_SEL_Z\0" /* 9012 */
	"SQ_SEL_W\0" /* 9021 */
	"DST_SEL_X\0" /* 9030 */
	"DST_SEL_Y\0" /* 9040 */
	"DST_SEL_Z\0" /* 9050 */
	"DST_SEL_W\0" /* 9060 */
	"BUF_NUM_FORMAT_UNORM\0" /* 9070 */
	"BUF_NUM_FORMAT_SNORM\0" /* 9091 */
	"BUF_NUM_FORMAT_USCALED\0" /* 9112 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 9135 */
	"BUF_NUM_FORMAT_UINT\0" /* 9158 */
	"BUF_NUM_FORMAT_SINT\0" /* 9178 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 9198 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 9223 */
	"NUM_FORMAT\0" /* 9248, 9244 */
	"BUF_DATA_FORMAT_INVALID\0" /* 9255 */
	"BUF_DATA_FORMAT_8\0" /* 9279 */
	"BUF_DATA_FORMAT_16\0" /* 9297 */
	"BUF_DATA_FORMAT_8_8\0" /* 9316 */
	"BUF_DATA_FORMAT_32\0" /* 9336 */
	"BUF_DATA_FORMAT_16_16\0" /* 9355 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 9377 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 9402 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 9427 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 9454 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 9481 */
	"BUF_DATA_FORMAT_32_32\0" /* 9505 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9527 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9555 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9580 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9608 */
	"DATA_FORMAT\0" /* 9636 */
	"ELEMENT_SIZE\0" /* 9648 */
	"INDEX_STRIDE\0" /* 9661 */
	"ADD_TID_ENABLE\0" /* 9674 */
	"ATC\0" /* 9689 */
	"HASH_ENABLE\0" /* 9693 */
	"HEAP\0" /* 9705 */
	"MTYPE\0" /* 9710 */
	"SQ_RSRC_BUF\0" /* 9716 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9728 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9747 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9766 */
	"USER_VM_ENABLE\0" /* 9785 */
	"USER_VM_MODE\0" /* 9800, 9808 */
	"NV\0" /* 9813 */
	"MIN_LOD\0" /* 9816 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9824 */
	"IMG_DATA_FORMAT_8\0" /* 9848 */
	"IMG_DATA_FORMAT_16\0" /* 9866 */
	"IMG_DATA_FORMAT_8_8\0" /* 9885 */
	"IMG_DATA_FORMAT_32\0" /* 9905 */
	"IMG_DATA_FORMAT_16_16\0" /* 9924 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9946 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9971 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9996 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 10023 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 10050 */
	"IMG_DATA_FORMAT_32_32\0" /* 10074 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 10096 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 10124 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 10149 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 10177 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 10205 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 10227 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 10251 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 10275 */
	"IMG_DATA_FORMAT_8_24\0" /* 10299 */
	"IMG_DATA_FORMAT_24_8\0" /* 10320 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 10341 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 10366 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 10395 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 10420 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 10446 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 10469 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 10493 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 10520 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10548 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10576 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10604 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10626 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10648 */
	"IMG_DATA_FORMAT_BC1\0" /* 10672 */
	"IMG_DATA_FORMAT_BC2\0" /* 10692 */
	"IMG_DATA_FORMAT_BC3\0" /* 10712 */
	"IMG_DATA_FORMAT_BC4\0" /* 10732 */
	"IMG_DATA_FORMAT_BC5\0" /* 10752 */
	"IMG_DATA_FORMAT_BC6\0" /* 10772 */
	"IMG_DATA_FORMAT_BC7\0" /* 10792 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 10812 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 10851 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10890 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10919 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10948 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10977 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 11006 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 11035 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 11064 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 11095 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 11125 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 11156 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 11186 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 11216 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 11247 */
	"IMG_DATA_FORMAT_4_4\0" /* 11278 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 11298 */
	"IMG_DATA_FORMAT_1\0" /* 11320 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 11338 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 11365 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 11389 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 11415 */
	"DATA_FORMAT_GFX6\0" /* 11449 */
	"IMG_NUM_FORMAT_UNORM\0" /* 11466 */
	"IMG_NUM_FORMAT_SNORM\0" /* 11487 */
	"IMG_NUM_FORMAT_USCALED\0" /* 11508 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 11531 */
	"IMG_NUM_FORMAT_UINT\0" /* 11554 */
	"IMG_NUM_FORMAT_SINT\0" /* 11574 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11594 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11619 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11640 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11666 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11686 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11708 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11734 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11755 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11779 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11806 */
	"NUM_FORMAT_GFX6\0" /* 11833 */
	"IMG_DATA_FORMAT_6E4\0" /* 11849 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 11869 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 11897 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 11936 */
	"IMG_DATA_FORMAT_FMASK\0" /* 11975 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 11997 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 12025 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 12053 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 12086 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 12114 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 12142 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 12175 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 12199 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 12226 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 12259 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 12298 */
	"IMG_DATA_FORMAT_S8_16\0" /* 12326 */
	"IMG_DATA_FORMAT_S8_32\0" /* 12348 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 12370 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 12394 */
	"DATA_FORMAT_GFX9\0" /* 12421 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 12438 */
	"IMG_NUM_FORMAT_METADATA\0" /* 12464 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 12488 */
	"NUM_FORMAT_GFX9\0" /* 12514 */
	"IMG_FMASK_8_2_1\0" /* 12530 */
	"IMG_FMASK_8_4_1\0" /* 12546 */
	"IMG_FMASK_8_8_1\0" /* 12562 */
	"IMG_FMASK_8_2_2\0" /* 12578 */
	"IMG_FMASK_8_4_2\0" /* 12594 */
	"IMG_FMASK_8_4_4\0" /* 12610 */
	"IMG_FMASK_16_16_1\0" /* 12626 */
	"IMG_FMASK_16_8_2\0" /* 12644 */
	"IMG_FMASK_32_16_2\0" /* 12661 */
	"IMG_FMASK_32_8_4\0" /* 12679 */
	"IMG_FMASK_32_8_8\0" /* 12696 */
	"IMG_FMASK_64_16_4\0" /* 12713 */
	"IMG_FMASK_64_16_8\0" /* 12731 */
	"NUM_FORMAT_FMASK\0" /* 12749 */
	"IMG_ASTC_2D_4x4\0" /* 12766 */
	"IMG_ASTC_2D_5x4\0" /* 12782 */
	"IMG_ASTC_2D_5x5\0" /* 12798 */
	"IMG_ASTC_2D_6x5\0" /* 12814 */
	"IMG_ASTC_2D_6x6\0" /* 12830 */
	"IMG_ASTC_2D_8x5\0" /* 12846 */
	"IMG_ASTC_2D_8x6\0" /* 12862 */
	"IMG_ASTC_2D_8x8\0" /* 12878 */
	"IMG_ASTC_2D_10x5\0" /* 12894 */
	"IMG_ASTC_2D_10x6\0" /* 12911 */
	"IMG_ASTC_2D_10x8\0" /* 12928 */
	"IMG_ASTC_2D_10x10\0" /* 12945 */
	"IMG_ASTC_2D_12x10\0" /* 12963 */
	"IMG_ASTC_2D_12x12\0" /* 12981 */
	"NUM_FORMAT_ASTC_2D\0" /* 13015, 12999 */
	"IMG_ASTC_3D_3x3x3\0" /* 13018 */
	"IMG_ASTC_3D_4x3x3\0" /* 13036 */
	"IMG_ASTC_3D_4x4x3\0" /* 13054 */
	"IMG_ASTC_3D_4x4x4\0" /* 13072 */
	"IMG_ASTC_3D_5x4x4\0" /* 13090 */
	"IMG_ASTC_3D_5x5x4\0" /* 13108 */
	"IMG_ASTC_3D_5x5x5\0" /* 13126 */
	"IMG_ASTC_3D_6x5x5\0" /* 13144 */
	"IMG_ASTC_3D_6x6x5\0" /* 13162 */
	"IMG_ASTC_3D_6x6x6\0" /* 13180 */
	"NUM_FORMAT_ASTC_3D\0" /* 13214, 13198 */
	"META_DIRECT\0" /* 13217 */
	"WIDTH\0" /* 13229 */
	"HEIGHT\0" /* 13235 */
	"PERF_MOD\0" /* 13242 */
	"INTERLACED\0" /* 13251 */
	"BASE_LEVEL\0" /* 13262 */
	"LAST_LEVEL\0" /* 13273 */
	"TILING_INDEX\0" /* 13284 */
	"POW2_PAD\0" /* 13297 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 13306 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 13325 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 13344 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 13363 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 13382 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 13401 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 13420 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 13439 */
	"SQ_RSRC_IMG_1D\0" /* 13458, 13470 */
	"SQ_RSRC_IMG_2D\0" /* 13473 */
	"SQ_RSRC_IMG_3D\0" /* 13488 */
	"SQ_RSRC_IMG_CUBE\0" /* 13503 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 13520 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 13541 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 13562 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 13582 */
	"SW_MODE\0" /* 13608 */
	"DEPTH\0" /* 13616 */
	"PITCH_GFX6\0" /* 13622 */
	"PITCH_GFX9\0" /* 13633 */
	"BC_SWIZZLE_XYZW\0" /* 13644 */
	"BC_SWIZZLE_XWYZ\0" /* 13660 */
	"BC_SWIZZLE_WZYX\0" /* 13676 */
	"BC_SWIZZLE_WXYZ\0" /* 13692 */
	"BC_SWIZZLE_ZYXW\0" /* 13708 */
	"BC_SWIZZLE_YXWZ\0" /* 13724 */
	"BC_SWIZZLE\0" /* 13740 */
	"BASE_ARRAY\0" /* 13751 */
	"LAST_ARRAY\0" /* 13762 */
	"ARRAY_PITCH\0" /* 13773 */
	"META_DATA_ADDRESS\0" /* 13785 */
	"META_LINEAR\0" /* 13808, 13803 */
	"META_PIPE_ALIGNED\0" /* 13820, 13815 */
	"META_RB_ALIGNED\0" /* 13833, 13838 */
	"MAX_MIP\0" /* 13849 */
	"MIN_LOD_WARN\0" /* 13857 */
	"COUNTER_BANK_ID\0" /* 13870 */
	"LOD_HDW_CNT_EN\0" /* 13886 */
	"COMPRESSION_EN\0" /* 13901 */
	"ALPHA_IS_ON_MSB\0" /* 13916 */
	"COLOR_TRANSFORM\0" /* 13932 */
	"LOST_ALPHA_BITS\0" /* 13948 */
	"LOST_COLOR_BITS\0" /* 13964 */
	"SQ_TEX_WRAP\0" /* 13980 */
	"SQ_TEX_MIRROR\0" /* 13992 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 14006 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 14030 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 14060 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 14085 */
	"SQ_TEX_CLAMP_BORDER\0" /* 14116 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 14136 */
	"CLAMP_X\0" /* 14162 */
	"CLAMP_Y\0" /* 14170 */
	"CLAMP_Z\0" /* 14178 */
	"MAX_ANISO_RATIO\0" /* 14186 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 14202 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 14229 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 14255 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 14282 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 14313 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 14342 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 14372 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 14427, 14406 */
	"DEPTH_COMPARE_FUNC\0" /* 14434 */
	"FORCE_UNNORMALIZED\0" /* 14453 */
	"ANISO_THRESHOLD\0" /* 14472 */
	"MC_COORD_TRUNC\0" /* 14488 */
	"FORCE_DEGAMMA\0" /* 14503 */
	"ANISO_BIAS\0" /* 14517 */
	"TRUNC_COORD\0" /* 14528 */
	"DISABLE_CUBE_WRAP\0" /* 14540 */
	"FILTER_MODE\0" /* 14558 */
	"COMPAT_MODE\0" /* 14570 */
	"MAX_LOD\0" /* 14582 */
	"PERF_MIP\0" /* 14590 */
	"PERF_Z\0" /* 14599 */
	"LOD_BIAS\0" /* 14606 */
	"LOD_BIAS_SEC\0" /* 14615 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 14642, 14628 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 14651 */
	"XY_MAG_FILTER\0" /* 14677 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 14691 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 14720 */
	"XY_MIN_FILTER\0" /* 14752 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 14766 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 14787 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 14809 */
	"Z_FILTER\0" /* 14832 */
	"MIP_FILTER\0" /* 14841 */
	"MIP_POINT_PRECLAMP\0" /* 14852 */
	"DISABLE_LSB_CEIL\0" /* 14871 */
	"FILTER_PREC_FIX\0" /* 14888 */
	"ANISO_OVERRIDE\0" /* 14904 */
	"BLEND_ZERO_PRT\0" /* 14919 */
	"BORDER_COLOR_PTR\0" /* 14934 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 14951 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 14983 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 15016 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 15049 */
	"BORDER_COLOR_TYPE\0" /* 15078 */
	"SKIP_DEGAMMA\0" /* 15096 */
	"VS_LOW_THRESHOLD\0" /* 15109 */
	"GS_LOW_THRESHOLD\0" /* 15126 */
	"ES_LOW_THRESHOLD\0" /* 15143 */
	"HS_LOW_THRESHOLD\0" /* 15160 */
	"LS_LOW_THRESHOLD\0" /* 15177 */
	"PS_CU_EN\0" /* 15194, 15197 */
	"VS_CU_EN\0" /* 15203 */
	"GS_CU_EN\0" /* 15212 */
	"ES_CU_EN\0" /* 15221 */
	"LSHS_CU_EN\0" /* 15230 */
	"MAX_WAVE_ID\0" /* 15241 */
	"X_R0\0" /* 15253 */
	"RING_ORDER_TS0\0" /* 15258 */
	"RING_ORDER_TS1\0" /* 15273 */
	"RING_ORDER_TS2\0" /* 15288 */
	"PIPE_ORDER_TS0\0" /* 15303 */
	"PIPE_ORDER_TS1\0" /* 15318 */
	"PIPE_ORDER_TS2\0" /* 15333 */
	"PIPE_ORDER_TS3\0" /* 15348 */
	"TS0_DUR_MULT\0" /* 15363 */
	"TS1_DUR_MULT\0" /* 15376 */
	"TS2_DUR_MULT\0" /* 15389 */
	"TS3_DUR_MULT\0" /* 15402 */
	"TS0_DURATION\0" /* 15415 */
	"TS1_DURATION\0" /* 15428 */
	"TS2_DURATION\0" /* 15441 */
	"GPR_WRITE_PRIORITY\0" /* 15464, 15454 */
	"EXP_PRIORITY_ORDER\0" /* 15473 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 15492 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 15514 */
	"RSRC_MGMT_RESET\0" /* 15536 */
	"X_DELAY_14_CLKS\0" /* 15552 */
	"X_DELAY_16_CLKS\0" /* 15568 */
	"X_DELAY_18_CLKS\0" /* 15584 */
	"X_DELAY_20_CLKS\0" /* 15600 */
	"X_DELAY_22_CLKS\0" /* 15616 */
	"X_DELAY_24_CLKS\0" /* 15632 */
	"X_DELAY_26_CLKS\0" /* 15648 */
	"X_DELAY_28_CLKS\0" /* 15664 */
	"X_DELAY_30_CLKS\0" /* 15680 */
	"X_DELAY_32_CLKS\0" /* 15696 */
	"X_DELAY_34_CLKS\0" /* 15712 */
	"X_DELAY_4_CLKS\0" /* 15728 */
	"X_DELAY_6_CLKS\0" /* 15743 */
	"X_DELAY_8_CLKS\0" /* 15758 */
	"X_DELAY_10_CLKS\0" /* 15773 */
	"X_DELAY_12_CLKS\0" /* 15789 */
	"VTX_DONE_DELAY\0" /* 15805 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 15820 */
	"PC_LIMIT_ENABLE\0" /* 15844 */
	"PC_LIMIT_STRICT\0" /* 15860 */
	"PC_LIMIT_SIZE\0" /* 15876 */
	"TYPE_A\0" /* 15890 */
	"VGPR_A\0" /* 15897 */
	"SGPR_A\0" /* 15904 */
	"LDS_A\0" /* 15911 */
	"WAVES_A\0" /* 15917 */
	"EN_A\0" /* 15925 */
	"TYPE_B\0" /* 15930 */
	"VGPR_B\0" /* 15937 */
	"SGPR_B\0" /* 15944 */
	"LDS_B\0" /* 15951 */
	"WAVES_B\0" /* 15957 */
	"EN_B\0" /* 15965 */
	"MSAA1_X\0" /* 15970 */
	"MSAA1_Y\0" /* 15978 */
	"MSAA2_X\0" /* 15986 */
	"MSAA2_Y\0" /* 15994 */
	"MSAA4_X\0" /* 16002 */
	"MSAA4_Y\0" /* 16010 */
	"MSAA8_X\0" /* 16018 */
	"MSAA8_Y\0" /* 16026 */
	"MSAA16_X\0" /* 16034 */
	"MSAA16_Y\0" /* 16043 */
	"NUM_PIPES\0" /* 16052 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 16062 */
	"BANK_INTERLEAVE_SIZE\0" /* 16088 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 16109 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 16133 */
	"NUM_GPUS_GFX6\0" /* 16157 */
	"MULTI_GPU_TILE_SIZE\0" /* 16171 */
	"ROW_SIZE\0" /* 16191 */
	"NUM_LOWER_PIPES\0" /* 16200 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 16216 */
	"MAX_COMPRESSED_FRAGS\0" /* 16242 */
	"NUM_BANKS\0" /* 16263 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 16273 */
	"NUM_GPUS_GFX9\0" /* 16297 */
	"NUM_RB_PER_SE\0" /* 16311 */
	"SE_ENABLE\0" /* 16325 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 16335 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 16366 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 16394 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 16423 */
	"MICRO_TILE_MODE\0" /* 16452 */
	"ARRAY_LINEAR_GENERAL\0" /* 16474, 16468 */
	"ARRAY_LINEAR_ALIGNED\0" /* 16489 */
	"ARRAY_1D_TILED_THIN1\0" /* 16510 */
	"ARRAY_1D_TILED_THICK\0" /* 16531 */
	"ARRAY_2D_TILED_THIN1\0" /* 16552 */
	"ARRAY_2D_TILED_THICK\0" /* 16573 */
	"ARRAY_2D_TILED_XTHICK\0" /* 16594 */
	"ARRAY_3D_TILED_THIN1\0" /* 16616 */
	"ARRAY_3D_TILED_THICK\0" /* 16637 */
	"ARRAY_3D_TILED_XTHICK\0" /* 16658 */
	"ARRAY_POWER_SAVE\0" /* 16680 */
	"ARRAY_MODE\0" /* 16697 */
	"ADDR_SURF_P2\0" /* 16708 */
	"ADDR_SURF_P2_RESERVED0\0" /* 16721 */
	"ADDR_SURF_P2_RESERVED1\0" /* 16744 */
	"ADDR_SURF_P2_RESERVED2\0" /* 16780, 16767 */
	"X_ADDR_SURF_P4_8X16\0" /* 16790 */
	"X_ADDR_SURF_P4_16X16\0" /* 16810 */
	"X_ADDR_SURF_P4_16X32\0" /* 16831 */
	"X_ADDR_SURF_P4_32X32\0" /* 16852 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 16873 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 16899 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 16925 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 16951 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 16978 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 17005 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 17032 */
	"PIPE_CONFIG\0" /* 17059 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 17071 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 17096 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 17122 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 17148 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 17174 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 17199 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 17224 */
	"TILE_SPLIT\0" /* 17249 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 17260 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 17283 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 17306 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 17329 */
	"BANK_WIDTH\0" /* 17352 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 17363 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 17387 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 17411 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 17435 */
	"BANK_HEIGHT\0" /* 17459 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 17471 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 17496 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 17521 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 17546 */
	"MACRO_TILE_ASPECT\0" /* 17571 */
	"ADDR_SURF_2_BANK\0" /* 17589 */
	"ADDR_SURF_4_BANK\0" /* 17606 */
	"ADDR_SURF_8_BANK\0" /* 17623 */
	"ADDR_SURF_16_BANK\0" /* 17640 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 17658 */
	"MICRO_TILE_MODE_NEW\0" /* 17689 */
	"SAMPLE_SPLIT\0" /* 17709 */
	"MEM_BASE\0" /* 17722 */
	"WAVE_LIMIT\0" /* 17731 */
	"LOCK_LOW_THRESHOLD\0" /* 17742 */
	"SIMD_DISABLE\0" /* 17761 */
	"VGPRS\0" /* 17774 */
	"SGPRS\0" /* 17780 */
	"FP_32_DENORMS\0" /* 17786 */
	"FP_64_DENORMS\0" /* 17800 */
	"FP_ALL_DENORMS\0" /* 17814 */
	"FLOAT_MODE\0" /* 17829 */
	"PRIV\0" /* 17840 */
	"DX10_CLAMP\0" /* 17845 */
	"DEBUG_MODE\0" /* 17856 */
	"IEEE_MODE\0" /* 17867 */
	"CU_GROUP_DISABLE\0" /* 17877 */
	"CACHE_CTL\0" /* 17894 */
	"CDBG_USER\0" /* 17904 */
	"FP16_OVFL\0" /* 17914 */
	"SCRATCH_EN\0" /* 17924 */
	"USER_SGPR\0" /* 17935 */
	"TRAP_PRESENT\0" /* 17945 */
	"WAVE_CNT_EN\0" /* 17958 */
	"EXTRA_LDS_SIZE\0" /* 17976, 17970 */
	"EXCP_EN_SI\0" /* 17985 */
	"EXCP_EN\0" /* 17996 */
	"LOAD_COLLISION_WAVEID\0" /* 18004 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 18026 */
	"SKIP_USGPR0\0" /* 18051 */
	"USER_SGPR_MSB\0" /* 18063 */
	"VGPR_COMP_CNT\0" /* 18077, 18087 */
	"CU_GROUP_ENABLE\0" /* 18091 */
	"OC_LDS_EN\0" /* 18107 */
	"SO_BASE0_EN\0" /* 18117 */
	"SO_BASE1_EN\0" /* 18129 */
	"SO_BASE2_EN\0" /* 18141 */
	"SO_BASE3_EN\0" /* 18153 */
	"SO_EN\0" /* 18165 */
	"DISPATCH_DRAW_EN\0" /* 18171 */
	"PC_BASE_EN\0" /* 18188 */
	"GROUP_FIFO_DEPTH\0" /* 18199 */
	"GS_VGPR_COMP_CNT\0" /* 18216 */
	"ES_VGPR_COMP_CNT\0" /* 18233 */
	"LS_VGPR_COMP_CNT\0" /* 18250 */
	"TG_SIZE_EN\0" /* 18267 */
	"EXCP_EN_CIK_VI\0" /* 18278 */
	"COMPUTE_SHADER_EN\0" /* 18293 */
	"PARTIAL_TG_EN\0" /* 18311 */
	"FORCE_START_AT_000\0" /* 18325 */
	"ORDERED_APPEND_ENBL\0" /* 18344 */
	"ORDERED_APPEND_MODE\0" /* 18364 */
	"USE_THREAD_DIMENSIONS\0" /* 18384 */
	"ORDER_MODE\0" /* 18406 */
	"DISPATCH_CACHE_CNTL\0" /* 18417 */
	"SCALAR_L1_INV_VOL\0" /* 18437 */
	"VECTOR_L1_INV_VOL\0" /* 18455 */
	"DATA_ATC\0" /* 18473 */
	"RESTORE\0" /* 18482 */
	"NUM_THREAD_FULL\0" /* 18490 */
	"NUM_THREAD_PARTIAL\0" /* 18506 */
	"PIPELINESTAT_ENABLE\0" /* 18525 */
	"PERFCOUNT_ENABLE\0" /* 18545 */
	"INST_ATC\0" /* 18562 */
	"BULKY\0" /* 18571 */
	"TGID_X_EN\0" /* 18577 */
	"TGID_Y_EN\0" /* 18587 */
	"TGID_Z_EN\0" /* 18597 */
	"TIDIG_COMP_CNT\0" /* 18607 */
	"EXCP_EN_MSB\0" /* 18622 */
	"WAVES_PER_SH_SI\0" /* 18634 */
	"WAVES_PER_SH\0" /* 18650 */
	"TG_PER_CU\0" /* 18663 */
	"LOCK_THRESHOLD\0" /* 18673 */
	"SIMD_DEST_CNTL\0" /* 18688 */
	"FORCE_SIMD_DIST\0" /* 18703 */
	"CU_GROUP_COUNT\0" /* 18719 */
	"SH0_CU_EN\0" /* 18734 */
	"SH1_CU_EN\0" /* 18744 */
	"WAVES\0" /* 18754 */
	"WAVESIZE\0" /* 18760 */
	"SEND_SEID\0" /* 18769 */
	"RESERVED3\0" /* 18779 */
	"RESERVED4\0" /* 18789 */
	"WAVE_ID_BASE\0" /* 18799 */
	"PAYLOAD\0" /* 18812 */
	"IS_EVENT\0" /* 18820 */
	"IS_STATE\0" /* 18829 */
	"PERFCOUNTER_HI\0" /* 18838 */
	"PERF_SEL2\0" /* 18853 */
	"PERF_SEL3\0" /* 18863 */
	"CNTR_SEL2\0" /* 18873 */
	"CNTR_SEL3\0" /* 18883 */
	"CNTR_MODE3\0" /* 18893 */
	"CNTR_MODE2\0" /* 18904 */
	"PERF_SEL\0" /* 18915 */
	"PERF_SEL1\0" /* 18924 */
	"CNTR_MODE\0" /* 18934 */
	"CNTR_SEL0\0" /* 18944 */
	"CNTR_SEL1\0" /* 18954 */
	"SPM_MODE\0" /* 18964 */
	"CNTR_MODE1\0" /* 18973 */
	"CNTR_MODE0\0" /* 18984 */
	"DISABLE_AND_RESET\0" /* 18995 */
	"START_COUNTING\0" /* 19013 */
	"STOP_COUNTING\0" /* 19028 */
	"PERFMON_STATE\0" /* 19042 */
	"SPM_PERFMON_STATE\0" /* 19056 */
	"PERFMON_ENABLE_MODE\0" /* 19074 */
	"PERFMON_SAMPLE_ENABLE\0" /* 19094 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 19116 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 19143 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 19170 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 19197 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 19223 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 19249 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 19276 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 19302 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 19328 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 19356 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 19382 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 19408 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 19434 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 19460 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 19487 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 19514 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 19541 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 19567 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 19593 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 19622 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 19648 */
	"PERF_MODE\0" /* 19675 */
	"PERF_MODE1\0" /* 19685 */
	"PERF_MODE3\0" /* 19696 */
	"PERF_MODE2\0" /* 19707 */
	"PERF_SEID_IGNORE_MASK\0" /* 19718 */
	"BIN0_MIN\0" /* 19740 */
	"BIN0_MAX\0" /* 19749 */
	"BIN1_MIN\0" /* 19758 */
	"BIN1_MAX\0" /* 19767 */
	"BIN2_MIN\0" /* 19776 */
	"BIN2_MAX\0" /* 19785 */
	"BIN3_MIN\0" /* 19794 */
	"BIN3_MAX\0" /* 19803 */
	"SQC_BANK_MASK\0" /* 19812 */
	"SQC_CLIENT_MASK\0" /* 19826 */
	"SIMD_MASK\0" /* 19842 */
	"PS_EN\0" /* 19852 */
	"VS_EN\0" /* 19858 */
	"GS_EN\0" /* 19864 */
	"ES_EN\0" /* 19870 */
	"HS_EN\0" /* 19876 */
	"LS_EN\0" /* 19882 */
	"CS_EN\0" /* 19888 */
	"CNTR_RATE\0" /* 19894 */
	"DISABLE_FLUSH\0" /* 19904 */
	"SH0_MASK\0" /* 19918 */
	"SH1_MASK\0" /* 19927 */
	"FORCE_EN\0" /* 19936 */
	"PERFCOUNTER_SELECT\0" /* 19945 */
	"PERFCOUNTER_SELECT1\0" /* 19964 */
	"PERFCOUNTER_SELECT2\0" /* 19984 */
	"PERFCOUNTER_SELECT3\0" /* 20004 */
	"OP_FILTER_ENABLE\0" /* 20024 */
	"OP_FILTER_SEL\0" /* 20041 */
	"FORMAT_FILTER_ENABLE\0" /* 20055 */
	"FORMAT_FILTER_SEL\0" /* 20076 */
	"CLEAR_FILTER_ENABLE\0" /* 20094 */
	"CLEAR_FILTER_SEL\0" /* 20114 */
	"MRT_FILTER_ENABLE\0" /* 20131 */
	"MRT_FILTER_SEL\0" /* 20149 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 20164 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 20190 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 20213 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 20241 */
	"DEPTH_CLEAR_ENABLE\0" /* 20266 */
	"STENCIL_CLEAR_ENABLE\0" /* 20285 */
	"DEPTH_COPY\0" /* 20306 */
	"STENCIL_COPY\0" /* 20317 */
	"RESUMMARIZE_ENABLE\0" /* 20330 */
	"STENCIL_COMPRESS_DISABLE\0" /* 20349 */
	"DEPTH_COMPRESS_DISABLE\0" /* 20374 */
	"COPY_CENTROID\0" /* 20397 */
	"COPY_SAMPLE\0" /* 20411 */
	"DECOMPRESS_ENABLE\0" /* 20423 */
	"ZPASS_INCREMENT_DISABLE\0" /* 20441 */
	"PERFECT_ZPASS_COUNTS\0" /* 20465 */
	"SAMPLE_RATE\0" /* 20486 */
	"ZPASS_ENABLE\0" /* 20498 */
	"ZFAIL_ENABLE\0" /* 20511 */
	"SFAIL_ENABLE\0" /* 20524 */
	"DBFAIL_ENABLE\0" /* 20537 */
	"SLICE_EVEN_ENABLE\0" /* 20551 */
	"SLICE_ODD_ENABLE\0" /* 20569 */
	"SLICE_START\0" /* 20586 */
	"SLICE_MAX\0" /* 20598 */
	"Z_READ_ONLY\0" /* 20608 */
	"STENCIL_READ_ONLY\0" /* 20620 */
	"MIPID\0" /* 20638 */
	"FORCE_OFF\0" /* 20644 */
	"FORCE_ENABLE\0" /* 20654 */
	"FORCE_DISABLE\0" /* 20667 */
	"FORCE_RESERVED\0" /* 20681 */
	"FORCE_HIZ_ENABLE\0" /* 20696, 20704 */
	"FORCE_HIS_ENABLE0\0" /* 20713, 20723 */
	"FORCE_HIS_ENABLE1\0" /* 20731, 20741 */
	"FORCE_SHADER_Z_ORDER\0" /* 20762, 20749 */
	"FAST_Z_DISABLE\0" /* 20770 */
	"FAST_STENCIL_DISABLE\0" /* 20785 */
	"NOOP_CULL_DISABLE\0" /* 20806 */
	"FORCE_COLOR_KILL\0" /* 20824 */
	"FORCE_Z_READ\0" /* 20841 */
	"FORCE_STENCIL_READ\0" /* 20854 */
	"FORCE_FULL_Z_RANGE\0" /* 20873 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 20892 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 20916 */
	"IGNORE_SC_ZRANGE\0" /* 20939 */
	"DISABLE_FULLY_COVERED\0" /* 20956 */
	"FORCE_SUMM_OFF\0" /* 20978 */
	"FORCE_SUMM_MINZ\0" /* 20993 */
	"FORCE_SUMM_MAXZ\0" /* 21009 */
	"FORCE_SUMM_BOTH\0" /* 21025 */
	"FORCE_Z_LIMIT_SUMM\0" /* 21041 */
	"MAX_TILES_IN_DTT\0" /* 21060 */
	"DISABLE_TILE_RATE_TILES\0" /* 21077 */
	"FORCE_Z_DIRTY\0" /* 21101, 21109 */
	"FORCE_STENCIL_DIRTY\0" /* 21115 */
	"FORCE_Z_VALID\0" /* 21135 */
	"FORCE_STENCIL_VALID\0" /* 21149 */
	"PRESERVE_COMPRESSION\0" /* 21169, 21178 */
	"PSLC_AUTO\0" /* 21190 */
	"PSLC_ON_HANG_ONLY\0" /* 21200 */
	"PSLC_ASAP\0" /* 21218 */
	"PSLC_COUNTDOWN\0" /* 21228 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 21243 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 21272 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 21303 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 21339 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 21374 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 21402 */
	"DISABLE_REG_SNOOP\0" /* 21424 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 21442 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 21474 */
	"HIZ_ZFUNC\0" /* 21504, 21500 */
	"HIS_SFUNC_FF\0" /* 21510 */
	"HIS_SFUNC_BF\0" /* 21523 */
	"PRESERVE_ZRANGE\0" /* 21536 */
	"PRESERVE_SRESULTS\0" /* 21552 */
	"DISABLE_FAST_PASS\0" /* 21570 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 21588 */
	"CLEAR\0" /* 21616 */
	"TL_X\0" /* 21622 */
	"TL_Y\0" /* 21627 */
	"BR_X\0" /* 21632 */
	"BR_Y\0" /* 21637 */
	"ADDR5_SWIZZLE_MASK\0" /* 21642 */
	"ARRAY_PRT_TILED_THIN1\0" /* 21661 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 21683 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 21708 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 21735 */
	"Z_INVALID\0" /* 21763 */
	"Z_16\0" /* 21773 */
	"Z_24\0" /* 21778 */
	"Z_32_FLOAT\0" /* 21783 */
	"NUM_SAMPLES\0" /* 21794 */
	"TILE_MODE_INDEX\0" /* 21806 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 21822 */
	"ALLOW_EXPCLEAR\0" /* 21846 */
	"READ_SIZE\0" /* 21861 */
	"TILE_SURFACE_ENABLE\0" /* 21871 */
	"CLEAR_DISALLOWED\0" /* 21891 */
	"ZRANGE_PRECISION\0" /* 21908 */
	"STENCIL_INVALID\0" /* 21925 */
	"STENCIL_8\0" /* 21941 */
	"TILE_STENCIL_DISABLE\0" /* 21951 */
	"PITCH_TILE_MAX\0" /* 21978, 21972 */
	"HEIGHT_TILE_MAX\0" /* 21987 */
	"SLICE_TILE_MAX\0" /* 22003 */
	"DEST_BASE_HI_256B\0" /* 22018 */
	"WINDOW_X_OFFSET\0" /* 22043, 22036 */
	"WINDOW_Y_OFFSET\0" /* 22059, 22052 */
	"WINDOW_OFFSET_DISABLE\0" /* 22068 */
	"CLIP_RULE\0" /* 22090 */
	"ER_TRI\0" /* 22100 */
	"ER_RECT\0" /* 22107 */
	"ER_LINE_LR\0" /* 22115 */
	"ER_LINE_RL\0" /* 22126 */
	"ER_LINE_TB\0" /* 22137 */
	"ER_LINE_BT\0" /* 22148 */
	"HW_SCREEN_OFFSET_X\0" /* 22159 */
	"HW_SCREEN_OFFSET_Y\0" /* 22178 */
	"TARGET0_ENABLE\0" /* 22197 */
	"TARGET1_ENABLE\0" /* 22212 */
	"TARGET2_ENABLE\0" /* 22227 */
	"TARGET3_ENABLE\0" /* 22242 */
	"TARGET4_ENABLE\0" /* 22257 */
	"TARGET5_ENABLE\0" /* 22272 */
	"TARGET6_ENABLE\0" /* 22287 */
	"TARGET7_ENABLE\0" /* 22302 */
	"OUTPUT0_ENABLE\0" /* 22317 */
	"OUTPUT1_ENABLE\0" /* 22332 */
	"OUTPUT2_ENABLE\0" /* 22347 */
	"OUTPUT3_ENABLE\0" /* 22362 */
	"OUTPUT4_ENABLE\0" /* 22377 */
	"OUTPUT5_ENABLE\0" /* 22392 */
	"OUTPUT6_ENABLE\0" /* 22407 */
	"OUTPUT7_ENABLE\0" /* 22422 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 22437 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 22460 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 22483 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 22506 */
	"RB_MAP_PKR0\0" /* 22529 */
	"RB_MAP_PKR1\0" /* 22541 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 22553 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 22578 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 22603 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 22628 */
	"RB_XSEL2\0" /* 22653 */
	"RB_XSEL\0" /* 22662 */
	"RB_YSEL\0" /* 22670 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 22678 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 22702 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 22726 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 22750 */
	"PKR_MAP\0" /* 22774 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 22782 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 22807 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 22832 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 22857 */
	"PKR_XSEL\0" /* 22882 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 22891 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 22916 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 22941 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 22966 */
	"PKR_YSEL\0" /* 22991 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 23000 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 23026 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 23052 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 23078 */
	"PKR_XSEL2\0" /* 23104 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 23114 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 23137 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 23160 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 23183 */
	"SC_MAP\0" /* 23206 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 23213 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 23247 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 23282 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 23317 */
	"SC_XSEL\0" /* 23352 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 23360 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 23394 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 23429 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 23464 */
	"SC_YSEL\0" /* 23499 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 23507 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 23530 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 23553 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 23576 */
	"SE_MAP\0" /* 23599 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 23606 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 23640 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 23675 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 23710 */
	"SE_XSEL_GFX6\0" /* 23745 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 23758 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 23792 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 23827 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 23862 */
	"SE_YSEL_GFX6\0" /* 23897 */
	"SE_XSEL_GFX9\0" /* 23910 */
	"SE_YSEL_GFX9\0" /* 23923 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 23936 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 23964 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 23992 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 24020 */
	"SE_PAIR_MAP\0" /* 24048 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 24060 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 24099 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 24139 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 24179 */
	"SE_PAIR_XSEL_GFX6\0" /* 24219 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 24237 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 24276 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 24316 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 24356 */
	"SE_PAIR_YSEL_GFX6\0" /* 24396 */
	"SE_PAIR_XSEL_GFX9\0" /* 24414 */
	"SE_PAIR_YSEL_GFX9\0" /* 24432 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 24450 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 24477 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 24516 */
	"STENCIL_KEEP\0" /* 24545 */
	"STENCIL_ZERO\0" /* 24558 */
	"STENCIL_ONES\0" /* 24571 */
	"STENCIL_REPLACE_TEST\0" /* 24584 */
	"STENCIL_REPLACE_OP\0" /* 24605 */
	"STENCIL_ADD_CLAMP\0" /* 24624 */
	"STENCIL_SUB_CLAMP\0" /* 24642 */
	"STENCIL_INVERT\0" /* 24660 */
	"STENCIL_ADD_WRAP\0" /* 24675 */
	"STENCIL_SUB_WRAP\0" /* 24692 */
	"STENCIL_AND\0" /* 24709 */
	"STENCIL_OR\0" /* 24721 */
	"STENCIL_XOR\0" /* 24732 */
	"STENCIL_NAND\0" /* 24744 */
	"STENCIL_NOR\0" /* 24757 */
	"STENCIL_XNOR\0" /* 24769 */
	"STENCILFAIL\0" /* 24782 */
	"STENCILZPASS\0" /* 24794 */
	"STENCILZFAIL\0" /* 24807 */
	"STENCILFAIL_BF\0" /* 24820 */
	"STENCILZPASS_BF\0" /* 24835 */
	"STENCILZFAIL_BF\0" /* 24851 */
	"STENCILTESTVAL\0" /* 24867 */
	"STENCILMASK\0" /* 24882 */
	"STENCILWRITEMASK\0" /* 24894 */
	"STENCILOPVAL\0" /* 24911 */
	"STENCILTESTVAL_BF\0" /* 24924 */
	"STENCILMASK_BF\0" /* 24942 */
	"STENCILWRITEMASK_BF\0" /* 24957 */
	"STENCILOPVAL_BF\0" /* 24977 */
	"X_0_0F\0" /* 24993 */
	"DEFAULT_VAL\0" /* 25000 */
	"FLAT_SHADE\0" /* 25012 */
	"CYL_WRAP\0" /* 25023 */
	"PT_SPRITE_TEX\0" /* 25032 */
	"DUP\0" /* 25046 */
	"FP16_INTERP_MODE\0" /* 25050 */
	"USE_DEFAULT_ATTR1\0" /* 25067 */
	"DEFAULT_VAL_ATTR1\0" /* 25085 */
	"PT_SPRITE_TEX_ATTR1\0" /* 25103 */
	"ATTR0_VALID\0" /* 25123 */
	"ATTR1_VALID\0" /* 25135 */
	"VS_EXPORT_COUNT\0" /* 25147 */
	"VS_HALF_PACK\0" /* 25163 */
	"VS_EXPORTS_FOG\0" /* 25176 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 25191 */
	"PERSP_SAMPLE_ENA\0" /* 25211 */
	"PERSP_CENTER_ENA\0" /* 25228 */
	"PERSP_CENTROID_ENA\0" /* 25245 */
	"PERSP_PULL_MODEL_ENA\0" /* 25264 */
	"LINEAR_SAMPLE_ENA\0" /* 25285 */
	"LINEAR_CENTER_ENA\0" /* 25303 */
	"LINEAR_CENTROID_ENA\0" /* 25321 */
	"LINE_STIPPLE_TEX_ENA\0" /* 25341 */
	"POS_X_FLOAT_ENA\0" /* 25362 */
	"POS_Y_FLOAT_ENA\0" /* 25378 */
	"POS_Z_FLOAT_ENA\0" /* 25394 */
	"POS_W_FLOAT_ENA\0" /* 25410 */
	"FRONT_FACE_ENA\0" /* 25426 */
	"ANCILLARY_ENA\0" /* 25441 */
	"SAMPLE_COVERAGE_ENA\0" /* 25455 */
	"POS_FIXED_PT_ENA\0" /* 25475 */
	"FLAT_SHADE_ENA\0" /* 25492 */
	"PNT_SPRITE_ENA\0" /* 25507 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 25522 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 25543 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 25564 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 25585 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 25606 */
	"PNT_SPRITE_OVRD_X\0" /* 25630 */
	"PNT_SPRITE_OVRD_Y\0" /* 25648 */
	"PNT_SPRITE_OVRD_Z\0" /* 25666 */
	"PNT_SPRITE_OVRD_W\0" /* 25684 */
	"PNT_SPRITE_TOP_1\0" /* 25702 */
	"NUM_INTERP\0" /* 25719 */
	"PARAM_GEN\0" /* 25730 */
	"FOG_ADDR\0" /* 25740 */
	"BC_OPTIMIZE_DISABLE\0" /* 25749 */
	"PASS_FOG_THROUGH_PS\0" /* 25769 */
	"OFFCHIP_PARAM_EN\0" /* 25789 */
	"LATE_PC_DEALLOC\0" /* 25806 */
	"PERSP_CENTER_CNTL\0" /* 25822 */
	"PERSP_CENTROID_CNTL\0" /* 25840 */
	"LINEAR_CENTER_CNTL\0" /* 25860 */
	"LINEAR_CENTROID_CNTL\0" /* 25879 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 25900 */
	"POS_FLOAT_LOCATION\0" /* 25949 */
	"POS_FLOAT_ULC\0" /* 25968 */
	"FRONT_FACE_ALL_BITS\0" /* 25982 */
	"NUM_PS_WAVES\0" /* 26002 */
	"NUM_VS_WAVES\0" /* 26015 */
	"NUM_GS_WAVES\0" /* 26028 */
	"NUM_ES_WAVES\0" /* 26041 */
	"NUM_HS_WAVES\0" /* 26054 */
	"NUM_LS_WAVES\0" /* 26067 */
	"SPI_SHADER_NONE\0" /* 26080 */
	"SPI_SHADER_1COMP\0" /* 26096 */
	"SPI_SHADER_2COMP\0" /* 26113 */
	"SPI_SHADER_4COMPRESS\0" /* 26130 */
	"SPI_SHADER_4COMP\0" /* 26151 */
	"POS0_EXPORT_FORMAT\0" /* 26168 */
	"POS1_EXPORT_FORMAT\0" /* 26187 */
	"POS2_EXPORT_FORMAT\0" /* 26206 */
	"POS3_EXPORT_FORMAT\0" /* 26225 */
	"SPI_SHADER_ZERO\0" /* 26244 */
	"SPI_SHADER_32_R\0" /* 26260 */
	"SPI_SHADER_32_GR\0" /* 26276 */
	"SPI_SHADER_32_AR\0" /* 26293 */
	"SPI_SHADER_FP16_ABGR\0" /* 26310 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 26331 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 26355 */
	"SPI_SHADER_UINT16_ABGR\0" /* 26379 */
	"SPI_SHADER_SINT16_ABGR\0" /* 26402 */
	"SPI_SHADER_32_ABGR\0" /* 26425 */
	"Z_EXPORT_FORMAT\0" /* 26444 */
	"COL0_EXPORT_FORMAT\0" /* 26460 */
	"COL1_EXPORT_FORMAT\0" /* 26479 */
	"COL2_EXPORT_FORMAT\0" /* 26498 */
	"COL3_EXPORT_FORMAT\0" /* 26517 */
	"COL4_EXPORT_FORMAT\0" /* 26536 */
	"COL5_EXPORT_FORMAT\0" /* 26555 */
	"COL6_EXPORT_FORMAT\0" /* 26574 */
	"COL7_EXPORT_FORMAT\0" /* 26593 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 26612 */
	"SX_RT_EXPORT_32_R\0" /* 26639 */
	"SX_RT_EXPORT_32_A\0" /* 26657 */
	"SX_RT_EXPORT_10_11_11\0" /* 26675 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 26697 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 26721 */
	"SX_RT_EXPORT_5_6_5\0" /* 26742 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 26761 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 26782 */
	"SX_RT_EXPORT_16_16_GR\0" /* 26803 */
	"SX_RT_EXPORT_16_16_AR\0" /* 26825 */
	"MRT0\0" /* 26847 */
	"MRT1\0" /* 26852 */
	"MRT2\0" /* 26857 */
	"MRT3\0" /* 26862 */
	"MRT4\0" /* 26867 */
	"MRT5\0" /* 26872 */
	"MRT6\0" /* 26877 */
	"MRT7\0" /* 26882 */
	"EXACT\0" /* 26887 */
	"11BIT_FORMAT\0" /* 26893 */
	"10BIT_FORMAT\0" /* 26906 */
	"8BIT_FORMAT\0" /* 26919 */
	"6BIT_FORMAT\0" /* 26931 */
	"5BIT_FORMAT\0" /* 26943 */
	"4BIT_FORMAT\0" /* 26955 */
	"MRT0_EPSILON\0" /* 26967 */
	"MRT1_EPSILON\0" /* 26980 */
	"MRT2_EPSILON\0" /* 26993 */
	"MRT3_EPSILON\0" /* 27006 */
	"MRT4_EPSILON\0" /* 27019 */
	"MRT5_EPSILON\0" /* 27032 */
	"MRT6_EPSILON\0" /* 27045 */
	"MRT7_EPSILON\0" /* 27058 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 27071 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 27094 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 27117 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 27140 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 27163 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 27186 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 27209 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 27232 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 27255 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 27278 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 27301 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 27324 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 27347 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 27370 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 27393 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 27416 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 27439 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 27462 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 27497 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 27532 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 27564 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 27596 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 27628 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 27660 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 27694 */
	"COLOR_SRC_OPT\0" /* 27730 */
	"COLOR_DST_OPT\0" /* 27744 */
	"OPT_COMB_NONE\0" /* 27758 */
	"OPT_COMB_ADD\0" /* 27772 */
	"OPT_COMB_SUBTRACT\0" /* 27785 */
	"OPT_COMB_MIN\0" /* 27803 */
	"OPT_COMB_MAX\0" /* 27816 */
	"OPT_COMB_REVSUBTRACT\0" /* 27829 */
	"OPT_COMB_BLEND_DISABLED\0" /* 27850 */
	"OPT_COMB_SAFE_ADD\0" /* 27874 */
	"COLOR_COMB_FCN\0" /* 27892 */
	"ALPHA_SRC_OPT\0" /* 27907 */
	"ALPHA_DST_OPT\0" /* 27921 */
	"ALPHA_COMB_FCN\0" /* 27935 */
	"BLEND_ZERO\0" /* 27950 */
	"BLEND_ONE\0" /* 27961 */
	"BLEND_SRC_COLOR\0" /* 27971 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 27987 */
	"BLEND_SRC_ALPHA\0" /* 28013 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 28029 */
	"BLEND_DST_ALPHA\0" /* 28055 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 28071 */
	"BLEND_DST_COLOR\0" /* 28097 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 28113 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 28139 */
	"BLEND_CONSTANT_COLOR\0" /* 28164 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 28185 */
	"BLEND_SRC1_COLOR\0" /* 28216 */
	"BLEND_INV_SRC1_COLOR\0" /* 28233 */
	"BLEND_SRC1_ALPHA\0" /* 28254 */
	"BLEND_INV_SRC1_ALPHA\0" /* 28271 */
	"BLEND_CONSTANT_ALPHA\0" /* 28292 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 28313 */
	"COLOR_SRCBLEND\0" /* 28344 */
	"COMB_DST_PLUS_SRC\0" /* 28359 */
	"COMB_SRC_MINUS_DST\0" /* 28377 */
	"COMB_MIN_DST_SRC\0" /* 28396 */
	"COMB_MAX_DST_SRC\0" /* 28413 */
	"COMB_DST_MINUS_SRC\0" /* 28430 */
	"COLOR_DESTBLEND\0" /* 28449 */
	"ALPHA_SRCBLEND\0" /* 28465 */
	"ALPHA_DESTBLEND\0" /* 28480 */
	"SEPARATE_ALPHA_BLEND\0" /* 28496 */
	"DISABLE_ROP3\0" /* 28517, 28525 */
	"SRC_STATE_ID\0" /* 28530 */
	"BASE_ADDR_GFX6\0" /* 28543 */
	"BASE_ADDR_GFX9\0" /* 28558 */
	"DI_SRC_SEL_DMA\0" /* 28573 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 28588 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 28609 */
	"DI_SRC_SEL_RESERVED\0" /* 28631 */
	"SOURCE_SELECT\0" /* 28651 */
	"DI_MAJOR_MODE_0\0" /* 28665 */
	"DI_MAJOR_MODE_1\0" /* 28681 */
	"MAJOR_MODE\0" /* 28697 */
	"NOT_EOP\0" /* 28708 */
	"USE_OPAQUE\0" /* 28716 */
	"SPRITE_EN_R6XX\0" /* 28727 */
	"UNROLLED_INST\0" /* 28742 */
	"GRBM_SKEW_NO_DEC\0" /* 28756 */
	"REG_RT_INDEX\0" /* 28773 */
	"ADDRESS_LOW\0" /* 28786 */
	"STENCIL_ENABLE\0" /* 28798 */
	"Z_WRITE_ENABLE\0" /* 28813 */
	"DEPTH_BOUNDS_ENABLE\0" /* 28828 */
	"FRAG_NEVER\0" /* 28848 */
	"FRAG_LESS\0" /* 28859 */
	"FRAG_EQUAL\0" /* 28869 */
	"FRAG_LEQUAL\0" /* 28880 */
	"FRAG_GREATER\0" /* 28892 */
	"FRAG_NOTEQUAL\0" /* 28905 */
	"FRAG_GEQUAL\0" /* 28919 */
	"FRAG_ALWAYS\0" /* 28931 */
	"BACKFACE_ENABLE\0" /* 28943 */
	"REF_NEVER\0" /* 28959 */
	"REF_LESS\0" /* 28969 */
	"REF_EQUAL\0" /* 28978 */
	"REF_LEQUAL\0" /* 28988 */
	"REF_GREATER\0" /* 28999 */
	"REF_NOTEQUAL\0" /* 29011 */
	"REF_GEQUAL\0" /* 29024 */
	"REF_ALWAYS\0" /* 29035 */
	"STENCILFUNC\0" /* 29046 */
	"STENCILFUNC_BF\0" /* 29058 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 29073 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 29107 */
	"MAX_ANCHOR_SAMPLES\0" /* 29142 */
	"PS_ITER_SAMPLES\0" /* 29161 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 29177 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 29201 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 29227 */
	"INCOHERENT_EQAA_READS\0" /* 29254 */
	"INTERPOLATE_COMP_Z\0" /* 29276 */
	"INTERPOLATE_SRC_Z\0" /* 29295 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 29313 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 29340 */
	"OVERRASTERIZATION_AMOUNT\0" /* 29367 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 29392 */
	"DISABLE_DUAL_QUAD\0" /* 29423 */
	"DEGAMMA_ENABLE\0" /* 29441 */
	"CB_DISABLE\0" /* 29456 */
	"CB_NORMAL\0" /* 29467 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 29490, 29477 */
	"CB_RESOLVE\0" /* 29501 */
	"CB_FMASK_DECOMPRESS\0" /* 29512 */
	"CB_DCC_DECOMPRESS\0" /* 29532 */
	"X_0X00\0" /* 29550 */
	"X_0X05\0" /* 29557 */
	"X_0X0A\0" /* 29564 */
	"X_0X0F\0" /* 29571 */
	"X_0X11\0" /* 29578 */
	"X_0X22\0" /* 29585 */
	"X_0X33\0" /* 29592 */
	"X_0X44\0" /* 29599 */
	"X_0X50\0" /* 29606 */
	"X_0X55\0" /* 29613 */
	"X_0X5A\0" /* 29620 */
	"X_0X5F\0" /* 29627 */
	"X_0X66\0" /* 29634 */
	"X_0X77\0" /* 29641 */
	"X_0X88\0" /* 29648 */
	"X_0X99\0" /* 29655 */
	"X_0XA0\0" /* 29662 */
	"X_0XA5\0" /* 29669 */
	"X_0XAA\0" /* 29676 */
	"X_0XAF\0" /* 29683 */
	"X_0XBB\0" /* 29690 */
	"X_0XCC\0" /* 29697 */
	"X_0XDD\0" /* 29704 */
	"X_0XEE\0" /* 29711 */
	"X_0XF0\0" /* 29718 */
	"X_0XF5\0" /* 29725 */
	"X_0XFA\0" /* 29732 */
	"X_0XFF\0" /* 29739 */
	"Z_EXPORT_ENABLE\0" /* 29746 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 29762 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 29793 */
	"LATE_Z\0" /* 29822 */
	"EARLY_Z_THEN_LATE_Z\0" /* 29829 */
	"RE_Z\0" /* 29849 */
	"EARLY_Z_THEN_RE_Z\0" /* 29854 */
	"KILL_ENABLE\0" /* 29872 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 29884 */
	"MASK_EXPORT_ENABLE\0" /* 29908 */
	"EXEC_ON_HIER_FAIL\0" /* 29927 */
	"EXEC_ON_NOOP\0" /* 29945 */
	"ALPHA_TO_MASK_DISABLE\0" /* 29958 */
	"DEPTH_BEFORE_SHADER\0" /* 29980 */
	"EXPORT_ANY_Z\0" /* 30000 */
	"EXPORT_LESS_THAN_Z\0" /* 30013 */
	"EXPORT_GREATER_THAN_Z\0" /* 30032 */
	"EXPORT_RESERVED\0" /* 30054 */
	"CONSERVATIVE_Z_EXPORT\0" /* 30070 */
	"DUAL_QUAD_DISABLE\0" /* 30092 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 30110 */
	"EXEC_IF_OVERLAPPED\0" /* 30141 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 30160 */
	"UCP_ENA_0\0" /* 30185 */
	"UCP_ENA_1\0" /* 30195 */
	"UCP_ENA_2\0" /* 30205 */
	"UCP_ENA_3\0" /* 30215 */
	"UCP_ENA_4\0" /* 30225 */
	"UCP_ENA_5\0" /* 30235 */
	"PS_UCP_Y_SCALE_NEG\0" /* 30245 */
	"PS_UCP_MODE\0" /* 30264 */
	"CLIP_DISABLE\0" /* 30276 */
	"UCP_CULL_ONLY_ENA\0" /* 30289 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 30307 */
	"DX_CLIP_SPACE_DEF\0" /* 30330 */
	"DIS_CLIP_ERR_DETECT\0" /* 30348 */
	"VTX_KILL_OR\0" /* 30368 */
	"DX_RASTERIZATION_KILL\0" /* 30380 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 30402 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 30426 */
	"ZCLIP_NEAR_DISABLE\0" /* 30452 */
	"ZCLIP_FAR_DISABLE\0" /* 30471 */
	"CULL_FRONT\0" /* 30489 */
	"CULL_BACK\0" /* 30500 */
	"FACE\0" /* 30510 */
	"X_DISABLE_POLY_MODE\0" /* 30515, 30525 */
	"X_DUAL_MODE\0" /* 30535 */
	"X_DRAW_POINTS\0" /* 30547 */
	"X_DRAW_LINES\0" /* 30561 */
	"X_DRAW_TRIANGLES\0" /* 30574 */
	"POLYMODE_FRONT_PTYPE\0" /* 30591 */
	"POLYMODE_BACK_PTYPE\0" /* 30612 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 30632 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 30657 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 30681 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 30705 */
	"PROVOKING_VTX_LAST\0" /* 30730 */
	"PERSP_CORR_DIS\0" /* 30749 */
	"MULTI_PRIM_IB_ENA\0" /* 30764 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 30782 */
	"NEW_QUAD_DECOMPOSITION\0" /* 30820 */
	"VPORT_X_SCALE_ENA\0" /* 30843 */
	"VPORT_X_OFFSET_ENA\0" /* 30861 */
	"VPORT_Y_SCALE_ENA\0" /* 30880 */
	"VPORT_Y_OFFSET_ENA\0" /* 30898 */
	"VPORT_Z_SCALE_ENA\0" /* 30917 */
	"VPORT_Z_OFFSET_ENA\0" /* 30935 */
	"VTX_XY_FMT\0" /* 30954 */
	"VTX_Z_FMT\0" /* 30965 */
	"VTX_W0_FMT\0" /* 30975 */
	"PERFCOUNTER_REF\0" /* 30986 */
	"CLIP_DIST_ENA_0\0" /* 31002 */
	"CLIP_DIST_ENA_1\0" /* 31018 */
	"CLIP_DIST_ENA_2\0" /* 31034 */
	"CLIP_DIST_ENA_3\0" /* 31050 */
	"CLIP_DIST_ENA_4\0" /* 31066 */
	"CLIP_DIST_ENA_5\0" /* 31082 */
	"CLIP_DIST_ENA_6\0" /* 31098 */
	"CLIP_DIST_ENA_7\0" /* 31114 */
	"CULL_DIST_ENA_0\0" /* 31130 */
	"CULL_DIST_ENA_1\0" /* 31146 */
	"CULL_DIST_ENA_2\0" /* 31162 */
	"CULL_DIST_ENA_3\0" /* 31178 */
	"CULL_DIST_ENA_4\0" /* 31194 */
	"CULL_DIST_ENA_5\0" /* 31210 */
	"CULL_DIST_ENA_6\0" /* 31226 */
	"CULL_DIST_ENA_7\0" /* 31242 */
	"USE_VTX_POINT_SIZE\0" /* 31258 */
	"USE_VTX_EDGE_FLAG\0" /* 31277 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 31295 */
	"USE_VTX_VIEWPORT_INDX\0" /* 31322 */
	"USE_VTX_KILL_FLAG\0" /* 31344 */
	"VS_OUT_MISC_VEC_ENA\0" /* 31362 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 31382 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 31405 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 31428 */
	"USE_VTX_GS_CUT_FLAG\0" /* 31453 */
	"USE_VTX_LINE_WIDTH\0" /* 31473 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 31492 */
	"VTE_XY_INF_DISCARD\0" /* 31515 */
	"VTE_Z_INF_DISCARD\0" /* 31534 */
	"VTE_W_INF_DISCARD\0" /* 31552 */
	"VTE_0XNANINF_IS_0\0" /* 31570 */
	"VTE_XY_NAN_RETAIN\0" /* 31588 */
	"VTE_Z_NAN_RETAIN\0" /* 31606 */
	"VTE_W_NAN_RETAIN\0" /* 31623 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 31640 */
	"VS_XY_NAN_TO_INF\0" /* 31661 */
	"VS_XY_INF_RETAIN\0" /* 31678 */
	"VS_Z_NAN_TO_INF\0" /* 31695 */
	"VS_Z_INF_RETAIN\0" /* 31711 */
	"VS_W_NAN_TO_INF\0" /* 31727 */
	"VS_W_INF_RETAIN\0" /* 31743 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 31759 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 31784 */
	"LINE_STIPPLE_RESET\0" /* 31804 */
	"EXPAND_FULL_LENGTH\0" /* 31823 */
	"FRACTIONAL_ACCUM\0" /* 31842 */
	"DIAMOND_ADJUST\0" /* 31859 */
	"TRIANGLE_FILTER_DISABLE\0" /* 31874 */
	"LINE_FILTER_DISABLE\0" /* 31898 */
	"POINT_FILTER_DISABLE\0" /* 31918 */
	"RECTANGLE_FILTER_DISABLE\0" /* 31939 */
	"TRIANGLE_EXPAND_ENA\0" /* 31964 */
	"LINE_EXPAND_ENA\0" /* 31984 */
	"POINT_EXPAND_ENA\0" /* 32000 */
	"RECTANGLE_EXPAND_ENA\0" /* 32017 */
	"PRIM_EXPAND_CONSTANT\0" /* 32038 */
	"XMAX_RIGHT_EXCLUSION\0" /* 32059 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 32080 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 32102 */
	"SRBSL_ENABLE\0" /* 32127 */
	"MIN_SIZE\0" /* 32140 */
	"MAX_SIZE\0" /* 32149 */
	"LINE_PATTERN\0" /* 32158 */
	"REPEAT_COUNT\0" /* 32171 */
	"PATTERN_BIT_ORDER\0" /* 32184 */
	"AUTO_RESET_CNTL\0" /* 32202 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 32218 */
	"VGT_OUTPATH_TESS_EN\0" /* 32240 */
	"VGT_OUTPATH_PASSTHRU\0" /* 32260 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 32281 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 32302 */
	"PATH_SELECT\0" /* 32323 */
	"TESS_MODE\0" /* 32335 */
	"REUSE_DEPTH\0" /* 32345 */
	"VGT_GRP_3D_POINT\0" /* 32357 */
	"VGT_GRP_3D_LINE\0" /* 32374 */
	"VGT_GRP_3D_TRI\0" /* 32390 */
	"VGT_GRP_3D_RECT\0" /* 32405 */
	"VGT_GRP_3D_QUAD\0" /* 32421 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 32437 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 32461 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 32485 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 32509 */
	"VGT_GRP_2D_FILL_RECT\0" /* 32533 */
	"VGT_GRP_2D_LINE\0" /* 32554 */
	"VGT_GRP_2D_TRI\0" /* 32570 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 32585 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 32609 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 32632 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 32656 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 32676 */
	"VGT_GRP_3D_PATCH\0" /* 32695 */
	"RETAIN_ORDER\0" /* 32712 */
	"RETAIN_QUADS\0" /* 32725 */
	"VGT_GRP_LIST\0" /* 32738 */
	"VGT_GRP_STRIP\0" /* 32751 */
	"VGT_GRP_FAN\0" /* 32765 */
	"VGT_GRP_LOOP\0" /* 32777 */
	"VGT_GRP_POLYGON\0" /* 32790 */
	"PRIM_ORDER\0" /* 32806 */
	"FIRST_DECR\0" /* 32817, 32823 */
	"COMP_X_EN\0" /* 32828 */
	"COMP_Y_EN\0" /* 32838 */
	"COMP_Z_EN\0" /* 32848 */
	"COMP_W_EN\0" /* 32858 */
	"SHIFT\0" /* 32868 */
	"VGT_GRP_INDEX_16\0" /* 32874 */
	"VGT_GRP_INDEX_32\0" /* 32891 */
	"VGT_GRP_UINT_16\0" /* 32908 */
	"VGT_GRP_UINT_32\0" /* 32924 */
	"VGT_GRP_SINT_16\0" /* 32940 */
	"VGT_GRP_SINT_32\0" /* 32956 */
	"VGT_GRP_FLOAT_32\0" /* 32972 */
	"VGT_GRP_AUTO_PRIM\0" /* 32989 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 33007 */
	"X_CONV\0" /* 33033 */
	"Y_CONV\0" /* 33040 */
	"Z_CONV\0" /* 33047 */
	"Z_OFFSET\0" /* 33054 */
	"W_CONV\0" /* 33063 */
	"W_OFFSET\0" /* 33070 */
	"GS_OFF\0" /* 33079 */
	"GS_SCENARIO_A\0" /* 33086 */
	"GS_SCENARIO_B\0" /* 33100 */
	"GS_SCENARIO_G\0" /* 33114 */
	"GS_SCENARIO_C\0" /* 33128 */
	"SPRITE_EN\0" /* 33142 */
	"GS_CUT_1024\0" /* 33152 */
	"GS_CUT_512\0" /* 33164 */
	"GS_CUT_256\0" /* 33175 */
	"GS_CUT_128\0" /* 33186 */
	"CUT_MODE\0" /* 33197 */
	"GS_C_PACK_EN\0" /* 33206 */
	"RESERVED_2\0" /* 33219 */
	"ES_PASSTHRU\0" /* 33230 */
	"COMPUTE_MODE\0" /* 33242 */
	"FAST_COMPUTE_MODE\0" /* 33255 */
	"ELEMENT_INFO_EN\0" /* 33273 */
	"PARTIAL_THD_AT_EOI\0" /* 33289 */
	"SUPPRESS_CUTS\0" /* 33308 */
	"ES_WRITE_OPTIMIZE\0" /* 33322 */
	"GS_WRITE_OPTIMIZE\0" /* 33340 */
	"X_0_OFFCHIP_GS\0" /* 33358 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 33373, 33391 */
	"RESERVED_3\0" /* 33398 */
	"RESERVED_4\0" /* 33409 */
	"RESERVED_5\0" /* 33420 */
	"ES_VERTS_PER_SUBGRP\0" /* 33431 */
	"GS_PRIMS_PER_SUBGRP\0" /* 33451 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 33471 */
	"MSAA_ENABLE\0" /* 33495 */
	"VPORT_SCISSOR_ENABLE\0" /* 33507 */
	"LINE_STIPPLE_ENABLE\0" /* 33528 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 33548 */
	"SCALE_LINE_WIDTH_PAD\0" /* 33573 */
	"ALTERNATE_RBS_PER_TILE\0" /* 33594 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 33617 */
	"WALK_SIZE\0" /* 33647 */
	"WALK_ALIGNMENT\0" /* 33657 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 33672 */
	"WALK_FENCE_ENABLE\0" /* 33697 */
	"WALK_FENCE_SIZE\0" /* 33715 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 33736, 33731 */
	"TILE_COVER_DISABLE\0" /* 33759 */
	"TILE_COVER_NO_SCISSOR\0" /* 33778 */
	"ZMM_LINE_EXTENT\0" /* 33800 */
	"ZMM_LINE_OFFSET\0" /* 33816 */
	"ZMM_RECT_EXTENT\0" /* 33832 */
	"KILL_PIX_POST_HI_Z\0" /* 33848 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 33867 */
	"PS_ITER_SAMPLE\0" /* 33893 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 33908 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 33948 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 33975 */
	"GPU_ID_OVERRIDE\0" /* 33998 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 34014 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 34044 */
	"FORCE_EOV_REZ_ENABLE\0" /* 34068 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 34089 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 34119 */
	"GS_PER_ES\0" /* 34143 */
	"ES_PER_GS\0" /* 34153 */
	"GS_PER_VS\0" /* 34163 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 34173 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 34196 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 34219 */
	"OUTPRIM_TYPE\0" /* 34241 */
	"OUTPRIM_TYPE_1\0" /* 34254 */
	"OUTPRIM_TYPE_2\0" /* 34269 */
	"OUTPRIM_TYPE_3\0" /* 34284 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 34299 */
	"VGT_INDEX_16\0" /* 34322 */
	"VGT_INDEX_32\0" /* 34335 */
	"VGT_INDEX_8\0" /* 34348 */
	"VGT_DMA_SWAP_NONE\0" /* 34360 */
	"VGT_DMA_SWAP_16_BIT\0" /* 34378 */
	"VGT_DMA_SWAP_32_BIT\0" /* 34398 */
	"VGT_DMA_SWAP_WORD\0" /* 34418 */
	"SWAP_MODE\0" /* 34436 */
	"VGT_DMA_BUF_MEM\0" /* 34446 */
	"VGT_DMA_BUF_RING\0" /* 34462 */
	"VGT_DMA_BUF_SETUP\0" /* 34479 */
	"BUF_TYPE\0" /* 34497 */
	"VGT_POLICY_LRU\0" /* 34506 */
	"VGT_POLICY_STREAM\0" /* 34521 */
	"RDREQ_POLICY_CIK\0" /* 34539 */
	"RDREQ_POLICY\0" /* 34556 */
	"REQ_PATH\0" /* 34569 */
	"PRIMITIVEID_EN\0" /* 34578 */
	"DISABLE_RESET_ON_EOI\0" /* 34593 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 34614 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 34639 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 34662 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 34685 */
	"CACHE_FLUSH_TS\0" /* 34708 */
	"CONTEXT_DONE\0" /* 34723 */
	"CACHE_FLUSH\0" /* 34736 */
	"CS_PARTIAL_FLUSH\0" /* 34748 */
	"VGT_STREAMOUT_SYNC\0" /* 34765 */
	"VGT_STREAMOUT_RESET\0" /* 34784 */
	"END_OF_PIPE_INCR_DE\0" /* 34804 */
	"END_OF_PIPE_IB_END\0" /* 34824 */
	"RST_PIX_CNT\0" /* 34843 */
	"VS_PARTIAL_FLUSH\0" /* 34855 */
	"PS_PARTIAL_FLUSH\0" /* 34872 */
	"FLUSH_HS_OUTPUT\0" /* 34889 */
	"FLUSH_LS_OUTPUT\0" /* 34905 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 34921 */
	"ZPASS_DONE\0" /* 34950 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 34961 */
	"PERFCOUNTER_START\0" /* 34987 */
	"PERFCOUNTER_STOP\0" /* 35005 */
	"PIPELINESTAT_START\0" /* 35022 */
	"PIPELINESTAT_STOP\0" /* 35041 */
	"PERFCOUNTER_SAMPLE\0" /* 35059 */
	"FLUSH_ES_OUTPUT\0" /* 35078 */
	"FLUSH_GS_OUTPUT\0" /* 35094 */
	"SAMPLE_PIPELINESTAT\0" /* 35110 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 35130 */
	"SAMPLE_STREAMOUTSTATS\0" /* 35152 */
	"RESET_VTX_CNT\0" /* 35174 */
	"BLOCK_CONTEXT_DONE\0" /* 35188 */
	"CS_CONTEXT_DONE\0" /* 35207 */
	"VGT_FLUSH\0" /* 35223 */
	"SC_SEND_DB_VPZ\0" /* 35233 */
	"BOTTOM_OF_PIPE_TS\0" /* 35248 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 35266 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 35289 */
	"FLUSH_AND_INV_DB_META\0" /* 35314 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 35336 */
	"FLUSH_AND_INV_CB_META\0" /* 35361 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 35383 */
	"THREAD_TRACE_START\0" /* 35411 */
	"THREAD_TRACE_STOP\0" /* 35430 */
	"THREAD_TRACE_MARKER\0" /* 35448 */
	"THREAD_TRACE_FLUSH\0" /* 35468 */
	"THREAD_TRACE_FINISH\0" /* 35487 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 35507 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 35531 */
	"PIXEL_PIPE_STAT_RESET\0" /* 35552 */
	"BREAK_BATCH\0" /* 35574 */
	"FLUSH_DFSM\0" /* 35586 */
	"RESET_TO_LOWEST_VGT\0" /* 35597 */
	"TGID_ROLLOVER\0" /* 35617 */
	"ENABLE_NGG_PIPELINE\0" /* 35631 */
	"ENABLE_LEGACY_PIPELINE\0" /* 35651 */
	"EVENT_TYPE\0" /* 35674 */
	"ADDRESS_HI_GFX6\0" /* 35685 */
	"EXTENDED_EVENT\0" /* 35701 */
	"ADDRESS_HI_GFX9\0" /* 35716 */
	"RESET_EN\0" /* 35732 */
	"PRIMGROUP_SIZE\0" /* 35741 */
	"PARTIAL_VS_WAVE_ON\0" /* 35756 */
	"SWITCH_ON_EOP\0" /* 35775 */
	"PARTIAL_ES_WAVE_ON\0" /* 35789 */
	"SWITCH_ON_EOI\0" /* 35808 */
	"WD_SWITCH_ON_EOP\0" /* 35822 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 35839 */
	"ITEMSIZE\0" /* 35859 */
	"REUSE_OFF\0" /* 35868 */
	"VTX_CNT_EN\0" /* 35878 */
	"FULL_CACHE\0" /* 35889 */
	"HTILE_USES_PRELOAD_WIN\0" /* 35900 */
	"PRELOAD\0" /* 35923 */
	"PREFETCH_WIDTH\0" /* 35931 */
	"PREFETCH_HEIGHT\0" /* 35946 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 35962 */
	"TC_COMPATIBLE\0" /* 35986 */
	"COMPAREFUNC0\0" /* 36000 */
	"COMPAREVALUE0\0" /* 36013 */
	"COMPAREMASK0\0" /* 36027 */
	"COMPAREFUNC1\0" /* 36040 */
	"COMPAREVALUE1\0" /* 36053 */
	"COMPAREMASK1\0" /* 36067 */
	"START_X\0" /* 36080 */
	"START_Y\0" /* 36088 */
	"MAX_X\0" /* 36096 */
	"MAX_Y\0" /* 36102 */
	"VERTEX_STRIDE\0" /* 36108 */
	"MAX_VERT_OUT\0" /* 36122 */
	"ACCUM_ISOLINE\0" /* 36135 */
	"ACCUM_TRI\0" /* 36149 */
	"ACCUM_QUAD\0" /* 36159 */
	"DONUT_SPLIT\0" /* 36170 */
	"TRAP_SPLIT\0" /* 36182 */
	"LS_STAGE_OFF\0" /* 36193 */
	"LS_STAGE_ON\0" /* 36206 */
	"CS_STAGE_ON\0" /* 36218 */
	"ES_STAGE_OFF\0" /* 36230 */
	"ES_STAGE_DS\0" /* 36243 */
	"ES_STAGE_REAL\0" /* 36255 */
	"VS_STAGE_REAL\0" /* 36269 */
	"VS_STAGE_DS\0" /* 36283 */
	"VS_STAGE_COPY_SHADER\0" /* 36295 */
	"DYNAMIC_HS\0" /* 36316 */
	"DIS_DEALLOC_ACCUM_0\0" /* 36327 */
	"DIS_DEALLOC_ACCUM_1\0" /* 36347 */
	"VS_WAVE_ID_EN\0" /* 36367 */
	"ORDERED_ID_MODE\0" /* 36381 */
	"GS_FAST_LAUNCH\0" /* 36397 */
	"NUM_PATCHES\0" /* 36412 */
	"HS_NUM_INPUT_CP\0" /* 36424 */
	"HS_NUM_OUTPUT_CP\0" /* 36440 */
	"TESS_ISOLINE\0" /* 36457 */
	"TESS_TRIANGLE\0" /* 36470 */
	"TESS_QUAD\0" /* 36484 */
	"PART_INTEGER\0" /* 36494 */
	"PART_POW2\0" /* 36507 */
	"PART_FRAC_ODD\0" /* 36517 */
	"PART_FRAC_EVEN\0" /* 36531 */
	"PARTITIONING\0" /* 36546 */
	"OUTPUT_POINT\0" /* 36559 */
	"OUTPUT_LINE\0" /* 36572 */
	"OUTPUT_TRIANGLE_CW\0" /* 36584 */
	"OUTPUT_TRIANGLE_CCW\0" /* 36603 */
	"TOPOLOGY\0" /* 36623 */
	"RESERVED_REDUC_AXIS\0" /* 36632 */
	"DEPRECATED\0" /* 36652 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 36663 */
	"DISABLE_DONUTS\0" /* 36685 */
	"VGT_POLICY_BYPASS\0" /* 36700 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 36718 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 36744 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 36770 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 36795 */
	"DISTRIBUTION_MODE\0" /* 36824 */
	"ALPHA_TO_MASK_ENABLE\0" /* 36842 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 36863 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 36885 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 36907 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 36929 */
	"OFFSET_ROUND\0" /* 36951 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 36964 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 36992 */
	"STREAMOUT_0_EN\0" /* 37020 */
	"STREAMOUT_1_EN\0" /* 37035 */
	"STREAMOUT_2_EN\0" /* 37050 */
	"STREAMOUT_3_EN\0" /* 37065 */
	"RAST_STREAM\0" /* 37080 */
	"RAST_STREAM_MASK\0" /* 37092 */
	"USE_RAST_STREAM_MASK\0" /* 37109 */
	"EN_PRIMS_NEEDED_CNT\0" /* 37130 */
	"STREAM_0_BUFFER_EN\0" /* 37150 */
	"STREAM_1_BUFFER_EN\0" /* 37169 */
	"STREAM_2_BUFFER_EN\0" /* 37188 */
	"STREAM_3_BUFFER_EN\0" /* 37207 */
	"DISTANCE_0\0" /* 37226 */
	"DISTANCE_1\0" /* 37237 */
	"DISTANCE_2\0" /* 37248 */
	"DISTANCE_3\0" /* 37259 */
	"DISTANCE_4\0" /* 37270 */
	"DISTANCE_5\0" /* 37281 */
	"DISTANCE_6\0" /* 37292 */
	"DISTANCE_7\0" /* 37303 */
	"DISTANCE_8\0" /* 37314 */
	"DISTANCE_9\0" /* 37325 */
	"DISTANCE_10\0" /* 37336 */
	"DISTANCE_11\0" /* 37348 */
	"DISTANCE_12\0" /* 37360 */
	"DISTANCE_13\0" /* 37372 */
	"DISTANCE_14\0" /* 37384 */
	"DISTANCE_15\0" /* 37396 */
	"EXPAND_LINE_WIDTH\0" /* 37408 */
	"LAST_PIXEL\0" /* 37426 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 37437 */
	"DX10_DIAMOND_TEST_ENA\0" /* 37462 */
	"MSAA_NUM_SAMPLES\0" /* 37484 */
	"AA_MASK_CENTROID_DTMN\0" /* 37501 */
	"MAX_SAMPLE_DIST\0" /* 37523 */
	"MSAA_EXPOSED_SAMPLES\0" /* 37539 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 37560 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 37583 */
	"PIX_CENTER\0" /* 37609 */
	"X_TRUNCATE\0" /* 37620 */
	"X_ROUND\0" /* 37631 */
	"X_ROUND_TO_EVEN\0" /* 37639 */
	"X_ROUND_TO_ODD\0" /* 37655 */
	"ROUND_MODE\0" /* 37670 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 37681 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 37707 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 37732 */
	"X_16_8_FIXED_POINT_1_2\0" /* 37757 */
	"X_16_8_FIXED_POINT_1\0" /* 37780 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 37801 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 37828 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 37857 */
	"QUANT_MODE\0" /* 37886 */
	"S0_X\0" /* 37897 */
	"S0_Y\0" /* 37902 */
	"S1_X\0" /* 37907 */
	"S1_Y\0" /* 37912 */
	"S2_X\0" /* 37917 */
	"S2_Y\0" /* 37922 */
	"S3_X\0" /* 37927 */
	"S3_Y\0" /* 37932 */
	"S4_X\0" /* 37937 */
	"S4_Y\0" /* 37942 */
	"S5_X\0" /* 37947 */
	"S5_Y\0" /* 37952 */
	"S6_X\0" /* 37957 */
	"S6_Y\0" /* 37962 */
	"S7_X\0" /* 37967 */
	"S7_Y\0" /* 37972 */
	"S8_X\0" /* 37977 */
	"S8_Y\0" /* 37982 */
	"S9_X\0" /* 37987 */
	"S9_Y\0" /* 37992 */
	"S10_X\0" /* 37997 */
	"S10_Y\0" /* 38003 */
	"S11_X\0" /* 38009 */
	"S11_Y\0" /* 38015 */
	"S12_X\0" /* 38021 */
	"S12_Y\0" /* 38027 */
	"S13_X\0" /* 38033 */
	"S13_Y\0" /* 38039 */
	"S14_X\0" /* 38045 */
	"S14_Y\0" /* 38051 */
	"S15_X\0" /* 38057 */
	"S15_Y\0" /* 38063 */
	"AA_MASK_X0Y0\0" /* 38069 */
	"AA_MASK_X1Y0\0" /* 38082 */
	"AA_MASK_X0Y1\0" /* 38095 */
	"AA_MASK_X1Y1\0" /* 38108 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 38121 */
	"VTX_REUSE_DEPTH\0" /* 38150 */
	"DEALLOC_DIST\0" /* 38166 */
	"FMASK_TILE_MAX\0" /* 38179 */
	"MIP_LEVEL\0" /* 38194 */
	"ENDIAN_NONE\0" /* 38204 */
	"ENDIAN_8IN16\0" /* 38216 */
	"ENDIAN_8IN32\0" /* 38229 */
	"ENDIAN_8IN64\0" /* 38242 */
	"ENDIAN\0" /* 38255 */
	"COLOR_INVALID\0" /* 38262 */
	"COLOR_8\0" /* 38276 */
	"COLOR_16\0" /* 38284 */
	"COLOR_8_8\0" /* 38293 */
	"COLOR_32\0" /* 38303 */
	"COLOR_16_16\0" /* 38312 */
	"COLOR_10_11_11\0" /* 38324 */
	"COLOR_11_11_10\0" /* 38339 */
	"COLOR_10_10_10_2\0" /* 38354 */
	"COLOR_2_10_10_10\0" /* 38371 */
	"COLOR_8_8_8_8\0" /* 38388 */
	"COLOR_32_32\0" /* 38402 */
	"COLOR_16_16_16_16\0" /* 38414 */
	"COLOR_32_32_32_32\0" /* 38432 */
	"COLOR_5_6_5\0" /* 38450 */
	"COLOR_1_5_5_5\0" /* 38462 */
	"COLOR_5_5_5_1\0" /* 38476 */
	"COLOR_4_4_4_4\0" /* 38490 */
	"COLOR_8_24\0" /* 38504 */
	"COLOR_24_8\0" /* 38515 */
	"COLOR_X24_8_32_FLOAT\0" /* 38526 */
	"NUMBER_UNORM\0" /* 38547 */
	"NUMBER_SNORM\0" /* 38560 */
	"NUMBER_UINT\0" /* 38573 */
	"NUMBER_SINT\0" /* 38585 */
	"NUMBER_SRGB\0" /* 38597 */
	"NUMBER_FLOAT\0" /* 38609 */
	"NUMBER_TYPE\0" /* 38622 */
	"SWAP_STD\0" /* 38634 */
	"SWAP_ALT\0" /* 38643 */
	"SWAP_STD_REV\0" /* 38652 */
	"SWAP_ALT_REV\0" /* 38665 */
	"COMP_SWAP\0" /* 38678 */
	"BLEND_CLAMP\0" /* 38688 */
	"BLEND_BYPASS\0" /* 38700 */
	"SIMPLE_FLOAT\0" /* 38713 */
	"CMASK_IS_LINEAR\0" /* 38726 */
	"FORCE_OPT_AUTO\0" /* 38742 */
	"FORCE_OPT_DISABLE\0" /* 38757 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 38775 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 38803 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 38833 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 38864 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 38892 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 38922 */
	"BLEND_OPT_DONT_RD_DST\0" /* 38953 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 38975 */
	"FMASK_COMPRESSION_DISABLE\0" /* 38999 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 39025 */
	"DCC_ENABLE\0" /* 39051 */
	"CMASK_ADDR_TYPE\0" /* 39062 */
	"FMASK_TILE_MODE_INDEX\0" /* 39078 */
	"FMASK_BANK_HEIGHT\0" /* 39100 */
	"NUM_FRAGMENTS\0" /* 39118 */
	"FORCE_DST_ALPHA_1\0" /* 39132 */
	"MIP0_DEPTH\0" /* 39150 */
	"COLOR_SW_MODE\0" /* 39161 */
	"FMASK_SW_MODE\0" /* 39175 */
	"RESOURCE_TYPE\0" /* 39189 */
	"KEY_CLEAR_ENABLE\0" /* 39203 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 39220 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 39248 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 39274 */
	"INDEPENDENT_64B_BLOCKS\0" /* 39300 */
	"LOSSY_RGB_PRECISION\0" /* 39323 */
	"LOSSY_ALPHA_PRECISION\0" /* 39343 */
	"MATCH_ALL_BITS\0" /* 39365 */
	"BASE_HI\0" /* 39380 */
	"EN_INST_OPT_BASIC\0" /* 39388 */
	"EN_INST_OPT_ADV\0" /* 39406 */
	"HW_USE_ONLY\0" /* 39422 */
	"DWB\0" /* 39434 */
	"GRAD_ADJ_0\0" /* 39438 */
	"GRAD_ADJ_1\0" /* 39449 */
	"GRAD_ADJ_2\0" /* 39460 */
	"GRAD_ADJ_3\0" /* 39471 */
	"TTRACE_STALL_ALL\0" /* 39482 */
	"ALLOC_ARB_LRU_ENA\0" /* 39499 */
	"EXP_ARB_LRU_ENA\0" /* 39517 */
	"PS_PKR_PRIORITY_CNTL\0" /* 39533 */
	"BATON_RESET_DISABLE\0" /* 39554 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 39574 */
	"LBPW_CU_CHK_MODE\0" /* 39600 */
	"LBPW_CU_CHK_CNT\0" /* 39617 */
	"CSC_PWR_SAVE_DISABLE\0" /* 39633 */
	"CSG_PWR_SAVE_DISABLE\0" /* 39654 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 39675 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 39716 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 39755 */
	"X_MAX\0" /* 39780 */
	"Y_MAX\0" /* 39786 */
	"PARTIALLY_RESIDENT\0" /* 39792 */
	"FAULT_BEHAVIOR\0" /* 39811 */
	"ITERATE_FLUSH\0" /* 39826 */
	"MAXMIP\0" /* 39840 */
	"FORCE_ON\0" /* 39847 */
	"PUNCHOUT_MODE\0" /* 39856 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 39870 */
	"DISALLOW_OVERFLOW\0" /* 39895 */
	"PS_INVOKE_MASK\0" /* 39913 */
	"EPITCH\0" /* 39928 */
	"NUM_SE\0" /* 39935 */
	"DISABLE_SRBSL_DB_OPTIMIZED_PACKING\0" /* 39942 */
	"PERFMON_ENABLE\0" /* 39977 */
	"LEFT_QTR\0" /* 39992 */
	"LEFT_HALF\0" /* 40001 */
	"RIGHT_HALF\0" /* 40011 */
	"RIGHT_QTR\0" /* 40022 */
	"TOP_QTR\0" /* 40032 */
	"TOP_HALF\0" /* 40040 */
	"BOT_HALF\0" /* 40049 */
	"BOT_QTR\0" /* 40058 */
	"LEFT_EYE_FOV_LEFT\0" /* 40066 */
	"LEFT_EYE_FOV_RIGHT\0" /* 40084 */
	"RIGHT_EYE_FOV_LEFT\0" /* 40103 */
	"RIGHT_EYE_FOV_RIGHT\0" /* 40122 */
	"FOV_TOP\0" /* 40142 */
	"FOV_BOT\0" /* 40150 */
	"OBJ_ID_SEL\0" /* 40158 */
	"ADD_PIPED_PRIM_ID\0" /* 40169 */
	"EN_32BIT_OBJPRIMID\0" /* 40187 */
	"VERTEX_REUSE_OFF\0" /* 40206 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 40223 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 40247 */
	"DISCARD_0_AREA_LINES\0" /* 40272 */
	"DISCARD_0_AREA_POINTS\0" /* 40293 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 40315 */
	"USE_PROVOKING_ZW\0" /* 40341 */
	"MAX_PRIMS_PER_SUBGROUP\0" /* 40358 */
	"OBJPRIM_ID_EN\0" /* 40381 */
	"EN_REG_RT_INDEX\0" /* 40395 */
	"EN_PIPELINE_PRIMID\0" /* 40411 */
	"OBJECT_ID_INST_EN\0" /* 40430 */
	"COMPOUND_INDEX_EN\0" /* 40448 */
	"BINNING_ALLOWED\0" /* 40466 */
	"FORCE_BINNING_ON\0" /* 40482 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 40499 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 40526 */
	"BINNING_MODE\0" /* 40556 */
	"BIN_SIZE_X\0" /* 40569 */
	"BIN_SIZE_Y\0" /* 40580 */
	"BIN_SIZE_X_EXTEND\0" /* 40591 */
	"BIN_SIZE_Y_EXTEND\0" /* 40609 */
	"CONTEXT_STATES_PER_BIN\0" /* 40627 */
	"PERSISTENT_STATES_PER_BIN\0" /* 40650 */
	"DISABLE_START_OF_PRIM\0" /* 40676 */
	"FPOVS_PER_BATCH\0" /* 40698 */
	"OPTIMAL_BIN_SELECTION\0" /* 40714 */
	"MAX_ALLOC_COUNT\0" /* 40736 */
	"MAX_PRIM_PER_BATCH\0" /* 40752 */
	"OVER_RAST_ENABLE\0" /* 40771 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 40788 */
	"UNDER_RAST_ENABLE\0" /* 40812 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 40830 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 40855 */
	"ZMM_TRI_EXTENT\0" /* 40885 */
	"ZMM_TRI_OFFSET\0" /* 40900 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 40915 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 40950 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 40986 */
	"UNCERTAINTY_REGION_MODE\0" /* 41030 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 41054 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 41090 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 41126 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 41152 */
	"PREZ_AA_MASK_ENABLE\0" /* 41176 */
	"POSTZ_AA_MASK_ENABLE\0" /* 41196 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 41217 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 41242 */
	"BASE_256B\0" /* 41263 */
	"MIP0_HEIGHT\0" /* 41273 */
	"MIP0_WIDTH\0" /* 41285 */
	"DRAW_INDEX_LOC\0" /* 41296 */
	"IB_BASE_LO\0" /* 41311 */
	"IB_BASE_HI\0" /* 41322 */
	"CP_DMA_WORD0\0" /* 41333 */
	"CP_DMA_WORD1\0" /* 41346 */
	"CP_DMA_WORD2\0" /* 41359 */
	"CP_DMA_WORD3\0" /* 41372 */
	"COMMAND\0" /* 41385 */
	"DMA_DATA_WORD0\0" /* 41393 */
	"SRBM_STATUS2\0" /* 41408 */
	"SRBM_STATUS\0" /* 41421 */
	"SRBM_STATUS3\0" /* 41433 */
	"SDMA0_STATUS_REG\0" /* 41446 */
	"SDMA1_STATUS_REG\0" /* 41463 */
	"GRBM_STATUS2\0" /* 41480 */
	"GRBM_STATUS\0" /* 41493 */
	"CP_STRMOUT_CNTL\0" /* 41505 */
	"CP_COHER_CNTL\0" /* 41521 */
	"CP_COHER_SIZE\0" /* 41535 */
	"CP_COHER_BASE\0" /* 41549 */
	"GRBM_STATUS_SE0\0" /* 41563 */
	"GRBM_STATUS_SE1\0" /* 41579 */
	"GRBM_STATUS_SE2\0" /* 41595 */
	"GRBM_STATUS_SE3\0" /* 41611 */
	"CP_COHER_BASE_HI\0" /* 41627 */
	"CP_COHER_START_DELAY\0" /* 41644 */
	"CP_COHER_STATUS\0" /* 41665 */
	"CP_CPC_STATUS\0" /* 41681 */
	"CP_CPC_BUSY_STAT\0" /* 41695 */
	"CP_CPC_STALLED_STAT1\0" /* 41712 */
	"CP_CPF_STATUS\0" /* 41733 */
	"CP_CPF_BUSY_STAT\0" /* 41747 */
	"CP_CPF_STALLED_STAT1\0" /* 41764 */
	"CP_COHER_SIZE_HI\0" /* 41785 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 41802 */
	"VGT_CACHE_INVALIDATION\0" /* 41825 */
	"VGT_ESGS_RING_SIZE\0" /* 41848 */
	"VGT_GSVS_RING_SIZE\0" /* 41867 */
	"VGT_GS_VERTEX_REUSE\0" /* 41886 */
	"VGT_PRIMITIVE_TYPE\0" /* 41906 */
	"VGT_INDEX_TYPE\0" /* 41925 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 41940 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 41973 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 42006 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 42039 */
	"VGT_NUM_INDICES\0" /* 42072 */
	"VGT_NUM_INSTANCES\0" /* 42088 */
	"VGT_TF_RING_SIZE\0" /* 42106 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 42123 */
	"VGT_TF_MEMORY_BASE\0" /* 42144 */
	"PA_CL_ENHANCE\0" /* 42163 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 42177 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 42202 */
	"CP_STALLED_STAT3\0" /* 42227 */
	"CP_STALLED_STAT1\0" /* 42244 */
	"CP_STALLED_STAT2\0" /* 42261 */
	"CP_STAT\0" /* 42278 */
	"GRBM_GFX_INDEX\0" /* 42286 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 42301 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 42327 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 42353 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 42379 */
	"PA_SC_ENHANCE\0" /* 42405 */
	"SQC_CACHES\0" /* 42419 */
	"SQ_RANDOM_WAVE_PRI\0" /* 42430 */
	"SQ_EXP_0\0" /* 42449 */
	"TA_CS_BC_BASE_ADDR\0" /* 42458 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 42477 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 42499 */
	"SQ_BUF_RSRC_WORD0\0" /* 42523 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 42541 */
	"SQ_BUF_RSRC_WORD1\0" /* 42564 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 42582 */
	"SQ_BUF_RSRC_WORD2\0" /* 42606 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 42624 */
	"SQ_BUF_RSRC_WORD3\0" /* 42647 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 42665 */
	"SQ_IMG_RSRC_WORD0\0" /* 42689 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 42707 */
	"SQ_IMG_RSRC_WORD1\0" /* 42730 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 42748 */
	"SQ_IMG_RSRC_WORD2\0" /* 42772 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 42790 */
	"SQ_IMG_RSRC_WORD3\0" /* 42813 */
	"SQ_IMG_RSRC_WORD4\0" /* 42831 */
	"SQ_IMG_RSRC_WORD5\0" /* 42849 */
	"SQ_IMG_RSRC_WORD6\0" /* 42867 */
	"SQ_IMG_RSRC_WORD7\0" /* 42885 */
	"SQ_IMG_SAMP_WORD0\0" /* 42903 */
	"SQ_IMG_SAMP_WORD1\0" /* 42921 */
	"SQ_IMG_SAMP_WORD2\0" /* 42939 */
	"SQ_IMG_SAMP_WORD3\0" /* 42957 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 42975 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 42995 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 43020 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 43045 */
	"SPI_PS_MAX_WAVE_ID\0" /* 43070 */
	"SPI_ARB_PRIORITY\0" /* 43089 */
	"SPI_ARB_CYCLES_0\0" /* 43106 */
	"SPI_ARB_CYCLES_1\0" /* 43123 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 43140 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 43162 */
	"DB_ZPASS_COUNT_LOW\0" /* 43184 */
	"DB_ZPASS_COUNT_HI\0" /* 43203 */
	"SPI_CONFIG_CNTL\0" /* 43221 */
	"SPI_CONFIG_CNTL_1\0" /* 43237 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 43255 */
	"DB_SUBTILE_CONTROL\0" /* 43284 */
	"GB_ADDR_CONFIG\0" /* 43303 */
	"GB_TILE_MODE0\0" /* 43318 */
	"GB_TILE_MODE1\0" /* 43332 */
	"GB_TILE_MODE2\0" /* 43346 */
	"GB_TILE_MODE3\0" /* 43360 */
	"GB_TILE_MODE4\0" /* 43374 */
	"GB_TILE_MODE5\0" /* 43388 */
	"GB_TILE_MODE6\0" /* 43402 */
	"GB_TILE_MODE7\0" /* 43416 */
	"GB_TILE_MODE8\0" /* 43430 */
	"GB_TILE_MODE9\0" /* 43444 */
	"GB_TILE_MODE10\0" /* 43458 */
	"GB_TILE_MODE11\0" /* 43473 */
	"GB_TILE_MODE12\0" /* 43488 */
	"GB_TILE_MODE13\0" /* 43503 */
	"GB_TILE_MODE14\0" /* 43518 */
	"GB_TILE_MODE15\0" /* 43533 */
	"GB_TILE_MODE16\0" /* 43548 */
	"GB_TILE_MODE17\0" /* 43563 */
	"GB_TILE_MODE18\0" /* 43578 */
	"GB_TILE_MODE19\0" /* 43593 */
	"GB_TILE_MODE20\0" /* 43608 */
	"GB_TILE_MODE21\0" /* 43623 */
	"GB_TILE_MODE22\0" /* 43638 */
	"GB_TILE_MODE23\0" /* 43653 */
	"GB_TILE_MODE24\0" /* 43668 */
	"GB_TILE_MODE25\0" /* 43683 */
	"GB_TILE_MODE26\0" /* 43698 */
	"GB_TILE_MODE27\0" /* 43713 */
	"GB_TILE_MODE28\0" /* 43728 */
	"GB_TILE_MODE29\0" /* 43743 */
	"GB_TILE_MODE30\0" /* 43758 */
	"GB_TILE_MODE31\0" /* 43773 */
	"GB_MACROTILE_MODE0\0" /* 43788 */
	"GB_MACROTILE_MODE1\0" /* 43807 */
	"GB_MACROTILE_MODE2\0" /* 43826 */
	"GB_MACROTILE_MODE3\0" /* 43845 */
	"GB_MACROTILE_MODE4\0" /* 43864 */
	"GB_MACROTILE_MODE5\0" /* 43883 */
	"GB_MACROTILE_MODE6\0" /* 43902 */
	"GB_MACROTILE_MODE7\0" /* 43921 */
	"GB_MACROTILE_MODE8\0" /* 43940 */
	"GB_MACROTILE_MODE9\0" /* 43959 */
	"GB_MACROTILE_MODE10\0" /* 43978 */
	"GB_MACROTILE_MODE11\0" /* 43998 */
	"GB_MACROTILE_MODE12\0" /* 44018 */
	"GB_MACROTILE_MODE13\0" /* 44038 */
	"GB_MACROTILE_MODE14\0" /* 44058 */
	"GB_MACROTILE_MODE15\0" /* 44078 */
	"SPI_SHADER_TBA_LO_PS\0" /* 44098 */
	"SPI_SHADER_TBA_HI_PS\0" /* 44119 */
	"SPI_SHADER_TMA_LO_PS\0" /* 44140 */
	"SPI_SHADER_TMA_HI_PS\0" /* 44161 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 44182 */
	"SPI_SHADER_PGM_LO_PS\0" /* 44206 */
	"SPI_SHADER_PGM_HI_PS\0" /* 44227 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 44248 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 44272 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 44296 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 44322 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 44348 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 44374 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 44400 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 44426 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 44452 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 44478 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 44504 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 44530 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 44556 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 44583 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 44610 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 44637 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 44664 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 44691 */
	"SPI_SHADER_TBA_LO_VS\0" /* 44718 */
	"SPI_SHADER_TBA_HI_VS\0" /* 44739 */
	"SPI_SHADER_TMA_LO_VS\0" /* 44760 */
	"SPI_SHADER_TMA_HI_VS\0" /* 44781 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 44802 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 44826 */
	"SPI_SHADER_PGM_LO_VS\0" /* 44851 */
	"SPI_SHADER_PGM_HI_VS\0" /* 44872 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 44893 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 44917 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 44941 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 44967 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 44993 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 45019 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 45045 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 45071 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 45097 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 45123 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 45149 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 45175 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 45201 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 45228 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 45255 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 45282 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 45309 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 45336 */
	"SPI_SHADER_TBA_LO_GS\0" /* 45363 */
	"SPI_SHADER_TBA_HI_GS\0" /* 45384 */
	"SPI_SHADER_TMA_LO_GS\0" /* 45405 */
	"SPI_SHADER_TMA_HI_GS\0" /* 45426 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 45447 */
	"SPI_SHADER_PGM_LO_GS\0" /* 45471 */
	"SPI_SHADER_PGM_HI_GS\0" /* 45492 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 45513 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 45537 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 45561 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 45587 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 45613 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 45639 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 45665 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 45691 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 45717 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 45743 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 45769 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 45795 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 45821 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 45848 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 45875 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 45902 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 45929 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 45956 */
	"SPI_SHADER_TBA_LO_ES\0" /* 45983 */
	"SPI_SHADER_TBA_HI_ES\0" /* 46004 */
	"SPI_SHADER_TMA_LO_ES\0" /* 46025 */
	"SPI_SHADER_TMA_HI_ES\0" /* 46046 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 46067 */
	"SPI_SHADER_PGM_LO_ES\0" /* 46091 */
	"SPI_SHADER_PGM_HI_ES\0" /* 46112 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 46133 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 46157 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 46181 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 46207 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 46233 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 46259 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 46285 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 46311 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 46337 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 46363 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 46389 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 46415 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 46441 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 46468 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 46495 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 46522 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 46549 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 46576 */
	"SPI_SHADER_TBA_LO_HS\0" /* 46603 */
	"SPI_SHADER_TBA_HI_HS\0" /* 46624 */
	"SPI_SHADER_TMA_LO_HS\0" /* 46645 */
	"SPI_SHADER_TMA_HI_HS\0" /* 46666 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 46687 */
	"SPI_SHADER_PGM_LO_HS\0" /* 46711 */
	"SPI_SHADER_PGM_HI_HS\0" /* 46732 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 46753 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 46777 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 46801 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 46827 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 46853 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 46879 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 46905 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 46931 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 46957 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 46983 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 47009 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 47035 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 47061 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 47088 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 47115 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 47142 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 47169 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 47196 */
	"SPI_SHADER_TBA_LO_LS\0" /* 47223 */
	"SPI_SHADER_TBA_HI_LS\0" /* 47244 */
	"SPI_SHADER_TMA_LO_LS\0" /* 47265 */
	"SPI_SHADER_TMA_HI_LS\0" /* 47286 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 47307 */
	"SPI_SHADER_PGM_LO_LS\0" /* 47331 */
	"SPI_SHADER_PGM_HI_LS\0" /* 47352 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 47373 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 47397 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 47421 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 47447 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 47473 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 47499 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 47525 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 47551 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 47577 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 47603 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 47629 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 47655 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 47681 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 47708 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 47735 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 47762 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 47789 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 47816 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 47843 */
	"COMPUTE_DIM_X\0" /* 47870 */
	"COMPUTE_DIM_Y\0" /* 47884 */
	"COMPUTE_DIM_Z\0" /* 47898 */
	"COMPUTE_START_X\0" /* 47912 */
	"COMPUTE_START_Y\0" /* 47928 */
	"COMPUTE_START_Z\0" /* 47944 */
	"COMPUTE_NUM_THREAD_X\0" /* 47960 */
	"COMPUTE_NUM_THREAD_Y\0" /* 47981 */
	"COMPUTE_NUM_THREAD_Z\0" /* 48002 */
	"COMPUTE_MAX_WAVE_ID\0" /* 48023 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 48043 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 48071 */
	"COMPUTE_PGM_LO\0" /* 48096 */
	"COMPUTE_PGM_HI\0" /* 48111 */
	"COMPUTE_TBA_LO\0" /* 48126 */
	"COMPUTE_TBA_HI\0" /* 48141 */
	"COMPUTE_TMA_LO\0" /* 48156 */
	"COMPUTE_TMA_HI\0" /* 48171 */
	"COMPUTE_PGM_RSRC1\0" /* 48186 */
	"COMPUTE_PGM_RSRC2\0" /* 48204 */
	"COMPUTE_VMID\0" /* 48222 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 48235 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 48259 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 48290 */
	"COMPUTE_TMPRING_SIZE\0" /* 48321 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 48342 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 48373 */
	"COMPUTE_RESTART_X\0" /* 48404 */
	"COMPUTE_RESTART_Y\0" /* 48422 */
	"COMPUTE_RESTART_Z\0" /* 48440 */
	"COMPUTE_MISC_RESERVED\0" /* 48458 */
	"COMPUTE_DISPATCH_ID\0" /* 48480 */
	"COMPUTE_THREADGROUP_ID\0" /* 48500 */
	"COMPUTE_RELAUNCH\0" /* 48523 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 48540 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 48569 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 48598 */
	"COMPUTE_USER_DATA_0\0" /* 48627 */
	"COMPUTE_USER_DATA_1\0" /* 48647 */
	"COMPUTE_USER_DATA_2\0" /* 48667 */
	"COMPUTE_USER_DATA_3\0" /* 48687 */
	"COMPUTE_USER_DATA_4\0" /* 48707 */
	"COMPUTE_USER_DATA_5\0" /* 48727 */
	"COMPUTE_USER_DATA_6\0" /* 48747 */
	"COMPUTE_USER_DATA_7\0" /* 48767 */
	"COMPUTE_USER_DATA_8\0" /* 48787 */
	"COMPUTE_USER_DATA_9\0" /* 48807 */
	"COMPUTE_USER_DATA_10\0" /* 48827 */
	"COMPUTE_USER_DATA_11\0" /* 48848 */
	"COMPUTE_USER_DATA_12\0" /* 48869 */
	"COMPUTE_USER_DATA_13\0" /* 48890 */
	"COMPUTE_USER_DATA_14\0" /* 48911 */
	"COMPUTE_USER_DATA_15\0" /* 48932 */
	"COMPUTE_NOWHERE\0" /* 48953 */
	"CPG_PERFCOUNTER1_LO\0" /* 48969 */
	"CPG_PERFCOUNTER1_HI\0" /* 48989 */
	"CPG_PERFCOUNTER0_LO\0" /* 49009 */
	"CPG_PERFCOUNTER0_HI\0" /* 49029 */
	"CPC_PERFCOUNTER1_LO\0" /* 49049 */
	"CPC_PERFCOUNTER1_HI\0" /* 49069 */
	"CPC_PERFCOUNTER0_LO\0" /* 49089 */
	"CPC_PERFCOUNTER0_HI\0" /* 49109 */
	"CPF_PERFCOUNTER1_LO\0" /* 49129 */
	"CPF_PERFCOUNTER1_HI\0" /* 49149 */
	"CPF_PERFCOUNTER0_LO\0" /* 49169 */
	"CPF_PERFCOUNTER0_HI\0" /* 49189 */
	"GRBM_PERFCOUNTER0_LO\0" /* 49209 */
	"GRBM_PERFCOUNTER0_HI\0" /* 49230 */
	"GRBM_PERFCOUNTER1_LO\0" /* 49251 */
	"GRBM_PERFCOUNTER1_HI\0" /* 49272 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 49293 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 49317 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 49341 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 49365 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 49389 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 49413 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 49437 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 49461 */
	"WD_PERFCOUNTER0_LO\0" /* 49485 */
	"WD_PERFCOUNTER0_HI\0" /* 49504 */
	"WD_PERFCOUNTER1_LO\0" /* 49523 */
	"WD_PERFCOUNTER1_HI\0" /* 49542 */
	"WD_PERFCOUNTER2_LO\0" /* 49561 */
	"WD_PERFCOUNTER2_HI\0" /* 49580 */
	"WD_PERFCOUNTER3_LO\0" /* 49599 */
	"WD_PERFCOUNTER3_HI\0" /* 49618 */
	"IA_PERFCOUNTER0_LO\0" /* 49637 */
	"IA_PERFCOUNTER0_HI\0" /* 49656 */
	"IA_PERFCOUNTER1_LO\0" /* 49675 */
	"IA_PERFCOUNTER1_HI\0" /* 49694 */
	"IA_PERFCOUNTER2_LO\0" /* 49713 */
	"IA_PERFCOUNTER2_HI\0" /* 49732 */
	"IA_PERFCOUNTER3_LO\0" /* 49751 */
	"IA_PERFCOUNTER3_HI\0" /* 49770 */
	"VGT_PERFCOUNTER0_LO\0" /* 49789 */
	"VGT_PERFCOUNTER0_HI\0" /* 49809 */
	"VGT_PERFCOUNTER1_LO\0" /* 49829 */
	"VGT_PERFCOUNTER1_HI\0" /* 49849 */
	"VGT_PERFCOUNTER2_LO\0" /* 49869 */
	"VGT_PERFCOUNTER2_HI\0" /* 49889 */
	"VGT_PERFCOUNTER3_LO\0" /* 49909 */
	"VGT_PERFCOUNTER3_HI\0" /* 49929 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 49949 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 49971 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 49993 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 50015 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 50037 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 50059 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 50081 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 50103 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 50125 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 50147 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 50169 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 50191 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 50213 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 50235 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 50257 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 50279 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 50301 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 50323 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 50345 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 50367 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 50389 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 50411 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 50433 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 50455 */
	"SPI_PERFCOUNTER0_HI\0" /* 50477 */
	"SPI_PERFCOUNTER0_LO\0" /* 50497 */
	"SPI_PERFCOUNTER1_HI\0" /* 50517 */
	"SPI_PERFCOUNTER1_LO\0" /* 50537 */
	"SPI_PERFCOUNTER2_HI\0" /* 50557 */
	"SPI_PERFCOUNTER2_LO\0" /* 50577 */
	"SPI_PERFCOUNTER3_HI\0" /* 50597 */
	"SPI_PERFCOUNTER3_LO\0" /* 50617 */
	"SPI_PERFCOUNTER4_HI\0" /* 50637 */
	"SPI_PERFCOUNTER4_LO\0" /* 50657 */
	"SPI_PERFCOUNTER5_HI\0" /* 50677 */
	"SPI_PERFCOUNTER5_LO\0" /* 50697 */
	"SQ_PERFCOUNTER0_LO\0" /* 50717 */
	"SQ_PERFCOUNTER0_HI\0" /* 50736 */
	"SQ_PERFCOUNTER1_LO\0" /* 50755 */
	"SQ_PERFCOUNTER1_HI\0" /* 50774 */
	"SQ_PERFCOUNTER2_LO\0" /* 50793 */
	"SQ_PERFCOUNTER2_HI\0" /* 50812 */
	"SQ_PERFCOUNTER3_LO\0" /* 50831 */
	"SQ_PERFCOUNTER3_HI\0" /* 50850 */
	"SQ_PERFCOUNTER4_LO\0" /* 50869 */
	"SQ_PERFCOUNTER4_HI\0" /* 50888 */
	"SQ_PERFCOUNTER5_LO\0" /* 50907 */
	"SQ_PERFCOUNTER5_HI\0" /* 50926 */
	"SQ_PERFCOUNTER6_LO\0" /* 50945 */
	"SQ_PERFCOUNTER6_HI\0" /* 50964 */
	"SQ_PERFCOUNTER7_LO\0" /* 50983 */
	"SQ_PERFCOUNTER7_HI\0" /* 51002 */
	"SQ_PERFCOUNTER8_LO\0" /* 51021 */
	"SQ_PERFCOUNTER8_HI\0" /* 51040 */
	"SQ_PERFCOUNTER9_LO\0" /* 51059 */
	"SQ_PERFCOUNTER9_HI\0" /* 51078 */
	"SQ_PERFCOUNTER10_LO\0" /* 51097 */
	"SQ_PERFCOUNTER10_HI\0" /* 51117 */
	"SQ_PERFCOUNTER11_LO\0" /* 51137 */
	"SQ_PERFCOUNTER11_HI\0" /* 51157 */
	"SQ_PERFCOUNTER12_LO\0" /* 51177 */
	"SQ_PERFCOUNTER12_HI\0" /* 51197 */
	"SQ_PERFCOUNTER13_LO\0" /* 51217 */
	"SQ_PERFCOUNTER13_HI\0" /* 51237 */
	"SQ_PERFCOUNTER14_LO\0" /* 51257 */
	"SQ_PERFCOUNTER14_HI\0" /* 51277 */
	"SQ_PERFCOUNTER15_LO\0" /* 51297 */
	"SQ_PERFCOUNTER15_HI\0" /* 51317 */
	"SX_PERFCOUNTER0_LO\0" /* 51337 */
	"SX_PERFCOUNTER0_HI\0" /* 51356 */
	"SX_PERFCOUNTER1_LO\0" /* 51375 */
	"SX_PERFCOUNTER1_HI\0" /* 51394 */
	"SX_PERFCOUNTER2_LO\0" /* 51413 */
	"SX_PERFCOUNTER2_HI\0" /* 51432 */
	"SX_PERFCOUNTER3_LO\0" /* 51451 */
	"SX_PERFCOUNTER3_HI\0" /* 51470 */
	"GDS_PERFCOUNTER0_LO\0" /* 51489 */
	"GDS_PERFCOUNTER0_HI\0" /* 51509 */
	"GDS_PERFCOUNTER1_LO\0" /* 51529 */
	"GDS_PERFCOUNTER1_HI\0" /* 51549 */
	"GDS_PERFCOUNTER2_LO\0" /* 51569 */
	"GDS_PERFCOUNTER2_HI\0" /* 51589 */
	"GDS_PERFCOUNTER3_LO\0" /* 51609 */
	"GDS_PERFCOUNTER3_HI\0" /* 51629 */
	"TA_PERFCOUNTER0_LO\0" /* 51649 */
	"TA_PERFCOUNTER0_HI\0" /* 51668 */
	"TA_PERFCOUNTER1_LO\0" /* 51687 */
	"TA_PERFCOUNTER1_HI\0" /* 51706 */
	"TD_PERFCOUNTER0_LO\0" /* 51725 */
	"TD_PERFCOUNTER0_HI\0" /* 51744 */
	"TD_PERFCOUNTER1_LO\0" /* 51763 */
	"TD_PERFCOUNTER1_HI\0" /* 51782 */
	"TCP_PERFCOUNTER0_LO\0" /* 51801 */
	"TCP_PERFCOUNTER0_HI\0" /* 51821 */
	"TCP_PERFCOUNTER1_LO\0" /* 51841 */
	"TCP_PERFCOUNTER1_HI\0" /* 51861 */
	"TCP_PERFCOUNTER2_LO\0" /* 51881 */
	"TCP_PERFCOUNTER2_HI\0" /* 51901 */
	"TCP_PERFCOUNTER3_LO\0" /* 51921 */
	"TCP_PERFCOUNTER3_HI\0" /* 51941 */
	"TCC_PERFCOUNTER0_LO\0" /* 51961 */
	"TCC_PERFCOUNTER0_HI\0" /* 51981 */
	"TCC_PERFCOUNTER1_LO\0" /* 52001 */
	"TCC_PERFCOUNTER1_HI\0" /* 52021 */
	"TCC_PERFCOUNTER2_LO\0" /* 52041 */
	"TCC_PERFCOUNTER2_HI\0" /* 52061 */
	"TCC_PERFCOUNTER3_LO\0" /* 52081 */
	"TCC_PERFCOUNTER3_HI\0" /* 52101 */
	"TCA_PERFCOUNTER0_LO\0" /* 52121 */
	"TCA_PERFCOUNTER0_HI\0" /* 52141 */
	"TCA_PERFCOUNTER1_LO\0" /* 52161 */
	"TCA_PERFCOUNTER1_HI\0" /* 52181 */
	"TCA_PERFCOUNTER2_LO\0" /* 52201 */
	"TCA_PERFCOUNTER2_HI\0" /* 52221 */
	"TCA_PERFCOUNTER3_LO\0" /* 52241 */
	"TCA_PERFCOUNTER3_HI\0" /* 52261 */
	"CB_PERFCOUNTER0_LO\0" /* 52281 */
	"CB_PERFCOUNTER0_HI\0" /* 52300 */
	"CB_PERFCOUNTER1_LO\0" /* 52319 */
	"CB_PERFCOUNTER1_HI\0" /* 52338 */
	"CB_PERFCOUNTER2_LO\0" /* 52357 */
	"CB_PERFCOUNTER2_HI\0" /* 52376 */
	"CB_PERFCOUNTER3_LO\0" /* 52395 */
	"CB_PERFCOUNTER3_HI\0" /* 52414 */
	"DB_PERFCOUNTER0_LO\0" /* 52433 */
	"DB_PERFCOUNTER0_HI\0" /* 52452 */
	"DB_PERFCOUNTER1_LO\0" /* 52471 */
	"DB_PERFCOUNTER1_HI\0" /* 52490 */
	"DB_PERFCOUNTER2_LO\0" /* 52509 */
	"DB_PERFCOUNTER2_HI\0" /* 52528 */
	"DB_PERFCOUNTER3_LO\0" /* 52547 */
	"DB_PERFCOUNTER3_HI\0" /* 52566 */
	"RLC_PERFCOUNTER0_LO\0" /* 52585 */
	"RLC_PERFCOUNTER0_HI\0" /* 52605 */
	"RLC_PERFCOUNTER1_LO\0" /* 52625 */
	"RLC_PERFCOUNTER1_HI\0" /* 52645 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 52665 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 52689 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 52714 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 52738 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 52762 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 52787 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 52811 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 52836 */
	"CP_PERFMON_CNTL\0" /* 52860 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 52876 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 52900 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 52925 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 52950 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 52978 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 53006 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 53034 */
	"WD_PERFCOUNTER0_SELECT\0" /* 53062 */
	"WD_PERFCOUNTER1_SELECT\0" /* 53085 */
	"WD_PERFCOUNTER2_SELECT\0" /* 53108 */
	"WD_PERFCOUNTER3_SELECT\0" /* 53131 */
	"IA_PERFCOUNTER0_SELECT\0" /* 53154 */
	"IA_PERFCOUNTER1_SELECT\0" /* 53177 */
	"IA_PERFCOUNTER2_SELECT\0" /* 53200 */
	"IA_PERFCOUNTER3_SELECT\0" /* 53223 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 53246 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 53270 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 53294 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 53318 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 53342 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 53366 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 53391 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 53416 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 53442 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 53468 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 53495 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 53521 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 53548 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 53574 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 53600 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 53626 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 53653 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 53679 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 53705 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 53731 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 53757 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 53783 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 53809 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 53835 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 53859 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 53883 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 53907 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 53931 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 53956 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 53981 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 54006 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 54031 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 54055 */
	"SPI_PERFCOUNTER_BINS\0" /* 54079 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 54100 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 54123 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 54146 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 54169 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 54192 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 54215 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 54238 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 54261 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 54284 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 54307 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 54330 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 54354 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 54378 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 54402 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 54426 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 54450 */
	"SQ_PERFCOUNTER_CTRL\0" /* 54474 */
	"SQ_PERFCOUNTER_MASK\0" /* 54494 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 54514 */
	"SX_PERFCOUNTER0_SELECT\0" /* 54535 */
	"SX_PERFCOUNTER1_SELECT\0" /* 54558 */
	"SX_PERFCOUNTER2_SELECT\0" /* 54581 */
	"SX_PERFCOUNTER3_SELECT\0" /* 54604 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 54627 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 54651 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 54675 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 54699 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 54723 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 54747 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 54771 */
	"TA_PERFCOUNTER0_SELECT\0" /* 54796 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 54819 */
	"TA_PERFCOUNTER1_SELECT\0" /* 54843 */
	"TD_PERFCOUNTER0_SELECT\0" /* 54866 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 54889 */
	"TD_PERFCOUNTER1_SELECT\0" /* 54913 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 54936 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 54960 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 54985 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 55009 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 55034 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 55058 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 55082 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 55106 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 55131 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 55155 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 55180 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 55204 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 55228 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 55252 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 55277 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 55301 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 55326 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 55350 */
	"CB_PERFCOUNTER_FILTER\0" /* 55374 */
	"CB_PERFCOUNTER0_SELECT\0" /* 55396 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 55419 */
	"CB_PERFCOUNTER1_SELECT\0" /* 55443 */
	"CB_PERFCOUNTER2_SELECT\0" /* 55466 */
	"CB_PERFCOUNTER3_SELECT\0" /* 55489 */
	"DB_PERFCOUNTER0_SELECT\0" /* 55512 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 55535 */
	"DB_PERFCOUNTER1_SELECT\0" /* 55559 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 55582 */
	"DB_PERFCOUNTER2_SELECT\0" /* 55606 */
	"DB_PERFCOUNTER3_SELECT\0" /* 55629 */
	"DB_RENDER_CONTROL\0" /* 55652 */
	"DB_COUNT_CONTROL\0" /* 55670 */
	"DB_DEPTH_VIEW\0" /* 55687 */
	"DB_RENDER_OVERRIDE\0" /* 55701 */
	"DB_RENDER_OVERRIDE2\0" /* 55720 */
	"DB_HTILE_DATA_BASE\0" /* 55740 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 55759 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 55779 */
	"DB_STENCIL_CLEAR\0" /* 55799 */
	"DB_DEPTH_CLEAR\0" /* 55816 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 55831 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 55855 */
	"DB_DEPTH_INFO\0" /* 55879 */
	"DB_Z_INFO\0" /* 55893 */
	"DB_STENCIL_INFO\0" /* 55903 */
	"DB_Z_READ_BASE\0" /* 55919 */
	"DB_STENCIL_READ_BASE\0" /* 55934 */
	"DB_Z_WRITE_BASE\0" /* 55955 */
	"DB_STENCIL_WRITE_BASE\0" /* 55971 */
	"DB_DEPTH_SIZE\0" /* 55993 */
	"DB_DEPTH_SLICE\0" /* 56007 */
	"TA_BC_BASE_ADDR\0" /* 56022 */
	"TA_BC_BASE_ADDR_HI\0" /* 56038 */
	"COHER_DEST_BASE_HI_0\0" /* 56057 */
	"COHER_DEST_BASE_HI_1\0" /* 56078 */
	"COHER_DEST_BASE_HI_2\0" /* 56099 */
	"COHER_DEST_BASE_HI_3\0" /* 56120 */
	"COHER_DEST_BASE_2\0" /* 56141 */
	"COHER_DEST_BASE_3\0" /* 56159 */
	"PA_SC_WINDOW_OFFSET\0" /* 56177 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 56197 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 56221 */
	"PA_SC_CLIPRECT_RULE\0" /* 56245 */
	"PA_SC_CLIPRECT_0_TL\0" /* 56265 */
	"PA_SC_CLIPRECT_0_BR\0" /* 56285 */
	"PA_SC_CLIPRECT_1_TL\0" /* 56305 */
	"PA_SC_CLIPRECT_1_BR\0" /* 56325 */
	"PA_SC_CLIPRECT_2_TL\0" /* 56345 */
	"PA_SC_CLIPRECT_2_BR\0" /* 56365 */
	"PA_SC_CLIPRECT_3_TL\0" /* 56385 */
	"PA_SC_CLIPRECT_3_BR\0" /* 56405 */
	"PA_SC_EDGERULE\0" /* 56425 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 56440 */
	"CB_TARGET_MASK\0" /* 56469 */
	"CB_SHADER_MASK\0" /* 56484 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 56499 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 56524 */
	"COHER_DEST_BASE_0\0" /* 56549 */
	"COHER_DEST_BASE_1\0" /* 56567 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 56585 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 56610 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 56635 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 56660 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 56685 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 56710 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 56735 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 56760 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 56785 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 56810 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 56835 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 56860 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 56885 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 56910 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 56935 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 56960 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 56985 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 57010 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 57035 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 57060 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 57085 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 57111 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 57137 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 57163 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 57189 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 57215 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 57241 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 57267 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 57293 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 57319 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 57345 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 57371 */
	"PA_SC_VPORT_ZMIN_0\0" /* 57397 */
	"PA_SC_VPORT_ZMAX_0\0" /* 57416 */
	"PA_SC_VPORT_ZMIN_1\0" /* 57435 */
	"PA_SC_VPORT_ZMAX_1\0" /* 57454 */
	"PA_SC_VPORT_ZMIN_2\0" /* 57473 */
	"PA_SC_VPORT_ZMAX_2\0" /* 57492 */
	"PA_SC_VPORT_ZMIN_3\0" /* 57511 */
	"PA_SC_VPORT_ZMAX_3\0" /* 57530 */
	"PA_SC_VPORT_ZMIN_4\0" /* 57549 */
	"PA_SC_VPORT_ZMAX_4\0" /* 57568 */
	"PA_SC_VPORT_ZMIN_5\0" /* 57587 */
	"PA_SC_VPORT_ZMAX_5\0" /* 57606 */
	"PA_SC_VPORT_ZMIN_6\0" /* 57625 */
	"PA_SC_VPORT_ZMAX_6\0" /* 57644 */
	"PA_SC_VPORT_ZMIN_7\0" /* 57663 */
	"PA_SC_VPORT_ZMAX_7\0" /* 57682 */
	"PA_SC_VPORT_ZMIN_8\0" /* 57701 */
	"PA_SC_VPORT_ZMAX_8\0" /* 57720 */
	"PA_SC_VPORT_ZMIN_9\0" /* 57739 */
	"PA_SC_VPORT_ZMAX_9\0" /* 57758 */
	"PA_SC_VPORT_ZMIN_10\0" /* 57777 */
	"PA_SC_VPORT_ZMAX_10\0" /* 57797 */
	"PA_SC_VPORT_ZMIN_11\0" /* 57817 */
	"PA_SC_VPORT_ZMAX_11\0" /* 57837 */
	"PA_SC_VPORT_ZMIN_12\0" /* 57857 */
	"PA_SC_VPORT_ZMAX_12\0" /* 57877 */
	"PA_SC_VPORT_ZMIN_13\0" /* 57897 */
	"PA_SC_VPORT_ZMAX_13\0" /* 57917 */
	"PA_SC_VPORT_ZMIN_14\0" /* 57937 */
	"PA_SC_VPORT_ZMAX_14\0" /* 57957 */
	"PA_SC_VPORT_ZMIN_15\0" /* 57977 */
	"PA_SC_VPORT_ZMAX_15\0" /* 57997 */
	"PA_SC_RASTER_CONFIG\0" /* 58017 */
	"PA_SC_RASTER_CONFIG_1\0" /* 58037 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 58059 */
	"VGT_MAX_VTX_INDX\0" /* 58087 */
	"VGT_MIN_VTX_INDX\0" /* 58104 */
	"VGT_INDX_OFFSET\0" /* 58121 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 58137 */
	"CB_BLEND_RED\0" /* 58166 */
	"CB_BLEND_GREEN\0" /* 58179 */
	"CB_BLEND_BLUE\0" /* 58194 */
	"CB_BLEND_ALPHA\0" /* 58208 */
	"CB_DCC_CONTROL\0" /* 58223 */
	"DB_STENCIL_CONTROL\0" /* 58238 */
	"DB_STENCILREFMASK\0" /* 58257 */
	"DB_STENCILREFMASK_BF\0" /* 58275 */
	"PA_CL_VPORT_XSCALE\0" /* 58296 */
	"PA_CL_VPORT_XOFFSET\0" /* 58315 */
	"PA_CL_VPORT_YSCALE\0" /* 58335 */
	"PA_CL_VPORT_YOFFSET\0" /* 58354 */
	"PA_CL_VPORT_ZSCALE\0" /* 58374 */
	"PA_CL_VPORT_ZOFFSET\0" /* 58393 */
	"PA_CL_VPORT_XSCALE_1\0" /* 58413 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 58434 */
	"PA_CL_VPORT_YSCALE_1\0" /* 58456 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 58477 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 58499 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 58520 */
	"PA_CL_VPORT_XSCALE_2\0" /* 58542 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 58563 */
	"PA_CL_VPORT_YSCALE_2\0" /* 58585 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 58606 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 58628 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 58649 */
	"PA_CL_VPORT_XSCALE_3\0" /* 58671 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 58692 */
	"PA_CL_VPORT_YSCALE_3\0" /* 58714 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 58735 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 58757 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 58778 */
	"PA_CL_VPORT_XSCALE_4\0" /* 58800 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 58821 */
	"PA_CL_VPORT_YSCALE_4\0" /* 58843 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 58864 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 58886 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 58907 */
	"PA_CL_VPORT_XSCALE_5\0" /* 58929 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 58950 */
	"PA_CL_VPORT_YSCALE_5\0" /* 58972 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 58993 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 59015 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 59036 */
	"PA_CL_VPORT_XSCALE_6\0" /* 59058 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 59079 */
	"PA_CL_VPORT_YSCALE_6\0" /* 59101 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 59122 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 59144 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 59165 */
	"PA_CL_VPORT_XSCALE_7\0" /* 59187 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 59208 */
	"PA_CL_VPORT_YSCALE_7\0" /* 59230 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 59251 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 59273 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 59294 */
	"PA_CL_VPORT_XSCALE_8\0" /* 59316 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 59337 */
	"PA_CL_VPORT_YSCALE_8\0" /* 59359 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 59380 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 59402 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 59423 */
	"PA_CL_VPORT_XSCALE_9\0" /* 59445 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 59466 */
	"PA_CL_VPORT_YSCALE_9\0" /* 59488 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 59509 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 59531 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 59552 */
	"PA_CL_VPORT_XSCALE_10\0" /* 59574 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 59596 */
	"PA_CL_VPORT_YSCALE_10\0" /* 59619 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 59641 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 59664 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 59686 */
	"PA_CL_VPORT_XSCALE_11\0" /* 59709 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 59731 */
	"PA_CL_VPORT_YSCALE_11\0" /* 59754 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 59776 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 59799 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 59821 */
	"PA_CL_VPORT_XSCALE_12\0" /* 59844 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 59866 */
	"PA_CL_VPORT_YSCALE_12\0" /* 59889 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 59911 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 59934 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 59956 */
	"PA_CL_VPORT_XSCALE_13\0" /* 59979 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 60001 */
	"PA_CL_VPORT_YSCALE_13\0" /* 60024 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 60046 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 60069 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 60091 */
	"PA_CL_VPORT_XSCALE_14\0" /* 60114 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 60136 */
	"PA_CL_VPORT_YSCALE_14\0" /* 60159 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 60181 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 60204 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 60226 */
	"PA_CL_VPORT_XSCALE_15\0" /* 60249 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 60271 */
	"PA_CL_VPORT_YSCALE_15\0" /* 60294 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 60316 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 60339 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 60361 */
	"PA_CL_UCP_0_X\0" /* 60384 */
	"PA_CL_UCP_0_Y\0" /* 60398 */
	"PA_CL_UCP_0_Z\0" /* 60412 */
	"PA_CL_UCP_0_W\0" /* 60426 */
	"PA_CL_UCP_1_X\0" /* 60440 */
	"PA_CL_UCP_1_Y\0" /* 60454 */
	"PA_CL_UCP_1_Z\0" /* 60468 */
	"PA_CL_UCP_1_W\0" /* 60482 */
	"PA_CL_UCP_2_X\0" /* 60496 */
	"PA_CL_UCP_2_Y\0" /* 60510 */
	"PA_CL_UCP_2_Z\0" /* 60524 */
	"PA_CL_UCP_2_W\0" /* 60538 */
	"PA_CL_UCP_3_X\0" /* 60552 */
	"PA_CL_UCP_3_Y\0" /* 60566 */
	"PA_CL_UCP_3_Z\0" /* 60580 */
	"PA_CL_UCP_3_W\0" /* 60594 */
	"PA_CL_UCP_4_X\0" /* 60608 */
	"PA_CL_UCP_4_Y\0" /* 60622 */
	"PA_CL_UCP_4_Z\0" /* 60636 */
	"PA_CL_UCP_4_W\0" /* 60650 */
	"PA_CL_UCP_5_X\0" /* 60664 */
	"PA_CL_UCP_5_Y\0" /* 60678 */
	"PA_CL_UCP_5_Z\0" /* 60692 */
	"PA_CL_UCP_5_W\0" /* 60706 */
	"SPI_PS_INPUT_CNTL_0\0" /* 60720 */
	"SPI_PS_INPUT_CNTL_1\0" /* 60740 */
	"SPI_PS_INPUT_CNTL_2\0" /* 60760 */
	"SPI_PS_INPUT_CNTL_3\0" /* 60780 */
	"SPI_PS_INPUT_CNTL_4\0" /* 60800 */
	"SPI_PS_INPUT_CNTL_5\0" /* 60820 */
	"SPI_PS_INPUT_CNTL_6\0" /* 60840 */
	"SPI_PS_INPUT_CNTL_7\0" /* 60860 */
	"SPI_PS_INPUT_CNTL_8\0" /* 60880 */
	"SPI_PS_INPUT_CNTL_9\0" /* 60900 */
	"SPI_PS_INPUT_CNTL_10\0" /* 60920 */
	"SPI_PS_INPUT_CNTL_11\0" /* 60941 */
	"SPI_PS_INPUT_CNTL_12\0" /* 60962 */
	"SPI_PS_INPUT_CNTL_13\0" /* 60983 */
	"SPI_PS_INPUT_CNTL_14\0" /* 61004 */
	"SPI_PS_INPUT_CNTL_15\0" /* 61025 */
	"SPI_PS_INPUT_CNTL_16\0" /* 61046 */
	"SPI_PS_INPUT_CNTL_17\0" /* 61067 */
	"SPI_PS_INPUT_CNTL_18\0" /* 61088 */
	"SPI_PS_INPUT_CNTL_19\0" /* 61109 */
	"SPI_PS_INPUT_CNTL_20\0" /* 61130 */
	"SPI_PS_INPUT_CNTL_21\0" /* 61151 */
	"SPI_PS_INPUT_CNTL_22\0" /* 61172 */
	"SPI_PS_INPUT_CNTL_23\0" /* 61193 */
	"SPI_PS_INPUT_CNTL_24\0" /* 61214 */
	"SPI_PS_INPUT_CNTL_25\0" /* 61235 */
	"SPI_PS_INPUT_CNTL_26\0" /* 61256 */
	"SPI_PS_INPUT_CNTL_27\0" /* 61277 */
	"SPI_PS_INPUT_CNTL_28\0" /* 61298 */
	"SPI_PS_INPUT_CNTL_29\0" /* 61319 */
	"SPI_PS_INPUT_CNTL_30\0" /* 61340 */
	"SPI_PS_INPUT_CNTL_31\0" /* 61361 */
	"SPI_VS_OUT_CONFIG\0" /* 61382 */
	"SPI_PS_INPUT_ENA\0" /* 61400 */
	"SPI_PS_INPUT_ADDR\0" /* 61417 */
	"SPI_INTERP_CONTROL_0\0" /* 61435 */
	"SPI_PS_IN_CONTROL\0" /* 61456 */
	"SPI_BARYC_CNTL\0" /* 61474 */
	"SPI_TMPRING_SIZE\0" /* 61489 */
	"SPI_WAVE_MGMT_1\0" /* 61506 */
	"SPI_WAVE_MGMT_2\0" /* 61522 */
	"SPI_SHADER_POS_FORMAT\0" /* 61538 */
	"SPI_SHADER_Z_FORMAT\0" /* 61560 */
	"SPI_SHADER_COL_FORMAT\0" /* 61580 */
	"SX_PS_DOWNCONVERT\0" /* 61602 */
	"SX_BLEND_OPT_EPSILON\0" /* 61620 */
	"SX_BLEND_OPT_CONTROL\0" /* 61641 */
	"SX_MRT0_BLEND_OPT\0" /* 61662 */
	"SX_MRT1_BLEND_OPT\0" /* 61680 */
	"SX_MRT2_BLEND_OPT\0" /* 61698 */
	"SX_MRT3_BLEND_OPT\0" /* 61716 */
	"SX_MRT4_BLEND_OPT\0" /* 61734 */
	"SX_MRT5_BLEND_OPT\0" /* 61752 */
	"SX_MRT6_BLEND_OPT\0" /* 61770 */
	"SX_MRT7_BLEND_OPT\0" /* 61788 */
	"CB_BLEND0_CONTROL\0" /* 61806 */
	"CB_BLEND1_CONTROL\0" /* 61824 */
	"CB_BLEND2_CONTROL\0" /* 61842 */
	"CB_BLEND3_CONTROL\0" /* 61860 */
	"CB_BLEND4_CONTROL\0" /* 61878 */
	"CB_BLEND5_CONTROL\0" /* 61896 */
	"CB_BLEND6_CONTROL\0" /* 61914 */
	"CB_BLEND7_CONTROL\0" /* 61932 */
	"CS_COPY_STATE\0" /* 61950 */
	"PA_CL_POINT_X_RAD\0" /* 61964 */
	"PA_CL_POINT_Y_RAD\0" /* 61982 */
	"PA_CL_POINT_SIZE\0" /* 62000 */
	"PA_CL_POINT_CULL_RAD\0" /* 62017 */
	"VGT_DMA_BASE_HI\0" /* 62038 */
	"VGT_DMA_BASE\0" /* 62054 */
	"VGT_DRAW_INITIATOR\0" /* 62067 */
	"VGT_IMMED_DATA\0" /* 62086 */
	"VGT_EVENT_ADDRESS_REG\0" /* 62101 */
	"DB_DEPTH_CONTROL\0" /* 62123 */
	"DB_EQAA\0" /* 62140 */
	"CB_COLOR_CONTROL\0" /* 62148 */
	"DB_SHADER_CONTROL\0" /* 62165 */
	"PA_CL_CLIP_CNTL\0" /* 62183 */
	"PA_SU_SC_MODE_CNTL\0" /* 62199 */
	"PA_CL_VTE_CNTL\0" /* 62218 */
	"PA_CL_VS_OUT_CNTL\0" /* 62233 */
	"PA_CL_NANINF_CNTL\0" /* 62251 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 62269 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 62293 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 62318 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 62341 */
	"PA_SU_POINT_SIZE\0" /* 62370 */
	"PA_SU_POINT_MINMAX\0" /* 62387 */
	"PA_SU_LINE_CNTL\0" /* 62406 */
	"PA_SC_LINE_STIPPLE\0" /* 62422 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 62441 */
	"VGT_HOS_CNTL\0" /* 62462 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 62475 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 62498 */
	"VGT_HOS_REUSE_DEPTH\0" /* 62521 */
	"VGT_GROUP_PRIM_TYPE\0" /* 62541 */
	"VGT_GROUP_FIRST_DECR\0" /* 62561 */
	"VGT_GROUP_DECR\0" /* 62582 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 62597 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 62619 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 62641 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 62667 */
	"VGT_GS_MODE\0" /* 62693 */
	"VGT_GS_ONCHIP_CNTL\0" /* 62705 */
	"PA_SC_MODE_CNTL_0\0" /* 62724 */
	"PA_SC_MODE_CNTL_1\0" /* 62742 */
	"VGT_ENHANCE\0" /* 62760 */
	"VGT_GS_PER_ES\0" /* 62772 */
	"VGT_ES_PER_GS\0" /* 62786 */
	"VGT_GS_PER_VS\0" /* 62800 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 62814 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 62837 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 62860 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 62883 */
	"IA_ENHANCE\0" /* 62904 */
	"VGT_DMA_SIZE\0" /* 62915 */
	"VGT_DMA_MAX_SIZE\0" /* 62928 */
	"VGT_DMA_INDEX_TYPE\0" /* 62945 */
	"WD_ENHANCE\0" /* 62964 */
	"VGT_PRIMITIVEID_EN\0" /* 62975 */
	"VGT_DMA_NUM_INSTANCES\0" /* 62994 */
	"VGT_PRIMITIVEID_RESET\0" /* 63016 */
	"VGT_EVENT_INITIATOR\0" /* 63038 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 63058 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 63085 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 63110 */
	"IA_MULTI_VGT_PARAM\0" /* 63135 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 63154 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 63177 */
	"VGT_REUSE_OFF\0" /* 63200 */
	"VGT_VTX_CNT_EN\0" /* 63214 */
	"DB_HTILE_SURFACE\0" /* 63229 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 63246 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 63273 */
	"DB_PRELOAD_CONTROL\0" /* 63300 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 63319 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 63345 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 63370 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 63398 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 63424 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 63449 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 63477 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 63503 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 63528 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 63556 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 63582 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 63607 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 63635 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 63666 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 63709 */
	"VGT_GS_MAX_VERT_OUT\0" /* 63747 */
	"VGT_TESS_DISTRIBUTION\0" /* 63767 */
	"VGT_SHADER_STAGES_EN\0" /* 63789 */
	"VGT_LS_HS_CONFIG\0" /* 63810 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 63827 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 63848 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 63871 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 63894 */
	"VGT_TF_PARAM\0" /* 63917 */
	"DB_ALPHA_TO_MASK\0" /* 63930 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 63947 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 63971 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 64001 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 64025 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 64055 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 64086 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 64115 */
	"VGT_GS_INSTANCE_CNT\0" /* 64145 */
	"VGT_STRMOUT_CONFIG\0" /* 64165 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 64184 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 64210 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 64236 */
	"PA_SC_LINE_CNTL\0" /* 64262 */
	"PA_SC_AA_CONFIG\0" /* 64278 */
	"PA_SU_VTX_CNTL\0" /* 64294 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 64309 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 64332 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 64355 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 64378 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 64401 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 64435 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 64469 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 64503 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 64537 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 64571 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 64605 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 64639 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 64673 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 64707 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 64741 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 64775 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 64809 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 64843 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 64877 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 64911 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 64945 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 64969 */
	"PA_SC_SHADER_CONTROL\0" /* 64993 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 65014 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 65042 */
	"CB_COLOR0_BASE\0" /* 65063 */
	"CB_COLOR0_PITCH\0" /* 65078 */
	"CB_COLOR0_SLICE\0" /* 65094 */
	"CB_COLOR0_VIEW\0" /* 65110 */
	"CB_COLOR0_INFO\0" /* 65125 */
	"CB_COLOR0_ATTRIB\0" /* 65140 */
	"CB_COLOR0_DCC_CONTROL\0" /* 65157 */
	"CB_COLOR0_CMASK\0" /* 65179 */
	"CB_COLOR0_CMASK_SLICE\0" /* 65195 */
	"CB_COLOR0_FMASK\0" /* 65217 */
	"CB_COLOR0_FMASK_SLICE\0" /* 65233 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 65255 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 65277 */
	"CB_COLOR0_DCC_BASE\0" /* 65299 */
	"CB_COLOR1_BASE\0" /* 65318 */
	"CB_COLOR1_PITCH\0" /* 65333 */
	"CB_COLOR1_SLICE\0" /* 65349 */
	"CB_COLOR1_VIEW\0" /* 65365 */
	"CB_COLOR1_INFO\0" /* 65380 */
	"CB_COLOR1_ATTRIB\0" /* 65395 */
	"CB_COLOR1_DCC_CONTROL\0" /* 65412 */
	"CB_COLOR1_CMASK\0" /* 65434 */
	"CB_COLOR1_CMASK_SLICE\0" /* 65450 */
	"CB_COLOR1_FMASK\0" /* 65472 */
	"CB_COLOR1_FMASK_SLICE\0" /* 65488 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 65510 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 65532 */
	"CB_COLOR1_DCC_BASE\0" /* 65554 */
	"CB_COLOR2_BASE\0" /* 65573 */
	"CB_COLOR2_PITCH\0" /* 65588 */
	"CB_COLOR2_SLICE\0" /* 65604 */
	"CB_COLOR2_VIEW\0" /* 65620 */
	"CB_COLOR2_INFO\0" /* 65635 */
	"CB_COLOR2_ATTRIB\0" /* 65650 */
	"CB_COLOR2_DCC_CONTROL\0" /* 65667 */
	"CB_COLOR2_CMASK\0" /* 65689 */
	"CB_COLOR2_CMASK_SLICE\0" /* 65705 */
	"CB_COLOR2_FMASK\0" /* 65727 */
	"CB_COLOR2_FMASK_SLICE\0" /* 65743 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 65765 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 65787 */
	"CB_COLOR2_DCC_BASE\0" /* 65809 */
	"CB_COLOR3_BASE\0" /* 65828 */
	"CB_COLOR3_PITCH\0" /* 65843 */
	"CB_COLOR3_SLICE\0" /* 65859 */
	"CB_COLOR3_VIEW\0" /* 65875 */
	"CB_COLOR3_INFO\0" /* 65890 */
	"CB_COLOR3_ATTRIB\0" /* 65905 */
	"CB_COLOR3_DCC_CONTROL\0" /* 65922 */
	"CB_COLOR3_CMASK\0" /* 65944 */
	"CB_COLOR3_CMASK_SLICE\0" /* 65960 */
	"CB_COLOR3_FMASK\0" /* 65982 */
	"CB_COLOR3_FMASK_SLICE\0" /* 65998 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 66020 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 66042 */
	"CB_COLOR3_DCC_BASE\0" /* 66064 */
	"CB_COLOR4_BASE\0" /* 66083 */
	"CB_COLOR4_PITCH\0" /* 66098 */
	"CB_COLOR4_SLICE\0" /* 66114 */
	"CB_COLOR4_VIEW\0" /* 66130 */
	"CB_COLOR4_INFO\0" /* 66145 */
	"CB_COLOR4_ATTRIB\0" /* 66160 */
	"CB_COLOR4_DCC_CONTROL\0" /* 66177 */
	"CB_COLOR4_CMASK\0" /* 66199 */
	"CB_COLOR4_CMASK_SLICE\0" /* 66215 */
	"CB_COLOR4_FMASK\0" /* 66237 */
	"CB_COLOR4_FMASK_SLICE\0" /* 66253 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 66275 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 66297 */
	"CB_COLOR4_DCC_BASE\0" /* 66319 */
	"CB_COLOR5_BASE\0" /* 66338 */
	"CB_COLOR5_PITCH\0" /* 66353 */
	"CB_COLOR5_SLICE\0" /* 66369 */
	"CB_COLOR5_VIEW\0" /* 66385 */
	"CB_COLOR5_INFO\0" /* 66400 */
	"CB_COLOR5_ATTRIB\0" /* 66415 */
	"CB_COLOR5_DCC_CONTROL\0" /* 66432 */
	"CB_COLOR5_CMASK\0" /* 66454 */
	"CB_COLOR5_CMASK_SLICE\0" /* 66470 */
	"CB_COLOR5_FMASK\0" /* 66492 */
	"CB_COLOR5_FMASK_SLICE\0" /* 66508 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 66530 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 66552 */
	"CB_COLOR5_DCC_BASE\0" /* 66574 */
	"CB_COLOR6_BASE\0" /* 66593 */
	"CB_COLOR6_PITCH\0" /* 66608 */
	"CB_COLOR6_SLICE\0" /* 66624 */
	"CB_COLOR6_VIEW\0" /* 66640 */
	"CB_COLOR6_INFO\0" /* 66655 */
	"CB_COLOR6_ATTRIB\0" /* 66670 */
	"CB_COLOR6_DCC_CONTROL\0" /* 66687 */
	"CB_COLOR6_CMASK\0" /* 66709 */
	"CB_COLOR6_CMASK_SLICE\0" /* 66725 */
	"CB_COLOR6_FMASK\0" /* 66747 */
	"CB_COLOR6_FMASK_SLICE\0" /* 66763 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 66785 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 66807 */
	"CB_COLOR6_DCC_BASE\0" /* 66829 */
	"CB_COLOR7_BASE\0" /* 66848 */
	"CB_COLOR7_PITCH\0" /* 66863 */
	"CB_COLOR7_SLICE\0" /* 66879 */
	"CB_COLOR7_VIEW\0" /* 66895 */
	"CB_COLOR7_INFO\0" /* 66910 */
	"CB_COLOR7_ATTRIB\0" /* 66925 */
	"CB_COLOR7_DCC_CONTROL\0" /* 66942 */
	"CB_COLOR7_CMASK\0" /* 66964 */
	"CB_COLOR7_CMASK_SLICE\0" /* 66980 */
	"CB_COLOR7_FMASK\0" /* 67002 */
	"CB_COLOR7_FMASK_SLICE\0" /* 67018 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 67040 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 67062 */
	"CB_COLOR7_DCC_BASE\0" /* 67084 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 67103 */
	"WD_POS_BUF_BASE\0" /* 67125 */
	"WD_POS_BUF_BASE_HI\0" /* 67141 */
	"WD_CNTL_SB_BUF_BASE\0" /* 67160 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 67180 */
	"WD_INDEX_BUF_BASE\0" /* 67203 */
	"WD_INDEX_BUF_BASE_HI\0" /* 67221 */
	"VGT_OBJECT_ID\0" /* 67242 */
	"VGT_INSTANCE_BASE_ID\0" /* 67256 */
	"SQC_WRITEBACK\0" /* 67277 */
	"TA_GRAD_ADJ_UCONFIG\0" /* 67291 */
	"SPI_CONFIG_CNTL_2\0" /* 67311 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 67329 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 67356 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 67383 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 67410 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 67437 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 67464 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 67491 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 67518 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 67545 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 67572 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 67599 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 67626 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 67653 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 67680 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 67707 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 67734 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 67761 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 67788 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 67815 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 67842 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 67869 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 67896 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 67923 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 67950 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 67977 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 68004 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 68031 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 68058 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 68085 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 68112 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 68139 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 68166 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 68193 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 68220 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 68244 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 68276 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 68308 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 68335 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 68362 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 68389 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 68416 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 68443 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 68470 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 68497 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 68524 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 68551 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 68578 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 68605 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 68632 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 68659 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 68686 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 68713 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 68740 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 68764 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 68796 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 68828 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 68855 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 68882 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 68909 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 68936 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 68963 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 68990 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 69017 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 69044 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 69071 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 69098 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 69125 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 69152 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 69179 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 69206 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 69233 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 69260 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 69290 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 69320 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 69350 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 69380 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 69410 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 69440 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 69470 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 69500 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 69530 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 69560 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 69591 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 69622 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 69653 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 69684 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 69715 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 69746 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 69777 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 69808 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 69839 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 69870 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 69901 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 69932 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 69963 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 69994 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 70025 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 70056 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 70087 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 70118 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 70149 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 70180 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 70211 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 70242 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 70271 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 70300 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 70333 */
	"CPF_LATENCY_STATS_DATA\0" /* 70366 */
	"CPG_LATENCY_STATS_DATA\0" /* 70389 */
	"CPC_LATENCY_STATS_DATA\0" /* 70412 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 70435 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 70469 */
	"CPF_LATENCY_STATS_SELECT\0" /* 70503 */
	"CPG_LATENCY_STATS_SELECT\0" /* 70528 */
	"CPC_LATENCY_STATS_SELECT\0" /* 70553 */
	"DB_HTILE_DATA_BASE_HI\0" /* 70578 */
	"DB_Z_READ_BASE_HI\0" /* 70600 */
	"DB_STENCIL_READ_BASE_HI\0" /* 70618 */
	"DB_Z_WRITE_BASE_HI\0" /* 70642 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 70661 */
	"DB_DFSM_CONTROL\0" /* 70686 */
	"DB_RENDER_FILTER\0" /* 70702 */
	"DB_Z_INFO2\0" /* 70719 */
	"DB_STENCIL_INFO2\0" /* 70730 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 70747 */
	"CP_PERFMON_CNTX_CNTL\0" /* 70776 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 70797 */
	"PA_SC_LEFT_VERT_GRID\0" /* 70819 */
	"PA_SC_HORIZ_GRID\0" /* 70840 */
	"PA_SC_FOV_WINDOW_LR\0" /* 70857 */
	"PA_SC_FOV_WINDOW_TB\0" /* 70877 */
	"CB_MRT0_EPITCH\0" /* 70897 */
	"CB_MRT1_EPITCH\0" /* 70912 */
	"CB_MRT2_EPITCH\0" /* 70927 */
	"CB_MRT3_EPITCH\0" /* 70942 */
	"CB_MRT4_EPITCH\0" /* 70957 */
	"CB_MRT5_EPITCH\0" /* 70972 */
	"CB_MRT6_EPITCH\0" /* 70987 */
	"CB_MRT7_EPITCH\0" /* 71002 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 71017 */
	"PA_CL_NGG_CNTL\0" /* 71039 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 71054 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 71084 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 71114 */
	"VGT_INDEX_PAYLOAD_CNTL\0" /* 71136 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 71159 */
	"PA_SC_BINNER_CNTL_0\0" /* 71183 */
	"PA_SC_BINNER_CNTL_1\0" /* 71203 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 71223 */
	"PA_SC_NGG_MODE_CNTL\0" /* 71261 */
	"CB_COLOR0_BASE_EXT\0" /* 71281 */
	"CB_COLOR0_ATTRIB2\0" /* 71300 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 71318 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 71343 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 71368 */
	"CB_COLOR1_BASE_EXT\0" /* 71391 */
	"CB_COLOR1_ATTRIB2\0" /* 71410 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 71428 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 71453 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 71478 */
	"CB_COLOR2_BASE_EXT\0" /* 71501 */
	"CB_COLOR2_ATTRIB2\0" /* 71520 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 71538 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 71563 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 71588 */
	"CB_COLOR3_BASE_EXT\0" /* 71611 */
	"CB_COLOR3_ATTRIB2\0" /* 71630 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 71648 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 71673 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 71698 */
	"CB_COLOR4_BASE_EXT\0" /* 71721 */
	"CB_COLOR4_ATTRIB2\0" /* 71740 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 71758 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 71783 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 71808 */
	"CB_COLOR5_BASE_EXT\0" /* 71831 */
	"CB_COLOR5_ATTRIB2\0" /* 71850 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 71868 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 71893 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 71918 */
	"CB_COLOR6_BASE_EXT\0" /* 71941 */
	"CB_COLOR6_ATTRIB2\0" /* 71960 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 71978 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 72003 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 72028 */
	"CB_COLOR7_BASE_EXT\0" /* 72051 */
	"CB_COLOR7_ATTRIB2\0" /* 72070 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 72088 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 72113 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 72138 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 867, 871, 874,
	/* 4 */ 911, 931, 943, 949, 953, 962,
	/* 10 */ 1020, 949, 391, 1029,
	/* 14 */ 1059, 949, 1068, 1076,
	/* 18 */ 1191, 1196, 1204, 1212,
	/* 22 */ 1238, 922,
	/* 24 */ 1253, 1263,
	/* 26 */ 5827, 5838, 5854, 5869, 5885, 5899, 5912, 5927, 5942, 5957, 5969, 5988, 6008, 6026, 6045, 6060, 6075, 6097, 6112, 6127, 6142, 6158, 6172, 6199, 6226, 6253, 6280, 6304, 6324,
	/* 55 */ 6353, 6374,
	/* 57 */ 5827, 5838, 5854, 5869, 5885, 5899, 5912, -1, -1, 5957, 5969, 5988, 6008, 6026, -1, -1, 6075, 6097, 6112, 6127, 6142, 6158, 6172, 6199, 6226, 6253, 6280, 6304, 6324,
	/* 86 */ 8345, 8357, 8369, 8381,
	/* 90 */ 8773, -1, -1, -1, -1, -1, -1, -1, 8784, 8796, -1, -1, 8808, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8819,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8845,
	/* 186 */ 8940, 8949, 8958, 8976, 8994, 9003, 9012, 9021,
	/* 194 */ 9070, 9091, 9112, 9135, 9158, 9178, 9198, 9223,
	/* 202 */ 9255, 9279, 9297, 9316, 9336, 9355, 9377, 9402, 9427, 9454, 9481, 9505, 9527, 9555, 9580, 9608,
	/* 218 */ 9716, 9728, 9747, 9766,
	/* 222 */ 9824, 9848, 9866, 9885, 9905, 9924, 9946, 9971, 9996, 10023, 10050, 10074, 10096, 10124, 10149, 10177, 10205, 10227, 10251, 10275, 10299, 10320, 10341, 10366, 10395, 10420, 10446, 10469, 10493, 10520, 10548, 10576, 10604, 10626, 10648, 10672, 10692, 10712, 10732, 10752, 10772, 10792, 10812, 10851, 10890, 10919, 10948, 10977, 11006, 11035, 11064, 11095, 11125, 11156, 11186, 11216, 11247, 11278, 11298, 11320, 11338, 11365, 11389, 11415,
	/* 286 */ 11466, 11487, 11508, 11531, 11554, 11574, 11594, 11619, 11640, 11666, 11686, 11708, 11734, 11755, 11779, 11806,
	/* 302 */ 9824, 9848, 9866, 9885, 9905, 9924, 9946, 9971, 9996, 10023, 10050, 10074, 10096, 10124, 10149, 10177, 10205, 10227, 10251, 10275, 10299, 10320, 10341, 10366, 10395, 10420, 10446, 10469, 10493, 10520, 10548, 11849, 10604, 10626, 10648, 10672, 10692, 10712, 10732, 10752, 10772, 10792, 11869, 11897, 11936, 11975, 11997, 12025, 12053, 12086, 12114, 12142, 12175, 12199, 12226, 12259, 12298, 11278, 11298, 12326, 12348, 12370, 12394, 11415,
	/* 366 */ 11466, 11487, 11508, 11531, 11554, 11574, 12438, 11619, 12464, 11666, 12488,
	/* 377 */ 12530, 12546, 12562, 12578, 12594, 12610, 12626, 12644, 12661, 12679, 12696, 12713, 12731,
	/* 390 */ 12766, 12782, 12798, 12814, 12830, 12846, 12862, 12878, 12894, 12911, 12928, 12945, 12963, 12981,
	/* 404 */ 13018, 13036, 13054, 13072, 13090, 13108, 13126, 13144, 13162, 13180,
	/* 414 */ 13306, 13325, 13344, 13363, 13382, 13401, 13420, 13439, 13458, 13473, 13488, 13503, 13520, 13541, 13562, 13582,
	/* 430 */ 13644, 13660, 13676, 13692, 13708, 13724,
	/* 436 */ 13980, 13992, 14006, 14030, 14060, 14085, 14116, 14136,
	/* 444 */ 14202, 14229, 14255, 14282, 14313, 14342, 14372, 14406,
	/* 452 */ 14628, 14651,
	/* 454 */ 14628, 14651, 14691, 14720,
	/* 458 */ 14766, 14787, 14809,
	/* 461 */ 14951, 14983, 15016, 15049,
	/* 465 */ 15253,
	/* 466 */ 15552, 15568, 15584, 15600, 15616, 15632, 15648, 15664, 15680, 15696, 15712, 15728, 15743, 15758, 15773, 15789,
	/* 482 */ 16335, 16366, 16394, 16423,
	/* 486 */ 16468, 16489, 16510, 16531, 16552, -1, -1, 16573, 16594, -1, -1, -1, 16616, 16637, 16658, 16680,
	/* 502 */ 16708, 16721, 16744, 16767, 16790, 16810, 16831, 16852, 16873, 16899, 16925, 16951, 16978, 17005, 17032,
	/* 517 */ 17071, 17096, 17122, 17148, 17174, 17199, 17224,
	/* 524 */ 17260, 17283, 17306, 17329,
	/* 528 */ 17363, 17387, 17411, 17435,
	/* 532 */ 17471, 17496, 17521, 17546,
	/* 536 */ 17589, 17606, 17623, 17640,
	/* 540 */ 16335, 16366, 16394, 17658,
	/* 544 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17786, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17800, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17814,
	/* 785 */ 18995, 19013, 19028,
	/* 788 */ 20644, 20654, 20667, 20681,
	/* 792 */ 20978, 20993, 21009, 21025,
	/* 796 */ 21190, 21200, 21218, 21228,
	/* 800 */ 16468, 16489, 16510, -1, 16552, 21661, 21683,
	/* 807 */ 16708, -1, -1, -1, 16790, 16810, 16831, 16852, 16873, 16899, 16925, 16951, 16978, 17005, 17032, -1, 21708, 21735,
	/* 825 */ 21763, 21773, 21778, 21783,
	/* 829 */ 21925, 21941,
	/* 831 */ 22437, 22460, 22483, 22506,
	/* 835 */ 22553, 22578, 22603, 22628,
	/* 839 */ 22678, 22702, 22726, 22750,
	/* 843 */ 22782, 22807, 22832, 22857,
	/* 847 */ 22891, 22916, 22941, 22966,
	/* 851 */ 23000, 23026, 23052, 23078,
	/* 855 */ 23114, 23137, 23160, 23183,
	/* 859 */ 23213, 23247, 23282, 23317,
	/* 863 */ 23360, 23394, 23429, 23464,
	/* 867 */ 23507, 23530, 23553, 23576,
	/* 871 */ 23606, 23640, 23675, 23710,
	/* 875 */ 23758, 23792, 23827, 23862,
	/* 879 */ 23936, 23964, 23992, 24020,
	/* 883 */ 24060, 24099, 24139, 24179,
	/* 887 */ 24237, 24276, 24316, 24356,
	/* 891 */ 24545, 24558, 24571, 24584, 24605, 24624, 24642, 24660, 24675, 24692, 24709, 24721, 24732, 24744, 24757, 24769,
	/* 907 */ 24993,
	/* 908 */ 25522, 25543, 25564, 25585, 25606,
	/* 913 */ 25900,
	/* 914 */ 26080, 26096, 26113, 26130, 26151,
	/* 919 */ 26244, 26260, 26276, 26293, 26310, 26331, 26355, 26379, 26402, 26425,
	/* 929 */ 26612, 26639, 26657, 26675, 26697, 26721, 26742, 26761, 26782, 26803, 26825,
	/* 940 */ 26887, 26893, -1, 26906, -1, -1, -1, 26919, -1, -1, -1, 26931, -1, 26943, -1, 26955,
	/* 956 */ 27462, 27497, 27532, 27564, 27596, 27628, 27660, 27694,
	/* 964 */ 27758, 27772, 27785, 27803, 27816, 27829, 27850, 27874,
	/* 972 */ 27950, 27961, 27971, 27987, 28013, 28029, 28055, 28071, 28097, 28113, 28139, -1, -1, 28164, 28185, 28216, 28233, 28254, 28271, 28292, 28313,
	/* 993 */ 28359, 28377, 28396, 28413, 28430,
	/* 998 */ 28573, 28588, 28609, 28631,
	/* 1002 */ 28665, 28681,
	/* 1004 */ 28848, 28859, 28869, 28880, 28892, 28905, 28919, 28931,
	/* 1012 */ 28959, 28969, 28978, 28988, 28999, 29011, 29024, 29035,
	/* 1020 */ 29456, 29467, 29477, 29501, -1, 29512, 29532,
	/* 1027 */ 29550, -1, -1, -1, -1, 29557, -1, -1, -1, -1, 29564, -1, -1, -1, -1, 29571, -1, 29578, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29585, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29592, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29599, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29606, -1, -1, -1, -1, 29613, -1, -1, -1, -1, 29620, -1, -1, -1, -1, 29627, -1, -1, -1, -1, -1, -1, 29634, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29641, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29648, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29655, -1, -1, -1, -1, -1, -1, 29662, -1, -1, -1, -1, 29669, -1, -1, -1, -1, 29676, -1, -1, -1, -1, 29683, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29690, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29697, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29704, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29711, -1, 29718, -1, -1, -1, -1, 29725, -1, -1, -1, -1, 29732, -1, -1, -1, -1, 29739,
	/* 1283 */ 29822, 29829, 29849, 29854,
	/* 1287 */ 30000, 30013, 30032, 30054,
	/* 1291 */ 30515, 30535,
	/* 1293 */ 30547, 30561, 30574,
	/* 1296 */ 32218, 32240, 32260, 32281, 32302,
	/* 1301 */ 32357, 32374, 32390, 32405, 32421, 32437, 32461, 32485, 32509, 32533, 32554, 32570, 32585, 32609, 32632, 32656, 32676, 32695,
	/* 1319 */ 32738, 32751, 32765, 32777, 32790,
	/* 1324 */ 32874, 32891, 32908, 32924, 32940, 32956, 32972, 32989, 33007,
	/* 1333 */ 33079, 33086, 33100, 33114, 33128, 33142,
	/* 1339 */ 33152, 33164, 33175, 33186,
	/* 1343 */ 33358, -1, -1, 33373,
	/* 1347 */ 34173, 34196, 34219,
	/* 1350 */ 34322, 34335, 34348,
	/* 1353 */ 34360, 34378, 34398, 34418,
	/* 1357 */ 34446, 34462, 34479,
	/* 1360 */ 34506, 34521,
	/* 1362 */ -1, 34639, 34662, 34685, 34708, 34723, 34736, 34748, 34765, -1, 34784, 34804, 34824, 34843, 35574, 34855, 34872, 34889, 35586, 35597, 34921, 34950, 34961, 34987, 35005, 35022, 35041, 35059, 35078, 35094, 35110, 35130, 35152, 35174, 35188, 35207, 35223, 35617, -1, 35233, 35248, -1, 35266, 35289, 35314, 35336, 35361, 7971, 7998, 35383, -1, 35411, 35430, 35448, 35468, 35487, 35507, 35531, 35552, -1, -1, 35631, 35651,
	/* 1425 */ 36193, 36206, 36218,
	/* 1428 */ 36230, 36243, 36255,
	/* 1431 */ 36269, 36283, 36295,
	/* 1434 */ 36457, 36470, 36484,
	/* 1437 */ 36494, 36507, 36517, 36531,
	/* 1441 */ 36559, 36572, 36584, 36603,
	/* 1445 */ 34506, 34521, 36700,
	/* 1448 */ 36718, 36744, 36770, 36795,
	/* 1452 */ 37620, 37631, 37639, 37655,
	/* 1456 */ 37681, 37707, 37732, 37757, 37780, 37801, 37828, 37857,
	/* 1464 */ 38204, 38216, 38229, 38242,
	/* 1468 */ 38262, 38276, 38284, 38293, 38303, 38312, 38324, 38339, 38354, 38371, 38388, 38402, 38414, -1, 38432, -1, 38450, 38462, 38476, 38490, 38504, 38515, 38526,
	/* 1491 */ 38547, 38560, -1, -1, 38573, 38585, 38597, 38609,
	/* 1499 */ 38634, 38643, 38652, 38665,
	/* 1503 */ 38742, 38757, 38775, 38803, 38833, 38864, 38892, 38922,
	/* 1511 */ 13470, 13015, 13214, 953,
	/* 1515 */ 245, 39847, 20644, 953,
	/* 1519 */ 40466, 40482, 40499, 40526,
};

#endif
