/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from relative-pointer-unstable-v1.xml
 * To regenerate, run the “refresh-wayland-wrapper” target.
 */

#include "relative-pointer-unstable-v1_wrapper.h"

#include <boost/throw_exception.hpp>
#include <boost/exception/diagnostic_information.hpp>

#include <wayland-server-core.h>

#include "mir/log.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const wl_pointer_interface_data;
extern struct wl_interface const zwp_relative_pointer_manager_v1_interface_data;
extern struct wl_interface const zwp_relative_pointer_v1_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// RelativePointerManagerV1

mw::RelativePointerManagerV1* mw::RelativePointerManagerV1::from(struct wl_resource* resource)
{
    return static_cast<RelativePointerManagerV1*>(wl_resource_get_user_data(resource));
}

struct mw::RelativePointerManagerV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        auto me = static_cast<RelativePointerManagerV1*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            internal_error_processing_request(client, "RelativePointerManagerV1::destroy()");
        }
    }

    static void get_relative_pointer_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* pointer)
    {
        auto me = static_cast<RelativePointerManagerV1*>(wl_resource_get_user_data(resource));
        wl_resource* id_resolved{
            wl_resource_create(client, &zwp_relative_pointer_v1_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->get_relative_pointer(id_resolved, pointer);
        }
        catch(...)
        {
            internal_error_processing_request(client, "RelativePointerManagerV1::get_relative_pointer()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<RelativePointerManagerV1*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<RelativePointerManagerV1::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &zwp_relative_pointer_manager_v1_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "RelativePointerManagerV1 global bind");
        }
    }

    static struct wl_interface const* get_relative_pointer_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

int const mw::RelativePointerManagerV1::Thunks::supported_version = 1;

mw::RelativePointerManagerV1::RelativePointerManagerV1(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::RelativePointerManagerV1::~RelativePointerManagerV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

bool mw::RelativePointerManagerV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_relative_pointer_manager_v1_interface_data, Thunks::request_vtable);
}

void mw::RelativePointerManagerV1::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

mw::RelativePointerManagerV1::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &zwp_relative_pointer_manager_v1_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::RelativePointerManagerV1::Global::interface_name() const -> char const*
{
    return RelativePointerManagerV1::interface_name;
}

struct wl_interface const* mw::RelativePointerManagerV1::Thunks::get_relative_pointer_types[] {
    &zwp_relative_pointer_v1_interface_data,
    &wl_pointer_interface_data};

struct wl_message const mw::RelativePointerManagerV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"get_relative_pointer", "no", get_relative_pointer_types}};

void const* mw::RelativePointerManagerV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::get_relative_pointer_thunk};

// RelativePointerV1

mw::RelativePointerV1* mw::RelativePointerV1::from(struct wl_resource* resource)
{
    return static_cast<RelativePointerV1*>(wl_resource_get_user_data(resource));
}

struct mw::RelativePointerV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        auto me = static_cast<RelativePointerV1*>(wl_resource_get_user_data(resource));
        try
        {
            me->destroy();
        }
        catch(...)
        {
            internal_error_processing_request(client, "RelativePointerV1::destroy()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<RelativePointerV1*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::RelativePointerV1::Thunks::supported_version = 1;

mw::RelativePointerV1::RelativePointerV1(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::RelativePointerV1::~RelativePointerV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::RelativePointerV1::send_relative_motion_event(uint32_t utime_hi, uint32_t utime_lo, double dx, double dy, double dx_unaccel, double dy_unaccel) const
{
    wl_fixed_t dx_resolved{wl_fixed_from_double(dx)};
    wl_fixed_t dy_resolved{wl_fixed_from_double(dy)};
    wl_fixed_t dx_unaccel_resolved{wl_fixed_from_double(dx_unaccel)};
    wl_fixed_t dy_unaccel_resolved{wl_fixed_from_double(dy_unaccel)};
    wl_resource_post_event(resource, Opcode::relative_motion, utime_hi, utime_lo, dx_resolved, dy_resolved, dx_unaccel_resolved, dy_unaccel_resolved);
}

bool mw::RelativePointerV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_relative_pointer_v1_interface_data, Thunks::request_vtable);
}

void mw::RelativePointerV1::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mw::RelativePointerV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types}};

struct wl_message const mw::RelativePointerV1::Thunks::event_messages[] {
    {"relative_motion", "uuffff", all_null_types}};

void const* mw::RelativePointerV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk};

namespace mir
{
namespace wayland
{

struct wl_interface const zwp_relative_pointer_manager_v1_interface_data {
    mw::RelativePointerManagerV1::interface_name,
    mw::RelativePointerManagerV1::Thunks::supported_version,
    2, mw::RelativePointerManagerV1::Thunks::request_messages,
    0, nullptr};

struct wl_interface const zwp_relative_pointer_v1_interface_data {
    mw::RelativePointerV1::interface_name,
    mw::RelativePointerV1::Thunks::supported_version,
    1, mw::RelativePointerV1::Thunks::request_messages,
    1, mw::RelativePointerV1::Thunks::event_messages};

}
}
