/*
 * Copyright © 2018 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 2 or 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MIR_PLATFORM_PROGRAM_H_
#define MIR_PLATFORM_PROGRAM_H_

namespace mir
{
namespace graphics
{
namespace gl
{

/**
 * An opaque handle to one (or more) GLSL shader(s).
 */
class Program
{
public:
    Program() = default;
    virtual ~Program();

    Program(Program const&) = delete;
    Program& operator=(Program const&) = delete;
};

}
}
}

#endif //MIR_PLATFORM_PROGRAM_H_
