/*
 * Copyright © 2018 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 or 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MIR_WAYLAND_GENERATOR_ARGUMENT_H
#define MIR_WAYLAND_GENERATOR_ARGUMENT_H

#include "emitter.h"

#include <optional>
#include <functional>
#include <unordered_map>
#include <set>

namespace xmlpp
{
class Element;
}

class Argument
{
public:
    struct TypeDescriptor
    {
        std::string mir_type;
        std::string wl_type;
        std::string wl_type_abbr; // abbreviated type (i for int, etc), used by libwayland
        std::optional<std::function<Emitter(Argument const*)>> converter;
    };

    Argument(xmlpp::Element const& node, bool is_event);

    Emitter wl_prototype() const;
    Emitter mir_prototype() const;
    Emitter call_fragment() const;
    Emitter object_type_fragment() const;
    Emitter type_str_fragment() const;
    std::optional<Emitter> converter() const;

    void populate_required_interfaces(std::set<std::string>& interfaces) const; // fills the set with interfaces used

    std::string const name;
    std::optional<std::string> const interface;
private:
    static TypeDescriptor get_type(xmlpp::Element const& node, bool is_event);
    static std::optional<std::string> get_interface(xmlpp::Element const& node);

    TypeDescriptor descriptor;
};

#endif // MIR_WAYLAND_GENERATOR_ARGUMENT_H
