<?xml version="1.0"?>

<!--
	Based on Mono's /monodoc/browser/mono-ecma.xsl file.
-->

<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	>
	
	<xsl:output omit-xml-declaration="yes" />
	
	<xsl:include href="stylesheet.xsl"/>
	
	<xsl:param name="ext" select="'xml'"/>
	<xsl:param name="namespace" select="''"/>

	<xsl:template match="Overview">
		<Page>

			<Title>
				<xsl:value-of select="Assembly"/>
				<xsl:if test="not($namespace='' or $namespace='all' or count(Types/Namespace)=1)">
					<xsl:value-of select="': '"/>
					<xsl:value-of select="$namespace"/>
				</xsl:if>
			</Title>

			<CollectionTitle>
				<xsl:if test="not($namespace='' or $namespace='all')">
					<a href="../index.{$ext}"><xsl:value-of select="Assembly"/></a>
				</xsl:if>			
			</CollectionTitle>
			
			<PageTitle>
				<xsl:choose>
				<xsl:when test="not($namespace='' or $namespace='all')">
					<xsl:value-of select="$namespace"/> Namespace
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Assembly"/>
				</xsl:otherwise>
				</xsl:choose>
			</PageTitle>

			<!--
			<SideBar>
			<xsl:if test="not($namespace='')">
				<p style="font-weight: bold; border-bottom: thin solid black"><a href="../index.{$ext}"><xsl:value-of select="Assembly"/></a></p>
				<xsl:for-each select="Types/Namespace">
					<xsl:sort select="@Name"/>
					<div>
						<a href="../{@Name}/index.{$ext}">
							<xsl:value-of select="@Name"/>
						</a>
					</div>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="$namespace=''">
					<div class="AssemblyRemarks" style="margin-top: 1em; margin-bottom: 1em">
						<xsl:apply-templates select="Remarks" mode="notoppara"/>
					</div>
			</xsl:if>
			</SideBar>
			-->
			
			<Summary>
				<xsl:if test="$namespace=''">
					<div class="AssemblyRemarks" style="margin-top: 1em; margin-bottom: 1em">
						<xsl:apply-templates select="Remarks" mode="notoppara"/>
					</div>
				</xsl:if>
			</Summary>
			
			<Signature>
			</Signature>
			
			<Remarks>			
				<xsl:for-each select="Types/Namespace[@Name=$namespace or $namespace='all' or count(parent::*/Namespace)=1][count(Type)>0]">
					<xsl:if test="$namespace='all' or count(parent::*/Namespace)=1">
						<div class="Section"><xsl:value-of select="@Name"/> Namespace</div>
					</xsl:if>
					
					<p><xsl:apply-templates select="document(concat(@Name,'.xml'), .)/Namespace/Docs/remarks" mode="notoppara"/></p>

					<table class="TypesListing" style="margin-top: 1em">
			
					<tr>
						<th>Type</th>
						<th>Description</th>
					</tr>				
						
					<xsl:for-each select="Type">
						<xsl:sort select="@Name"/>
						
						<tr valign="top">
							<td>
								<xsl:variable name="path">
									<xsl:choose>
									<xsl:when test="$namespace=parent::Namespace/@Name">.</xsl:when>
									<xsl:otherwise><xsl:value-of select="parent::Namespace/@Name"/></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
							
								<a href="{$path}/{@Name}.{$ext}">
									<xsl:value-of select="@Name"/>
								</a>
							</td>
							<td>
								<xsl:apply-templates select="document(concat(parent::Namespace/@Name, '/',  @Name,'.xml'), .)/Type/Docs/summary" mode="notoppara"/>
							</td>
						</tr>
					</xsl:for-each>
						
					</table>
				</xsl:for-each>

				<xsl:if test="$namespace='' and count(Types/Namespace) > 1">
					<div style="margin-left: 2em">
					<xsl:for-each select="Types/Namespace[count(Type)>0]">
						<xsl:sort select="not(contains(@Name, 'System') and substring-before(@Name, 'System')='')"/>
						<xsl:sort select="@Name"/>
						<div style="margin-bottom: 1em">
							<a href="{@Name}/index.{$ext}" class="NamespaceName"><xsl:value-of select="@Name"/></a>
							<div class="NamespaceSummary">
							<xsl:apply-templates select="document(concat(@Name, '.xml'), .)/Namespace/Docs/summary" mode="notoppara"/>
							</div>						
						</div>
					</xsl:for-each>
					</div>
				</xsl:if>
			</Remarks>
				
			<Members>
			</Members>
			
			<xsl:copy-of select="Copyright"/>
			
		</Page>

	</xsl:template>
	
</xsl:stylesheet>

