<?xml version="1.0"?>

<!--
	Based on Mono's /monodoc/browser/mono-ecma.xsl file.
-->

<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	>
	
	<xsl:output omit-xml-declaration="yes" />

	<!-- TEMPLATE PARAMETERS -->

	<xsl:param name="language" select="'C#'"/>
	<xsl:param name="ext" select="'xml'"/>
	<xsl:param name="basepath" select="'./'"/>

	<!-- The namespace that the current type belongs to. -->
	<xsl:variable name="TypeNamespace" select="substring(/Type/@FullName, 1, string-length(/Type/@FullName) - string-length(/Type/@Name) - 1)"/>		

	<!-- THE MAIN RENDERING TEMPLATE -->

	<xsl:template match="Type">
		<Page>
		
		<Title>
			<xsl:value-of select="@FullName"/>
		</Title>
		
		<CollectionTitle>
			<a href="{$basepath}index.{$ext}"><xsl:value-of select="AssemblyInfo/AssemblyName"/></a>
			:
			<a href="index.{$ext}"><xsl:value-of select="$TypeNamespace"/> Namespace</a>
		</CollectionTitle>
		
		<PageTitle>
			<xsl:value-of select="@Name"/>
		</PageTitle>
		
		<!--
		<SideBar>
			<p style="font-weight: bold; border-bottom: thin solid black"><a href="index.{$ext}"><xsl:value-of select="$TypeNamespace"/></a></p>

			<xsl:for-each select="document('index.xml',.)/Overview/Types/Namespace[@Name=$TypeNamespace]/Type">
				<xsl:sort select="@Name"/>
				<div>
					<a href="../{parent::Namespace/@Name}/{@Name}.{$ext}">
						<xsl:value-of select="@Name"/>
					</a>
				</div>
			</xsl:for-each>
		</SideBar>
		-->

		<!-- TYPE OVERVIEW -->
		
		<Summary>
			<!-- summary -->
			<xsl:apply-templates select="Docs/summary" mode="notoppara"/>
		</Summary>

		<Signature>
			<!-- signature -->
			<table class="SignatureTable" cellspacing="0" width="100%">
			<tr><td>
				<table class="InnerSignatureTable" cellpadding="10" cellspacing="0" width="100%">
				<tr bgcolor="#f2f2f2"><td>
					<xsl:choose>
					<xsl:when test="$language='C#'">

						<xsl:for-each select="Attributes/Attribute">
							<div>[<xsl:value-of select="AttributeName"/>]</div>
						</xsl:for-each>
	
						<xsl:choose>

						<xsl:when test="Base/BaseTypeName='System.Enum'">
							<xsl:call-template name="getmodifiers">
								<xsl:with-param name="sig" select="TypeSignature[@Language='C#']/@Value"/>
							</xsl:call-template>

							enum
	
							<!-- member name, argument list -->
							<b>
							<xsl:value-of select="@Name"/>
							</b>
						</xsl:when>
	
						<xsl:when test="Base/BaseTypeName='System.Delegate' or Base/BaseTypeName='System.MulticastDelegate'">
							<xsl:choose>

							<xsl:when test="count(Parameters) &gt; 0 and count(ReturnValue) &gt; 0">
							<!-- Only recreate the delegate signature if the appropriate information
								is present in the XML file. -->

							<xsl:call-template name="getmodifiers">
								<xsl:with-param name="sig" select="TypeSignature[@Language='C#']/@Value"/>
							</xsl:call-template>

							delegate
	
							<xsl:apply-templates select="ReturnValue/ReturnType" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>
	
							<!-- hard space -->
							<xsl:value-of select="' '"/>
	
							<!-- member name, argument list -->
							<b>
							<xsl:value-of select="@Name"/>
							</b>

							<!-- hard space -->
							<xsl:value-of select="' '"/>

							<xsl:value-of select="'('"/> <!-- prevents whitespace issues -->
							
							<xsl:variable name="HasManyArgs" select="count(Parameters/Parameter) &gt; 4"/>

							<xsl:for-each select="Parameters/Parameter">
								<xsl:call-template name="ShowParameter">
									<xsl:with-param name="Param" select="."/>
									<xsl:with-param name="TypeNamespace" select="$TypeNamespace"/>
								</xsl:call-template>

								<xsl:if test="not(position()=last())">, </xsl:if>
							</xsl:for-each>
							
							<xsl:value-of select="')'"/>

							</xsl:when>
							
							<xsl:otherwise>
								<xsl:apply-templates select="TypeSignature[@Language=$language]/@Value"/>	
							</xsl:otherwise>

							</xsl:choose>

							
						</xsl:when>

						<xsl:otherwise>
							<xsl:call-template name="getmodifiers">
								<xsl:with-param name="sig" select="TypeSignature[@Language='C#']/@Value"/>
								<xsl:with-param name="typetype" select="true()"/>
							</xsl:call-template>
		
							<xsl:value-of select="' '"/>
		
							<b><xsl:value-of select="@Name"/></b>
		
							<xsl:variable name="HasStandardBaseType" select="Base/BaseTypeName='System.Object' or Base/BaseTypeName='System.ValueType'"/>
							<xsl:variable name="HasBaseType" select="count(Base/BaseTypeName)>0"/>
							<xsl:if test="(($HasBaseType) and not($HasStandardBaseType)) or not(count(Interfaces/Interface)=0)"> :
		
								<xsl:if test="not($HasStandardBaseType)">
									<xsl:apply-templates select="Base/BaseTypeName" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>
									<xsl:if test="not(count(Interfaces/Interface)=0)">,	</xsl:if>
								</xsl:if>
		
								<xsl:for-each select="Interfaces/Interface">
									<xsl:if test="not(position()=1)">, </xsl:if>
									<xsl:apply-templates select="InterfaceName" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>
								</xsl:for-each>
							
							</xsl:if>
						</xsl:otherwise>

						</xsl:choose>

					</xsl:when>

					<xsl:otherwise>
						<xsl:apply-templates select="TypeSignature[@Language=$language]/@Value"/>
					</xsl:otherwise>
					
					</xsl:choose>
				</td></tr>
				</table>
			</td></tr>
			</table>

			<br/>
		</Signature>
			
		<Remarks>
			<xsl:call-template name="DisplayDocsInformation"/>

			<!-- MEMBER LISTING -->
			<xsl:if test="not(Base/BaseTypeName='System.Delegate' or Base/BaseTypeName='System.MulticastDelegate' or Base/BaseTypeName='System.Enum')">
				<div class="Section">Members</div>
	
				<div class="SectionBox">
				
				<xsl:if test="Base/BaseTypeName">
					<p>
						See Also: Inherited members from
						<xsl:apply-templates select="Base/BaseTypeName" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>.
					</p>
				</xsl:if>

				<!-- list each type of member (public, then protected) -->

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Constructor'"/>
					<xsl:with-param name="showprotected" select="false()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Constructor'"/>
					<xsl:with-param name="showprotected" select="true()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Field'"/>
					<xsl:with-param name="showprotected" select="false()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Field'"/>
					<xsl:with-param name="showprotected" select="true()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Property'"/>
					<xsl:with-param name="showprotected" select="false()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Property'"/>
					<xsl:with-param name="showprotected" select="true()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Method'"/>
					<xsl:with-param name="showprotected" select="false()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Method'"/>
					<xsl:with-param name="showprotected" select="true()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Event'"/>
					<xsl:with-param name="showprotected" select="false()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Event'"/>
					<xsl:with-param name="showprotected" select="true()"/>
				</xsl:call-template>

				<xsl:call-template name="ListMembers">
					<xsl:with-param name="listmembertype" select="'Operator'"/>
					<xsl:with-param name="showprotected" select="false()"/>
				</xsl:call-template>
				
			</div>
			</xsl:if>
			
		</Remarks>
			
		<Members>
		<!-- MEMBER DETAILS -->
			<xsl:if test="not(Base/BaseTypeName='System.Delegate' or Base/BaseTypeName='System.MulticastDelegate' or Base/BaseTypeName='System.Enum')">
			<xsl:variable name="Type" select="."/>
			
			<div class="Section">Member Details</div>
			
			<div class="SectionBox">

			<xsl:for-each select="Members/Member">
			
				<a name="member_{generate-id(.)}"></a>

				<div class="MemberName">
					<xsl:choose>
					<xsl:when test="MemberType='Constructor'">
						<xsl:value-of select="$Type/@Name"/> Constructor
					</xsl:when>
					<xsl:when test="@MemberName='op_Implicit' or @MemberName='op_Explicit'">
						Conversion
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@MemberName"/>
					</xsl:otherwise>
					</xsl:choose>
				</div>
					
				<div class="MemberSignature">
					<!-- recreate the signature -->

					<xsl:call-template name="getmodifiers">
						<xsl:with-param name="sig" select="MemberSignature[@Language='C#']/@Value"/>
					</xsl:call-template>

					<xsl:if test="MemberType = 'Event'">
						event

						<xsl:if test="ReturnValue/ReturnType=''">
							<xsl:value-of select="substring-before(substring-after(MemberSignature[@Language='C#']/@Value, 'event '), concat(' ', @MemberName))"/>
						</xsl:if>
					</xsl:if>

					<!-- return value (comes out "" where not applicable/available) -->
					<xsl:choose>
					<xsl:when test="@MemberName='op_Implicit'">
						implicit operator
					</xsl:when>
					<xsl:when test="@MemberName='op_Explicit'">
						explicit operator
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="ReturnValue/ReturnType" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>
					</xsl:otherwise>					
					</xsl:choose>

					<!-- hard space -->
					<xsl:value-of select="' '"/>

					<!-- member name -->
					<xsl:choose>
					
					<!-- Constructors get the name of the class -->
					<xsl:when test="MemberType='Constructor'">
						<b><xsl:value-of select="$Type/@Name"/></b>
					</xsl:when>
					
					<!-- Conversion operators get the return type -->
					<xsl:when test="@MemberName='op_Implicit' or @MemberName='op_Explicit'">
						<xsl:apply-templates select="ReturnValue/ReturnType" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>
					</xsl:when>
					
					<!-- Regular operators get their symbol -->
					<xsl:when test="@MemberName='op_UnaryPlus'">+</xsl:when>
					<xsl:when test="@MemberName='op_UnaryNegation'">-</xsl:when>
					<xsl:when test="@MemberName='op_LogicalNot'">!</xsl:when>
					<xsl:when test="@MemberName='op_OnesComplement'">~</xsl:when>
					<xsl:when test="@MemberName='op_Increment'">++</xsl:when>
					<xsl:when test="@MemberName='op_Decrement'">--</xsl:when>
					<xsl:when test="@MemberName='op_True'">true</xsl:when>
					<xsl:when test="@MemberName='op_False'">false</xsl:when>
					<xsl:when test="@MemberName='op_Addition'">+</xsl:when>
					<xsl:when test="@MemberName='op_Subtraction'">-</xsl:when>
					<xsl:when test="@MemberName='op_Multiply'">*</xsl:when>
					<xsl:when test="@MemberName='op_Division'">/</xsl:when>
					<xsl:when test="@MemberName='op_Modulus'">%</xsl:when>
					<xsl:when test="@MemberName='op_BitwiseAnd'">&amp;</xsl:when>
					<xsl:when test="@MemberName='op_BitwiseOr'">|</xsl:when>
					<xsl:when test="@MemberName='op_ExclusiveOr'">^</xsl:when>
					<xsl:when test="@MemberName='op_LeftShift'">&lt;&lt;</xsl:when>
					<xsl:when test="@MemberName='op_RightShift'">&gt;&gt;</xsl:when>
					<xsl:when test="@MemberName='op_Equality'">==</xsl:when>
					<xsl:when test="@MemberName='op_Inequality'">!=</xsl:when>
					<xsl:when test="@MemberName='op_GreaterThan'">&gt;</xsl:when>
					<xsl:when test="@MemberName='op_LessThan'">&lt;</xsl:when>
					<xsl:when test="@MemberName='op_GreaterThanOrEqual'">&gt;=</xsl:when>
					<xsl:when test="@MemberName='op_LessThanOrEqual'">&lt;=</xsl:when>
					
					<!-- Everything else just gets its name -->
					<xsl:otherwise>
						<b><xsl:value-of select="@MemberName"/></b>
					</xsl:otherwise>
					</xsl:choose>

					<!-- hard space -->
					<xsl:value-of select="' '"/>

					<!-- argument list -->
					<xsl:if test="MemberType='Method' or MemberType='Constructor' or (MemberType='Property' and count(Parameters/Parameter))">
						<xsl:if test="not(MemberType='Property')">(</xsl:if>
						<xsl:if test="MemberType='Property'">[</xsl:if>

						<xsl:variable name="HasManyArgs" select="count(Parameters/Parameter) &gt; 4"/>

						<xsl:for-each select="Parameters/Parameter">
							<xsl:call-template name="ShowParameter">
								<xsl:with-param name="Param" select="."/>
								<xsl:with-param name="TypeNamespace" select="$TypeNamespace"/>
							</xsl:call-template>

							<xsl:if test="not(position()=last())">, </xsl:if>
						</xsl:for-each>
						<xsl:if test="not(MemberType='Property')">)</xsl:if>
						<xsl:if test="MemberType='Property'">]</xsl:if>
					</xsl:if>

					<xsl:if test="MemberType='Property'">
						<xsl:value-of select="' '"/>
						{
						<xsl:value-of select="substring-before(substring-after(MemberSignature[@Language='C#']/@Value, '{'), '}')"/>
						}
					</xsl:if>
				</div>
				
				<div class="MemberBox">

				<!-- summary -->

				<xsl:if test="contains(MemberSignature[@Language='C#']/@Value,'this[')">
					<p><i>This is the default property for this class.</i></p>
				</xsl:if>
				
				<!-- member value -->

				<xsl:if test="MemberValue">
				<p><b>Value: </b>
					<xsl:value-of select="MemberValue"/>
				</p>
				</xsl:if>

				<p>
					<xsl:apply-templates select="Docs/summary" mode="notoppara"/>
				</p>

				<xsl:if test="Attributes/Attribute">
					<p>Attributes:
					<xsl:for-each select="Attributes/Attribute">
						<xsl:if test="not(position()=1)">, </xsl:if>
						<xsl:value-of select="AttributeName"/>
					</xsl:for-each>
					</p>
				</xsl:if>

				<xsl:call-template name="DisplayDocsInformation"/>

				<hr size="1"/>
					
				</div>

			</xsl:for-each>
			
			</div>
			</xsl:if>
			
			</Members>
			
			<Copyright>
			</Copyright>
			
		</Page>
	</xsl:template>

	<xsl:template name="ShowParameter">
		<xsl:param name="Param"/>
		<xsl:param name="TypeNamespace"/>
		<xsl:param name="prototype" select="false()"/>

		<xsl:if test="not($prototype)">
			<xsl:for-each select="$Param/Attributes/Attribute[not(Exclude='1') and not(AttributeName='ParamArrayAttribute' or AttributeName='System.ParamArray')]">
				[<xsl:value-of select="AttributeName"/>]
				<xsl:value-of select="' '"/>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="count($Param/Attributes/Attribute/AttributeName[.='ParamArrayAttribute' or .='System.ParamArray'])">
			<b>params</b> <xsl:value-of select="' '"/>
		</xsl:if>

		<xsl:if test="$Param/@RefType">
			<i><xsl:value-of select="$Param/@RefType"/></i>
			<!-- hard space -->
			<xsl:value-of select="' '"/>
		</xsl:if>

		<!-- parameter type link -->
		<xsl:apply-templates select="$Param/@Type" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>

		<xsl:if test="not($prototype)">
			<!-- hard space -->
			<xsl:value-of select="' '"/>
	
			<!-- parameter name -->
			<xsl:value-of select="$Param/@Name"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="DisplayDocsInformation">
		<!-- The namespace that the current type belongs to. -->
		<xsl:variable name="TypeNamespace" select="substring(@FullName, 1, string-length(@FullName) - string-length(@Name) - 1)"/>

		<!-- alt member: not sure what these are for, actually -->

		<xsl:if test="count(Docs/altmember)">
			<div class="Subsection">See Also</div>
			<div class="SubsectionBox">
			<xsl:for-each select="Docs/altmember">
				<div><xsl:apply-templates select="@cref" mode="cref"/></div>
			</xsl:for-each>
			</div>
		</xsl:if>

		<!-- parameters & return & value -->

		<xsl:if test="count(Docs/param)">
			<div class="Subsection">Parameters</div>
			<div class="SubsectionBox">
			<dl>
			<xsl:for-each select="Docs/param">
				<dt><i><xsl:value-of select="@name"/></i></dt>
				<dd>
					<xsl:apply-templates select="." mode="notoppara"/>
				</dd>
			</xsl:for-each>
			</dl>
			</div>
		</xsl:if>
		<xsl:if test="count(Docs/returns)">
			<div class="Subsection">Returns</div>
			<div class="SubsectionBox">
				<xsl:apply-templates select="Docs/returns" mode="notoppara"/>
			</div>
		</xsl:if>
		<xsl:if test="count(Docs/value)">
			<div class="Subsection">Value</div>
			<div class="SubsectionBox">
				<xsl:apply-templates select="Docs/value" mode="notoppara"/>
			</div>
		</xsl:if>

		<!-- thread safety -->

		<xsl:if test="count(ThreadingSafetyStatement)">
			<div class="Subsection">Thread Safety</div>
			<div class="SubsectionBox">
			<xsl:apply-templates select="ThreadingSafetyStatement" mode="notoppara"/>
			</div>
		</xsl:if>


		<!-- permissions -->

		<xsl:if test="count(Docs/permission)">
			<div>Permissions</div>
			<div class="SubsectionBox">
			<table class="TypePermissionsTable" border="1" cellpadding="6">
			<tr bgcolor="#f2f2f2"><th>Type</th><th>Reason</th></tr>
			<xsl:for-each select="Docs/permission">
				<tr valign="top">
				<td><xsl:apply-templates select="@cref" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates></td>
				<td>
					<xsl:apply-templates select="." mode="notoppara"/>
				</td>
				</tr>
			</xsl:for-each>
			</table>
			</div>
		</xsl:if>

		<!-- method/property/constructor exceptions -->

		<xsl:if test="count(Docs/exception)">
			<div class="Subsection">Exceptions</div>
			<div class="SubsectionBox">
			<table class="ExceptionsTable">
			<tr><th>Type</th><th>Condition</th></tr>
			<xsl:for-each select="Docs/exception">
				<tr valign="top">
				<td><xsl:apply-templates select="@cref" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates></td>
				<td>
					<xsl:apply-templates select="." mode="notoppara"/>
				</td>
				</tr>
			</xsl:for-each>
			</table>
			</div>
		</xsl:if>

		<!-- remarks -->

		<xsl:if test="count(Docs/remarks)">
			<div class="Subsection">Remarks</div>
			<div class="SubsectionBox">
			<xsl:apply-templates select="Docs/remarks" mode="notoppara"/>
			</div>
		</xsl:if>

		<!-- enumeration values -->

		<xsl:if test="Base/BaseTypeName = 'System.Enum'">
			<div class="Subsection">Members</div>
			<div class="SubsectionBox">
			<table class="EnumerationsTable">
			<tr>
				<th>Member name</th>
				<th>Description</th>
			</tr>

			<xsl:for-each select="Members/Member[MemberType='Field']">
				<xsl:if test="not(@MemberName='value__')">
					<tr><td><b>
						<xsl:value-of select="@MemberName"/>
					</b></td>
					<td>
						<xsl:apply-templates select="Docs/summary" mode="notoppara"/>
					</td>
					</tr>
				</xsl:if>
			</xsl:for-each>

			</table>
			</div>
		</xsl:if>

		<!-- examples -->

		<xsl:if test="count(Docs/example)">
			<h4>Examples</h4>
			<div class="SubsectionBox">
			<xsl:for-each select="Docs/example">
				<xsl:apply-templates select="." mode="notoppara"/>
			</xsl:for-each>
			</div>
		</xsl:if>
	</xsl:template>

	
	<!-- Transforms the contents of the selected node into a hyperlink to the type named by the node.  The node can contain a type name (eg System.Object) or a type link (eg T:System.String). Use wrt parameter to specify the current namespace. -->

	<xsl:template match="*|@*" mode="typelink">
		<xsl:param name="wrt" select="'notset'"/>
		
		<xsl:call-template name="maketypelink">
				<xsl:with-param name="type" select="."/>
				<xsl:with-param name="wrt" select="$wrt"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="maketypelink">
		<xsl:param name="type"/>
		<xsl:param name="wrt" select="'notset'"/>

		<xsl:choose>

		<!-- chop off T: -->
		<xsl:when test="starts-with($type, 'T:')">
			<xsl:call-template name="maketypelink">
				<xsl:with-param name="type" select="substring($type, 3)"/>
				<xsl:with-param name="wrt" select="$wrt"/>
			</xsl:call-template>
		</xsl:when>

		<xsl:when test="contains($type, '&amp;')">
			<xsl:call-template name="maketypelink">
				<xsl:with-param name="type" select="substring($type, 1, string-length($type)-1)"/>
				<xsl:with-param name="wrt" select="$wrt"/>
			</xsl:call-template>
		</xsl:when>

		<xsl:when test="contains($type, '[]')">
			<xsl:call-template name="maketypelink">
				<xsl:with-param name="type" select="substring($type, 1, string-length($type)-2)"/>
				<xsl:with-param name="wrt" select="$wrt"/>
			</xsl:call-template>
			<xsl:value-of select="'[]'"/>
		</xsl:when>

		<xsl:when test="contains($type, '*')">
			<xsl:call-template name="maketypelink">
				<xsl:with-param name="type" select="substring($type, 1, string-length($type)-1)"/>
				<xsl:with-param name="wrt" select="$wrt"/>
			</xsl:call-template>
			<xsl:value-of select="'*'"/>
		</xsl:when>

		<xsl:otherwise>
			
			<xsl:variable name="T" select="$type"/>
			<a>
				<!-- Search for type in the index.xml file. -->
				<xsl:variable name="typeentry" select="document('index.xml')/Overview/Types/Namespace/Type[concat(parent::Namespace/@Name,'.',@Name) = $T]"/>
				
				<xsl:attribute name="href">
				<xsl:choose>
					<xsl:when test="count($typeentry)">
						<xsl:value-of select="concat($basepath,$typeentry/parent::Namespace/@Name, '/', $typeentry/@Name)"/>.<xsl:value-of select="$ext"/>
					</xsl:when>
					<xsl:when test="starts-with($T, 'System.')">
						http://mono.ximian.com:8080/monodoc.ashx?link=T:<xsl:value-of select="$T"/>
					</xsl:when>
					<xsl:otherwise>
						javascript:alert("Documentation not found.")
					</xsl:otherwise>
				</xsl:choose>
				</xsl:attribute>
	
				<!-- use C#-style names -->
				<xsl:choose>
					<xsl:when test="$T='System.Object'">object</xsl:when>
					<xsl:when test="$T='System.Boolean'">bool</xsl:when>
					<xsl:when test="$T='System.Byte'">byte</xsl:when>
					<xsl:when test="$T='System.Char'">char</xsl:when>
					<xsl:when test="$T='System.Decimal'">decimal</xsl:when>
					<xsl:when test="$T='System.Double'">double</xsl:when>
					<xsl:when test="$T='System.Int16'">short</xsl:when>
					<xsl:when test="$T='System.Int32'">int</xsl:when>
					<xsl:when test="$T='System.Int64'">long</xsl:when>
					<xsl:when test="$T='System.SByte'">sbyte</xsl:when>
					<xsl:when test="$T='System.Single'">float</xsl:when>
					<xsl:when test="$T='System.String'">string</xsl:when>
					<xsl:when test="$T='System.UInt16'">ushort</xsl:when>
					<xsl:when test="$T='System.UInt32'">uint</xsl:when>
					<xsl:when test="$T='System.UInt64'">ulong</xsl:when>
					<xsl:when test="$T='System.Void'">void</xsl:when>
	
					<!-- if the type is in the wrt namespace, omit the namespace name -->
					<xsl:when test="not($wrt='') and starts-with($T, concat($wrt,'.')) and not(contains(substring-after($T,concat($wrt,'.')), '.'))">
						<xsl:value-of select="substring-after($T,concat($wrt,'.'))"/>
					</xsl:when>
	
					<!-- if the type is in the System namespace, omit the namespace name -->
					<xsl:when test="starts-with($T, 'System.') and not(contains(substring-after($T, 'System.'), '.'))">
						<xsl:value-of select="substring-after($T,'System.')"/>
					</xsl:when>
	
					<!-- if the type is in the System.Collections namespace, omit the namespace name -->
					<xsl:when test="starts-with($T, 'System.Collections.') and not(contains(substring-after($T, 'System.Collections.'), '.'))">
						<xsl:value-of select="substring-after($T,'System.Collections.')"/>
					</xsl:when>

					<xsl:otherwise>
						<xsl:value-of select="$T"/>
					</xsl:otherwise>
				</xsl:choose>
			</a>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="memberlinkprefix">
		<xsl:choose>
			<xsl:when test="MemberType='Constructor'">C</xsl:when>
			<xsl:when test="MemberType='Method'">M</xsl:when>
			<xsl:when test="MemberType='Property'">P</xsl:when>
			<xsl:when test="MemberType='Field'">F</xsl:when>
			<xsl:when test="MemberType='Event'">F</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Transforms the contents of the selected node containing a cref into a hyperlink. -->
	<xsl:template match="*|@*" mode="cref">
		<a>
			<xsl:attribute name="href"><xsl:value-of select="."/></xsl:attribute>
			<xsl:value-of select="substring-after(., ':')"/></a>
	</xsl:template>

	<xsl:template name="membertypeplural">
		<xsl:param name="name"/>
		<xsl:choose>
		<xsl:when test="$name='Constructor'">Constructors</xsl:when>
		<xsl:when test="$name='Property'">Properties</xsl:when>
		<xsl:when test="$name='Method'">Methods</xsl:when>
		<xsl:when test="$name='Field'">Fields</xsl:when>
		<xsl:when test="$name='Event'">Events</xsl:when>
		<xsl:when test="$name='Operator'">Operators</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="membertypeplurallc">
		<xsl:param name="name"/>
		<xsl:choose>
		<xsl:when test="$name='Constructor'">constructors</xsl:when>
		<xsl:when test="$name='Property'">properties</xsl:when>
		<xsl:when test="$name='Method'">methods</xsl:when>
		<xsl:when test="$name='Field'">fields</xsl:when>
		<xsl:when test="$name='Event'">events</xsl:when>
		<xsl:when test="$name='Operator'">operators</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="gettypetype">
		<xsl:variable name="sig" select="concat(' ', TypeSignature[@Language='C#']/@Value, ' ')"/>
		<xsl:choose>
		<xsl:when test="contains($sig,'class')">Class</xsl:when>
		<xsl:when test="contains($sig,'enum')">Enumeration</xsl:when>
		<xsl:when test="contains($sig,'struct')">Structure</xsl:when>
		<xsl:when test="contains($sig,'delegate')">Delegate</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- Ensures that the resuting node is not surrounded by a para tag. -->
	<xsl:template match="*" mode="notoppara">
		<xsl:choose>
		<xsl:when test="count(*) = 1 and count(para)=1">
			<xsl:apply-templates select="para/node()"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="."/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="para">
		<p>
			<xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="paramref">
		<i><xsl:value-of select="@name"/>
				<xsl:apply-templates/>
		</i>
	</xsl:template>

	<xsl:template match="block[@type='note']">
		<p>
		<i>Note: </i>
				<xsl:apply-templates/>
		</p>
	</xsl:template>
	<xsl:template match="block[@type='behaviors']">
		<div class="Subsection">Operation</div><p><xsl:apply-templates/></p>
	</xsl:template>
	<xsl:template match="block[@type='overrides']">
		<div class="Subsection">Note to Inheritors</div><p><xsl:apply-templates/></p>
	</xsl:template>
	<xsl:template match="block[@type='usage']">
		<div class="Subsection">Usage</div><p><xsl:apply-templates/></p>
	</xsl:template>


	<xsl:template match="c">
		<tt><font size="-1">
			<xsl:apply-templates/>	
		</font></tt>
	</xsl:template>
	<xsl:template match="c//para">
		<xsl:apply-templates/><br/>	
	</xsl:template>
	
	<xsl:template match="code">
		<table class="CodeExampleTable">
		<tr><td><b><font size="-1"><xsl:value-of select="@lang"/> Example</font></b></td></tr>
		<tr><td>
			<!--<xsl:value-of select="monodoc:Colorize(string(descendant-or-self::text()), string(@lang))" disable-output-escaping="yes" />-->
			<pre>
				<xsl:value-of select="." />
			</pre>
		</td></tr>
		</table>
	</xsl:template>

	<xsl:template match="onequarter">
		1/4
	</xsl:template>
	<xsl:template match="pi">pi</xsl:template>
	<xsl:template match="theta">theta</xsl:template>
	<xsl:template match="subscript">
		<sub><xsl:value-of select="@term"/></sub>
	</xsl:template>
	<xsl:template match="superscript">
		<sup><xsl:value-of select="@term"/></sup>
	</xsl:template>

	<!-- tabular data
		example:

			<list type="table">
				<listheader>
					<term>First Col Header</term>
					<description>Second Col Header</description>
					<description>Third Col Header</description>
				</listheader>
				<item>
					<term>First Row First Col</term>
					<description>First Row Second Col</description>
					<description>First Row Third Col</description>
				</item>
				<item>
					<term>Second Row First Col</term>
					<description>Second Row Second Col</description>
					<description>Second Row Third Col</description>
				</item>
			</list>
	-->

	<xsl:template match="list[@type='table']">
		<table border="1" cellpadding="3">
		<tr valign="top">
			<th><xsl:apply-templates select="listheader/term" mode="notoppara"/></th>
			<xsl:for-each select="listheader/description">
				<th><xsl:apply-templates mode="notoppara"/></th>
			</xsl:for-each>
		</tr>

		<xsl:for-each select="item">
			<tr valign="top">
			<td>
				<xsl:apply-templates select="term" mode="notoppara"/>
			</td>
			<xsl:for-each select="description">
				<td>
					<xsl:apply-templates mode="notoppara"/>
				</td>
			</xsl:for-each>
			</tr>
		</xsl:for-each>

		</table>
	</xsl:template>

	<xsl:template match="list[@type='bullet']">
		<UL>
			<xsl:for-each select="item">
				<LI>
					<xsl:apply-templates select="term" mode="notoppara"/>
				</LI>
			</xsl:for-each>
		</UL>
	</xsl:template>
	<xsl:template match="list[@type='number']">
		<OL>
			<xsl:for-each select="item">
				<LI>
					<xsl:apply-templates select="term" mode="notoppara"/>
				</LI>
			</xsl:for-each>
		</OL>
	</xsl:template>

	<xsl:template match="list">
		[<i>The '<xsl:value-of select="@type"/>' type of list has not been implemented in the ECMA stylesheet.</i>]
		
		<xsl:message>
		[<i>The '<xsl:value-of select="@type"/>' type of list has not been implemented in the ECMA stylesheet.</i>]
		</xsl:message>
	</xsl:template>

	<xsl:template match="see[@cref]">
		<xsl:choose>
		<xsl:when test="not(substring-after(@cref, 'T:')='')">
			<xsl:call-template name="maketypelink">
				<xsl:with-param name="type" select="@cref"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="substring-after(@cref, ':')"/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="see[@langword]">
		<!--<a href="{@langword}"><xsl:value-of select="@langword"/></a>-->
		<tt><xsl:value-of select="@langword"/></tt>
	</xsl:template>
	
	<!-- Lists the members in the current Type node.
		 Only lists members of type listmembertype.
		 Displays the signature in siglanguage.
		 showprotected = true() or false()
	-->
	<xsl:template name="ListMembers">
		<xsl:param name="listmembertype"/>
		<xsl:param name="showprotected"/>

		<!-- get name and namespace of current type -->
		<xsl:variable name="TypeName" select="@Name"/>		
		<xsl:variable name="TypeNamespace" select="substring-before(@FullName, concat('.',@Name))"/>

		<!-- Get all members in this type that are of listmembertype and are either
			protected or not protected according to showprotected. -->
		<xsl:variable name="MEMBERS" select="
			Members/Member
			[(MemberType=$listmembertype or ($listmembertype='Operator' and MemberType='Method'))]
			[$showprotected=contains(MemberSignature[@Language='C#']/@Value,'protected')]
			[($listmembertype='Method' and not(starts-with(@MemberName,'op_')))
				or ($listmembertype='Operator' and starts-with(@MemberName,'op_'))
				or (not($listmembertype='Method') and not($listmembertype='Operator'))]
			"/>

		<!-- if there aren't any, skip this -->
		<xsl:if test="count($MEMBERS)">

		<!-- header -->
		<div class="Subsection" style="margin-bottom: .75em">
			<xsl:if test="$showprotected">Protected </xsl:if>
			<xsl:call-template name="membertypeplural"><xsl:with-param name="name" select="$listmembertype"/></xsl:call-template>
			</div>

		<div class="SubsectionBox">
		<table Class="MembersListing">

		<xsl:for-each select="$MEMBERS">
			<!--<xsl:sort select="contains(MemberSignature[@Language='C#']/@Value,' static ')" data-type="text"/>-->
			<xsl:sort select="@MemberName = 'op_Implicit' or @MemberName = 'op_Explicit'"/>
			<xsl:sort select="@MemberName" data-type="text"/>
			<xsl:sort select="count(Parameters/Parameter)"/>
			<xsl:sort select="Parameters/Parameter/@Type"/>
			
			<xsl:variable name="linkname" select="generate-id(.)"/>

			<tr valign="top">

			<xsl:choose>
				<!-- constructor listing -->
				<xsl:when test="MemberType='Constructor'">
					<!-- link to constructor page -->
					<td>
					<div>
					<b>
					<a href="#member_{$linkname}">
							<xsl:value-of select="$TypeName"/>
					</a>
					</b>

					<!-- argument list -->
					<xsl:value-of select="'('"/>
						<xsl:for-each select="Parameters/Parameter">
							<xsl:if test="not(position()=1)">, </xsl:if>
							
							<xsl:call-template name="ShowParameter">
								<xsl:with-param name="Param" select="."/>
								<xsl:with-param name="TypeNamespace" select="$TypeNamespace"/>
								<xsl:with-param name="prototype" select="true()"/>
							</xsl:call-template>
						</xsl:for-each>
					<xsl:value-of select="')'"/>
					</div>

					<!-- description -->
					<xsl:apply-templates select="Docs/summary" mode="notoppara"/>

					</td>
				</xsl:when>

				<!-- field, property and event listing -->
				<xsl:when test="MemberType='Field' or MemberType='Property' or MemberType='Event'">
					<td>

					<!-- link to member page -->
					<b>
					<a href="#member_{$linkname}">
						<xsl:value-of select="@MemberName"/>
					</a>
					</b>

					<!-- argument list for accessors -->
					<xsl:if test="Parameters/Parameter">
					<xsl:value-of select="'['"/>
						<xsl:for-each select="Parameters/Parameter">
							<xsl:if test="not(position()=1)">, </xsl:if>
							
							<xsl:call-template name="ShowParameter">
								<xsl:with-param name="Param" select="."/>
								<xsl:with-param name="TypeNamespace" select="$TypeNamespace"/>
								<xsl:with-param name="prototype" select="true()"/>
							</xsl:call-template>

						</xsl:for-each>
					<xsl:value-of select="']'"/>
					</xsl:if>

					<!-- check if it has get and set accessors -->
					<xsl:if test="MemberType='Property' and not(contains(MemberSignature[@Language='C#']/@Value, 'set;'))">
					[read-only]
					</xsl:if>
					<xsl:if test="MemberType='Property' and not(contains(MemberSignature[@Language='C#']/@Value, 'get;'))">
					[write-only]
					</xsl:if>

					<xsl:if test="contains(MemberSignature[@Language='C#']/@Value,'this[')">
						<div><i>default property</i></div>
					</xsl:if>

					<div>
					<xsl:call-template name="getmodifiers">
						<xsl:with-param name="sig" select="MemberSignature[@Language='C#']/@Value"/>
						<xsl:with-param name="protection" select="false()"/>
						<xsl:with-param name="inheritance" select="true()"/>
						<xsl:with-param name="extra" select="false()"/>
					</xsl:call-template>
					</div>

					</td>
					<td>
					<!-- field/property type -->
					<xsl:if test="not(MemberType='Event')">
						<i><xsl:apply-templates select="ReturnValue/ReturnType" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates></i>
						<xsl:if test="MemberValue"> (<xsl:value-of select="MemberValue"/>)</xsl:if>
						<xsl:text>. </xsl:text>
					</xsl:if>

					<!-- description -->
					<xsl:apply-templates select="Docs/summary" mode="notoppara"/>
					</td>
				</xsl:when>

				<!-- method listing -->
				<xsl:when test="$listmembertype='Method'">
					<td>
						<xsl:call-template name="getmodifiers">
							<xsl:with-param name="sig" select="MemberSignature[@Language='C#']/@Value"/>
							<xsl:with-param name="protection" select="false()"/>
							<xsl:with-param name="inheritance" select="true()"/>
							<xsl:with-param name="extra" select="false()"/>
						</xsl:call-template>
					</td>

					<td>

					<!-- link to method page -->
					<b>
					<a href="#member_{$linkname}">
						<xsl:value-of select="@MemberName"/>
					</a>
					</b>

					<!-- argument list -->
					<xsl:value-of select="'('"/>
						<xsl:for-each select="Parameters/Parameter">
							<xsl:if test="not(position()=1)">, </xsl:if>
							
							<xsl:call-template name="ShowParameter">
								<xsl:with-param name="Param" select="."/>
								<xsl:with-param name="TypeNamespace" select="$TypeNamespace"/>
								<xsl:with-param name="prototype" select="true()"/>
							</xsl:call-template>

						</xsl:for-each>
					<xsl:value-of select="')'"/>

					<!-- return type -->
					<xsl:if test="not(ReturnValue/ReturnType='System.Void')">
						<nobr>
						:
						<xsl:apply-templates select="ReturnValue/ReturnType" mode="typelink"><xsl:with-param name="wrt" select="$TypeNamespace"/></xsl:apply-templates>
						</nobr>
					</xsl:if>

					<!-- description -->
					<div>
						<xsl:apply-templates select="Docs/summary" mode="notoppara"/>
					</div>
					</td>
				</xsl:when>

				<xsl:when test="$listmembertype='Operator'">
					<td>

					<!-- link to operator page -->
					<xsl:choose>
					<xsl:when test="@MemberName='op_Implicit' or @MemberName='op_Explicit'">
						<b>
						<a href="#member_{$linkname}">
							Conversion
							<xsl:choose>
							<xsl:when test="ReturnValue/ReturnType = //Type/@FullName">
								From <xsl:value-of select="Parameters/Parameter/@Type"/>
							</xsl:when>
							<xsl:otherwise>
								to <xsl:value-of select="ReturnValue/ReturnType"/>
							</xsl:otherwise>
							</xsl:choose>
						</a>
						</b>						

						<xsl:choose>
						<xsl:when test="@MemberName='op_Implicit'">
							(Implicit)
						</xsl:when>
						<xsl:otherwise>
							(Explicit)
						</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="count(Parameters/Parameter)=1">
						<b>
						<a href="#member_{$linkname}">
							<xsl:value-of select="substring-after(@MemberName, 'op_')"/>
						</a>
						</b>
					</xsl:when>
					<xsl:otherwise>
						<b>
						<a href="#member_{$linkname}">
							<xsl:value-of select="substring-after(@MemberName, 'op_')"/>
						</a>
						</b>
						<xsl:value-of select="'('"/>
							<xsl:for-each select="Parameters/Parameter">
								<xsl:if test="not(position()=1)">, </xsl:if>
								
								<xsl:call-template name="ShowParameter">
									<xsl:with-param name="Param" select="."/>
									<xsl:with-param name="TypeNamespace" select="$TypeNamespace"/>
									<xsl:with-param name="prototype" select="true()"/>
								</xsl:call-template>
	
							</xsl:for-each>
						<xsl:value-of select="')'"/>
					</xsl:otherwise>
					</xsl:choose>
			

					<!-- description -->
					<div>
						<xsl:apply-templates select="Docs/summary" mode="notoppara"/>
					</div>
					</td>
				</xsl:when>
				
				<xsl:otherwise>
					<!-- Other types: just provide a link -->
					<a href="#member_{$linkname}">
						<xsl:value-of select="@MemberName"/>
					</a>
				</xsl:otherwise>
			</xsl:choose>
			
			<!--<tt><xsl:value-of select="MemberSignature[@Language='C#']/@Value"/></tt><br/>-->

			</tr>
		</xsl:for-each>

		</table>
		</div>

		</xsl:if>
	</xsl:template>


	<xsl:template name="getmodifiers">
		<xsl:param name="sig"/>
		<xsl:param name="protection" select="true()"/>
		<xsl:param name="inheritance" select="true()"/>
		<xsl:param name="extra" select="true()"/>
		<xsl:param name="typetype" select="false()"/>

		<xsl:variable name="Sig" select="concat(' ', $sig, ' ')"/>

		<xsl:if test="$protection">
			<xsl:if test="contains($Sig, ' public ')">public </xsl:if>
			<xsl:if test="contains($Sig, ' private ')">private </xsl:if>
			<xsl:if test="contains($Sig, ' protected ')">protected </xsl:if>
			<xsl:if test="contains($Sig, ' internal ')">internal </xsl:if>
		</xsl:if>

		<xsl:if test="contains($Sig, ' static ')">static </xsl:if>
		<xsl:if test="contains($Sig, ' abstract ')">abstract </xsl:if>
		<xsl:if test="contains($Sig, ' operator ')">operator </xsl:if>

		<xsl:if test="contains($Sig, ' const ')">const </xsl:if>
		<xsl:if test="contains($Sig, ' readonly ')">readonly </xsl:if>

		<xsl:if test="$inheritance">
			<xsl:if test="contains($Sig, ' override ')">override </xsl:if>
			<xsl:if test="contains($Sig, ' new ')">override </xsl:if>
		</xsl:if>

		<xsl:if test="$extra">
			<xsl:if test="contains($Sig, ' sealed ')">sealed </xsl:if>
			<xsl:if test="contains($Sig, ' virtual ')">virtual </xsl:if>

			<xsl:if test="contains($Sig, ' extern ')">extern </xsl:if>
			<xsl:if test="contains($Sig, ' checked ')">checked </xsl:if>
			<xsl:if test="contains($Sig, ' unsafe ')">unsafe </xsl:if>
			<xsl:if test="contains($Sig, ' volatile ')">volatile </xsl:if>
			<xsl:if test="contains($Sig, ' explicit ')">explicit </xsl:if>
			<xsl:if test="contains($Sig, ' implicit ')">implicit </xsl:if>
		</xsl:if>

		<xsl:if test="$typetype">
			<xsl:if test="contains($Sig, ' class ')">class </xsl:if>
			<xsl:if test="contains($Sig, ' interface ')">interface </xsl:if>
			<xsl:if test="contains($Sig, ' struct ')">struct </xsl:if>
			<xsl:if test="contains($Sig, ' delegate ')">delegate </xsl:if>
			<xsl:if test="contains($Sig, ' enum ')">enum </xsl:if>
		</xsl:if>
	</xsl:template>
	

</xsl:stylesheet>
