# -*- mode: Perl -*-

# Copyright (c) 2007-2008 Fabien Tassin <fta@sofaraway.org>
# Description: MozClient::Mercurial
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

############################################################################

package MozClient::Mercurial;

use vars qw(@ISA);
use strict;
use MozClient::VCS;

@ISA = ("MozClient::VCS");

sub get_client {
  my $self = shift;

  $self->LOG("MozClient::Mercurial::get_client()");
  # nothing to do
}

sub convert_revdate {
  my $self = shift;
  my $arg = shift;

  $self->LOG("MozClient::Mercurial::convert_revdate($arg)");
  $arg =~ s,^\d+r,,;
  $arg;
}

sub set_revdate {
  my $self = shift;

  $self->LOG("MozClient::Mercurial::set_revdate()");

  # We can set a revision for hg
  $self->{'mozclient_date'} =
    '-r ' . $self->convert_revdate($self->{'have_date'});
}

sub set_tag {
  my $self = shift;
  my $tag  = shift;

  $self->LOG("MozClient::Mercurial::set_tag($tag)");

  $self->{'co_tag'} = "-r $tag";
}

sub checkout {
  my $self = shift;

  $self->LOG("MozClient:Mercurial::checkout:()");
  $self->chdir($self->work_dir);
  my $modules = [];
  if (defined $self->{'MOZCLIENT_PROJECT'}) {
    push @$modules,
      $self->{'MOZCLIENT_VCS_LOC'} . $self->{'MOZCLIENT_PROJECT'} . "/";
  }
  else {
    for my $module (@{$self->{'MOZCLIENT_MODULES'}}) {
      push @$modules, (sprintf " %s%s/%s", $self->{'MOZCLIENT_VCS_LOC'},
	$self->{'MOZCLIENT_PROJECT'}, $module);
    }
  }
  my $cmd = sprintf "hg clone %s %s %s %s", $self->{'mozclient_date'},
    $self->{'co_tag'}, join(" ", @$modules), $self->{'MOZCLIENT_MOZDIRNAME'};
  $self->run_system($cmd);
  $self->chdir("..");
}

sub tar_exclude {
  my $self = shift;

  $self->LOG("MozClient::Mercurial::tar_exclude()");
  [ '--exclude .hg' ];
}

1;
