# -*- mode: makefile; coding: utf-8 -*-

# Copyright (c) 2008 Canonical Ltd.
# Author(s): Alexander Sack <asac@ubuntu.com>
#            Fabien Tassin <fta@sofaraway.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#
# Usage: include this file in your cdbs debian/rules file and define the
#        following variables:
#
#        MOZ_EXTENSION_PKG (MANDATORY):
#        	define the binary package name used to ship this xpi
#
#        MOZ_XPI_FILE (OPTIONAL):
#        	if defined the given .xpi file is used; otherwise we try to
#        	guess one using wildcard (*.xpi)
#
#        MOZ_XPI_EMID (OPTIONAL):
#        	if defined the given id is used to determine the link name
#        	in the firefox extensions directory. if not defined we try
#        	our best to extract the em:id from the install.rdf file shipped
#        	by any xpi
#
#        MOZ_XPI_BUILD_COMMAND (OPTIONAL):
#               if defined the given command will be run _before_ the extension
#               gets packaged up the standard .xpi way. Thus, the build command
#               should produce an .xpi in top level directory. Note: If this
#               command is specified, all .xpi files in the top level directory
#               will be removed during |clean|
#        MOZ_XPI_MOZILLA_DIRS (DEFAULT=firefox-addons):
#               defines in which directories to create links for this extension.
#               the default is "firefox-addons", which means that
#               the extension will be linked appropriately to the
#               /usr/lib/firefox-addons/extensions directory.
#

MOZ_XPI_MOZILLA_DIRS ?= firefox-addons

MOZ_XPI_BUILD_COMMAND ?= med-xpi-pack $(CURDIR) $(MOZ_EXTENSION_PKG).xpi;

TEMPDIR := $(shell rm -rf temp-xpi-*; mktemp -d temp-xpi-XXXXXXXX)

ifneq (,$(MOZ_XPI_FILE))
XPI_FILE = $(MOZ_XPI_FILE)
else
XPI_FILE = $(wildcard *.xpi)
endif

XPI_BASE_FILE = $(notdir $(XPI_FILE))
XPI_DIR       = $(dir $(XPI_FILE))

ifneq (,$(MOZ_XPI_EMID))
XPI_EMID = $(MOZ_XPI_EMID)
else
XPI_EMID = $(shell xpath -e '/node()/Description/em:id/text()' $(1)/install.rdf 2>/dev/null)
endif

# ### cdbs hooks
# build xpi using MOZ_XPI_BUILD_COMMAND if defined
build/$(MOZ_EXTENSION_PKG)::
ifneq (,$(MOZ_XPI_BUILD_COMMAND))
	$(MOZ_XPI_BUILD_COMMAND)
endif

install/$(MOZ_EXTENSION_PKG):: xpi-install

# clean build and remove all .xpi in top-level if a MOZ_XPI_BUILD_COMMAND is defined
clean:: xpi-clean
ifneq (,$(MOZ_XPI_BUILD_COMMAND))
	rm -f *.xpi
endif

# ### general helper targets
stamp-unzip-%:
	unzip -d $(TEMPDIR) $(XPI_DIR)$*
	touch $@

stamp-installdirs-%:
	dh_installdirs -p$(MOZ_EXTENSION_PKG) /usr/lib/$*/extensions
	touch $@

stamp-installlinks-%:
	dh_link -p$(MOZ_EXTENSION_PKG) /usr/share/$(MOZ_EXTENSION_PKG) /usr/lib/$*/extensions/$(call XPI_EMID,$(TEMPDIR))
	touch $@

stamp-install-%: $(foreach mozilla,$(MOZ_XPI_MOZILLA_DIRS),stamp-installdirs-$(mozilla) stamp-installlinks-$(mozilla)) 
	dh_install -p$(MOZ_EXTENSION_PKG) $(wildcard $(TEMPDIR)/*) /usr/share/$(MOZ_EXTENSION_PKG)
	touch $@

stamp-extension-install: $(XPI_FILE) stamp-unzip-$(XPI_BASE_FILE) stamp-install-$(XPI_BASE_FILE)
	touch $@


# only attempt to do things if a pkg was provided; otherwise error out
ifneq (,$(MOZ_EXTENSION_PKG))
xpi-install: stamp-extension-install

xpi-clean:
	dh_clean -p$(MOZ_EXTENSION_PKG)
	-rm -f stamp-extension-install \
		stamp-* \
		$(NULL)
	-rm -rf $(TEMPDIR)


else
xpi-install:
	echo "*** need to define MOZ_EXTENSION_PKG"
	exit 2

xpi-clean:
	echo "*** need to define MOZ_EXTENSION_PKG"
	exit 2
endif

