# -*- mode: makefile; coding: utf-8 -*-

# Copyright (c) 2008-2009 Canonical Ltd.
# Author(s): Alexander Sack <asac@ubuntu.com>
#            Fabien Tassin <fta@sofaraway.org>
#            Benjamin Drung <bdrung@ubuntu.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#
# Usage: include this file in your CDBS debian/rules file and define the
#        following variables:
#
#        MOZ_EXTENSION_PKG (OPTIONAL):
#                if defined the given binary package name is used to ship
#                this xpi; otherwise the first binary package listed in
#                debian/control is used
#
#        MOZ_XPI_FILE (OPTIONAL):
#                if defined the given .xpi file is used; otherwise we try to
#                guess one using wildcard (*.xpi)
#
#        MOZ_XPI_EMID (OPTIONAL):
#                if defined the given id is used to determine the link name
#                in the Firefox extensions directory. if not defined we try
#                our best to extract the em:id from the install.rdf file shipped
#                by any xpi
#
#        MOZ_XPI_BUILD_COMMAND (OPTIONAL):
#                if defined the given command will be run _before_ the extension
#                gets packaged up the standard .xpi way. Thus, the build command
#                should produce an .xpi in top level directory. Note: If this
#                command is specified, all .xpi files in the top level directory
#                will be removed during |clean|. If the .xpi file will not be
#                build from source, you have to set this variable to nothing.
#
#        MOZ_XPI_MOZILLA_EXTRA_DIRS (OPTIONAL):
#                TODO: implement this!
#                defines extra directories to link the extension in. Usually
#                xpi.mk creates the right links based on targetApplication
#                parsed in install.rdf; if you need more directories, use this.
#
#        MOZ_XPI_DOCUMENTED_LICENSE_FILES (OPTIONAL):
#                defines extra license files which need to be excluded during
#                the installation of the XPI file to the packaging tree. When
#                using parameter, be sure that you documented _all_ excluded
#                license files in debian/copyright appropriately. If not defined
#                the common license file names are guessed.
#
#        MOZ_XPI_EXT_NAME (OPTIONAL):
#                defines the name of the extension (without any prefixes like
#                mozilla- or xul-ext-). If not defined MOZ_EXTENSION_PKG with
#                stripped prefixes is used. This value is used to determine
#                xpi:Provides.
#
#        Deprecated variables:
#
#        MOZ_XPI_MOZILLA_DIRS /deprecated/ (OPTIONAL/NODEFAULT - see "Note:"):
#                defines in which directories to create links for this
#                extension. The default is "firefox-addons", which means that
#                the extension will be linked appropriately to the
#                /usr/lib/firefox-addons/extensions directory.
#                '''Note''': this variable is deprecated and will go away; the
#                default is already empty; if you still need this variable,
#                migrate your code to MOZ_XPI_MOZILLA_EXTRA_DIRS
#
#        MOZ_EXT_NAME /deprecated/ (OPTIONAL):
#                this variable is deprecated and will go away; it was renamed
#                to MOZ_XPI_EXT_NAME
#

_xpi_makefile_path ?= /usr/share/mozilla-devscripts

-include $(_xpi_makefile_path)/xpi-config.mk

MOZ_XPI_DISTRO ?= all

# xpi-data-*.mk must define packages_*, *_sol, and *_eol
include $(_xpi_makefile_path)/xpi-data-$(MOZ_XPI_DISTRO).mk

# data for XPI_RECOMMENDS/CHECK_VERSION magic - targetApplication min-/maxVersions
# call parameters_
#   1- target app id
#   2- maxVersion | minVersion
#   3- extension dir
TARGET_VERSION = $(shell xpath -q -e '//em:targetApplication/Description[em:id="$(1)" or @em:id="$(1)"]/em:$(2)/text() | //em:targetApplication/Description[em:id="$(1)" or @em:id="$(1)"]/@em:$(2) | //RDF:Description[@em:id="$(1)"]/em:$(2)/text() | //RDF:Description[@em:id="$(1)"]/@em:$(2)' $(3)/install.rdf | sed -e 's/.*"\(.*\)"/\1/')

# call parameters_
#   1- target app id
#   2- package name
CHECK_VERSION = $(shell \
	moz-version -cs "$($(2)_eol)" ge $(call TARGET_VERSION,$(1),minVersion,$(TEMPDIR)) && \
	moz-version -cs "$($(2)_sol)" le $(call TARGET_VERSION,$(1),maxVersion,$(TEMPDIR)) && \
	echo $(2))

MOZ_EXTENSION_PKG ?= $(strip $(shell grep ^Package: debian/control | head -n 1 | sed "s/^Package://"))

MOZ_XPI_ARCH := $(strip $(shell egrep '^Package:|^Architecture:' debian/control | grep -A1 '^Package:[ \t]*$(MOZ_EXTENSION_PKG)[ \t]*$$' | grep ^Architecture: | sed -e 's/Architecture://'))

MOZ_XPI_BUILD_COMMAND ?= med-xpi-pack $(CURDIR) $(MOZ_EXTENSION_PKG).xpi

XPI_RECOMMENDS = $(strip $(foreach id,$(call XPI_TARGET_EMIDs,$(TEMPDIR)), \
	$(foreach package,$(packages_$(id)),$(call CHECK_VERSION,$(id),$(package)))))

# support for deprecated MOZ_EXT_NAME
ifneq (,$(MOZ_EXT_NAME))
MOZ_XPI_EXT_NAME := $(MOZ_EXT_NAME)
endif

MOZ_XPI_EXT_NAME ?= $(shell echo $(MOZ_EXTENSION_PKG) | sed "s/^firefox-//;s/^iceweasel-//;s/^mozilla-//;s/^xul-ext-//")

ifeq ($(MOZ_XPI_EXT_NAME),$(strip $(shell grep ^Source: debian/control | sed "s/^Source://")))
ADDITIONAL_PROVIDES := $(MOZ_XPI_EXT_NAME)
endif
strip_version = $(sort $(foreach package,$(1),$(shell echo $(package) | sed "s/-[0-9.]*$$//")))
XPI_PROVIDES = $(sort $(filter-out $(MOZ_EXTENSION_PKG),$(ADDITIONAL_PROVIDES) $(addsuffix -$(MOZ_XPI_EXT_NAME),xul-ext $(call strip_version,$(XPI_RECOMMENDS)))))

TEMPDIR := temp-xpi-unpacked

ifneq (,$(MOZ_XPI_FILE))
XPI_FILE = $(wildcard $(MOZ_XPI_FILE))
else
XPI_FILE = $(wildcard *.xpi)
endif

XPI_BASE_FILE = $(notdir $(XPI_FILE))

ifneq (,$(MOZ_XPI_EMID))
XPI_EMID = $(MOZ_XPI_EMID)
else
XPI_EMID = $(sort $(shell xpath -q -e '/node()/Description/em:id/text() | //RDF:Description[@RDF:about="urn:mozilla:install-manifest"]/em:id/text()' $(1)/install.rdf 2>/dev/null) \
		$(shell xpath -q -e '/node()/Description/@em:id | //RDF:Description[@RDF:about="urn:mozilla:install-manifest"]/@em:id' $(1)/install.rdf 2>/dev/null | sed -e 's/.*"\(.*\)"/\1/'))
endif

ifeq (,$(MOZ_XPI_DISABLE_AUTOLINKS))
RDF_RESOURCES = $(shell xpath -q -e '//em:targetApplication/@RDF:resource' $(1)/install.rdf 2>/dev/null | sed -e 's/.*="\(.*\)"/\1/')

XPI_TARGET_EMIDs = \
		$(shell xpath -q -e '//em:targetApplication//@em:id' $(1)/install.rdf 2>/dev/null | sed -e 's/.*"\(.*\)"/\1/') \
		$(shell xpath -q -e '//em:targetApplication//em:id/text()' $(1)/install.rdf 2>/dev/null) \
		$(foreach resource,$(RDF_RESOURCES),$(shell xpath -q -e '//RDF:Description[@RDF:about="$(resource)"]/@em:id' $(1)/install.rdf 2>/dev/null | sed -e 's/.*"\(.*\)"/\1/'))
endif

# local vars
# + lib_share_dir - for arch all this is "share"; otherwise "lib"
ifeq (all, $(MOZ_XPI_ARCH))
lib_share_dir = share
else
lib_share_dir = lib
endif

# ### cdbs hooks
# build xpi using MOZ_XPI_BUILD_COMMAND if defined
build/$(MOZ_EXTENSION_PKG)::
ifneq (,$(MOZ_XPI_BUILD_COMMAND))
	$(MOZ_XPI_BUILD_COMMAND)
endif

install/$(MOZ_EXTENSION_PKG):: xpi-install

# ### general helper targets
unzip-%-stamp: $(XPI_FILE)
	@if test ! -f "$^" -a -f "$<"; then \
		echo "xpi.mk: Failed to extract the xpi file, there are multiple: $^"; \
		echo "xpi.mk: Either create only one xpi file or specify MOZ_XPI_FILE!"; \
		exit 1; \
	fi
	mkdir -p $(TEMPDIR)
ifneq (,$(MOZ_XPI_DOCUMENTED_LICENSE_FILES))
	unzip -o -d $(TEMPDIR) $^ -x $(MOZ_XPI_DOCUMENTED_LICENSE_FILES)
else
	unzip -o -d $(TEMPDIR) $^
ifeq ($(origin MOZ_XPI_DOCUMENTED_LICENSE_FILES),undefined)
	cd $(TEMPDIR) && find \( -iname copying -o -iname gpl.txt -o -iname licen[cs]e -o -iname licen[cs]e.txt \) -printf "xpi.mk: deleted %p\n" -delete
endif
endif
	touch $@

installlinks-%-stamp: $(patsubst %,unzip-%-stamp,$(XPI_BASE_FILE))
	dh_link -p$(MOZ_EXTENSION_PKG) /usr/$(lib_share_dir)/$(MOZ_EXTENSION_PKG) /usr/lib/$*/extensions/$(call XPI_EMID,$(TEMPDIR))
	touch $@

autolinks-stamp: $(patsubst %,unzip-%-stamp,$(XPI_BASE_FILE)) $(foreach mozilla,$(MOZ_XPI_MOZILLA_DIRS),installlinks-$(mozilla)-stamp)
	$(if $(XPI_FILE),,@echo "xpi.mk: No xpi file found. Did you create one?"; \
		echo "xpi.mk: Please check MOZ_XPI_BUILD_COMMAND and maybe MOZ_XPI_FILE!"; \
		exit 2)
	$(if $(call XPI_EMID,$(TEMPDIR)),,@echo "xpi.mk: Detecting the extension manager ID failed."; \
		echo "xpi.mk: This is either a bug in the install.rdf file or in mozilla-devscripts."; \
		echo "xpi.mk: Patch the install.rdf file or use MOZ_XPI_EMID as workaround."; \
		exit 3)
	$(foreach id,$(call XPI_TARGET_EMIDs,$(TEMPDIR)),dh_link -p$(MOZ_EXTENSION_PKG) /usr/$(lib_share_dir)/$(MOZ_EXTENSION_PKG) /usr/lib/mozilla/extensions/$(id)/$(call XPI_EMID,$(TEMPDIR));)
	touch $@

install-%-stamp: unzip-%-stamp
	dh_install -p$(MOZ_EXTENSION_PKG) $(wildcard $(TEMPDIR)/*) /usr/$(lib_share_dir)/$(MOZ_EXTENSION_PKG)
	touch $@

xpi-recommends-stamp: $(patsubst %,unzip-%-stamp,$(XPI_BASE_FILE))
	if test -f debian/$(MOZ_EXTENSION_PKG).substvars; then sed -i '/^xpi:Recommends=/d' debian/$(MOZ_EXTENSION_PKG).substvars; fi
	echo "xpi:Recommends=$(XPI_RECOMMENDS)" | sed "s/ / | /g" >> debian/$(MOZ_EXTENSION_PKG).substvars
ifneq ($(shell grep '$${xpi:Depends}' debian/control),)
	@echo 'xpi.mk: $${xpi:Depends} is deprecated, please use $${xpi:Recommends} instead.'
	if test -f debian/$(MOZ_EXTENSION_PKG).substvars; then sed -i '/^xpi:Depends=/d' debian/$(MOZ_EXTENSION_PKG).substvars; fi
	echo "xpi:Depends=$(XPI_RECOMMENDS)" | sed "s/ / | /g" >> debian/$(MOZ_EXTENSION_PKG).substvars
endif
	if test -f debian/$(MOZ_EXTENSION_PKG).substvars; then sed -i '/^xpi:Provides=/d' debian/$(MOZ_EXTENSION_PKG).substvars; fi
	echo "xpi:Provides=$(XPI_PROVIDES)" | sed "s/ /, /g" >> debian/$(MOZ_EXTENSION_PKG).substvars
	if test -f debian/$(MOZ_EXTENSION_PKG).substvars; then sed -i '/^xpi:Enhances=/d' debian/$(MOZ_EXTENSION_PKG).substvars; fi
	echo "xpi:Enhances=$(sort $(XPI_RECOMMENDS))" | sed "s/ /, /g" >> debian/$(MOZ_EXTENSION_PKG).substvars
	touch $@

xpi-install: $(patsubst %,install-%-stamp,$(XPI_BASE_FILE)) autolinks-stamp xpi-recommends-stamp

# clean build and remove all .xpi in top-level if a MOZ_XPI_BUILD_COMMAND is defined
clean::
	dh_testdir
	dh_clean
	rm -rf $(TEMPDIR)
ifeq ($(shell expr $(shell cat debian/compat) '<' 7),1)
	rm -f *-stamp
endif
ifneq (,$(MOZ_XPI_BUILD_COMMAND))
	rm -f *.xpi
endif

.PHONY: clean xpi-install
