/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.HyperlinkEvent;
import com.sun.java.swing.event.HyperlinkListener;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.EditorKit;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import com.sun.java.swing.text.WrappedPlainView;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

public class JEditorPane
extends JTextComponent {
    private EditorKit kit;
    private Hashtable typeHandlers;
    private static final Object kitRegistryKey = new StringBuffer("JEditorPane.kitRegistry");
    private static final Object kitTypeRegistryKey = new StringBuffer("JEditorPane.kitTypeRegistry");
    static /* synthetic */ Class class$com$sun$java$swing$event$HyperlinkListener;

    public JEditorPane() {
    }

    public JEditorPane(URL uRL) throws IOException {
        this();
        this.setPage(uRL);
    }

    public JEditorPane(String string) throws IOException {
        this();
        this.setPage(string);
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(class$com$sun$java$swing$event$HyperlinkListener != null ? class$com$sun$java$swing$event$HyperlinkListener : (class$com$sun$java$swing$event$HyperlinkListener = JComponent.class$("com.sun.java.swing.event.HyperlinkListener")), hyperlinkListener);
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$HyperlinkListener != null ? class$com$sun$java$swing$event$HyperlinkListener : (class$com$sun$java$swing$event$HyperlinkListener = JComponent.class$("com.sun.java.swing.event.HyperlinkListener")), hyperlinkListener);
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$HyperlinkListener != null ? class$com$sun$java$swing$event$HyperlinkListener : JComponent.class$("com.sun.java.swing.event.HyperlinkListener"))) {
                ((HyperlinkListener)objectArray[n + 1]).hyperlinkUpdate(hyperlinkEvent);
            }
            n -= 2;
        }
    }

    public void setPage(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        InputStream inputStream = uRL.openStream();
        URLConnection uRLConnection = uRL.openConnection();
        String string = uRLConnection.getContentType();
        this.setContentType(string);
        if (this.kit != null) {
            Document document = this.kit.createDefaultDocument();
            document.putProperty("stream", uRL);
            try {
                this.kit.read(inputStream, document, 0);
                this.setDocument(document);
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException(badLocationException.getMessage());
            }
        }
    }

    public URL getPage() {
        return (URL)this.getDocument().getProperty("stream");
    }

    public void setPage(String string) throws IOException {
        if (string == null) {
            throw new IOException("invalid url");
        }
        URL uRL = new URL(string);
        this.setPage(uRL);
    }

    public String getUIClassID() {
        return "EditorPaneUI";
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public final EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = this.createDefaultEditorKit();
        }
        return this.kit;
    }

    public final String getContentType() {
        if (this.kit != null) {
            return this.kit.getContentType();
        }
        return null;
    }

    public final void setContentType(String string) {
        EditorKit editorKit;
        if (!(this.kit != null && string.equals(this.kit.getContentType()) || (editorKit = this.getEditorKitForContentType(string)) == null)) {
            this.setEditorKit(editorKit);
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        EditorKit editorKit2 = this.kit;
        if (editorKit2 != null) {
            editorKit2.deinstall(this);
        }
        this.kit = editorKit;
        if (this.kit != null) {
            this.kit.install(this);
            this.setDocument(this.kit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((editorKit = (EditorKit)this.typeHandlers.get(string)) == null && (editorKit = JEditorPane.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = new DefaultEditorKit();
        }
        return editorKit;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, editorKit);
    }

    public static EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        Hashtable<String, EditorKit> hashtable = (Hashtable<String, EditorKit>)SwingUtilities.appContextGet(kitRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable<String, EditorKit>();
            SwingUtilities.appContextPut(kitRegistryKey, hashtable);
        } else {
            editorKit = (EditorKit)hashtable.get(string);
        }
        if (editorKit == null) {
            String string2 = (String)JEditorPane.getKitTypeRegistry().get(string);
            try {
                Class<?> clazz = Class.forName(string2);
                editorKit = (EditorKit)clazz.newInstance();
                hashtable.put(string, editorKit);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        return null;
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        JEditorPane.getKitTypeRegistry().put(string, string2);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    private static Hashtable getKitTypeRegistry() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(kitTypeRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable();
            SwingUtilities.appContextPut(kitTypeRegistryKey, hashtable);
        }
        return hashtable;
    }

    static {
        JEditorPane.registerEditorKitForContentType("text/plain", "com.sun.java.swing.JEditorPane$PlainEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "com.sun.java.swing.text.html.HTMLEditorKit");
        JEditorPane.registerEditorKitForContentType("text/rtf", "com.sun.java.swing.text.rtf.RTFEditorKit");
        JEditorPane.registerEditorKitForContentType("application/rtf", "com.sun.java.swing.text.rtf.RTFEditorKit");
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            return JEditorPane.this.getContentType();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }

        AccessibleJEditorPane() {
            super(JEditorPane.this);
            JEditorPane.this = JEditorPane.this;
        }
    }

    static class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        PlainEditorKit() {
        }
    }
}

