/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Composite;
import base.drawable.DrawOrderComparator;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import logformat.slog2.BufForObjects;
import logformat.slog2.IteratorOfBackDrawables;
import logformat.slog2.IteratorOfBackPrimitives;
import logformat.slog2.IteratorOfForeDrawables;
import logformat.slog2.IteratorOfForeDrawablesOfAll;
import logformat.slog2.IteratorOfForePrimitives;
import logformat.slog2.LineIDMap;

public class BufForDrawables
extends BufForObjects {
    private static final int INIT_BYTESIZE = 42;
    private static final DrawOrderComparator DRAWING_ORDER = new DrawOrderComparator();
    private static final byte PRIMITIVE_ID = 0;
    private static final byte COMPOSITE_ID = 1;
    private List buf4nestable;
    private List buf4nestless;
    private boolean isOutputBuf;
    private boolean haveObjectsBeenSaved;
    private int total_bytesize;

    public BufForDrawables(boolean bl) {
        this.isOutputBuf = bl;
        if (this.isOutputBuf) {
            this.buf4nestable = new ArrayList();
            this.buf4nestless = new ArrayList();
        } else {
            this.buf4nestable = null;
            this.buf4nestless = null;
        }
        this.haveObjectsBeenSaved = false;
        this.total_bytesize = 42;
    }

    public int getByteSize() {
        return this.total_bytesize;
    }

    public void add(Primitive primitive) {
        if (primitive.getCategory().getTopology().isState()) {
            this.buf4nestable.add(primitive);
        } else {
            this.buf4nestless.add(primitive);
        }
        this.total_bytesize += primitive.getByteSize() + 1;
    }

    public void add(Composite composite) {
        this.buf4nestable.add(composite);
        this.total_bytesize += composite.getByteSize() + 1;
    }

    public void empty() {
        if (this.haveObjectsBeenSaved) {
            this.buf4nestable.clear();
            this.buf4nestless.clear();
            this.haveObjectsBeenSaved = false;
            this.total_bytesize = 42;
        }
    }

    public int getNumOfDrawables() {
        return this.buf4nestable.size() + this.buf4nestless.size();
    }

    public int getNumOfPrimitives() {
        int n = this.buf4nestless.size();
        Iterator iterator = this.buf4nestable.iterator();
        while (iterator.hasNext()) {
            n += ((Drawable)iterator.next()).getNumOfPrimitives();
        }
        return n;
    }

    public Iterator nestableForeIterator(TimeBoundingBox timeBoundingBox, boolean bl) {
        if (bl) {
            return new IteratorOfForeDrawables(this.buf4nestable, timeBoundingBox);
        }
        return new IteratorOfForePrimitives(this.buf4nestable, timeBoundingBox);
    }

    public Iterator nestlessForeIterator(TimeBoundingBox timeBoundingBox) {
        return new IteratorOfForeDrawables(this.buf4nestless, timeBoundingBox);
    }

    public Iterator nestableBackIterator(TimeBoundingBox timeBoundingBox, boolean bl) {
        if (bl) {
            return new IteratorOfBackDrawables(this.buf4nestable, timeBoundingBox);
        }
        return new IteratorOfBackPrimitives(this.buf4nestable, timeBoundingBox);
    }

    public Iterator nestlessBackIterator(TimeBoundingBox timeBoundingBox) {
        return new IteratorOfBackDrawables(this.buf4nestless, timeBoundingBox);
    }

    public LineIDMap getIdentityLineIDMap() {
        ArrayList arrayList = new ArrayList(this.buf4nestable);
        arrayList.addAll(this.buf4nestless);
        return BufForObjects.toIdentityLineIDMap(arrayList);
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        Drawable drawable;
        super.writeObject(mixedDataOutput);
        Collections.sort(this.buf4nestable, DRAWING_ORDER);
        Collections.sort(this.buf4nestless, DRAWING_ORDER);
        int n = this.buf4nestless.size();
        mixedDataOutput.writeInt(n);
        ListIterator listIterator = this.buf4nestless.listIterator(0);
        while (listIterator.hasNext()) {
            drawable = (Drawable)listIterator.next();
            if (drawable instanceof Composite) {
                mixedDataOutput.writeByte(1);
                ((Composite)drawable).writeObject(mixedDataOutput);
                continue;
            }
            mixedDataOutput.writeByte(0);
            ((Primitive)drawable).writeObject(mixedDataOutput);
        }
        n = this.buf4nestable.size();
        mixedDataOutput.writeInt(n);
        listIterator = this.buf4nestable.listIterator(0);
        while (listIterator.hasNext()) {
            drawable = (Drawable)listIterator.next();
            if (drawable instanceof Composite) {
                mixedDataOutput.writeByte(1);
                ((Composite)drawable).writeObject(mixedDataOutput);
                continue;
            }
            mixedDataOutput.writeByte(0);
            ((Primitive)drawable).writeObject(mixedDataOutput);
        }
        this.haveObjectsBeenSaved = true;
    }

    public BufForDrawables(MixedDataInput mixedDataInput, Map map) throws IOException {
        this(false);
        this.readObject(mixedDataInput, map);
    }

    public void readObject(MixedDataInput mixedDataInput, Map map) throws IOException {
        Composite composite;
        Primitive primitive;
        byte by;
        int n;
        super.readObject(mixedDataInput);
        int n2 = mixedDataInput.readInt();
        this.buf4nestless = new ArrayList(n2);
        block8: for (n = 0; n < n2; ++n) {
            by = mixedDataInput.readByte();
            switch (by) {
                case 0: {
                    primitive = new Primitive(mixedDataInput);
                    primitive.resolveCategory(map);
                    this.buf4nestless.add(primitive);
                    this.total_bytesize += primitive.getByteSize() + 1;
                    continue block8;
                }
                case 1: {
                    composite = new Composite(mixedDataInput);
                    composite.resolveCategory(map);
                    this.buf4nestless.add(composite);
                    this.total_bytesize += composite.getByteSize() + 1;
                    continue block8;
                }
                default: {
                    System.err.println("BufForDrawables: Error! Unknown drawable type = " + by);
                }
            }
        }
        n2 = mixedDataInput.readInt();
        this.buf4nestable = new ArrayList(n2);
        block9: for (n = 0; n < n2; ++n) {
            by = mixedDataInput.readByte();
            switch (by) {
                case 0: {
                    primitive = new Primitive(mixedDataInput);
                    primitive.resolveCategory(map);
                    this.buf4nestable.add(primitive);
                    this.total_bytesize += primitive.getByteSize() + 1;
                    continue block9;
                }
                case 1: {
                    composite = new Composite(mixedDataInput);
                    composite.resolveCategory(map);
                    this.buf4nestable.add(composite);
                    this.total_bytesize += composite.getByteSize() + 1;
                    continue block9;
                }
                default: {
                    System.err.println("BufForDrawables: Error! Unknown drawable type = " + by);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("    BufForDrawables{ ");
        stringBuffer.append(super.toString());
        stringBuffer.append(" }\n");
        IteratorOfForeDrawables iteratorOfForeDrawables = new IteratorOfForeDrawables(this.buf4nestable, this);
        IteratorOfForeDrawables iteratorOfForeDrawables2 = new IteratorOfForeDrawables(this.buf4nestless, this);
        IteratorOfForeDrawablesOfAll iteratorOfForeDrawablesOfAll = new IteratorOfForeDrawablesOfAll(iteratorOfForeDrawables, iteratorOfForeDrawables2);
        int n = 1;
        while (iteratorOfForeDrawablesOfAll.hasNext()) {
            stringBuffer.append(n + ": " + iteratorOfForeDrawablesOfAll.next() + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

