
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 24 "/export/home/pb2/build/sb_0-15194557-1430741448.18/mysql-5.5.44-release-export-7920655_gpl/sql/sql_yacc.yy"

/*
Note: YYTHD is passed as an argument to yyparse(), and subsequently to yylex().
*/
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Alter_table*_statement
#include "sql_truncate.h"                      // Truncate_statement
#include "sql_admin.h"                         // Analyze/Check..._table_stmt
#include "sql_partition_admin.h"               // Alter_table_*_partition_stmt
#include "sql_signal.h"
#include "event_parse_data.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(YYTHD, (char*) (A));            \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable_t *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->dflt)
    it= spv->dflt;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_NO_WRITE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}



/* Line 189 of yacc.c  */
#line 790 "/export/home/pb2/build/sb_0-15194557-1430741448.18/dist_GPL/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     AT_SYM = 277,
     AUTHORS_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BLOCK_SYM = 296,
     BOOLEAN_SYM = 297,
     BOOL_SYM = 298,
     BOTH = 299,
     BTREE_SYM = 300,
     BY = 301,
     BYTE_SYM = 302,
     CACHE_SYM = 303,
     CALL_SYM = 304,
     CASCADE = 305,
     CASCADED = 306,
     CASE_SYM = 307,
     CAST_SYM = 308,
     CATALOG_NAME_SYM = 309,
     CHAIN_SYM = 310,
     CHANGE = 311,
     CHANGED = 312,
     CHARSET = 313,
     CHAR_SYM = 314,
     CHECKSUM_SYM = 315,
     CHECK_SYM = 316,
     CIPHER_SYM = 317,
     CLASS_ORIGIN_SYM = 318,
     CLIENT_SYM = 319,
     CLOSE_SYM = 320,
     COALESCE = 321,
     CODE_SYM = 322,
     COLLATE_SYM = 323,
     COLLATION_SYM = 324,
     COLUMNS = 325,
     COLUMN_SYM = 326,
     COLUMN_NAME_SYM = 327,
     COMMENT_SYM = 328,
     COMMITTED_SYM = 329,
     COMMIT_SYM = 330,
     COMPACT_SYM = 331,
     COMPLETION_SYM = 332,
     COMPRESSED_SYM = 333,
     CONCURRENT = 334,
     CONDITION_SYM = 335,
     CONNECTION_SYM = 336,
     CONSISTENT_SYM = 337,
     CONSTRAINT = 338,
     CONSTRAINT_CATALOG_SYM = 339,
     CONSTRAINT_NAME_SYM = 340,
     CONSTRAINT_SCHEMA_SYM = 341,
     CONTAINS_SYM = 342,
     CONTEXT_SYM = 343,
     CONTINUE_SYM = 344,
     CONTRIBUTORS_SYM = 345,
     CONVERT_SYM = 346,
     COUNT_SYM = 347,
     CPU_SYM = 348,
     CREATE = 349,
     CROSS = 350,
     CUBE_SYM = 351,
     CURDATE = 352,
     CURRENT_USER = 353,
     CURSOR_SYM = 354,
     CURSOR_NAME_SYM = 355,
     CURTIME = 356,
     DATABASE = 357,
     DATABASES = 358,
     DATAFILE_SYM = 359,
     DATA_SYM = 360,
     DATETIME = 361,
     DATE_ADD_INTERVAL = 362,
     DATE_SUB_INTERVAL = 363,
     DATE_SYM = 364,
     DAY_HOUR_SYM = 365,
     DAY_MICROSECOND_SYM = 366,
     DAY_MINUTE_SYM = 367,
     DAY_SECOND_SYM = 368,
     DAY_SYM = 369,
     DEALLOCATE_SYM = 370,
     DECIMAL_NUM = 371,
     DECIMAL_SYM = 372,
     DECLARE_SYM = 373,
     DEFAULT = 374,
     DEFINER_SYM = 375,
     DELAYED_SYM = 376,
     DELAY_KEY_WRITE_SYM = 377,
     DELETE_SYM = 378,
     DESC = 379,
     DESCRIBE = 380,
     DES_KEY_FILE = 381,
     DETERMINISTIC_SYM = 382,
     DIRECTORY_SYM = 383,
     DISABLE_SYM = 384,
     DISCARD = 385,
     DISK_SYM = 386,
     DISTINCT = 387,
     DIV_SYM = 388,
     DOUBLE_SYM = 389,
     DO_SYM = 390,
     DROP = 391,
     DUAL_SYM = 392,
     DUMPFILE = 393,
     DUPLICATE_SYM = 394,
     DYNAMIC_SYM = 395,
     EACH_SYM = 396,
     ELSE = 397,
     ELSEIF_SYM = 398,
     ENABLE_SYM = 399,
     ENCLOSED = 400,
     END = 401,
     ENDS_SYM = 402,
     END_OF_INPUT = 403,
     ENGINES_SYM = 404,
     ENGINE_SYM = 405,
     ENUM = 406,
     EQ = 407,
     EQUAL_SYM = 408,
     ERROR_SYM = 409,
     ERRORS = 410,
     ESCAPED = 411,
     ESCAPE_SYM = 412,
     EVENTS_SYM = 413,
     EVENT_SYM = 414,
     EVERY_SYM = 415,
     EXECUTE_SYM = 416,
     EXISTS = 417,
     EXIT_SYM = 418,
     EXPANSION_SYM = 419,
     EXTENDED_SYM = 420,
     EXTENT_SIZE_SYM = 421,
     EXTRACT_SYM = 422,
     FALSE_SYM = 423,
     FAST_SYM = 424,
     FAULTS_SYM = 425,
     FETCH_SYM = 426,
     FILE_SYM = 427,
     FIRST_SYM = 428,
     FIXED_SYM = 429,
     FLOAT_NUM = 430,
     FLOAT_SYM = 431,
     FLUSH_SYM = 432,
     FORCE_SYM = 433,
     FOREIGN = 434,
     FOR_SYM = 435,
     FOUND_SYM = 436,
     FROM = 437,
     FULL = 438,
     FULLTEXT_SYM = 439,
     FUNCTION_SYM = 440,
     GE = 441,
     GENERAL = 442,
     GEOMETRYCOLLECTION = 443,
     GEOMETRY_SYM = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GROUP_SYM = 449,
     GROUP_CONCAT_SYM = 450,
     GT_SYM = 451,
     HANDLER_SYM = 452,
     HASH_SYM = 453,
     HAVING = 454,
     HELP_SYM = 455,
     HEX_NUM = 456,
     HIGH_PRIORITY = 457,
     HOST_SYM = 458,
     HOSTS_SYM = 459,
     HOUR_MICROSECOND_SYM = 460,
     HOUR_MINUTE_SYM = 461,
     HOUR_SECOND_SYM = 462,
     HOUR_SYM = 463,
     IDENT = 464,
     IDENTIFIED_SYM = 465,
     IDENT_QUOTED = 466,
     IF = 467,
     IGNORE_SYM = 468,
     IGNORE_SERVER_IDS_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INITIAL_SIZE_SYM = 474,
     INNER_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INSTALL_SYM = 480,
     INTERVAL_SYM = 481,
     INTO = 482,
     INT_SYM = 483,
     INVOKER_SYM = 484,
     IN_SYM = 485,
     IO_SYM = 486,
     IPC_SYM = 487,
     IS = 488,
     ISOLATION = 489,
     ISSUER_SYM = 490,
     ITERATE_SYM = 491,
     JOIN_SYM = 492,
     KEYS = 493,
     KEY_BLOCK_SIZE = 494,
     KEY_SYM = 495,
     KILL_SYM = 496,
     LANGUAGE_SYM = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAVES = 501,
     LEAVE_SYM = 502,
     LEFT = 503,
     LESS_SYM = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEAR_SYM = 509,
     LINES = 510,
     LINESTRING = 511,
     LIST_SYM = 512,
     LOAD = 513,
     LOCAL_SYM = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGFILE_SYM = 518,
     LOGS_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MASTER_CONNECT_RETRY_SYM = 527,
     MASTER_HOST_SYM = 528,
     MASTER_LOG_FILE_SYM = 529,
     MASTER_LOG_POS_SYM = 530,
     MASTER_PASSWORD_SYM = 531,
     MASTER_PORT_SYM = 532,
     MASTER_SERVER_ID_SYM = 533,
     MASTER_SSL_CAPATH_SYM = 534,
     MASTER_SSL_CA_SYM = 535,
     MASTER_SSL_CERT_SYM = 536,
     MASTER_SSL_CIPHER_SYM = 537,
     MASTER_SSL_KEY_SYM = 538,
     MASTER_SSL_SYM = 539,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 540,
     MASTER_SYM = 541,
     MASTER_USER_SYM = 542,
     MASTER_HEARTBEAT_PERIOD_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SIZE_SYM = 548,
     MAX_SYM = 549,
     MAX_UPDATES_PER_HOUR = 550,
     MAX_USER_CONNECTIONS_SYM = 551,
     MAX_VALUE_SYM = 552,
     MEDIUMBLOB = 553,
     MEDIUMINT = 554,
     MEDIUMTEXT = 555,
     MEDIUM_SYM = 556,
     MEMORY_SYM = 557,
     MERGE_SYM = 558,
     MESSAGE_TEXT_SYM = 559,
     MICROSECOND_SYM = 560,
     MIGRATE_SYM = 561,
     MINUTE_MICROSECOND_SYM = 562,
     MINUTE_SECOND_SYM = 563,
     MINUTE_SYM = 564,
     MIN_ROWS = 565,
     MIN_SYM = 566,
     MODE_SYM = 567,
     MODIFIES_SYM = 568,
     MODIFY_SYM = 569,
     MOD_SYM = 570,
     MONTH_SYM = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     MYSQL_ERRNO_SYM = 576,
     NAMES_SYM = 577,
     NAME_SYM = 578,
     NATIONAL_SYM = 579,
     NATURAL = 580,
     NCHAR_STRING = 581,
     NCHAR_SYM = 582,
     NDBCLUSTER_SYM = 583,
     NE = 584,
     NEG = 585,
     NEW_SYM = 586,
     NEXT_SYM = 587,
     NODEGROUP_SYM = 588,
     NONE_SYM = 589,
     NOT2_SYM = 590,
     NOT_SYM = 591,
     NOW_SYM = 592,
     NO_SYM = 593,
     NO_WAIT_SYM = 594,
     NO_WRITE_TO_BINLOG = 595,
     NULL_SYM = 596,
     NUM = 597,
     NUMERIC_SYM = 598,
     NVARCHAR_SYM = 599,
     OFFSET_SYM = 600,
     OLD_PASSWORD = 601,
     ON = 602,
     ONE_SHOT_SYM = 603,
     ONE_SYM = 604,
     OPEN_SYM = 605,
     OPTIMIZE = 606,
     OPTIONS_SYM = 607,
     OPTION = 608,
     OPTIONALLY = 609,
     OR2_SYM = 610,
     ORDER_SYM = 611,
     OR_OR_SYM = 612,
     OR_SYM = 613,
     OUTER = 614,
     OUTFILE = 615,
     OUT_SYM = 616,
     OWNER_SYM = 617,
     PACK_KEYS_SYM = 618,
     PAGE_SYM = 619,
     PARAM_MARKER = 620,
     PARSER_SYM = 621,
     PARTIAL = 622,
     PARTITIONING_SYM = 623,
     PARTITIONS_SYM = 624,
     PARTITION_SYM = 625,
     PASSWORD = 626,
     PHASE_SYM = 627,
     PLUGINS_SYM = 628,
     PLUGIN_SYM = 629,
     POINT_SYM = 630,
     POLYGON = 631,
     PORT_SYM = 632,
     POSITION_SYM = 633,
     PRECISION = 634,
     PREPARE_SYM = 635,
     PRESERVE_SYM = 636,
     PREV_SYM = 637,
     PRIMARY_SYM = 638,
     PRIVILEGES = 639,
     PROCEDURE_SYM = 640,
     PROCESS = 641,
     PROCESSLIST_SYM = 642,
     PROFILE_SYM = 643,
     PROFILES_SYM = 644,
     PROXY_SYM = 645,
     PURGE = 646,
     QUARTER_SYM = 647,
     QUERY_SYM = 648,
     QUICK = 649,
     RANGE_SYM = 650,
     READS_SYM = 651,
     READ_ONLY_SYM = 652,
     READ_SYM = 653,
     READ_WRITE_SYM = 654,
     REAL = 655,
     REBUILD_SYM = 656,
     RECOVER_SYM = 657,
     REDOFILE_SYM = 658,
     REDO_BUFFER_SIZE_SYM = 659,
     REDUNDANT_SYM = 660,
     REFERENCES = 661,
     REGEXP = 662,
     RELAY = 663,
     RELAYLOG_SYM = 664,
     RELAY_LOG_FILE_SYM = 665,
     RELAY_LOG_POS_SYM = 666,
     RELAY_THREAD = 667,
     RELEASE_SYM = 668,
     RELOAD = 669,
     REMOVE_SYM = 670,
     RENAME = 671,
     REORGANIZE_SYM = 672,
     REPAIR = 673,
     REPEATABLE_SYM = 674,
     REPEAT_SYM = 675,
     REPLACE = 676,
     REPLICATION = 677,
     REQUIRE_SYM = 678,
     RESET_SYM = 679,
     RESIGNAL_SYM = 680,
     RESOURCES = 681,
     RESTORE_SYM = 682,
     RESTRICT = 683,
     RESUME_SYM = 684,
     RETURNS_SYM = 685,
     RETURN_SYM = 686,
     REVOKE = 687,
     RIGHT = 688,
     ROLLBACK_SYM = 689,
     ROLLUP_SYM = 690,
     ROUTINE_SYM = 691,
     ROWS_SYM = 692,
     ROW_FORMAT_SYM = 693,
     ROW_SYM = 694,
     RTREE_SYM = 695,
     SAVEPOINT_SYM = 696,
     SCHEDULE_SYM = 697,
     SCHEMA_NAME_SYM = 698,
     SECOND_MICROSECOND_SYM = 699,
     SECOND_SYM = 700,
     SECURITY_SYM = 701,
     SELECT_SYM = 702,
     SENSITIVE_SYM = 703,
     SEPARATOR_SYM = 704,
     SERIALIZABLE_SYM = 705,
     SERIAL_SYM = 706,
     SESSION_SYM = 707,
     SERVER_SYM = 708,
     SERVER_OPTIONS = 709,
     SET = 710,
     SET_VAR = 711,
     SHARE_SYM = 712,
     SHIFT_LEFT = 713,
     SHIFT_RIGHT = 714,
     SHOW = 715,
     SHUTDOWN = 716,
     SIGNAL_SYM = 717,
     SIGNED_SYM = 718,
     SIMPLE_SYM = 719,
     SLAVE = 720,
     SLOW = 721,
     SMALLINT = 722,
     SNAPSHOT_SYM = 723,
     SOCKET_SYM = 724,
     SONAME_SYM = 725,
     SOUNDS_SYM = 726,
     SOURCE_SYM = 727,
     SPATIAL_SYM = 728,
     SPECIFIC_SYM = 729,
     SQLEXCEPTION_SYM = 730,
     SQLSTATE_SYM = 731,
     SQLWARNING_SYM = 732,
     SQL_BIG_RESULT = 733,
     SQL_BUFFER_RESULT = 734,
     SQL_CACHE_SYM = 735,
     SQL_CALC_FOUND_ROWS = 736,
     SQL_NO_CACHE_SYM = 737,
     SQL_SMALL_RESULT = 738,
     SQL_SYM = 739,
     SQL_THREAD = 740,
     SSL_SYM = 741,
     STARTING = 742,
     STARTS_SYM = 743,
     START_SYM = 744,
     STATUS_SYM = 745,
     STDDEV_SAMP_SYM = 746,
     STD_SYM = 747,
     STOP_SYM = 748,
     STORAGE_SYM = 749,
     STRAIGHT_JOIN = 750,
     STRING_SYM = 751,
     SUBCLASS_ORIGIN_SYM = 752,
     SUBDATE_SYM = 753,
     SUBJECT_SYM = 754,
     SUBPARTITIONS_SYM = 755,
     SUBPARTITION_SYM = 756,
     SUBSTRING = 757,
     SUM_SYM = 758,
     SUPER_SYM = 759,
     SUSPEND_SYM = 760,
     SWAPS_SYM = 761,
     SWITCHES_SYM = 762,
     SYSDATE = 763,
     TABLES = 764,
     TABLESPACE = 765,
     TABLE_REF_PRIORITY = 766,
     TABLE_SYM = 767,
     TABLE_CHECKSUM_SYM = 768,
     TABLE_NAME_SYM = 769,
     TEMPORARY = 770,
     TEMPTABLE_SYM = 771,
     TERMINATED = 772,
     TEXT_STRING = 773,
     TEXT_SYM = 774,
     THAN_SYM = 775,
     THEN_SYM = 776,
     TIMESTAMP = 777,
     TIMESTAMP_ADD = 778,
     TIMESTAMP_DIFF = 779,
     TIME_SYM = 780,
     TINYBLOB = 781,
     TINYINT = 782,
     TINYTEXT = 783,
     TO_SYM = 784,
     TRAILING = 785,
     TRANSACTION_SYM = 786,
     TRIGGERS_SYM = 787,
     TRIGGER_SYM = 788,
     TRIM = 789,
     TRUE_SYM = 790,
     TRUNCATE_SYM = 791,
     TYPES_SYM = 792,
     TYPE_SYM = 793,
     UDF_RETURNS_SYM = 794,
     ULONGLONG_NUM = 795,
     UNCOMMITTED_SYM = 796,
     UNDEFINED_SYM = 797,
     UNDERSCORE_CHARSET = 798,
     UNDOFILE_SYM = 799,
     UNDO_BUFFER_SIZE_SYM = 800,
     UNDO_SYM = 801,
     UNICODE_SYM = 802,
     UNINSTALL_SYM = 803,
     UNION_SYM = 804,
     UNIQUE_SYM = 805,
     UNKNOWN_SYM = 806,
     UNLOCK_SYM = 807,
     UNSIGNED = 808,
     UNTIL_SYM = 809,
     UPDATE_SYM = 810,
     UPGRADE_SYM = 811,
     USAGE = 812,
     USER = 813,
     USE_FRM = 814,
     USE_SYM = 815,
     USING = 816,
     UTC_DATE_SYM = 817,
     UTC_TIMESTAMP_SYM = 818,
     UTC_TIME_SYM = 819,
     VALUES = 820,
     VALUE_SYM = 821,
     VARBINARY = 822,
     VARCHAR = 823,
     VARIABLES = 824,
     VARIANCE_SYM = 825,
     VARYING = 826,
     VAR_SAMP_SYM = 827,
     VIEW_SYM = 828,
     WAIT_SYM = 829,
     WARNINGS = 830,
     WEEK_SYM = 831,
     WHEN_SYM = 832,
     WHERE = 833,
     WHILE_SYM = 834,
     WITH = 835,
     WITH_CUBE_SYM = 836,
     WITH_ROLLUP_SYM = 837,
     WORK_SYM = 838,
     WRAPPER_SYM = 839,
     WRITE_SYM = 840,
     X509_SYM = 841,
     XA_SYM = 842,
     XML_SYM = 843,
     XOR = 844,
     YEAR_MONTH_SYM = 845,
     YEAR_SYM = 846,
     ZEROFILL = 847
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define AT_SYM 277
#define AUTHORS_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CATALOG_NAME_SYM 309
#define CHAIN_SYM 310
#define CHANGE 311
#define CHANGED 312
#define CHARSET 313
#define CHAR_SYM 314
#define CHECKSUM_SYM 315
#define CHECK_SYM 316
#define CIPHER_SYM 317
#define CLASS_ORIGIN_SYM 318
#define CLIENT_SYM 319
#define CLOSE_SYM 320
#define COALESCE 321
#define CODE_SYM 322
#define COLLATE_SYM 323
#define COLLATION_SYM 324
#define COLUMNS 325
#define COLUMN_SYM 326
#define COLUMN_NAME_SYM 327
#define COMMENT_SYM 328
#define COMMITTED_SYM 329
#define COMMIT_SYM 330
#define COMPACT_SYM 331
#define COMPLETION_SYM 332
#define COMPRESSED_SYM 333
#define CONCURRENT 334
#define CONDITION_SYM 335
#define CONNECTION_SYM 336
#define CONSISTENT_SYM 337
#define CONSTRAINT 338
#define CONSTRAINT_CATALOG_SYM 339
#define CONSTRAINT_NAME_SYM 340
#define CONSTRAINT_SCHEMA_SYM 341
#define CONTAINS_SYM 342
#define CONTEXT_SYM 343
#define CONTINUE_SYM 344
#define CONTRIBUTORS_SYM 345
#define CONVERT_SYM 346
#define COUNT_SYM 347
#define CPU_SYM 348
#define CREATE 349
#define CROSS 350
#define CUBE_SYM 351
#define CURDATE 352
#define CURRENT_USER 353
#define CURSOR_SYM 354
#define CURSOR_NAME_SYM 355
#define CURTIME 356
#define DATABASE 357
#define DATABASES 358
#define DATAFILE_SYM 359
#define DATA_SYM 360
#define DATETIME 361
#define DATE_ADD_INTERVAL 362
#define DATE_SUB_INTERVAL 363
#define DATE_SYM 364
#define DAY_HOUR_SYM 365
#define DAY_MICROSECOND_SYM 366
#define DAY_MINUTE_SYM 367
#define DAY_SECOND_SYM 368
#define DAY_SYM 369
#define DEALLOCATE_SYM 370
#define DECIMAL_NUM 371
#define DECIMAL_SYM 372
#define DECLARE_SYM 373
#define DEFAULT 374
#define DEFINER_SYM 375
#define DELAYED_SYM 376
#define DELAY_KEY_WRITE_SYM 377
#define DELETE_SYM 378
#define DESC 379
#define DESCRIBE 380
#define DES_KEY_FILE 381
#define DETERMINISTIC_SYM 382
#define DIRECTORY_SYM 383
#define DISABLE_SYM 384
#define DISCARD 385
#define DISK_SYM 386
#define DISTINCT 387
#define DIV_SYM 388
#define DOUBLE_SYM 389
#define DO_SYM 390
#define DROP 391
#define DUAL_SYM 392
#define DUMPFILE 393
#define DUPLICATE_SYM 394
#define DYNAMIC_SYM 395
#define EACH_SYM 396
#define ELSE 397
#define ELSEIF_SYM 398
#define ENABLE_SYM 399
#define ENCLOSED 400
#define END 401
#define ENDS_SYM 402
#define END_OF_INPUT 403
#define ENGINES_SYM 404
#define ENGINE_SYM 405
#define ENUM 406
#define EQ 407
#define EQUAL_SYM 408
#define ERROR_SYM 409
#define ERRORS 410
#define ESCAPED 411
#define ESCAPE_SYM 412
#define EVENTS_SYM 413
#define EVENT_SYM 414
#define EVERY_SYM 415
#define EXECUTE_SYM 416
#define EXISTS 417
#define EXIT_SYM 418
#define EXPANSION_SYM 419
#define EXTENDED_SYM 420
#define EXTENT_SIZE_SYM 421
#define EXTRACT_SYM 422
#define FALSE_SYM 423
#define FAST_SYM 424
#define FAULTS_SYM 425
#define FETCH_SYM 426
#define FILE_SYM 427
#define FIRST_SYM 428
#define FIXED_SYM 429
#define FLOAT_NUM 430
#define FLOAT_SYM 431
#define FLUSH_SYM 432
#define FORCE_SYM 433
#define FOREIGN 434
#define FOR_SYM 435
#define FOUND_SYM 436
#define FROM 437
#define FULL 438
#define FULLTEXT_SYM 439
#define FUNCTION_SYM 440
#define GE 441
#define GENERAL 442
#define GEOMETRYCOLLECTION 443
#define GEOMETRY_SYM 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GROUP_SYM 449
#define GROUP_CONCAT_SYM 450
#define GT_SYM 451
#define HANDLER_SYM 452
#define HASH_SYM 453
#define HAVING 454
#define HELP_SYM 455
#define HEX_NUM 456
#define HIGH_PRIORITY 457
#define HOST_SYM 458
#define HOSTS_SYM 459
#define HOUR_MICROSECOND_SYM 460
#define HOUR_MINUTE_SYM 461
#define HOUR_SECOND_SYM 462
#define HOUR_SYM 463
#define IDENT 464
#define IDENTIFIED_SYM 465
#define IDENT_QUOTED 466
#define IF 467
#define IGNORE_SYM 468
#define IGNORE_SERVER_IDS_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INITIAL_SIZE_SYM 474
#define INNER_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INSTALL_SYM 480
#define INTERVAL_SYM 481
#define INTO 482
#define INT_SYM 483
#define INVOKER_SYM 484
#define IN_SYM 485
#define IO_SYM 486
#define IPC_SYM 487
#define IS 488
#define ISOLATION 489
#define ISSUER_SYM 490
#define ITERATE_SYM 491
#define JOIN_SYM 492
#define KEYS 493
#define KEY_BLOCK_SIZE 494
#define KEY_SYM 495
#define KILL_SYM 496
#define LANGUAGE_SYM 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAVES 501
#define LEAVE_SYM 502
#define LEFT 503
#define LESS_SYM 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEAR_SYM 509
#define LINES 510
#define LINESTRING 511
#define LIST_SYM 512
#define LOAD 513
#define LOCAL_SYM 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGFILE_SYM 518
#define LOGS_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MASTER_CONNECT_RETRY_SYM 527
#define MASTER_HOST_SYM 528
#define MASTER_LOG_FILE_SYM 529
#define MASTER_LOG_POS_SYM 530
#define MASTER_PASSWORD_SYM 531
#define MASTER_PORT_SYM 532
#define MASTER_SERVER_ID_SYM 533
#define MASTER_SSL_CAPATH_SYM 534
#define MASTER_SSL_CA_SYM 535
#define MASTER_SSL_CERT_SYM 536
#define MASTER_SSL_CIPHER_SYM 537
#define MASTER_SSL_KEY_SYM 538
#define MASTER_SSL_SYM 539
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 540
#define MASTER_SYM 541
#define MASTER_USER_SYM 542
#define MASTER_HEARTBEAT_PERIOD_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SIZE_SYM 548
#define MAX_SYM 549
#define MAX_UPDATES_PER_HOUR 550
#define MAX_USER_CONNECTIONS_SYM 551
#define MAX_VALUE_SYM 552
#define MEDIUMBLOB 553
#define MEDIUMINT 554
#define MEDIUMTEXT 555
#define MEDIUM_SYM 556
#define MEMORY_SYM 557
#define MERGE_SYM 558
#define MESSAGE_TEXT_SYM 559
#define MICROSECOND_SYM 560
#define MIGRATE_SYM 561
#define MINUTE_MICROSECOND_SYM 562
#define MINUTE_SECOND_SYM 563
#define MINUTE_SYM 564
#define MIN_ROWS 565
#define MIN_SYM 566
#define MODE_SYM 567
#define MODIFIES_SYM 568
#define MODIFY_SYM 569
#define MOD_SYM 570
#define MONTH_SYM 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define MYSQL_ERRNO_SYM 576
#define NAMES_SYM 577
#define NAME_SYM 578
#define NATIONAL_SYM 579
#define NATURAL 580
#define NCHAR_STRING 581
#define NCHAR_SYM 582
#define NDBCLUSTER_SYM 583
#define NE 584
#define NEG 585
#define NEW_SYM 586
#define NEXT_SYM 587
#define NODEGROUP_SYM 588
#define NONE_SYM 589
#define NOT2_SYM 590
#define NOT_SYM 591
#define NOW_SYM 592
#define NO_SYM 593
#define NO_WAIT_SYM 594
#define NO_WRITE_TO_BINLOG 595
#define NULL_SYM 596
#define NUM 597
#define NUMERIC_SYM 598
#define NVARCHAR_SYM 599
#define OFFSET_SYM 600
#define OLD_PASSWORD 601
#define ON 602
#define ONE_SHOT_SYM 603
#define ONE_SYM 604
#define OPEN_SYM 605
#define OPTIMIZE 606
#define OPTIONS_SYM 607
#define OPTION 608
#define OPTIONALLY 609
#define OR2_SYM 610
#define ORDER_SYM 611
#define OR_OR_SYM 612
#define OR_SYM 613
#define OUTER 614
#define OUTFILE 615
#define OUT_SYM 616
#define OWNER_SYM 617
#define PACK_KEYS_SYM 618
#define PAGE_SYM 619
#define PARAM_MARKER 620
#define PARSER_SYM 621
#define PARTIAL 622
#define PARTITIONING_SYM 623
#define PARTITIONS_SYM 624
#define PARTITION_SYM 625
#define PASSWORD 626
#define PHASE_SYM 627
#define PLUGINS_SYM 628
#define PLUGIN_SYM 629
#define POINT_SYM 630
#define POLYGON 631
#define PORT_SYM 632
#define POSITION_SYM 633
#define PRECISION 634
#define PREPARE_SYM 635
#define PRESERVE_SYM 636
#define PREV_SYM 637
#define PRIMARY_SYM 638
#define PRIVILEGES 639
#define PROCEDURE_SYM 640
#define PROCESS 641
#define PROCESSLIST_SYM 642
#define PROFILE_SYM 643
#define PROFILES_SYM 644
#define PROXY_SYM 645
#define PURGE 646
#define QUARTER_SYM 647
#define QUERY_SYM 648
#define QUICK 649
#define RANGE_SYM 650
#define READS_SYM 651
#define READ_ONLY_SYM 652
#define READ_SYM 653
#define READ_WRITE_SYM 654
#define REAL 655
#define REBUILD_SYM 656
#define RECOVER_SYM 657
#define REDOFILE_SYM 658
#define REDO_BUFFER_SIZE_SYM 659
#define REDUNDANT_SYM 660
#define REFERENCES 661
#define REGEXP 662
#define RELAY 663
#define RELAYLOG_SYM 664
#define RELAY_LOG_FILE_SYM 665
#define RELAY_LOG_POS_SYM 666
#define RELAY_THREAD 667
#define RELEASE_SYM 668
#define RELOAD 669
#define REMOVE_SYM 670
#define RENAME 671
#define REORGANIZE_SYM 672
#define REPAIR 673
#define REPEATABLE_SYM 674
#define REPEAT_SYM 675
#define REPLACE 676
#define REPLICATION 677
#define REQUIRE_SYM 678
#define RESET_SYM 679
#define RESIGNAL_SYM 680
#define RESOURCES 681
#define RESTORE_SYM 682
#define RESTRICT 683
#define RESUME_SYM 684
#define RETURNS_SYM 685
#define RETURN_SYM 686
#define REVOKE 687
#define RIGHT 688
#define ROLLBACK_SYM 689
#define ROLLUP_SYM 690
#define ROUTINE_SYM 691
#define ROWS_SYM 692
#define ROW_FORMAT_SYM 693
#define ROW_SYM 694
#define RTREE_SYM 695
#define SAVEPOINT_SYM 696
#define SCHEDULE_SYM 697
#define SCHEMA_NAME_SYM 698
#define SECOND_MICROSECOND_SYM 699
#define SECOND_SYM 700
#define SECURITY_SYM 701
#define SELECT_SYM 702
#define SENSITIVE_SYM 703
#define SEPARATOR_SYM 704
#define SERIALIZABLE_SYM 705
#define SERIAL_SYM 706
#define SESSION_SYM 707
#define SERVER_SYM 708
#define SERVER_OPTIONS 709
#define SET 710
#define SET_VAR 711
#define SHARE_SYM 712
#define SHIFT_LEFT 713
#define SHIFT_RIGHT 714
#define SHOW 715
#define SHUTDOWN 716
#define SIGNAL_SYM 717
#define SIGNED_SYM 718
#define SIMPLE_SYM 719
#define SLAVE 720
#define SLOW 721
#define SMALLINT 722
#define SNAPSHOT_SYM 723
#define SOCKET_SYM 724
#define SONAME_SYM 725
#define SOUNDS_SYM 726
#define SOURCE_SYM 727
#define SPATIAL_SYM 728
#define SPECIFIC_SYM 729
#define SQLEXCEPTION_SYM 730
#define SQLSTATE_SYM 731
#define SQLWARNING_SYM 732
#define SQL_BIG_RESULT 733
#define SQL_BUFFER_RESULT 734
#define SQL_CACHE_SYM 735
#define SQL_CALC_FOUND_ROWS 736
#define SQL_NO_CACHE_SYM 737
#define SQL_SMALL_RESULT 738
#define SQL_SYM 739
#define SQL_THREAD 740
#define SSL_SYM 741
#define STARTING 742
#define STARTS_SYM 743
#define START_SYM 744
#define STATUS_SYM 745
#define STDDEV_SAMP_SYM 746
#define STD_SYM 747
#define STOP_SYM 748
#define STORAGE_SYM 749
#define STRAIGHT_JOIN 750
#define STRING_SYM 751
#define SUBCLASS_ORIGIN_SYM 752
#define SUBDATE_SYM 753
#define SUBJECT_SYM 754
#define SUBPARTITIONS_SYM 755
#define SUBPARTITION_SYM 756
#define SUBSTRING 757
#define SUM_SYM 758
#define SUPER_SYM 759
#define SUSPEND_SYM 760
#define SWAPS_SYM 761
#define SWITCHES_SYM 762
#define SYSDATE 763
#define TABLES 764
#define TABLESPACE 765
#define TABLE_REF_PRIORITY 766
#define TABLE_SYM 767
#define TABLE_CHECKSUM_SYM 768
#define TABLE_NAME_SYM 769
#define TEMPORARY 770
#define TEMPTABLE_SYM 771
#define TERMINATED 772
#define TEXT_STRING 773
#define TEXT_SYM 774
#define THAN_SYM 775
#define THEN_SYM 776
#define TIMESTAMP 777
#define TIMESTAMP_ADD 778
#define TIMESTAMP_DIFF 779
#define TIME_SYM 780
#define TINYBLOB 781
#define TINYINT 782
#define TINYTEXT 783
#define TO_SYM 784
#define TRAILING 785
#define TRANSACTION_SYM 786
#define TRIGGERS_SYM 787
#define TRIGGER_SYM 788
#define TRIM 789
#define TRUE_SYM 790
#define TRUNCATE_SYM 791
#define TYPES_SYM 792
#define TYPE_SYM 793
#define UDF_RETURNS_SYM 794
#define ULONGLONG_NUM 795
#define UNCOMMITTED_SYM 796
#define UNDEFINED_SYM 797
#define UNDERSCORE_CHARSET 798
#define UNDOFILE_SYM 799
#define UNDO_BUFFER_SIZE_SYM 800
#define UNDO_SYM 801
#define UNICODE_SYM 802
#define UNINSTALL_SYM 803
#define UNION_SYM 804
#define UNIQUE_SYM 805
#define UNKNOWN_SYM 806
#define UNLOCK_SYM 807
#define UNSIGNED 808
#define UNTIL_SYM 809
#define UPDATE_SYM 810
#define UPGRADE_SYM 811
#define USAGE 812
#define USER 813
#define USE_FRM 814
#define USE_SYM 815
#define USING 816
#define UTC_DATE_SYM 817
#define UTC_TIMESTAMP_SYM 818
#define UTC_TIME_SYM 819
#define VALUES 820
#define VALUE_SYM 821
#define VARBINARY 822
#define VARCHAR 823
#define VARIABLES 824
#define VARIANCE_SYM 825
#define VARYING 826
#define VAR_SAMP_SYM 827
#define VIEW_SYM 828
#define WAIT_SYM 829
#define WARNINGS 830
#define WEEK_SYM 831
#define WHEN_SYM 832
#define WHERE 833
#define WHILE_SYM 834
#define WITH 835
#define WITH_CUBE_SYM 836
#define WITH_ROLLUP_SYM 837
#define WORK_SYM 838
#define WRAPPER_SYM 839
#define WRITE_SYM 840
#define X509_SYM 841
#define XA_SYM 842
#define XML_SYM 843
#define XOR 844
#define YEAR_MONTH_SYM 845
#define YEAR_SYM 846
#define ZEROFILL 847




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 731 "/export/home/pb2/build/sb_0-15194557-1430741448.18/mysql-5.5.44-release-export-7920655_gpl/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2061 "/export/home/pb2/build/sb_0-15194557-1430741448.18/dist_GPL/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 780 "/export/home/pb2/build/sb_0-15194557-1430741448.18/mysql-5.5.44-release-export-7920655_gpl/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2078 "/export/home/pb2/build/sb_0-15194557-1430741448.18/dist_GPL/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  573
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   50277

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  612
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  888
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2496
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4247

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   847

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   605,     2,     2,     2,   599,   594,     2,
     602,   603,   597,   596,   604,   595,   610,   598,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   611,   608,
       2,     2,     2,     2,   609,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   600,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   606,   593,   607,   601,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   127,   129,   131,   136,   138,   141,   142,   147,
     148,   151,   155,   157,   160,   161,   165,   166,   172,   174,
     178,   182,   186,   190,   194,   198,   202,   206,   210,   214,
     218,   222,   226,   230,   236,   238,   239,   241,   245,   247,
     251,   255,   259,   263,   264,   272,   273,   286,   287,   300,
     301,   314,   315,   322,   323,   327,   332,   337,   341,   344,
     355,   357,   361,   364,   367,   370,   373,   376,   379,   382,
     383,   397,   398,   405,   408,   409,   411,   415,   417,   418,
     421,   422,   425,   426,   428,   432,   437,   438,   441,   442,
     445,   447,   449,   451,   453,   455,   457,   459,   461,   463,
     465,   467,   469,   471,   472,   476,   478,   479,   482,   483,
     486,   489,   492,   495,   498,   502,   506,   508,   510,   512,
     515,   519,   523,   524,   529,   530,   534,   535,   537,   541,
     543,   544,   546,   550,   552,   553,   557,   558,   560,   564,
     566,   571,   572,   574,   576,   578,   579,   583,   586,   590,
     591,   595,   596,   602,   608,   609,   617,   623,   624,   627,
     629,   631,   633,   637,   639,   641,   643,   647,   648,   650,
     652,   654,   656,   659,   661,   665,   667,   669,   670,   672,
     673,   676,   680,   686,   688,   690,   692,   694,   696,   698,
     700,   702,   704,   706,   708,   710,   712,   714,   716,   720,
     722,   726,   727,   730,   732,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   752,   754,   756,   757,   763,   764,
     767,   768,   772,   773,   776,   779,   782,   785,   786,   793,
     796,   797,   800,   802,   804,   808,   809,   810,   811,   819,
     820,   823,   826,   828,   830,   831,   832,   841,   842,   849,
     851,   854,   856,   859,   860,   861,   868,   869,   870,   877,
     878,   881,   882,   888,   889,   891,   892,   898,   899,   902,
     903,   909,   914,   915,   916,   925,   926,   934,   936,   938,
     940,   942,   944,   947,   952,   958,   959,   964,   969,   974,
     978,   982,   985,   988,   989,   992,   994,   997,  1001,  1003,
    1005,  1007,  1009,  1011,  1014,  1018,  1020,  1022,  1024,  1026,
    1028,  1030,  1032,  1034,  1036,  1038,  1041,  1045,  1047,  1049,
    1051,  1053,  1055,  1057,  1059,  1062,  1066,  1068,  1070,  1072,
    1074,  1076,  1078,  1080,  1082,  1084,  1087,  1091,  1093,  1095,
    1097,  1100,  1103,  1106,  1108,  1110,  1112,  1114,  1117,  1121,
    1125,  1129,  1133,  1137,  1141,  1145,  1149,  1154,  1155,  1157,
    1159,  1161,  1163,  1165,  1168,  1172,  1175,  1180,  1186,  1187,
    1193,  1194,  1195,  1201,  1202,  1210,  1212,  1213,  1215,  1216,
    1221,  1222,  1223,  1227,  1233,  1240,  1241,  1246,  1249,  1252,
    1255,  1258,  1259,  1261,  1262,  1266,  1267,  1269,  1271,  1275,
    1277,  1282,  1288,  1294,  1295,  1298,  1299,  1300,  1308,  1309,
    1320,  1322,  1326,  1328,  1330,  1331,  1334,  1335,  1339,  1341,
    1345,  1346,  1353,  1355,  1356,  1357,  1363,  1364,  1369,  1371,
    1373,  1375,  1379,  1381,  1385,  1386,  1387,  1393,  1395,  1399,
    1401,  1403,  1404,  1408,  1410,  1414,  1415,  1420,  1422,  1423,
    1425,  1428,  1430,  1434,  1439,  1443,  1447,  1451,  1456,  1461,
    1465,  1466,  1467,  1474,  1475,  1477,  1478,  1480,  1482,  1485,
    1487,  1489,  1490,  1492,  1494,  1497,  1499,  1500,  1504,  1505,
    1507,  1509,  1512,  1514,  1517,  1521,  1525,  1529,  1533,  1537,
    1541,  1545,  1549,  1553,  1557,  1561,  1565,  1569,  1573,  1574,
    1581,  1583,  1585,  1589,  1594,  1599,  1602,  1605,  1608,  1612,
    1616,  1621,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,
    1642,  1644,  1646,  1648,  1650,  1653,  1655,  1657,  1659,  1661,
    1663,  1665,  1669,  1671,  1673,  1676,  1679,  1687,  1696,  1705,
    1714,  1723,  1726,  1727,  1729,  1734,  1735,  1737,  1740,  1741,
    1746,  1750,  1754,  1758,  1760,  1763,  1765,  1767,  1771,  1774,
    1778,  1781,  1784,  1786,  1790,  1794,  1797,  1801,  1803,  1805,
    1807,  1809,  1811,  1814,  1816,  1818,  1820,  1823,  1827,  1830,
    1834,  1837,  1840,  1844,  1848,  1852,  1853,  1860,  1861,  1868,
    1871,  1873,  1875,  1877,  1879,  1881,  1883,  1885,  1887,  1889,
    1891,  1893,  1896,  1899,  1901,  1904,  1906,  1909,  1913,  1916,
    1918,  1920,  1922,  1924,  1926,  1928,  1930,  1933,  1934,  1936,
    1938,  1944,  1945,  1947,  1950,  1952,  1954,  1956,  1958,  1962,
    1966,  1970,  1974,  1975,  1977,  1978,  1980,  1981,  1983,  1986,
    1988,  1990,  1993,  1996,  2001,  2003,  2007,  2010,  2012,  2015,
    2018,  2021,  2024,  2027,  2029,  2032,  2034,  2036,  2038,  2040,
    2042,  2043,  2046,  2048,  2050,  2052,  2054,  2056,  2057,  2060,
    2062,  2064,  2065,  2067,  2069,  2072,  2075,  2077,  2080,  2083,
    2084,  2086,  2088,  2090,  2094,  2096,  2100,  2101,  2103,  2104,
    2106,  2112,  2113,  2117,  2121,  2123,  2124,  2127,  2130,  2133,
    2134,  2138,  2142,  2149,  2156,  2158,  2160,  2163,  2166,  2169,
    2171,  2174,  2177,  2179,  2181,  2182,  2184,  2186,  2188,  2190,
    2191,  2193,  2195,  2197,  2198,  2200,  2203,  2204,  2206,  2207,
    2209,  2210,  2212,  2214,  2217,  2219,  2222,  2224,  2227,  2230,
    2233,  2237,  2240,  2242,  2244,  2246,  2248,  2252,  2254,  2256,
    2258,  2263,  2266,  2268,  2273,  2274,  2276,  2277,  2280,  2282,
    2286,  2287,  2294,  2295,  2301,  2309,  2310,  2316,  2317,  2323,
    2324,  2330,  2331,  2336,  2337,  2348,  2352,  2357,  2361,  2365,
    2373,  2374,  2378,  2380,  2385,  2386,  2390,  2391,  2394,  2395,
    2397,  2398,  2401,  2404,  2407,  2410,  2412,  2414,  2416,  2420,
    2425,  2426,  2433,  2438,  2439,  2445,  2446,  2453,  2458,  2462,
    2464,  2467,  2469,  2471,  2472,  2478,  2479,  2483,  2486,  2487,
    2493,  2494,  2495,  2502,  2504,  2508,  2510,  2512,  2516,  2519,
    2523,  2526,  2531,  2532,  2539,  2540,  2541,  2550,  2555,  2560,
    2564,  2568,  2571,  2574,  2581,  2587,  2591,  2597,  2599,  2601,
    2603,  2604,  2606,  2607,  2609,  2610,  2612,  2614,  2615,  2618,
    2620,  2621,  2623,  2625,  2627,  2628,  2634,  2638,  2639,  2645,
    2649,  2653,  2654,  2658,  2659,  2662,  2664,  2668,  2669,  2671,
    2673,  2674,  2677,  2679,  2683,  2684,  2690,  2691,  2693,  2695,
    2696,  2703,  2704,  2706,  2708,  2711,  2713,  2715,  2717,  2718,
    2724,  2727,  2728,  2734,  2735,  2737,  2739,  2742,  2744,  2746,
    2748,  2750,  2752,  2755,  2756,  2762,  2763,  2765,  2767,  2768,
    2773,  2778,  2782,  2788,  2790,  2794,  2798,  2799,  2806,  2808,
    2810,  2812,  2816,  2819,  2823,  2825,  2827,  2828,  2835,  2837,
    2839,  2841,  2845,  2849,  2854,  2855,  2862,  2863,  2866,  2867,
    2872,  2873,  2876,  2878,  2881,  2886,  2889,  2893,  2896,  2900,
    2901,  2905,  2906,  2907,  2914,  2917,  2919,  2921,  2924,  2927,
    2936,  2941,  2942,  2944,  2947,  2949,  2951,  2953,  2955,  2956,
    2959,  2964,  2968,  2970,  2972,  2976,  2981,  2982,  2983,  2984,
    2987,  2990,  2992,  2994,  2995,  2998,  3002,  3006,  3010,  3013,
    3017,  3022,  3026,  3031,  3035,  3040,  3042,  3046,  3051,  3055,
    3059,  3066,  3068,  3074,  3081,  3087,  3095,  3102,  3111,  3117,
    3124,  3129,  3134,  3140,  3144,  3149,  3151,  3155,  3159,  3163,
    3167,  3171,  3175,  3181,  3187,  3191,  3195,  3199,  3203,  3207,
    3211,  3213,  3215,  3217,  3219,  3221,  3223,  3225,  3227,  3229,
    3231,  3233,  3235,  3237,  3239,  3241,  3243,  3245,  3247,  3249,
    3251,  3253,  3255,  3259,  3261,  3263,  3265,  3267,  3271,  3274,
    3277,  3280,  3283,  3287,  3291,  3297,  3304,  3309,  3314,  3322,
    3325,  3332,  3338,  3345,  3352,  3357,  3362,  3368,  3373,  3380,
    3383,  3388,  3393,  3398,  3409,  3416,  3425,  3432,  3437,  3442,
    3449,  3454,  3459,  3464,  3471,  3476,  3484,  3492,  3500,  3507,
    3514,  3521,  3528,  3532,  3537,  3544,  3553,  3556,  3559,  3564,
    3573,  3582,  3589,  3596,  3599,  3604,  3611,  3618,  3627,  3636,
    3643,  3652,  3659,  3662,  3667,  3676,  3685,  3688,  3691,  3694,
    3699,  3704,  3709,  3714,  3718,  3727,  3732,  3739,  3744,  3749,
    3754,  3761,  3770,  3777,  3782,  3789,  3791,  3798,  3803,  3808,
    3813,  3818,  3823,  3830,  3835,  3836,  3842,  3849,  3852,  3856,
    3857,  3862,  3863,  3867,  3868,  3870,  3872,  3876,  3881,  3886,
    3892,  3897,  3902,  3907,  3913,  3918,  3919,  3920,  3928,  3933,
    3939,  3944,  3950,  3955,  3960,  3965,  3970,  3975,  3981,  3982,
    3991,  3992,  3996,  4000,  4002,  4007,  4008,  4010,  4011,  4014,
    4015,  4016,  4021,  4026,  4029,  4030,  4034,  4037,  4041,  4044,
    4046,  4049,  4051,  4054,  4056,  4058,  4060,  4063,  4064,  4066,
    4068,  4072,  4074,  4078,  4080,  4084,  4085,  4087,  4088,  4091,
    4096,  4102,  4104,  4106,  4108,  4110,  4115,  4117,  4121,  4125,
    4129,  4130,  4137,  4138,  4145,  4146,  4155,  4160,  4161,  4170,
    4171,  4182,  4189,  4190,  4199,  4200,  4211,  4218,  4220,  4223,
    4226,  4227,  4232,  4236,  4242,  4245,  4246,  4247,  4255,  4257,
    4258,  4259,  4266,  4267,  4271,  4272,  4273,  4279,  4280,  4282,
    4283,  4285,  4286,  4289,  4293,  4297,  4299,  4301,  4302,  4310,
    4311,  4319,  4321,  4324,  4325,  4326,  4329,  4330,  4333,  4334,
    4336,  4338,  4340,  4342,  4346,  4348,  4352,  4354,  4356,  4358,
    4360,  4362,  4364,  4366,  4368,  4370,  4372,  4374,  4376,  4378,
    4380,  4382,  4384,  4386,  4388,  4390,  4392,  4394,  4396,  4398,
    4400,  4402,  4403,  4405,  4407,  4408,  4411,  4412,  4414,  4415,
    4416,  4420,  4421,  4422,  4426,  4429,  4430,  4431,  4436,  4441,
    4444,  4445,  4447,  4449,  4453,  4457,  4459,  4462,  4463,  4465,
    4466,  4471,  4476,  4479,  4480,  4482,  4484,  4485,  4487,  4488,
    4490,  4493,  4495,  4499,  4503,  4505,  4507,  4509,  4511,  4513,
    4514,  4517,  4519,  4521,  4523,  4525,  4527,  4529,  4531,  4533,
    4535,  4537,  4539,  4541,  4543,  4545,  4547,  4549,  4551,  4553,
    4555,  4557,  4559,  4561,  4563,  4564,  4565,  4572,  4573,  4575,
    4579,  4581,  4585,  4586,  4589,  4593,  4595,  4598,  4600,  4601,
    4605,  4606,  4607,  4615,  4618,  4620,  4621,  4625,  4626,  4634,
    4635,  4642,  4647,  4654,  4659,  4664,  4669,  4670,  4677,  4682,
    4687,  4693,  4700,  4705,  4707,  4711,  4713,  4715,  4719,  4721,
    4722,  4725,  4726,  4728,  4729,  4730,  4739,  4740,  4741,  4748,
    4749,  4751,  4753,  4755,  4757,  4759,  4762,  4764,  4766,  4768,
    4772,  4777,  4778,  4782,  4786,  4788,  4791,  4794,  4795,  4799,
    4800,  4806,  4810,  4812,  4816,  4818,  4822,  4824,  4826,  4827,
    4829,  4830,  4835,  4836,  4838,  4842,  4844,  4846,  4848,  4849,
    4850,  4857,  4858,  4859,  4871,  4875,  4877,  4881,  4885,  4887,
    4891,  4892,  4894,  4895,  4900,  4901,  4908,  4909,  4915,  4916,
    4923,  4925,  4929,  4932,  4937,  4938,  4941,  4942,  4945,  4947,
    4949,  4951,  4952,  4957,  4958,  4960,  4961,  4963,  4965,  4969,
    4971,  4973,  4976,  4979,  4982,  4984,  4986,  4988,  4990,  4991,
    4995,  4996,  5000,  5003,  5008,  5013,  5017,  5022,  5027,  5029,
    5033,  5037,  5044,  5047,  5050,  5051,  5058,  5059,  5066,  5072,
    5075,  5077,  5079,  5081,  5087,  5093,  5096,  5099,  5101,  5106,
    5110,  5113,  5117,  5120,  5123,  5125,  5129,  5134,  5138,  5142,
    5145,  5148,  5152,  5156,  5160,  5164,  5168,  5172,  5176,  5180,
    5182,  5184,  5186,  5188,  5190,  5191,  5193,  5194,  5197,  5198,
    5200,  5202,  5204,  5205,  5208,  5209,  5212,  5213,  5216,  5219,
    5220,  5225,  5226,  5231,  5233,  5235,  5236,  5238,  5240,  5241,
    5243,  5245,  5246,  5251,  5252,  5253,  5259,  5261,  5262,  5266,
    5270,  5272,  5275,  5278,  5281,  5284,  5287,  5290,  5293,  5295,
    5297,  5299,  5301,  5303,  5305,  5307,  5309,  5310,  5312,  5313,
    5317,  5321,  5323,  5324,  5328,  5330,  5333,  5334,  5336,  5337,
    5341,  5345,  5348,  5351,  5355,  5356,  5358,  5360,  5363,  5364,
    5365,  5366,  5367,  5389,  5391,  5393,  5394,  5396,  5397,  5399,
    5401,  5402,  5404,  5406,  5407,  5410,  5413,  5415,  5419,  5424,
    5428,  5432,  5433,  5436,  5439,  5441,  5445,  5449,  5450,  5455,
    5456,  5460,  5462,  5464,  5465,  5469,  5472,  5476,  5478,  5480,
    5483,  5484,  5487,  5491,  5493,  5499,  5501,  5503,  5506,  5509,
    5511,  5513,  5515,  5517,  5519,  5522,  5525,  5527,  5529,  5531,
    5533,  5535,  5537,  5539,  5542,  5545,  5548,  5551,  5554,  5556,
    5558,  5560,  5562,  5564,  5566,  5568,  5572,  5578,  5580,  5582,
    5584,  5586,  5588,  5592,  5597,  5603,  5605,  5611,  5615,  5618,
    5620,  5624,  5627,  5630,  5635,  5637,  5639,  5641,  5643,  5645,
    5647,  5649,  5651,  5653,  5655,  5657,  5659,  5661,  5663,  5667,
    5670,  5672,  5674,  5676,  5678,  5680,  5682,  5684,  5686,  5688,
    5690,  5692,  5694,  5696,  5698,  5700,  5702,  5704,  5706,  5708,
    5710,  5712,  5714,  5716,  5718,  5720,  5722,  5724,  5726,  5728,
    5730,  5732,  5734,  5736,  5738,  5740,  5742,  5744,  5746,  5748,
    5750,  5752,  5754,  5756,  5758,  5760,  5762,  5764,  5766,  5768,
    5770,  5772,  5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,
    5790,  5792,  5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,
    5810,  5812,  5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,
    5830,  5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,
    5850,  5852,  5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,
    5870,  5872,  5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,
    5890,  5892,  5894,  5896,  5898,  5900,  5902,  5904,  5906,  5908,
    5910,  5912,  5914,  5916,  5918,  5920,  5922,  5924,  5926,  5928,
    5930,  5932,  5934,  5936,  5938,  5940,  5942,  5944,  5946,  5948,
    5950,  5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,  5968,
    5970,  5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,  5988,
    5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,
    6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,
    6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,
    6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,
    6070,  6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,
    6090,  6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,  6108,
    6110,  6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,  6128,
    6130,  6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,  6148,
    6150,  6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,  6168,
    6170,  6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,  6188,
    6190,  6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,  6208,
    6210,  6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,  6228,
    6230,  6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,  6248,
    6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,  6268,
    6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,  6288,
    6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,  6308,
    6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,  6327,
    6332,  6333,  6335,  6337,  6341,  6342,  6345,  6347,  6349,  6351,
    6353,  6354,  6356,  6357,  6359,  6361,  6363,  6364,  6367,  6370,
    6373,  6375,  6378,  6383,  6389,  6394,  6401,  6404,  6408,  6412,
    6416,  6422,  6424,  6428,  6432,  6435,  6438,  6441,  6443,  6445,
    6450,  6455,  6457,  6459,  6461,  6463,  6465,  6466,  6471,  6473,
    6475,  6477,  6481,  6485,  6487,  6489,  6492,  6495,  6496,  6500,
    6505,  6509,  6510,  6518,  6520,  6523,  6525,  6527,  6529,  6531,
    6533,  6535,  6536,  6542,  6544,  6546,  6548,  6550,  6552,  6556,
    6563,  6570,  6577,  6585,  6591,  6595,  6604,  6613,  6622,  6629,
    6630,  6632,  6634,  6637,  6638,  6640,  6642,  6646,  6647,  6651,
    6652,  6656,  6657,  6661,  6662,  6666,  6668,  6670,  6672,  6674,
    6676,  6678,  6680,  6682,  6684,  6686,  6688,  6691,  6694,  6696,
    6700,  6703,  6706,  6709,  6712,  6715,  6718,  6721,  6724,  6726,
    6728,  6731,  6732,  6734,  6738,  6740,  6743,  6746,  6749,  6751,
    6755,  6759,  6761,  6763,  6767,  6769,  6773,  6778,  6784,  6789,
    6796,  6798,  6799,  6803,  6807,  6809,  6811,  6812,  6815,  6818,
    6821,  6824,  6825,  6828,  6829,  6833,  6836,  6838,  6841,  6844,
    6847,  6850,  6853,  6854,  6858,  6859,  6861,  6862,  6866,  6869,
    6870,  6872,  6875,  6876,  6878,  6883,  6888,  6894,  6897,  6901,
    6902,  6904,  6905,  6910,  6911,  6913,  6915,  6916,  6918,  6919,
    6922,  6925,  6927,  6928,  6930,  6932,  6935,  6939,  6942,  6943,
    6950,  6954,  6955,  6956,  6957,  6959,  6962,  6964,  6966,  6968,
    6970,  6972,  6974,  6976,  6978,  6980,  6983,  6986,  6990,  6992,
    6994,  6996,  6998,  7000,  7002,  7004,  7006,  7008,  7010,  7012,
    7014,  7016,  7017,  7021,  7023,  7026,  7028,  7031,  7035,  7039,
    7043,  7044,  7048,  7052,  7053,  7061,  7062,  7066,  7068,  7072,
    7073,  7077,  7080,  7085,  7086,  7090,  7095,  7100,  7101,  7102,
    7103,  7120,  7129,  7137,  7138,  7139,  7140,  7141,  7142,  7158,
    7159,  7160,  7161,  7162,  7175,  7180,  7185,  7189,  7194,  7198,
    7201,  7203,  7207,  7213,  7215,  7217,  7218,  7220,  7222,  7223,
    7226,  7227,  7228,  7232,  7233,  7236,  7242
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     613,     0,    -1,   148,    -1,    -1,   616,   614,   608,   615,
      -1,   616,   148,    -1,    -1,   148,    -1,   617,    -1,  1428,
      -1,   960,    -1,  1017,    -1,  1019,    -1,   666,    -1,   629,
      -1,  1020,    -1,  1009,    -1,  1434,    -1,   636,    -1,   618,
      -1,  1258,    -1,  1290,    -1,  1210,    -1,  1212,    -1,   622,
      -1,  1296,    -1,  1402,    -1,  1393,    -1,   627,    -1,  1222,
      -1,  1498,    -1,  1315,    -1,  1318,    -1,  1385,    -1,  1025,
      -1,  1033,    -1,   809,    -1,  1040,    -1,   620,    -1,  1311,
      -1,  1437,    -1,  1028,    -1,  1012,    -1,  1225,    -1,  1305,
      -1,   701,    -1,  1400,    -1,  1435,    -1,  1436,    -1,  1052,
      -1,  1368,    -1,   694,    -1,  1276,    -1,   998,    -1,  1001,
      -1,  1269,    -1,  1499,    -1,  1391,    -1,  1250,    -1,  1317,
      -1,  1490,    -1,   619,   380,  1362,    -1,   115,    -1,   136,
      -1,   380,  1362,   182,   621,    -1,  1359,    -1,   609,  1364,
      -1,    -1,   161,  1362,   623,   624,    -1,    -1,   561,   625,
      -1,   625,   604,   626,    -1,   626,    -1,   609,  1364,    -1,
      -1,   200,   628,  1364,    -1,    -1,    56,   286,   529,   630,
     631,    -1,   632,    -1,   631,   604,   632,    -1,   273,   152,
    1359,    -1,   287,   152,  1359,    -1,   276,   152,  1359,    -1,
     277,   152,  1190,    -1,   272,   152,  1190,    -1,   284,   152,
    1190,    -1,   280,   152,  1359,    -1,   279,   152,  1359,    -1,
     281,   152,  1359,    -1,   282,   152,  1359,    -1,   283,   152,
    1359,    -1,   285,   152,  1190,    -1,   288,   152,  1347,    -1,
     214,   152,   602,   633,   603,    -1,   635,    -1,    -1,   634,
      -1,   633,   604,   634,    -1,  1190,    -1,   274,   152,  1359,
      -1,   275,   152,  1192,    -1,   410,   152,  1359,    -1,   411,
     152,  1190,    -1,    -1,    94,   861,   512,   864,  1355,   637,
     798,    -1,    -1,    94,   938,   217,  1362,   942,   347,  1355,
     638,   602,   955,   603,   943,    -1,    -1,    94,   939,   217,
    1362,   941,   347,  1355,   639,   602,   955,   603,   944,    -1,
      -1,    94,   940,   217,  1362,   941,   347,  1355,   640,   602,
     955,   603,   945,    -1,    -1,    94,   102,   864,  1362,   641,
     858,    -1,    -1,    94,   642,  1456,    -1,    94,   558,   659,
    1418,    -1,    94,   263,   194,   761,    -1,    94,   510,   758,
      -1,    94,   643,    -1,   453,  1364,   179,   105,   584,  1364,
     352,   602,   644,   603,    -1,   645,    -1,   644,   604,   645,
      -1,   558,  1359,    -1,   203,  1359,    -1,   102,  1359,    -1,
     362,  1359,    -1,   371,  1359,    -1,   469,  1359,    -1,   377,
    1190,    -1,    -1,  1069,   159,   864,   660,   647,   347,   442,
     648,   653,   650,   655,   135,   656,    -1,    -1,   160,  1073,
    1162,   649,   651,   652,    -1,    22,  1073,    -1,    -1,   144,
      -1,   129,   347,   465,    -1,   129,    -1,    -1,   488,  1073,
      -1,    -1,   147,  1073,    -1,    -1,   654,    -1,   347,    77,
     381,    -1,   347,    77,   336,   381,    -1,    -1,    73,  1359,
      -1,    -1,   657,   658,    -1,   707,    -1,   709,    -1,   705,
      -1,   726,    -1,   744,    -1,   746,    -1,   741,    -1,   711,
      -1,   713,    -1,   714,    -1,   715,    -1,   716,    -1,   718,
      -1,    -1,  1362,   610,  1362,    -1,  1362,    -1,    -1,   661,
     663,    -1,    -1,   662,   664,    -1,    73,  1359,    -1,   242,
     484,    -1,   338,   484,    -1,    87,   484,    -1,   396,   484,
     105,    -1,   313,   484,   105,    -1,   665,    -1,   663,    -1,
     127,    -1,  1079,   127,    -1,   484,   446,   120,    -1,   484,
     446,   229,    -1,    -1,    49,   660,   667,   668,    -1,    -1,
     602,   669,   603,    -1,    -1,   670,    -1,   670,   604,  1073,
      -1,  1073,    -1,    -1,   672,    -1,   672,   604,   674,    -1,
     674,    -1,    -1,  1362,   673,   910,    -1,    -1,   676,    -1,
     676,   604,   677,    -1,   677,    -1,   678,   673,  1362,   910,
      -1,    -1,   230,    -1,   361,    -1,   221,    -1,    -1,   679,
     704,   608,    -1,   704,   608,    -1,   680,   704,   608,    -1,
      -1,   681,   682,   608,    -1,    -1,   118,   702,   683,   910,
     703,    -1,   118,  1362,    80,   180,   690,    -1,    -1,   118,
     687,   197,   180,   684,   688,   704,    -1,   118,  1362,    99,
     180,   685,    -1,    -1,   686,  1052,    -1,   163,    -1,    89,
      -1,   689,    -1,   688,   604,   689,    -1,   693,    -1,  1190,
      -1,   691,    -1,   476,   692,  1360,    -1,    -1,   566,    -1,
     690,    -1,  1362,    -1,   477,    -1,  1079,   181,    -1,   475,
      -1,   462,   695,   697,    -1,  1362,    -1,   691,    -1,    -1,
     695,    -1,    -1,   455,   698,    -1,   700,   152,   699,    -1,
     698,   604,   700,   152,   699,    -1,  1346,    -1,  1100,    -1,
    1351,    -1,    63,    -1,   497,    -1,    84,    -1,    86,    -1,
      85,    -1,    54,    -1,   443,    -1,   514,    -1,    72,    -1,
     100,    -1,   304,    -1,   321,    -1,   425,   696,   697,    -1,
    1362,    -1,   702,   604,  1362,    -1,    -1,   119,  1073,    -1,
     707,    -1,   709,    -1,   705,    -1,   726,    -1,   744,    -1,
     746,    -1,   741,    -1,   711,    -1,   713,    -1,   714,    -1,
     715,    -1,   716,    -1,   718,    -1,    -1,   212,   706,   721,
     146,   212,    -1,    -1,   708,   617,    -1,    -1,   431,   710,
    1073,    -1,    -1,   712,   750,    -1,   247,  1363,    -1,   236,
    1363,    -1,   350,  1362,    -1,    -1,   171,   719,  1362,   227,
     717,   720,    -1,    65,  1362,    -1,    -1,   332,   182,    -1,
     182,    -1,  1362,    -1,   720,   604,  1362,    -1,    -1,    -1,
      -1,   722,  1073,   521,   723,   680,   724,   725,    -1,    -1,
     143,   721,    -1,   142,   680,    -1,   727,    -1,   730,    -1,
      -1,    -1,    52,   728,  1073,   729,   732,   740,   146,    52,
      -1,    -1,    52,   731,   733,   740,   146,    52,    -1,   734,
      -1,   732,   734,    -1,   737,    -1,   733,   737,    -1,    -1,
      -1,   577,   735,  1073,   736,   521,   680,    -1,    -1,    -1,
     577,   738,  1073,   739,   521,   680,    -1,    -1,   142,   680,
      -1,    -1,  1363,   611,   742,   750,   743,    -1,    -1,  1363,
      -1,    -1,  1363,   611,   745,   748,   743,    -1,    -1,   747,
     748,    -1,    -1,    30,   749,   681,   679,   146,    -1,   269,
     680,   146,   269,    -1,    -1,    -1,   579,   751,  1073,   135,
     752,   680,   146,   579,    -1,    -1,   420,   680,   554,   753,
    1073,   146,   420,    -1,    29,    -1,     8,    -1,   223,    -1,
     555,    -1,   123,    -1,   783,   785,    -1,   783,    56,   780,
     764,    -1,   783,     6,   780,   759,   768,    -1,    -1,   560,
     263,   194,  1362,    -1,   783,     6,   780,   771,    -1,   783,
     136,   780,   771,    -1,   784,   763,   774,    -1,   784,   763,
     777,    -1,     6,   781,    -1,     6,   782,    -1,    -1,   765,
     766,    -1,   767,    -1,   766,   767,    -1,   766,   604,   767,
      -1,   786,    -1,   787,    -1,   788,    -1,   769,    -1,   770,
      -1,   769,   770,    -1,   769,   604,   770,    -1,   786,    -1,
     787,    -1,   788,    -1,   789,    -1,   792,    -1,   794,    -1,
     796,    -1,   793,    -1,   772,    -1,   773,    -1,   772,   773,
      -1,   772,   604,   773,    -1,   786,    -1,   787,    -1,   788,
      -1,   794,    -1,   796,    -1,   775,    -1,   776,    -1,   775,
     776,    -1,   775,   604,   776,    -1,   786,    -1,   790,    -1,
     791,    -1,   792,    -1,   794,    -1,   796,    -1,   793,    -1,
     778,    -1,   779,    -1,   778,   779,    -1,   778,   604,   779,
      -1,   786,    -1,   794,    -1,   796,    -1,   104,  1359,    -1,
     544,  1359,    -1,   403,  1359,    -1,  1362,    -1,  1362,    -1,
     397,    -1,   399,    -1,   336,     4,    -1,   219,  1242,   797,
      -1,    24,  1242,   797,    -1,   293,  1242,   797,    -1,   166,
    1242,   797,    -1,   545,  1242,   797,    -1,   404,  1242,   797,
      -1,   333,  1242,  1191,    -1,    73,  1242,  1359,    -1,  1283,
     150,  1242,   872,    -1,    -1,   796,    -1,   574,    -1,   339,
      -1,  1193,    -1,  1358,    -1,   602,   799,    -1,   865,   804,
     801,    -1,   252,  1355,    -1,   602,   252,  1355,   603,    -1,
     878,   603,   865,   804,   801,    -1,    -1,   804,   854,   603,
     800,  1441,    -1,    -1,    -1,  1326,   857,   854,   802,  1438,
      -1,    -1,  1326,   857,   602,   854,   603,   803,  1441,    -1,
     805,    -1,    -1,   806,    -1,    -1,   370,   808,   807,   811,
      -1,    -1,    -1,   370,   810,   811,    -1,    46,   812,   822,
     823,   830,    -1,   814,   240,   815,   602,   816,   603,    -1,
      -1,   814,   198,   813,   820,    -1,   395,   820,    -1,   395,
     819,    -1,   257,   820,    -1,   257,   819,    -1,    -1,   254,
      -1,    -1,    11,   152,  1191,    -1,    -1,   817,    -1,   818,
      -1,   817,   604,   818,    -1,  1362,    -1,    70,   602,   816,
     603,    -1,   602,  1069,   828,  1070,   603,    -1,   602,  1069,
     828,  1070,   603,    -1,    -1,   369,  1191,    -1,    -1,    -1,
     501,    46,   814,   198,   821,   824,   829,    -1,    -1,   501,
      46,   814,   240,   815,   602,   826,   603,   825,   829,    -1,
     827,    -1,   826,   604,   827,    -1,  1362,    -1,  1076,    -1,
      -1,   500,  1191,    -1,    -1,   602,   831,   603,    -1,   832,
      -1,   831,   604,   832,    -1,    -1,   370,   833,   834,   835,
     851,   846,    -1,  1362,    -1,    -1,    -1,   565,   249,   520,
     836,   838,    -1,    -1,   565,   230,   837,   839,    -1,   297,
      -1,   841,    -1,   841,    -1,   602,   840,   603,    -1,   841,
      -1,   840,   604,   841,    -1,    -1,    -1,   602,   842,   844,
     843,   603,    -1,   845,    -1,   844,   604,   845,    -1,   297,
      -1,  1076,    -1,    -1,   602,   847,   603,    -1,   848,    -1,
     847,   604,   848,    -1,    -1,   501,   849,   850,   851,    -1,
    1364,    -1,    -1,   852,    -1,   852,   853,    -1,   853,    -1,
     510,  1242,  1364,    -1,  1283,   150,  1242,   872,    -1,   333,
    1242,  1191,    -1,   292,  1242,  1193,    -1,   310,  1242,  1193,
      -1,   105,   128,  1242,  1359,    -1,   217,   128,  1242,  1359,
      -1,    73,  1242,  1359,    -1,    -1,    -1,   447,   855,  1063,
    1067,   856,   876,    -1,    -1,    18,    -1,    -1,   859,    -1,
     860,    -1,   859,   860,    -1,   871,    -1,   870,    -1,    -1,
     862,    -1,   863,    -1,   863,   862,    -1,   515,    -1,    -1,
     212,  1079,   162,    -1,    -1,   867,    -1,   868,    -1,   868,
     866,    -1,   868,    -1,   868,   867,    -1,   868,   604,   867,
      -1,   150,  1242,   872,    -1,   292,  1242,  1192,    -1,   310,
    1242,  1192,    -1,    26,  1242,  1190,    -1,   371,  1242,  1359,
      -1,    73,  1242,  1359,    -1,    25,  1242,  1192,    -1,   363,
    1242,  1190,    -1,   363,  1242,   119,    -1,    60,  1242,  1190,
      -1,   513,  1242,  1190,    -1,   122,  1242,  1190,    -1,   438,
    1242,   874,    -1,    -1,   549,  1242,   869,   602,  1304,   603,
      -1,   870,    -1,   871,    -1,   224,  1242,   875,    -1,   105,
     128,  1242,  1359,    -1,   217,   128,  1242,  1359,    -1,   510,
    1362,    -1,   494,   131,    -1,   494,   302,    -1,    81,  1242,
    1359,    -1,   239,  1242,  1190,    -1,   921,   912,  1242,   914,
      -1,   921,    68,  1242,   920,    -1,  1364,    -1,  1364,    -1,
     119,    -1,   174,    -1,   140,    -1,    78,    -1,   405,    -1,
      76,    -1,   338,    -1,   173,    -1,   243,    -1,  1185,    -1,
    1062,  1066,    -1,   496,    -1,   400,    -1,   117,    -1,   228,
      -1,   879,    -1,   880,    -1,   879,   604,   880,    -1,   881,
      -1,   882,    -1,   887,   883,    -1,   887,   927,    -1,   933,
     957,   942,   602,   955,   603,   943,    -1,   939,   936,   957,
     941,   602,   955,   603,   944,    -1,   940,   936,   957,   941,
     602,   955,   603,   945,    -1,   885,   934,   957,   942,   602,
     955,   603,   943,    -1,   885,   179,   240,   957,   602,   955,
     603,   927,    -1,   885,   884,    -1,    -1,   884,    -1,    61,
     602,  1073,   603,    -1,    -1,   886,    -1,    83,   957,    -1,
      -1,  1354,   888,   889,   907,    -1,   897,   905,   901,    -1,
     898,   906,   901,    -1,   176,   899,   901,    -1,    38,    -1,
      38,   904,    -1,    43,    -1,    42,    -1,   893,   904,   924,
      -1,   893,   924,    -1,   894,   904,   925,    -1,   894,   925,
      -1,    33,   904,    -1,    33,    -1,   895,   904,   924,    -1,
     896,   904,   925,    -1,   567,   904,    -1,   591,   905,   901,
      -1,   109,    -1,   525,    -1,   522,    -1,   106,    -1,   526,
      -1,    40,   905,    -1,   892,    -1,   298,    -1,   265,    -1,
     268,   567,    -1,   268,   895,   924,    -1,   528,   924,    -1,
     519,   905,   924,    -1,   300,   924,    -1,   266,   924,    -1,
     117,   899,   901,    -1,   343,   899,   901,    -1,   174,   899,
     901,    -1,    -1,   151,   890,   602,   959,   603,   924,    -1,
      -1,   455,   891,   602,   959,   603,   924,    -1,   268,   924,
      -1,   451,    -1,   189,    -1,   188,    -1,   375,    -1,   318,
      -1,   256,    -1,   317,    -1,   376,    -1,   319,    -1,    59,
      -1,   327,    -1,   324,    59,    -1,   893,   571,    -1,   568,
      -1,   324,   568,    -1,   344,    -1,   327,   568,    -1,   324,
      59,   571,    -1,   327,   571,    -1,   228,    -1,   527,    -1,
     467,    -1,   299,    -1,    32,    -1,   400,    -1,   134,    -1,
     134,   379,    -1,    -1,   904,    -1,   900,    -1,   602,   342,
     604,   342,   603,    -1,    -1,   902,    -1,   902,   903,    -1,
     903,    -1,   463,    -1,   553,    -1,   592,    -1,   602,   267,
     603,    -1,   602,   540,   603,    -1,   602,   116,   603,    -1,
     602,   342,   603,    -1,    -1,   904,    -1,    -1,   900,    -1,
      -1,   908,    -1,   908,   909,    -1,   909,    -1,   341,    -1,
    1079,   341,    -1,   119,   911,    -1,   347,   555,   337,  1072,
      -1,    25,    -1,   451,   119,   566,    -1,   926,   240,    -1,
     550,    -1,   550,   240,    -1,    73,  1359,    -1,    68,   918,
      -1,   889,   919,    -1,   337,  1072,    -1,  1345,    -1,    59,
     455,    -1,    58,    -1,  1364,    -1,    33,    -1,   913,    -1,
     119,    -1,    -1,   912,   914,    -1,  1364,    -1,    33,    -1,
     916,    -1,   119,    -1,  1364,    -1,    -1,    68,   920,    -1,
     918,    -1,   119,    -1,    -1,   119,    -1,    20,    -1,    33,
      20,    -1,    20,    33,    -1,   547,    -1,   547,    33,    -1,
      33,   547,    -1,    -1,   922,    -1,   923,    -1,    47,    -1,
     912,   913,   925,    -1,    33,    -1,    33,   912,   913,    -1,
      -1,    33,    -1,    -1,   383,    -1,   406,  1355,   928,   930,
     931,    -1,    -1,   602,   929,   603,    -1,   929,   604,  1362,
      -1,  1362,    -1,    -1,   289,   183,    -1,   289,   367,    -1,
     289,   464,    -1,    -1,   347,   555,   932,    -1,   347,   123,
     932,    -1,   347,   555,   932,   347,   123,   932,    -1,   347,
     123,   932,   347,   555,   932,    -1,   428,    -1,    50,    -1,
     455,   341,    -1,   338,     5,    -1,   455,   119,    -1,   935,
      -1,   383,   240,    -1,   550,   936,    -1,   240,    -1,   217,
      -1,    -1,   935,    -1,   238,    -1,   217,    -1,   216,    -1,
      -1,   550,    -1,   184,    -1,   473,    -1,    -1,   941,    -1,
     941,   949,    -1,    -1,   946,    -1,    -1,   948,    -1,    -1,
     947,    -1,   951,    -1,   946,   951,    -1,   952,    -1,   947,
     952,    -1,   953,    -1,   948,   953,    -1,   561,   954,    -1,
     538,   954,    -1,   239,  1242,  1190,    -1,    73,  1359,    -1,
     950,    -1,   949,    -1,   950,    -1,   950,    -1,   580,   366,
    1358,    -1,    45,    -1,   440,    -1,   198,    -1,   955,   604,
     956,  1183,    -1,   956,  1183,    -1,  1362,    -1,  1362,   602,
     342,   603,    -1,    -1,  1354,    -1,    -1,   610,  1362,    -1,
    1343,    -1,   959,   604,  1343,    -1,    -1,    13,   994,   512,
    1355,   961,   972,    -1,    -1,    13,   102,   971,   962,   859,
      -1,    13,   102,  1362,   556,   105,   128,   323,    -1,    -1,
      13,   385,   660,   963,   661,    -1,    -1,    13,   185,   660,
     964,   661,    -1,    -1,    13,  1464,  1459,   965,  1466,    -1,
      -1,    13,  1459,   966,  1466,    -1,    -1,    13,  1459,   159,
     660,   967,   968,   969,   650,   655,   970,    -1,    13,   510,
     760,    -1,    13,   263,   194,   762,    -1,    13,   510,   757,
      -1,    13,   510,   756,    -1,    13,   453,  1364,   352,   602,
     644,   603,    -1,    -1,   347,   442,   648,    -1,   654,    -1,
     347,   442,   648,   654,    -1,    -1,   416,   529,   660,    -1,
      -1,   135,   656,    -1,    -1,  1362,    -1,    -1,   130,   510,
      -1,   215,   510,    -1,   987,   805,    -1,   987,   976,    -1,
     976,    -1,   806,    -1,   978,    -1,   136,   370,   985,    -1,
     401,   370,  1027,   977,    -1,    -1,   351,   370,  1027,   977,
     973,  1027,    -1,    14,   370,  1027,   977,    -1,    -1,    61,
     370,   977,   974,  1022,    -1,    -1,   418,   370,  1027,   977,
     975,  1014,    -1,    66,   370,  1027,  1191,    -1,   536,   370,
     977,    -1,   981,    -1,   415,   368,    -1,    12,    -1,   985,
      -1,    -1,     6,   370,  1027,   979,   980,    -1,    -1,   602,
     831,   603,    -1,   369,  1191,    -1,    -1,   417,   370,  1027,
     982,   983,    -1,    -1,    -1,   985,   984,   227,   602,   831,
     603,    -1,   986,    -1,   985,   604,   986,    -1,  1362,    -1,
     989,    -1,   987,   604,   989,    -1,     6,   993,    -1,   988,
     881,   996,    -1,     6,   882,    -1,   988,   602,   878,   603,
      -1,    -1,    56,   993,  1354,   990,   887,   996,    -1,    -1,
      -1,   314,   993,  1354,   991,   889,   907,   992,   996,    -1,
     136,   993,  1354,   995,    -1,   136,   179,   240,   957,    -1,
     136,   383,   240,    -1,   136,   935,  1354,    -1,   129,   238,
      -1,   144,   238,    -1,    13,   993,  1354,   455,   119,  1345,
      -1,    13,   993,  1354,   136,   119,    -1,   416,   997,  1355,
      -1,    91,   529,   912,   914,   919,    -1,   866,    -1,   178,
      -1,  1176,    -1,    -1,    71,    -1,    -1,   213,    -1,    -1,
     428,    -1,    50,    -1,    -1,     8,  1362,    -1,   173,    -1,
      -1,   529,    -1,   152,    -1,    18,    -1,    -1,   489,   465,
    1003,   999,  1007,    -1,   493,   465,  1003,    -1,    -1,   465,
     489,  1003,  1000,  1007,    -1,   465,   493,  1003,    -1,   489,
     531,  1002,    -1,    -1,   580,    82,   468,    -1,    -1,  1004,
    1005,    -1,  1006,    -1,  1005,   604,  1006,    -1,    -1,   485,
      -1,   412,    -1,    -1,   554,  1008,    -1,   635,    -1,  1008,
     604,   635,    -1,    -1,    60,  1387,  1010,  1216,  1011,    -1,
      -1,   394,    -1,   165,    -1,    -1,   418,  1027,  1387,  1013,
    1216,  1014,    -1,    -1,  1015,    -1,  1016,    -1,  1016,  1015,
      -1,   394,    -1,   165,    -1,   559,    -1,    -1,    14,  1027,
    1387,  1018,  1216,    -1,    34,  1359,    -1,    -1,    61,  1387,
    1021,  1216,  1022,    -1,    -1,  1023,    -1,  1024,    -1,  1024,
    1023,    -1,   394,    -1,   169,    -1,   301,    -1,   165,    -1,
      57,    -1,   180,   556,    -1,    -1,   351,  1027,  1387,  1026,
    1216,    -1,    -1,   340,    -1,   259,    -1,    -1,   416,  1387,
    1029,  1031,    -1,   416,   558,   659,  1030,    -1,  1365,   529,
    1365,    -1,  1030,   604,  1365,   529,  1365,    -1,  1032,    -1,
    1031,   604,  1032,    -1,  1355,   529,  1355,    -1,    -1,    48,
     217,  1034,  1035,   230,  1039,    -1,  1036,    -1,  1038,    -1,
    1037,    -1,  1036,   604,  1037,    -1,  1355,  1048,    -1,  1355,
    1046,  1048,    -1,  1362,    -1,   119,    -1,    -1,   258,   217,
     227,    48,  1041,  1042,    -1,  1045,    -1,  1043,    -1,  1044,
      -1,  1043,   604,  1044,    -1,  1355,  1048,  1051,    -1,  1355,
    1046,  1048,  1051,    -1,    -1,   370,   808,  1047,   602,   977,
     603,    -1,    -1,  1049,  1050,    -1,    -1,   935,   602,  1158,
     603,    -1,    -1,   213,   246,    -1,  1053,    -1,   447,  1056,
      -1,   602,  1054,   603,  1441,    -1,   447,  1058,    -1,   602,
    1054,   603,    -1,   447,  1137,    -1,   602,  1055,   603,    -1,
      -1,  1058,  1057,  1438,    -1,    -1,    -1,  1059,  1063,  1067,
    1060,  1061,  1066,    -1,  1179,  1185,    -1,  1205,    -1,  1062,
      -1,  1205,  1062,    -1,  1062,  1205,    -1,   182,  1119,  1168,
    1173,  1170,  1179,  1185,  1196,    -1,   182,   137,  1168,  1185,
      -1,    -1,  1064,    -1,  1064,  1065,    -1,  1065,    -1,  1455,
      -1,   482,    -1,   480,    -1,    -1,   180,   555,    -1,   262,
     230,   457,   312,    -1,  1067,   604,  1068,    -1,  1068,    -1,
     597,    -1,  1069,  1349,  1070,    -1,  1069,  1073,  1070,  1071,
      -1,    -1,    -1,    -1,    18,  1362,    -1,    18,  1359,    -1,
    1362,    -1,  1359,    -1,    -1,   602,   603,    -1,  1073,  1077,
    1073,    -1,  1073,   589,  1073,    -1,  1073,  1078,  1073,    -1,
     336,  1073,    -1,  1074,   233,   535,    -1,  1074,   233,  1079,
     535,    -1,  1074,   233,   168,    -1,  1074,   233,  1079,   168,
      -1,  1074,   233,   551,    -1,  1074,   233,  1079,   551,    -1,
    1074,    -1,  1074,   233,   341,    -1,  1074,   233,  1079,   341,
      -1,  1074,   153,  1075,    -1,  1074,  1081,  1075,    -1,  1074,
    1081,  1082,   602,  1450,   603,    -1,  1075,    -1,  1076,   230,
     602,  1450,   603,    -1,  1076,  1079,   230,   602,  1450,   603,
      -1,  1076,   230,   602,  1073,   603,    -1,  1076,   230,   602,
    1073,   604,  1112,   603,    -1,  1076,  1079,   230,   602,  1073,
     603,    -1,  1076,  1079,   230,   602,  1073,   604,  1112,   603,
      -1,  1076,    31,  1076,    16,  1075,    -1,  1076,  1079,    31,
    1076,    16,  1075,    -1,  1076,   471,   252,  1076,    -1,  1076,
     252,  1083,  1172,    -1,  1076,  1079,   252,  1083,  1172,    -1,
    1076,   407,  1076,    -1,  1076,  1079,   407,  1076,    -1,  1076,
      -1,  1076,   593,  1076,    -1,  1076,   594,  1076,    -1,  1076,
     458,  1076,    -1,  1076,   459,  1076,    -1,  1076,   596,  1076,
      -1,  1076,   595,  1076,    -1,  1076,   596,   226,  1073,  1162,
      -1,  1076,   595,   226,  1073,  1162,    -1,  1076,   597,  1076,
      -1,  1076,   598,  1076,    -1,  1076,   599,  1076,    -1,  1076,
     133,  1076,    -1,  1076,   315,  1076,    -1,  1076,   600,  1076,
      -1,  1083,    -1,   358,    -1,   355,    -1,    16,    -1,    15,
      -1,   336,    -1,   335,    -1,   605,    -1,   335,    -1,   152,
      -1,   186,    -1,   196,    -1,   244,    -1,   271,    -1,   329,
      -1,    12,    -1,    17,    -1,  1351,    -1,  1084,    -1,  1085,
      -1,  1088,    -1,  1086,    -1,  1083,    68,  1364,    -1,  1346,
      -1,  1344,    -1,  1100,    -1,  1096,    -1,  1083,   357,  1083,
      -1,   596,  1083,    -1,   595,  1083,    -1,   601,  1083,    -1,
    1080,  1083,    -1,   602,  1450,   603,    -1,   602,  1073,   603,
      -1,   602,  1073,   604,  1112,   603,    -1,   439,   602,  1073,
     604,  1112,   603,    -1,   162,   602,  1450,   603,    -1,   606,
    1362,  1073,   607,    -1,   289,  1113,     9,   602,  1076,  1090,
     603,    -1,    33,  1083,    -1,    53,   602,  1073,    18,  1110,
     603,    -1,    52,  1115,  1117,  1116,   146,    -1,    91,   602,
    1073,   604,  1110,   603,    -1,    91,   602,  1073,   561,   913,
     603,    -1,   119,   602,  1351,   603,    -1,   565,   602,  1352,
     603,    -1,   226,  1073,  1162,   596,  1073,    -1,    59,   602,
    1112,   603,    -1,    59,   602,  1112,   561,   913,   603,    -1,
      98,  1072,    -1,   109,   602,  1073,   603,    -1,   114,   602,
    1073,   603,    -1,   208,   602,  1073,   603,    -1,   223,   602,
    1073,   604,  1073,   604,  1073,   604,  1073,   603,    -1,   226,
     602,  1073,   604,  1073,   603,    -1,   226,   602,  1073,   604,
    1073,   604,  1112,   603,    -1,   248,   602,  1073,   604,  1073,
     603,    -1,   309,   602,  1073,   603,    -1,   316,   602,  1073,
     603,    -1,   433,   602,  1073,   604,  1073,   603,    -1,   445,
     602,  1073,   603,    -1,   525,   602,  1073,   603,    -1,   522,
     602,  1073,   603,    -1,   522,   602,  1073,   604,  1073,   603,
      -1,   534,   602,  1073,   603,    -1,   534,   602,   245,  1073,
     182,  1073,   603,    -1,   534,   602,   530,  1073,   182,  1073,
     603,    -1,   534,   602,    44,  1073,   182,  1073,   603,    -1,
     534,   602,   245,   182,  1073,   603,    -1,   534,   602,   530,
     182,  1073,   603,    -1,   534,   602,    44,   182,  1073,   603,
      -1,   534,   602,  1073,   182,  1073,   603,    -1,   558,   602,
     603,    -1,   591,   602,  1073,   603,    -1,     7,   602,  1073,
     604,  1073,   603,    -1,     7,   602,  1073,   604,   226,  1073,
    1162,   603,    -1,    97,  1072,    -1,   101,  1072,    -1,   101,
     602,  1073,   603,    -1,   107,   602,  1073,   604,   226,  1073,
    1162,   603,    -1,   108,   602,  1073,   604,   226,  1073,  1162,
     603,    -1,   167,   602,  1162,   182,  1073,   603,    -1,   190,
     602,  1164,   604,  1073,   603,    -1,   337,  1072,    -1,   337,
     602,  1073,   603,    -1,   378,   602,  1076,   230,  1073,   603,
      -1,   498,   602,  1073,   604,  1073,   603,    -1,   498,   602,
    1073,   604,   226,  1073,  1162,   603,    -1,   502,   602,  1073,
     604,  1073,   604,  1073,   603,    -1,   502,   602,  1073,   604,
    1073,   603,    -1,   502,   602,  1073,   182,  1073,   180,  1073,
     603,    -1,   502,   602,  1073,   182,  1073,   603,    -1,   508,
    1072,    -1,   508,   602,  1073,   603,    -1,   523,   602,  1163,
     604,  1073,   604,  1073,   603,    -1,   524,   602,  1163,   604,
    1073,   604,  1073,   603,    -1,   562,  1072,    -1,   564,  1072,
      -1,   563,  1072,    -1,    20,   602,  1073,   603,    -1,    58,
     602,  1073,   603,    -1,    66,   602,  1112,   603,    -1,    69,
     602,  1073,   603,    -1,   102,   602,   603,    -1,   212,   602,
    1073,   604,  1073,   604,  1073,   603,    -1,   305,   602,  1073,
     603,    -1,   315,   602,  1073,   604,  1073,   603,    -1,   346,
     602,  1073,   603,    -1,   371,   602,  1073,   603,    -1,   392,
     602,  1073,   603,    -1,   420,   602,  1073,   604,  1073,   603,
      -1,   421,   602,  1073,   604,  1073,   604,  1073,   603,    -1,
     536,   602,  1073,   604,  1073,   603,    -1,   576,   602,  1073,
     603,    -1,   576,   602,  1073,   604,  1073,   603,    -1,  1087,
      -1,    87,   602,  1073,   604,  1073,   603,    -1,   188,   602,
    1112,   603,    -1,   256,   602,  1112,   603,    -1,   317,   602,
    1112,   603,    -1,   318,   602,  1112,   603,    -1,   319,   602,
    1112,   603,    -1,   375,   602,  1073,   604,  1073,   603,    -1,
     376,   602,  1112,   603,    -1,    -1,  1358,   602,  1089,  1093,
     603,    -1,  1362,   610,  1362,   602,  1111,   603,    -1,  1091,
    1092,    -1,   230,    42,   312,    -1,    -1,   230,   325,   242,
     312,    -1,    -1,   580,   393,   164,    -1,    -1,  1094,    -1,
    1095,    -1,  1094,   604,  1095,    -1,  1069,  1073,  1070,  1071,
      -1,    27,   602,  1108,   603,    -1,    27,   602,   132,  1108,
     603,    -1,    36,   602,  1108,   603,    -1,    37,   602,  1108,
     603,    -1,    39,   602,  1108,   603,    -1,    92,   602,  1167,
     597,   603,    -1,    92,   602,  1108,   603,    -1,    -1,    -1,
      92,   602,   132,  1097,  1112,  1098,   603,    -1,   311,   602,
    1108,   603,    -1,   311,   602,   132,  1108,   603,    -1,   294,
     602,  1108,   603,    -1,   294,   602,   132,  1108,   603,    -1,
     492,   602,  1108,   603,    -1,   570,   602,  1108,   603,    -1,
     491,   602,  1108,   603,    -1,   572,   602,  1108,   603,    -1,
     503,   602,  1108,   603,    -1,   503,   602,   132,  1108,   603,
      -1,    -1,   195,   602,  1103,  1099,  1112,  1105,  1104,   603,
      -1,    -1,   609,  1101,  1102,    -1,  1364,   456,  1073,    -1,
    1364,    -1,   609,  1377,  1364,   958,    -1,    -1,   132,    -1,
      -1,   449,  1343,    -1,    -1,    -1,   356,    46,  1106,  1107,
      -1,  1107,   604,  1350,  1183,    -1,  1350,  1183,    -1,    -1,
    1167,  1109,  1073,    -1,    33,   905,    -1,    59,   905,   924,
      -1,   327,   905,    -1,   463,    -1,   463,   228,    -1,   553,
      -1,   553,   228,    -1,   109,    -1,   525,    -1,   106,    -1,
     117,   899,    -1,    -1,  1112,    -1,  1073,    -1,  1112,   604,
    1073,    -1,  1114,    -1,   602,  1114,   603,    -1,  1351,    -1,
    1114,   604,  1351,    -1,    -1,  1073,    -1,    -1,   142,  1073,
      -1,   577,  1073,   521,  1073,    -1,  1117,   577,  1073,   521,
    1073,    -1,  1131,    -1,  1122,    -1,  1121,    -1,  1118,    -1,
     606,  1362,  1118,   607,    -1,  1120,    -1,  1121,   604,  1120,
      -1,  1118,  1130,  1118,    -1,  1118,   495,  1131,    -1,    -1,
    1118,  1130,  1118,   347,  1123,  1073,    -1,    -1,  1118,   495,
    1131,   347,  1124,  1073,    -1,    -1,  1118,  1130,  1118,   561,
    1125,   602,  1161,   603,    -1,  1118,   325,   237,  1131,    -1,
      -1,  1118,   248,  1147,   237,  1118,   347,  1126,  1073,    -1,
      -1,  1118,   248,  1147,   237,  1131,  1127,   561,   602,  1161,
     603,    -1,  1118,   325,   248,  1147,   237,  1131,    -1,    -1,
    1118,   433,  1147,   237,  1118,   347,  1128,  1073,    -1,    -1,
    1118,   433,  1147,   237,  1131,  1129,   561,   602,  1161,   603,
      -1,  1118,   325,   433,  1147,   237,  1131,    -1,   237,    -1,
     220,   237,    -1,    95,   237,    -1,    -1,  1132,  1355,  1166,
    1156,    -1,  1146,  1145,  1142,    -1,   602,  1145,  1133,   603,
    1166,    -1,  1140,  1442,    -1,    -1,    -1,  1133,   549,  1446,
    1134,  1447,  1135,  1442,    -1,  1137,    -1,    -1,    -1,  1138,
    1453,  1067,  1139,   876,  1066,    -1,    -1,  1145,  1141,  1121,
      -1,    -1,    -1,  1143,  1063,  1067,  1144,   876,    -1,    -1,
     447,    -1,    -1,   359,    -1,    -1,   180,   237,    -1,   180,
     356,    46,    -1,   180,   194,    46,    -1,   178,    -1,   213,
      -1,    -1,  1149,   935,  1148,  1151,   602,  1160,   603,    -1,
      -1,   560,   935,  1148,  1152,   602,  1158,   603,    -1,  1150,
      -1,  1153,  1150,    -1,    -1,    -1,  1155,  1153,    -1,    -1,
    1157,  1154,    -1,    -1,  1160,    -1,  1362,    -1,   383,    -1,
    1159,    -1,  1160,   604,  1159,    -1,  1362,    -1,  1161,   604,
    1362,    -1,  1163,    -1,   110,    -1,   111,    -1,   112,    -1,
     113,    -1,   205,    -1,   206,    -1,   207,    -1,   307,    -1,
     308,    -1,   444,    -1,   590,    -1,   114,    -1,   576,    -1,
     208,    -1,   309,    -1,   316,    -1,   392,    -1,   445,    -1,
     305,    -1,   591,    -1,   109,    -1,   525,    -1,   106,    -1,
     522,    -1,    -1,    18,    -1,   152,    -1,    -1,  1165,  1362,
      -1,    -1,    12,    -1,    -1,    -1,   578,  1169,  1073,    -1,
      -1,    -1,   199,  1171,  1073,    -1,   157,  1083,    -1,    -1,
      -1,   194,    46,  1174,  1175,    -1,  1174,   604,  1350,  1183,
      -1,  1350,  1183,    -1,    -1,   581,    -1,   582,    -1,   356,
      46,  1177,    -1,  1177,   604,  1178,    -1,  1178,    -1,  1352,
    1183,    -1,    -1,  1180,    -1,    -1,   356,    46,  1181,  1182,
      -1,  1182,   604,  1350,  1183,    -1,  1350,  1183,    -1,    -1,
      19,    -1,   124,    -1,    -1,  1186,    -1,    -1,  1186,    -1,
     253,  1187,    -1,  1188,    -1,  1188,   604,  1188,    -1,  1188,
     345,  1188,    -1,  1362,    -1,  1344,    -1,   540,    -1,   267,
      -1,   342,    -1,    -1,   253,  1188,    -1,   342,    -1,   201,
      -1,   267,    -1,   540,    -1,   116,    -1,   175,    -1,   342,
      -1,   201,    -1,   267,    -1,   540,    -1,  1194,    -1,   342,
      -1,   540,    -1,   267,    -1,   116,    -1,   175,    -1,   342,
      -1,   540,    -1,   267,    -1,  1194,    -1,  1195,    -1,   116,
      -1,   175,    -1,    -1,    -1,   385,  1362,  1197,   602,  1198,
     603,    -1,    -1,  1199,    -1,  1199,   604,  1200,    -1,  1200,
      -1,  1069,  1073,  1070,    -1,    -1,  1202,  1203,    -1,  1203,
     604,  1204,    -1,  1204,    -1,   609,  1364,    -1,  1364,    -1,
      -1,   227,  1206,  1207,    -1,    -1,    -1,   360,  1361,  1208,
     915,  1209,  1327,  1330,    -1,   138,  1361,    -1,  1201,    -1,
      -1,   135,  1211,  1112,    -1,    -1,   136,  1221,  1387,  1220,
    1213,  1216,   995,    -1,    -1,   136,   217,  1362,   347,  1355,
    1214,    -1,   136,   102,  1220,  1362,    -1,   136,   185,  1220,
    1362,   610,  1362,    -1,   136,   185,  1220,  1362,    -1,   136,
     385,  1220,   660,    -1,   136,   558,   659,  1417,    -1,    -1,
     136,   573,  1220,  1215,  1216,   995,    -1,   136,   159,  1220,
     660,    -1,   136,   533,  1220,   660,    -1,   136,   510,   783,
     794,   795,    -1,   136,   263,   194,   784,   794,   795,    -1,
     136,   453,  1220,  1364,    -1,  1217,    -1,  1216,   604,  1217,
      -1,  1355,    -1,  1219,    -1,  1218,   604,  1219,    -1,  1356,
      -1,    -1,   212,   162,    -1,    -1,   515,    -1,    -1,    -1,
     223,  1223,  1228,   994,  1230,  1224,  1232,  1248,    -1,    -1,
      -1,   421,  1226,  1229,  1230,  1227,  1232,    -1,    -1,   270,
      -1,   121,    -1,   202,    -1,  1257,    -1,   121,    -1,   227,
    1231,    -1,  1231,    -1,  1217,    -1,  1235,    -1,   602,   603,
    1235,    -1,   602,  1234,   603,  1235,    -1,    -1,   455,  1233,
    1239,    -1,  1234,   604,  1348,    -1,  1348,    -1,   565,  1238,
      -1,   566,  1238,    -1,    -1,   854,  1236,  1438,    -1,    -1,
     602,   854,   603,  1237,  1441,    -1,  1238,   604,  1243,    -1,
    1243,    -1,  1239,   604,  1240,    -1,  1240,    -1,  1352,  1241,
    1247,    -1,   152,    -1,   456,    -1,    -1,  1241,    -1,    -1,
     602,  1244,  1245,   603,    -1,    -1,  1246,    -1,  1246,   604,
    1247,    -1,  1247,    -1,  1073,    -1,   119,    -1,    -1,    -1,
     347,   139,  1249,   240,   555,  1255,    -1,    -1,    -1,   555,
    1251,  1257,   994,  1119,   455,  1253,  1252,  1168,  1179,  1189,
      -1,  1253,   604,  1254,    -1,  1254,    -1,  1352,  1241,  1247,
      -1,  1255,   604,  1256,    -1,  1256,    -1,  1352,  1241,  1247,
      -1,    -1,   270,    -1,    -1,   123,  1259,  1267,  1260,    -1,
      -1,   182,  1355,  1261,  1168,  1179,  1189,    -1,    -1,  1264,
    1262,   182,  1119,  1168,    -1,    -1,   182,  1218,  1263,   561,
    1119,  1168,    -1,  1265,    -1,  1264,   604,  1265,    -1,  1362,
    1266,    -1,  1362,   610,  1362,  1266,    -1,    -1,   610,   597,
      -1,    -1,  1268,  1267,    -1,   394,    -1,   270,    -1,   213,
      -1,    -1,   536,  1271,  1270,  1217,    -1,    -1,   512,    -1,
      -1,  1273,    -1,  1274,    -1,  1273,   604,  1274,    -1,    93,
      -1,   302,    -1,    41,   231,    -1,    88,   507,    -1,   364,
     170,    -1,   232,    -1,   506,    -1,   472,    -1,    12,    -1,
      -1,   180,   393,   342,    -1,    -1,   460,  1277,  1278,    -1,
     103,  1289,    -1,  1285,   509,  1284,  1289,    -1,  1285,   532,
    1284,  1289,    -1,   158,  1284,  1289,    -1,   512,   490,  1284,
    1289,    -1,   350,   509,  1284,  1289,    -1,   373,    -1,   150,
     873,  1281,    -1,   150,    12,  1281,    -1,  1285,    70,  1286,
    1355,  1284,  1289,    -1,  1282,   264,    -1,   465,   204,    -1,
      -1,    34,   158,  1287,  1288,  1279,  1184,    -1,    -1,   409,
     158,  1287,  1288,  1280,  1184,    -1,   937,  1286,  1355,  1284,
    1168,    -1,  1283,   149,    -1,    23,    -1,    90,    -1,   384,
      -1,    92,   602,   597,   603,   575,    -1,    92,   602,   597,
     603,   155,    -1,   575,  1184,    -1,   155,  1184,    -1,   389,
      -1,   388,  1272,  1275,  1184,    -1,  1376,   490,  1289,    -1,
    1285,   387,    -1,  1376,   569,  1289,    -1,   912,  1289,    -1,
      69,  1289,    -1,   193,    -1,   193,   180,  1365,    -1,    94,
     102,   864,  1362,    -1,    94,   512,  1355,    -1,    94,   573,
    1355,    -1,   286,   490,    -1,   465,   490,    -1,    94,   385,
     660,    -1,    94,   185,   660,    -1,    94,   533,   660,    -1,
     385,   490,  1289,    -1,   185,   490,  1289,    -1,   385,    67,
     660,    -1,   185,    67,   660,    -1,    94,   159,   660,    -1,
     490,    -1,   320,    -1,   264,    -1,   286,    -1,    33,    -1,
      -1,   494,    -1,    -1,  1286,  1362,    -1,    -1,   183,    -1,
     182,    -1,   230,    -1,    -1,   230,  1359,    -1,    -1,   182,
    1192,    -1,    -1,   252,  1359,    -1,   578,  1073,    -1,    -1,
    1293,  1355,  1291,  1295,    -1,    -1,  1293,  1294,  1292,  1052,
      -1,   124,    -1,   125,    -1,    -1,   165,    -1,   369,    -1,
      -1,  1343,    -1,  1362,    -1,    -1,   177,  1027,  1297,  1298,
      -1,    -1,    -1,  1387,  1299,  1304,  1300,  1301,    -1,  1302,
      -1,    -1,   580,   398,   262,    -1,  1302,   604,  1303,    -1,
    1303,    -1,   154,   264,    -1,   150,   264,    -1,   187,   264,
      -1,   466,   264,    -1,    33,   264,    -1,   408,   264,    -1,
     393,    48,    -1,   204,    -1,   384,    -1,   264,    -1,   490,
      -1,   465,    -1,   286,    -1,   126,    -1,   426,    -1,    -1,
    1216,    -1,    -1,   424,  1306,  1307,    -1,  1307,   604,  1308,
      -1,  1308,    -1,    -1,   465,  1309,  1310,    -1,   286,    -1,
     393,    48,    -1,    -1,    12,    -1,    -1,   391,  1312,  1313,
      -1,  1282,   264,  1314,    -1,   529,  1359,    -1,    29,  1073,
      -1,   241,  1316,  1073,    -1,    -1,    81,    -1,   393,    -1,
     560,  1362,    -1,    -1,    -1,    -1,    -1,   258,  1323,  1319,
    1325,  1324,   218,  1361,  1320,  1326,   227,   512,  1355,  1321,
     915,  1322,  1333,  1327,  1330,  1334,  1336,  1339,    -1,   105,
      -1,   588,    -1,    -1,   259,    -1,    -1,    79,    -1,   270,
      -1,    -1,   421,    -1,   213,    -1,    -1,    70,  1328,    -1,
    1328,  1329,    -1,  1329,    -1,   517,    46,  1343,    -1,   354,
     145,    46,  1343,    -1,   145,    46,  1343,    -1,   156,    46,
    1343,    -1,    -1,   255,  1331,    -1,  1331,  1332,    -1,  1332,
      -1,   517,    46,  1343,    -1,   487,    46,  1343,    -1,    -1,
     437,   210,    46,  1343,    -1,    -1,   213,   342,  1335,    -1,
     255,    -1,   437,    -1,    -1,   602,  1337,   603,    -1,   602,
     603,    -1,  1337,   604,  1338,    -1,  1338,    -1,  1352,    -1,
     609,  1364,    -1,    -1,   455,  1340,    -1,  1340,   604,  1341,
      -1,  1341,    -1,  1352,  1241,  1069,  1247,  1070,    -1,   518,
      -1,   326,    -1,   543,   518,    -1,  1342,  1360,    -1,  1360,
      -1,   201,    -1,    35,    -1,   365,    -1,  1346,    -1,   596,
    1347,    -1,   595,  1347,    -1,  1342,    -1,  1347,    -1,   341,
      -1,   168,    -1,   535,    -1,   201,    -1,    35,    -1,   543,
     201,    -1,   543,    35,    -1,   109,  1342,    -1,   525,  1342,
      -1,   522,  1342,    -1,   342,    -1,   267,    -1,   540,    -1,
     116,    -1,   175,    -1,  1352,    -1,  1349,    -1,  1362,   610,
     597,    -1,  1362,   610,  1362,   610,   597,    -1,  1073,    -1,
    1362,    -1,  1353,    -1,  1362,    -1,  1353,    -1,  1362,   610,
    1362,    -1,   610,  1362,   610,  1362,    -1,  1362,   610,  1362,
     610,  1362,    -1,  1362,    -1,  1362,   610,  1362,   610,  1362,
      -1,  1362,   610,  1362,    -1,   610,  1362,    -1,  1362,    -1,
    1362,   610,  1362,    -1,   610,  1362,    -1,  1362,  1266,    -1,
    1362,   610,  1362,  1266,    -1,  1362,    -1,   209,    -1,   211,
      -1,   518,    -1,   518,    -1,   518,    -1,  1358,    -1,  1366,
      -1,  1358,    -1,  1367,    -1,  1362,    -1,  1359,    -1,   251,
      -1,  1364,    -1,  1364,   609,  1364,    -1,    98,  1072,    -1,
    1367,    -1,    20,    -1,    28,    -1,    30,    -1,    47,    -1,
      48,    -1,    58,    -1,    60,    -1,    65,    -1,    73,    -1,
      75,    -1,    87,    -1,   115,    -1,   135,    -1,   146,    -1,
     161,    -1,   177,    -1,   197,    -1,   200,    -1,   203,    -1,
     225,    -1,   242,    -1,   338,    -1,   350,    -1,   352,    -1,
     362,    -1,   366,    -1,   370,    -1,   377,    -1,   380,    -1,
     415,    -1,   418,    -1,   424,    -1,   427,    -1,   434,    -1,
     441,    -1,   446,    -1,   453,    -1,   463,    -1,   469,    -1,
     465,    -1,   470,    -1,   489,    -1,   493,    -1,   536,    -1,
     547,    -1,   548,    -1,   584,    -1,   587,    -1,   556,    -1,
       5,    -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,
      11,    -1,    17,    -1,    22,    -1,    23,    -1,    25,    -1,
      24,    -1,    26,    -1,    27,    -1,    34,    -1,    38,    -1,
      41,    -1,    43,    -1,    42,    -1,    45,    -1,    51,    -1,
      54,    -1,    55,    -1,    57,    -1,    62,    -1,    64,    -1,
      63,    -1,    66,    -1,    67,    -1,    69,    -1,    72,    -1,
      70,    -1,    74,    -1,    76,    -1,    77,    -1,    78,    -1,
      79,    -1,    81,    -1,    82,    -1,    84,    -1,    86,    -1,
      85,    -1,    88,    -1,    90,    -1,    93,    -1,    96,    -1,
     100,    -1,   105,    -1,   104,    -1,   106,    -1,   109,    -1,
     114,    -1,   120,    -1,   122,    -1,   126,    -1,   128,    -1,
     129,    -1,   130,    -1,   131,    -1,   138,    -1,   139,    -1,
     140,    -1,   147,    -1,   151,    -1,   150,    -1,   149,    -1,
     154,    -1,   155,    -1,   157,    -1,   159,    -1,   158,    -1,
     160,    -1,   164,    -1,   165,    -1,   166,    -1,   170,    -1,
     169,    -1,   181,    -1,   144,    -1,   183,    -1,   172,    -1,
     173,    -1,   174,    -1,   187,    -1,   189,    -1,   188,    -1,
     190,    -1,   193,    -1,   191,    -1,   198,    -1,   204,    -1,
     208,    -1,   210,    -1,   214,    -1,   229,    -1,   215,    -1,
     216,    -1,   219,    -1,   231,    -1,   232,    -1,   234,    -1,
     235,    -1,   224,    -1,   239,    -1,   243,    -1,   246,    -1,
     249,    -1,   250,    -1,   256,    -1,   257,    -1,   259,    -1,
     261,    -1,   263,    -1,   264,    -1,   292,    -1,   286,    -1,
     288,    -1,   273,    -1,   277,    -1,   274,    -1,   275,    -1,
     287,    -1,   276,    -1,   278,    -1,   272,    -1,   284,    -1,
     280,    -1,   279,    -1,   281,    -1,   282,    -1,   283,    -1,
     290,    -1,   291,    -1,   293,    -1,   295,    -1,   296,    -1,
     301,    -1,   302,    -1,   303,    -1,   304,    -1,   305,    -1,
     306,    -1,   309,    -1,   310,    -1,   314,    -1,   312,    -1,
     316,    -1,   317,    -1,   318,    -1,   319,    -1,   320,    -1,
     321,    -1,   323,    -1,   322,    -1,   324,    -1,   327,    -1,
     328,    -1,   332,    -1,   331,    -1,   339,    -1,   333,    -1,
     334,    -1,   344,    -1,   345,    -1,   346,    -1,   348,    -1,
     349,    -1,   363,    -1,   364,    -1,   367,    -1,   368,    -1,
     369,    -1,   371,    -1,   372,    -1,   374,    -1,   373,    -1,
     375,    -1,   376,    -1,   381,    -1,   382,    -1,   384,    -1,
     386,    -1,   387,    -1,   388,    -1,   389,    -1,   390,    -1,
     392,    -1,   393,    -1,   394,    -1,   397,    -1,   401,    -1,
     402,    -1,   404,    -1,   403,    -1,   405,    -1,   408,    -1,
     409,    -1,   410,    -1,   411,    -1,   412,    -1,   414,    -1,
     417,    -1,   419,    -1,   422,    -1,   426,    -1,   429,    -1,
     430,    -1,   435,    -1,   436,    -1,   437,    -1,   438,    -1,
     439,    -1,   440,    -1,   442,    -1,   443,    -1,   445,    -1,
     451,    -1,   450,    -1,   452,    -1,   464,    -1,   457,    -1,
     461,    -1,   466,    -1,   468,    -1,   471,    -1,   472,    -1,
     480,    -1,   479,    -1,   482,    -1,   485,    -1,   488,    -1,
     490,    -1,   494,    -1,   496,    -1,   497,    -1,   498,    -1,
     499,    -1,   501,    -1,   500,    -1,   504,    -1,   505,    -1,
     506,    -1,   507,    -1,   514,    -1,   509,    -1,   513,    -1,
     510,    -1,   515,    -1,   516,    -1,   519,    -1,   520,    -1,
     531,    -1,   532,    -1,   522,    -1,   523,    -1,   524,    -1,
     525,    -1,   537,    -1,   538,    -1,   539,    -1,   185,    -1,
     541,    -1,   542,    -1,   545,    -1,   544,    -1,   551,    -1,
     554,    -1,   558,    -1,   559,    -1,   569,    -1,   573,    -1,
     566,    -1,   575,    -1,   574,    -1,   576,    -1,   583,    -1,
     586,    -1,   588,    -1,   591,    -1,    -1,   455,  1370,  1369,
    1371,    -1,    -1,   353,    -1,  1372,    -1,  1371,   604,  1372,
      -1,    -1,  1373,  1378,    -1,  1375,    -1,   191,    -1,   259,
      -1,   452,    -1,    -1,   348,    -1,    -1,   191,    -1,   259,
      -1,   452,    -1,    -1,   191,   610,    -1,   259,   610,    -1,
     452,   610,    -1,  1379,    -1,  1375,  1380,    -1,  1374,  1381,
    1241,  1384,    -1,  1374,   531,   234,   250,  1382,    -1,   609,
    1364,  1241,  1073,    -1,   609,   609,  1377,  1381,  1241,  1384,
      -1,   912,   917,    -1,   322,  1241,  1073,    -1,   322,   914,
     919,    -1,   371,  1241,  1383,    -1,   371,   180,  1365,  1241,
    1383,    -1,  1362,    -1,  1362,   610,  1362,    -1,   119,   610,
    1362,    -1,   398,   541,    -1,   398,    74,    -1,   419,   398,
      -1,   450,    -1,   518,    -1,   371,   602,   518,   603,    -1,
     346,   602,   518,   603,    -1,  1073,    -1,   119,    -1,   347,
      -1,    12,    -1,    33,    -1,    -1,   262,  1387,  1386,  1388,
      -1,   512,    -1,   509,    -1,  1389,    -1,  1388,   604,  1389,
      -1,  1355,  1166,  1390,    -1,   398,    -1,   585,    -1,   270,
     585,    -1,   398,   259,    -1,    -1,   552,  1392,  1387,    -1,
     197,  1355,   350,  1166,    -1,   197,  1357,    65,    -1,    -1,
     197,  1357,   398,  1394,  1395,  1168,  1185,    -1,  1396,    -1,
    1362,  1397,    -1,   173,    -1,   332,    -1,   173,    -1,   332,
      -1,   382,    -1,   243,    -1,    -1,  1399,  1398,   602,  1246,
     603,    -1,   152,    -1,   186,    -1,   244,    -1,   196,    -1,
     271,    -1,   432,   659,  1401,    -1,  1405,   347,  1404,  1416,
     182,  1418,    -1,  1405,   347,   185,  1416,   182,  1418,    -1,
    1405,   347,   385,  1416,   182,  1418,    -1,    12,  1406,   604,
     192,   353,   182,  1418,    -1,   390,   347,  1365,   182,  1418,
      -1,   192,   659,  1403,    -1,  1405,   347,  1404,  1416,   529,
    1418,  1423,  1424,    -1,  1405,   347,   185,  1416,   529,  1418,
    1423,  1424,    -1,  1405,   347,   385,  1416,   529,  1418,  1423,
    1424,    -1,   390,   347,  1365,   529,  1418,  1425,    -1,    -1,
     512,    -1,  1407,    -1,    12,  1406,    -1,    -1,   384,    -1,
    1408,    -1,  1407,   604,  1408,    -1,    -1,   447,  1409,  1420,
      -1,    -1,   223,  1410,  1420,    -1,    -1,   555,  1411,  1420,
      -1,    -1,   406,  1412,  1420,    -1,   123,    -1,   557,    -1,
     217,    -1,    13,    -1,    94,    -1,   136,    -1,   161,    -1,
     414,    -1,   461,    -1,   386,    -1,   172,    -1,   192,   353,
      -1,   460,   103,    -1,   504,    -1,    94,   515,   509,    -1,
     262,   509,    -1,   422,   465,    -1,   422,    64,    -1,    94,
     573,    -1,   460,   573,    -1,    94,   436,    -1,    13,   436,
      -1,    94,   558,    -1,   159,    -1,   533,    -1,    94,   510,
      -1,    -1,    16,    -1,  1415,  1413,  1414,    -1,  1415,    -1,
     499,   518,    -1,   235,   518,    -1,    62,   518,    -1,   597,
      -1,  1362,   610,   597,    -1,   597,   610,   597,    -1,  1355,
      -1,  1365,    -1,  1417,   604,  1365,    -1,  1419,    -1,  1418,
     604,  1419,    -1,  1365,   210,    46,   518,    -1,  1365,   210,
      46,   371,   518,    -1,  1365,   210,   580,  1364,    -1,  1365,
     210,   580,  1364,    18,  1359,    -1,  1365,    -1,    -1,   602,
    1421,   603,    -1,  1421,   604,  1422,    -1,  1422,    -1,  1362,
      -1,    -1,   423,  1414,    -1,   423,   486,    -1,   423,   586,
      -1,   423,   334,    -1,    -1,   580,  1426,    -1,    -1,   580,
     192,   353,    -1,  1426,  1427,    -1,  1427,    -1,   192,   353,
      -1,   291,  1190,    -1,   295,  1190,    -1,   290,  1190,    -1,
     296,  1190,    -1,    -1,    30,  1429,  1430,    -1,    -1,   583,
      -1,    -1,    16,   338,    55,    -1,    16,    55,    -1,    -1,
     413,    -1,   338,   413,    -1,    -1,   441,    -1,    75,  1430,
    1431,  1432,    -1,   434,  1430,  1431,  1432,    -1,   434,  1430,
     529,  1433,  1362,    -1,   441,  1362,    -1,   413,   441,  1362,
      -1,    -1,  1439,    -1,    -1,   549,  1446,  1440,  1053,    -1,
      -1,  1439,    -1,  1443,    -1,    -1,  1443,    -1,    -1,  1444,
    1445,    -1,  1180,  1184,    -1,  1186,    -1,    -1,   132,    -1,
      12,    -1,   447,  1136,    -1,   602,  1055,   603,    -1,  1447,
    1442,    -1,    -1,  1448,   549,  1446,  1449,  1447,  1442,    -1,
    1451,  1448,  1452,    -1,    -1,    -1,    -1,  1454,    -1,  1454,
    1455,    -1,  1455,    -1,   495,    -1,   202,    -1,   132,    -1,
     483,    -1,   478,    -1,   479,    -1,   481,    -1,    12,    -1,
    1461,  1457,    -1,  1460,  1458,    -1,  1462,  1459,  1466,    -1,
    1466,    -1,  1474,    -1,  1485,    -1,  1479,    -1,   646,    -1,
    1466,    -1,  1474,    -1,  1485,    -1,  1479,    -1,  1478,    -1,
     646,    -1,  1460,    -1,  1461,    -1,    -1,   120,   152,  1365,
      -1,  1463,    -1,  1463,  1464,    -1,  1464,    -1,   358,   421,
      -1,    11,   152,   542,    -1,    11,   152,   303,    -1,    11,
     152,   516,    -1,    -1,   484,   446,   120,    -1,   484,   446,
     229,    -1,    -1,  1465,   573,  1355,  1467,  1468,    18,  1470,
      -1,    -1,   602,  1469,   603,    -1,  1362,    -1,  1469,   604,
    1362,    -1,    -1,  1471,  1472,  1473,    -1,   447,  1056,    -1,
     602,  1054,   603,  1441,    -1,    -1,   580,    61,   353,    -1,
     580,    51,    61,   353,    -1,   580,   259,    61,   353,    -1,
      -1,    -1,    -1,   533,  1069,   660,   754,   755,   347,  1069,
    1475,  1355,   180,  1069,  1476,   141,   439,  1477,   704,    -1,
      10,  1069,   185,  1362,   430,   877,   470,  1359,    -1,  1069,
     185,  1362,   430,   877,   470,  1359,    -1,    -1,    -1,    -1,
      -1,    -1,  1069,   185,   660,   602,  1480,   671,   603,  1481,
     430,  1482,   910,  1483,   662,  1484,   704,    -1,    -1,    -1,
      -1,    -1,   385,  1069,   660,  1486,   602,  1487,   675,   603,
    1488,   662,  1489,   704,    -1,   587,  1492,  1491,  1493,    -1,
     587,   146,  1491,  1495,    -1,   587,   380,  1491,    -1,   587,
      75,  1491,  1494,    -1,   587,   434,  1491,    -1,   587,   402,
      -1,  1343,    -1,  1343,   604,  1343,    -1,  1343,   604,  1343,
     604,  1190,    -1,    30,    -1,   489,    -1,    -1,   237,    -1,
     429,    -1,    -1,   349,   372,    -1,    -1,    -1,   505,  1496,
    1497,    -1,    -1,   180,   306,    -1,   225,   374,  1362,   470,
    1359,    -1,   548,   374,  1362,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1663,  1663,  1676,  1675,  1700,  1707,  1709,  1713,  1714,
    1719,  1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,  1728,
    1729,  1730,  1731,  1732,  1733,  1734,  1735,  1736,  1737,  1738,
    1739,  1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,
    1749,  1750,  1751,  1752,  1753,  1754,  1755,  1756,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1773,  1783,  1784,  1788,  1798,  1805,  1816,  1815,  1826,
    1828,  1832,  1833,  1837,  1850,  1849,  1869,  1868,  1882,  1883,
    1887,  1891,  1895,  1899,  1903,  1907,  1912,  1916,  1920,  1924,
    1928,  1932,  1938,  1969,  1974,  1977,  1979,  1980,  1984,  1998,
    2002,  2018,  2022,  2034,  2033,  2075,  2074,  2086,  2084,  2097,
    2095,  2107,  2106,  2119,  2118,  2126,  2130,  2134,  2138,  2145,
    2158,  2159,  2163,  2167,  2171,  2175,  2179,  2183,  2187,  2195,
    2194,  2226,  2225,  2232,  2239,  2240,  2246,  2252,  2262,  2268,
    2274,  2276,  2283,  2284,  2288,  2294,  2303,  2304,  2312,  2312,
    2370,  2371,  2372,  2373,  2374,  2375,  2376,  2377,  2378,  2379,
    2380,  2381,  2382,  2387,  2401,  2417,  2436,  2437,  2441,  2442,
    2447,  2449,  2451,  2453,  2455,  2457,  2459,  2465,  2466,  2467,
    2471,  2475,  2483,  2482,  2495,  2497,  2500,  2502,  2506,  2510,
    2517,  2519,  2523,  2524,  2529,  2548,  2574,  2576,  2580,  2581,
    2585,  2611,  2612,  2613,  2614,  2618,  2619,  2623,  2624,  2629,
    2632,  2659,  2658,  2723,  2739,  2738,  2792,  2818,  2818,  2841,
    2842,  2847,  2849,  2854,  2877,  2890,  2894,  2911,  2912,  2916,
    2920,  2929,  2936,  2943,  2953,  2968,  2991,  2997,  2998,  3004,
    3007,  3011,  3019,  3039,  3041,  3059,  3065,  3067,  3069,  3071,
    3073,  3075,  3077,  3079,  3081,  3083,  3085,  3087,  3092,  3107,
    3122,  3140,  3141,  3145,  3146,  3147,  3148,  3149,  3150,  3151,
    3152,  3153,  3154,  3155,  3156,  3157,  3162,  3161,  3168,  3168,
    3225,  3224,  3253,  3253,  3267,  3320,  3363,  3384,  3383,  3405,
    3424,  3426,  3427,  3431,  3451,  3474,  3476,  3492,  3474,  3511,
    3513,  3514,  3518,  3519,  3524,  3530,  3523,  3551,  3550,  3566,
    3567,  3571,  3572,  3577,  3581,  3576,  3602,  3606,  3601,  3625,
    3635,  3640,  3639,  3675,  3676,  3681,  3680,  3713,  3713,  3728,
    3727,  3763,  3775,  3777,  3774,  3804,  3803,  3824,  3826,  3831,
    3833,  3835,  3852,  3857,  3863,  3870,  3871,  3879,  3885,  3894,
    3900,  3906,  3907,  3911,  3911,  3916,  3917,  3918,  3922,  3923,
    3924,  3928,  3932,  3933,  3934,  3938,  3939,  3940,  3941,  3942,
    3943,  3944,  3945,  3949,  3953,  3954,  3955,  3959,  3960,  3961,
    3962,  3963,  3967,  3971,  3972,  3973,  3977,  3978,  3979,  3980,
    3981,  3982,  3983,  3987,  3991,  3992,  3993,  3997,  3998,  3999,
    4004,  4012,  4020,  4028,  4040,  4052,  4057,  4062,  4070,  4078,
    4086,  4094,  4102,  4110,  4118,  4131,  4144,  4157,  4159,  4163,
    4168,  4181,  4182,  4233,  4234,  4237,  4252,  4270,  4275,  4273,
    4280,  4282,  4281,  4285,  4284,  4290,  4327,  4328,  4333,  4332,
    4351,  4370,  4369,  4386,  4390,  4398,  4397,  4400,  4402,  4404,
    4406,  4411,  4412,  4418,  4419,  4436,  4437,  4441,  4442,  4446,
    4465,  4475,  4486,  4495,  4496,  4512,  4514,  4513,  4518,  4516,
    4527,  4528,  4532,  4550,  4566,  4567,  4583,  4598,  4620,  4621,
    4626,  4625,  4649,  4659,  4681,  4680,  4698,  4697,  4717,  4739,
    4743,  4772,  4784,  4785,  4790,  4801,  4789,  4826,  4827,  4831,
    4844,  4865,  4878,  4904,  4905,  4910,  4909,  4946,  4951,  4952,
    4956,  4957,  4961,  4963,  4969,  4971,  4973,  4975,  4977,  4979,
    4989,  5004,  4988,  5018,  5019,  5023,  5024,  5028,  5029,  5033,
    5034,  5038,  5039,  5043,  5044,  5048,  5052,  5053,  5056,  5058,
    5062,  5063,  5067,  5068,  5069,  5073,  5078,  5083,  5088,  5093,
    5098,  5103,  5108,  5123,  5129,  5134,  5139,  5144,  5150,  5149,
    5175,  5176,  5177,  5182,  5187,  5192,  5194,  5196,  5198,  5204,
    5212,  5230,  5247,  5270,  5284,  5285,  5286,  5287,  5288,  5289,
    5293,  5294,  5295,  5299,  5300,  5304,  5305,  5306,  5307,  5312,
    5319,  5320,  5324,  5325,  5329,  5330,  5337,  5342,  5348,  5354,
    5360,  5378,  5384,  5386,  5390,  5394,  5395,  5399,  5404,  5403,
    5426,  5427,  5428,  5429,  5434,  5438,  5443,  5448,  5452,  5457,
    5462,  5468,  5473,  5479,  5483,  5488,  5493,  5511,  5513,  5515,
    5528,  5530,  5535,  5540,  5552,  5557,  5562,  5567,  5569,  5571,
    5573,  5575,  5577,  5579,  5581,  5584,  5583,  5588,  5587,  5591,
    5593,  5602,  5603,  5604,  5610,  5611,  5612,  5613,  5614,  5618,
    5622,  5623,  5627,  5628,  5632,  5633,  5634,  5635,  5636,  5640,
    5641,  5642,  5643,  5644,  5648,  5653,  5655,  5661,  5662,  5664,
    5669,  5678,  5679,  5683,  5684,  5688,  5689,  5690,  5694,  5695,
    5696,  5697,  5700,  5701,  5705,  5706,  5710,  5711,  5715,  5716,
    5720,  5721,  5722,  5723,  5730,  5731,  5737,  5743,  5749,  5755,
    5756,  5773,  5794,  5800,  5805,  5806,  5810,  5818,  5822,  5823,
    5827,  5828,  5832,  5841,  5845,  5846,  5850,  5861,  5862,  5866,
    5867,  5871,  5872,  5877,  5878,  5882,  5889,  5898,  5906,  5917,
    5918,  5919,  5920,  5921,  5922,  5927,  5935,  5936,  5940,  5942,
    5946,  5958,  5959,  5963,  5970,  5983,  5984,  5986,  5988,  5994,
    5999,  6005,  6011,  6018,  6028,  6029,  6030,  6031,  6032,  6036,
    6040,  6041,  6045,  6046,  6050,  6051,  6055,  6056,  6057,  6061,
    6062,  6066,  6070,  6083,  6095,  6096,  6100,  6101,  6105,  6106,
    6110,  6111,  6115,  6116,  6120,  6121,  6125,  6126,  6130,  6131,
    6135,  6137,  6141,  6142,  6146,  6150,  6151,  6164,  6165,  6166,
    6170,  6171,  6175,  6181,  6195,  6196,  6200,  6201,  6205,  6206,
    6214,  6213,  6252,  6251,  6265,  6277,  6276,  6295,  6294,  6313,
    6312,  6331,  6325,  6345,  6344,  6377,  6382,  6387,  6392,  6397,
    6407,  6408,  6409,  6410,  6414,  6415,  6427,  6428,  6432,  6433,
    6436,  6438,  6439,  6440,  6442,  6444,  6445,  6454,  6455,  6459,
    6468,  6466,  6480,  6494,  6493,  6507,  6505,  6519,  6526,  6537,
    6541,  6548,  6552,  6557,  6556,  6572,  6574,  6579,  6587,  6586,
    6602,  6606,  6605,  6617,  6618,  6622,  6637,  6638,  6642,  6651,
    6655,  6660,  6665,  6664,  6675,  6684,  6674,  6699,  6708,  6712,
    6721,  6730,  6736,  6742,  6751,  6760,  6779,  6800,  6810,  6814,
    6822,  6823,  6827,  6828,  6832,  6833,  6834,  6838,  6839,  6840,
    6844,  6845,  6846,  6847,  6856,  6855,  6866,  6874,  6873,  6883,
    6892,  6901,  6902,  6909,  6909,  6915,  6916,  6920,  6921,  6922,
    6926,  6927,  6943,  6944,  6949,  6948,  6960,  6961,  6962,  6967,
    6966,  6988,  6989,  6993,  6994,  6998,  6999,  7000,  7005,  7004,
    7026,  7035,  7034,  7061,  7062,  7066,  7067,  7071,  7072,  7073,
    7074,  7075,  7076,  7081,  7080,  7102,  7103,  7104,  7109,  7108,
    7114,  7121,  7126,  7134,  7135,  7139,  7153,  7152,  7165,  7166,
    7170,  7171,  7175,  7185,  7195,  7196,  7201,  7200,  7211,  7212,
    7216,  7217,  7221,  7231,  7242,  7241,  7249,  7249,  7260,  7261,
    7266,  7267,  7276,  7285,  7286,  7290,  7295,  7300,  7305,  7310,
    7309,  7329,  7337,  7329,  7344,  7345,  7346,  7347,  7348,  7352,
    7359,  7366,  7368,  7379,  7380,  7384,  7385,  7413,  7443,  7445,
    7451,  7461,  7462,  7463,  7478,  7485,  7511,  7517,  7523,  7524,
    7525,  7526,  7527,  7531,  7532,  7537,  7588,  7595,  7638,  7644,
    7650,  7656,  7662,  7668,  7674,  7680,  7684,  7690,  7696,  7702,
    7708,  7714,  7718,  7724,  7734,  7740,  7748,  7754,  7764,  7770,
    7779,  7789,  7795,  7805,  7811,  7820,  7824,  7830,  7836,  7842,
    7848,  7854,  7860,  7866,  7872,  7878,  7884,  7890,  7896,  7902,
    7908,  7912,  7913,  7917,  7918,  7922,  7923,  7927,  7928,  7932,
    7933,  7934,  7935,  7936,  7937,  7941,  7942,  7946,  7947,  7948,
    7949,  7950,  7951,  7963,  7964,  7965,  7966,  7967,  7973,  7977,
    7983,  7989,  7995,  8001,  8003,  8010,  8017,  8023,  8025,  8034,
    8041,  8049,  8055,  8062,  8068,  8082,  8089,  8105,  8111,  8117,
    8125,  8131,  8137,  8143,  8149,  8164,  8176,  8182,  8188,  8194,
    8200,  8206,  8212,  8218,  8224,  8230,  8236,  8242,  8248,  8254,
    8260,  8266,  8272,  8280,  8301,  8308,  8314,  8321,  8328,  8335,
    8342,  8349,  8355,  8361,  8368,  8375,  8381,  8388,  8394,  8400,
    8406,  8412,  8418,  8436,  8446,  8452,  8458,  8465,  8472,  8487,
    8493,  8499,  8505,  8511,  8518,  8524,  8530,  8536,  8542,  8554,
    8560,  8566,  8572,  8578,  8590,  8596,  8612,  8618,  8625,  8632,
    8639,  8646,  8653,  8657,  8677,  8676,  8749,  8791,  8793,  8798,
    8799,  8803,  8804,  8808,  8809,  8813,  8820,  8828,  8854,  8860,
    8866,  8872,  8878,  8884,  8893,  8900,  8902,  8899,  8909,  8920,
    8926,  8932,  8938,  8944,  8950,  8956,  8962,  8968,  8975,  8974,
    8994,  8993,  9008,  9018,  9026,  9042,  9043,  9048,  9053,  9056,
    9059,  9058,  9075,  9077,  9083,  9082,  9099,  9101,  9103,  9105,
    9107,  9109,  9111,  9113,  9115,  9117,  9119,  9124,  9125,  9129,
    9136,  9144,  9145,  9149,  9156,  9164,  9165,  9169,  9170,  9174,
    9182,  9193,  9194,  9203,  9214,  9215,  9221,  9222,  9242,  9244,
    9248,  9246,  9263,  9261,  9279,  9277,  9284,  9293,  9291,  9309,
    9308,  9318,  9329,  9327,  9346,  9345,  9356,  9367,  9368,  9369,
    9381,  9381,  9395,  9435,  9507,  9518,  9523,  9515,  9542,  9562,
    9570,  9562,  9579,  9578,  9601,  9618,  9601,  9625,  9629,  9655,
    9656,  9661,  9664,  9665,  9666,  9670,  9671,  9676,  9675,  9681,
    9680,  9688,  9689,  9692,  9694,  9694,  9698,  9698,  9703,  9704,
    9708,  9710,  9715,  9716,  9720,  9731,  9744,  9745,  9746,  9747,
    9748,  9749,  9750,  9751,  9752,  9753,  9754,  9755,  9759,  9760,
    9761,  9762,  9763,  9764,  9765,  9766,  9767,  9771,  9772,  9773,
    9774,  9777,  9779,  9780,  9784,  9785,  9793,  9795,  9799,  9801,
    9800,  9814,  9817,  9816,  9831,  9837,  9852,  9854,  9858,  9860,
    9865,  9866,  9886,  9911,  9915,  9916,  9920,  9933,  9935,  9940,
    9939,  9974,  9976,  9981,  9982,  9983,  9988,  9994,  9998,  9999,
   10003, 10010, 10017, 10024, 10034, 10068, 10072, 10078, 10084, 10094,
   10098, 10108, 10109, 10110, 10111, 10112, 10113, 10117, 10118, 10119,
   10120, 10121, 10125, 10126, 10127, 10128, 10129, 10133, 10134, 10135,
   10136, 10140, 10145, 10146, 10149, 10152, 10151, 10182, 10183, 10187,
   10188, 10192, 10204, 10204, 10214, 10215, 10219, 10238, 10271, 10270,
   10283, 10291, 10282, 10293, 10305, 10317, 10316, 10334, 10333, 10344,
   10344, 10360, 10367, 10390, 10411, 10423, 10428, 10427, 10437, 10443,
   10450, 10455, 10460, 10470, 10471, 10475, 10486, 10487, 10491, 10502,
   10503, 10507, 10508, 10516, 10524, 10515, 10534, 10541, 10533, 10551,
   10563, 10564, 10572, 10576, 10577, 10588, 10589, 10593, 10602, 10603,
   10604, 10606, 10605, 10616, 10617, 10621, 10622, 10624, 10623, 10627,
   10626, 10632, 10633, 10637, 10638, 10642, 10652, 10653, 10657, 10658,
   10663, 10662, 10676, 10677, 10681, 10686, 10694, 10695, 10703, 10705,
   10705, 10713, 10721, 10712, 10743, 10744, 10748, 10756, 10757, 10761,
   10771, 10772, 10779, 10778, 10794, 10793, 10805, 10804, 10816, 10815,
   10829, 10830, 10834, 10847, 10863, 10864, 10868, 10869, 10873, 10874,
   10875, 10880, 10879, 10901, 10903, 10906, 10908, 10911, 10912, 10915,
   10919, 10923, 10927, 10931, 10935, 10939, 10943, 10947, 10955, 10958,
   10968, 10967, 10982, 10989, 10997, 11005, 11013, 11021, 11029, 11036,
   11038, 11040, 11049, 11053, 11058, 11057, 11063, 11062, 11067, 11076,
   11083, 11092, 11101, 11106, 11108, 11110, 11112, 11114, 11116, 11123,
   11131, 11133, 11141, 11148, 11155, 11165, 11172, 11178, 11187, 11195,
   11199, 11203, 11210, 11217, 11223, 11230, 11237, 11242, 11247, 11255,
   11257, 11259, 11264, 11265, 11268, 11270, 11274, 11275, 11279, 11280,
   11284, 11285, 11289, 11290, 11294, 11295, 11298, 11300, 11307, 11318,
   11317, 11333, 11332, 11342, 11343, 11347, 11348, 11349, 11353, 11354,
   11355, 11370, 11369, 11382, 11391, 11381, 11393, 11397, 11398, 11412,
   11413, 11418, 11420, 11422, 11424, 11426, 11428, 11430, 11432, 11434,
   11436, 11438, 11440, 11445, 11447, 11449, 11454, 11455, 11460, 11459,
   11469, 11470, 11474, 11474, 11476, 11477, 11481, 11482, 11487, 11486,
   11497, 11501, 11505, 11517, 11527, 11528, 11529, 11535, 11547, 11559,
   11569, 11579, 11546, 11587, 11588, 11592, 11593, 11597, 11598, 11610,
   11614, 11615, 11616, 11619, 11621, 11625, 11626, 11630, 11635, 11642,
   11647, 11654, 11656, 11660, 11661, 11665, 11670, 11678, 11679, 11682,
   11684, 11692, 11694, 11698, 11699, 11700, 11704, 11706, 11711, 11712,
   11721, 11722, 11726, 11727, 11731, 11751, 11775, 11787, 11798, 11817,
   11825, 11837, 11852, 11873, 11874, 11875, 11883, 11884, 11885, 11892,
   11898, 11904, 11910, 11916, 11945, 11973, 11974, 11975, 11979, 11989,
   11999, 12005, 12014, 12029, 12030, 12034, 12043, 12059, 12063, 12110,
   12114, 12132, 12136, 12215, 12240, 12271, 12272, 12288, 12298, 12302,
   12308, 12314, 12324, 12330, 12339, 12349, 12350, 12380, 12396, 12412,
   12429, 12430, 12441, 12442, 12453, 12454, 12455, 12459, 12476, 12498,
   12513, 12514, 12515, 12516, 12517, 12518, 12519, 12520, 12521, 12522,
   12523, 12524, 12525, 12526, 12527, 12528, 12529, 12530, 12531, 12532,
   12533, 12534, 12535, 12536, 12537, 12538, 12539, 12540, 12541, 12542,
   12543, 12544, 12545, 12546, 12547, 12548, 12549, 12550, 12551, 12552,
   12553, 12554, 12555, 12556, 12557, 12558, 12559, 12560, 12561, 12562,
   12572, 12573, 12574, 12575, 12576, 12577, 12578, 12579, 12580, 12581,
   12582, 12583, 12584, 12585, 12586, 12587, 12588, 12589, 12590, 12591,
   12592, 12593, 12594, 12595, 12596, 12597, 12598, 12599, 12600, 12601,
   12602, 12603, 12604, 12605, 12606, 12607, 12608, 12609, 12610, 12611,
   12612, 12613, 12614, 12615, 12616, 12617, 12618, 12619, 12620, 12621,
   12622, 12623, 12624, 12625, 12626, 12627, 12628, 12629, 12630, 12631,
   12632, 12633, 12634, 12635, 12636, 12637, 12638, 12639, 12640, 12641,
   12642, 12643, 12644, 12645, 12646, 12647, 12648, 12649, 12650, 12651,
   12652, 12653, 12654, 12655, 12656, 12657, 12658, 12659, 12660, 12661,
   12662, 12663, 12664, 12665, 12666, 12667, 12668, 12669, 12670, 12671,
   12672, 12673, 12674, 12675, 12676, 12677, 12678, 12679, 12680, 12681,
   12682, 12683, 12684, 12685, 12686, 12687, 12688, 12689, 12690, 12691,
   12692, 12693, 12694, 12695, 12696, 12697, 12698, 12699, 12700, 12701,
   12702, 12703, 12704, 12705, 12706, 12707, 12708, 12709, 12710, 12711,
   12712, 12713, 12714, 12715, 12716, 12717, 12718, 12719, 12720, 12721,
   12722, 12723, 12724, 12725, 12726, 12727, 12728, 12729, 12730, 12731,
   12732, 12733, 12734, 12735, 12736, 12737, 12738, 12739, 12740, 12741,
   12742, 12743, 12744, 12745, 12746, 12747, 12748, 12749, 12750, 12751,
   12752, 12753, 12754, 12755, 12756, 12757, 12758, 12759, 12760, 12761,
   12762, 12763, 12764, 12765, 12766, 12767, 12768, 12769, 12770, 12771,
   12772, 12773, 12774, 12775, 12776, 12777, 12778, 12779, 12780, 12781,
   12782, 12783, 12784, 12785, 12786, 12787, 12788, 12789, 12790, 12791,
   12792, 12793, 12794, 12795, 12796, 12797, 12798, 12799, 12800, 12801,
   12802, 12803, 12804, 12805, 12806, 12807, 12808, 12809, 12810, 12811,
   12812, 12813, 12814, 12815, 12816, 12817, 12818, 12819, 12820, 12821,
   12822, 12823, 12824, 12825, 12826, 12827, 12828, 12829, 12830, 12831,
   12832, 12833, 12834, 12835, 12836, 12837, 12838, 12839, 12840, 12841,
   12842, 12843, 12844, 12845, 12846, 12847, 12848, 12849, 12856, 12855,
   12870, 12871, 12875, 12876, 12880, 12880, 12962, 12963, 12964, 12965,
   12969, 12970, 12974, 12975, 12976, 12977, 12981, 12982, 12983, 12984,
   12988, 12989, 12993, 13035, 13054, 13065, 13078, 13092, 13107, 13126,
   13153, 13166, 13193, 13236, 13250, 13251, 13252, 13253, 13257, 13258,
   13267, 13279, 13280, 13281, 13287, 13293, 13305, 13304, 13320, 13321,
   13325, 13326, 13330, 13343, 13344, 13345, 13346, 13351, 13350, 13370,
   13382, 13395, 13394, 13427, 13428, 13432, 13433, 13437, 13438, 13439,
   13440, 13442, 13441, 13454, 13455, 13456, 13457, 13458, 13464, 13469,
   13475, 13486, 13497, 13501, 13511, 13516, 13523, 13535, 13547, 13556,
   13558, 13562, 13563, 13570, 13572, 13576, 13577, 13582, 13581, 13585,
   13584, 13588, 13587, 13591, 13590, 13593, 13594, 13595, 13596, 13597,
   13598, 13599, 13600, 13601, 13602, 13603, 13604, 13605, 13606, 13607,
   13608, 13609, 13610, 13611, 13612, 13613, 13614, 13615, 13616, 13617,
   13618, 13622, 13623, 13627, 13628, 13632, 13642, 13652, 13665, 13680,
   13693, 13706, 13718, 13723, 13731, 13736, 13744, 13773, 13780, 13788,
   13796, 13802, 13806, 13810, 13811, 13815, 13842, 13844, 13848, 13852,
   13856, 13863, 13864, 13868, 13869, 13873, 13874, 13878, 13879, 13885,
   13891, 13897, 13907, 13906, 13916, 13917, 13922, 13923, 13924, 13929,
   13930, 13931, 13935, 13936, 13940, 13952, 13961, 13971, 13980, 13994,
   13995, 14000, 13999, 14015, 14016, 14017, 14021, 14022, 14026, 14026,
   14050, 14051, 14055, 14056, 14057, 14061, 14065, 14072, 14075, 14073,
   14089, 14096, 14117, 14141, 14143, 14147, 14148, 14152, 14153, 14161,
   14162, 14163, 14164, 14170, 14176, 14186, 14188, 14190, 14195, 14196,
   14197, 14198, 14199, 14203, 14204, 14205, 14206, 14207, 14208, 14218,
   14219, 14224, 14237, 14250, 14252, 14254, 14259, 14264, 14266, 14268,
   14274, 14275, 14277, 14283, 14282, 14300, 14301, 14305, 14310, 14318,
   14318, 14343, 14344, 14349, 14350, 14352, 14354, 14372, 14378, 14383,
   14365, 14445, 14463, 14488, 14520, 14524, 14532, 14555, 14484, 14620,
   14644, 14653, 14661, 14619, 14682, 14686, 14690, 14694, 14698, 14702,
   14709, 14716, 14723, 14733, 14734, 14738, 14739, 14740, 14744, 14745,
   14750, 14752, 14751, 14757, 14758, 14762, 14772
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM",
  "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM",
  "CONTRIBUTORS_SYM", "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM",
  "CURSOR_NAME_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFINER_SYM", "DELAYED_SYM",
  "DELAY_KEY_WRITE_SYM", "DELETE_SYM", "DESC", "DESCRIBE", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISK_SYM", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP",
  "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM",
  "ELSE", "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM",
  "EXPANSION_SYM", "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM", "FROM", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES",
  "INDEX_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM", "INOUT_SYM",
  "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM",
  "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM", "LINES",
  "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM",
  "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE",
  "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM",
  "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM",
  "PACK_KEYS_SYM", "PAGE_SYM", "PARAM_MARKER", "PARSER_SYM", "PARTIAL",
  "PARTITIONING_SYM", "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD",
  "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM", "POLYGON",
  "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM", "PURGE",
  "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM",
  "STRAIGHT_JOIN", "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM",
  "SUBJECT_SYM", "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING",
  "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM",
  "SYSDATE", "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "ULONGLONG_NUM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM", "UNICODE_SYM", "UNINSTALL_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED",
  "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM", "USAGE", "USER", "USE_FRM",
  "USE_SYM", "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "VIEW_SYM", "WAIT_SYM",
  "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH",
  "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM", "WRAPPER_SYM",
  "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR", "YEAR_MONTH_SYM",
  "YEAR_SYM", "ZEROFILL", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'",
  "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'",
  "'.'", "':'", "$accept", "query", "$@1", "opt_end_of_input",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "$@2", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "$@3", "change", "$@4",
  "master_defs", "master_def", "ignore_server_id_list", "ignore_server_id",
  "master_file_def", "create", "$@5", "$@6", "$@7", "$@8", "$@9", "$@10",
  "server_def", "server_options_list", "server_option", "event_tail",
  "$@11", "ev_schedule_time", "$@12", "opt_ev_status", "ev_starts",
  "ev_ends", "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@13", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@14", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@15", "$@16", "sp_cursor_stmt", "$@17",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@18", "sp_proc_stmt_statement", "$@19", "sp_proc_stmt_return", "$@20",
  "sp_proc_stmt_unlabeled", "$@21", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@22", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@23", "$@24", "$@25", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@26", "$@27", "searched_case_stmt", "$@28",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@29", "$@30", "searched_when_clause", "$@31",
  "$@32", "else_clause_opt", "sp_labeled_control", "$@33", "sp_opt_label",
  "sp_labeled_block", "$@34", "sp_unlabeled_block", "$@35",
  "sp_block_content", "$@36", "sp_unlabeled_control", "$@37", "$@38",
  "$@39", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@40", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "$@41", "create3", "$@42", "$@43", "opt_create_partitioning",
  "opt_partitioning", "partitioning", "$@44", "have_partitioning",
  "partition_entry", "$@45", "partition", "part_type_def", "$@46",
  "opt_linear", "opt_key_algo", "part_field_list", "part_field_item_list",
  "part_field_item", "part_column_list", "part_func", "sub_part_func",
  "opt_num_parts", "opt_sub_part", "$@47", "$@48", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_num_subparts", "part_defs",
  "part_def_list", "part_definition", "$@49", "part_name",
  "opt_part_values", "$@50", "$@51", "part_func_max", "part_values_in",
  "part_value_list", "part_value_item", "$@52", "$@53",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@54", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@55", "$@56", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@57", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@58", "type", "$@59", "$@60",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "field_length", "opt_field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@61", "$@62", "$@63", "$@64", "$@65", "$@66",
  "$@67", "ev_alter_on_schedule_completion", "opt_ev_rename_to",
  "opt_ev_sql_stmt", "ident_or_empty", "alter_commands", "$@68", "$@69",
  "$@70", "remove_partitioning", "all_or_alt_part_name_list",
  "add_partition_rule", "$@71", "add_part_extra", "reorg_partition_rule",
  "$@72", "reorg_parts_rule", "$@73", "alt_part_name_list",
  "alt_part_name_item", "alter_list", "add_column", "alter_list_item",
  "$@74", "$@75", "$@76", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@77", "$@78", "start",
  "start_transaction_opts", "slave_thread_opts", "$@79",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@80", "opt_checksum_type", "repair",
  "$@81", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@82", "binlog_base64_event", "check", "$@83",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@84", "opt_no_write_to_binlog", "rename", "$@85", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@86",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@87",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@88", "cache_keys_spec", "$@89",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@90",
  "select_part2", "$@91", "$@92", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@93", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@94", "$@95", "$@96",
  "variable", "$@97", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@98", "gorder_list",
  "in_sum_expr", "$@99", "cast_type", "opt_expr_list", "expr_list",
  "ident_list_arg", "ident_list", "opt_expr", "opt_else", "when_list",
  "table_ref", "join_table_list", "esc_table_ref", "derived_table_list",
  "join_table", "$@100", "$@101", "$@102", "$@103", "$@104", "$@105",
  "$@106", "normal_join", "table_factor", "$@107", "select_derived_union",
  "$@108", "$@109", "select_init2_derived", "select_part2_derived",
  "$@110", "$@111", "select_derived", "$@112", "select_derived2", "$@113",
  "$@114", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@115",
  "$@116", "index_hints_list", "opt_index_hints_list", "$@117",
  "opt_key_definition", "$@118", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@119", "having_clause", "$@120", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@121", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_clause", "$@122", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@123",
  "select_var_list", "select_var_ident", "into", "$@124",
  "into_destination", "$@125", "$@126", "do", "$@127", "drop", "$@128",
  "$@129", "$@130", "table_list", "table_name", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "insert", "$@131",
  "$@132", "replace", "$@133", "$@134", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@135", "fields", "insert_values", "$@136", "$@137", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@138", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@139", "update", "$@140", "$@141", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@142", "single_multi", "$@143", "$@144", "$@145", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@146", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@147", "show_param",
  "$@148", "$@149", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@150", "$@151", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "$@152",
  "flush_options", "$@153", "$@154", "opt_with_read_lock",
  "flush_options_list", "flush_option", "opt_table_list", "reset", "$@155",
  "reset_options", "reset_option", "$@156", "slave_reset_options", "purge",
  "$@157", "purge_options", "purge_option", "kill", "kill_option", "use",
  "load", "$@158", "$@159", "$@160", "$@161", "data_or_xml", "opt_local",
  "load_data_lock", "opt_duplicate", "opt_field_term", "field_term_list",
  "field_term", "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "$@162", "opt_option", "option_value_list", "option_type_value",
  "$@163", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@164",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@165", "handler", "$@166", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@167",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@168", "$@169", "$@170",
  "$@171", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "grant_user",
  "opt_column_list", "column_list", "column_list_id", "require_clause",
  "grant_options", "opt_grant_option", "grant_option_list", "grant_option",
  "begin", "$@172", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "$@173", "union_opt",
  "opt_union_order_or_limit", "union_order_or_limit", "$@174",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@175", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@176",
  "view_list_opt", "view_list", "view_select", "$@177", "view_select_aux",
  "view_check_option", "trigger_tail", "$@178", "$@179", "$@180",
  "udf_tail", "sf_tail", "$@181", "$@182", "$@183", "$@184", "$@185",
  "sp_tail", "$@186", "$@187", "$@188", "$@189", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@190", "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   124,    38,    45,    43,    42,    47,    37,
      94,   126,    40,    41,    44,    33,   123,   125,    59,    64,
      46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   612,   613,   614,   613,   613,   615,   615,   616,   616,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   618,   619,   619,   620,   621,   621,   623,   622,   624,
     624,   625,   625,   626,   628,   627,   630,   629,   631,   631,
     632,   632,   632,   632,   632,   632,   632,   632,   632,   632,
     632,   632,   632,   632,   632,   633,   633,   633,   634,   635,
     635,   635,   635,   637,   636,   638,   636,   639,   636,   640,
     636,   641,   636,   642,   636,   636,   636,   636,   636,   643,
     644,   644,   645,   645,   645,   645,   645,   645,   645,   647,
     646,   649,   648,   648,   650,   650,   650,   650,   651,   651,
     652,   652,   653,   653,   654,   654,   655,   655,   657,   656,
     658,   658,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   659,   660,   660,   661,   661,   662,   662,
     663,   663,   663,   663,   663,   663,   663,   664,   664,   664,
     665,   665,   667,   666,   668,   668,   669,   669,   670,   670,
     671,   671,   672,   672,   673,   674,   675,   675,   676,   676,
     677,   678,   678,   678,   678,   679,   679,   680,   680,   681,
     681,   683,   682,   682,   684,   682,   682,   686,   685,   687,
     687,   688,   688,   689,   690,   690,   691,   692,   692,   693,
     693,   693,   693,   693,   694,   695,   695,   696,   696,   697,
     697,   698,   698,   699,   699,   699,   700,   700,   700,   700,
     700,   700,   700,   700,   700,   700,   700,   700,   701,   702,
     702,   703,   703,   704,   704,   704,   704,   704,   704,   704,
     704,   704,   704,   704,   704,   704,   706,   705,   708,   707,
     710,   709,   712,   711,   713,   714,   715,   717,   716,   718,
     719,   719,   719,   720,   720,   722,   723,   724,   721,   725,
     725,   725,   726,   726,   728,   729,   727,   731,   730,   732,
     732,   733,   733,   735,   736,   734,   738,   739,   737,   740,
     740,   742,   741,   743,   743,   745,   744,   747,   746,   749,
     748,   750,   751,   752,   750,   753,   750,   754,   754,   755,
     755,   755,   756,   757,   758,   759,   759,   760,   760,   761,
     762,   763,   763,   765,   764,   766,   766,   766,   767,   767,
     767,   768,   769,   769,   769,   770,   770,   770,   770,   770,
     770,   770,   770,   771,   772,   772,   772,   773,   773,   773,
     773,   773,   774,   775,   775,   775,   776,   776,   776,   776,
     776,   776,   776,   777,   778,   778,   778,   779,   779,   779,
     780,   781,   782,   783,   784,   785,   785,   785,   786,   787,
     788,   789,   790,   791,   792,   793,   794,   795,   795,   796,
     796,   797,   797,   798,   798,   798,   798,   799,   800,   799,
     801,   802,   801,   803,   801,   804,   805,   805,   807,   806,
     808,   810,   809,   811,   812,   813,   812,   812,   812,   812,
     812,   814,   814,   815,   815,   816,   816,   817,   817,   818,
     819,   820,   821,   822,   822,   823,   824,   823,   825,   823,
     826,   826,   827,   828,   829,   829,   830,   830,   831,   831,
     833,   832,   834,   835,   836,   835,   837,   835,   838,   838,
     839,   839,   840,   840,   842,   843,   841,   844,   844,   845,
     845,   846,   846,   847,   847,   849,   848,   850,   851,   851,
     852,   852,   853,   853,   853,   853,   853,   853,   853,   853,
     855,   856,   854,   857,   857,   858,   858,   859,   859,   860,
     860,   861,   861,   862,   862,   863,   864,   864,   865,   865,
     866,   866,   867,   867,   867,   868,   868,   868,   868,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   868,   868,
     870,   871,   872,   873,   874,   874,   874,   874,   874,   874,
     875,   875,   875,   876,   876,   877,   877,   877,   877,   878,
     879,   879,   880,   880,   881,   881,   882,   882,   882,   882,
     882,   882,   883,   883,   884,   885,   885,   886,   888,   887,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   890,   889,   891,   889,   889,
     889,   892,   892,   892,   892,   892,   892,   892,   892,   893,
     894,   894,   895,   895,   896,   896,   896,   896,   896,   897,
     897,   897,   897,   897,   898,   898,   898,   899,   899,   899,
     900,   901,   901,   902,   902,   903,   903,   903,   904,   904,
     904,   904,   905,   905,   906,   906,   907,   907,   908,   908,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   910,   911,   911,   912,   912,   913,   913,   914,   914,
     915,   915,   916,   916,   917,   917,   918,   919,   919,   920,
     920,   921,   921,   922,   922,   922,   923,   923,   923,   924,
     924,   924,   924,   924,   924,   924,   925,   925,   926,   926,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   931,   931,   931,   932,   932,   932,   932,   932,   933,
     934,   934,   935,   935,   936,   936,   937,   937,   937,   938,
     938,   939,   940,   941,   942,   942,   943,   943,   944,   944,
     945,   945,   946,   946,   947,   947,   948,   948,   949,   949,
     950,   950,   951,   951,   952,   953,   953,   954,   954,   954,
     955,   955,   956,   956,   957,   957,   958,   958,   959,   959,
     961,   960,   962,   960,   960,   963,   960,   964,   960,   965,
     960,   966,   960,   967,   960,   960,   960,   960,   960,   960,
     968,   968,   968,   968,   969,   969,   970,   970,   971,   971,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     973,   972,   972,   974,   972,   975,   972,   972,   972,   972,
     976,   977,   977,   979,   978,   980,   980,   980,   982,   981,
     983,   984,   983,   985,   985,   986,   987,   987,   988,   989,
     989,   989,   990,   989,   991,   992,   989,   989,   989,   989,
     989,   989,   989,   989,   989,   989,   989,   989,   989,   989,
     993,   993,   994,   994,   995,   995,   995,   996,   996,   996,
     997,   997,   997,   997,   999,   998,   998,  1000,   998,   998,
    1001,  1002,  1002,  1004,  1003,  1005,  1005,  1006,  1006,  1006,
    1007,  1007,  1008,  1008,  1010,  1009,  1011,  1011,  1011,  1013,
    1012,  1014,  1014,  1015,  1015,  1016,  1016,  1016,  1018,  1017,
    1019,  1021,  1020,  1022,  1022,  1023,  1023,  1024,  1024,  1024,
    1024,  1024,  1024,  1026,  1025,  1027,  1027,  1027,  1029,  1028,
    1028,  1030,  1030,  1031,  1031,  1032,  1034,  1033,  1035,  1035,
    1036,  1036,  1037,  1038,  1039,  1039,  1041,  1040,  1042,  1042,
    1043,  1043,  1044,  1045,  1047,  1046,  1049,  1048,  1050,  1050,
    1051,  1051,  1052,  1053,  1053,  1054,  1054,  1055,  1055,  1057,
    1056,  1059,  1060,  1058,  1061,  1061,  1061,  1061,  1061,  1062,
    1062,  1063,  1063,  1064,  1064,  1065,  1065,  1065,  1066,  1066,
    1066,  1067,  1067,  1067,  1068,  1068,  1069,  1070,  1071,  1071,
    1071,  1071,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1074,  1074,  1074,  1074,
    1074,  1074,  1075,  1075,  1075,  1075,  1075,  1075,  1075,  1075,
    1075,  1075,  1075,  1075,  1075,  1075,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1077,  1077,  1078,  1078,  1079,  1079,  1080,  1080,  1081,
    1081,  1081,  1081,  1081,  1081,  1082,  1082,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1089,  1088,  1088,  1090,  1090,  1091,
    1091,  1092,  1092,  1093,  1093,  1094,  1094,  1095,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1097,  1098,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1099,  1096,
    1101,  1100,  1102,  1102,  1102,  1103,  1103,  1104,  1104,  1105,
    1106,  1105,  1107,  1107,  1109,  1108,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1111,  1111,  1112,
    1112,  1113,  1113,  1114,  1114,  1115,  1115,  1116,  1116,  1117,
    1117,  1118,  1118,  1119,  1120,  1120,  1121,  1121,  1122,  1122,
    1123,  1122,  1124,  1122,  1125,  1122,  1122,  1126,  1122,  1127,
    1122,  1122,  1128,  1122,  1129,  1122,  1122,  1130,  1130,  1130,
    1132,  1131,  1131,  1131,  1133,  1134,  1135,  1133,  1136,  1138,
    1139,  1137,  1141,  1140,  1143,  1144,  1142,  1145,  1146,  1147,
    1147,  1148,  1148,  1148,  1148,  1149,  1149,  1151,  1150,  1152,
    1150,  1153,  1153,  1154,  1155,  1154,  1157,  1156,  1158,  1158,
    1159,  1159,  1160,  1160,  1161,  1161,  1162,  1162,  1162,  1162,
    1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,  1163,  1163,
    1163,  1163,  1163,  1163,  1163,  1163,  1163,  1164,  1164,  1164,
    1164,  1165,  1165,  1165,  1166,  1166,  1167,  1167,  1168,  1169,
    1168,  1170,  1171,  1170,  1172,  1172,  1173,  1173,  1174,  1174,
    1175,  1175,  1175,  1176,  1177,  1177,  1178,  1179,  1179,  1181,
    1180,  1182,  1182,  1183,  1183,  1183,  1184,  1184,  1185,  1185,
    1186,  1187,  1187,  1187,  1188,  1188,  1188,  1188,  1188,  1189,
    1189,  1190,  1190,  1190,  1190,  1190,  1190,  1191,  1191,  1191,
    1191,  1191,  1192,  1192,  1192,  1192,  1192,  1193,  1193,  1193,
    1193,  1194,  1195,  1195,  1196,  1197,  1196,  1198,  1198,  1199,
    1199,  1200,  1202,  1201,  1203,  1203,  1204,  1204,  1206,  1205,
    1208,  1209,  1207,  1207,  1207,  1211,  1210,  1213,  1212,  1214,
    1212,  1212,  1212,  1212,  1212,  1212,  1215,  1212,  1212,  1212,
    1212,  1212,  1212,  1216,  1216,  1217,  1218,  1218,  1219,  1220,
    1220,  1221,  1221,  1223,  1224,  1222,  1226,  1227,  1225,  1228,
    1228,  1228,  1228,  1229,  1229,  1230,  1230,  1231,  1232,  1232,
    1232,  1233,  1232,  1234,  1234,  1235,  1235,  1236,  1235,  1237,
    1235,  1238,  1238,  1239,  1239,  1240,  1241,  1241,  1242,  1242,
    1244,  1243,  1245,  1245,  1246,  1246,  1247,  1247,  1248,  1249,
    1248,  1251,  1252,  1250,  1253,  1253,  1254,  1255,  1255,  1256,
    1257,  1257,  1259,  1258,  1261,  1260,  1262,  1260,  1263,  1260,
    1264,  1264,  1265,  1265,  1266,  1266,  1267,  1267,  1268,  1268,
    1268,  1270,  1269,  1271,  1271,  1272,  1272,  1273,  1273,  1274,
    1274,  1274,  1274,  1274,  1274,  1274,  1274,  1274,  1275,  1275,
    1277,  1276,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1279,  1278,  1280,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1281,
    1281,  1281,  1282,  1282,  1283,  1283,  1284,  1284,  1285,  1285,
    1286,  1286,  1287,  1287,  1288,  1288,  1289,  1289,  1289,  1291,
    1290,  1292,  1290,  1293,  1293,  1294,  1294,  1294,  1295,  1295,
    1295,  1297,  1296,  1299,  1300,  1298,  1298,  1301,  1301,  1302,
    1302,  1303,  1303,  1303,  1303,  1303,  1303,  1303,  1303,  1303,
    1303,  1303,  1303,  1303,  1303,  1303,  1304,  1304,  1306,  1305,
    1307,  1307,  1309,  1308,  1308,  1308,  1310,  1310,  1312,  1311,
    1313,  1314,  1314,  1315,  1316,  1316,  1316,  1317,  1319,  1320,
    1321,  1322,  1318,  1323,  1323,  1324,  1324,  1325,  1325,  1325,
    1326,  1326,  1326,  1327,  1327,  1328,  1328,  1329,  1329,  1329,
    1329,  1330,  1330,  1331,  1331,  1332,  1332,  1333,  1333,  1334,
    1334,  1335,  1335,  1336,  1336,  1336,  1337,  1337,  1338,  1338,
    1339,  1339,  1340,  1340,  1341,  1342,  1342,  1342,  1342,  1343,
    1343,  1343,  1344,  1345,  1345,  1345,  1346,  1346,  1346,  1346,
    1346,  1346,  1346,  1346,  1346,  1346,  1346,  1346,  1347,  1347,
    1347,  1347,  1347,  1348,  1348,  1349,  1349,  1350,  1351,  1351,
    1352,  1352,  1353,  1353,  1353,  1354,  1354,  1354,  1354,  1355,
    1355,  1355,  1356,  1356,  1357,  1358,  1358,  1359,  1360,  1361,
    1362,  1362,  1363,  1363,  1364,  1364,  1364,  1365,  1365,  1365,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1369,  1368,
    1370,  1370,  1371,  1371,  1373,  1372,  1374,  1374,  1374,  1374,
    1375,  1375,  1376,  1376,  1376,  1376,  1377,  1377,  1377,  1377,
    1378,  1378,  1379,  1379,  1380,  1380,  1380,  1380,  1380,  1380,
    1380,  1381,  1381,  1381,  1382,  1382,  1382,  1382,  1383,  1383,
    1383,  1384,  1384,  1384,  1384,  1384,  1386,  1385,  1387,  1387,
    1388,  1388,  1389,  1390,  1390,  1390,  1390,  1392,  1391,  1393,
    1393,  1394,  1393,  1395,  1395,  1396,  1396,  1397,  1397,  1397,
    1397,  1398,  1397,  1399,  1399,  1399,  1399,  1399,  1400,  1401,
    1401,  1401,  1401,  1401,  1402,  1403,  1403,  1403,  1403,  1404,
    1404,  1405,  1405,  1406,  1406,  1407,  1407,  1409,  1408,  1410,
    1408,  1411,  1408,  1412,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1413,  1413,  1414,  1414,  1415,  1415,  1415,  1416,  1416,
    1416,  1416,  1417,  1417,  1418,  1418,  1419,  1419,  1419,  1419,
    1419,  1420,  1420,  1421,  1421,  1422,  1423,  1423,  1423,  1423,
    1423,  1424,  1424,  1425,  1425,  1426,  1426,  1427,  1427,  1427,
    1427,  1427,  1429,  1428,  1430,  1430,  1431,  1431,  1431,  1432,
    1432,  1432,  1433,  1433,  1434,  1435,  1435,  1436,  1437,  1438,
    1438,  1440,  1439,  1441,  1441,  1441,  1442,  1442,  1444,  1443,
    1445,  1445,  1446,  1446,  1446,  1447,  1447,  1448,  1449,  1448,
    1450,  1451,  1452,  1453,  1453,  1454,  1454,  1455,  1455,  1455,
    1455,  1455,  1455,  1455,  1455,  1456,  1456,  1456,  1457,  1457,
    1457,  1457,  1457,  1458,  1458,  1458,  1458,  1458,  1458,  1459,
    1459,  1460,  1461,  1462,  1462,  1462,  1463,  1464,  1464,  1464,
    1465,  1465,  1465,  1467,  1466,  1468,  1468,  1469,  1469,  1471,
    1470,  1472,  1472,  1473,  1473,  1473,  1473,  1475,  1476,  1477,
    1474,  1478,  1478,  1480,  1481,  1482,  1483,  1484,  1479,  1486,
    1487,  1488,  1489,  1485,  1490,  1490,  1490,  1490,  1490,  1490,
    1491,  1491,  1491,  1492,  1492,  1493,  1493,  1493,  1494,  1494,
    1495,  1496,  1495,  1497,  1497,  1498,  1499
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     4,     1,     2,     0,     4,     0,
       2,     3,     1,     2,     0,     3,     0,     5,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     5,     1,     0,     1,     3,     1,     3,
       3,     3,     3,     0,     7,     0,    12,     0,    12,     0,
      12,     0,     6,     0,     3,     4,     4,     3,     2,    10,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     0,
      13,     0,     6,     2,     0,     1,     3,     1,     0,     2,
       0,     2,     0,     1,     3,     4,     0,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     0,     2,     0,     2,
       2,     2,     2,     2,     3,     3,     1,     1,     1,     2,
       3,     3,     0,     4,     0,     3,     0,     1,     3,     1,
       0,     1,     3,     1,     0,     3,     0,     1,     3,     1,
       4,     0,     1,     1,     1,     0,     3,     2,     3,     0,
       3,     0,     5,     5,     0,     7,     5,     0,     2,     1,
       1,     1,     3,     1,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     3,     1,     1,     0,     1,     0,
       2,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     0,     2,
       0,     3,     0,     2,     2,     2,     2,     0,     6,     2,
       0,     2,     1,     1,     3,     0,     0,     0,     7,     0,
       2,     2,     1,     1,     0,     0,     8,     0,     6,     1,
       2,     1,     2,     0,     0,     6,     0,     0,     6,     0,
       2,     0,     5,     0,     1,     0,     5,     0,     2,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     4,     5,     0,     4,     4,     4,     3,
       3,     2,     2,     0,     2,     1,     2,     3,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       1,     1,     1,     2,     3,     2,     4,     5,     0,     5,
       0,     0,     5,     0,     7,     1,     0,     1,     0,     4,
       0,     0,     3,     5,     6,     0,     4,     2,     2,     2,
       2,     0,     1,     0,     3,     0,     1,     1,     3,     1,
       4,     5,     5,     0,     2,     0,     0,     7,     0,    10,
       1,     3,     1,     1,     0,     2,     0,     3,     1,     3,
       0,     6,     1,     0,     0,     5,     0,     4,     1,     1,
       1,     3,     1,     3,     0,     0,     5,     1,     3,     1,
       1,     0,     3,     1,     3,     0,     4,     1,     0,     1,
       2,     1,     3,     4,     3,     3,     3,     4,     4,     3,
       0,     0,     6,     0,     1,     0,     1,     1,     2,     1,
       1,     0,     1,     1,     2,     1,     0,     3,     0,     1,
       1,     2,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     0,     6,
       1,     1,     3,     4,     4,     2,     2,     2,     3,     3,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     2,     2,     7,     8,     8,     8,
       8,     2,     0,     1,     4,     0,     1,     2,     0,     4,
       3,     3,     3,     1,     2,     1,     1,     3,     2,     3,
       2,     2,     1,     3,     3,     2,     3,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     2,     3,     2,     3,
       2,     2,     3,     3,     3,     0,     6,     0,     6,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     2,     1,     2,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       5,     0,     1,     2,     1,     1,     1,     1,     3,     3,
       3,     3,     0,     1,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     2,     1,     2,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     0,     1,     1,     2,     2,     1,     2,     2,     0,
       1,     1,     1,     3,     1,     3,     0,     1,     0,     1,
       5,     0,     3,     3,     1,     0,     2,     2,     2,     0,
       3,     3,     6,     6,     1,     1,     2,     2,     2,     1,
       2,     2,     1,     1,     0,     1,     1,     1,     1,     0,
       1,     1,     1,     0,     1,     2,     0,     1,     0,     1,
       0,     1,     1,     2,     1,     2,     1,     2,     2,     2,
       3,     2,     1,     1,     1,     1,     3,     1,     1,     1,
       4,     2,     1,     4,     0,     1,     0,     2,     1,     3,
       0,     6,     0,     5,     7,     0,     5,     0,     5,     0,
       5,     0,     4,     0,    10,     3,     4,     3,     3,     7,
       0,     3,     1,     4,     0,     3,     0,     2,     0,     1,
       0,     2,     2,     2,     2,     1,     1,     1,     3,     4,
       0,     6,     4,     0,     5,     0,     6,     4,     3,     1,
       2,     1,     1,     0,     5,     0,     3,     2,     0,     5,
       0,     0,     6,     1,     3,     1,     1,     3,     2,     3,
       2,     4,     0,     6,     0,     0,     8,     4,     4,     3,
       3,     2,     2,     6,     5,     3,     5,     1,     1,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     2,     1,
       0,     1,     1,     1,     0,     5,     3,     0,     5,     3,
       3,     0,     3,     0,     2,     1,     3,     0,     1,     1,
       0,     2,     1,     3,     0,     5,     0,     1,     1,     0,
       6,     0,     1,     1,     2,     1,     1,     1,     0,     5,
       2,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     5,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     0,     6,     1,     1,
       1,     3,     2,     3,     1,     1,     0,     6,     1,     1,
       1,     3,     3,     4,     0,     6,     0,     2,     0,     4,
       0,     2,     1,     2,     4,     2,     3,     2,     3,     0,
       3,     0,     0,     6,     2,     1,     1,     2,     2,     8,
       4,     0,     1,     2,     1,     1,     1,     1,     0,     2,
       4,     3,     1,     1,     3,     4,     0,     0,     0,     2,
       2,     1,     1,     0,     2,     3,     3,     3,     2,     3,
       4,     3,     4,     3,     4,     1,     3,     4,     3,     3,
       6,     1,     5,     6,     5,     7,     6,     8,     5,     6,
       4,     4,     5,     3,     4,     1,     3,     3,     3,     3,
       3,     3,     5,     5,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     5,     4,     6,     2,
       4,     4,     4,    10,     6,     8,     6,     4,     4,     6,
       4,     4,     4,     6,     4,     7,     7,     7,     6,     6,
       6,     6,     3,     4,     6,     8,     2,     2,     4,     8,
       8,     6,     6,     2,     4,     6,     6,     8,     8,     6,
       8,     6,     2,     4,     8,     8,     2,     2,     2,     4,
       4,     4,     4,     3,     8,     4,     6,     4,     4,     4,
       6,     8,     6,     4,     6,     1,     6,     4,     4,     4,
       4,     4,     6,     4,     0,     5,     6,     2,     3,     0,
       4,     0,     3,     0,     1,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       0,     4,     4,     2,     0,     3,     2,     3,     2,     1,
       2,     1,     2,     1,     1,     1,     2,     0,     1,     1,
       3,     1,     3,     1,     3,     0,     1,     0,     2,     4,
       5,     1,     1,     1,     1,     4,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     3,     5,     2,     0,     0,     7,     1,     0,
       0,     6,     0,     3,     0,     0,     5,     0,     1,     0,
       1,     0,     2,     3,     3,     1,     1,     0,     7,     0,
       7,     1,     2,     0,     0,     2,     0,     2,     0,     1,
       1,     1,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     2,     0,     1,     0,     0,
       3,     0,     0,     3,     2,     0,     0,     4,     4,     2,
       0,     1,     1,     3,     3,     1,     2,     0,     1,     0,
       4,     4,     2,     0,     1,     1,     0,     1,     0,     1,
       2,     1,     3,     3,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     0,     6,     0,     1,     3,
       1,     3,     0,     2,     3,     1,     2,     1,     0,     3,
       0,     0,     7,     2,     1,     0,     3,     0,     7,     0,
       6,     4,     6,     4,     4,     4,     0,     6,     4,     4,
       5,     6,     4,     1,     3,     1,     1,     3,     1,     0,
       2,     0,     1,     0,     0,     8,     0,     0,     6,     0,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     3,
       4,     0,     3,     3,     1,     2,     2,     0,     3,     0,
       5,     3,     1,     3,     1,     3,     1,     1,     0,     1,
       0,     4,     0,     1,     3,     1,     1,     1,     0,     0,
       6,     0,     0,    11,     3,     1,     3,     3,     1,     3,
       0,     1,     0,     4,     0,     6,     0,     5,     0,     6,
       1,     3,     2,     4,     0,     2,     0,     2,     1,     1,
       1,     0,     4,     0,     1,     0,     1,     1,     3,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     0,     3,
       0,     3,     2,     4,     4,     3,     4,     4,     1,     3,
       3,     6,     2,     2,     0,     6,     0,     6,     5,     2,
       1,     1,     1,     5,     5,     2,     2,     1,     4,     3,
       2,     3,     2,     2,     1,     3,     4,     3,     3,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     0,     1,     1,     0,     1,
       1,     0,     4,     0,     0,     5,     1,     0,     3,     3,
       1,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     3,
       3,     1,     0,     3,     1,     2,     0,     1,     0,     3,
       3,     2,     2,     3,     0,     1,     1,     2,     0,     0,
       0,     0,    21,     1,     1,     0,     1,     0,     1,     1,
       0,     1,     1,     0,     2,     2,     1,     3,     4,     3,
       3,     0,     2,     2,     1,     3,     3,     0,     4,     0,
       3,     1,     1,     0,     3,     2,     3,     1,     1,     2,
       0,     2,     3,     1,     5,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     3,     5,     1,     1,     1,
       1,     1,     3,     4,     5,     1,     5,     3,     2,     1,
       3,     2,     2,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     5,     3,     8,     8,     8,     6,     0,
       1,     1,     2,     0,     1,     1,     3,     0,     3,     0,
       3,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       2,     0,     1,     3,     1,     2,     2,     2,     1,     3,
       3,     1,     1,     3,     1,     3,     4,     5,     4,     6,
       1,     0,     3,     3,     1,     1,     0,     2,     2,     2,
       2,     0,     2,     0,     3,     2,     1,     2,     2,     2,
       2,     2,     0,     3,     0,     1,     0,     3,     2,     0,
       1,     2,     0,     1,     4,     4,     5,     2,     3,     0,
       1,     0,     4,     0,     1,     1,     0,     1,     0,     2,
       2,     1,     0,     1,     1,     2,     3,     2,     0,     6,
       3,     0,     0,     0,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     1,     2,     1,     2,     3,     3,     3,
       0,     3,     3,     0,     7,     0,     3,     1,     3,     0,
       3,     2,     4,     0,     3,     4,     4,     0,     0,     0,
      16,     8,     7,     0,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    12,     4,     4,     3,     4,     3,     2,
       1,     3,     5,     1,     1,     0,     1,     1,     0,     2,
       0,     0,     3,     0,     2,     5,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  2431,   975,  2362,     0,     0,     0,     0,     0,     0,
    2364,   113,    62,  1582,  1693,  1694,  1495,  1521,     2,     0,
     975,   163,     0,    74,  1523,     0,  1744,     0,     0,   975,
     441,     0,  1738,     0,     0,   975,  1526,  1728,   237,   163,
    2364,     0,  1021,  2190,  1620,     0,     0,     0,     0,  1603,
       0,  2247,  1571,     0,     0,     0,     0,     3,     8,    19,
       0,    38,    24,    28,    14,    18,    13,    51,    45,    36,
      10,    53,    54,    16,    42,    11,    12,    15,    34,    41,
      35,    37,    49,  1012,    22,    23,    29,    43,    58,    20,
      55,    52,    21,  1695,    25,    44,    39,    31,    59,    32,
      50,    33,    57,    27,    46,    26,     9,    17,    47,    48,
      40,    60,    30,    56,     0,   848,     0,     0,   913,     0,
       0,     0,     0,     0,   831,  2429,  2430,  2431,   977,   976,
       0,  2364,  1847,   960,   986,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1861,  1917,  1918,  1920,  1919,  1921,  1922,  1862,
    1863,  1923,  1924,  1925,  1927,  1926,  1928,  1864,  1865,  1929,
    1930,  1931,  1932,  1866,  1867,  1933,  1935,  1934,  1868,  1936,
    1937,  1938,  1940,  1939,  1869,  1941,  1870,  1942,  1943,  1944,
    1945,  1946,  1947,  1948,  1950,  1949,  1871,  1951,  1952,  1953,
    1954,  1955,  1957,  1956,  1958,  1959,  1960,  1872,  1961,  1962,
    1963,  1964,  1965,  1966,  1967,  1873,  1968,  1969,  1970,  1987,
    1874,  1971,  1974,  1973,  1972,  1975,  1976,  1977,  1979,  1978,
    1980,  1875,  1981,  1982,  1983,  1985,  1984,  1989,  1990,  1991,
    1876,  1986,  1988,  2169,  1992,  1994,  1993,  1995,  1997,  1996,
    1877,  1998,  1878,  1879,  1999,  2000,  1845,  2001,  1846,  2002,
    2004,  2005,  2006,  2011,  1880,  2003,  2007,  2008,  2009,  2010,
    2012,  1881,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2021,  2022,  2033,  2026,  2028,  2029,  2031,  2027,  2032,  2036,
    2035,  2037,  2038,  2039,  2034,  2024,  2030,  2025,  2040,  2041,
    2023,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,
    2051,  2052,  2054,  2053,  2055,  2056,  2057,  2058,  2059,  2060,
    2062,  2061,  2063,  2064,  2065,  2067,  2066,  2069,  2070,  1882,
    2068,  2071,  2072,  2073,  2074,  2075,  1883,  1884,  1885,  2076,
    2077,  1886,  2078,  2079,  2080,  1887,  2081,  2082,  2084,  2083,
    2085,  2086,  1888,  1889,  2087,  2088,  2089,  2090,  2091,  2092,
    2093,  2094,  2095,  2096,  2097,  2098,  2099,  2100,  2102,  2101,
    2103,  2104,  2105,  2106,  2107,  2108,  2109,  1890,  2110,  1891,
    2111,  2112,  1892,  2113,  1893,  2114,  2115,  1894,  2116,  2117,
    2118,  2119,  2120,  2121,  1895,  2122,  2123,  2124,  1896,  2126,
    2125,  2127,  1897,  2129,  2130,  1898,  2128,  1900,  2131,  2132,
    1899,  1901,  2133,  2134,  2136,  2135,  2137,  2138,  2139,  1902,
    2140,  1903,  2141,  2142,  2143,  2144,  2145,  2147,  2146,  2148,
    2149,  2150,  2151,  2153,  2155,  2154,  2152,  2156,  2157,  2158,
    2159,  2162,  2163,  2164,  2165,  2160,  2161,  1904,  2166,  2167,
    2168,  2170,  2171,  2173,  2172,  1905,  1906,  2174,  2175,  1909,
    2176,  2177,  2180,  2178,  2179,  2182,  2181,  2183,  2184,  1907,
    2185,  1908,  2186,  2187,   182,  1850,   165,  1851,  1860,     0,
    2239,  2238,   944,   961,  2365,  2366,   536,   781,     0,     0,
     782,     0,   535,   780,   163,  2431,   118,     0,   532,   533,
       0,     0,     0,  1596,     0,  1519,  1519,  1519,     0,     0,
    1519,  1519,     0,  1522,  1519,   163,  1519,     0,    67,  1701,
       0,     0,     0,     0,  1844,     0,  1529,     0,  1745,  1746,
       0,  1753,     0,  1754,  1748,  2236,     0,     0,     0,     0,
       0,   163,   978,     0,  1580,     0,   227,   236,   238,   239,
     235,     0,  2366,  2377,  1013,  1019,  1031,  2191,  2188,  1678,
     239,   933,   933,   933,   931,   933,  1604,  1601,     0,     0,
    1580,  1747,  2483,     0,     0,     0,  2479,     0,  2484,     0,
    1021,     0,     0,     1,     5,     0,     0,  1982,  2080,  1691,
    1689,  1839,     0,   822,   849,     0,   827,     0,   825,  1856,
    1855,  1854,     0,   838,   837,   835,     0,   403,     0,     0,
    2440,   829,   958,  2363,     0,   184,     0,    76,     0,     0,
       0,  2369,     0,     0,     0,     0,   117,     0,     0,     0,
     114,  1046,  1046,  2431,  2433,  2435,   536,   534,     0,     0,
       0,  1600,  1599,  1598,     0,  1596,  1911,  1861,  1922,     0,
    1812,     0,     0,     0,  1295,     0,  1866,     0,  1936,  1938,
    1871,     0,     0,  1053,  1053,  1053,     0,     0,     0,  1959,
    1960,  1821,     0,     0,     0,  1809,  1822,  1994,  1995,     0,
    1811,  2000,     0,     0,     0,     0,  2017,  1819,     0,     0,
    2049,  2051,     0,     0,  2055,  2056,  2057,  2058,  1796,  1108,
       0,  1053,  1808,  1818,  2073,  1802,  2081,  2085,  2086,     0,
    2095,     0,     0,     0,  2120,  2124,     0,     0,  2144,     0,
       0,  1053,  1795,  2162,  2163,  2164,  2165,     0,  1810,  1904,
    1820,     0,  2176,  1053,  1053,  1053,     0,     0,     0,  2183,
    2187,     0,     0,     0,  2401,  1107,     0,  1260,     0,  1289,
    1065,  1071,  1085,     0,  1100,  1118,  1119,  1121,  1215,  1120,
    1126,  1125,  1496,  1806,  1124,  1123,  1807,  1117,  1829,  1850,
    1828,     0,     0,     0,     0,     0,     0,     0,     0,  1674,
       0,     0,  1506,  1519,    69,     0,  2283,  2298,  2299,  2295,
    2300,  2318,  2301,  2305,     0,  2297,  2289,     0,  2304,     0,
    2293,  2302,     0,  2287,     0,  2303,  2308,  2319,  2291,  2296,
    2274,     0,  2281,  2285,  1841,  1401,  2250,  2251,     0,    75,
    1531,  1532,  1530,   912,     0,  1743,     0,  1757,     0,   973,
     451,   442,     0,  1673,  1672,     0,  1739,  2378,     0,     0,
     949,  1534,  1581,     0,  1533,  1734,     0,  1732,  1729,  1731,
     228,     0,     0,   258,  2283,     0,  2268,     0,  2372,  2369,
    2379,  2414,  2409,  2408,  2411,  2412,  1037,  2413,  1036,  2410,
    2407,  1046,  1032,  1034,  1035,  2194,  1640,     0,   715,     0,
    1686,  1641,     0,     0,  1686,     0,  1436,  1676,  1679,     0,
    2203,  1654,   778,   777,   776,  2204,  1672,     0,  1628,  1642,
       0,  1605,  1647,     0,  2205,     0,  1675,     0,  1436,  1686,
       0,  1621,     0,     0,     0,     0,   234,   927,   937,   929,
     924,     0,   930,   926,     0,  2496,  2248,   912,  1801,  1800,
    1848,  2480,  1799,  2488,  2490,  2476,  2478,  2485,  1015,     0,
    2383,     6,    61,     0,  1698,  2438,  2439,  2437,   731,     0,
    1053,  1857,  2432,   166,   836,     0,   404,   166,     0,     0,
       0,     0,     0,   405,   406,   342,   820,   833,     0,     0,
     832,  2440,     0,     0,   988,   990,   989,  1006,   186,   183,
     164,     0,   946,  1513,  1515,   963,  2368,     0,     0,  2370,
    2374,  1106,  1105,     0,   111,   116,     0,     0,     0,  2340,
     115,  2334,  2436,  1046,  1046,  1046,  2428,     0,  2416,  2423,
    2424,  2427,  2426,  2425,  2422,     0,  2415,  2418,  2419,  2421,
    2420,  2440,  2434,     0,   783,   783,   783,     0,  1583,  1586,
    1590,  1594,  1597,     0,     0,  1406,  1139,  1406,  1406,  1406,
    1296,     0,     0,     0,     0,     0,     0,     0,     0,  1406,
       0,  1176,  1149,     0,  1177,     0,     0,     0,     0,     0,
    1815,     0,     0,  2401,     0,     0,     0,  1265,     0,     0,
       0,  2401,     0,     0,     0,     0,     0,  1291,  1293,  1828,
    1406,     0,     0,  1406,     0,     0,     0,     0,     0,  1058,
       0,  1183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1406,  1406,     0,     0,  1406,     0,  1192,
       0,  1817,     0,     0,     0,  1816,     0,     0,  1814,  1813,
    1797,     0,  1196,  1198,  1197,     0,  1406,  1406,     0,     0,
    1129,  1128,  1130,     0,     0,     0,     0,     0,     0,  1104,
    1103,  1102,  1101,     0,     0,     0,  1109,     0,  1110,  1111,
       0,  1112,  1113,  1114,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1131,     0,     0,     0,  1798,  1224,     0,
    1520,  1501,  1508,  1503,     0,  1674,  1504,  1512,   417,     0,
    1509,  2332,  1505,     0,  1497,     0,    68,     0,  1724,     0,
       0,     0,  1718,  1720,  1723,  1719,     0,     0,  1725,  1722,
       0,  1721,  1702,  1706,  1710,  1703,  2284,  2282,  2316,  2315,
    2320,     0,  2317,  2313,  2306,  2341,  2310,     0,  2341,  2312,
    2311,  2341,  2307,  2314,  2341,  2279,     0,  1402,  1403,     0,
    2249,     0,  1840,     0,     0,   996,  1758,  1759,  1755,  1401,
    2237,  2240,     0,   452,     0,     0,   463,     0,     0,    64,
      65,     0,   980,     0,   979,   983,     0,     0,     0,  1537,
    1527,  1536,  1735,  1736,     0,   226,   251,   246,   254,   248,
     250,   249,   255,   256,   257,   252,   247,   253,   240,     0,
    2282,     0,  2279,  2373,     0,  2375,  2392,  1020,  2380,  1043,
    1022,  1042,     0,  1033,  2189,  2192,  2200,  1682,   714,     0,
       0,  1653,     0,   536,     0,     0,     0,     0,     0,     0,
    1622,     0,     0,   573,     0,  1646,  1437,  1680,  1681,  1686,
       0,     0,  1686,     0,  1659,  1676,     0,  1686,  1617,     0,
       0,  1609,  1614,  1610,     0,  1616,  1615,  1618,  1606,  1607,
    1682,  1633,  1660,  1676,  1645,  1652,     0,  1632,  1639,     0,
    1650,  1676,  1676,  1686,  1686,   940,   939,   938,   934,   935,
     940,     0,  1602,  1330,     0,     0,  2477,  2491,  2475,  2486,
    2487,  2474,  1016,  2384,  1014,  2385,     0,     7,     4,  1692,
    1690,  1699,  1700,   732,   731,   527,   530,   529,     0,     0,
    1859,     0,   828,     0,  1674,   826,     0,     0,  1674,   353,
    1674,   407,   731,   840,     0,     0,   830,   959,     0,     0,
     440,  1006,   992,  1008,     0,   187,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    77,    78,    94,   948,   947,
       0,   945,   971,   970,   968,     0,   969,   967,   962,   964,
     965,  2367,  2371,   537,   731,  1674,     0,   345,     0,     0,
       0,     0,     0,   536,     0,     0,  2417,   103,   784,     0,
       0,     0,  1588,  1516,  1584,  1518,  1839,     0,     0,     0,
    1592,     0,     0,  1407,  1406,     0,  1274,     0,     0,     0,
       0,  1297,     0,     0,     0,     0,     0,     0,     0,  1245,
       0,  1274,  1054,     0,  1203,     0,     0,     0,     0,     0,
       0,  1377,  1378,  1379,  1380,  1388,  1381,  1382,  1383,  1390,
    1395,  1384,  1385,  1391,  1392,  1393,  1386,  1394,  1389,  1387,
    1396,     0,  1376,     0,  1399,  1397,  1400,  1398,     0,  1266,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1406,     0,     0,     0,  1406,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1406,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1172,     0,  1831,  1830,     0,     0,     0,     0,  1133,
       0,  1132,  1339,     0,  2386,  2402,     0,  2206,  1261,  1263,
       0,  1056,  1055,  1057,  1068,  1061,  1066,  1059,  1063,     0,
    1115,  1916,  1069,     0,     0,  1097,  2401,  1415,  1098,  1083,
    1088,  1089,     0,  1086,  1087,     0,  1091,     0,  1090,  1094,
    1095,  1096,  1099,     0,     0,     0,     0,  1122,  1127,  1290,
    1046,  1832,     0,  1499,   417,   420,   419,  1510,   418,  1558,
       0,   914,     0,     0,    70,    72,  1715,  1712,  1711,  1713,
    1717,  1716,  1714,     0,  1726,  2309,     0,  2290,     0,  2294,
    2288,  2292,     0,     0,  2280,     0,  2286,  1405,  1990,  2066,
       0,  1408,  2253,  1524,  2495,     0,  1756,     0,     0,     0,
     974,     0,  1046,   450,   449,   448,   447,     0,   465,   445,
     453,    66,     0,     0,  1740,     0,     0,     0,     0,   951,
    1535,     0,  1737,  1733,  1730,     0,     0,     0,     0,     0,
       0,     0,  2376,  2394,  2393,  2381,  1046,  1427,  1047,  1047,
    1828,  2194,  2197,  2198,  2201,  2199,     0,  2196,  2195,  2210,
       0,  1684,  1687,  1688,     0,     0,  1668,  1662,  1661,  1657,
    1663,  1658,  1671,  1670,  1669,  1630,  1629,  1447,  1448,  1446,
    1440,  1441,  1445,  1444,  1625,  1677,  1667,  1665,  1655,  1686,
    1666,  1664,  1611,  1612,  1613,     0,  1436,     0,  1684,  1686,
    1676,     0,  1686,  1686,  1649,  1651,     0,   928,   937,   925,
     932,  1348,  1347,     0,  1304,     0,  1306,  1303,  1302,  1301,
       0,  1347,  2481,  2489,  2493,     0,  1436,  2391,  2389,   528,
    1558,  1558,     0,  1858,     0,     0,     0,     0,     0,     0,
       0,   167,   176,     0,     0,   351,   352,  1558,   350,   393,
     394,   397,   398,   399,     0,     0,     0,     0,     0,     0,
       0,     0,   120,   400,  1558,  1558,   347,   373,   374,   377,
     378,   379,   380,   381,   343,     0,   348,   910,   910,     0,
    1558,  1558,   910,  1558,     0,     0,  1558,  1558,     0,     0,
    1558,     0,     0,   910,     0,  1558,   908,     0,     0,  1558,
    1558,  1558,  1558,   910,     0,     0,  1558,   440,  1558,     0,
       0,   920,     0,     0,  1558,     0,     0,  1558,     0,  1558,
     856,   907,   540,   560,   561,   821,   855,   857,   869,   436,
       0,   886,   909,     0,   842,   844,  2441,  2442,  2443,   995,
     987,   994,   991,  1006,  1004,   993,   773,   772,     0,  1007,
     185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1514,   972,   966,   112,   731,  1558,  1558,  1558,  1558,
     349,   382,   383,   386,   387,   388,   389,   392,   390,   391,
       0,     0,  1674,     0,     0,  2335,     0,  2469,     0,     0,
       0,   165,   538,     0,     0,   785,     0,     0,     0,     0,
       0,  1408,     0,  1842,  1591,  1330,  1595,  1594,     0,  1199,
       0,  1238,     0,  1240,  1241,  1242,     0,     0,     0,     0,
       0,  1200,     0,  1147,  1201,  1202,     0,     0,     0,     0,
    1244,     0,  1178,     0,     0,  1150,  1151,  1144,  1136,     0,
    1217,     0,     0,  1152,     0,     0,     0,     0,     0,  1218,
    1292,     0,  1294,  1832,     0,  1250,  1205,  1157,     0,  1248,
       0,  1158,  1219,  1220,  1221,  1184,  1207,  1208,     0,  1223,
       0,  1209,     0,     0,     0,     0,  1160,  1254,  1252,     0,
       0,     0,     0,  1256,  1193,  1162,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,  1164,     0,  1145,
    1253,  1255,  1213,     0,  1173,     0,  2395,  1338,  2403,  1339,
       0,     0,  2397,  2387,  2392,  2400,  1137,     0,     0,     0,
       0,     0,  1833,  1062,  1067,  1060,  1064,  2401,     0,     0,
       0,     0,  1081,  1080,     0,     0,     0,  2401,  1415,  1084,
       0,     0,  1234,  1235,  1287,     0,  1502,  1500,  1511,  1556,
    1557,  1559,     0,  2333,   916,   915,  1507,   914,    73,     0,
    1709,  1727,  1704,  2345,     0,  2344,     0,  2328,  2331,  1839,
       0,     0,     0,  2263,  2257,  2264,  2266,  2260,  2265,  2267,
    2258,  2259,  2254,  2261,  1409,  1438,     0,   997,   999,  1000,
     998,  1006,     0,     0,  2243,  2244,  2242,  2241,   455,     0,
    1472,  1473,  1458,  1459,  1457,  1460,   464,  1461,  1471,     0,
     476,     0,     0,     0,  1742,  1741,     0,   981,   984,   985,
     956,   955,   957,   950,   952,   953,   520,  1541,     0,     0,
       0,  1547,  1528,  1538,     0,  1959,  2162,  2165,   241,   244,
     243,   245,     0,     0,     0,     0,     0,     0,  1041,  1330,
    1488,  1038,  1026,  1438,  1428,  1025,  1048,  1044,     0,  2193,
       0,  2160,  2221,     0,     0,     0,     0,     0,  2211,  1683,
       0,  1634,     0,  1656,     0,     0,  1627,     0,  1648,  1608,
    1636,  1626,  1408,  1676,  1623,  1624,   942,   941,   936,  1347,
    1330,     0,     0,  1327,  1349,     0,  1349,  1330,  1330,     0,
    1330,  1401,  1344,     0,     0,  2492,  1429,  2390,     0,     0,
     824,   170,   173,   171,     0,   172,     0,     0,   402,   401,
       0,  1674,   395,   124,   123,   125,   126,  1455,  1456,  1452,
    1453,  1451,  1454,   128,   127,   122,   839,     0,     0,     0,
    1674,   375,   354,   355,   358,   359,   360,   911,   814,   975,
     890,     0,   606,   814,   769,   774,   774,   888,     0,   975,
       0,     0,     0,     0,     0,   975,     0,     0,     0,  1558,
       0,   901,   851,     0,     0,     0,     0,     0,   902,     0,
     852,  1558,     0,     0,     0,     0,     0,   975,     0,     0,
     438,     0,   975,   870,   923,   922,   921,     0,   975,   975,
       0,   566,   567,   565,     0,     0,   558,   541,   731,   853,
     437,   854,   605,     0,   917,   602,   608,  1835,     0,     0,
       0,   134,  2445,     0,  1368,   188,    95,    84,    80,    99,
    1465,  1466,  1464,  1462,  1463,   100,    82,    83,    87,    86,
      88,    89,    90,    85,    91,    81,    92,   101,   102,    79,
       0,     0,     0,     0,  1674,   384,     0,     0,  1558,   344,
     361,   362,   365,   366,   367,   368,   369,   372,   370,   371,
       0,  2336,  2338,     0,     0,   338,   337,     0,   129,  2463,
       0,     0,   605,   104,   436,   539,   542,   807,   809,   808,
     799,   798,   105,   107,   109,  1517,  1594,  1330,  1427,  1840,
    1408,     0,  1593,     0,     0,  1239,  1275,     0,  1298,     0,
    1141,   692,   692,  1285,  1283,   677,   692,  1279,  1284,  1281,
       0,   717,     0,   716,     0,     0,     0,  1246,  1243,     0,
       0,     0,     0,  1269,     0,     0,     0,  1146,     0,  1229,
    1251,  1249,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1134,  1046,  2404,  2406,
    1017,     0,  2396,  2398,  2207,  2208,  2209,   816,  1262,     0,
    1078,  1074,     0,  1072,  1414,  1093,  1092,     0,     0,     0,
    1082,  1047,  1225,  1046,     0,  1288,  1834,   416,   572,  1498,
      71,  1707,  2342,     0,  2353,     0,     0,     0,     0,     0,
       0,     0,  2252,  1439,  1568,     0,  1006,  1010,  1849,  1749,
    2245,  2246,     0,   456,   457,   459,  1047,   473,   451,     0,
     443,   446,     0,   455,     0,   954,  1031,     0,  1560,  1545,
    1552,  1546,     0,     0,     0,  1544,  1824,  1823,  1830,  2379,
       0,     0,  2273,     0,     0,     0,  2382,  1408,  1408,  1482,
       0,     0,  1023,  1028,  1024,  1027,     0,  1045,  1052,  1051,
    1825,  1832,     0,     0,     0,     0,   719,   718,   727,     0,
       0,     0,  2206,     0,   723,   725,   724,  2216,   722,  1685,
    1436,  1644,  1643,  1443,  1442,  1619,  1436,  1638,  1686,     0,
       0,  2386,  1342,     0,  1329,  1328,  1350,     0,  1330,  1349,
    1349,     0,  1309,  1308,  1572,  1575,     0,  1307,  1366,  1332,
    1031,  2482,  2494,     0,   730,   729,   571,   726,   570,   175,
     174,   180,   181,  1469,  1467,  1468,   408,   421,  1470,   422,
     396,   121,   409,   410,   376,     0,   356,   607,   815,   873,
       0,     0,     0,   774,   601,   814,   783,   775,   814,   814,
       0,     0,   551,   548,   892,   554,   871,   863,   872,   883,
     885,     0,   550,   568,     0,     0,   556,   814,   858,   899,
     900,   914,   545,     0,   581,   582,   580,   562,   569,   546,
     547,   894,     0,  1423,  1425,  1433,   553,   552,     0,   549,
       0,   905,   878,     0,   579,   577,   574,   576,   575,   578,
     557,   555,   868,     0,   910,   910,   887,     0,   589,   590,
     592,   593,  1838,     0,   919,   889,     0,   594,   603,   595,
       0,     0,     0,   144,     0,     0,   841,     0,   137,   135,
     146,     0,     0,     0,  1371,     0,  1372,  1369,  1370,     0,
      96,    98,   415,   414,   413,   412,   385,     0,     0,     0,
    1674,   363,  2337,     0,     0,  2470,   341,   339,   340,     0,
       0,   190,   587,   588,   586,   585,     0,   425,     0,  1887,
     423,     0,   435,     0,  1760,   731,   543,     0,     0,     0,
       0,  1408,  1449,  1843,  1587,     0,  1174,  1299,     0,     0,
     693,  1276,   739,     0,  1286,   679,   678,  1278,  1280,  1282,
    1140,  1148,  1216,  1143,  1142,     0,     0,     0,  1181,  1182,
       0,  1267,     0,     0,  1154,     0,  1156,     0,     0,  1231,
    1206,  1222,  1185,  1210,     0,  1159,  1135,     0,  1186,     0,
    1191,  1189,     0,  1163,     0,     0,  1170,     0,  1168,     0,
    1169,     0,  1171,  1212,  1214,  1340,  2405,  1018,     0,     0,
    1264,  1070,     0,  1079,  1076,     0,  1073,  1048,  1236,  1226,
       0,  1705,  2343,     0,  2278,  2330,  2329,  2346,  2346,  2346,
       0,  1410,     0,  1525,  1001,  1006,  1010,     0,  1002,  1760,
     460,     0,     0,     0,   480,     0,   478,   454,     0,   982,
    1046,  1542,  1554,     0,  1562,     0,     0,  1539,  1549,     0,
       0,     0,  1548,   242,     0,  2270,  2271,  2269,  1438,  1416,
       0,     0,  1494,     0,  1489,  1039,     0,  1050,  1049,     0,
    2223,     0,  2222,  2234,  2235,  2232,  2233,  2231,  2212,     0,
    2218,  2217,     0,     0,     0,  2228,  2219,     0,     0,  1635,
    1637,  1631,   943,  2392,  1401,  1334,  1330,  1305,  1330,  1316,
       0,     0,  1330,  1312,  1310,  1314,     0,  1408,     0,  1331,
    1363,  1046,  1827,  1430,  1433,   357,   875,     0,   814,   770,
     771,   783,     0,   783,   783,     0,     0,   862,     0,   963,
       0,   867,   727,   563,   898,   897,   564,     0,   860,     0,
    1434,  1435,  1426,   439,   859,   880,   865,  1726,   891,   605,
     918,   751,   673,   622,   613,   692,   616,   615,   659,   630,
     627,   677,   675,   645,   677,   677,   652,   651,   669,   655,
     635,   739,   739,   634,   672,   739,   656,   654,   658,     0,
     660,   677,   665,   653,   657,   674,   650,   647,   671,   692,
     629,   628,   631,   670,   739,     0,   663,   692,   696,   633,
     739,   746,     0,     0,   692,   694,  1837,   145,   133,     0,
       0,   843,   845,     0,     0,   846,  2447,     0,  2449,     0,
    1009,     0,    93,     0,     0,   346,   411,   364,  2339,     0,
     201,  1046,     0,     0,   191,   193,   194,     0,     0,     0,
     538,  1762,  1761,   424,   523,   544,     0,     0,     0,  1594,
    1589,     0,  1585,     0,  1300,     0,     0,     0,     0,   733,
     744,   742,   736,     0,   740,   741,  1277,     0,  1247,     0,
       0,  1270,     0,     0,     0,     0,     0,     0,     0,  1138,
       0,  1227,     0,     0,     0,     0,     0,     0,  1167,  1165,
    1166,  1438,  2386,   817,  1075,     0,  1237,     0,     0,     0,
    2351,  2351,  2351,  1567,  1566,     0,  1565,  1569,  1003,  1011,
       0,   458,   461,     0,   453,     0,   477,     0,   444,   521,
       0,     0,     0,  1563,  1551,  2383,  1540,  1543,  1832,  2272,
    1030,     0,  1411,  1493,  1490,     0,  1483,  1485,  1487,     0,
    1826,     0,     0,  2227,  2213,   728,     0,     0,     0,     0,
    2214,  1335,  1333,  1343,     0,  1301,  1330,  1330,     0,  1301,
       0,     0,     0,  1574,  1427,  1576,  1367,     0,  1345,     0,
    1432,     0,     0,   874,     0,     0,     0,     0,     0,     0,
     904,     0,   917,   864,   884,   906,   696,   975,  1424,   879,
     881,   951,     0,   591,     0,   755,   621,   614,   632,   681,
     676,     0,   681,   681,   641,   659,   636,     0,   739,   649,
     640,   661,   664,   666,   668,   681,     0,   739,   638,   625,
     681,   704,     0,     0,     0,   700,     0,   749,     0,   707,
     609,   697,   699,     0,     0,   662,   739,   618,   747,   746,
     620,   739,   746,   681,     0,   695,   681,     0,   131,   136,
     147,   148,   834,  2446,     0,  2444,     0,  1005,  1373,    97,
       0,     0,   204,   202,   203,     0,   197,   199,   194,  2457,
       0,  2464,     0,     0,  2462,   426,   428,   436,   524,     0,
       0,  1433,   812,     0,     0,  1450,  1175,   690,   688,   691,
     689,   735,   734,   738,     0,   737,   746,     0,  1179,  1180,
       0,  1268,  1259,  1204,     0,  1155,  1228,     0,     0,  1211,
    1187,  1190,  1188,  1194,  1195,  1038,  1038,   583,  2399,  1077,
    1708,  2354,     0,     0,  2350,  2348,     0,  2349,  2347,  2321,
       0,  2276,  2277,  2275,  2262,     0,     0,     0,  1046,   466,
       0,   483,   482,   479,  1438,  1553,  1555,  1561,  1550,     0,
    1412,  1427,   720,  1486,     0,  1040,  2225,  2224,  2226,  2220,
       0,     0,     0,     0,  1317,     0,  1321,  1326,  1322,     0,
    1313,  1311,     0,  1449,  1355,  1356,     0,     0,  1361,  1365,
    1438,  1433,   877,     0,   604,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   903,  1803,   893,   895,   861,
       0,   866,   559,     0,   754,     0,   759,   685,   686,   687,
     642,   682,   684,     0,   644,   612,   637,   667,   643,     0,
     639,   626,   710,   709,  1053,   702,   713,     0,     0,   708,
     698,   706,   701,   617,   619,   623,   624,   610,     0,   611,
    1836,   138,   847,   278,  2448,  1021,     0,  2453,   119,  2461,
    2471,   201,     0,     0,   142,     0,   192,   727,   195,  2383,
    1760,     0,   431,   786,     0,   811,     0,   788,   790,   745,
     743,     0,  1271,  1433,     0,  1230,  1232,  1341,   584,  2327,
    2326,  2325,  2322,     0,     0,     0,     0,     0,     0,  2352,
    2356,  1564,     0,     0,     0,   474,     0,     0,   508,   522,
    1420,  1433,     0,  1438,     0,  1491,  1484,  2230,  2229,  2215,
    1336,     0,     0,     0,     0,     0,  1374,  1573,  1351,  1351,
    1362,  1346,  1431,   876,     0,     0,   786,     0,     0,  1805,
    1804,   917,     0,   752,     0,   756,   757,   758,     0,   750,
     683,     0,   818,     0,   712,  1053,   705,     0,   140,   304,
       0,   290,   276,     0,     0,     0,   280,   149,   152,   150,
       0,   151,   157,     0,   158,   159,   160,   161,   162,   153,
     302,   303,   156,   154,   155,     0,  1852,     0,  1853,  2451,
       0,     0,  2450,   168,   198,     0,     0,   134,   143,  2465,
     711,   429,   427,     0,  2379,     0,  1558,   106,   787,   803,
     802,   792,  1433,     0,     0,   108,   789,   805,   796,   110,
     791,   804,   794,   680,     0,  1273,  1153,  2323,  2357,  2360,
    2358,  2359,  2361,  2355,     0,  1750,  1047,     0,   467,     0,
     470,   472,   486,     0,  1558,     0,     0,  1558,  1558,  1558,
    1558,   501,   509,   511,     0,  1421,  1422,     0,  1417,  1419,
    1413,  1474,   721,  1763,  2386,  1318,     0,  1323,     0,  1315,
       0,     0,  1359,  1357,     0,   786,   596,   788,   790,   896,
       0,   753,     0,     0,   739,     0,   739,   703,   139,     0,
     132,     0,     0,   289,   292,     0,     0,   295,   285,   284,
     286,     0,   279,   278,   278,   332,   283,   329,   328,   321,
    2383,     0,     0,     0,  2472,   200,  1046,   146,     0,   433,
     432,   801,     0,   793,   810,   813,     0,   797,   795,  1433,
    1570,  1578,     0,   720,     0,   475,   468,     0,     0,   484,
       0,  1558,  1558,     0,     0,     0,     0,     0,   481,   510,
    1558,  1433,     0,  1029,     0,  1771,  1337,     0,     0,  1375,
       0,  1352,     0,     0,     0,   600,   599,   597,   598,     0,
     765,     0,   764,     0,   761,   760,   646,   819,   648,   141,
     305,   316,   319,   311,   291,     0,     0,     0,   281,   278,
       0,   265,   263,   264,   270,   271,   272,   273,   274,   275,
     266,   269,   267,   268,   278,     0,   209,     0,     0,  2452,
       0,  2454,     0,   178,   177,   169,     0,   278,  2458,     0,
    2466,  2383,   800,   806,  1272,     0,     0,  1751,   462,   474,
     471,   494,   487,   490,     0,   519,     0,     0,   515,   516,
     514,   512,   505,     0,   503,     0,  1418,  1475,     0,     0,
       0,     0,  1764,  1766,     0,  1492,  1320,  1325,  1354,  1353,
    1368,     0,   882,   767,   768,   766,     0,     0,     0,     0,
     278,   312,     0,   287,     0,     0,     0,     0,   207,   335,
       0,   205,   323,   323,  2455,  2456,   179,  2473,     0,   148,
     168,   434,  1577,  1579,  1777,   469,   494,     0,   492,     0,
     488,   485,   489,   517,   518,     0,   502,     0,   513,     0,
       0,     0,     0,     0,  1765,     0,     0,  1772,  1774,     0,
       0,     0,     0,   313,   319,   309,   317,   278,     0,     0,
     277,   296,   331,   208,     0,   333,     0,   278,     0,   322,
     324,   326,     0,   130,  2467,     0,  1763,   491,     0,   499,
     495,   497,   500,   508,   507,   504,  1046,  1769,  1770,     0,
    1767,     0,     0,  1773,  1360,  1358,   763,   762,     0,   310,
       0,     0,   308,   288,   293,   278,     0,   278,   220,   219,
       0,   211,   259,   330,     0,   210,  2459,   278,     0,  1771,
     493,     0,     0,   506,     0,     0,  1478,  1480,  1768,  1776,
    1775,   314,     0,   278,     0,   278,     0,   278,     0,     0,
       0,     0,     0,   206,   278,  2468,     0,  1779,   498,   496,
    1047,  1476,  1046,     0,   306,   278,   294,   299,   336,     0,
     214,   260,   261,     0,   217,  2460,  1778,     0,  1783,  1481,
    1479,   278,   278,   295,   298,   334,     0,     0,   212,   213,
     225,   224,   216,     0,     0,     0,  1790,   278,   278,   300,
     233,   231,   278,   221,   229,   223,     0,   230,   262,   218,
    1781,  1782,  1780,  1785,     0,     0,  1787,  1788,     0,  1752,
       0,   215,   232,  1789,  1784,     0,  1791,  1793,     0,   222,
    1786,     0,  1046,  1792,     0,  1047,  1794
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    56,   575,  1378,    57,    58,    59,    60,    61,  1249,
      62,   774,  1186,  1664,  1665,    63,   515,    64,   971,  1435,
    1436,  2849,  2850,  1437,    65,  1992,  2887,  2888,  2889,  1454,
     485,   486,  1851,  1852,   996,  2870,  2836,  3601,  2840,  3708,
    3840,  3747,  1924,  3175,  3602,  3603,  3717,   510,  1990,  1392,
    3864,  1831,  3965,  1832,    66,   605,   969,  1414,  1415,  3193,
    3194,  3433,  3195,  3425,  3426,  3427,  3428,  4087,  3939,  4031,
    4088,  4160,  4196,  4202,  4203,  4130,  4212,  4213,  4214,  4200,
     841,  4215,    67,   538,   539,   843,  1278,  2238,  1279,    68,
    4131,  4198,  3940,  3941,  3847,  3942,  3720,  3943,  3851,  3944,
    3723,  3945,  3946,  3947,  3948,  4079,  3949,  3846,  4123,  3936,
    3937,  4125,  4177,  4194,  3950,  3730,  3841,  4018,  3731,  3842,
    4074,  3932,  4075,  4118,  4173,  3933,  4019,  4121,  4022,  3951,
    3957,  4089,  3952,  3958,  3953,  3735,  3858,  3956,  3856,  3955,
    4127,  4084,  2477,  2869,   593,   594,   616,  1982,   595,   985,
     944,  1394,  1864,  1865,  2342,  2343,  2459,  2460,  2461,  1856,
    1857,  1858,  1970,  1971,  1972,  1838,  1839,  1840,  1398,  1835,
    1836,   596,   945,   955,  1859,  1860,  1861,  2465,  1974,  1975,
    1976,  1977,  1862,  1657,  1863,  2736,  2483,  2880,  3619,  3203,
    3754,  3971,  2881,  2882,  2410,  2798,  2390,    69,   527,   821,
    1246,  2211,  1247,  2213,  2622,  2623,  2624,  1703,  1704,  3499,
    1708,  2210,  3655,  3979,  3789,  3790,  2626,  3788,  2630,  2995,
    2996,  3275,  3501,  3658,  3984,  3888,  4051,  3982,  4047,  3983,
    4049,  4142,  4100,  4101,  3898,  3993,  3994,  4055,  4103,  3801,
    3802,  3803,  2231,  2636,  3504,  3439,  1964,  1384,  1385,   487,
     488,   489,   613,  2484,  1911,  2485,  2486,  2813,  1913,  1914,
    2597,  1312,  2810,  2787,  3475,  2876,  2817,  2818,  2819,  2820,
    2821,  2827,  2754,  2351,  2352,  2415,  2830,  3617,  3361,  3376,
    3159,  3160,  3161,  3162,  3163,  3164,  3165,  2904,  2905,  3570,
    3571,  3572,  2900,  2901,  3406,  3390,  3391,  3392,  3618,  3585,
    3223,  2677,  2678,  3665,  2686,  2687,  2725,  3040,  2726,  1388,
    3224,  3225,  3226,  3400,  3393,  2829,  3355,  3563,  3566,  3699,
    3924,  2353,  2755,  2354,  2758,   900,   490,  2355,  2356,  1468,
    1469,  3757,  3765,  3769,  3758,  3770,  3766,  3759,  3760,  3761,
    3772,  3768,  2490,  3440,  3441,  2747,  2960,  3701,    70,  1402,
     938,   947,   943,   961,   600,  1403,  1925,  2421,  3412,   583,
    1915,  3347,  3089,  3351,  1916,  2767,  1917,  3076,  3333,  1918,
    3105,  3349,  3560,  2768,  2769,  1919,  1920,  1921,  3088,  3097,
    3691,  2357,   123,  2156,  2825,  2397,    71,  1360,  1355,    72,
     912,   907,   908,  1358,  1359,  1797,  2287,    73,   608,  1441,
      74,  1257,  2223,  2224,  2225,    75,   962,    76,    77,   609,
    1448,  1449,  1450,    78,  1242,   130,    79,   829,  1252,  1254,
    1255,    80,   604,   963,   964,   965,   966,  1930,    81,  1695,
    2187,  2188,  2189,  2190,  1411,  2423,  1412,  1413,  1939,  2988,
      82,    83,   572,  2111,   544,   850,   545,   546,  1737,  2251,
    3476,   861,   862,   863,  2662,  1290,  1291,  1292,  2256,  2667,
    1041,   739,   740,   741,   742,  1134,  1135,  3394,   743,  1144,
    1623,   744,   745,   746,   747,   748,   749,  1650,  2928,  2929,
    3241,  2141,  2142,  2143,   750,  2029,  2915,  2042,   751,  1127,
    1608,  1540,  3233,  2921,  3460,  3632,  1485,  2012,  2520,  2594,
    2105,  1066,  1067,  1031,  2019,  1491,  1804,  1805,  1806,  1807,
    1808,  3321,  3320,  3322,  3671,  3525,  3673,  3529,  2298,  1809,
    1810,  2700,  3523,  3814,  2106,  2107,  2108,  3251,  2701,  3056,
    2719,  2720,  3540,  2289,  1811,  2707,  3822,  3537,  3538,  3914,
    3913,  3539,  3326,  3327,  3069,  3070,  2845,  2846,  2847,  3675,
    1531,  1532,  1538,  1229,  1230,  1486,  2185,  2611,  3511,  3662,
    2132,  3292,  3660,  3808,  1922,  2793,  2794,  2253,  2254,  2723,
    3073,  3102,  1315,  3477,  2613,  1770,  1771,  3212,  4201,  2206,
    2435,  2737,  2738,  2208,  3903,  4059,  4145,  4146,  4147,  3022,
    3023,  3296,  3297,  2255,  2659,  3024,  3512,  3813,    84,   494,
      85,  1662,  2147,  1183,  2161,   973,  1472,  1473,   762,   507,
      86,   516,  2186,    87,   534,  1721,   813,   833,  1260,  1261,
    2232,  2637,  2644,  2233,  2649,  3285,  2639,  3001,  3002,  2151,
    2152,  2640,  3004,  3282,  3265,  3266,  2983,  3496,    88,   560,
    3067,  2714,  2715,  3880,  3881,   834,    89,   493,  1018,  2001,
    1478,  2000,  1019,  1020,  2003,   634,   635,    90,   914,   557,
    1337,  1338,  1339,  1786,    91,   549,   901,  2690,  2696,  1765,
     825,  1179,  1319,   904,  1320,  1751,  2271,  1301,    92,   934,
     933,    93,   579,  1380,    94,   775,  1202,  1674,  2601,  2971,
    1203,  1204,  2162,    95,   535,   838,   839,  1263,  1723,    96,
     529,   826,  1714,    97,   520,    98,    99,   817,  2989,  3883,
    4044,   524,  1697,  1238,  3204,  3905,  4002,  4003,  4005,  4067,
    4068,  4096,  4188,  4222,  4206,  4225,  4226,  4229,  4236,  4237,
     753,   921,   754,  3555,   755,   756,  2645,  2646,  3074,   757,
    2647,   758,  2748,   974,  1475,   513,   465,   590,   922,  2619,
     760,  3737,   941,   989,   467,   468,   100,   865,   548,  1294,
    1295,  1296,  1746,  1747,   905,  2120,  1748,  1749,  2268,  2263,
    3304,  3046,  3038,   101,   818,   472,  1240,  1241,  2196,   102,
     559,   103,  1231,  1691,  1692,  2182,  2610,  2183,   104,   846,
     105,   800,  1685,   801,  1207,   802,   803,  1221,  1215,  1224,
    1218,  3643,  3488,  3489,  2170,  1182,   990,   991,  1677,  2164,
    2165,  3260,  3491,  2974,  3649,  3650,   106,   131,   475,   611,
     980,  1284,   107,   108,   109,   110,  1287,  1373,  2247,  1374,
    2112,  1375,  1376,  1818,  1735,  1604,  1605,  2958,  1124,  1125,
    2115,  2567,  2568,   864,   620,  1006,   998,   124,   125,   126,
     623,   624,   127,   959,   960,  2422,  2842,  3177,  3415,  3416,
    3607,  3742,  1000,  3613,  4038,  4164,  1001,  1002,  2871,  3615,
    3868,  4040,  4137,  1003,  2474,  3190,  3743,  3967,   111,   923,
     569,  1371,  1366,  1368,  1814,  2305,   112,   113
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3606
static const int yypact[] =
{
    4367,  2376,    64, -3606,  -127,   832, 42666,   138,  1080,  1080,
     433,  2656, -3606, -3606, -3606, -3606, -3606,  2987, -3606, 42666,
      64, -3606, 23336, -3606, -3606,   688,   790,   128,  1080,    64,
   -3606, 42666, -3606,   635,  1349,    64, -3606, -3606, 37986, -3606,
     433, 42666, -3606,   771, -3606, 37986,   496,  -114,   685,   649,
    1006, -3606, -3606, 42666,  2180,   863,  1237,  1163, -3606, -3606,
    1074, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, 23925, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606,  1330, 42666,  1335, 42666, -3606,  1348,
   42666, 36231, 42666,  1035,  1471, -3606, -3606,  1456, -3606, -3606,
    1080,   433, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606,   957, -3606, -3606,  1082,
   -3606, -3606, -3606, -3606, -3606,  1608,  1441, -3606,  1497, 36231,
   -3606, 42666, -3606, -3606, -3606,   870, -3606,  1186, -3606,  1212,
    1528,  1540,  1559,  1120, 11378,  1553,  1553,  1553, 42666,  1589,
    1553,  1553, 42666, -3606,  1553, -3606,  1553,  1080, -3606, -3606,
    3753, 42666,  1437,   462,   662, 36231,  1432, 42666, -3606, -3606,
   11378, -3606,  1566, -3606, -3606, -3606,  1080,  1770,  1637,   858,
   42666, -3606, -3606,  1080,   191,   599,  1258, -3606, -3606,  1380,
   -3606,  4111,   165, -3606, -3606, -3606,  2324, -3606, -3606,  5415,
    1380, -3606, -3606, -3606,  1274, -3606, -3606, -3606, 42666,  1080,
    1568, -3606, -3606,   149,   149,   149, -3606,   149, -3606,   149,
   -3606,   863,  1266, -3606, -3606,  1269, 42666,   888,   985, -3606,
   -3606,  1283,   764, -3606,  1390, 33306, -3606, 42666, -3606, -3606,
   -3606, -3606,  1577, -3606, -3606, -3606,  1544, -3606, 23336, 42666,
    1467, -3606, -3606, -3606, 23336,  1347, 42666, -3606, 23336, 23336,
     203,    26,  1381, 42666, 42666,  1785, -3606,  1925, 33306,  1551,
   -3606,   204,   -87,  1456,  1966, -3606,  1441, -3606, 42666, 42666,
   42666, -3606, -3606, -3606, 38571,  1120,  1377,  1379,  1382, 15620,
   -3606,  1384,  1396,  1402, 11378,  1405,  1409,  1415,  1433,  1444,
    1446,  1451,  1454,  1473,  1473,  1477,  1487,  1492,  1503,  1067,
    1516, -3606,  1521,  1556,  1560, -3606, -3606,  1563,  1575,  1584,
   -3606,  1598,  1609,  1621, 11984,  1629,  1632, -3606, 20387,  1638,
    1643,  1647,  1669,  1671,  1692,  1694,  1698,  1704, -3606, -3606,
   11378,  1708, -3606, -3606,  1712, -3606,  1718,  1730,  1743,  1746,
    1748,  1755,  1760,  1767,  1779,  1786,  1791,  1800,  1821,  1830,
    1834,  1843, -3606,  1527,  1850,  1853,  1533,  1863, -3606,  1868,
   -3606,   256,  1878,  1473,  1473,  1473,  1882,  1885,  1887,  1891,
    1904, 15620, 15620, 15620, 11378, -3606, 42666, -3606, 42666,  1363,
    3070, -3606,  2455, 15620,   899, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606,  1499,  1602, -3606, -3606, -3606, -3606, -3606,  1907,
    1681,  2032, 42666, 42666, 42666,  1994, 42666, 42666, 36231,  1829,
   42666, 33306, -3606,  1553,  1811,  3125,  2013,  2075,  1375, -3606,
   -3606, -3606, -3606, -3606,  2160, -3606, -3606,  2014, -3606,  2183,
   -3606, -3606,   318, -3606,    89, -3606, -3606, -3606, -3606, -3606,
   -3606,  2186,  1932, -3606, -3606,   151, -3606, -3606, 42666, -3606,
   -3606, -3606, -3606,  2325,  2070,  1363,  2508,   900, 23336, -3606,
      79, -3606,  -176, -3606, -3606,  2298, -3606, -3606, 33306, 23336,
   -3606, -3606, -3606, 20976, -3606, -3606,  2524, -3606,  1987, -3606,
   -3606,  1602,  3155, -3606,  2013,  2249, -3606,  2251,  2163,    26,
    2064, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,  2019,  2324, -3606, -3606, -3606, -3606,  2461, -3606,  2166,
     648, -3606,  2024,  1706,   648, 33891,  2379,   884, -3606,   292,
   -3606,  2463, -3606, -3606, -3606, -3606,  2155,  2158, -3606, -3606,
     338,  1721, -3606,  2519, -3606,   711, -3606,  2199,  2379,   648,
     884, -3606,  2435,  2553,   392,   508, -3606, -3606,   -75, -3606,
   -3606,  2622, -3606, -3606, 23336, -3606, -3606,  2325, -3606, -3606,
   -3606,  2102, -3606,  2361,  2207, -3606, -3606,    52, -3606,  2114,
       9,  2571, -3606,  1001, 34476, -3606, -3606, -3606,  2605,  2621,
    1473,  2120, -3606, -3606, -3606,  2727, -3606, -3606,  2133,  2636,
    2636,  2636,  2740, -3606, -3606, -3606, -3606, -3606,  2296,  2174,
   -3606,  1467, 23336,  2520,  2153, -3606, -3606,  2392, 11378, -3606,
   -3606,  4660,    22, -3606, -3606,   221, -3606,  2709,  2367, -3606,
   -3606, -3606, -3606,  2619, -3606, -3606,  2727,  2678,  2636,  2575,
    2192, -3606, -3606, -3606, -3606, -3606, -3606,   215, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,   230, -3606, -3606, -3606, -3606,
   -3606,  1467, -3606, 23336, -3606, -3606, -3606, 23336, -3606,  2196,
   -3606,  2191, -3606, 11378, 11378,   313,  2743,  2796,  2796,  2796,
    1363,  2247, 11378, 11378, 11378, 11378, 11378, 11378, 11378,  1245,
    2212, -3606, -3606,  8954, -3606,  2220, 11378, 11378,  2309, 11378,
    1602, 11378, 24514, -3606,  3626, 11378,   331,  2698, 11378, 11378,
   11378, 11378,  4044, 11378, 11378, 24514,  2823,  2229, -3606,  2231,
    1445, 11378, 11378,  1465, 11378, 11378, 11378, 11378, 11378, -3606,
    8954, -3606, 11378, 11378, 11378, 11378, 15620, 11378, 11378, 11378,
   11378, 11378, 11378,  2796,  2796, 11378, 11378,  1529,  8954, -3606,
   11378,  1602,  2269,  2269, 11378,  1602,  7742, 11378, -3606, -3606,
   -3606,  2235, -3606, -3606, -3606, 24514,  2796,  2796, 11378, 11378,
    2743,  2743,  2743,   187,  2239,  1003, 11378, 25692,  2233, -3606,
   -3606, -3606, -3606, 11378, 11378, 11378, -3606, 15620, -3606, -3606,
    1795, -3606, -3606, -3606, 12590, 15620, 15620,  2232, 15620, 15620,
   15620, 15620, 15620,  2595, 15620, 15620, 16226, 16832, 15620, 15620,
   15620, 15620,   952,  2743, 36231, 15620, 11378, -3606, -3606, 42666,
   -3606, -3606, -3606,  2241, 23336,  1829, -3606, -3606,   -64,  2705,
   -3606, -3606,  2244, 23336, -3606,  2250, -3606,  2597, -3606,  2599,
    2600,  2602, -3606, -3606, -3606, -3606,  2819,  2610, -3606, -3606,
    2615, -3606, -3606,  2265, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,  2374, -3606, -3606, -3606,  2283, -3606, 33306,  2283, -3606,
   -3606,  2283, -3606, -3606,  2283,    63,  2840, -3606, -3606, 42666,
   -3606, 43251, -3606, 20976,  -127, -3606, -3606, -3606,  2631,   162,
    2287, -3606, 23336, -3606,   102,   102,  2525,   183, 36231, -3606,
   -3606,   157,  2291,  2369,  2297, -3606,  2370, 23336, 23336, -3606,
   -3606, -3606, -3606,  2903,   599, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,  2312,  2768,
    2317, 33306,   748, -3606, 42666, -3606,  1558, -3606, -3606, -3606,
    2319, -3606, 11378, -3606,  2321, -3606,  1654,  2699, -3606,  -127,
   11378, -3606,  2331,  1441, 42666, 42666, 42666, 23336, 42666, 23336,
   -3606,   787,   787, -3606, 31551, -3606, -3606, -3606, -3606,   648,
   42666, 42666,   648, 33306, -3606,   884, 42666,   648, -3606,  2700,
    2423, -3606, -3606, -3606,  2762, -3606, -3606,  2753,  2332, -3606,
    2699, -3606, -3606,   884, -3606, -3606, 23336, -3606, -3606,   884,
   -3606,   884,   884,   648,   648,  2381, -3606, -3606,  2339, -3606,
    2381,  2476, -3606,   925,   149,  2573, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606,    96, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606,   132, -3606, -3606, -3606,  2041,  2818,
   -3606, 36231,  2083,   763,     4,  2083,  1895,  -127,   998, -3606,
     998, -3606,  3356,  2601,   209, 23336, -3606,  2345, 39156, 23336,
   -3606, -3606, -3606,  1177,  2353,  2354,  1363,  2805,  2808,  2810,
    2812,  2814,  2815,  2817,  2820,  2827,  2828,  2830,  2832,  2834,
    2835,  2838,  2841,  2842,  2846,  2388, -3606, -3606, -3606, -3606,
   23336, -3606, -3606, -3606, -3606,  2415, -3606, -3606, -3606, -3606,
    1714, -3606, -3606, -3606,   207,  1914,  2418,  2446,   113, 33306,
    2822, 42666, 42666,  1441, 42666, 42666, -3606, -3606,  1018,  2662,
    2663,  2667,  2411, -3606, -3606, -3606,   815, 42666,  2837, 28041,
   -3606,   315,   935, -3606,  2796,  2413, -3606,  2419,  2421,  2422,
   11378,    36,   293,   937,  -209,  1259,  1042,   357,   206, -3606,
    2424,  2429, -3606,  1126, -3606,   414,   449,  1133,  1149,  2425,
    2428, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,  2853, -3606,  1356, -3606, -3606, -3606, -3606,  2432, -3606,
   -3606,  1164,   451,   456,   241,  2444,   461,  1426,  1439,  2443,
   24514, 42666,  2796,  2453,  1170,  1181,  2796,  2456,   479,  1191,
    1468,  1601,  1603,  1197,  1223,  1228,   491,  1618,  2179,  1233,
     500,   541,   558,   777,  1243,  2458,  2459,   782,   196,  2796,
    2464,  1254,   285,  2442,  2460,  1281,  9560, 10166, 10772,   642,
     802, -3606,  2465, -3606,  2231,  2466,  2468,   289,  1289, -3606,
   11378, -3606, -3606,  1033,   828,  2526,   146,   872, -3606,  2618,
   42666,  2228,   152, -3606, -3606, -3606, -3606, -3606, -3606,   715,
   -3606,  2474, -3606,  2477,  1690,  2478, 11378,   928,  2478,  3032,
    2307,  2307, 15620,  3098,  2685, 11984,  1021, 11984,  1021,  2478,
    2478,  2478, -3606, 15620,  2481, 15620, 15620, -3606,  2743,  1363,
    2482,  1049, 42666, -3606,   -64, -3606, -3606, -3606, -3606,   695,
   33306,   116, 23336, 36231,  2484, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606,  4057, 23336, -3606, 42666, -3606,  2557, -3606,
   -3606, -3606, 21565, 21565, -3606, 21565, -3606, -3606,   295,   853,
    2795,  2514, -3606, -3606, -3606, 23336, -3606,  2876,   639, 23336,
    2345,  2494, -3606, -3606, -3606, -3606, -3606,  1965,  2596, -3606,
    3093, -3606, 11378,  -127, -3606, 33306, 33306, 23336, 23336,   636,
   -3606,  1135, -3606, -3606, -3606,  3155, 17438,  2914,  2925, 21565,
   21565, 21565, -3606, -3606, -3606, -3606, -3606,   799,  1363, -3606,
    2498, -3606, -3606, -3606, -3606, -3606, 39741,   258, -3606, -3606,
    -127,  2930, -3606,  1363,  2510, 42666, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,   -71, -3606, -3606, -3606, -3606, -3606, -3606, -3606,   648,
   -3606, -3606, -3606, -3606, -3606,  2722,  2379,  1721,  2930,   648,
     884, 23336,   648,   648, -3606, -3606,    44, -3606,   -75, -3606,
   -3606, -3606, -3606, 42666,  1127,  2661, -3606,  2513, -3606, -3606,
   23336, -3606,  2516, -3606,  2938,  3076,  2379, -3606, -3606, -3606,
     695,   695,  2801, -3606,  -127,  2641,  2647,  2650,  2664,  2668,
    2701, -3606, -3606,  -127,  -127, -3606, -3606,   695, -3606,  1960,
   -3606, -3606, -3606, -3606,  -127,  -127,  -127,  -127,  2547,  -127,
    -127,  1660, -3606, -3606,   695,   695, -3606,  1739, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,   915, -3606,  2660,  3082,  2785,
     695,   695,  3082,   695,  2786,  2787,   695,   695,  2630,  3033,
     695,  2922,  2652,  2295,  2926,   695, -3606,  2653,  3042,   695,
     695,   695,   695,  3082,  2803,  3128,   695, -3606,   695,  2806,
    2811,   170,  2821,  2824,   695,  1085, 42666,   695,  2825,   695,
   -3606, -3606,  3238, -3606, -3606, -3606, -3606, -3606, -3606,   806,
   22156, -3606, -3606,   336, -3606,  2764, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,  2576, -3606,
   -3606, 11378,  2580,  2547,  -127,  -127,    77,  -127,  2547,  -127,
    -127,  -127,  -127,  -127,  2547,  2547,  -127,   827,  -127,  2547,
    4660, -3606, -3606, -3606, -3606,   213,   695,   695,   695,   695,
   -3606,  2242, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   36231,  2927,  2238,   -58, 36231, -3606, 42666, -3606,  1410, 42666,
    2590,  -128,  2915,   171,   171, -3606, 23336, 23336, 23336, 42666,
    2635,  2514, 28041, -3606, -3606,   925, -3606,  2583, 13196, -3606,
    2612, -3606, 11378, -3606, -3606, -3606,  1075, 11378, 11378,  3052,
    2566, -3606, 35061, -3606, -3606, -3606, 11378, 35061,  2566, 11378,
   -3606,  2613, -3606,  2973,  2977, -3606, -3606, -3606, -3606, 11378,
   -3606, 11378, 11378, -3606, 11378, 11378, 11378, 11378, 11378, -3606,
   -3606, 15620, -3606,  2598,  2616, -3606, -3606, -3606,  2617, -3606,
   11378, -3606, -3606, -3606, -3606, -3606, -3606, -3606, 11378, -3606,
   11378, -3606, 11378, 11378, 11378, 11378, -3606, -3606, -3606, 13802,
   11378, 11378,  2625, -3606, -3606, -3606, 11378, 11378, 11378, -3606,
   11378,   159, 11378,   355, 11378,   484, 11378, -3606, 11378, -3606,
   -3606, -3606, -3606, 11378, -3606,  1672, -3606, -3606,  1695, -3606,
    1033,  2626, -3606, -3606,  1558, -3606, -3606,  2603,  2611,  2614,
   36231, 11378, -3606, -3606, -3606, -3606, -3606, -3606, 15620,   291,
    2627, 15620, -3606,  3032,  4044,  4044,  1955, 11378,   928,  3032,
   11378,  2629,  2608, -3606, 11378, 42666, -3606, -3606, -3606, -3606,
   -3606, -3606, 36231, -3606, -3606, -3606, -3606,   116, -3606,  2250,
   -3606,  2345, -3606, -3606,  1678, -3606, 33306,  2623, -3606,  2624,
    2706,  2708,  2713, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,  2379,  1135, -3606,  2634, -3606,
   -3606,  2392,  2726,  2672,  2986, -3606, -3606, -3606, 42666, 15620,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,  3201,
    2657,  2658,  3100,  2659,  1363, -3606,  2736, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,   675, -3606, -3606,  2665,  2665,
   19207, -3606, -3606, -3606,  3116,   -59,   -59,   -59, -3606, -3606,
   -3606, -3606,  2918, 33306,  3091,  3095,  3108,  1001, -3606,   740,
   -3606,   174,  3064,  2379, -3606,  3111, 36816, -3606, 28626, -3606,
    2689,  3061,  2692,   695, 30966,   940, 26280, 32136, -3606, -3606,
      77, -3606,   180, -3606, 31551, 31551, -3606,  2962, -3606, -3606,
   -3606, -3606,  2514,   884, -3606, -3606, -3606,  2703, -3606, -3606,
    1038,  3068,  3071, -3606,  2950,  1121,  2950,  1038,  1038, 24514,
     925,  2185, -3606,  2547,  3004, -3606, -3606, -3606, 35646, 32721,
   -3606, -3606, -3606, -3606,  3208, -3606,  3210,   959, -3606, -3606,
    2328,     4, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606,  1895,  2328,  2328,
     998, -3606,   121, -3606, -3606, -3606, -3606, -3606, 25103,    64,
   -3606,   361, -3606, 25103, -3606,  1177,  1177, -3606, 25103,    64,
      77,  2547, 25103,  2547, 40326,    64,  -127,  -127,  2246,   695,
    2547, -3606, -3606,  3077, 42666,  3078, 25103, 25103, -3606, 36231,
   -3606,   695,  1155,  2547,    77,    77, 25103,    64, 24514,  2609,
   -3606,  -127,    64, -3606, -3606, -3606, -3606, 23336,    64,    64,
    1663, -3606, -3606, -3606,  2547, 40326, -3606, -3606,  4747, -3606,
   -3606, -3606, 18618, 42666,   269,   383, -3606,  2711,    27,  1188,
    2794,  1276,  2714,  2723, 40911,  1363,  2547, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
    -127,  1965,  2328,  2328,  1914, -3606,  2972,  3132,   695, -3606,
    2224, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
    2809, -3606,  3310,  2900,  2730, -3606, -3606,   145, -3606, -3606,
    1103, 23336, 18029, -3606,  2963, -3606,  2632, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606,  2724,   925,  2979,  1408,
    2514,  2741, -3606, 11984,  1329, -3606,  1363, 11378,  1363,  1518,
   -3606,  2744,  2744, -3606, -3606,  2749,  2744,  3112, -3606,  3117,
    2751, -3606,  2752, -3606,  1337,  2760,  2761,  1499, -3606, 11378,
   11378,  1339,  1341,   -91,   820,   847,   332, -3606,  1373,  3204,
   -3606, -3606,  1400,  1406,  1411,  1447,   860,  1452,  1725, 11984,
    1460,   972,   368, -3606,  1484,   907,   916,  1493, 11378,  1548,
   11378,  1592, 11378,  1599,  1610,  1612, -3606,  2019,  1695, -3606,
   -3606,  2763, -3606, -3606, -3606, -3606, -3606,  2742,  1363,  2771,
   -3606, -3606, 11378, -3606,   899, -3606, -3606, 15620,   391,  2772,
   -3606,  1363, -3606, -3606,  2774,  1499, -3606, -3606, -3606, -3606,
   -3606,  2776, -3606, 42666,   444,  2782, 29211, 33306, 33306, 33306,
    2769, 11378, -3606, -3606,  3037, 23336, -3606,  3167, -3606, -3606,
   -3606, -3606,  2784,  2781, -3606, -3606, -3606,  3032,  3136,  3021,
   -3606, -3606,  1965, 42666, 33306, -3606,  2324, 24514, -3606,  2788,
   -3606,  2788,  1000,  2790,  1750, -3606, -3606, -3606,  2793,  2064,
   17438,  3212,  2192, 33306, 33306, 33306, -3606,  2514,  2514,   769,
    2845,  3166, -3606, -3606, -3606, -3606, 41496, -3606, -3606, -3606,
   -3606,  1196, 42666,  3148, 42666,  8348, -3606, -3606,  3336, 11378,
   33306,   673,   872,   695, -3606, -3606, -3606, -3606, -3606, -3606,
    2379, -3606, -3606, -3606, -3606, -3606,  2379, -3606,   648,    44,
     738,   828, -3606,  1832, -3606, -3606, -3606,  3168,  1038,  2950,
    2950,  3169,  3060,   908,  2816, -3606,   695, -3606, -3606, -3606,
    2324, -3606, -3606, 11378, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,   915, -3606, -3606, -3606, -3606,
    2813,  3170,  3174,  1177, -3606, 25103, -3606, -3606, 25103, 25103,
     111, 40326, -3606, -3606, -3606, -3606, -3606, -3606,  2826, -3606,
   -3606,  1965, -3606, -3606, 32721,  -127, -3606, 25103,  2826, -3606,
   -3606,   193, -3606,  -127, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, 40326,  2829, -3606,  1365, -3606, -3606,  1770, -3606,
   40326, -3606, -3606, 40326, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606,  2833,  2738,  1389, -3606,  2847,  2839, -3606,
   -3606, -3606, -3606, 42666, -3606, -3606, 23336, -3606, -3606, -3606,
    5688, 42666,  3038, -3606, 11378, 11378,  3084, 42666,  3085, -3606,
    3345, 42666,  3405, 40326, -3606,  2848, -3606,  2849, -3606,  1756,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606,  2844, 42666,  2328,
    2238, -3606, -3606,  -127,  1103, -3606, -3606, -3606, -3606,  3089,
    3094, 42666, -3606, -3606, -3606, -3606,  2954, -3606, 23336,  3398,
   -3606,  2998, -3606,  2851,   218,  4780, -3606,  2850,  2854,  2855,
   28041,  2514,  3207, -3606, -3606,  4044, -3606,  1363, 11378,   861,
   -3606, -3606,   195,   905, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,  2860,  4044,  4044, -3606, -3606,
    3419,  3017, 11378, 11378, -3606, 11378, -3606,   228,  2864,  2889,
   -3606, -3606, -3606, -3606, 11378, -3606, -3606,  4044, -3606, 11378,
   -3606, -3606, 11378, -3606, 11378, 11378, -3606,  1627, -3606,  1689,
   -3606,  1719, -3606, -3606, -3606,  2319, -3606, -3606,  1003, 42666,
   -3606, -3606,  1774, -3606, -3606, 11378, -3606, 36816, -3606, -3606,
    3072, -3606, -3606,  3279, -3606, -3606, -3606,   -65,   -65,   -65,
   14408,  1363,  3333, -3606, -3606, -3606,  3167,  3227, -3606,    48,
   -3606, 42666,  2871,  1303, -3606,  1782, -3606, -3606,  2877, -3606,
    2019,  2875, -3606,   695, 14408,  2665,  2998, -3606, -3606,  1000,
   24514, 28626, -3606, -3606, 33306,  2192,  2192,  2192,  2379,  3287,
    2726,  2726, -3606, 26868, -3606, -3606,  3025, -3606, -3606, 29796,
   -3606,  1370, -3606, -3606, 15620,  1521, -3606,  1363, -3606, 35646,
   -3606,  1363,   695,  2882,  2885, -3606, -3606, 42081, 11378, -3606,
   -3606, -3606, -3606,  1558,   834, -3606,   925, -3606,  1038, -3606,
    3252,  3256,  1038, -3606, -3606, -3606, 24514,  2514, 14408, -3606,
     290,  2019,  1363,  2890,  1365, -3606,   630, 11378, 25103, -3606,
   -3606, -3606,  2893, -3606, -3606,  3379,  3380, -3606, 25103,  1714,
   42666, -3606,  3336, -3606, -3606, -3606, -3606,  5688, -3606, 24514,
   -3606, -3606, -3606, -3606, -3606, 42666, -3606, 23336, -3606, 18618,
   -3606,  2899, -3606,  2744,  2744,  2744, -3606, -3606, -3606, -3606,
   -3606,  2749,  3124, -3606,  2749,  2749, -3606, -3606, -3606, -3606,
   -3606,   195,  1808, -3606, -3606,   195, -3606, -3606, -3606,   117,
    1104,  2749, -3606, -3606, -3606, -3606, -3606, -3606, -3606,  2744,
   -3606, -3606, -3606, -3606,   195,  2744, -3606,  2744,  2276, -3606,
    1515,    94,  2744,  2744,  2744,  2905,  2895, -3606,  1363,  4044,
    3433, -3606, -3606,  3046,  -127,  3377, -3606,  1807, -3606,  2910,
   -3606, 40911, -3606,  2547,  1895, -3606, -3606, -3606, -3606,  3044,
     892, -3606,  3073,  2913,  2917, -3606, -3606,  -127,  2919,  2920,
    3238, -3606, -3606, -3606,  3506, -3606, 42666, 42666, 42666,  2583,
   -3606, 31551, -3606,  -216,  1363,  2924,  2928,  2929,  2933,  3492,
     205, -3606,  3495, 35061, -3606, -3606, -3606,  1812, -3606,  2934,
    2935, -3606,   149,  2941,  1735,   926,  1816,  3217,  3299, -3606,
    3154, -3606,  1814,  -211,  1859,  1880,  1896,  1901, -3606, -3606,
   -3606,  1501,   828, -3606, -3606,  1825, -3606,  3288,  3196,   334,
    2975,  2975,  2975,  1521,  1363,  1827, -3606, -3606, -3606, -3606,
    3331, -3606, -3606,  2951,  3093, 42666, -3606,  3021, -3606,  2319,
   24514, 14408,  2958,  2960, -3606,     9, -3606, -3606,  2952,  2192,
   -3606,  3519,  3367, -3606, -3606, 36231,  2964, -3606, -3606,  3255,
   -3606,   122,  3171, -3606, -3606, -3606,   673,  3054,  3057,   695,
    1363, -3606, -3606,  2513,  3102,  3009,  1038,  1038,  3326,  3015,
   11378, 11378,  2976, -3606,  2979, -3606, -3606,   354,  2319, 11378,
   -3606,  1965,  3021, -3606,  1919,  2980,  2981, 42666,  2982,  2984,
   -3606,  2843,   269, -3606, -3606, -3606,  2276,    64, -3606, -3606,
    2826,   675,  2974, -3606, 42666,  3290, -3606, -3606, -3606,   965,
   -3606,  2991,   965,   965, -3606,  2166, -3606,  3010,   195, -3606,
   -3606,  3018, -3606, -3606, -3606,   965,  2992,   195, -3606, -3606,
     965, -3606, 36231,  -127,  2555, -3606,  3041, -3606,  3469,  3359,
   -3606,  2276, -3606,  3360,  3261, -3606,   195, -3606, -3606,  3570,
   -3606,   195,  3570,   965,  3262, -3606,   965, 42666, -3606, -3606,
   -3606, -3606, -3606, -3606, 42666, -3606,  1039, -3606, -3606, -3606,
    1831,  -127, -3606, -3606, -3606,  3002,  3006, -3606, -3606, -3606,
    1188, -3606, 42666,  5688, -3606, -3606, -3606,  2963, -3606,  1063,
    1847,  1365,  3011,  1860,  1869, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, 35061, -3606,  3570,  3266, -3606, -3606,
   11378, -3606, -3606, -3606, 11378, -3606, -3606,  3300,  3447, -3606,
   -3606, -3606, -3606, -3606, -3606,   174,   174, -3606, -3606, -3606,
   -3606, -3606,  3096,  3099, -3606, -3606,  3103, -3606, -3606,   142,
    2044, -3606, -3606, -3606, -3606, 14408,  3376,  3121, -3606, -3606,
    3034,  3055, -3606, -3606,  1501, -3606, -3606, -3606, -3606, 11378,
   -3606,  2979,  2246, -3606, 26868, -3606, -3606, -3606, -3606, -3606,
    3020,  3036,  8348,  1003, -3606,  3074, -3606, -3606, -3606,  3079,
    1363,  1363, 42666,  3207, -3606, -3606,  1177,  1177, -3606,   354,
    1501,  1365, -3606,  1894, -3606, 42666, 42666,  1898, 42666, 42666,
     -59,   -59,   -59,   827,   827, -3606, -3606, -3606, -3606, -3606,
    3414, -3606, -3606,  1915, -3606,   734,  3295, -3606, -3606, -3606,
   -3606,   965, -3606,   149, -3606, -3606, -3606, -3606, -3606,   149,
   -3606, -3606, -3606, -3606,  1473, -3606, -3606,  3306,  3080, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,  3040, -3606,
   -3606,  3157, -3606, 48516, -3606, -3606,   863,  3069, -3606, -3606,
   -3606,  1152, 42666, 23336,  3084,  3223, -3606,  3336, -3606,     9,
     218,  2998, -3606,   778, 42666, -3606,  3312,   118,   214, -3606,
   -3606,  3053,  3051,  1365,  1940, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606,   349,  3304,  2547,  2547,  2547,  2547,  2044,
   -3606, -3606,  3104, 23336, 15620,  3160, 42666,  1253,  2503, -3606,
    1479,  1365, 11378,  2379, 32721, -3606, -3606, -3606, -3606, -3606,
   -3606, 11378,  3059, 11378,  3062,  1917, -3606, -3606,  3485,  3485,
   -3606, -3606, -3606, -3606,  1924,  1941,   778,  1943,  1962, -3606,
   -3606,   269,  3065, -3606, 42666, -3606, -3606, -3606,   148, -3606,
   -3606,  1976, -3606,  1980, -3606,  1473, -3606, 11378,  3521,  3101,
   42666,   103, -3606, 49686, 49686, 42666, -3606, -3606, -3606, -3606,
    5120, -3606, -3606,   772, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606,  3641, -3606,  3066, -3606, -3606,
    3081,   231, -3606, -3606, -3606,  5688,  3503,  1276, -3606, -3606,
   -3606, -3606, -3606,  3083,  2064,  -127,   695, -3606,   778, -3606,
   -3606, -3606,  1365,  3086,  3309, -3606,   118, -3606, -3606, -3606,
     214, -3606, -3606, -3606, 11378, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, 24514, -3606, -3606,  1965, -3606,  1983,
   -3606, -3606, -3606,  3152,   695,  3557,  3559,   695,   695,   695,
     695,  3097,  2503, -3606,  3550, -3606, -3606, 11378, -3606, -3606,
    1363,  3316, -3606,  3632,   828,  1363, 42666,  1363, 42666, -3606,
   42666,   833, -3606, -3606,  3297,   778, -3606,   118,   214, -3606,
    3021, -3606,   140,   140,   195,   149,   195, -3606,  1363, 11378,
   -3606, 11378,  3129, -3606, -3606,  3526, 42666, -3606, -3606, -3606,
   -3606, 11378, -3606, 48516, 48516, -3606, -3606, -3606, -3606,  3680,
       9,  3650,  3362,  3652,  2373, -3606, -3606,  3345,  5688, -3606,
   -3606, -3606,  2547, -3606, -3606, -3606,  1590, -3606, -3606,  1365,
    3113, -3606,   695,  2246,  3118, -3606, -3606, 42666,  3114, -3606,
    -127,   695,   695,  1098,  1098,  1965, 36231,  3219, -3606, -3606,
     695,  1365, 42666, -3606,   875,  3467, -3606,  2003,  2026, -3606,
    3677, -3606,  3678,  3123,  3126, -3606, -3606, -3606, -3606,  2031,
   -3606,  3724, -3606,   993,  3383,  3384, -3606, -3606, -3606,  1363,
    1363, -3606,    55, -3606, -3606,  3507,  3587, 11378,  1363, 45591,
    3127, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, 49101, 11378, -3606,   772,  3641, -3606,
    3388, -3606,  3389, -3606, -3606, -3606,  3617, 48516, -3606,  3608,
   -3606,     9, -3606, -3606, -3606, 24514, 14408, -3606, -3606,  3160,
   -3606,  3143, -3606, -3606,   211, -3606,  -127,  -127, -3606, -3606,
   -3606, -3606, -3606,  2038, -3606, 36231, -3606, -3606,  3700,  3701,
    3604,  3704,   875, -3606,  -108, -3606, -3606, -3606, -3606, -3606,
   40911, 40911, -3606, -3606, -3606, -3606,  3197,  3630,  3177, 11378,
   48516, -3606,  3609, -3606,  3544,  1543,  3489,  3153, -3606,  3149,
     323,  3644, 49686, 49686, -3606, -3606, -3606, -3606,  3622, -3606,
   -3606, -3606, -3606, -3606,  3327, -3606, -3606,  2048, -3606, 15014,
   -3606, -3606, -3606, -3606, -3606, 36231, -3606,  3219, -3606,  3165,
     149,   149,  3722,   149, -3606,  3723,  3729,  -108, -3606,  3173,
    2051,   140,   140, -3606,    58, -3606,  1363, 46176,  3718, 42666,
   -3606, -3606, -3606, -3606, 11378, -3606, 37401, 46761,  3172, -3606,
   -3606, -3606,  3338, -3606,  2373,  3569,  3632, -3606,  3143, -3606,
    3178, -3606,  3032,  2503, -3606, -3606,  3180, -3606, -3606,   149,
   -3606,   149,   149, -3606, -3606, -3606, -3606, -3606, 11378, -3606,
    3635,  3264, -3606,  3182, -3606, 48516,  1297, 48516, -3606, -3606,
    3591,  3185,  1417, -3606,  3183, -3606, -3606, 48516,  3744,  3467,
   -3606, 15014,  3189, -3606, 11378,  3190,  3191, -3606, -3606, -3606,
   -3606,  1363,  3754, 48516, 42666, 43836,  3385, 47346,  3627, 42666,
    5688,  3628,  3629, -3606, 48516, -3606,   149,  3583, -3606, -3606,
    1363, -3606, -3606,  3292, -3606, 44421, -3606,  2416, -3606,  3232,
   -3606, -3606,  3696,  1093, -3606, -3606, -3606,  3474,  3215, -3606,
   -3606, 48516, 48516, -3606, -3606, -3606, 30381, 11378, -3606, -3606,
   -3606, -3606, -3606,  1001,    33, 19796,  3363, 45006, 47931, -3606,
   -3606, -3606, 27456, -3606, -3606, -3606,  3638, -3606,  1363, -3606,
   -3606, -3606, -3606, -3606, 36231,  2084, -3606, -3606, 24514, -3606,
   30381, -3606, -3606, -3606, -3606, 22745,  3216, -3606,   695, -3606,
   -3606, 24514, -3606, -3606, 14408, -3606, -3606
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3606, -3606, -3606, -3606, -3606,   104, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606,  1664, -3606, -3606, -3606, -3606, -3606,
    1862, -3606,   643, -1686, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606,   641,  1490,  3213, -3606,   399, -3606,    90, -3606,
   -3606, -3606, -2728,   -31,  -200, -3606, -3606,   240,    17,  2894,
    -198, -3605, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,   415,   413, -3606, -3606,   233, -3606, -3606,  -833, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606,  -384,  -335,  1628,
   -3606, -3606, -3606,  3804, -3606,  3301, -3606,  1202,  2128, -3606,
   -3606, -3606,  -249,   251, -3606,   252, -3606,   253, -3606,   254,
   -3606,   255,   257,   259,   260, -3606,   261, -3606, -3606,  -334,
   -3606, -3606, -3606, -3606,   262, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606,  -213, -3606, -3606,   -62, -3606, -3606,  -207,   265,
   -3606,  -162,   270, -3606,   271, -3606,   -86, -3606,   -80, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,  2892, -3606, -3606, -3606, -2104, -3606, -3606, -2229,  2475,
   -3606, -1602, -3606, -3606, -1711, -3606, -3606, -1650,   845, -3606,
   -3606,   -82,  -338, -3606, -1337, -1752, -1741, -3606, -3606, -3606,
   -1850, -1835,  -741,  2225, -1128, -2132, -3606, -3606, -3606,   264,
   -3606, -3606, -2403,  1961,  2480, -3606,  2483, -3606, -3606,  1087,
   -3606, -3606,  1263,   612,  1261, -3606,   896,  2654, -1172, -3606,
   -3606, -3606, -3606, -3606, -3606,     8,   243,   -81, -3606, -3138,
     623, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -2368,
   -3606, -3606, -3606,  -240, -3606, -3606,  -155, -3606, -3606,  -199,
   -3606,   101, -2175, -3606, -3606, -3606, -3606,  2457, -1231, -3606,
    3418, -3606,  -498,   709,  1998, -2276, -1298, -3606,  -863,  -850,
   -2333, -3606, -3606, -3606, -3142,  1053,  1431, -3606,   809,  1999,
   -1785, -3606,  1505, -3606, -3606,   835, -3606, -2561, -3606, -3606,
   -3606,   789, -3606,   792, -3606, -3606, -3606,  -957,   757,  -770,
   -3606,   356, -2187, -2361, -3606,   582, -3606,   538, -3385, -3606,
    -547, -1960, -2251,    47, -3606, -3606,   550, -2928,   897, -3606,
   -3606, -3606, -2975, -1714, -3606,   114, -3606, -3606, -3606, -3606,
   -2722, -3606, -3606, -1392, -2120, -3606, -3606,  3926,  3928,  -982,
   -2194, -3376,   119,   112, -3606, -3606, -3606,  2473, -1146,   186,
     177,   182,  1956, -1433,   325, -2212, -3606,   372, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606,  2033, -1129, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -2248,   864, -3606, -3606,  1545, -3606, -3606,
   -3606, -1743,  -467, -2015, -3027, -3606, -3606, -3606, -3606, -3606,
   -3606,  1630, -3606, -3606,  2157,  2606, -3606, -3606, -3606, -3606,
   -3606, -3606,   605,  1732, -3606, -3606, -3606, -3606, -3606, -3606,
     871,  2511, -3606, -3606, -3606,     2, -3606, -3606, -3606, -3606,
    2245, -3606, -3606, -3606, -3606,  2558, -3606, -3606, -3606, -3606,
   -3606, -3606,  1353, -3606,  1783, -3606, -1362, -3606, -3606,   987,
    -927,  1728,  -559,  1867,   373, -3606,  3409, -3606, -3606, -3606,
   -1564, -2302, -3606,  3130,  -907, -2340,  2252,  -618, -1721,  1020,
    -647,  3616, -3606, -1081, -1060, -3606, -3606,  -611, -3606, -3606,
   -3606,  -610, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606,  1397, -3606, -3606, -3606, -3606, -1614, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606,  1398, -3606,  1968, -3606,
    -458, -3606,  2936, -3606, -3606, -3606, -2160, -1724,  1693,   942,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -2190,
   -3606, -3606, -3606, -3606, -3606,  1893, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -1571, -3606, -1845,   321, -3606,   471, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606,     3,   836,     5, -1969,
   -1035,  1593, -3606, -3606, -1198,  2988, -1929, -3606, -3606, -3606,
    1876, -3606, -3606, -3606, -3606, -3606,   922, -2418,  2666, -3606,
   -3606, -2954,  -856, -2134,  -846, -3606, -2169,   512, -1709, -2383,
    -347, -1178, -1683, -3606, -3606, -3606, -3606, -3606,  -143, -3606,
   -3606, -3606,   527,  1798, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606,  -506,  -670, -3606,  2052,  2197, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,  2831,  2789,
    1870, -3606, -3606, -2215, -3606, -3606,  1824, -3606,   783, -2204,
   -1672,  1052, -3606, -3606,  1054, -2998, -3606, -3606, -3606, -3606,
   -3606, -3606,   999, -3606,    93,  3509, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606,  2607, -1001,  3437, -3606, -3606, -3606, -3606,
   -3606, -3606,  2288, -3606, -3606, -3606, -3606, -3606, -3606,  2765,
    3527,  -544, -1208, -3606,  -616,  2739,  2290,  -834, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606,  2414,   979, -3606, -3606, -3606,  2852, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606, -3606, -3606,  1099,    -7, -3606,    99,   -48, -3606,
      28, -3606, -3606, -3606, -3606, -3606,  -125, -3606, -3606,  -130,
    -642,  -923, -1266,   731, -1681, -1904,  1107,  2836, -2363,  -640,
   -1100, -1105, -1827,    61, -3606, -3606,  2948,    75,   676,  -282,
      -6, -2351,  -112,  -542, -3606, -1966, -3606, -3606, -3606, -3606,
    2377, -3606, -3606, -3606, -3606,  1438, -3606, -3606, -3606,  1072,
   -3606,   816,   603, -3606, -3606,   143, -3606,  2427, -3606, -3606,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606,  2856,  3580,  3283, -3606,  2904, -3606, -3606, -3606,
   -3606, -3606,   486, -3606,   412, -3606, -1971,  2673,   929, -3606,
    1530,  -219,  -495, -3606, -3606,   482, -3606, -3606,   316,  3592,
    3286, -3606, -3606, -3606, -3606, -3606, -2583,  -836, -3606, -3139,
   -2647, -1585, -3606, -3606, -2030, -2822, -3606, -3606,  -984, -3606,
   -3606, -3606, -3606, -1938, -3606, -3606, -3606,    82,  3655,  3656,
   -3606, -3606,  -161, -3606,   697, -3606, -3606, -3606, -3606, -3606,
   -3606, -3606,  3515, -3606, -3606, -3606, -3606,  3520, -3606, -3606,
   -3606, -3606, -3606,  3522, -3606, -3606, -3606, -3606, -3606,  1752,
   -3606, -3606, -3606, -3606, -3606, -3606, -3606, -3606
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2441
static const yytype_int16 yytable[] =
{
     466,   983,   899,   997,  1005,   903,  1379,  1042,  1044,   592,
    1593,  1381,   929,   508,  1288,  1592,   514,  1050,  2257,  2113,
    1480,  1938,   509,   464,  2207,   528,  1568,  1545,  1178,  1026,
    1316,   526,   540,  1470,  1471,   543,   752,   533,  1068,   540,
    1310,  1698,  1344,   942,  1081,  2240,  2782,   561,  1772,  1935,
    1658,  2612,  1316,  2446,  3055,  2643,  1614,  1841,  2728,  2675,
    2679,  2681,  2522,  1622,  1099,  1345,  3012,  2525,  2853,  1510,
    3325,  1101,  2498,  1706,  1105,  1386,  1112,  1113,  1114,   133,
    2892,  2884,  2350,   512,  2573,  1624,  1625,   581,  1387,  1628,
    1629,  1630,  1631,  2416,  1633,  1634,  1636,  1638,  1639,  1640,
    1641,  1642,   972,   975,  1912,  2693,  2694,  2712,  3171,   584,
    2286,   466,  2239,  2345,   466,   591,   597,  1779,  1973,  2664,
    3330,  1120,  1121,  1122,  2346,  2358,  2778,  3398,  1013,  2362,
    2703,  1162,  2466,  1163,   586,  1789,  3252,   588,  2713,  2333,
    2377,  2756,  2599,  1792,  1793,  1854,  3508,  2467,  2308,  2309,
    2386,  2902,   473,  1819,   580,  2907,  3364,  3369,  3642,  1983,
    3370,  1129,  1130,  1259,  3345,  2320,  2154,  1129,  1130,  1227,
    2569,   525,  1701,  2252,  1129,  1130,  3371,   532,  2017,  3378,
    1227,   610,  2338,  2339,   918,  3397,  1712,  1438,  2394,  2322,
    3920,  3755,  1222,  2430,  3543,  2604,  3516,  4020,  2360,  2361,
    4020,  2363,  1129,  1130,  2366,  2367,  2742,  2743,  2370,   601,
    2886,  1129,  1130,  2379,   993,  3219,  2487,  2382,  2383,  2384,
    2385,  1129,  1130,  1837,  2389,  3452,  2391,  2955,  3220,  1181,
    2463,  2861,  2400,   521,  2427,  2404,  2759,  2406,  2746,  2437,
    2302,  2464,  3221,  2154,  1362,  2443,  2444,  3085,  1682,  2997,
    2448,  1383,  2431,   868,   869,  2341,  1129,  1130,   976,  3964,
    2455,  3201, -2388,   868,   869,  2920,  1843,   688,  2866,  3158,
    3237,  3832,  2652,   602,  2274,  1655,   986,  2823,  1442,   541,
    -823,  2500,  3861,  3506,  1346,  3844,  1253,  3755,  4220,  1369,
   -2324,  1108,  3862,  1390,  2450,  2451,  2452,  2453,   994, -1404,
    1129,  1130,  2480,  1228,  1129,  1130,  1129,  1130,  1129,  1130,
    3826,  2020,   831,  2470,  1228,  3557,   868,   869,  1420,  1421,
    2854,  2855,  2395,   128,   625,  1483,  1383,  1979,  2906,  1926,
    1129,  1130,  1383,  1243,  3000,  2691,  1244,  1356,  1129,  1130,
    1837,  2558,   132,  1655,  2432,   522,  1233,  1129,  1130,  1314,
     919,   553,  2022,  2697,  2660,  -525,   542,  3756,  3259,  1321,
    3865,  -526,  3659,  2832,   978, -2388,  -430,   615,  2867,  2488,
    1129,  1130,  1129,  1130,  1463,  1460,  1461,  1462,  2080,  4065,
    2047,  1709,  1219,  1129,  1130,  2047,  1443,  3446,  3091,  1463,
    1444,   132,  3470,  3576,  2023,  1166,  3482,   958,  3681,   617,
    1464,  1445,  3580,   809,   129,  1326,  1129,  1130,  2833,  4066,
    1357,  3482,  1509,  2418,  1855,  1465,  1439,   554,  3071,  2433,
     769,  3593,  2750,  1710,   469,  1068,  3595,  3007,  1175,  1129,
    1130,  3201, -1404,  1248,  1654,  3845,  2661,  1534,  1927,   979,
    1535,  1812,  2824, -2255,  2750,  1484,   995,   603,  1683,  3916,
    1363,  2711,  1815,  3756,  1433,  1434,  1407,  1109,  4085,   712,
    2471,   832,  1349,  1012,  1129,  1130,  1129,  1130, -1364,  3202,
    4221,  1129,  1130,   591,  1245,   597,  1129,  1130,  3921,  3048,
    3751,  1370,   606,  3970,  1048,  1774, -2440,  3625,  1777,  3964,
    3863,  2376,   765,  1781,  1129,  1130,   597,  3651,   896,  1129,
    1130,  1131,  1841, -1364,  1132,   804,  1129,  1130,  4050,   591,
    1656,   814,  3068,  1166,  1131,  1129,  1130,  1132,  3059,  1794,
    1795,  1386,  1446,  3092,   827,  2658,  1658,   806,  2344,  1619,
    1817,  2760,  3534,  2275,  1387,  2764,  3346,  2560,  1627,  1459,
    2751,   977,  1131,  3081,  2155,  1132,  3083,  3084, -2255,  2780,
    2781,  1131,   915,  3238,  1132,  1648,  1129,  1130,  1286,  2791,
   -1404,  1131,  3082,  1259,  1132,  3094,  3086,  3535,  3922,  3483,
     932,  2894,  2133,  1129,  1130,  1684,  1494,  1495,  1656,   591,
    2264,   946,  2282,  2136,  3483,  2416,  2139,  3682,  1259,   994,
    2345,  1386,   581,   466,  2721,  3923,  1131,  1533,   581,  1132,
     970,  2346,   581,   581,  1387,  3478,  1547,   984,   946,  3205,
    2466,  2489,   591,  2018,  1912,  1447,   957,  2434,  1560,  1561,
    1562,  2155,  1014,  1015,  1016,  2467,  1440,  1567,  1021,  2265,
    2956,  3187,  3931,  3080,  1973,  4073,  2977,  2978,  2979,  3202,
    1131,  3075,  2130,  1132,  1131,  2462,  1131,  1132,  1131,  1132,
     773,  1132,  2763,  1842,  2765,  2416,  1177,  1129,  1130,   956,
    3279,  2776,  1223,  3517,  3829,   967,  2562,   920,  3484,   819,
    1131,  2740,  1069,  1132,  2788,  1678,   830,  1661,  1131,  3775,
    2797,  1132,  3015,  3016,  3017,  3372,  1713,  1131,   958,  3750,
    1132,  2665,  3919,  1984,   848,  2811,  2899,  2775,  3764,  2396,
    2868,  3670,   916,  3833,  1702,  1011,  3199,  3809,  2463,  2783,
    1131,  1843,  1131,  1132,  1978,  1132,   523,  2851,  2702,  2464,
    1440,  3959, -2324,  1131,   618,  2745,  1132,  3186,  3018,  3019,
    1126,  3328,  1128,  1791,  1819,  1133,  1700,   995,  2744,  1728,
    -823,  1133,  3222,  2856,  2752,   771,  1131, -1404,  1133,  1132,
   -2324,  1719,  3453,  2116,  3358,  2692,  1171,   466,  1173, -1404,
     946,   466,   591,  1313,   466,   591,  3095,  2027,  2207,  1131,
    1961,   828,  1132,  2891,  1110,  4182,  1133, -2440,  2419,  1350,
    1172,  1778,  1322,  1220,  1176,  1133,  2859,  1180,  3377,  2826,
    1599,  1600,  1129,  1130,  3286,  1133,  3380,  1129,  1130,  3281,
    2081,  2220,  1232,  3403,  1131,  1755,  1131,  1132,  3874,  1132,
    2028,  1131,   581,  4046,  1132,  -525,  1131,  1129,  1130,  1132,
    3485,  -526,   591,   581,  2096,  1440,  -430,   581,  1327,  2617,
    1133,  2643,  4041,  3486,  1131,  1129,  1130,  1132,  3306,  1131,
    2220,  1821,  1132,  1979,  1599,  2046,  1131,  2149,  3486,  1132,
   -1364,  3755,  1227,  1536,  2469,  1131,  1537,  3350,  1132,  3926,
     807,  3928,  1129,  1130,  3060,  3061,  3335,  2266,  3315,   591,
    2967,   518,  3319, -2255,  1133,  1129,  1130,  2657,  1133,  1239,
    1133,   114,  1133,  2123,  3290,   835,  3748,  3336,  2085,  2086,
    1256,   823,  2102,  2103,  2581,  2582,  1131,  1250,  3314,  1132,
    1299,  1351,  3318, -2255,  1133,  2992,  3533,  3020,   581,  2193,
    2052,  2753,  1133,  1131,  3536,  1341,  1132,  3695,  1205,  2008,
    3487,  1133,  1129,  1130,  1352,  3974,  3356,  3357,  1382, -1404,
    2278,  1129,  1130,  1729,  2906,  2924,  2925,  2906,  2906,  1854,
    1316,  1129,  1130,   661,  1133,  2276,  1133,  3996,  3542,  2207,
    1129,  1130,  1129,  1130,  2906,  2281,   581,  1133,  2284,  2285,
    2307,  2026,  3210,  2757,  2757,  1989,  3541,  1164,  3379,  2240,
    1316,  2941,  2942,  3396,  3399,  3401,  3402,  3215,  4043,  1236,
    1133,  2249, -1404,  1643,  1841,   551,  1228,  1129,  1130,   552,
     116,  2539,   836,  2345,  2964,  2965,  1164,  1131,  1353,  3331,
    1132, -2256,   666,  1133,  2346,  2344,  2502,   581,  1772,  1772,
    2466,  1476, -1839,  3052, -1404,  1609,   474,  3756,  2033,  3043,
    3998,  3215,  1854,  3311,  2973,  2467,  2250,  3910, -1404,  2350,
    2221,  3999,  2140, -1404,  3620,  2138,  2239,  2194,  1133,  2631,
    1133,  3853,  3445,  3289,  3044,  1133,  1069,  2580,  1459,   134,
    1133,  1762,  1647,  2034, -1404,  2044,  2124,  1129,  1130,  1069,
    2045, -1404,   517,  2117,   837,  2048,  1317,   935,  1133,  2221,
    3911, -1404,  2377,  1133,  1467,  2698,   530,  1354,  1474,  2731,
    1133, -2388, -1404,  2060,  2199,  2131,  2241, -1404,  2207,  1133,
    1129,  1130,  2149,  3663,   677,  2068, -1404,  3633,  1842,  2585,
    2586,  3696,  1386,  2718,  2072,  3522, -2256,  1763,  2463,  1594,
    1912,  3925,  4014,  3422,  1318,  1387,  2113,  1973,  2153,  2464,
    2680,   591,  3423,  2462,   547,  1593,  3526,  3527,  3216,  3021,
    1133,  2118,  1131,  1730,  1837,  1132,  1711,  1131,  3324,  2627,
    1132,  1129,  1130,  2579,   824,  2073,  3661,  1133,  1129,  1130,
     555,  2150,  2939,  2589,  1146,  1815,  2157,  1131,   591, -1404,
    1132,   556,  2074,  1651,  1129,  1130,  1833,  3906,   581,   693,
    1237,  3870,  3216,  2216,  2217,  1131,  1897,   581,  1132,  1129,
    1130, -1404,  1644,   519, -2388,  1129,  1130,  1801,  2732,  3912,
   -1404,  3045,  3854,  1843,  1593,  2222,  1129,  1130,  3697,  2716,
    2267,  1342,  1131,  3217,  1645,  1132,  1129,  1130,  1855,  2327,
    2834,   591,  1129,  1130,  2200,  1131,  2401,  1837,  1132, -1404,
    2872,  1900,  2291,  1687,  2195,  1690,  1300,   581,   619,  4000,
    1978,  1133,  3332,  2295,  2222,  1653,   581,   573,  1129,  1130,
    1440,  2468,   591,  1129,  1130,  2097,  4245,  3227,  1129,  1130,
    2125,   581,   581,  3424,  2986,  3064,  1165,  1483,  1129,  1130,
    1684,  2416,  1131,  3456,  3622,  1132,  2126, -1404,  2328,  1129,
    1130,  1131,   808,  2201,  1132,   591,  2812,  1764,  1732,  1823,
     936,  1131,  2416,  1593,  1132,  1165,  1740,  3053,  2795, -1404,
    1131,  1855,  1131,  1132,  2329,  1132,  1129,  1130,   466,   466,
     466,   581,   466,   581,  1129,  1130,   937,  1834,  1773,  1694,
     570,   574,  1129,  1130,  1775,   466,  1993,   591,   999,  1007,
     466,  1756,  1757,  1758,  2119,  1760,  1979,  1131,  2784, -1404,
    1132,  2873,  2469,   631,  4015, -1696,  1149,  1655,  1776,  1994,
     581,  3054,  1802,  1780,  1129,  1130,  1803,  2292,  2835,  4116,
    4117,  3855,  1129,  1130,  1129,  1130,  1129,  1130,  2708,  1646,
    2330,  2757,  3848,  3849,  2293,  2733,  1133,   720,  1759,  2709,
    1761,  1133,  1801,  3422,  1752,  2294, -1594,  1499,  1129,  1130,
     558,  2075,  3423, -1404,  3100,   591,  2079,  2402,  1129,  1130,
     632,  1133,  4001,   688,  1936, -1404,  2150,  1131,  2785,   581,
    1132,  3218,  1931,   581,  3885,  2838,  2098,  1790,  2344,  1133,
    2408,  3879, -1404,  3812, -1404,  1129,  1130,  1937,  2475, -1594,
    2839,  1129,  1130,  2376,  2922,  2002,  1129,  1130,  3567,  1167,
    1131, -2256, -1697,  1132,   581,  2331,  1133, -1404, -1404,  2476,
    2734, -1404, -1404,  4156,  3901,  3218,  3753,  2226,    42,  1133,
    1602,  2923,  2295,   591,   576,   466,   466,  1483,  1991,   466,
    2347, -2256,  1129,  1130,  2934,   571,  1928,  1129,  1130,  3065,
    1933,  1021,  1853,  2007,  2851,  1129,  1130,  1483,  1987,  1988,
    2109,  1131,   582,  3792,  1132,  1801,  3605,   585,  1131,  3101,
   -1696,  1132,   896,  2786,  3629,  -196,  1133,  4161,  2893,  1129,
    1130,  3273,  3793,  2874,  1131,  1133,  2963,  1132,  1129,  1130,
    2226,  2944,  3990,  3424,   633,  1133,  4162,  1265,  3568,  1131,
    2945,  2584,  1132,  2462,  1133,  1131,  1133,  1802,  1132,  3811,
    3464,  1803,  1593,  1129,  1130,  3219,  1131,  3003,  2009,  1132,
    2021,  1483,   587,  3274,  1069,  2053,  1131,   598,  3220,  1132,
     949,  2158,  1131,   810,  2710,  1132,  1993,  3569,  1129,  1130,
    2296,  1133,  3221,  1129,  1130,  2228,  2229,   606,  2373,   536,
    1733,  2527,  1656,   868,   869,  2940,   116,  1552,  1131,  1994,
    1842,  1132,  2226,  1131,  2533,   712,  1132, -1697,  1131,   470,
    2227,  1132,   471,  1050,  1101,  1105,  2507,  1556,  1131,  2875,
     950,  1132,  3006,    55,  2122,  1603,  1936,  1129,  1130,  1131,
    1048,   607,  1132,  4048,  1129,  1130,  4052,  2548,  1158,  1159,
    1160,  1161,  2297,  2617,   610,  1129,  1130,  1129,  1130,  1937,
     599,  1133,  3087,  2332,   811,  2110,  1131,  3738,  2735,  1132,
    1802,  3606,  1129,  1130,  1131,  2025,  2146,  1132,  2207,  3689,
    3690,  2144,  1131,   612,   591,  1132,   581,   591,  1406,  2145,
    3556,  1579,  4058,  3098,  1133,  3621,   537,  2113,   581,  1049,
    2163,  3104,  3373,   537,  3106,  3374,  2169,  2169,  3976,  2169,
     951,  4090,  4090,  2249,  1131,  3594,  2595,  1132,  3596,   581,
    1734,   614,  1131,   581,  1131,  1132,  1131,  1132,   626,  1132,
    2228,  2229,   812,  3556,  1129,  1130,  2128,   851,  1466,   591,
     591,   581,   581,  1978,  3179,  1133,   981,   982,  1131,  2468,
    1069,  1132,  1133,  2169,  2169,  2169,  1167,   482,  1131,  2032,
    4140,  1132,  2469,  1328,  1129,  1130,  2035,  2230,  1133,  2804,
    2262,  2805,  3630,  2168,  2168,   628,  2168,  3738,  3738,  2273,
    1129,  1130,  2036,  1133,  1314,  1131,  2191,   629,  1132,  1133,
    1239,  1131,  1329,  1854,  1132,   761,  1131,  2043,  3301,  1132,
    1133,  1442,  2375,  2056,  3443,  3444,   630,  1167,  1256,  2219,
    1133,  1167,  2806,   766,  2057,   581,  1133,   805,  2215,  3302,
    2168,  2168,  2168,   816,  2061,  1399,  1400,  2290,  2144,   246,
    2065,   248,  1131,  2807,   581,  1132,  3029,  1131,  1303,  1330,
    1132,  1209,  1133,  1288,  1331,  1131,   820,  1133,  1132,   822,
    3303,  2774,  1133,  1146,   840,  2269,  2066,   852,  3219,  1129,
    1130,  2067,  1133,  1457,  3049,   842,  2071,  2808,   832,  1131,
    3050,  3220,  1132,  1133,  1316,  1742,  2076,  3907,  1131,  3908,
    1316,  1132,  2283,   688,   911,  3221,  3312,  2084,   470,   688,
    3213,   471,  2024,  1166,  3051,  1304,   868,  3365,  2456,   930,
    1133,  2301,  2472,  1131,  1129,  1130,  1132,   931,  1133,  1443,
     952,  3229,  3230,  1444,  2089,  1210,  1133,  3738,  3738, -1674,
    1211,  1305,  2104,   808,  1445,  1129,  1130,   853,  1131,  2311,
    2403,  1132,  3243,  1131,  3547,  1593,  1132,   531,  2318,  2319,
    2523,  1129,  1130,  1743,  2417,  2523,  1129,  1130,  1133,  2323,
    2324,  2325,  2326,  2689,  2334,  2335,  1133,  2291,  1133,   948,
    1133,   988,  2896,  1212,  1129,  1130,  3779,  3780,  3781,  3782,
    2912,   953,  2918,   954,  2919,  1772,   939,  1131,  1213,   968,
    1132,   958,  1133,  1332,  1131,  1129,  1130,  1132,  1837,  2040,
    1166,  1593,  1133,  1615,   987,  1131,  2716,  1131,  1132, -1594,
    1132,  2587,   992,  3738,   591,  2140,  2926,   114,   591,  1023,
    2473,  1024,  1131,   466,  1025,  1132,  1027,  1966,  3738,  1133,
     581,   581,   581,  2496,  1593,  1133,  2499,  1844,  1028,  2795,
    1133,  3738,  1744,  2930,  1029,  1149,  2478,  1032,  2577,  2931,
    2241,  1033, -1594,  2762,  2932,  1446,   591,  1034,  2501,  2428,
    2429,   591,  2436,  1333,  2438,  2439,  2440,  2441,  2442,  2049,
    1166,  2445,  1855,  2447,  4242,  1035,  1133,  2789,  2790,  2898,
    2598,  1133,  2050,  1550,  1131,   712,  1036,  1132,  1037,  1133,
    2933,   712,  2292,  1038,  3738,  2935,  1039,  2492,  2493,  2494,
    3805,  3806,  3222,  2938,  4081,  3884,  3738,  3738,  2809,  2293,
    1048,  2062,  1166,  1133,  1131,  1040,  1048,  1132,  1655,  1043,
    2294,  2200,  1133,  3807,  3872,  1334,  3395,  2943,  1146,  1045,
    1131,  1306,  2999,  1132,  1046,  2171,  2946,  2172,  1845,   868,
     869,  3338,  3339,  1166,  2207,  1047,  1745,  1133,  1447,  1820,
   -1674,  3738,  3684,  3685,   591,  3687,  3688,  2899,  1051,  2468,
     920,  3738,  3890,  1052,  2962,  3893,  3894,  3895,  3896,  1100,
     981,   982,  1133,  1837,  3408,  1104,  1616,  1133,  3042,  2596,
    2201,  2244,  2245,  2246,  3678,  3679,   591,  1679,  1151,  1152,
    1680,  2948,  2523,  1681,  2683,  2688,  1824,  2295,  1053,  3738,
     591,  3738,  1054,  3972,  3359,  1055,  2202,  3362,  3363,  1131,
    1825,  3738,  1132,   854,   855,  1593,   857,  1056,   859,  1837,
    3003,  1133,   909,   910,  3375,   913,  1057,  3738,  1133,  3738,
     860,  3738,  2625,  1335,  1170,  2950,  2727,  2523,  3738,  1133,
    1058,  1133,  2952,  1227,  2063,  1166,  2064,  1166,  2893,  3738,
     562,  1059,  2207,  2953,  1131,  2954,  1133,  1132,  1307,  3986,
    3987,  2069,  1166,  1060,  2648,  3738,  3738,  1336,  3995,  2113,
    3248,  1063,  2203,   896,  1064,  1131,  3644,   591,  1132,  1308,
    1070,  3738,  3738,  1129,  1130,  1071,  3738,  1967,  1854,  1072,
    2669,  1131,  2671,  1655,  1132,   563,  1131,  1846,   591,  1132,
     591,   591,  1854,  2336,  2337,  2296,  1847,  2598,  1773,  1773,
    1149,  1073,  1848,  1074,  1131,  2566,  1166,  1132,  1133,  1309,
   -1404,  2602,  2603,  1154,  1155,  1156,  1157,  1158,  1159,  1160,
    1161,  1169,  3249,  1594,  1075,  1131,  1076,  1966,  1132,  1655,
    1077,  3381,   591,   591,   868,   869,  1078,  2204,  1133,  3461,
    1080,  1966,  1146,  1656,  1082,  1966,   924,   925,  1968,   926,
    1083,   927,  3250,   896,  1133,  1826,   564,  2297,  2936,  1166,
    1617,  2668,  1084, -1404,  3645,  3646,   851,  1228,  3463,  3647,
    3648,  1174,  2417,  2340,  3382,  1085,  1618,  2417,  1086,  3383,
    1087,  2749,  2417,  3009,  3010,  3222,  2417,  1088,  2770,  3182,
    3183,  2761,  1089, -1404,  1849, -1404,  2347,  2771,  2770,  1090,
    2417,  2417,  1185,   591, -1674,  3366,  3156,  3254,  1166, -1404,
    2417,  1091,  1594,  1515, -1404,  3276,  3277,   114,  1092,  2792,
    2458,   581, -1674,  1093,  2800,  3384,  1827,  1206, -1404,  2770,
    2802,  2803,  1094,  1133,  2458, -1404,  2417,  2822,   896,  2070,
    3413,  3414, -1404,  1151,  1152,  3449,  3457,  3469,  2848,  3465,
    1166,  1828, -1404,  1095,  1026,  1487,  1488,  1489,  3479,  1166,
    3494,  3495,  1096, -1404,  3608,  2337,  1097,  1500, -1404,  3057,
    1146,  2772,  2773,  1837,  2200,  1098,  1824, -1404,  1133,  4189,
    3623,  3624,  1102,  1850,   896,  1103,   852,  1837,  2801,  1969,
    1825,  1837,  3471,  3627,  3624,  1106,  2799,  3236,  1553,  1133,
    1107,  1557,  3628,  3624,  2373,   581,  2417,  1519,   115,  1829,
    1111,  3767,  3771,  3472,  1115,  1133,  1145,  1116,  1656,  1117,
    1133,  1575,  1576,  1118,  1149,  1580,   116,  3683,  3277,  3473,
    3963,  3686,  3624,  2201,  3474,  2205,  1119,  3255,  1133,  1168,
   -1404,  1208,  1936,  1214,  1595,  1596,  -748,  1855,  3693,  3694,
    3819,  3820,  3544,  1216,  4246,  2852,   853,  3824,  3624,  1133,
    1217,  1855, -1404,  1225,  1656,  1937,  1226,   246,   118,   248,
    1234, -1404,  2877,  3776,  3825,  3624,  3827,  3624,  1154,  1155,
    1156,  1157,  1158,  1159,  1160,  1161,  1235,  1967,  4192,  4193,
     565,   117,  1251,  1655,  2321,  3828,  3624,  1830,  3637,  3638,
   -1404,  1967,  1262,  3429,  1520,  1967,  3794,  1655,  1523,  3834,
    3835,  1655,   566,  3836,  3835,  1524,  3886,  3887,  1146,   118,
     640,  1264,  3574,  3575,  2627,  2733,  1281,  2163,  1282,  2511,
    1232,   591,   591,   591,  1283,  3578,  4006,  3820,  3795,   581,
    3581,   981,   982,  1286,   567,  1826,  1289,  3385, -1404,  1297,
    3767,  1298,  1149,  3386,  3771,  2512,  1302,  2625,   591,  4007,
    3820,  1594,  1314,  3597,  4012,  3277,  3599,  1151,  1152,   119,
   -1404,  4056,  4057,  1323,  1069,  1324,  1968,   591,   591,   591,
    3702,  4097,  4098, -1674,  4115,  3181,  3702,  1870,  1871,  3387,
    3028,  1525,  2523,  2327,  3550,  2374,  3030,  1325,  3032,   568,
    2734,   661,  2513,  3454,   591,  2514,  2985,  1340,  2375,  1593,
   -1404,  3767,  3771,  2515,  3882,  1147,  1827,  4234,  4235,  1343,
    -731,  -731,  1873,   763,   764,  1583,  1584,   767,   768,  1347,
    -731,   770,  1348,   772,  1361,  1876,  1364,  1148,   981,   982,
    1365,  1828,  1367,  1877,  1527,  3988,  3989,  1372,   896,  1377,
    3796,  -605,  2328,   665,  1383,  2327,  1389,  3388,  2796,  1391,
     666,  2347,   896,  1393, -1404,  1396,   896,  1879,  3293,  3294,
    1397,  3027,  1404,  2348,  1401, -1404, -1404,  1405,  2329,  2417,
    1408,  1383,  2417,  2417,  1880,  2770,   670,  1409,   476,  3261,
    3262,   120,  1410, -1404,  1451, -1404,  3492,  3493,   591,  1829,
    1149,  2417,  1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,
    1452,  1453,  1885,  1456,  2328,  1458,  2770,  1969, -1404, -1404,
     981,   982, -1404, -1404,  2770,  3797,  1459,  2770,  1656,  -605,
    1477,  1479,   854,   855,   856,   857,   858,   859,  1483,  2347,
    2329,  1164,  1656,  3798,  2330,  1502,  1656,  3110,  1146,   860,
     581,  2348,   677,  1504,  1490,  3166,  3389,  1110,  2860,   121,
    1539,   466,  1549,  1550,  1626,  3176,  3799,  2770,  1591,  -605,
     477,  1551,  1601,  1610,   477,  1528,  2454,  1632,  1660,  1888,
    3093,  1652,  3185,   777,  3172,  1659,  1889,  1830,  3096,  1663,
    1530,  1666,  1150,  1667,  1668,  3196,  1669,  1670,  2735,  1673,
    1593,  1890,   581,  -779,  1671,  3882,  2330,  1936,   640,  1672,
    3654,   688,  2010,  1675,  3209,  1676,   122,  3111,  -912,  2331,
    1696,  1699,  3584,  2516,  1707,  1715,   692,   693,  1716,  1718,
    1937,  1717,  1156,  1157,  1158,  1159,  1160,  1161,  1050,  1101,
    1105,  3298,  3927,  1151,  1152,  1722,  1725,  -605,  1288,   478,
    1726,  1727,   477,  1736,  1891,  1741,  1153,  2727,  1754,  1750,
    1783,  1782,  1784,  1785,   778,  1796,  1787,  3704,  3188,  3198,
    1870,  1871,  1892,  1798,  1800,  1813,  1822,  2173,  1923,  1440,
    2054,  2331,  3550,  3253,  2058,  1936,  1940,  1942,  1941,   661,
    1943,  2669,  1944,   779,  1945,  3664,  1946,  1947,  2174,  1948,
    1184,  1962,  1949,  -731,  -731,  1873,   780,  2082,  1937,  1950,
    1951,  2175,  1952,  -731,  1953,  2625,  1954,  1955,  1876,  4102,
    1956,  2176,  1960,  1957,  1958,  1896,  1877,   896,  1959,   781,
    1149,   782,  1980,  1898,  2648,  3288,  1981,  1986,   591,  1996,
    1997,   665,   783,  3800,  1998,  1999,  2011,   591,   666,  2005,
    1879,  3954,  2013,  2596,  2014,  2015,  2031,  2030,  2037,  2517,
    2349,  2038,   784,   591,  1383,  2039,  2041,  1880,  2177,  2178,
    2047,  2262,  2668,  -605,   670,  2051,  2087,  3740,  1154,  1155,
    1156,  1157,  1158,  1159,  1160,  1161,  2055,   785,  3837,  2059,
    1594,  2077,  2078,   786,  2088,  1885,  2179,  2083,  2099,  2100,
    1904,  2101,  2417,   712,  2121,  2114, -1116,  3551,  1161,  2127,
    3552,  4102,  2417,  2137,  2770, -1233,  2166,  2332,  2159,   495,
     718,  2518,  2184,  1594,  2192,   720,  2198,  2209,   721,  2770,
    1593,   581,   787,  2417,  2212,  4227,  2242,  2243,  2258,   479,
     677,  2523,  2270,  2272,  3804,  2277,  2299,  2300,  2304,  2519,
    2303,  -605,  2306,  1593,  2310,  2312,  1905,  2180,  4238,   480,
    1593,  2313,  1888,   480,  2314,  4227,  1593,  4107,  4108,  1889,
    4110,  4238,  1906,  1151,  1152,  1907,   496,  2317,  2315,  2332,
    3553,  3554,  2316,  2347,  1890,  2359,  2364,  2365,  1187,  2368,
    2371,  2369,  2372,  2380,  2378,  1146,   481,  2481,  -531,   688,
    2381,   482,   497,  2387,  2388,  2848,  2392,  2181,  2424,  2393,
    2420,  1909,  2426,  3513,   692,   693,  4148,  4077,  4149,  4150,
    2457,  2398,  2479,  2501,  2399,  2405,  2497,  2291,  2510,  2529,
    3442,  3442,  3442,  2530,   498,  1773,   483,  1891,  2145,  1266,
    -605,   480,  2593,  2574,   484,  2505,  2528,   591,  1267,  2540,
    2541,  2575,  1136,  1137,  2576,  1892,   788,  1268,  2553,  2572,
    2583,  1146,  2592,  2605,  2606,  2607,  2885,  2608,  2615,  1269,
    1270,  1271,  2609,  4186,  2618,  2621,   790,  2628,  3968,  3410,
     499,  1188,  2632,  3966,   791,  1272,  1138,  2620,  3804,  2629,
    1702,  2633,   792,  1870,  1871,  2634,  1139,  2638,  2650,  3502,
    2727,  2651,  3434,  2653,  1594,  1189,  4219,  2654,  1896,  1190,
    1156,  1157,  1158,  1159,  1160,  1161,  1898,   793,  -605,   591,
    2655,  2250,  4155,  2249,  4157,  2673,  -731,  -731,  1873,  2672,
     794,   795,  2674,  1140,  2695,  2704,  -731,  2699,  2705,  2706,
    2722,  1876,  1191,  2729,  1141,  2730,  2841,  2777,  2779,  1877,
    4175,  2831,  2292,  2837,  2857,  2843,  2858,  2862,  2863,  1192,
    2864,  3442,  2865,  1897,  2890,  1815,  3664,  1146,  2006,  2293,
    2908,  1142,  2523,  1879,   796,  2909,  2899,  1149,  3564,  3559,
    2294,  2903,  2959,  1904,  2910,  2911,  2970,  1383,  4207,  4208,
    1880,   712,  1867,  2913,  2914,  3551,  2957,   -63,  3552,  1868,
    1869,  2980,   500,   797,  2961,  2966,   591,  2969,   718,  2975,
    2987,  1870,  1871,   720,  2982,  2991,   721,  2990,  1885,  1193,
    1243,  2994,  3005,  3008,  3014,   798,  3026,   799,  3031,  1143,
    3025,  3600,  3298,  3011,  3039,  3058,  3062,  3063,  3604,  1905,
    3078,  1194,  1872,  1149,  3079,  3077,  1873,  1874,  3174,  3167,
    3066,  2291,  1875,  3178,  3197,  1906,  3196,  2295,  1907,  1876,
    3090,  3170,  3173,  3099,  2927,  3107,  3191,  1877,  3553,  3554,
     501,  3192,   759,  3109,  -440,  2226,  3184,  1878,   591,  3524,
    3108,  3180,  3206,  3181,  3200,  1888,  3207,  3208,  3583,  1273,
    3211,  1879,  1889,  3228,  1909,  3231,  3232,  3239,   759,  3240,
    3257,  3258,  3267,  3269,  3272,  1383,  1274,  1890,  1880,  3280,
    3278,  3291,  3299,  3966,  3307,  1881,  1882,  3308,  4144,  3316,
    1151,  1152,  1883,  3317,  3329,  3337,  3609,   502,  3340,  3341,
    1884,  3354,   503,  3360,  -850,  3407,  1885,  3404,   591,  1195,
    2418,  3409,  3411,  3417,  3421,  3430,  3431,  2482,  1196,  1149,
     504,  3432,  3435,  3436,  3438,  3451,  3676,  3447,  3455,  3466,
    1891,  3448,  3449,  1197,  1886,  2296,  3450,  3458,  3459,  3442,
    3442,  3467,  3442,  3442,  3462,   505,  2292,  3468,  1892,  3481,
    3480,  1198,  2523,  3498,  4144,  3490,  1151,  1152,  3497,  3804,
     506,  3507,  3029,  2293,  3495,  3509,  3510,  3515,  3514,  3518,
   -1319,  1887,  3520,  1888,  2294,  3521, -1324,  3562,  3532,  3565,
    1889,  3395,  3545,  3546,  3548,  4216,  3549,   759,  3588,  3577,
    1199,  1200,   759,  3573,  3579,  1890,  3587,  2297,  1275,  3589,
    3591,  1896,  3592,  3398,  3598,  3610,  3745,   581,  3631,  1898,
    3611,  3636,  3635,  3626,  3639,  1201,  3652,  3640,  3442,  4216,
    3657,  3641,   759,  3667,  4244,  1154,  1155,  1156,  1157,  1158,
    1159,  1160,  1161,  3653,   470,  3672,  3656,   471,   759,  3668,
    3674,  3692,  3698,  3705,  3457,  3707,  3706,   581,  1891,  3741,
    3791,  2295,  1276,  3749,  3763,  3774,  3773,  3778,   591,  3784,
    3787,  3816,  1151,  1152,  3818,  3821,  1892,  3830,  3839,  1277,
    1893,  3857,  3889,  3528,  3746,  3876,  1904,  3859,  -307,   759,
     759,   759,   759,  3866,  3860,  3891,  3869,  3892,  3831,  3875,
    4027,   759,  1155,  1156,  1157,  1158,  1159,  1160,  1161,  3897,
    3900,  3902,  3904,  2826,  3843,  4027,  3931,  1894,  3934,  3850,
    -325,  3960,  1895,  3962,  3785,  3961,  3981,  3975,  4037,  1896,
    3992,  3978,  4004,  4008,  4009,  4010,  1897,  1898,  4011,  4013,
    4016,  4017,  1905,  4024,  4023,  4028,  1511,  1512,  1513,  1514,
    1515,  4034,  4035,  4039,  4036,  4046,  4060,  4061,  1906,  4062,
    4063,  1907,  4071,  4072,  4073,  4078,  4080,  1899,  4082,  2296,
   -2175,  4083,  4086,  4092,  4095,   776,   777,  4106,  4109,  4111,
    4122,  1900,  1901,  1902,  1903,  4112,  4114,  4136,  1594,  4138,
    4135,  4152,  4141, -1477,  3991,  4153,  4154,  1909,  4158,  4159,
    4166,  4163,  4169,  4171,  1904,  4172,  4187,  1154,  1155,  1156,
    1157,  1158,  1159,  1160,  1161,  4178,  4174,  4180,  4183,  4184,
    3676,  4195,  3676,  4191,  3909,  4197,  4204,  4205,  4228,  4232,
    4241,  2297,  2449,  2600,  3852,  3420,  3419,  2741,  4027,  3614,
    3871,  1516,  1517,  1518,  1519,  1004,  3969,  3867,  4134,  4093,
    3935,  1395,  4094,  3612,  3744,  3616,  4239,   778,  4199,   550,
    1905,   906,  3013,  2234,  3718,  3719,  3721,  3722,  3724,  4209,
    3725,  4119,  3726,  3727,  3728,  3729,  1906,  4120,  3732,  1907,
    4021,  4091,  4033,  3733,  3734,  1866,   779,  4032,  1455,  2148,
    2409,  3791,  1910,  2598,  3752,  3103,  3500,  3271,  4165,   780,
     591,  2993,  1908,  1934,  2998,  3980,  3997,  3786,  4045,  1705,
    3503,  4168,  4105,  3899,  4143,  1909,  4027,   627,  4027,  3437,
    2407,  1965,   781,  2883,   782,  4185,   759,  3189,  3353,  2414,
    2828,  3367,  3405,  3342,  3368,   783,  4027,  3700,  3558,  3590,
    3977,  1520,  3582,  1521,  1522,  1523,  3305,   491,  3915,   492,
    3918,  1995,  1524,  4104,  3873,   784,  3917,  3878,  3877,  3762,
    2491,  3703,  2411,  2816,  3344,  2288,  3561,  2635,  4027,  4027,
    3343,  1963,  2218,  4231,  -850,  3985,  1799,  1932,  2984,  1594,
     785,   759,   759,  3268,  2616,  2656,   786,  2571,  3739,   928,
     759,   759,   759,   759,   759,   759,   759,  3256,  2248,   591,
    2968,   759,  1293,  2717,   759,   759,  2526,   759,  3313,   759,
    3823,  1548,  2570,   759,  2848,  2848,   759,   759,   759,   759,
    3680,   759,   759,  4069,  2590,   787,  4070,  3418,  1525,   759,
     759,  3348,   759,   759,   759,   759,   759,  1501,   759,  4190,
     759,   759,   759,   759,   759,   759,   759,   759,   759,   759,
     759,  3666,  1816,   759,   759,  3677,   759,  1720,   759,   591,
    2663,  2495,   759,  2641,   759,   759,  2614,  3284,  3283,  1129,
    1130,  4053,  4054,  3505,  1693,  3323,   759,   759,  4042,   917,
    1526,  1527,  1022,  4124,   759,  2279,   902,  1766,  2280,  1788,
    4132,   759,   759,   759,  2004,   759,  3352,  2160,  3270,  4139,
    1187,  4167,   759,   759,   759,  4113,   759,   759,   759,   759,
     759,  4064,   759,   759,   759,   759,   759,   759,   759,   759,
    4240,  4243,  4233,   759,   759,  3586,  1724,  3287,  2259,  3309,
    3047,   847,  3519,   844,   777,  3669,  2197,  1280,  1739,  3777,
    1686,  3783,  1985,  2972,   849,  1285,   815,  1008,  1731,   788,
     621,   622,  1009,   789,  1010,     0,     0,     0,  4176,     0,
       0,     0,     0,  4181,  1511,  1512,  1513,  1514,  1515,   790,
       0,     0,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,     0,     0,     0,   792,     0,     0,     0,     0,
       0,     0,     0,  1188,     0,     0,     0,     0,     0,     0,
    4217,     0,     0,     0,     0,     0,     0,     0,     0,  1594,
     793,     0,  1528,     0,     0,   778,     0,  1189,     0,     0,
       0,  1190,     0,   794,   795,     0,  1529,  1530,   591,     0,
       0,     0,  1594,     0,  4217,     0,     0,     0,     0,  1594,
       0,     0,     0,     0,   779,  1594,     0,     0,     0,     0,
     759,     0,     0,     0,  1191,     0,     0,   780,   759,  1516,
    1517,  1518,  1519,     0,     0,     0,     0,   796,     0,     0,
    1030,  1192,     0,     0,     0,     0,     0,     0,     0,     0,
     781,     0,   782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   783,     0,     0,   797,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   784,     0,     0,  1079,     0,   798,     0,
     799,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1193,     0,     0,     0,     0,     0,     0,   785,     0,
       0,     0,     0,     0,   786,     0,     0,     0,     0,     0,
       0,     0,     0,  1194,     0,     0,     0,     0,     0,  1520,
    1123,  1521,  1522,  1523,     0,     0,     0,     0,     0,     0,
    1524,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   787,     0,     0,     0,     0,     0,     0,
       1,     2,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     3,     0,  1131,
       0,     4,  1132,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     6,     0,     0,     0,
       0,     0,     0,     7,     0,     0,     0,     8,     9,     0,
       0,     0,     0,     0,     0,     0,  1525,     0,   759,     0,
       0,  1195,    10,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    11,     0,     0,     0,  1197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    12,  1198,     0,     0,     0,     0,  1526,  1527,
      13,    14,    15,     0,     0,     0,     0,   788,     0,     0,
       0,   845,    16,    17,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,   790,     0,     0,
       0,     0,  1199,  1200,     0,   791,     0,     0,    19,     0,
       0,     0,     0,   792,   759,   759,   759,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,  1201,   759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   793,    21,
       0,     0,     0,     0,    22,     0,     0,    23,     0,     0,
       0,   794,   795,     0,   759,     0,     0,     0,     0,     0,
     759,     0,     0,   759,  1416,   759,     0,     0,     0,     0,
      24,   759,    25,   759,   759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    26,     0,
       0,     0,     0,     0,     0,   796,     0,     0,     0,     0,
    1528,     0,     0,     0,     0,    27,     0,     0,     0,    28,
       0,     0,     0,  1133,  1529,  1530,     0,     0,     0,  1481,
    1482,     0,     0,     0,   797,     0,     0,     0,  1492,  1493,
       0,     0,  1496,  1497,  1498,     0,     0,     0,     0,  1503,
     759,     0,  1505,  1506,     0,  1507,   798,  1508,   799,     0,
       0,     0,     0,     0,  1541,  1542,  1543,  1544,     0,  1546,
       0,     0,     0,     0,     0,     0,     0,  1554,  1555,     0,
    1558,  1559,     0,     0,     0,     0,  1563,     0,  1564,  1565,
    1566,     0,     0,  1569,  1570,  1571,  1572,  1573,  1574,     0,
       0,  1577,  1578,     0,  1581,     0,  1582,     0,    29,     0,
    1585,     0,  1589,  1590,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1597,  1598,     0,    30,     0,     0,
       0,     0,  1606,     0,     0,     0,     0,    31,     0,  1611,
    1612,  1613,     0,  2814,     0,     0,     0,     0,    32,     0,
    1868,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1870,  1871,     0,     0,     0,     0,     0,     0,
      33,     0,  1649,    34,     0,    35,     0,     0,    36,     0,
       0,    37,    38,     0,     0,     0,     0,     0,     0,    39,
       0,    40,     0,  1872,     0,  1870,  1871,  1873,    41,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
    1876,     0,    43,     0,     0,     0,     0,    44,  1877,    45,
       0,     0,    46,     0,     0,     0,     0,     0,  1878,     0,
    1873,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1879,  1876,     0,     0,    47,     0,     0,     0,
      48,  1877,     0,     0,     0,     0,  1383,     0,     0,  1880,
       0,     0,     0,     0,  1417,     0,  1881,     0,     0,     0,
       0,     0,     0,  2815,     0,  1879,     0,     0,     0,   759,
       0,  1884,     0,     0,     0,     0,     0,  1885,     0,  1383,
       0,     0,  1880,    49,     0,     0,     0,     0,  1738,     0,
       0,     0,     0,     0,     0,    50,  1753,     0,     0,    51,
       0,     0,    52,     0,     0,  1886,     0,    53,     0,     0,
    1885,     0,  1418,  1419,  1420,  1421,  1422,  1423,     0,  1424,
    1425,  1426,  1427,  1428,  1429,  1430,     0,  1431,  1432,     0,
       0,     0,     0,     0,    54,     0,   759,     0,     0,     0,
     759,     0,     0,     0,  1888,   759,   759,     0,     0,    55,
       0,  1889,     0,     0,   759,     0,     0,   759,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,   759,     0,   759,
     759,     0,   759,   759,   759,   759,   759,  1888,     0,   759,
       0,     0,     0,     0,  1889,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,   759,     0,   759,  1890,
     759,   759,   759,   759,     0,     0,     0,   759,   759,   759,
       0,     0,     0,     0,   759,   759,   759,     0,   759,  1891,
     759,     0,   759,     0,   759,     0,   759,     0,     0,     0,
       0,   759,     0,     0,     0,     0,     0,  1892,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,   759,
    1433,  1434,  1891,     0,     0,     0,   759,     0,     0,   759,
       0,     0,     0,     0,     0,   759,     0,     0,   759,     0,
    1892,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1895,     0,     0,  2016,     0,     0,     0,
    1896,     0,     0,     0,     0,     0,     0,     0,  1898,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     1,     2,     0,     0,     0,     0,     0,
       0,     0,     0,  1896,     0,     0,     0,   759,     0,     0,
       0,  1898,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,  1901,     0,     0,     0,     0,     5,     6,
       0,     0,     0,     0,     0,     0,     7,     0,     0,     0,
       8,     9,     0,     0,     0,  1904,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    10,     0,     0,     0,     0,
       0,     0,  2091,  2093,  2095,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    11,     0,     0,     0,  1904,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    12,     0,     0,     0,     0,
       0,  1905,  2129,    13,    14,    15,     0,     0,     0,     0,
       0,  2134,     0,  2135,     0,    16,    17,  1906,     0,     0,
    1907,     0,     0,     0,     0,     0,     0,     0,  2739,     0,
       0,     0,     0,     0,  1905,     0,     0,     0,     0,     0,
       0,    19,     0,     0,     0,     0,  2739,  2739,     0,     0,
    1906,     0,     0,  1907,     0,     0,  1909,    20,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    21,     0,     0,     0,     0,    22,     0,     0,
      23,     0,     0,     0,     0,     0,     0,     0,  2214,  1909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    24,     0,    25,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    27,     0,
       0,     0,    28,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2739,  2739,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   866,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   823,   867,
       0,   759,     0,     0,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    29,     0,   868,   869,     0,     0,   759,   759,     0,
       0,     0,     0,     0,   870,     0,     0,     0,     0,     0,
      30,     0,     0,     0,     0,     0,     0,   759,     0,     0,
      31,     0,     0,     0,     0,   871,   759,   872,   759,   873,
     759,    32,     0,     0,     0,     0,     0,     0,   874,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     759,     0,     0,    33,     0,   759,    34,     0,    35,     0,
       0,    36,     0,     0,    37,    38,     0,     0,     0,     0,
       0,     0,    39,     0,    40,     0,     0,  2425,     0,   759,
       0,    41,     0,     0, -1674,   875,     0,    42,     0,     0,
     876,     0,     0,   877,     0,    43,     0,     0,     0,     0,
      44,     0,    45,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   878,     0,
     879,     0,     0,     0,     0,     0,   880,     0,   881,    47,
       0,     0,     0,    48,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   759,  2504,     0,     0,   759,  2506,     0,
       0,   882,   883,  2508,  2509,     0,     0,     0,     0,     0,
       0,     0,  2524,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   884,     0,  2531,    49,  2532,     0,     0,
    2534,  2535,  2536,  2537,  2538,     0,     0,     0,    50,     0,
       0,   759,    51,     0,   885,    52,  2542,     0,     0,     0,
      53,     0,     0,     0,  2543,     0,  2544,     0,  2545,  2546,
    2547,     0,     0,     0,     0,  2550,  2551,  2552,     0,     0,
       0,   886,  2554,  2555,  2556,     0,  2557,    54,  2559,     0,
    2561,     0,  2563,     0,  2564,     0,     0,     0,     0,  2565,
    3112,  3113,    55,     0,     0,     0,  3114,     0,  3115,     0,
    3116,  3117,     0,     0,     0,     0,     0,  2578,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3118,     0,     0,
       0,     0,     0,  2588,     0,     0,  2591,     0,     0,     0,
       0,     0,     0,     0,     0,   887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   759,   759,     0,     0,     0,     0,   888,     0,
       0,     0,     0,     0,  3119,     0,     0,  3120,     0,   889,
     890,     0,     0,   891,   892,  3121,     0,  2739,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3122,     0,   893,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3123,
       0,     0,     0,     0,     0,     0,   759,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3124,     0,  3125,     0,     0,   894,     0,     0,
     759,   759,     0,   759,     0,     0,  3126,  3127,     0,     0,
     895,     0,   759,     0,     0,     0,     0,   759,     0,     0,
     759,     0,   759,   759,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2202,     0,     0,     0,   896,
       0,     0,     0,   759,     0,     0,  3128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   897,   759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3129,     0,     0,     0,     0,     0,
       0,     0,   759,  3130,  3131,     0,  3132,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   759,     0, -2202,     0,  3133,  3134,  3135,     0,
     898,     0,     0,     0,     0,     0,   759,     0,     0,     0,
       0,     0,     0,     0,     0,  3136,  3137,  3138,     0,     0,
       0,     0,  3139,     0,     0,  3140,   759,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,     0,     0,     0,
       0,  3141,  3142,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3143,  3144,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2895,
       0,     0,     0,  2897,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3146,
       0,     0,     0,  3147,     0,  2916,  2917,     0,     0,     0,
       0,     0,     0,     0,     0,  3148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2937,     0,     0,     0,     0,
       0,     0,     0,     0,  2947,     0,  2949,     0,  2951,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3149,     0,     0,
    3150,     0,     0,  3151,  3152,  3153,  3154,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2981,     0,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3155,  3156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   759,   759,
       0,     0,     0,     0,     0,     0,     0,   759,     0,  3157,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3037,     0,     0,     0,  3041,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3072,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   759,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   759,     0,     0,     0,     0,     0,     0,
    3168,  3169,     0,     0,     0,     0,     0,   759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3214,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3234,  3235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3242,  3736,     0,     0,     0,  3244,     0,     0,  3245,     0,
    3246,  3247,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3264,     0,     0,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
     759,     0,     0,     0,     0,     0,     0,     0,     0,   759,
    3264,   759,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,     0,     0,     0,
       0,  3736,  3736,     0,  3310,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3264,     0,     0,     0,     0,     0,
       0,     0,     0,  3334,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,     0,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   759,
       0,  3736,  3736,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3973,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,  3736,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3264,     0,     0,
       0,     0,  3736,   759,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3736,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3530,  3531,     0,     0,
       0,     0,     0,     0,     0,  3072,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,  3736,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3736,  3736,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3736,     0,     0,     0,     0,
       0,     0,   759,     0,     0,  3736,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   759,     0,     0,     0,
       0,     0,     0,  3736,     0,  3736,  3072,     0,     0,     0,
    3634,     0,     0,     0,     0,  3736,     0,     0,     0,   759,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,  3736,     0,  3736,     0,  3736,     0,     0,     0,     0,
       0,  3264,  3736,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3736,     0,  3072,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3037,  3736,
    3736,     0,     0,     0,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3736,  3736,     0,     0,     0,
    3736,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3810,     0,
       0,     0,     0,     0,     0,     0,     0,  3815,     0,  3817,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3838,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3072,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3072,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3929,     0,  3930,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3938,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4025,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4030,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3264,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4076,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
    4170,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,  1586,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,  4218,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
    3264,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,  1587,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,  1588,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
    3033,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,  3034,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,  3035,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,  3036,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,  1502,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,  2090,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,   690,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,  2092,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,   674,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,   690,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,  2094,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,   662,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,  1061,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,  1620,     0,     0,     0,     0,  1621,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,     0,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,  2503,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,   690,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,  2549,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,  3263,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,  4099,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
       0,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,     0,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,  1635,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,     0,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,  1637,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,     0,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,   640,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,  2235,     0,     0,
       0,     0,   196,   197,   661,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,   692,
     693,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
    2236,   432,   433,  2237,     0,     0,     0,     0,     0,   435,
     436,     0,     0,   718,   437,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,     0,     0,   135,     0,   136,   137,   138,   139,
     140,     0,     0,     0,     0,     0,   141,   737,   738,   142,
       0,   143,   144,   145,   146,   147,   148,   149,     0,   150,
       0,     0,     0,   151,     0,     0,     0,   152,     0,     0,
     153,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,   161,     0,   162,   163,     0,   164,
       0,   165,   166,   167,   168,   169,   170,     0,   171,   172,
       0,   173,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,  2348,   183,   184,   185,   186,   187,     0,   188,
       0,     0,   189,     0,     0,   190,     0,     0,     0,   191,
       0,     0,     0,   192,   193,   194,     0,     0,   195,     0,
       0,     0,     0,   196,   197,     0,     0,     0,     0,   198,
       0,   199,     0,     0,     0,   200,     0,   201,   202,   203,
     204,     0,     0,     0,   205,     0,     0,   206,   207,   208,
       0,     0,     0,   209,     0,   210,   211,     0,   212,   213,
     214,     0,     0,   215,   216,     0,   217,   218,   219,   220,
     221,     0,     0,   222,   223,   224,     0,     0,   225,   226,
       0,   227,   228,   229,     0,     0,   230,     0,     0,     0,
     231,     0,   232,   477,   233,     0,   234,   235,   236,   237,
     238,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,     0,   243,   244,     0,     0,     0,   245,   246,   247,
     248,     0,     0,   249,   250,   251,  1936,     0,   252,     0,
       0,     0,     0,   253,   254,     0,     0,     0,   255,     0,
     256,   257,     0,   258,   259,     0,     0,     0,   260,  1937,
       0,   261,   262,     0,     0,   263,     0,     0,   264,   265,
       0,  2878,     0,     0,     0,   266,   267,     0,   268,     0,
     269,     0,   270,   271,     0,     0,     0,     0,     0,     0,
       0,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,     0,   285,   286,   287,     0,   288,
     289,   290,   291,     0,   292,   293,     0,     0,     0,     0,
     294,   295,   296,   297,   298,   299,     0,     0,   300,   301,
       0,   302,     0,   303,     0,   304,   305,   306,   307,   308,
     309,   310,   311,   312,     0,     0,   313,   314,     0,     0,
     315,   316,   317,   318,     0,     0,     0,   319,   320,     0,
       0,     0,     0,   321,   322,   323,     0,   324,   325,   326,
       0,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,   329,   330,     0,   331,   332,   333,   334,  2879,
     336,   337,   338,   339,   340,   341,   342,     0,     0,   343,
     344,   345,     0,   346,     0,   347,   348,   349,   350,   351,
       0,   352,   353,   354,     0,     0,   355,     0,     0,     0,
     356,   357,   358,   359,   360,     0,     0,   361,   362,   363,
     364,   365,     0,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,   372,     0,   373,   374,     0,   375,   376,
       0,     0,     0,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,  -436,     0,     0,   389,
     390,   391,   392,     0,     0,     0,   393,     0,     0,     0,
     394,     0,   395,   396,   397,   398,     0,   399,   400,   401,
     402,   403,   480,     0,     0,     0,     0,     0,   404,   405,
       0,   406,     0,     0,   407,     0,     0,   408,   409,   410,
       0,     0,   411,   412,     0,   413,   414,   415,   416,   417,
     418,     0,     0,   419,   420,   421,   422,     0,   423,   424,
       0,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,   433,   434,     0,     0,     0,     0,     0,
     435,   436,     0,     0,     0,   437,   438,   439,   440,     0,
     441,   442,     0,   443,   444,     0,   445,   446,     0,     0,
     447,     0,     0,   448,     0,   449,     0,   450,   451,     0,
       0,     0,     0,     0,     0,   452,     0,     0,   453,     0,
       0,     0,   454,   455,   456,   457,     0,     0,     0,     0,
       0,     0,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,  2413,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,  2348,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,   477,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,  1936,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,  1937,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,   480,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,   135,     0,   136,   137,   138,   139,   140,     0,
       0,     0,     0,     0,   141,     0,     0,   142,  2413,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   223,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,  2226,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
    2642,     0,     0,   141,     0,     0,   142,   738,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
       0,     0,   135,     0,   136,   137,   138,   139,   140,  4223,
       0,     0,     0,     0,   141,  4224,   738,   142,     0,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   223,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,  1065,
       0,     0,     0,   141,     0,     0,   142,   738,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,  1258,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,     0,     0,
       0,     0,   141,     0,     0,   142,   511,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     223,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,     0,
       0,   135,  2167,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,   511,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,  2412,     0,
       0,     0,   141,     0,     0,   142,  2413,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     223,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,  4224,   738,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,     0,     0,
       0,     0,   141,     0,     0,   142,   511,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     577,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   578,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,   135,
       0,   136,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   142,   511,   143,   144,   145,   146,
     147,   148,   149,     0,   150,     0,     0,     0,   151,     0,
       0,     0,   152,     0,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,     0,     0,   160,   161,
       0,   162,   163,     0,   164,     0,   165,   166,   167,   168,
     169,   170,     0,   171,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   186,   187,     0,   188,     0,     0,   189,     0,     0,
     190,     0,     0,     0,   191,     0,     0,     0,   192,   193,
     194,     0,     0,   195,     0,     0,     0,     0,   196,   197,
       0,     0,     0,     0,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,     0,     0,   222,   223,
     224,     0,     0,   225,   226,     0,   227,   228,   229,     0,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   235,   236,   237,   238,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,     0,   243,   244,     0,
       0,     0,   245,   246,   247,   248,     0,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,     0,   253,   254,
       0,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,     0,   264,   265,     0,     0,     0,     0,     0,
     266,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,     0,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,     0,   288,   289,   290,   291,     0,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,     0,     0,   300,   301,     0,   302,     0,   303,     0,
     304,   305,   306,   307,   308,   309,   310,   311,   312,     0,
       0,   313,   314,     0,     0,   315,   316,   317,   318,     0,
       0,     0,   319,   320,     0,     0,     0,     0,   321,   322,
     323,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,     0,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   352,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,     0,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,     0,     0,   411,   412,     0,
     413,   414,   415,   416,   417,   418,     0,     0,   419,   420,
     421,   422,     0,   423,   424,     0,     0,   425,   426,   427,
     428,     0,     0,   429,   430,     0,   431,   432,   433,   434,
       0,     0,     0,     0,     0,   435,   436,     0,     0,     0,
     437,   438,   439,   440,     0,   441,   442,     0,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   450,   451,     0,     0,     0,     0,     0,     0,
     452,     0,     0,   453,     0,     0,     0,   454,   455,   456,
     457,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,     0,   135,     0,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,   738,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,     0,   135,     0,   136,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   142,  2413,   143,   144,   145,   146,   147,   148,
     149,     0,   150,     0,     0,     0,   151,     0,     0,     0,
     152,     0,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,     0,     0,   160,   161,     0,   162,
     163,     0,   164,     0,   165,   166,   167,   168,   169,   170,
       0,   171,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   186,
     187,     0,   188,     0,     0,   189,     0,     0,   190,     0,
       0,     0,   191,     0,     0,     0,   192,   193,   194,     0,
       0,   195,     0,     0,     0,     0,   196,   197,     0,     0,
       0,     0,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,     0,     0,   222,   223,   224,     0,
       0,   225,   226,     0,   227,   228,   229,     0,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     235,   236,   237,   238,     0,   239,     0,     0,     0,   240,
     241,     0,   242,     0,     0,   243,   244,     0,     0,     0,
     245,   246,   247,   248,     0,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,     0,   253,   254,     0,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
       0,   264,   265,   589,     0,     0,     0,     0,   266,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,     0,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,     0,   288,   289,   290,   291,     0,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   298,   299,     0,
       0,   300,   301,     0,   302,     0,   303,     0,   304,   305,
     306,   307,   308,   309,   310,   311,   312,     0,     0,   313,
     314,     0,     0,   315,   316,   317,   318,     0,     0,     0,
     319,   320,     0,     0,     0,     0,   321,   322,   323,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,     0,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
       0,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   352,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,     0,     0,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,     0,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,     0,     0,   411,   412,     0,   413,   414,
     415,   416,   417,   418,     0,     0,   419,   420,   421,   422,
       0,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     132,   429,   430,     0,   431,   432,   433,   434,     0,     0,
       0,     0,     0,   435,   436,     0,     0,     0,   437,   438,
     439,   440,     0,   441,   442,     0,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     450,   451,     0,     0,     0,     0,     0,     0,   452,     0,
       0,   453,     0,     0,     0,   454,   455,   456,   457,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   135,     0,   136,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     142,  1607,   143,   144,   145,   146,   147,   148,   149,     0,
     150,     0,     0,     0,   151,     0,     0,     0,   152,     0,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,     0,     0,   160,   161,     0,   162,   163,     0,
     164,     0,   165,   166,   167,   168,   169,   170,     0,   171,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   186,   187,     0,
     188,     0,     0,   189,     0,     0,   190,     0,     0,     0,
     191,     0,     0,     0,   192,   193,   194,     0,     0,   195,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,     0,     0,   222,   223,   224,     0,     0,   225,
     226,     0,   227,   228,   229,     0,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   235,   236,
     237,   238,     0,   239,     0,     0,     0,   240,   241,     0,
     242,     0,     0,   243,   244,     0,     0,     0,   245,   246,
     247,   248,     0,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,     0,   253,   254,     0,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,     0,   264,
     265,   589,     0,     0,     0,     0,   266,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,     0,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,     0,
     288,   289,   290,   291,     0,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   298,   299,     0,     0,   300,
     301,     0,   302,     0,   303,     0,   304,   305,   306,   307,
     308,   309,   310,   311,   312,     0,     0,   313,   314,     0,
       0,   315,   316,   317,   318,     0,     0,     0,   319,   320,
       0,     0,     0,     0,   321,   322,   323,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   352,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
       0,     0,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,     0,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,     0,     0,   411,   412,     0,   413,   414,   415,   416,
     417,   418,     0,     0,   419,   420,   421,   422,     0,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   132,   429,
     430,     0,   431,   432,   433,   434,     0,     0,     0,     0,
       0,   435,   436,     0,     0,     0,   437,   438,   439,   440,
       0,   441,   442,     0,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   450,   451,
       0,     0,     0,     0,     0,     0,   452,     0,     0,   453,
       0,     0,     0,   454,   455,   456,   457,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,  2682,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,   589,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,  3295,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3709,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3710,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,     0,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3711,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3712,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3713,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3714,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3715,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3716,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
    4230,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,  2006,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,  2670,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,  2976,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,  3300,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,  2327,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,  2328,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,  2329,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,  2330,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,   981,   982,     0,   319,
     320,     0,     0,  2331,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,  4210,   536,  4211,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,  2332,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,  2521,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  2676,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,  2149,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,  2150,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,  1767,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,  1768,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,   695,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,  1769,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,  2684,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  2685,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,  2521,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
    2676,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,   940,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,  1311,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,   918,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,   919,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   920,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,  2521,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  2724,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,  2666,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
    4128,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,  4129,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,   536,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,  1017,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  1929,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
    2260,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,  2261,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,  2766,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,  2844,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
    2260,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,  1688,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,  1689,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3709,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3710,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,  -297,  -297,
     209,     0,  -297,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3711,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3712,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3713,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3714,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3715,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3716,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3709,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3710,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,  -318,     0,   209,     0,  -318,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3711,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3712,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3713,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3714,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3715,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3716,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,  -318,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3709,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3710,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,  -315,     0,
     209,     0,  -315,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3711,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3712,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3713,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3714,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3715,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3716,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,  -315,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3709,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3710,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,  4026,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3711,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3712,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3713,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3714,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3715,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3716,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3709,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3710,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,  -320,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3711,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3712,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3713,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3714,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3715,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3716,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3709,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3710,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,  4133,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3711,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3712,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3713,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3714,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3715,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3716,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3709,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3710,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,  4179,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3711,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3712,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3713,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3714,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3715,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3716,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3709,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3710,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,  -301,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3711,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3712,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3713,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3714,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3715,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3716,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3709,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3710,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,     0,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3711,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3712,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3713,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3714,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3715,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3716,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3709,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3710,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,     0,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3711,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3712,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3713,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3714,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3715,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3716,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,  4029,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,     0,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,     0,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,     0,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,     0,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,     0,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,     0,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,     0,   463
};

static const yytype_int16 yycheck[] =
{
       6,   612,   549,   621,   622,   549,   933,   654,   655,   121,
    1115,   934,   571,    19,   850,  1115,    22,   659,  1739,  1604,
    1021,  1413,    20,     6,  1707,    31,  1086,  1062,   769,   639,
     876,    29,    38,  1015,  1016,    41,   494,    35,   678,    45,
     874,  1239,   898,   585,   691,  1726,  2379,    53,  1314,  1411,
    1178,  2185,   898,  1957,  2701,  2230,  1137,  1394,  2309,  2263,
    2264,  2265,  2022,  1144,   711,   899,  2649,  2027,  2451,  1053,
    3068,   713,  2001,  1245,   716,   938,   723,   724,   725,     4,
    2498,  2484,  1867,    22,  2114,  1145,  1146,    93,   938,  1149,
    1150,  1151,  1152,  1920,  1154,  1155,  1156,  1157,  1158,  1159,
    1160,  1161,   608,   609,  1402,  2274,  2275,  2297,  2836,   115,
    1796,   117,  1726,  1865,   120,   121,   122,  1325,  1455,  2253,
    3074,   731,   732,   733,  1865,  1868,  2374,    33,   626,  1872,
    2290,   742,  1982,   743,   117,  1343,  2958,   120,  2298,  1848,
    1883,  2353,  2157,  1351,  1352,    24,  3285,  1982,  1820,  1821,
    1893,  2512,     9,  1384,    93,  2516,  3131,  3132,    16,    46,
    3135,    15,    16,   833,  3092,  1837,    50,    15,    16,    18,
    2108,    28,    70,  1737,    15,    16,    59,    34,   142,  3154,
      18,    16,  1854,  1855,    35,  3160,    29,   165,    18,  1839,
      50,    73,   103,   116,  3332,  2166,    74,   142,  1870,  1871,
     142,  1873,    15,    16,  1876,  1877,  2338,  2339,  1880,   127,
    2486,    15,    16,  1885,    10,    20,    45,  1889,  1890,  1891,
    1892,    15,    16,   219,  1896,    20,  1898,  2567,    33,   771,
    1982,  2460,  1904,   105,  1943,  1907,  2356,  1909,  2342,  1948,
    1811,  1982,    47,    50,   914,  1954,  1955,   136,   185,  2632,
    1959,   119,   175,    58,    59,  1857,    15,    16,    55,  3864,
    1971,   213,   253,    58,    59,   356,  1394,   326,   123,  2830,
      42,   123,  2243,   130,   345,   339,   614,     8,    57,    39,
     148,  2005,    51,  3281,   900,   182,   828,    73,   255,   237,
     148,    35,    61,   940,  1966,  1967,  1968,  1969,   385,   148,
      15,    16,   430,   152,    15,    16,    15,    16,    15,    16,
    3686,    18,   121,   371,   152,  3342,    58,    59,   274,   275,
    2452,  2453,   152,   259,   485,    12,   119,  1455,  2515,   120,
      15,    16,   119,   254,  2636,   155,   257,   412,    15,    16,
     219,   182,   518,   339,   267,   217,   813,    15,    16,   253,
     201,   465,   561,  2282,   180,   148,    40,   239,   423,    67,
    3745,   148,  3504,   336,   338,   356,   148,   479,   223,   198,
      15,    16,    15,    16,   159,   993,   994,   995,   182,   487,
     596,   198,    64,    15,    16,   596,   165,   603,  2771,   159,
     169,   518,   603,  3368,   603,   604,    62,   484,  3540,   481,
     185,   180,  3377,   515,   340,    67,    15,    16,   381,   517,
     485,    62,  1052,    77,   293,   185,   394,   531,  2720,   342,
     502,  3396,    61,   240,   286,  1065,  3401,  2642,   766,    15,
      16,   213,   270,   609,  1175,   332,   262,   106,   229,   413,
     109,  1364,   173,   148,    61,   132,   533,   131,   385,  3825,
     917,  2296,   356,   239,   410,   411,   962,   201,   135,   518,
     518,   270,    70,   624,    15,    16,    15,    16,   178,   421,
     437,    15,    16,   479,   395,   481,    15,    16,   338,  2683,
    3619,   429,   610,  3868,   543,  1319,   573,  3441,  1322,  4094,
     259,  1883,   498,  1327,    15,    16,   502,  3495,   494,    15,
      16,   355,  1839,   213,   358,   511,    15,    16,   297,   515,
     574,   517,  2716,   604,   355,    15,    16,   358,  2708,  1353,
    1354,  1384,   301,  2774,   530,  2249,  1654,    65,  1865,  1140,
    1376,  2358,   178,   604,  1384,  2362,  3097,   182,  1148,   604,
     179,   338,   355,  2755,   428,   358,  2758,  2759,   253,  2376,
    2377,   355,   558,   325,   358,  1165,    15,    16,   549,  2386,
     398,   355,  2756,  1233,   358,  2777,   455,   213,   428,   235,
     576,  2500,  1632,    15,    16,   512,  1034,  1035,   574,   585,
     322,   587,  1790,  1643,   235,  2412,  1646,  3541,  1258,   385,
    2342,  1454,   598,   599,  2303,   455,   355,  1055,   604,   358,
     606,  2342,   608,   609,  1454,  3252,  1064,   613,   614,  2885,
    2460,   440,   618,   577,  1912,   394,   599,   540,  1076,  1077,
    1078,   428,   628,   629,   630,  2460,   604,  1085,   634,   371,
    2568,  2860,   577,  2753,  1971,   577,  2607,  2608,  2609,   421,
     355,  2745,  1626,   358,   355,  1982,   355,   358,   355,   358,
     507,   358,  2361,  1394,  2363,  2482,   768,    15,    16,   598,
    3000,  2370,   573,   541,  3691,   604,   182,   518,   334,   526,
     355,  2321,   678,   358,  2383,  1217,   533,  1183,   355,  3633,
    2389,   358,  2653,  2654,  2655,   568,   529,   355,   484,  3617,
     358,  2255,  3830,   580,   529,  2404,   602,  2369,   580,   529,
     555,  3523,   559,   555,   602,   623,  2881,  3661,  2460,  2381,
     355,  1839,   355,   358,  1455,   358,   588,  2426,  2289,  2460,
     604,  3860,   580,   355,   484,   604,   358,  2859,  2657,  2658,
     736,  3071,   738,  1349,  1965,   589,  1242,   533,  2340,  1281,
     608,   589,   547,  2454,   383,   505,   355,   585,   589,   358,
     608,  1257,   547,   607,  3115,   575,   762,   763,   764,   608,
     766,   767,   768,   875,   770,   771,  2781,   561,  2451,   355,
    1440,   531,   358,  2497,   518,  4160,   589,   573,   442,   387,
     763,  1323,   490,   465,   767,   589,  2458,   770,  3149,   406,
     603,   604,    15,    16,  3009,   589,  3157,    15,    16,  3003,
     604,   165,   808,  3164,   355,  1303,   355,   358,  3762,   358,
     604,   355,   818,   602,   358,   608,   355,    15,    16,   358,
     486,   608,   828,   829,   182,   604,   608,   833,   490,  2191,
     589,  3006,  3971,   499,   355,    15,    16,   358,  3042,   355,
     165,  1388,   358,  1971,   603,   604,   355,   152,   499,   358,
     560,    73,    18,   522,  1982,   355,   525,  3105,   358,  3834,
     398,  3836,    15,    16,  2709,  2710,  3078,   609,  3058,   875,
    2591,    81,  3062,   578,   589,    15,    16,   137,   589,   818,
     589,    11,   589,   168,  3018,   286,  3614,  3081,   603,   604,
     829,    33,   603,   604,   603,   604,   355,   822,  3058,   358,
     252,   509,  3062,   608,   589,  2626,  3324,   138,   914,   270,
    1550,   550,   589,   355,   560,   204,   358,   183,   775,   604,
     586,   589,    15,    16,   532,  3879,  3113,  3114,   934,    95,
    1786,    15,    16,   185,  3121,   603,   604,  3124,  3125,    24,
    1786,    15,    16,   116,   589,  1779,   589,  3901,  3331,  2632,
      15,    16,    15,    16,  3141,  1789,   962,   589,  1792,  1793,
    1816,   604,  2891,  2355,  2356,  1463,  3329,    68,  3155,  2650,
    1816,   603,   604,  3160,  3161,  3162,  3163,   116,  3976,    79,
     589,   182,   148,    31,  2321,   489,   152,    15,    16,   493,
     120,  2051,   393,  2745,   603,   604,    68,   355,   490,   369,
     358,   148,   175,   589,  2745,  2342,  2007,  1013,  2274,  2275,
    2860,  1017,   350,  2699,   180,  1127,   583,   239,   604,   346,
     145,   116,    24,  3053,   580,  2860,   227,   194,   194,  2814,
     394,   156,  1650,   199,  3437,  1645,  2650,   398,   589,  2211,
     589,   269,  3211,  3014,   371,   589,  1052,  2128,   604,   217,
     589,   264,  1164,   604,   220,   604,   341,    15,    16,  1065,
     604,   227,   374,   191,   465,   604,   182,   303,   589,   394,
     237,   237,  2815,   589,  1013,  2283,   441,   569,  1017,   120,
     589,   253,   248,   604,  1702,   157,  1726,   253,  2771,   589,
      15,    16,   152,  3511,   267,   604,   262,  3460,  1839,  2134,
    2135,   367,  1965,  2301,   604,  3309,   253,   320,  2860,  1115,
    2408,  3833,   119,   221,   230,  1965,  2701,  2454,  1660,  2860,
     180,  1127,   230,  2460,   353,  2230,  3316,  3317,   267,   360,
     589,   259,   355,   385,   219,   358,  1248,   355,  3067,  2199,
     358,    15,    16,  2127,   286,   604,  3509,   589,    15,    16,
     465,   456,   180,  2137,   133,   356,  1662,   355,  1164,   325,
     358,   512,   604,  1169,    15,    16,   403,  3814,  1174,   342,
     270,  3754,   267,  1715,  1716,   355,   370,  1183,   358,    15,
      16,   347,   230,   393,   356,    15,    16,   447,   229,   356,
     356,   518,   420,  2321,  2299,   559,    15,    16,   464,  2299,
    1747,   490,   355,   342,   252,   358,    15,    16,   293,   116,
      22,  1217,    15,    16,   116,   355,   131,   219,   358,   385,
     117,   415,    95,  1229,   585,  1231,   578,  1233,   358,   354,
    1971,   589,   602,   325,   559,  1174,  1242,     0,    15,    16,
     604,  1982,  1248,    15,    16,   603,  4244,   342,    15,    16,
     535,  1257,  1258,   361,  2616,   347,   357,    12,    15,    16,
     512,  3088,   355,  3223,  3439,   358,   551,   433,   175,    15,
      16,   355,   610,   175,   358,  1281,  2405,   490,  1284,  1391,
     516,   355,  3109,  2388,   358,   357,  1292,   549,  2388,   455,
     355,   293,   355,   358,   201,   358,    15,    16,  1304,  1305,
    1306,  1307,  1308,  1309,    15,    16,   542,   544,  1314,  1234,
     447,   148,    15,    16,  1320,  1321,   538,  1323,   621,   622,
    1326,  1304,  1305,  1306,   452,  1308,  2454,   355,   173,   495,
     358,   228,  2460,   213,   341,   447,   315,   339,  1321,   561,
    1346,   603,   602,  1326,    15,    16,   606,   220,   160,  4071,
    4072,   579,    15,    16,    15,    16,    15,    16,   237,   407,
     267,  2753,  3713,  3714,   237,   267,   589,   540,  1307,   248,
    1309,   589,   447,   221,  1299,   248,   561,   132,    15,    16,
     374,   604,   230,   549,    19,  1391,   604,   302,    15,    16,
     270,   589,   517,   326,   217,   561,   456,   355,   243,  1405,
     358,   540,  1408,  1409,  3787,   129,   604,  1346,  2745,   589,
     604,  3774,   578,  3664,   580,    15,    16,   240,     8,   604,
     144,    15,    16,  2815,   604,   610,    15,    16,   463,   753,
     355,   578,   447,   358,  1440,   342,   589,   603,   604,    29,
     342,   607,   608,   146,  3807,   540,  3621,   447,   447,   589,
     447,   604,   325,  1459,   380,  1461,  1462,    12,  1464,  1465,
      71,   608,    15,    16,   604,   602,  1405,    15,    16,   561,
    1409,  1477,  1397,  1479,  3183,    15,    16,    12,  1461,  1462,
     447,   355,   152,   230,   358,   447,   447,   152,   355,   124,
     602,   358,   494,   338,  3454,   603,   589,    80,  2499,    15,
      16,   198,   249,   400,   355,   589,  2587,   358,    15,    16,
     447,   604,  3895,   361,   394,   589,    99,   841,   553,   355,
     604,  2131,   358,  2860,   589,   355,   589,   602,   358,  3663,
     604,   606,  2637,    15,    16,    20,   355,  2637,   603,   358,
     603,    12,   194,   240,  1550,  1551,   355,   512,    33,   358,
       6,  1663,   355,   121,   433,   358,   538,   592,    15,    16,
     433,   589,    47,    15,    16,   565,   566,   610,   179,   476,
      12,  2029,   574,    58,    59,   603,   120,   132,   355,   561,
    2321,   358,   447,   355,  2042,   518,   358,   602,   355,   509,
     455,   358,   512,  2235,  2236,  2237,   521,   132,   355,   496,
      56,   358,   602,   602,  1610,   602,   217,    15,    16,   355,
     543,   529,   358,  3981,    15,    16,  3984,  2075,   597,   598,
     599,   600,   495,  2985,    16,    15,    16,    15,    16,   240,
     159,   589,  2761,   540,   202,   602,   355,  3603,   540,   358,
     602,   602,    15,    16,   355,   603,  1652,   358,  3331,  3553,
    3554,   602,   355,   212,  1660,   358,  1662,  1663,   961,   610,
    3341,   132,  3995,  2792,   589,   602,    38,  3252,  1674,   602,
    1676,  2800,   568,    45,  2803,   571,  1682,  1683,  3882,  1685,
     136,  4032,  4033,   182,   355,  3399,  2144,   358,  3402,  1695,
     132,   194,   355,  1699,   355,   358,   355,   358,   512,   358,
     565,   566,   270,  3384,    15,    16,    16,    12,  1011,  1715,
    1716,  1717,  1718,  2454,  2843,   589,   335,   336,   355,  2460,
    1726,   358,   589,  1729,  1730,  1731,  1050,   515,   355,   603,
    4098,   358,  2860,    12,    15,    16,   603,   602,   589,    76,
    1746,    78,  3456,  1682,  1683,   217,  1685,  3713,  3714,  1755,
      15,    16,   603,   589,   253,   355,  1695,   217,   358,   589,
    1699,   355,    41,    24,   358,   212,   355,   603,   398,   358,
     589,    57,   383,   603,  3207,  3208,   217,  1101,  1717,  1718,
     589,  1105,   119,   194,   603,  1791,   589,   350,  1713,   419,
    1729,  1730,  1731,   227,   603,   950,   951,  1803,   602,   209,
     603,   211,   355,   140,  1810,   358,   610,   355,   102,    88,
     358,   436,   589,  2649,    93,   355,    46,   589,   358,   182,
     450,  2368,   589,   133,   566,  1750,   603,   132,    20,    15,
      16,   603,   589,   988,  2690,   455,   603,   174,   270,   355,
    2696,    33,   358,   589,  2690,   191,   603,  3816,   355,  3818,
    2696,   358,  1791,   326,   580,    47,  3054,   603,   509,   326,
    2895,   512,   603,   604,  2698,   159,    58,    59,  1980,   603,
     589,  1810,  1984,   355,    15,    16,   358,   608,   589,   165,
     336,  2916,  2917,   169,   603,   510,   589,  3853,  3854,   150,
     515,   185,   603,   610,   180,    15,    16,   202,   355,  1824,
    1906,   358,  2937,   355,  3337,  3010,   358,   558,  1833,  1834,
    2022,    15,    16,   259,  1920,  2027,    15,    16,   589,  1844,
    1845,  1846,  1847,  2270,  1849,  1850,   589,    95,   589,   352,
     589,     6,   603,   558,    15,    16,  3645,  3646,  3647,  3648,
     603,   397,   603,   399,   603,  3211,   556,   355,   573,   602,
     358,   484,   589,   232,   355,    15,    16,   358,   219,   603,
     604,  3066,   589,   168,   179,   355,  3066,   355,   358,   561,
     358,    16,   421,  3939,  1980,  2593,   603,    11,  1984,   602,
    1986,   602,   355,  1989,   602,   358,   602,    73,  3954,   589,
    1996,  1997,  1998,  1999,  3099,   589,  2002,   102,   602,  3099,
     589,  3967,   348,   603,   602,   315,  1989,   602,  2120,   603,
    2650,   602,   604,  2360,   603,   301,  2022,   602,   610,  1944,
    1945,  2027,  1947,   302,  1949,  1950,  1951,  1952,  1953,   603,
     604,  1956,   293,  1958,  4238,   602,   589,  2384,  2385,   521,
    2152,   589,   603,   604,   355,   518,   602,   358,   602,   589,
     603,   518,   220,   602,  4020,   603,   602,  1996,  1997,  1998,
     581,   582,   547,   603,   521,  3786,  4032,  4033,   405,   237,
     543,   603,   604,   589,   355,   602,   543,   358,   339,   602,
     248,   116,   589,   604,  3756,   364,   571,   603,   133,   602,
     355,   385,  2634,   358,   602,  1683,   603,  1685,   203,    58,
      59,  3083,  3084,   604,  3787,   602,   452,   589,   394,    68,
     150,  4077,  3545,  3546,  2120,  3548,  3549,   602,   602,  2860,
     518,  4087,  3794,   602,  2582,  3797,  3798,  3799,  3800,   602,
     335,   336,   589,   219,  3169,   602,   341,   589,  2680,  2145,
     175,  1729,  1730,  1731,  3536,  3537,  2152,  1218,   458,   459,
    1221,   603,  2264,  1224,  2266,  2267,    73,   325,   602,  4125,
    2166,  4127,   602,  3872,  3121,   602,   201,  3124,  3125,   355,
      87,  4137,   358,   478,   479,  3280,   481,   602,   483,   219,
    3280,   589,   552,   553,  3141,   555,   602,  4153,   589,  4155,
     495,  4157,  2198,   472,   162,   603,  2308,  2309,  4164,   589,
     602,   589,   603,    18,   603,   604,   603,   604,  3209,  4175,
      30,   602,  3895,   603,   355,   603,   589,   358,   512,  3891,
    3892,   603,   604,   602,  2230,  4191,  4192,   506,  3900,  3814,
     603,   602,   267,   494,   602,   355,   192,  2243,   358,   533,
     602,  4207,  4208,    15,    16,   602,  4212,   333,    24,   602,
    2256,   355,  2258,   339,   358,    75,   355,   362,  2264,   358,
    2266,  2267,    24,   603,   604,   433,   371,  2379,  2274,  2275,
     315,   602,   377,   602,   355,   603,   604,   358,   589,   573,
      95,   603,   604,   593,   594,   595,   596,   597,   598,   599,
     600,   610,   603,  2299,   602,   355,   602,    73,   358,   339,
     602,    25,  2308,  2309,    58,    59,   602,   342,   589,  3232,
     602,    73,   133,   574,   602,    73,   564,   565,   404,   567,
     602,   569,   603,   494,   589,   242,   146,   495,   603,   604,
     535,  2256,   602,   148,   290,   291,    12,   152,   603,   295,
     296,   347,  2348,   604,    68,   602,   551,  2353,   602,    73,
     602,  2349,  2358,   603,   604,   547,  2362,   602,  2364,   603,
     604,  2359,   602,   178,   469,   180,    71,  2365,  2374,   602,
    2376,  2377,   561,  2379,   150,   567,   568,   603,   604,   194,
    2386,   602,  2388,   114,   199,   603,   604,    11,   602,  2387,
     166,  2397,   150,   602,  2392,   119,   313,   384,   213,  2405,
    2398,  2399,   602,   589,   166,   220,  2412,  2413,   494,   230,
     603,   604,   227,   458,   459,   603,   604,   603,  2424,   603,
     604,   338,   237,   602,  3034,  1027,  1028,  1029,   603,   604,
     603,   604,   602,   248,   603,   604,   602,  1039,   253,   607,
     133,  2366,  2367,   219,   116,   602,    73,   262,   589,  4170,
     603,   604,   602,   558,   494,   602,   132,   219,  2397,   545,
      87,   219,   603,   603,   604,   602,  2391,  2925,  1070,   589,
     602,  1073,   603,   604,   179,  2481,  2482,   208,   102,   396,
     602,  3627,  3628,   603,   602,   589,    31,   602,   574,   602,
     589,  1093,  1094,   602,   315,  1097,   120,   603,   604,   603,
     127,   603,   604,   175,   603,   540,   602,  2965,   589,   602,
     325,   436,   217,   353,  1116,  1117,   240,   293,   603,   604,
     603,   604,   603,   509,  4245,  2450,   202,   603,   604,   589,
     347,   293,   347,   347,   574,   240,   604,   209,   213,   211,
     470,   356,  2481,   603,   603,   604,   603,   604,   593,   594,
     595,   596,   597,   598,   599,   600,    48,   333,   142,   143,
     380,   185,   264,   339,   604,   603,   604,   484,  3475,  3476,
     385,   333,    48,  3191,   305,   333,    73,   339,   309,   603,
     604,   339,   402,   603,   604,   316,   603,   604,   133,   213,
      35,   604,  3362,  3363,  3654,   267,   347,  2603,   347,    33,
    2606,  2607,  2608,  2609,   441,  3375,   603,   604,   105,  2615,
    3380,   335,   336,   549,   434,   242,   597,   341,   433,   158,
    3766,   455,   315,   347,  3770,    59,   602,  2633,  2634,   603,
     604,  2637,   253,  3403,   603,   604,  3406,   458,   459,   263,
     455,   603,   604,   180,  2650,   490,   404,  2653,  2654,  2655,
    3573,   603,   604,   150,   603,   604,  3579,    25,    26,   383,
    2666,   392,  2774,   116,   109,   370,  2672,   509,  2674,   489,
     342,   116,   106,  3220,  2680,   109,  2615,   158,   383,  3784,
     495,  3827,  3828,   117,  3784,   230,   313,   603,   604,   490,
      58,    59,    60,   496,   497,  1102,  1103,   500,   501,   264,
      68,   504,   149,   506,    82,    73,   604,   252,   335,   336,
     349,   338,   505,    81,   445,  3893,  3894,   603,   494,   148,
     217,    61,   175,   168,   119,   116,   105,   451,   119,   609,
     175,    71,   494,     6,   549,   602,   494,   105,  3020,  3021,
     104,  2666,   446,    83,     4,   560,   561,   573,   201,  2755,
     230,   119,  2758,  2759,   122,  2761,   201,   604,   102,  2978,
    2979,   385,   370,   578,    55,   580,  3261,  3262,  2774,   396,
     315,  2777,   593,   594,   595,   596,   597,   598,   599,   600,
     413,   162,   150,   105,   175,   210,  2792,   545,   603,   604,
     335,   336,   607,   608,  2800,   292,   604,  2803,   574,    61,
     604,   610,   478,   479,   480,   481,   482,   483,    12,    71,
     201,    68,   574,   310,   267,   603,   574,  2823,   133,   495,
    2826,    83,   267,   603,   577,  2831,   550,   518,   604,   453,
     132,  2837,     9,   604,   602,  2841,   333,  2843,   603,   179,
     184,   610,   603,   610,   184,   576,   604,   252,   604,   217,
    2775,   610,  2858,    13,  2837,   150,   224,   484,  2783,   609,
     591,   264,   407,   264,   264,  2871,   264,    48,   540,   604,
    3975,   239,  2878,   217,   264,  3975,   267,   217,    35,   264,
    3498,   326,  1484,   509,  2890,   602,   510,  2826,   512,   342,
     259,   604,   337,   327,   369,   604,   341,   342,   529,   529,
     240,   604,   595,   596,   597,   598,   599,   600,  3550,  3551,
    3552,  3023,  3835,   458,   459,    12,   604,   179,  3754,   263,
     152,   604,   184,   604,   292,   604,   471,  3039,   597,   230,
     507,   231,   170,   180,    94,   554,   604,  3584,  2863,  2878,
      25,    26,   310,   604,   468,   372,   128,   152,   347,   604,
    1552,   342,   109,  2959,  1556,   217,   603,   152,   604,   116,
     152,  2967,   152,   123,   152,  3512,   152,   152,   173,   152,
     773,   556,   152,    58,    59,    60,   136,  1579,   240,   152,
     152,   186,   152,    68,   152,  2991,   152,   152,    73,  4049,
     152,   196,   604,   152,   152,   363,    81,   494,   152,   159,
     315,   161,   584,   371,  3010,  3011,   560,   185,  3014,   347,
     347,   168,   172,   510,   347,   604,   603,  3023,   175,   182,
     105,  3854,   603,  3029,   603,   603,   597,   603,   603,   463,
     370,   603,   192,  3039,   119,   182,   604,   122,   243,   244,
     596,  3047,  2967,   383,   201,   602,   604,  3606,   593,   594,
     595,   596,   597,   598,   599,   600,   603,   217,  3705,   603,
    3066,   603,   603,   223,   604,   150,   271,   603,   603,   603,
     438,   603,  3078,   518,   456,   549,   602,   522,   600,   602,
     525,  4141,  3088,   602,  3090,   603,   529,   540,   604,   102,
     535,   525,   578,  3099,   218,   540,   602,   501,   543,  3105,
    4205,  3107,   262,  3109,    11,  4205,   192,   182,   610,   453,
     267,  3223,   182,   603,  3658,   393,   455,   604,   180,   553,
     604,   383,    46,  4228,   323,   484,   494,   332,  4228,   473,
    4235,   484,   217,   473,   484,  4235,  4241,  4060,  4061,   224,
    4063,  4241,   510,   458,   459,   513,   159,   446,   484,   540,
     595,   596,   484,    71,   239,   370,   370,   370,    33,   529,
     238,   128,   510,   510,   238,   133,   510,   252,   512,   326,
     128,   515,   185,   370,    46,  3181,   370,   382,   602,   368,
     416,   549,   602,  3295,   341,   342,  4109,  4020,  4111,  4112,
     263,   370,   602,   610,   370,   370,   561,    95,   146,   226,
    3206,  3207,  3208,   226,   217,  3211,   550,   292,   610,    54,
     550,   473,   604,   610,   558,   603,   603,  3223,    63,   603,
     603,   610,   152,   153,   610,   310,   386,    72,   603,   603,
     603,   133,   603,   610,   610,   529,   604,   529,   604,    84,
      85,    86,   529,  4166,   518,   259,   406,    46,  3866,  3174,
     263,   126,   152,  3864,   414,   100,   186,   585,  3802,   602,
     602,   602,   422,    25,    26,   529,   196,   602,   152,  3275,
    3382,   353,  3197,   182,  3280,   150,  4203,   182,   363,   154,
     595,   596,   597,   598,   599,   600,   371,   447,   550,  3295,
     182,   227,  4125,   182,  4127,   234,    58,    59,    60,   610,
     460,   461,   610,   233,   342,   237,    68,   604,   237,   359,
     306,    73,   187,   105,   244,   105,   602,   240,   240,    81,
    4153,   610,   220,   529,   352,   602,   194,   518,    18,   204,
     430,  3337,   602,   370,   610,   356,  3883,   133,   597,   237,
     228,   271,  3454,   105,   504,   228,   602,   315,  3354,  3347,
     248,   602,   610,   438,   603,   603,   580,   119,  4191,  4192,
     122,   518,     6,   603,   603,   522,   603,   380,   525,    13,
      14,   602,   385,   533,   603,   603,  3382,   603,   535,   597,
     213,    25,    26,   540,   347,   604,   543,   603,   150,   264,
     254,   370,   604,   603,   182,   555,   230,   557,   250,   329,
     555,  3407,  3514,   610,    68,   237,   237,   347,  3414,   494,
     240,   286,    56,   315,   240,   602,    60,    61,    73,   381,
     604,    95,    66,    18,   470,   510,  3432,   325,   513,    73,
     604,   347,   347,   604,   230,   602,   347,    81,   595,   596,
     453,   347,   494,   604,    46,   447,   602,    91,  3454,   347,
     603,   603,   602,   604,   603,   217,   602,   602,  3383,   304,
     253,   105,   224,   603,   549,    46,   449,   603,   520,   580,
     398,   192,   139,   246,   603,   119,   321,   239,   122,   604,
     603,   194,   457,  4094,   602,   129,   130,   602,  4106,   237,
     458,   459,   136,   237,   604,   602,  3421,   510,   119,   119,
     144,   602,   515,   379,   148,   610,   150,   602,  3514,   384,
      77,   465,   135,   603,   470,   442,   603,   602,   393,   315,
     533,   604,   603,   603,    18,    33,  3532,   603,    33,   312,
     292,   603,   603,   408,   178,   433,   603,   603,   603,  3545,
    3546,   242,  3548,  3549,   603,   558,   220,   393,   310,   353,
     262,   426,  3664,   602,  4172,   580,   458,   459,   227,  4103,
     573,   603,   610,   237,   604,    46,   199,   312,   604,   398,
     561,   215,   518,   217,   248,   518,   561,   603,   602,   289,
     224,   571,   602,   602,   602,  4196,   602,   639,   119,   571,
     465,   466,   644,   602,   602,   239,   555,   495,   443,   240,
     240,   363,   341,    33,   342,   603,  3612,  3613,   342,   371,
     604,   164,   312,   602,   518,   490,   240,   518,  3624,  4230,
     565,   518,   674,   603,  4242,   593,   594,   595,   596,   597,
     598,   599,   600,   512,   509,   561,   602,   512,   690,   603,
     561,   227,   347,   337,   604,   488,   566,  3653,   292,   580,
    3656,   325,   497,   430,   342,   604,   603,   353,  3664,   555,
     500,   602,   458,   459,   602,   180,   310,   602,   147,   514,
     314,    30,   520,   347,  3613,   366,   438,   611,   577,   731,
     732,   733,   734,   180,   603,   128,   603,   128,  3694,   603,
    3939,   743,   594,   595,   596,   597,   598,   599,   600,   602,
     150,   385,    70,   406,  3710,  3954,   577,   351,   182,  3715,
      30,    61,   356,    61,  3653,   353,   602,   604,  3967,   363,
     501,   603,   255,    46,    46,   602,   370,   371,   602,     5,
     347,   347,   494,   146,   227,   608,   110,   111,   112,   113,
     114,   353,   353,   135,   127,   602,    46,    46,   510,   145,
      46,   513,   555,   123,   577,   146,   212,   401,   269,   433,
     611,   608,   118,   141,   437,    12,    13,   602,    46,    46,
      52,   415,   416,   417,   418,    46,   603,   439,  3784,   210,
     608,   146,   604,   603,  3896,   521,   604,   549,   197,   604,
      46,   608,   603,   603,   438,   604,   213,   593,   594,   595,
     596,   597,   598,   599,   600,   420,    52,   180,   180,   180,
    3816,   579,  3818,   521,  3820,   119,   342,   602,   455,   181,
     604,   495,  1960,  2159,  3720,  3184,  3183,  2337,  4077,  3430,
    3755,   205,   206,   207,   208,   622,  3867,  3747,  4087,  4039,
    3846,   947,  4040,  3428,  3611,  3432,  4230,    94,  4183,    45,
     494,   550,  2650,  1725,  3603,  3603,  3603,  3603,  3603,  4193,
    3603,  4074,  3603,  3603,  3603,  3603,   510,  4074,  3603,   513,
    3932,  4033,  3958,  3603,  3603,  1400,   123,  3957,   986,  1654,
    1919,  3887,  1402,  3995,  3620,  2798,  3274,  2991,  4137,   136,
    3896,  2628,   536,  1410,  2633,  3887,  3902,  3654,  3979,  1245,
    3277,  4141,  4057,  3802,  4103,   549,  4155,   489,  4157,  3200,
    1912,  1454,   159,  2482,   161,  4164,   968,  2864,  3109,  1920,
    2415,  3132,  3165,  3088,  3132,   172,  4175,  3571,  3346,  3391,
    3883,   305,  3382,   307,   308,   309,  3039,    11,  3824,    11,
    3828,  1468,   316,  4055,  3758,   192,  3827,  3770,  3766,  3624,
    1994,  3579,  1919,  2408,  3090,  1798,  3351,  2225,  4207,  4208,
    3089,  1450,  1717,  4212,   608,  3890,  1360,  1409,  2615,  3975,
     217,  1023,  1024,  2986,  2191,  2247,   223,  2110,  3605,   570,
    1032,  1033,  1034,  1035,  1036,  1037,  1038,  2967,  1736,  3995,
    2593,  1043,   862,  2300,  1046,  1047,  2028,  1049,  3056,  1051,
    3679,  1065,  2109,  1055,  4010,  4011,  1058,  1059,  1060,  1061,
    3539,  1063,  1064,  4010,  2138,   262,  4011,  3181,   392,  1071,
    1072,  3099,  1074,  1075,  1076,  1077,  1078,  1039,  1080,  4172,
    1082,  1083,  1084,  1085,  1086,  1087,  1088,  1089,  1090,  1091,
    1092,  3514,  1376,  1095,  1096,  3533,  1098,  1258,  1100,  4055,
    2252,  1999,  1104,  2229,  1106,  1107,  2186,  3005,  3004,    15,
      16,  3986,  3987,  3280,  1233,  3066,  1118,  1119,  3975,   560,
     444,   445,   635,  4079,  1126,  1787,   549,  1312,  1788,  1340,
    4086,  1133,  1134,  1135,  1477,  1137,  3107,  1673,  2989,  4096,
      33,  4139,  1144,  1145,  1146,  4067,  1148,  1149,  1150,  1151,
    1152,  4002,  1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,
    4235,  4241,  4224,  1165,  1166,  3384,  1264,  3010,  1741,  3047,
    2682,   541,  3306,    12,    13,  3522,  1699,   844,  1292,  3643,
    1226,  3649,  1459,  2603,   542,   849,   520,   622,  1282,   386,
     485,   485,   622,   390,   622,    -1,    -1,    -1,  4154,    -1,
      -1,    -1,    -1,  4159,   110,   111,   112,   113,   114,   406,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   414,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   422,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,
    4196,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4205,
     447,    -1,   576,    -1,    -1,    94,    -1,   150,    -1,    -1,
      -1,   154,    -1,   460,   461,    -1,   590,   591,  4224,    -1,
      -1,    -1,  4228,    -1,  4230,    -1,    -1,    -1,    -1,  4235,
      -1,    -1,    -1,    -1,   123,  4241,    -1,    -1,    -1,    -1,
    1292,    -1,    -1,    -1,   187,    -1,    -1,   136,  1300,   205,
     206,   207,   208,    -1,    -1,    -1,    -1,   504,    -1,    -1,
     644,   204,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     159,    -1,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   172,    -1,    -1,   533,    -1,    -1,    -1,
     674,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   192,    -1,    -1,   690,    -1,   555,    -1,
     557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   264,    -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,
      -1,    -1,    -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,   305,
     734,   307,   308,   309,    -1,    -1,    -1,    -1,    -1,    -1,
     316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    14,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,    -1,   355,
      -1,    34,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    56,    -1,    -1,    -1,    60,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,  1490,    -1,
      -1,   384,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    94,    -1,    -1,    -1,   408,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,   426,    -1,    -1,    -1,    -1,   444,   445,
     123,   124,   125,    -1,    -1,    -1,    -1,   386,    -1,    -1,
      -1,   390,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   148,    -1,   406,    -1,    -1,
      -1,    -1,   465,   466,    -1,   414,    -1,    -1,   161,    -1,
      -1,    -1,    -1,   422,  1586,  1587,  1588,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   177,    -1,    -1,   490,  1600,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,   192,
      -1,    -1,    -1,    -1,   197,    -1,    -1,   200,    -1,    -1,
      -1,   460,   461,    -1,  1626,    -1,    -1,    -1,    -1,    -1,
    1632,    -1,    -1,  1635,   968,  1637,    -1,    -1,    -1,    -1,
     223,  1643,   225,  1645,  1646,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
      -1,    -1,    -1,    -1,    -1,   504,    -1,    -1,    -1,    -1,
     576,    -1,    -1,    -1,    -1,   258,    -1,    -1,    -1,   262,
      -1,    -1,    -1,   589,   590,   591,    -1,    -1,    -1,  1023,
    1024,    -1,    -1,    -1,   533,    -1,    -1,    -1,  1032,  1033,
      -1,    -1,  1036,  1037,  1038,    -1,    -1,    -1,    -1,  1043,
    1712,    -1,  1046,  1047,    -1,  1049,   555,  1051,   557,    -1,
      -1,    -1,    -1,    -1,  1058,  1059,  1060,  1061,    -1,  1063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1071,  1072,    -1,
    1074,  1075,    -1,    -1,    -1,    -1,  1080,    -1,  1082,  1083,
    1084,    -1,    -1,  1087,  1088,  1089,  1090,  1091,  1092,    -1,
      -1,  1095,  1096,    -1,  1098,    -1,  1100,    -1,   351,    -1,
    1104,    -1,  1106,  1107,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1118,  1119,    -1,   370,    -1,    -1,
      -1,    -1,  1126,    -1,    -1,    -1,    -1,   380,    -1,  1133,
    1134,  1135,    -1,     6,    -1,    -1,    -1,    -1,   391,    -1,
      13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    -1,    -1,    -1,    -1,    -1,    -1,
     413,    -1,  1166,   416,    -1,   418,    -1,    -1,   421,    -1,
      -1,   424,   425,    -1,    -1,    -1,    -1,    -1,    -1,   432,
      -1,   434,    -1,    56,    -1,    25,    26,    60,   441,    -1,
      -1,    -1,    -1,    -1,   447,    -1,    -1,    -1,    -1,    -1,
      73,    -1,   455,    -1,    -1,    -1,    -1,   460,    81,   462,
      -1,    -1,   465,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   105,    73,    -1,    -1,   489,    -1,    -1,    -1,
     493,    81,    -1,    -1,    -1,    -1,   119,    -1,    -1,   122,
      -1,    -1,    -1,    -1,   214,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,   136,    -1,   105,    -1,    -1,    -1,  1941,
      -1,   144,    -1,    -1,    -1,    -1,    -1,   150,    -1,   119,
      -1,    -1,   122,   536,    -1,    -1,    -1,    -1,  1292,    -1,
      -1,    -1,    -1,    -1,    -1,   548,  1300,    -1,    -1,   552,
      -1,    -1,   555,    -1,    -1,   178,    -1,   560,    -1,    -1,
     150,    -1,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,   587,    -1,  2008,    -1,    -1,    -1,
    2012,    -1,    -1,    -1,   217,  2017,  2018,    -1,    -1,   602,
      -1,   224,    -1,    -1,  2026,    -1,    -1,  2029,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   239,  2039,    -1,  2041,
    2042,    -1,  2044,  2045,  2046,  2047,  2048,   217,    -1,  2051,
      -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,  2060,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2068,    -1,  2070,   239,
    2072,  2073,  2074,  2075,    -1,    -1,    -1,  2079,  2080,  2081,
      -1,    -1,    -1,    -1,  2086,  2087,  2088,    -1,  2090,   292,
    2092,    -1,  2094,    -1,  2096,    -1,  2098,    -1,    -1,    -1,
      -1,  2103,    -1,    -1,    -1,    -1,    -1,   310,    -1,    -1,
      -1,   314,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2121,
     410,   411,   292,    -1,    -1,    -1,  2128,    -1,    -1,  2131,
      -1,    -1,    -1,    -1,    -1,  2137,    -1,    -1,  2140,    -1,
     310,    -1,  2144,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,  1490,    -1,    -1,    -1,
     363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   371,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    13,    14,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   363,    -1,    -1,    -1,  2199,    -1,    -1,
      -1,   371,    -1,    -1,    34,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,    -1,    -1,
      60,    61,    -1,    -1,    -1,   438,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    -1,    -1,    -1,    -1,
      -1,    -1,  1586,  1587,  1588,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    -1,    -1,    -1,   438,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
      -1,   494,  1626,   123,   124,   125,    -1,    -1,    -1,    -1,
      -1,  1635,    -1,  1637,    -1,   135,   136,   510,    -1,    -1,
     513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2320,    -1,
      -1,    -1,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,
      -1,   161,    -1,    -1,    -1,    -1,  2338,  2339,    -1,    -1,
     510,    -1,    -1,   513,    -1,    -1,   549,   177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   192,    -1,    -1,    -1,    -1,   197,    -1,    -1,
     200,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1712,   549,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,    -1,   225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,    -1,
      -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2452,  2453,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    34,
      -1,  2503,    -1,    -1,    -1,  2507,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,    -1,    58,    59,    -1,    -1,  2529,  2530,    -1,
      -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,
     370,    -1,    -1,    -1,    -1,    -1,    -1,  2549,    -1,    -1,
     380,    -1,    -1,    -1,    -1,    90,  2558,    92,  2560,    94,
    2562,   391,    -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2582,    -1,    -1,   413,    -1,  2587,   416,    -1,   418,    -1,
      -1,   421,    -1,    -1,   424,   425,    -1,    -1,    -1,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,  1941,    -1,  2611,
      -1,   441,    -1,    -1,   149,   150,    -1,   447,    -1,    -1,
     155,    -1,    -1,   158,    -1,   455,    -1,    -1,    -1,    -1,
     460,    -1,   462,    -1,    -1,   465,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   183,    -1,
     185,    -1,    -1,    -1,    -1,    -1,   191,    -1,   193,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2675,  2008,    -1,    -1,  2679,  2012,    -1,
      -1,   216,   217,  2017,  2018,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2026,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   238,    -1,  2039,   536,  2041,    -1,    -1,
    2044,  2045,  2046,  2047,  2048,    -1,    -1,    -1,   548,    -1,
      -1,  2723,   552,    -1,   259,   555,  2060,    -1,    -1,    -1,
     560,    -1,    -1,    -1,  2068,    -1,  2070,    -1,  2072,  2073,
    2074,    -1,    -1,    -1,    -1,  2079,  2080,  2081,    -1,    -1,
      -1,   286,  2086,  2087,  2088,    -1,  2090,   587,  2092,    -1,
    2094,    -1,  2096,    -1,  2098,    -1,    -1,    -1,    -1,  2103,
      32,    33,   602,    -1,    -1,    -1,    38,    -1,    40,    -1,
      42,    43,    -1,    -1,    -1,    -1,    -1,  2121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,
      -1,    -1,    -1,  2137,    -1,    -1,  2140,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2834,  2835,    -1,    -1,    -1,    -1,   373,    -1,
      -1,    -1,    -1,    -1,   106,    -1,    -1,   109,    -1,   384,
     385,    -1,    -1,   388,   389,   117,    -1,  2859,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,    -1,   409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
      -1,    -1,    -1,    -1,    -1,    -1,  2898,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   174,    -1,   176,    -1,    -1,   452,    -1,    -1,
    2922,  2923,    -1,  2925,    -1,    -1,   188,   189,    -1,    -1,
     465,    -1,  2934,    -1,    -1,    -1,    -1,  2939,    -1,    -1,
    2942,    -1,  2944,  2945,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   490,    -1,    -1,    -1,   494,
      -1,    -1,    -1,  2965,    -1,    -1,   228,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   512,  2980,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3004,   265,   266,    -1,   268,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3034,    -1,   569,    -1,   298,   299,   300,    -1,
     575,    -1,    -1,    -1,    -1,    -1,  3048,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   317,   318,   319,    -1,    -1,
      -1,    -1,   324,    -1,    -1,   327,  3068,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3077,    -1,    -1,    -1,    -1,
      -1,   343,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   375,   376,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2503,
      -1,    -1,    -1,  2507,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,  2529,  2530,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2549,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2558,    -1,  2560,    -1,  2562,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   519,    -1,    -1,
     522,    -1,    -1,   525,   526,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2611,    -1,  3281,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   567,   568,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3320,  3321,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3329,    -1,   591,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2675,    -1,    -1,    -1,  2679,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2723,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3460,    -1,
      -1,    -1,  3464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3495,    -1,    -1,    -1,    -1,    -1,    -1,
    2834,  2835,    -1,    -1,    -1,    -1,    -1,  3509,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2898,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2922,  2923,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2934,  3603,    -1,    -1,    -1,  2939,    -1,    -1,  2942,    -1,
    2944,  2945,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2980,    -1,    -1,    -1,
      -1,    -1,  3654,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3662,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3671,
    3004,  3673,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3707,    -1,    -1,    -1,    -1,
      -1,  3713,  3714,    -1,  3048,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3068,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3077,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3774,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3807,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3839,    -1,  3841,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3851,
      -1,  3853,  3854,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3876,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3937,    -1,  3939,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3281,    -1,    -1,
      -1,    -1,  3954,  3955,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3967,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3976,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3320,  3321,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4019,  4020,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4032,  4033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4049,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4077,    -1,    -1,    -1,    -1,
      -1,    -1,  4084,    -1,    -1,  4087,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4118,    -1,    -1,    -1,
      -1,    -1,    -1,  4125,    -1,  4127,  3460,    -1,    -1,    -1,
    3464,    -1,    -1,    -1,    -1,  4137,    -1,    -1,    -1,  4141,
      -1,    -1,  4144,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4153,    -1,  4155,    -1,  4157,    -1,    -1,    -1,    -1,
      -1,  3495,  4164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4175,    -1,  3509,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3522,  4191,
    4192,    -1,    -1,    -1,    -1,  4197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4207,  4208,    -1,    -1,    -1,
    4212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3662,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3671,    -1,  3673,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3707,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3774,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3807,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3839,    -1,  3841,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3851,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3937,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3955,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3976,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4019,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4084,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
    4144,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    44,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,  4197,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
    4244,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,   245,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,   530,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,   603,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,   609,   610,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,
      -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,
      -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,
      -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,
     151,    -1,    -1,   154,   155,    -1,   157,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,
      -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,
     181,    -1,   183,   184,   185,    -1,   187,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,
      -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,
     211,    -1,    -1,   214,   215,   216,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,
     231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,   240,
      -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,
      -1,   252,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,    -1,   290,
     291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,
     301,   302,   303,   304,   305,   306,    -1,    -1,   309,   310,
      -1,   312,    -1,   314,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,
     331,   332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,
      -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,   350,
      -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   362,   363,   364,    -1,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,   380,
     381,   382,    -1,   384,    -1,   386,   387,   388,   389,   390,
      -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,
     401,   402,   403,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,    -1,   414,   415,    -1,   417,   418,   419,    -1,
      -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,    -1,   445,   446,   447,    -1,    -1,   450,
     451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,
     461,    -1,   463,   464,   465,   466,    -1,   468,   469,   470,
     471,   472,   473,    -1,    -1,    -1,    -1,    -1,   479,   480,
      -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,
      -1,    -1,   493,   494,    -1,   496,   497,   498,   499,   500,
     501,    -1,    -1,   504,   505,   506,   507,    -1,   509,   510,
      -1,    -1,   513,   514,   515,   516,    -1,    -1,   519,   520,
      -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,
     531,   532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,
     541,   542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,
     551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,
      -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,
      -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,
      -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,
     591,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,   184,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,   217,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,   473,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,   447,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
     603,    -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,   603,
      -1,    -1,    -1,    -1,    17,   609,   610,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,   602,
      -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,   227,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,
      -1,     5,   597,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,   610,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,   602,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,   609,   610,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   610,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,
      96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,
     106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,
      -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,    -1,    -1,   164,   165,
     166,    -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,   290,   291,   292,   293,    -1,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,   327,   328,    -1,    -1,   331,   332,   333,   334,    -1,
      -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,    -1,    -1,   504,   505,
     506,   507,    -1,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,    -1,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,
     536,   537,   538,   539,    -1,   541,   542,    -1,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,
     566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   610,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,    -1,   591,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   610,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,
      -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,
      -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,
      -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,    -1,    -1,   164,   165,   166,    -1,
      -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
     198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,    -1,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
      -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,   290,   291,   292,   293,    -1,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,   327,
     328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,
     338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,    -1,    -1,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,    -1,    -1,   504,   505,   506,   507,
      -1,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,
     538,   539,    -1,   541,   542,    -1,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,
      -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   609,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,
     100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,
      -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,
     170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,
     200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,
     250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
     290,   291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,   312,    -1,   314,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,   327,   328,    -1,
      -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,   339,
      -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,    -1,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
      -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,    -1,    -1,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,    -1,    -1,   504,   505,   506,   507,    -1,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,   539,
      -1,   541,   542,    -1,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
      -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   609,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,   609,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    -1,
      74,    -1,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    -1,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,    -1,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,   171,   172,   173,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,   269,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,    -1,    -1,    -1,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,   419,   420,    -1,   422,    -1,
      -1,    -1,   426,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,   442,   443,
      -1,   445,    -1,    -1,    -1,    -1,   450,   451,   452,    -1,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,    -1,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,    -1,   490,    -1,    -1,    -1,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,    -1,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,    -1,    -1,    -1,    -1,   551,    -1,    -1,
     554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,   579,    -1,    -1,    -1,   583,
      -1,    -1,   586,    -1,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
     604,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,   597,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,   597,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,   597,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,   597,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,   175,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,    -1,    -1,   342,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,   475,   476,   477,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,   540,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,   456,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,   342,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,   540,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
     119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    35,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,   163,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,   476,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
     119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
     119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    -1,
      74,    -1,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    -1,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,    -1,   142,   143,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,    -1,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,   171,   172,   173,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,   269,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,    -1,    -1,    -1,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,   419,   420,    -1,   422,    -1,
      -1,    -1,   426,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,   442,   443,
      -1,   445,    -1,    -1,    -1,    -1,   450,   451,   452,    -1,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,    -1,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,    -1,   490,    -1,    -1,    -1,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,    -1,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,    -1,    -1,    -1,    -1,   551,    -1,    -1,
     554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,   579,    -1,    -1,    -1,   583,
      -1,    -1,   586,    -1,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    22,    23,    24,    25,    26,    27,    -1,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    -1,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,    -1,    -1,    -1,   138,
     139,   140,    -1,   142,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,    -1,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,   171,   172,   173,   174,    -1,    -1,    -1,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,   198,
      -1,    -1,    -1,    -1,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,   211,   212,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,   236,    -1,    -1,
     239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
     269,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,    -1,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,    -1,    -1,   367,   368,
     369,    -1,   371,   372,   373,   374,   375,   376,    -1,    -1,
      -1,    -1,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,
     419,   420,    -1,   422,    -1,    -1,    -1,   426,    -1,    -1,
     429,   430,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,   443,    -1,   445,    -1,    -1,    -1,
      -1,   450,   451,   452,    -1,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,    -1,   464,    -1,   466,    -1,   468,
      -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
      -1,   490,    -1,    -1,    -1,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,    -1,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,    -1,    -1,
      -1,    -1,   551,    -1,    -1,   554,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,   577,    -1,
     579,    -1,    -1,    -1,   583,    -1,    -1,   586,    -1,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    -1,
      74,    -1,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    -1,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,    -1,   142,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,    -1,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,   171,   172,   173,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,   269,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,    -1,    -1,    -1,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,   419,   420,    -1,   422,    -1,
      -1,    -1,   426,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,   442,   443,
      -1,   445,    -1,    -1,    -1,    -1,   450,   451,   452,    -1,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,    -1,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,    -1,   490,    -1,    -1,    -1,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,    -1,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,    -1,    -1,    -1,    -1,   551,    -1,    -1,
     554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,   577,    -1,   579,    -1,    -1,    -1,   583,
      -1,    -1,   586,    -1,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    22,    23,    24,    25,    26,    27,    -1,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    -1,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,    -1,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,    -1,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,   171,   172,   173,   174,    -1,    -1,    -1,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,   198,
      -1,    -1,    -1,    -1,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,   211,   212,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,   236,    -1,    -1,
     239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
     269,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,    -1,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,    -1,    -1,   367,   368,
     369,    -1,   371,   372,   373,   374,   375,   376,    -1,    -1,
      -1,    -1,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,
     419,   420,    -1,   422,    -1,    -1,    -1,   426,    -1,    -1,
     429,   430,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,   443,    -1,   445,    -1,    -1,    -1,
      -1,   450,   451,   452,    -1,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,    -1,   464,    -1,   466,    -1,   468,
      -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
      -1,   490,    -1,    -1,    -1,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   5