#!/usr/bin/perl 
#******************************************************************************************
#
# CHECK_PING
#
# Program: PING Plugin for Netsaint written in PERL 
# License: GPL
# Copyright (c) 1999 Gary Berger (berger@marketxt.com)
#
# Last Modified: 11/19/99
#
# Command line: CHECK_PING <ip_address> <warn packet loss> <critical packet loss> <warn round-trip-average> <critical round-trip-average> [packets]
#
# Description:
#
#
# Dependencies:
#
# This plugin uses the 'ping' command included with UNIX . 
#
# License Information:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#*****************************************************************************************/

# Initialzie Variables

$STAUS_OK=0;
$STATUS_WARN=1;
$STATUS_UNKNOWN=-1;
$STATUS_CRIT=2;
$CGIURL="/cgi-bin/netsaint";
$TIMEOUT=15;
$rta=0;
$pl=0;
$PACKETS=5;

$command="/bin/ping -q -w 15 -c ";

# I know sloppy but it works!

while(@ARGV){

	$server_address=shift(@ARGV) if(@ARGV);
	$wpl=shift(@ARGV) if(@ARGV);
	$cpl=shift(@ARGV)  if(@ARGV);
	$wrta=shift(@ARGV)  if(@ARGV);
	$crta=shift(@ARGV)  if(@ARGV);
	$PACKETS=shift(@ARGV) if(@ARGV);

}

$pid=open(PIPE,"$command $PACKETS $server_address|") || die "Can't open PIPE $!\n";


#Test Loop to timeout ping to unreachables

eval {
 local $SIG{ALRM} = sub { die "alarm\n" };
alarm $TIMEOUT;
$buffer=<PIPE>;
 alarm 0;
};

if($@) { 
	printf("<A HREF='%s/mtr.cgi?host=%s\&count=5'>",$CGIURL,$server_address);
	print "Ping problem - Check timed out after $TIMEOUT seconds\n";
 	$result=$STATUS_CRIT;
#	close(PIPE); # seems to hang so ....
	kill 9, $pid;  # brutal but can't wait for close(PIPE)
	die  unless $@ eq "alarm\n"; 

}else{

while(<PIPE>){

#6 packets transmitted, 0 packets received, +1 errors, 100% packet loss
if(/.* (\d+)%\spacket loss/) {
		$pl=$1;
		next;
}
#round-trip min/avg/max = 1.3/1.4/1.7 ms

if(/^round-trip min\/avg\/max \= \d\.\d\/(\d\.\d)\/\d\.\d ms/){
		$rta=$1;
		next;
	}
}

if($pl==100 || $pl>=$cpl || $rta>=$crta){
		$result=$STATUS_CRIT;
	}
elsif ($pl>=$wpl || $rta>=$wrta){
                $result=$STATUS_WARNING;
	}
elsif ($pl<$wpl && $rta<$wrta && $pl>=0 && $rta>=0){
		$result=$STATUS_OK;
	}

  	$status=($result==$STATUS_OK)?"ok":"problem";
        printf("<A HREF='%s/mtr.cgi?host=%s\&count=5'>",$CGIURL,$server_address);
        printf("PING %s - Packet loss = %d%, RTA = %2.2f ms",$status,$pl,$rta);
        print("</A>");

exit $result;
}
exit $result;

sub usage {
	die "Usage: $progname  <host_address> <wpl> <cpl> <wrta> <crta> [packets]\n";
}


