# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200501-24.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(16415);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200501-24");
 script_cve_id("CAN-2004-1294");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200501-24
(tnftp: Arbitrary file overwriting)


    The \'mget\' function in cmds.c lacks validation of the filenames
    that are supplied by the server.
  
Impact

    An attacker running an FTP server could supply clients with
    malicious filenames, potentially allowing the overwriting of arbitrary
    files with the permission of the connected user.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2004-1294
    http://tigger.uic.edu/~jlongs2/holes/tnftp.txt


Solution: 
    All tnftp users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-ftp/tnftp-20050103"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200501-24] tnftp: Arbitrary file overwriting");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'tnftp: Arbitrary file overwriting');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-ftp/tnftp", unaffected: make_list("ge 20050103"), vulnerable: make_list("lt 20050103")
)) { security_warning(0); exit(0); }
