#TRUSTED 03f5b2910320f95bf19b3290ac042ce0e4e4948167d39fb81f4e8ab05ef805a6cec07806573a216a862f56cd880f23c5b1ce6d494029841d7721764c861649064a63614ae9f8fc9f4c1db7c1daeba7f055d32095e31b09948a94d86eac37f6ca312d9d04a476c22a98a8c48ee085f67121337d27b4525306656944ef845be91dd390bea52cf0913102ef4feb25997d5bd4110339941512ba06a3cc7d698dae1f5d629426d76dc06299b5b712157b96b8fba1254b20bb72377d26d99c68e8e00c18acdd4b839c34d8cfabb38f0f0621abc94a6f2b7766a6692f06015da4442945ee140e906a3a9b48d16a6ca9d71e1e1cb23ae311875e94f2c1057514f26bde7db2bbc5c0b9694fa70a6ed54577eb1803244f96cb15e0cb699f237bfaecdcac0501357703d752dc648a56cdfecad341ec0c1ef8d68ecd280e446eeb015f6dfca792feb0998d10c5710880373a142515fd4191735759b1d10cf741cc84467c16b21ccedae19eaa5e2323279e514555a2e7e9ff6405824e35751ffbfede639fdd91b400995ca50f9b0b566fc8861c87102c3875a335ebf10077fcb8a4f3b263ef26981e8f50b3d7ba397ee99b9b217a9e99f3472bf97d8a705138ec51f7c1551b22351195d6cd701ad88997b77b1f68d60dc0259691fad49f77d0e672e0d2f57ac9cc8195e7ffced794b1ca3a7c4bd878494b3ca8a8e336d5aeddf2a21ee72a6668
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15871);
 script_version ("1.2");
 name["english"] = "Hydra: CVS";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find CVS accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force CVS authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/cvspserver", 2401);
 script_dependencies("hydra_options.nasl", "find_service.nes", "cvs_detect.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/cvspserver");
if (! port) port = 2401;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cvs";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/cvs/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following CVS accounts:\n' + report);
