#TRUSTED 0e2897fe9f8f13e796206219a95c6a4558f8adacc55a2d2d8d053ab09ba60056aadd7a4a6a1830198337a3b2a3f3fa5a362dfbf38a1060dc588db63510be52c98bd41ea49fa0dcb7a5b56d55606142f86ad9581aae4973a352fa9c0ee45493b51bfc0af9571b7be3a1043ac342b4eea8fae5ee69ab3e28690a3cd899121f8a7f4fe66e66bcb2a021d4b5d3b6a12b95adfca6d31839292d00a99cc5b9cc5d4488eef125eb3f6f11161bc19c6c7d4c1b466dcd48f9fa6d43236c062f4b49274fec93865c5b4a20aeeed54ab6a15fe3402dd3f4daa53e86b5b660cb49baf8c0c13e35ae65ffcf9ba26e48cf8ed53fedcb9049743f996ed9fbfc79026e7c5f42221c12a6752704e1558bc26101baf16cff822255973508250c7f8ee78ba5cdcd8c82056f799111f8f78ee354043cd2671ace075137fc4f7b56ae096999330c97d88912e90acb4ba6980f14d7685565e11d3b01f4f99f8afae1525f77abfd8a8e0a9fcc4a85d3bb2a11ac7ab45cb6e610a6bbe068ed5a6c2b1554ba322efa8b6b81c580e48bbc73be546aa533eb045a25df18b89566ef0234dd54c96d663aad43a0035816b7cbfd04912b7427b8dc38e669d927a2136541f50e20bd6d252b3fd4228d997b50229b746888b475b094925d2ed370e90040178b6daaaaa6c4d21a8e289a62b5ce0a8bd0a91820b2fc14f469ce863129bc91a8cc9b824e0c1e0a72359685
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("script_get_preference_file_location")) exit(0);
if ( ! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15884);
 script_version ("1.2");
 name["english"] = "Hydra: SMB";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SMB accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SMB authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DESTRUCTIVE_ATTACK); # Because of accounts autolock
 
 script_add_preference(name: "Check local / domain accounts", 
	value: "Local accounts; Domain Accounts; Either", type: "radio");
 script_add_preference(name: "Interpret passwords as NTLM hashes", 
	value: "no", type: "checkbox");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports(139,445);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("SMB/transport"); port = int(port);
if (! port) port = 445;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "smbnt";	# what's "smb"?

opt = "";
p = script_get_preference("Check local / domain accounts");
if ("Local" >< p) opt = "L";
else if ("Domain" >< p) opt = "D";
else opt = "B";

p = script_get_preference("Interpret passwords as NTLM hashes");
if ("yes" >< p) opt += "H";
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SMB accounts:\n' + report);
