/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.net.Socket;
import java.net.SocketException;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.DefaultChannelConfig;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.jboss.netty.util.internal.ConversionUtil;

final class HttpTunnelingSocketChannelConfig
extends DefaultChannelConfig
implements SocketChannelConfig {
    final Socket socket;
    private Integer trafficClass;
    private Boolean tcpNoDelay;
    private Integer soLinger;
    private Integer sendBufferSize;
    private Boolean reuseAddress;
    private Integer receiveBufferSize;
    private Integer connectionTime;
    private Integer latency;
    private Integer bandwidth;
    private Boolean keepAlive;

    HttpTunnelingSocketChannelConfig(Socket socket) {
        this.socket = socket;
    }

    public boolean setOption(String key, Object value) {
        if (key.equals("receiveBufferSize")) {
            this.setReceiveBufferSize(ConversionUtil.toInt(value));
        } else if (key.equals("sendBufferSize")) {
            this.setSendBufferSize(ConversionUtil.toInt(value));
        } else if (key.equals("tcpNoDelay")) {
            this.setTcpNoDelay(ConversionUtil.toBoolean(value));
        } else if (key.equals("keepAlive")) {
            this.setKeepAlive(ConversionUtil.toBoolean(value));
        } else if (key.equals("reuseAddress")) {
            this.setReuseAddress(ConversionUtil.toBoolean(value));
        } else if (key.equals("soLinger")) {
            this.setSoLinger(ConversionUtil.toInt(value));
        } else if (key.equals("trafficClass")) {
            this.setTrafficClass(ConversionUtil.toInt(value));
        } else {
            return false;
        }
        return true;
    }

    public int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getSoLinger() {
        try {
            return this.socket.getSoLinger();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isKeepAlive() {
        try {
            return this.socket.getKeepAlive();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isReuseAddress() {
        try {
            return this.socket.getReuseAddress();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public boolean isTcpNoDelay() {
        try {
            return this.socket.getTcpNoDelay();
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        try {
            this.socket.setKeepAlive(keepAlive);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.connectionTime = connectionTime;
        this.latency = latency;
        this.bandwidth = bandwidth;
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        if (this.socket != null) {
            try {
                this.socket.setSendBufferSize(sendBufferSize);
            }
            catch (SocketException e) {
                throw new ChannelException(e);
            }
        }
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
        try {
            if (soLinger < 0) {
                this.socket.setSoLinger(false, 0);
            } else {
                this.socket.setSoLinger(true, soLinger);
            }
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        try {
            this.socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (SocketException e) {
            throw new ChannelException(e);
        }
    }

    HttpTunnelingSocketChannelConfig copyConfig(Socket socket) {
        HttpTunnelingSocketChannelConfig config = new HttpTunnelingSocketChannelConfig(socket);
        config.setConnectTimeoutMillis(this.getConnectTimeoutMillis());
        if (this.trafficClass != null) {
            config.setTrafficClass(this.trafficClass);
        }
        if (this.tcpNoDelay != null) {
            config.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.soLinger != null) {
            config.setSoLinger(this.soLinger);
        }
        if (this.sendBufferSize != null) {
            config.setSendBufferSize(this.sendBufferSize);
        }
        if (this.reuseAddress != null) {
            config.setReuseAddress(this.reuseAddress);
        }
        if (this.receiveBufferSize != null) {
            config.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.keepAlive != null) {
            config.setKeepAlive(this.keepAlive);
        }
        if (this.connectionTime != null) {
            config.setPerformancePreferences(this.connectionTime, this.latency, this.bandwidth);
        }
        return config;
    }
}

