/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.xnio.BaseXnioChannel;
import org.jboss.netty.channel.xnio.XnioChannelRegistry;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.MultipointReadResult;
import org.jboss.xnio.channels.MultipointReadableMessageChannel;
import org.jboss.xnio.channels.MultipointWritableMessageChannel;
import org.jboss.xnio.channels.ReadableMessageChannel;
import org.jboss.xnio.channels.SuspendableReadChannel;
import org.jboss.xnio.channels.SuspendableWriteChannel;
import org.jboss.xnio.channels.WritableMessageChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractXnioChannelHandler
implements IoHandler<Channel> {
    protected AbstractXnioChannelHandler() {
    }

    public void handleReadable(Channel channel) {
        BaseXnioChannel c = XnioChannelRegistry.getChannel(channel);
        boolean closed = false;
        ReceiveBufferSizePredictor predictor = c.getConfig().getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = c.getConfig().getBufferFactory();
        ChannelBuffer buf = bufferFactory.getBuffer(predictor.nextReceiveBufferSize());
        SocketAddress remoteAddress = null;
        IOException exception = null;
        if (channel instanceof ScatteringByteChannel) {
            try {
                int readBytes;
                while (buf.writable() && (readBytes = buf.writeBytes((ScatteringByteChannel)channel, buf.writableBytes())) != 0) {
                    if (readBytes >= 0) continue;
                    closed = true;
                }
            }
            catch (IOException e) {
                exception = e;
                closed = true;
            }
        } else if (channel instanceof MultipointReadableMessageChannel) {
            ByteBuffer nioBuf = buf.toByteBuffer();
            try {
                MultipointReadResult res = ((MultipointReadableMessageChannel)channel).receive(nioBuf);
                if (res != null) {
                    buf = ChannelBuffers.wrappedBuffer(nioBuf);
                    remoteAddress = (SocketAddress)res.getSourceAddress();
                }
            }
            catch (IOException e) {
                exception = e;
                closed = true;
            }
        } else if (channel instanceof ReadableMessageChannel) {
            ByteBuffer nioBuf = buf.toByteBuffer();
            try {
                int readBytes = ((ReadableMessageChannel)channel).receive(nioBuf);
                if (readBytes > 0) {
                    buf = ChannelBuffers.wrappedBuffer(nioBuf);
                } else if (readBytes < 0) {
                    closed = true;
                }
            }
            catch (IOException e) {
                exception = e;
                closed = true;
            }
        }
        if (buf.readable()) {
            predictor.previousReceiveBufferSize(buf.readableBytes());
            Channels.fireMessageReceived(c, (Object)buf, remoteAddress);
        }
        if (exception != null) {
            Channels.fireExceptionCaught(c, (Throwable)exception);
        }
        if (closed) {
            this.close(c);
        } else {
            this.resumeRead(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWritable(Channel channel) {
        BaseXnioChannel c = XnioChannelRegistry.getChannel(channel);
        int writtenBytes = 0;
        boolean open = true;
        boolean addOpWrite = false;
        Queue<MessageEvent> writeBuffer = c.writeBuffer;
        Object object = c.writeLock;
        synchronized (object) {
            MessageEvent evt = c.currentWriteEvent;
            while (true) {
                int bufIdx;
                ChannelBuffer buf;
                if (evt == null) {
                    evt = writeBuffer.poll();
                    if (evt == null) {
                        c.currentWriteEvent = null;
                        break;
                    }
                    buf = (ChannelBuffer)evt.getMessage();
                    bufIdx = buf.readerIndex();
                } else {
                    buf = (ChannelBuffer)evt.getMessage();
                    bufIdx = c.currentWriteIndex;
                }
                try {
                    int writeSpinCount = c.getConfig().getWriteSpinCount();
                    boolean sent = false;
                    for (int i = writeSpinCount; i > 0; --i) {
                        int nioBufSize;
                        if (channel instanceof GatheringByteChannel) {
                            int localWrittenBytes = buf.getBytes(bufIdx, (GatheringByteChannel)channel, buf.writerIndex() - bufIdx);
                            if (localWrittenBytes == 0) continue;
                            bufIdx += localWrittenBytes;
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (channel instanceof MultipointWritableMessageChannel) {
                            ByteBuffer nioBuf = buf.toByteBuffer(bufIdx, buf.writerIndex() - bufIdx);
                            nioBufSize = nioBuf.remaining();
                            SocketAddress remoteAddress = evt.getRemoteAddress();
                            if (remoteAddress == null) {
                                remoteAddress = c.getRemoteAddress();
                            }
                            if (!(sent = ((MultipointWritableMessageChannel)channel).send((Object)remoteAddress, nioBuf))) continue;
                            bufIdx += nioBufSize;
                            writtenBytes += nioBufSize;
                            break;
                        }
                        if (channel instanceof WritableMessageChannel) {
                            ByteBuffer nioBuf = buf.toByteBuffer(bufIdx, buf.writerIndex() - bufIdx);
                            nioBufSize = nioBuf.remaining();
                            sent = ((WritableMessageChannel)channel).send(nioBuf);
                            if (!sent) continue;
                            bufIdx += nioBufSize;
                            writtenBytes += nioBufSize;
                            break;
                        }
                        throw new IllegalArgumentException("Unsupported channel type: " + channel.getClass().getName());
                    }
                    if (bufIdx == buf.writerIndex() || sent) {
                        evt.getFuture().setSuccess();
                        evt = null;
                        continue;
                    }
                    c.currentWriteEvent = evt;
                    c.currentWriteIndex = bufIdx;
                    addOpWrite = true;
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    evt.getFuture().setFailure(t);
                    evt = null;
                    Channels.fireExceptionCaught(c, t);
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    c.closeNow(Channels.succeededFuture(c));
                    continue;
                }
                break;
            }
        }
        if (writtenBytes > 0) {
            Channels.fireWriteComplete(c, writtenBytes);
        }
        if (open && addOpWrite && channel instanceof SuspendableWriteChannel) {
            ((SuspendableWriteChannel)channel).resumeWrites();
        }
    }

    public void handleClosed(Channel channel) {
        this.close(XnioChannelRegistry.getChannel(channel));
    }

    protected void resumeRead(Channel channel) {
        if (channel instanceof SuspendableReadChannel) {
            ((SuspendableReadChannel)channel).resumeReads();
        }
    }

    protected void close(BaseXnioChannel c) {
        if (c != null) {
            c.closeNow(c.getCloseFuture());
        }
    }
}

