/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;

@ChannelPipelineCoverage(value="one")
public class HttpChunkAggregator
extends SimpleChannelUpstreamHandler {
    private final int maxContentLength;
    private volatile HttpMessage currentMessage;

    public HttpChunkAggregator(int maxContentLength) {
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpChunk)) {
            ctx.sendUpstream(e);
            return;
        }
        HttpMessage currentMessage = this.currentMessage;
        if (currentMessage == null) {
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                List<String> encodings = m.getHeaders("Transfer-Encoding");
                encodings.remove("chunked");
                if (encodings.isEmpty()) {
                    m.removeHeader("Transfer-Encoding");
                }
                m.setContent(ChannelBuffers.dynamicBuffer(e.getChannel().getConfig().getBufferFactory()));
                this.currentMessage = m;
            } else {
                ctx.sendUpstream(e);
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            ChannelBuffer content = currentMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - chunk.getContent().readableBytes()) {
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            content.writeBytes(chunk.getContent());
            if (chunk.isLast()) {
                this.currentMessage = null;
                currentMessage.setHeader("Content-Length", String.valueOf(content.readableBytes()));
                Channels.fireMessageReceived(ctx, (Object)currentMessage, e.getRemoteAddress());
            }
        }
    }
}

