import atexit, pickle

from nevow import rend, loaders, tags, livepage, inevow
from nevow.livepage import document

class node:
    def __init__(self, question, positive=None, negative=None):
        self.question = question
        self.positive = positive
        self.negative = negative

    def clone(self):
        return self.__class__(**vars(self))

    def isLeaf(self):
        return not (self.positive or self.negative)

win = 'winnar'
lose = lambda: node("I give up. What is the animal, and what question describes it?")

def guess(animal):
    return node("Is it " + animal + "?", win, lose())

try:
    knowledge = pickle.load(file('knowledge', 'rb'))
except:
    knowledge = lose()
atexit.register(lambda: pickle.dump(knowledge, file('knowledge', 'wb')))


def renderAnswerInputs(ctx, client):
    if client.node.isLeaf():
        return ctx.tag[inevow.IQ(ctx).onePattern('leaf')]
    return ctx.tag[inevow.IQ(ctx).onePattern('branch')]


byId = document.getElementById


def newquestion(client, animal, question):
    newNegative = client.oldNode.clone()

    client.oldNode.question = question
    client.oldNode.positive = guess(animal)
    client.oldNode.negative = newNegative

    client.node = knowledge
    updateDom(client)
newquestion = livepage.handler(newquestion,
    byId('animal').value, byId('new-question').value)



def updateDom(client):
    client.set('question', client.node.question)
    if client.node.isLeaf():
        client.set('answer-inputs', inevow.IQ(AnimalPage.docFactory).onePattern('leaf'))
    else:
        client.set('answer-inputs', inevow.IQ(AnimalPage.docFactory).onePattern('branch'))


startOver = livepage.handler(updateDom)


def positiveResponse(client):
    client.oldNode = client.node
    client.node = client.node.positive
    if client.node == win:
        client.node = knowledge
        client.set('question', "I win!")
        client.set('answer-inputs', tags.button(id="start-over", onclick=startOver)["Start over"])
    else:
        updateDom(client)
positiveResponse = livepage.handler(positiveResponse)


def negativeResponse(client):
    client.oldNode = client.node
    client.node = client.node.negative
    updateDom(client)
negativeResponse = livepage.handler(negativeResponse)


class AnimalPage(livepage.LivePage):
    addSlash = True
    def goingLive(self, ctx, client):
        if ctx.arg('fresh') is not None:
            global knowledge
            knowledge = lose()
        client.oldNode = knowledge
        client.node = knowledge
        self.original = client

    docFactory = loaders.stan(
        tags.html[
            tags.head[
                tags.directive('liveid'),
                tags.directive('liveglue')],
            tags.body[
                tags.h1["Live Animal"],
                tags.div(id='question')[lambda c, d: d.node.question],
                tags.div(id='answer-inputs', render=renderAnswerInputs)[
                    tags.form(name='new-question', pattern="leaf", onsubmit=newquestion)[
                        tags.input(name='animal', id='animal'), tags.input(name='new-question', id='new-question'), tags.button['Submit']],
                    tags.invisible(pattern='branch')[
                        tags.button(id="yes-response", onclick=positiveResponse)['Yes'], tags.button(id="no-response", onclick=negativeResponse)['No']]]]])


def createResource():
    return AnimalPage()



